<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/BalanceVI"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="BalanceVI"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Calibri;
  panose-1:2 15 5 2 2 2 4 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR"><div id="header">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="margin-bottom:0cm;margin-bottom:.0001pt;line-height: normal;punctuation-wrap:simple"><span style="font-size:10.0pt;font-family: &#34;Arial&#34;,sans-serif">
                        <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/> – 
                        
                        
                        <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="margin-bottom:0cm;margin-bottom:.0001pt; text-align:right;line-height:normal;punctuation-wrap:simple"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif">Date édition : 
                        
                        
                        <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateEdition)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Edition/@TypeEdition = 'P'"><xsl:variable name="varOdm1" select="$docbudg/Budget/LigneBalanceVI"/><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1">
                  <p class="MsoNormal" align="right" style="margin-left:-366.5pt;text-align:right; punctuation-wrap:simple"><xsl:variable name ="Refer85">BALVALIN</xsl:variable><xsl:variable name ="Refer86" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Refer87" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer85, '_', $Refer86, '_', $Refer87)"/></xsl:call-template>Édition provisoire
                     
                     
                  </p>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Edition/@TypeEdition = 'D'"><xsl:variable name="varOdm2" select="$docbudg/Budget/LigneBalanceVI"/><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1">
                  <p class="MsoNormal" align="right" style="margin-left:-366.5pt;text-align:right; punctuation-wrap:simple">Édition définitive</p>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" colspan="2" valign="top" rowspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center;punctuation-wrap: simple"><b><span style="font-size:12.0pt">BALANCE DES VALEURS INACTIVES</span></b></p>
               </td></tr><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p align="center" style="text-align:center;punctuation-wrap: simple">arrêtée à la date du <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateArrete)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></p></td></tr><tr><td width="49%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="51%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td></tr><tr><td width="49%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="51%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td></tr><tr><td width="49%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@CodeBC)"/> – <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@Libelle)"/></p></td><td width="51%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right;punctuation-wrap:simple"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></p></td></tr><xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Collectivite/@TypeBC = 'BA' or $docbudg/BalanceVI/EnteteComptable/Infos/Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm3" select="$docbudg/Budget/LigneBalanceVI"/><tr><td width="100%" colspan="2" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p style="punctuation-wrap:simple">BA de <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetRattachement/@Libelle)"/>
                     
                     
                  </p></td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="49%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td><td height="1px" width="51%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><tr><td width="100%" colspan="2" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1"> </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoNormalTable BORDURE" border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm4" select="$docbudg/Budget/LigneBalanceVI[(./NumOrdre/@V)]"/><thead>
               <tr><xsl:variable name="varOdm5" select="$varOdm4"/><xsl:variable name="content365">
                     <p class="Contenudetableau"><span><b>DÉSIGNATION DES COMPTES</b></span></p>
                     <p class="Contenudetableau"><b><span>No</span></b></p>
                     <p class="Contenudetableau"><b><span>Intitulé</span></b></p>
                     <p class="Contenudetableau"><b><span>Nature des valeurs inactives</span></b></p>
                  </xsl:variable><xsl:variable name="className699">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className699" /><xsl:with-param name="rowspan">2</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">20%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content365" /></xsl:call-template><xsl:variable name="content366">
                     <p class="Contenudetableau"><b><span>DÉBIT</span></b></p>
                  </xsl:variable><xsl:variable name="className700">VBORDER</xsl:variable><xsl:variable name="className701">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className700, ' ', $className701)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">3</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content366" /></xsl:call-template><xsl:variable name="content367">
                     <p class="Contenudetableau"><b><span>CRÉDIT</span></b></p>
                  </xsl:variable><xsl:variable name="className702">VBORDER</xsl:variable><xsl:variable name="className703">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className702, ' ', $className703)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">3</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content367" /></xsl:call-template><xsl:variable name="content368">
                     <p class="Contenudetableau"><b><span>SOLDES</span></b></p>
                  </xsl:variable><xsl:variable name="className704">VBORDER</xsl:variable><xsl:variable name="className705">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className704, ' ', $className705)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">2</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content368" /></xsl:call-template></tr>
               <tr><xsl:variable name="varOdm6" select="$varOdm4"/><xsl:variable name="content369">
                     <p class="Contenudetableau"><b><span>Balance<br clear="none" />
                              d’entrée</span></b></p>
                  </xsl:variable><xsl:variable name="className706">VBORDER</xsl:variable><xsl:variable name="className707">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className706, ' ', $className707)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content369" /></xsl:call-template><xsl:variable name="content370">
                     <p class="Contenudetableau"><b><span>Année<br clear="none" />
                              n cours</span></b></p>
                  </xsl:variable><xsl:variable name="className708">VBORDER</xsl:variable><xsl:variable name="className709">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className708, ' ', $className709)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content370" /></xsl:call-template><xsl:variable name="content371">
                     <p class="Contenudetableau"><b><span>TOTAL</span></b></p>
                  </xsl:variable><xsl:variable name="className710">VBORDER</xsl:variable><xsl:variable name="className711">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className710, ' ', $className711)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content371" /></xsl:call-template><xsl:variable name="content372">
                     <p class="Contenudetableau"><b><span>Balance</span></b></p>
                     <p class="Contenudetableau"><b><span>d’entrée</span></b></p>
                  </xsl:variable><xsl:variable name="className712">VBORDER</xsl:variable><xsl:variable name="className713">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className712, ' ', $className713)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content372" /></xsl:call-template><xsl:variable name="content373">
                     <p class="Contenudetableau"><b><span>Année<br clear="none" />
                              n cours</span></b></p>
                  </xsl:variable><xsl:variable name="className714">VBORDER</xsl:variable><xsl:variable name="className715">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className714, ' ', $className715)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content373" /></xsl:call-template><xsl:variable name="content374">
                     <p class="Contenudetableau"><b><span>TOTAL</span></b></p>
                  </xsl:variable><xsl:variable name="className716">VBORDER</xsl:variable><xsl:variable name="className717">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className716, ' ', $className717)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content374" /></xsl:call-template><xsl:variable name="content375">
                     <p class="Contenudetableau"><b><span>Débiteurs</span></b></p>
                  </xsl:variable><xsl:variable name="className718">VBORDER</xsl:variable><xsl:variable name="className719">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className718, ' ', $className719)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content375" /></xsl:call-template><xsl:variable name="content376">
                     <p class="Contenudetableau"><b><span>Créditeurs</span></b></p>
                  </xsl:variable><xsl:variable name="className720">VBORDER</xsl:variable><xsl:variable name="className721">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className720, ' ', $className721)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content376" /></xsl:call-template></tr>
            </thead><xsl:variable name="varOdm7" select="$varOdm4"/><xsl:variable name="varOdm8"><xsl:for-each select="$varOdm7"><xsl:sort select="./NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content377"> <xsl:value-of select="distinct-values($ligne/NumCompte/@V)"/> <xsl:if test="$ligne/NumCompte/@V != ''">-</xsl:if> <xsl:value-of select="distinct-values($ligne/LibelleCompte/@V)"/></xsl:variable><xsl:variable name="className722" select="$ligne/Format/@V"/><xsl:variable name="className723">LIBELLE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className722, ' ', $className723)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">20%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content377" /></xsl:call-template><xsl:variable name="content378"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtBalEntreeDeb/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className724" select="$ligne/Format/@V"/><xsl:variable name="className725">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className724, ' ', $className725)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content378" /></xsl:call-template><xsl:variable name="content379"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtAnneeCourDeb/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className726" select="$ligne/Format/@V"/><xsl:variable name="className727">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className726, ' ', $className727)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content379" /></xsl:call-template><xsl:variable name="content380"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtTotDeb/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className728" select="$ligne/Format/@V"/><xsl:variable name="className729">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className728, ' ', $className729)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content380" /></xsl:call-template><xsl:variable name="content381"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtBalEntreeCre/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className730" select="$ligne/Format/@V"/><xsl:variable name="className731">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className730, ' ', $className731)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content381" /></xsl:call-template><xsl:variable name="content382"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtAnneeCourCre/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className732" select="$ligne/Format/@V"/><xsl:variable name="className733">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className732, ' ', $className733)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content382" /></xsl:call-template><xsl:variable name="content383"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtTotCre/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className734" select="$ligne/Format/@V"/><xsl:variable name="className735">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className734, ' ', $className735)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content383" /></xsl:call-template><xsl:variable name="content384"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtSoldeDeb/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className736" select="$ligne/Format/@V"/><xsl:variable name="className737">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className736, ' ', $className737)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content384" /></xsl:call-template><xsl:variable name="content385"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/MtSoldeCre/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className738" select="$ligne/Format/@V"/><xsl:variable name="className739">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className738, ' ', $className739)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">10%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content385" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm9"><xsl:choose><xsl:when test="count($varOdm8/*) = 0"><tr class=" #tech#"><td height="1px" width="10%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="10%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="10%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="10%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="10%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="10%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="10%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="10%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm8"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm9/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
         <xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><xsl:variable name="varOdm10" select="$docbudg/Budget/LigneBalanceVI"/><td width="100%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal" style="punctuation-wrap:simple"><xsl:if test="not($varOdm10/NumOrdre/@V)">Cet état ne contient pas d'information.</xsl:if></p>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt"> </span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
        </script>
</html></xsl:template></xsl:stylesheet>