<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="p_32983_nature"></xsl:param><xsl:param name="p_32984_nature"></xsl:param><xsl:param name="p_32985_nature"></xsl:param><xsl:param name="p_32986_nature"></xsl:param><xsl:param name="p_32988_nature"></xsl:param><xsl:param name="p_32989_nature"></xsl:param><xsl:param name="p_32990_nature"></xsl:param><xsl:param name="p_32991_nature"></xsl:param><xsl:param name="p_32992_nature"></xsl:param><xsl:param name="p_32993_nature"></xsl:param><xsl:param name="p_32994_nature"></xsl:param><xsl:param name="p_33006_nature"></xsl:param><xsl:param name="p_33008_nature"></xsl:param><xsl:param name="p_33009_nature"></xsl:param><xsl:param name="p_33010_nature"></xsl:param><xsl:param name="p_33011_nature"></xsl:param><xsl:param name="p_33012_nature"></xsl:param><xsl:param name="p_33013_nature"></xsl:param><xsl:param name="p_33014_nature"></xsl:param><xsl:param name="p_33015_nature"></xsl:param><xsl:param name="p_33016_nature"></xsl:param><xsl:param name="p_33017_nature"></xsl:param><xsl:param name="p_33018_nature"></xsl:param><xsl:param name="p_33019_nature"></xsl:param><xsl:param name="p_33020_nature"></xsl:param><xsl:param name="p_33021_nature"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="dcfu:CompteFinancierUnique"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.MsoFootnoteText, li.MsoFootnoteText, div.MsoFootnoteText
  {
  margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
span.MsoFootnoteReference
  {vertical-align:super;}
a:link, span.MsoHyperlink
  {color:blue;
  text-decoration:underline;}
a:visited, span.MsoHyperlinkFollowed
  {color:purple;
  text-decoration:underline;}
span.NotedebasdepageCar
  {
  
  font-family:"Times New Roman",serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
span.Caractresdenotedebasdepage
  {}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR" link="blue" vlink="purple"><div id="header">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple">
                     <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@CodeBC)"/> – 
                     
                     
                     <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/>
                  </p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right;punctuation-wrap:simple">Exercice 
                     
                     
                     <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V)"/>
                  </p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$HTML_OUTPUT_FORMAT"><xsl:variable name="varOdm1" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr><td width="100%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal"><span style="font-size:8.0pt"></span></p>
                  <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="center" style="text-align:center;punctuation-wrap: simple">POSTE COMPTABLE : <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Tresorerie/@Codique)"/> <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Tresorerie/@LibellePoste)"/><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:BudgetRattachement/@Libelle)"/></p></td></tr><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="center" style="text-align:center"><b><span style="font-size:14.0pt"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/></span></b></p></td></tr><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BA' or $docbudg/dcfu:CompteFinancierUnique/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm2" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="center" style="text-align:center;punctuation-wrap: simple">RELATIF AU BUDGET PRINCIPAL DE <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:BudgetRattachement/@Libelle)"/>
                              
                              
                           </p></td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="center" style="text-align:center;punctuation-wrap: simple"> </p><p align="center" style="text-align:center;punctuation-wrap: simple"><b>NOMENCLATURE : <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Nomenclature/@V)"/></b></p></td></tr><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="center" style="text-align:center;punctuation-wrap: simple"> </p><p align="center" style="text-align:center;punctuation-wrap: simple"><b>SIRET : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:with-param name="format" select="&quot;#0&quot;"/></xsl:call-template></b></p></td></tr><tr><xsl:variable name="varOdm3" select="$varOdm1"/><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center;punctuation-wrap: simple">
                              
                              
                           </p>
                        </td></tr><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:NatFonc/@V = '1' or $docbudg/dcfu:CompteFinancierUnique/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:NatFonc/@V = '3'"><xsl:variable name="varOdm4" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b> Voté par Nature</b></p>
                        </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:NatFonc/@V = '2'"><xsl:variable name="varOdm5" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"><b> Voté par Fonction</b></p>
                        </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BP'"><xsl:variable name="varOdm6" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center"> BUDGET PRINCIPAL</p>
                        </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BA' or $docbudg/dcfu:CompteFinancierUnique/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BR'"><xsl:variable name="varOdm7" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="center" style="text-align:center">BUDGET ANNEXE</p>
                        </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" align="center" style="text-align:center"><b> </b></p>
         <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:14.0pt">Sommaire</span></b></p>
         <p class="MsoNormal"><span style="font-size:14.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$HTML_OUTPUT_FORMAT"><xsl:variable name="varOdm8" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                  <p class="MsoNormal"><b><span style="font-size:8.0pt"></span></b></p>
                  <p class="MsoNormal" style="margin-top:0cm;margin-right:255.1pt;margin-bottom: 0cm;margin-left:255.1pt;margin-bottom:.0001pt"><a href="#CFU" shape="rect"><span style="font-size:8.0pt">Le Compte Financier Unique</span></a></p>
                  <p class="MsoNormal" style="margin-top:0cm;margin-right:255.1pt;margin-bottom: 0cm;margin-left:255.1pt;margin-bottom:.0001pt"><a href="#BEC" shape="rect"><span style="font-size:8.0pt">Balance et autres états comptables</span></a></p>
                  <p class="MsoNormal" style="margin-top:0cm;margin-right:255.1pt;margin-bottom: 0cm;margin-left:255.1pt;margin-bottom:.0001pt"><a href="#DB" shape="rect"><span style="font-size:8.0pt">Liens vers les Documents Budgétaires</span></a></p>
                  <p class="MsoNormal" style="margin-top:0cm;margin-right:255.1pt;margin-bottom: 0cm;margin-left:255.1pt;margin-bottom:.0001pt"><a href="#ADD" shape="rect"><span style="font-size:8.0pt">Autres documents dématérialisés</span></a></p>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:12.0pt"><xsl:variable name ="Refer94">CFU</xsl:variable><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="$Refer94"/></xsl:call-template></span><span style="font-size:14.0pt">Le Compte Financier Unique</span></p>
         <p class="MsoNormal" align="center" style="text-align:center"> </p>
         <xsl:variable name="varOdmTmpTab5"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$HTML_OUTPUT_FORMAT"><xsl:variable name="varOdm9" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt"></span></b></p>
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt"> </span></b></p>
                  <xsl:variable name="varOdmTmpTab6"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><xsl:variable name="varOdm10" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="55%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="35%" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:variable name ="Link1">Page de signatures</xsl:variable><xsl:variable name ="Link2">AARRESIG</xsl:variable><xsl:variable name ="Link3" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link4" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link2, $Link3, $Link4)"/><xsl:value-of select="$Link1" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td></tr><tr><xsl:variable name="varOdm11" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="55%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="35%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:variable name ="Link5">ECCF</xsl:variable><xsl:variable name ="Link6">ETACTRLCPTFIN</xsl:variable><xsl:variable name ="Link7" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link8" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link6, $Link7, $Link8)"/><xsl:value-of select="$Link5" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab6"></xsl:with-param></xsl:call-template>
                  <xsl:variable name="varOdmTmpTab7"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><thead>
                        <tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                              <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">Origine des données</span></p>
                           </td></tr>
                     </thead><tr><td width="10%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">I. Informations générales et synthétiques</span></b></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm12" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link9">Informations statistiques, fiscales et financières</xsl:variable><xsl:variable name ="Link10">AINFOSTATFISCFIN</xsl:variable><xsl:variable name ="Link11" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link12" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link10, $Link11, $Link12)"/><xsl:value-of select="$Link9" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm13" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link13">Présentation générale du compte financier - Vue d'ensemble</xsl:variable><xsl:variable name ="Link14">B1PRESCPTFIN</xsl:variable><xsl:variable name ="Link15" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link16" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link14, $Link15, $Link16)"/><xsl:value-of select="$Link13" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm14" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link17">Détermination du résultat cumulé à la fin de l'exercice</xsl:variable><xsl:variable name ="Link18">BRESCUMUL</xsl:variable><xsl:variable name ="Link19" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link20" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link18, $Link19, $Link20)"/><xsl:value-of select="$Link17" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm15" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">B3.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link21">Liste des organismes de regroupement</xsl:variable><xsl:variable name ="Link22">B31ORGAREGROUP</xsl:variable><xsl:variable name ="Link23" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link24" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link22, $Link23, $Link24)"/><xsl:value-of select="$Link21" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm16" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">B3.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link25">Liste des établissements publics créés</xsl:variable><xsl:variable name ="Link26">B32ETAPUB</xsl:variable><xsl:variable name ="Link27" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link28" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link26, $Link27, $Link28)"/><xsl:value-of select="$Link25" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm17" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">B3.3</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link29">Liste des services individualisés dans un budget annexe</xsl:variable><xsl:variable name ="Link30">B33SERVINDIV</xsl:variable><xsl:variable name ="Link31" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link32" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link30, $Link31, $Link32)"/><xsl:value-of select="$Link29" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm18" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link33">Détail des restes à réaliser - Dépenses</xsl:variable><xsl:variable name ="Link34">C1RESTREALDEP</xsl:variable><xsl:variable name ="Link35" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link36" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link34, $Link35, $Link36)"/><xsl:value-of select="$Link33" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm19" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link37">Détail des restes à réaliser - Recettes</xsl:variable><xsl:variable name ="Link38">C2RESTREALREC</xsl:variable><xsl:variable name ="Link39" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link40" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link38, $Link39, $Link40)"/><xsl:value-of select="$Link37" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm20" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link41">Bilan Synthétique</xsl:variable><xsl:variable name ="Link42">DBILANSYNTH</xsl:variable><xsl:variable name ="Link43" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link44" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link42, $Link43, $Link44)"/><xsl:value-of select="$Link41" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm21" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">E</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link45">Compte de résultat synthétique</xsl:variable><xsl:variable name ="Link46">ECPTRESSYNTH</xsl:variable><xsl:variable name ="Link47" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link48" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link46, $Link47, $Link48)"/><xsl:value-of select="$Link45" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm22" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">F</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link49">Taux des contributions et produits afférents en N</xsl:variable><xsl:variable name ="Link50">FTAUXCTRPROD</xsl:variable><xsl:variable name ="Link51" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link52" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link50, $Link51, $Link52)"/><xsl:value-of select="$Link49" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">II. Exécution budgétaire</span></b></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm23" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link53">Modalités de vote du budget</xsl:variable><xsl:variable name ="Link54">AVOTEBUDG</xsl:variable><xsl:variable name ="Link55" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link56" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link54, $Link55, $Link56)"/><xsl:value-of select="$Link53" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">Vue d'ensemble</span></i></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm24" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link57">Dépenses d'investissement</xsl:variable><xsl:variable name ="Link58">A11DEPINV</xsl:variable><xsl:variable name ="Link59" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link60" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link58, $Link59, $Link60)"/><xsl:value-of select="$Link57" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm25" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link61">Recette d'investissement</xsl:variable><xsl:variable name ="Link62">A12RECINV</xsl:variable><xsl:variable name ="Link63" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link64" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link62, $Link63, $Link64)"/><xsl:value-of select="$Link61" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm26" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link65">Dépenses de fonctionnement</xsl:variable><xsl:variable name ="Link66">A21DEPFONC</xsl:variable><xsl:variable name ="Link67" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link68" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link66, $Link67, $Link68)"/><xsl:value-of select="$Link65" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm27" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link69">Recettes de fonctionnement</xsl:variable><xsl:variable name ="Link70">A22RECFONC</xsl:variable><xsl:variable name ="Link71" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link72" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link70, $Link71, $Link72)"/><xsl:value-of select="$Link69" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">Vue détaillée</span></i></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm28" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link73">Dépenses d'investissement</xsl:variable><xsl:variable name ="Link74">B1DEPINV</xsl:variable><xsl:variable name ="Link75" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link76" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link74, $Link75, $Link76)"/><xsl:value-of select="$Link73" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm29" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link77">Recettes d'investissement</xsl:variable><xsl:variable name ="Link78">B2RECINV</xsl:variable><xsl:variable name ="Link79" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link80" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link78, $Link79, $Link80)"/><xsl:value-of select="$Link77" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm30" select="$varOdm9"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link81">Opérations d'équipement - Détail des chapitres et articles</xsl:variable><xsl:variable name ="Link82">C1OPEREQUIP</xsl:variable><xsl:variable name ="Link83" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link84" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link82, $Link83, $Link84)"/><xsl:value-of select="$Link81" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><xsl:variable name="varOdm31" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link85">Dépenses de fonctionnement</xsl:variable><xsl:variable name ="Link86">D1DEPFONC</xsl:variable><xsl:variable name ="Link87" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link88" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link86, $Link87, $Link88)"/><xsl:value-of select="$Link85" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm32" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link89">Recettes de fonctionnement</xsl:variable><xsl:variable name ="Link90">D2RECFONC</xsl:variable><xsl:variable name ="Link91" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link92" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link90, $Link91, $Link92)"/><xsl:value-of select="$Link89" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><td width="10%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">III. États Financiers</span></b></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm33" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link93">Bilan</xsl:variable><xsl:variable name ="Link94">ABILAN</xsl:variable><xsl:variable name ="Link95" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link96" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link94, $Link95, $Link96)"/><xsl:value-of select="$Link93" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm34" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link97">Compte de résultat</xsl:variable><xsl:variable name ="Link98">BCPTRES</xsl:variable><xsl:variable name ="Link99" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link100" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link98, $Link99, $Link100)"/><xsl:value-of select="$Link97" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td></tr><tr><xsl:variable name="varOdm35" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link101">Annexe (uniquement pour les collectivités certifiables)</xsl:variable><xsl:variable name ="Link102">CANNEX</xsl:variable><xsl:variable name ="Link103" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link104" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link102, $Link103, $Link104)"/><xsl:value-of select="$Link101" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur / Comptable - Pièce jointe</span></p>
                        </td></tr><tr><td width="10%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><u><span style="font-size:8.0pt;color:blue">IV. États annexés</span></u></b></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="10%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">A. Présentation croisée et agrégée</span></i></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation croisée, section d’investissement – vue d’ensemble</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation croisée, section de fonctionnement – vue d’ensemble</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A3</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation agrégée du budget principal et des budgets annexes</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">B. États annexés patrimoniaux</span></i></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Détail des crédits de trésorerie</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Répartition par nature de dette</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.3</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Répartition par structure de taux</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.4</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Typologie de la répartition de l'encours</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.5</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Détail des opérations de couverture</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.6</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Remboursement anticipé d'un emprunt avec refinancement</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.7</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Emprunts renégociés au cours de l'année N</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.8</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Dette pour financer l'emprunt d'un autre organisme</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.9</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Autres dettes</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Méthodes utilisées pour les amortissements</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B3.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des provisions</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B3.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Étalement des provisions</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B4</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des charges transférées</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B5</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Détail des opérations pour le compte de tiers</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B6</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Prêts</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B7.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des emprunts garantis</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B7.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Calcul du ratio d'endettement relatif aux emprunts garantis</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.1.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des concours attribués à des tiers en nature ou en subventions</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.1.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des subventions versées aux communes</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des contrats de crédit-bail</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.3</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des contrats de partenariat public-privé</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.4</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des autres engagements donnés</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.5</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des engagements reçus</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B9</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État du personnel</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B10</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des organismes dans lesquels la collectivité a pris un engagement financier</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B12.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine – Entrées</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B12.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine – Sorties</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" style="layout-grid-mode:char"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B13</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Opérations liées aux cessions</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B14</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des travaux en régie</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">C. États annexés budgétaires</span></i></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire - dépenses</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire - recettes</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Situation des autorisations de programme</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Situation des autorisations d’engagement</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">D. Autres éléments d’information</span></i></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des recettes grevées d'une affectation spéciale</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D2.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">Liste des services assujettis à la TVA et non érigés en budget annexe</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D2.2.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">Services assujettis à la TVA – vue d’ensemble</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D3.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Services ferroviaires régionaux des voyageurs (SRV) - Volet 1 : Budget</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D3.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">SRV - Volet 2 : Compte d'exploitation</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D3.3</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">SRV - Volet 3 : Patrimoine</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D4.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine (article L. 300-5 du code de l'urbanisme) – Entrées</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D4.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine (article L. 300-5 du code de l'urbanisme) – Sorties</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D5</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Gestion des fonds européens</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D6</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Emploi des crédits communautaires dans le cadre de la subvention globale</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D7</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Actions de formation des élus</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D8</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État relatif aux ressources et dépenses de la formation professionnelle des jeunes</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D9</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Compte d'emploi du fonds commun des services d'hébergement</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D10</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Identification des flux croisés</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D11.1</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">États de la répartition de la TEOM – investissement</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D11.2</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">États de la répartition de la TEOM – fonctionnement</span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td></tr><tr><td width="10%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">V. Arrêté et signatures</span></b></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm36" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link105">Arrêté et signatures</xsl:variable><xsl:variable name ="Link106">AARRESIG</xsl:variable><xsl:variable name ="Link107" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link108" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link106, $Link107, $Link108)"/><xsl:value-of select="$Link105" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="35%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur / Comptable</span></p>
                        </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab7"></xsl:with-param></xsl:call-template>
                  <p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:12.0pt"> </span></p>
                  <p class="MsoNormal" align="center" style="text-align:center;page-break-after: avoid;punctuation-wrap:simple"><span style="font-size:12.0pt"><xsl:variable name ="Refer95">BEC</xsl:variable><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="$Refer95"/></xsl:call-template>Balance et autres états comptables</span></p>
                  <p class="MsoNormal" style="page-break-after:avoid;punctuation-wrap:simple"><span style="font-size:12.0pt"> </span></p>
                  <xsl:variable name="varOdmTmpTab8"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><xsl:variable name="varOdm37" select="$varOdm9"/><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link109">Balance Générale des comptes</xsl:variable><xsl:variable name ="Link110">BALGENCPT</xsl:variable><xsl:variable name ="Link111" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link112" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link110, $Link111, $Link112)"/><xsl:value-of select="$Link109" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm38" select="$varOdm9"/><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link113">Balance des Valeurs Inactives</xsl:variable><xsl:variable name ="Link114">BALVALIN</xsl:variable><xsl:variable name ="Link115" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link116" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link114, $Link115, $Link116)"/><xsl:value-of select="$Link113" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><u><span style="font-size:8.0pt;color:blue">État de solde : Reste A Recouvrer</span></u></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><u><span style="font-size:8.0pt;color:blue">État de solde : Reste A Payer</span></u></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><u><span style="font-size:8.0pt;color:blue">État de Développement Des Soldes (EDDS)</span></u></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><u><span style="font-size:8.0pt;color:blue">Fiches Budgétaires</span></u></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><u><span style="font-size:8.0pt;color:blue">Livre Auxiliaire des Comptes de Tiers et des comptes Financiers</span></u></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><u><span style="font-size:8.0pt;color:blue">État des ordres de paiement</span></u></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab8"></xsl:with-param></xsl:call-template>
                  <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size: 12.0pt"> </span></p>
                  <p class="MsoNormal" align="center" style="text-align:center;page-break-after: avoid;punctuation-wrap:simple"><span style="font-size:12.0pt"><xsl:variable name ="Refer96">DB</xsl:variable><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="$Refer96"/></xsl:call-template>Liens vers les Documents Budgétaires</span></p>
                  <p class="MsoNormal" style="page-break-after:avoid;punctuation-wrap:simple"><span style="font-size:12.0pt"> </span></p>
                  <xsl:variable name="varOdmTmpTab9"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="background:#E6E6E6;padding: 0cm 1.4pt 1.5pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" style="margin-top:2.85pt;margin-right:0cm; margin-bottom:2.85pt;margin-left:0cm"><b><span style="font-size:8.0pt; color:black">Budgets (BP et BS)</span></b></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><u><span style="font-size:8.0pt;color:blue">[libellé doc bud] [identifiant doc bud]</span></u></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><u><span style="font-size:8.0pt;color:blue">[libellé doc bud] [identifiant doc bud]</span></u></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><i><span style="font-size:8.0pt">etc.</span></i></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="background:#E6E6E6;padding: 0cm 1.4pt 1.5pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="margin-top:2.85pt;margin-right:0cm;margin-bottom: 2.85pt;margin-left:0cm;punctuation-wrap:simple"><b><span style="font-size: 8.0pt;color:black">Décision(s) Modificative(s)</span></b></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size: 8.0pt">Numéro de la décision : <u><span style="color:blue">[num décision] : [libellé doc bud] [identifiant doc bud]</span></u></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size: 8.0pt">Numéro de la décision : <u><span style="color:blue">[num décision] : [libellé doc bud] [identifiant doc bud]</span></u></span></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="MsoNormal" style="punctuation-wrap:simple"><i><span style="font-size:8.0pt">etc.</span></i></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab9"></xsl:with-param></xsl:call-template>
                  <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size: 12.0pt"> </span></p>
                  <p class="MsoNormal" align="center" style="text-align:center;page-break-after: avoid;punctuation-wrap:simple"><span style="font-size:12.0pt"><xsl:variable name ="Refer97">ADD</xsl:variable><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="$Refer97"/></xsl:call-template>Autres documents dématérialisés</span></p>
                  <p class="MsoNormal" style="page-break-after:avoid;punctuation-wrap:simple"><span style="font-size:12.0pt"> </span></p>
                  <xsl:variable name="varOdmTmpTab10"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><td width="8.1%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="66.7%" style="padding: 0cm 1.4pt 1.5pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><u><span style="font-size:8.0pt;color:blue">ORMC</span></u></p>
                        </td><td width="25.3%" style="padding:0cm 1.4pt 0cm 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab10"></xsl:with-param></xsl:call-template>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab5"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" align="center" style="text-align:center;punctuation-wrap:simple"><span style="font-size:4.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab11"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$PDF_OUTPUT_FORMAT"><xsl:variable name="varOdm39" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt"></span></b></p>
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt"> </span></b></p>
                  <xsl:variable name="varOdmTmpTab12"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><xsl:variable name="varOdm40" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="55%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="25%" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:variable name ="Link117">Arrêté et signatures</xsl:variable><xsl:variable name ="Link118">AARRESIG</xsl:variable><xsl:variable name ="Link119" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link120" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link118, $Link119, $Link120)"/><xsl:value-of select="$Link117" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="10%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm41" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="10%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="55%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="25%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                           <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:variable name ="Link121">ECCF</xsl:variable><xsl:variable name ="Link122">ETACTRLCPTFIN</xsl:variable><xsl:variable name ="Link123" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link124" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link122, $Link123, $Link124)"/><xsl:value-of select="$Link121" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="10%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab12"></xsl:with-param></xsl:call-template>
                  <xsl:variable name="varOdmTmpTab13"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><thead>
                        <tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                              <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">Origine des données</span></p>
                           </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                              <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">Page</span></p>
                           </td></tr>
                     </thead><tr><td width="9.3%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">I. Informations générales et synthétiques</span></b></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm42" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link125">Informations statistiques, fiscales et financières</xsl:variable><xsl:variable name ="Link126">AINFOSTATFISCFIN</xsl:variable><xsl:variable name ="Link127" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link128" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link126, $Link127, $Link128)"/><xsl:value-of select="$Link125" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33006_nature &gt; 0"><xsl:value-of select="$p_33006_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm43" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link129">Présentation générale du compte financier - Vue d'ensemble</xsl:variable><xsl:variable name ="Link130">B1PRESCPTFIN</xsl:variable><xsl:variable name ="Link131" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link132" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link130, $Link131, $Link132)"/><xsl:value-of select="$Link129" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33008_nature &gt; 0"><xsl:value-of select="$p_33008_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm44" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link133">Détermination du résultat cumulé à la fin de l'exercice</xsl:variable><xsl:variable name ="Link134">BRESCUMUL</xsl:variable><xsl:variable name ="Link135" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link136" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link134, $Link135, $Link136)"/><xsl:value-of select="$Link133" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33009_nature &gt; 0"><xsl:value-of select="$p_33009_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm45" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">B3.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link137">Liste des organismes de regroupement</xsl:variable><xsl:variable name ="Link138">B31ORGAREGROUP</xsl:variable><xsl:variable name ="Link139" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link140" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link138, $Link139, $Link140)"/><xsl:value-of select="$Link137" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33010_nature &gt; 0"><xsl:value-of select="$p_33010_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm46" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">B3.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link141">Liste des établissements publics créés</xsl:variable><xsl:variable name ="Link142">B32ETAPUB</xsl:variable><xsl:variable name ="Link143" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link144" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link142, $Link143, $Link144)"/><xsl:value-of select="$Link141" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33011_nature &gt; 0"><xsl:value-of select="$p_33011_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm47" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">B3.3</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link145">Liste des services individualisés dans un budget annexe</xsl:variable><xsl:variable name ="Link146">B33SERVINDIV</xsl:variable><xsl:variable name ="Link147" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link148" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link146, $Link147, $Link148)"/><xsl:value-of select="$Link145" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33012_nature &gt; 0"><xsl:value-of select="$p_33012_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm48" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link149">Détail des restes à réaliser - Dépenses</xsl:variable><xsl:variable name ="Link150">C1RESTREALDEP</xsl:variable><xsl:variable name ="Link151" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link152" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link150, $Link151, $Link152)"/><xsl:value-of select="$Link149" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33013_nature &gt; 0"><xsl:value-of select="$p_33013_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm49" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link153">Détail des restes à réaliser - Recettes</xsl:variable><xsl:variable name ="Link154">C2RESTREALREC</xsl:variable><xsl:variable name ="Link155" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link156" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link154, $Link155, $Link156)"/><xsl:value-of select="$Link153" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33014_nature &gt; 0"><xsl:value-of select="$p_33014_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm50" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link157">Bilan Synthétique</xsl:variable><xsl:variable name ="Link158">DBILANSYNTH</xsl:variable><xsl:variable name ="Link159" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link160" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link158, $Link159, $Link160)"/><xsl:value-of select="$Link157" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32984_nature &gt; 0"><xsl:value-of select="$p_32984_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm51" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">E</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link161">Compte de résultat synthétique</xsl:variable><xsl:variable name ="Link162">ECPTRESSYNTH</xsl:variable><xsl:variable name ="Link163" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link164" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link162, $Link163, $Link164)"/><xsl:value-of select="$Link161" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32986_nature &gt; 0"><xsl:value-of select="$p_32986_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm52" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">F</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link165">Taux des contributions et produits afférents en N</xsl:variable><xsl:variable name ="Link166">FTAUXCTRPROD</xsl:variable><xsl:variable name ="Link167" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link168" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link166, $Link167, $Link168)"/><xsl:value-of select="$Link165" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33015_nature &gt; 0"><xsl:value-of select="$p_33015_nature" /></xsl:if></span></p>
                        </td></tr><tr><td width="9.3%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">II. Exécution budgétaire</span></b></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm53" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link169">Modalités de vote du budget</xsl:variable><xsl:variable name ="Link170">AVOTEBUDG</xsl:variable><xsl:variable name ="Link171" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link172" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link170, $Link171, $Link172)"/><xsl:value-of select="$Link169" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33016_nature &gt; 0"><xsl:value-of select="$p_33016_nature" /></xsl:if></span></p>
                        </td></tr><tr><td width="9.3%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">Vue d'ensemble</span></i></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm54" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link173">Dépenses d'investissement</xsl:variable><xsl:variable name ="Link174">A11DEPINV</xsl:variable><xsl:variable name ="Link175" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link176" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link174, $Link175, $Link176)"/><xsl:value-of select="$Link173" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33017_nature &gt; 0"><xsl:value-of select="$p_33017_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm55" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link177">Recette d'investissement</xsl:variable><xsl:variable name ="Link178">A12RECINV</xsl:variable><xsl:variable name ="Link179" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link180" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link178, $Link179, $Link180)"/><xsl:value-of select="$Link177" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33018_nature &gt; 0"><xsl:value-of select="$p_33018_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm56" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link181">Dépenses de fonctionnement</xsl:variable><xsl:variable name ="Link182">A21DEPFONC</xsl:variable><xsl:variable name ="Link183" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link184" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link182, $Link183, $Link184)"/><xsl:value-of select="$Link181" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33019_nature &gt; 0"><xsl:value-of select="$p_33019_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm57" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link185">Recettes de fonctionnement</xsl:variable><xsl:variable name ="Link186">A22RECFONC</xsl:variable><xsl:variable name ="Link187" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link188" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link186, $Link187, $Link188)"/><xsl:value-of select="$Link185" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33020_nature &gt; 0"><xsl:value-of select="$p_33020_nature" /></xsl:if></span></p>
                        </td></tr><tr><td width="9.3%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">Vue détaillée</span></i></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm58" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link189">Dépenses d'investissement</xsl:variable><xsl:variable name ="Link190">B1DEPINV</xsl:variable><xsl:variable name ="Link191" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link192" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link190, $Link191, $Link192)"/><xsl:value-of select="$Link189" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32989_nature &gt; 0"><xsl:value-of select="$p_32989_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm59" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link193">Recettes d'investissement</xsl:variable><xsl:variable name ="Link194">B2RECINV</xsl:variable><xsl:variable name ="Link195" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link196" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link194, $Link195, $Link196)"/><xsl:value-of select="$Link193" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32991_nature &gt; 0"><xsl:value-of select="$p_32991_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm60" select="$varOdm39"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link197">Opérations d'équipement - Détail des chapitres et articles</xsl:variable><xsl:variable name ="Link198">C1OPEREQUIP</xsl:variable><xsl:variable name ="Link199" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"/><xsl:variable name ="Link200" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link198, $Link199, $Link200)"/><xsl:value-of select="$Link197" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_33021_nature &gt; 0"><xsl:value-of select="$p_33021_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm61" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link201">Dépenses de fonctionnement</xsl:variable><xsl:variable name ="Link202">D1DEPFONC</xsl:variable><xsl:variable name ="Link203" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link204" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link202, $Link203, $Link204)"/><xsl:value-of select="$Link201" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32988_nature &gt; 0"><xsl:value-of select="$p_32988_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm62" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link205">Recettes de fonctionnement</xsl:variable><xsl:variable name ="Link206">D2RECFONC</xsl:variable><xsl:variable name ="Link207" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link208" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link206, $Link207, $Link208)"/><xsl:value-of select="$Link205" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32990_nature &gt; 0"><xsl:value-of select="$p_32990_nature" /></xsl:if></span></p>
                        </td></tr><tr><td width="9.3%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">III. États Financiers</span></b></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm63" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link209">Bilan</xsl:variable><xsl:variable name ="Link210">ABILAN</xsl:variable><xsl:variable name ="Link211" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link212" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link210, $Link211, $Link212)"/><xsl:value-of select="$Link209" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32983_nature &gt; 0"><xsl:value-of select="$p_32983_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm64" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link213">Compte de résultat</xsl:variable><xsl:variable name ="Link214">BCPTRES</xsl:variable><xsl:variable name ="Link215" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link216" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link214, $Link215, $Link216)"/><xsl:value-of select="$Link213" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32985_nature &gt; 0"><xsl:value-of select="$p_32985_nature" /></xsl:if></span></p>
                        </td></tr><tr><xsl:variable name="varOdm65" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link217">Annexe (uniquement pour les collectivités certifiables)</xsl:variable><xsl:variable name ="Link218">CANNEX</xsl:variable><xsl:variable name ="Link219" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link220" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link218, $Link219, $Link220)"/><xsl:value-of select="$Link217" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur / Comptable - Pièce jointe</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32992_nature &gt; 0"><xsl:value-of select="$p_32992_nature" /></xsl:if></span></p>
                        </td></tr><tr><td width="9.3%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">IV. États annexés</span></b></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">A. Présentation croisée et agrégée</span></i></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation croisée, section d’investissement – vue d’ensemble</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation croisée, section de fonctionnement – vue d’ensemble</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A3</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation agrégée du budget principal et des budgets annexes</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">B. États annexés patrimoniaux</span></i></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Détail des crédits de trésorerie</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Répartition par nature de dette</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.3</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Répartition par structure de taux</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.4</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Typologie de la répartition de l'encours</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.5</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Détail des opérations de couverture</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.6</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Remboursement anticipé d'un emprunt avec refinancement</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.7</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Emprunts renégociés au cours de l'année N</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.8</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Dette pour financer l'emprunt d'un autre organisme</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.9</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Autres dettes</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Méthodes utilisées pour les amortissements</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B3.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des provisions</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B3.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Étalement des provisions</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B4</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des charges transférées</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B5</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Détail des opérations pour le compte de tiers</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B6</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Prêts</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B7.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des emprunts garantis</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B7.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Calcul du ratio d'endettement relatif aux emprunts garantis</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.1.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des concours attribués à des tiers en nature ou en subventions</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.1.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des subventions versées aux communes</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des contrats de crédit-bail</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.3</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des contrats de partenariat public-privé</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.4</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des autres engagements donnés</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.5</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des engagements reçus</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B9</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État du personnel</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B10</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des organismes dans lesquels la collectivité a pris un engagement financier</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B12.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine – Entrées</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B12.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine – Sorties</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" style="layout-grid-mode:char"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B13</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Opérations liées aux cessions</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B14</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des travaux en régie</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">C. États annexés budgétaires</span></i></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire - dépenses</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire - recettes</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Situation des autorisations de programme</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Situation des autorisations d’engagement</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><i><span style="font-size:8.0pt;color:black">D. Autres éléments d’information</span></i></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État des recettes grevées d'une affectation spéciale</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D2.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">Liste des services assujettis à la TVA et non érigés en budget annexe</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D2.2.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">Services assujettis à la TVA – vue d’ensemble</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D3.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Services ferroviaires régionaux des voyageurs (SRV) - Volet 1 : Budget</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D3.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">SRV - Volet 2 : Compte d'exploitation</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D3.3</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">SRV - Volet 3 : Patrimoine</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D4.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine (article L. 300-5 du code de l'urbanisme) – Entrées</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D4.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Variation du patrimoine (article L. 300-5 du code de l'urbanisme) – Sorties</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D5</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Gestion des fonds européens</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D6</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Emploi des crédits communautaires dans le cadre de la subvention globale</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D7</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Actions de formation des élus</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D8</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">État relatif aux ressources et dépenses de la formation professionnelle des jeunes</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D9</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Compte d'emploi du fonds commun des services d'hébergement</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D10</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Identification des flux croisés</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D11.1</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">États de la répartition de la TEOM – investissement</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D11.2</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">États de la répartition de la TEOM – fonctionnement</span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><td width="9.3%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="55.7%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt;color:black">V. Arrêté et signatures</span></b></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr><xsl:variable name="varOdm66" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="9.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
                        </td><td width="55.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:variable name ="Link221">Arrêté et signatures</xsl:variable><xsl:variable name ="Link222">AARRESIG</xsl:variable><xsl:variable name ="Link223" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Link224" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:element name="a"><xsl:attribute name="href" select="exomile:createLink($Link222, $Link223, $Link224)"/><xsl:value-of select="$Link221" disable-output-escaping="yes"/></xsl:element></span></p>
                        </td><td width="24.7%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur / Comptable</span></p>
                        </td><td width="10.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                           <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:if test="$p_32994_nature &gt; 0"><xsl:value-of select="$p_32994_nature" /></xsl:if></span></p>
                        </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab13"></xsl:with-param></xsl:call-template>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab11"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" align="center" style="text-align:center;punctuation-wrap:simple"><span style="font-size:8.0pt"> </span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
        </script>
</html></xsl:template></xsl:stylesheet>