<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data">
   <xsl:import href="../../number.xsl"></xsl:import>
   <xsl:import href="../../date.xsl"></xsl:import>
   <xsl:import href="../../table.xsl"></xsl:import>
   <xsl:import href="../../style.xsl"></xsl:import>
   <xsl:import href="../../lien.xsl"></xsl:import>
   <xsl:import href="../../commons/constants.xsl"></xsl:import>
   <xsl:import href="../../commons/fonctions.xsl"></xsl:import>
   <xsl:import href="../../commons/templates.xsl"></xsl:import>
   <xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param>
   <xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param>
   <xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable>
   <xsl:param name="nomenclaturePasEnrichie"></xsl:param>
   <xsl:variable name="nomenclature" select="document('libellePlanCompte.xml')/n:Nomenclature"></xsl:variable>
   <xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable>
   <xsl:variable name="isPrint" select="1"></xsl:variable>
   <xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="/dcfu:CompteFinancierUnique"></xsl:template><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         
         
         <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
            
            
            
            
            
            <meta name="generator" content="ODM" />
            
            
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
            
            
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
            
            
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h3
  {
  
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;
  font-weight:normal;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoAcetate, li.MsoAcetate, div.MsoAcetate
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:8.0pt;
  font-family:"Tahoma",sans-serif;}
p.MsoListParagraph, li.MsoListParagraph, div.MsoListParagraph
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpFirst, li.MsoListParagraphCxSpFirst, div.MsoListParagraphCxSpFirst
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpMiddle, li.MsoListParagraphCxSpMiddle, div.MsoListParagraphCxSpMiddle
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpLast, li.MsoListParagraphCxSpLast, div.MsoListParagraphCxSpLast
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.En-tteCar
  {
  }
span.PieddepageCar
  {
  }
span.TextedebullesCar
  {
  
  font-family:"Tahoma",sans-serif;}
span.Titre3Car
  {
  
  font-family:"Times New Roman",serif;}
p.BodyText21, li.BodyText21, div.BodyText21
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:210mm 297mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0in;}
ul
  {margin-bottom:0in;}
--&gt;
/**/
}</style>
            </head>
         
         
         
         <body id="ETAT_RSTREALDEP" lang="EN-US">
            
            
            <div id="header">
               
               
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &#34;Arial&#34;,&#34;sans-serif&#34;">
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"></xsl:value-of>  - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"></xsl:value-of></span></b></p>
               
               </div>
            
            
            
            
            <div class="WordSection1">
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab1">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <tr>
                           
                           
                           <td width="82.1%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">I – INFORMATIONS GENERALES ET SYNTHÉTIQUES</span></b></p>
                              
                              </td>
                           
                           
                           <td width="17.9%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">I</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="82.1%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">EXECUTION DU BUDGET – RAR RECETTES</span></b></p>
                              
                              </td>
                           
                           
                           <td width="17.9%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">C2</span></b></p>
                              
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal" style="margin-top:0in;margin-right:46.45pt;margin-bottom: 0in;margin-left:7.1pt;margin-bottom:.0001pt;text-align:justify"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">DETAIL DES RESTES A REALISER N EN RECETTES (1)</span></b></p>
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab2">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        <xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:CodRD/@V='R') and (not(./n:Fonction/@V))                         and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0)]"></xsl:variable>
                        
                        
                        <thead>
                           
                           
                           
                           <tr height="0" class="#tech# #fixWidths#">
                              
                              
                              <td width="13.4%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="51.1%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="-49%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="84.6%" style="border:none" rowspan="1" colspan="1"></td>
                              </tr>
                           
                           
                           
                           <tr style="page-break-inside:avoid">
                              
                              
                              <td width="13.4%" valign="top" style="border-top:double black 2.25pt; border-left:double black 2.25pt;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Chap. / art. (2)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="51.1%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:none;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Libellé</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="35.5%" colspan="2" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Titres restant à émettre</span></b></p>
                                 
                                 </td>
                              </tr>
                           
                           </thead>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           
                           <td width="13.4%" colspan="2" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="margin-right:11.95pt;text-align:justify;line-height: 115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif">SECTION D’INVESTISSEMENT – TOTAL</span></b></p>
                              
                              </td>
                           
                           
                           <td width="2.1%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">(III)</span></p>
                              
                              </td>
                           
                           
                           <td width="33.4%" valign="top" style="border-top:solid black 1.0pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINV')]/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm2" select="$varOdm1[(n:ChapitreNature/@V='018') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">018</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '018' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm2/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm3">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='018' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (./n:CaracSup[(@Code='ChapSpe')]/@V='018')]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm4">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm3/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm3"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm4/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm5" select="$varOdm1[(n:ChapitreNature/@V='024') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">024</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '024' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm5/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm6" select="$varOdm1[(n:ChapitreNature/@V='10') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">10</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '10' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm6/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm7">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='10' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm8">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm7/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm7"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm8/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm9" select="$varOdm1[(n:ChapitreNature/@V='13') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">13</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '13' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (reçues) (3)</span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm9/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm10">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='13' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm11">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm10/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm10"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm11/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm12" select="$varOdm1[(n:ChapitreNature/@V='16') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">16</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '16' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm12/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm13">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='16' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm14">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm13/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm13"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm14/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm15" select="$varOdm1[(n:ChapitreNature/@V='18') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">18</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="BodyText21" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '18' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm15/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm16">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='18' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm17">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm16/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm16"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm17/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm18" select="$varOdm1[(n:ChapitreNature/@V='20') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">20</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '20' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (sauf 204) (3)</span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm18/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm19">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='20' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm20">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm19/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm19"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm20/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm21" select="$varOdm1[(n:ChapitreNature/@V='204') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">204</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '204' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (3)</span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm21/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm22">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='204' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm23">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm22/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm22"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm23/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm24" select="$varOdm1[(n:ChapitreNature/@V='21') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">21</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '21' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (3)</span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm24/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm25">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='21' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm26">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm25/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm25"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm26/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm27" select="$varOdm1[(n:ChapitreNature/@V='22') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">22</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="BodyText21" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '22' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (3)</span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm27/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm28">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='22' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm29">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm28/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm28"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm29/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm30" select="$varOdm1[(n:ChapitreNature/@V='23') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">23</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '23' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (3)</span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm30/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm31">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='23' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm32">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm31/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm31"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm32/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm33" select="$varOdm1[(n:ChapitreNature/@V='26') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">26</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '26' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm33/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm34">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='26' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm35">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm34/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm34"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm35/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm36" select="$varOdm1[(n:ChapitreNature/@V='27') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">27</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="BodyText21" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '27' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (3)</span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm36/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm37">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='27' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteInv/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm38">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm37/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm37"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm38/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">45</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="BodyText21" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Chapitres d’opérations pour compte de tiers</span></b></p>
                              
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECOPCT')                                        and (./n:OpBudg/@V='0')]/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm39">
                           
                           
                           <xsl:for-each select="distinct-values($varOdm1[(./n:Nature/@V) and (./n:OpeCpteTiers/@V)]/n:TypNumCpteTiers/@V)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$varOdm1[(./n:Nature/@V) and (./n:OpeCpteTiers/@V) and (./n:TypNumCpteTiers/@V=$codeBoucle)]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($ligne/n:Nature/@V)"></xsl:value-of>
                                             
                                             <xsl:value-of select="distinct-values($ligne/n:OpeCpteTiers/@V)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($ligne/n:LibCpte/@V)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm40">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm39/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm39"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm40/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           
                           <td width="13.4%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="margin-right:46.45pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">SECTION DE FONCTIONNEMENT – TOTAL</span></b></p>
                              
                              </td>
                           
                           
                           <td width="2.1%" valign="top" style="border:none;border-bottom:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">(IV)</span></p>
                              
                              </td>
                           
                           
                           <td width="33.4%" valign="top" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm41" select="$varOdm1[(n:ChapitreNature/@V='70') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">70</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '70' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm41/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm42">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='70' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm43">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm42/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm42"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm43/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm44" select="$varOdm1[(n:ChapitreNature/@V='73') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">73</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '73' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm44/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm45">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='73' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm46">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm45/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm45"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm46/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm47" select="$varOdm1[(n:ChapitreNature/@V='731') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">731</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '731' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm47/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm48">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='731' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm49">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm48/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm48"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm49/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm50" select="$varOdm1[(n:ChapitreNature/@V='74') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">74</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '74' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (4)</span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm50/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm51">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='74' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm52">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm51/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm51"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm52/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm53" select="$varOdm1[(n:ChapitreNature/@V='75') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">75</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '75' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (4)</span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm53/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm54">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='75' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm55">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm54/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm54"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm55/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm56" select="$varOdm1[(n:ChapitreNature/@V='013') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">013</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '013' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (4)</span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm56/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm57">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='013' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm58">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm57/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm57"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm58/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm59" select="$varOdm1[(n:ChapitreNature/@V='016') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">016</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '016' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm59/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm60">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='016' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (./n:CaracSup[(@Code='ChapSpe')]/@V='016')]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm61">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm60/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm60"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm61/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm62" select="$varOdm1[(n:ChapitreNature/@V='017') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">017</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="margin-right:-3.5pt;text-align:left; line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '017' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm62/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm63">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='017' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (./n:CaracSup[(@Code='ChapSpe')]/@V='017')]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm64">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm63/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm63"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm64/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm65" select="$varOdm1[(n:ChapitreNature/@V='76') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">76</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <h3 align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '76' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></b></h3>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm65/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm66">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='76' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm67">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm66/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm66"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm67/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm68" select="$varOdm1[(n:ChapitreNature/@V='77') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">77</span></b></p>
                              
                              </td>
                           
                           
                           <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '77' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (4)</span></b></p>
                              </td>
                           
                           
                           <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm68/n:MtRAR3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <xsl:variable name="varOdm69">
                           
                           
                           <xsl:for-each select="distinct-values($nomenclature/n:Nature/n:Compte[@Type='C' and @Code='77' and @CodRD='R' and @OpBudg='0']/descendant::node()[@Type = 'A']/@Code)">
                              
                              
                              <xsl:sort select="."></xsl:sort>
                              
                              
                              <xsl:variable name="codeBoucle" select="."></xsl:variable>
                              
                              <xsl:variable name="ligne" select="$docbudg/n:DocumentBudgetaire/n:Budget[(./n:BlocBudget/n:NatVoteFonc/@V='a')]/n:LigneBudget[(./n:CodRD/@V='R')                               and (not(./n:Fonction/@V)) and (./n:OpBudg/@V='0') and (./n:MtRAR3112/@V!=0) and (./n:Nature/@V=$codeBoucle) and (not(./n:CaracSup[(@Code='ChapSpe')]/@V))]"></xsl:variable>
                              
                              
                              <xsl:if test="$ligne">
                                 
                                 
                                 <tr style="page-break-inside:avoid">
                                    
                                    
                                    <td width="13.4%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values($codeBoucle)"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="51.1%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                                       
                                       
                                       <p class="MsoHeader" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = $codeBoucle and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                                       </td>
                                    
                                    
                                    <td width="35.5%" colspan="2" valign="top" style="border-top:none; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1">
                                       
                                       
                                       <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                             
                                             <xsl:call-template name="num:number">
                                                
                                                <xsl:with-param name="num" select="$ligne/n:MtRAR3112/@V"></xsl:with-param>
                                                </xsl:call-template></span></p>
                                       </td>
                                    </tr>
                                 </xsl:if>
                              </xsl:for-each>
                           </xsl:variable>
                        
                        
                        <xsl:variable name="varOdm70">
                           
                           
                           <xsl:choose>
                              
                              
                              <xsl:when test="count($varOdm69/*) = 0">
                                 
                                 
                                 <tr class=" #tech#" style="page-break-inside:avoid">
                                    
                                    
                                    <td height="1px" width="13.4%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left:double black 2.25pt; border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="51.1%" valign="top" rowspan="1" colspan="1" style="border-top:hidden;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    
                                    
                                    <td height="1px" width="35.5%" colspan="2" valign="top" rowspan="1" style="border-top:hidden; border-left:none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt"></td>
                                    </tr>
                                 </xsl:when>
                              
                              
                              <xsl:otherwise>
                                 
                                 
                                 <xsl:sequence select="$varOdm69"></xsl:sequence>
                                 </xsl:otherwise>
                              </xsl:choose>
                           </xsl:variable>
                        
                        
                        <xsl:call-template name="table:processRowBorders">
                           
                           
                           <xsl:with-param name="borderStyle" select="'none'"></xsl:with-param>
                           
                           
                           <xsl:with-param name="rows" select="$varOdm70/xhtml:tr"></xsl:with-param>
                           </xsl:call-template>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal" style="text-align:justify"><b><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(1) Il s’agit des restes à réaliser établis conformément à la comptabilité d’engagement
                     annuelle. Ces restes à réaliser seront
                     repris au BP ou au BS N+1.</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(2) Suivant le niveau de vote retenu par l’assemblée délibérante.</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(3) Hors recettes imputées au chapitre 018.</span></p>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left;text-autospace:none"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif">(4) Hors recettes imputées aux chapitres 016 et 017.</span></p>
               
               </div>
            
            
            
            <div id="footer">
               
               <p xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" class="MsoNormal"><span style="font-size:8.0pt;line-height:115%">
                     
                     <xsl:if test="$HTML_OUTPUT_FORMAT">
                        
                        <xsl:variable name="link1" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"></xsl:variable>
                        
                        <xsl:variable name="link2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"></xsl:variable>
                        
                        <xsl:variable name="link3" select="'images/return.png'"></xsl:variable>
                        
                        <xsl:variable name="link4" select="'Accueil'"></xsl:variable>
                        
                        <xsl:variable name="link5" select="$link1"></xsl:variable>
                        
                        <xsl:variable name="link6" select="$link2"></xsl:variable>
                        
                        <xsl:call-template name="com:lienOutputImage">
                           
                           <xsl:with-param name="Param_0" select="'images/return.png'"></xsl:with-param>
                           
                           <xsl:with-param name="Param_1" select="$link3"></xsl:with-param>
                           
                           <xsl:with-param name="Param_2" select="$link4"></xsl:with-param>
                           
                           <xsl:with-param name="Param_3" select="$link5"></xsl:with-param>
                           
                           <xsl:with-param name="Param_4" select="$link6"></xsl:with-param>
                           </xsl:call-template>
                        </xsl:if></span></p>
               </div>
            </body>
         
         </html></xsl:template></xsl:stylesheet>