<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data">
   <xsl:import href="../../number.xsl"></xsl:import>
   <xsl:import href="../../date.xsl"></xsl:import>
   <xsl:import href="../../table.xsl"></xsl:import>
   <xsl:import href="../../style.xsl"></xsl:import>
   <xsl:import href="../../lien.xsl"></xsl:import>
   <xsl:import href="../../commons/constants.xsl"></xsl:import>
   <xsl:import href="../../commons/fonctions.xsl"></xsl:import>
   <xsl:import href="../../commons/templates.xsl"></xsl:import>
   <xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param>
   <xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param>
   <xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable>
   <xsl:param name="nomenclaturePasEnrichie"></xsl:param>
   <xsl:variable name="nomenclature" select="document('libellePlanCompte.xml')/n:Nomenclature"></xsl:variable>
   <xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable>
   <xsl:variable name="isPrint" select="1"></xsl:variable>
   <xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="/dcfu:CompteFinancierUnique"></xsl:template><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         
         
         <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
            
            
            
            
            
            <meta name="generator" content="ODM" />
            
            
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
            
            
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
            
            
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Calibri;
  panose-1:2 15 5 2 2 2 4 3 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h2
  {
  margin-top:10.0pt;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:0in;
  margin-bottom:.0001pt;
  page-break-after:avoid;
  font-size:13.0pt;
  font-family:"Cambria",serif;
  color:#4F81BD;}
h4
  {
  margin-top:10.0pt;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:0in;
  margin-bottom:.0001pt;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Cambria",serif;
  color:#4F81BD;
  font-style:italic;}
h5
  {
  margin-top:10.0pt;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:0in;
  margin-bottom:.0001pt;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Cambria",serif;
  color:#243F60;
  font-weight:normal;}
h6
  {
  margin:0in;
  margin-bottom:.0001pt;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFootnoteText, li.MsoFootnoteText, div.MsoFootnoteText
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:11.0pt;
  font-family:"Calibri",sans-serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:11.0pt;
  font-family:"Calibri",sans-serif;}
p.MsoBodyTextIndent, li.MsoBodyTextIndent, div.MsoBodyTextIndent
  {
  margin-top:0in;
  margin-right:0in;
  margin-bottom:6.0pt;
  margin-left:14.15pt;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoBodyText3, li.MsoBodyText3, div.MsoBodyText3
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:8.0pt;
  font-family:"Times New Roman",serif;
  text-transform:uppercase;}
p.MsoListParagraph, li.MsoListParagraph, div.MsoListParagraph
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpFirst, li.MsoListParagraphCxSpFirst, div.MsoListParagraphCxSpFirst
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpMiddle, li.MsoListParagraphCxSpMiddle, div.MsoListParagraphCxSpMiddle
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpLast, li.MsoListParagraphCxSpLast, div.MsoListParagraphCxSpLast
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.En-tteCar
  {
  }
span.PieddepageCar
  {
  }
span.Titre6Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.Corpsdetexte3Car
  {
  
  font-family:"Times New Roman",serif;
  text-transform:uppercase;}
span.Titre2Car
  {
  
  font-family:"Cambria",serif;
  color:#4F81BD;
  font-weight:bold;}
span.Titre4Car
  {
  
  font-family:"Cambria",serif;
  color:#4F81BD;
  font-weight:bold;
  font-style:italic;}
span.Titre5Car
  {
  
  font-family:"Cambria",serif;
  color:#243F60;}
p.BodyText21, li.BodyText21, div.BodyText21
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;}
span.RetraitcorpsdetexteCar
  {
  
  font-family:"Times New Roman",serif;}
span.NotedebasdepageCar
  {
  
  font-family:"Times New Roman",serif;}
p.notedebasdepage, li.notedebasdepage, div.notedebasdepage
  {
  margin-top:0in;
  margin-right:46.5pt;
  margin-bottom:3.0pt;
  margin-left:0in;
  text-align:justify;
  font-size:6.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style>
            </head>
         
         
         
         <body id="ETAT_DEPFONCFON" lang="EN-US">
            
            
            <div id="header">
               
               
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &#34;Arial&#34;,&#34;sans-serif&#34;">
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"></xsl:value-of>  - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"></xsl:value-of></span></b></p>
               
               </div>
            
            
            
            
            <div class="WordSection1">
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab1">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="background:white;border-collapse:collapse;border:none">
                        
                        
                        <tr>
                           
                           
                           <td width="87.2%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II – EXÉCUTION BUDGÉTAIRE</span></b></p>
                              
                              </td>
                           
                           
                           <td width="12.8%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="87.2%" valign="top" style="border-top:none;border-left: double black 2.25pt;border-bottom:double black 2.25pt;border-right: solid black 1.0pt;padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">EXECUTION BUDGETAIRE PAR FONCTION – DEPENSES DE FONCTIONNEMENT – VUE D’ENSEMBLE</span></b></p>
                              
                              </td>
                           
                           
                           <td width="12.8%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:double black 2.25pt; padding:0in 3.5pt 0in 3.5pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">C2.1</span></b></p>
                              
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab2">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        <xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:OpBudg/@V!='T') and (./n:InfoOpe/@V='T')                         and (./n:CodRD/@V='D')]"></xsl:variable>
                        
                        
                        <thead>
                           
                           
                           
                           <tr height="0" class="#tech# #fixWidths#">
                              
                              
                              <td width="6.5%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="13.9%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="14.5%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="19.3%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="22.8%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="22.8%" style="border:none" rowspan="1" colspan="1"></td>
                              </tr>
                           
                           
                           
                           <tr style="page-break-inside:avoid;height:9.2pt">
                              
                              
                              <td width="6.5%" rowspan="2" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt;height:9.2pt" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="13.9%" rowspan="2" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.2pt" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Intitulé </span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="14.5%" rowspan="2" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.2pt" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Prévisions (a)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="19.3%" rowspan="2" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.2pt" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Réalisations</span></b></p>
                                 
                                 
                                 
                                 <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Titres émis (b)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="22.8%" rowspan="2" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.2pt" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" align="center" style="text-align:center;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Taux de</span></b></p>
                                 
                                 
                                 
                                 <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">réalisation (b/a)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="22.8%" rowspan="2" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt;height:9.2pt" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Restes à réaliser </span></b></p>
                                 
                                 </td>
                              </tr>
                           
                           
                           
                           <tr style="page-break-inside:avoid;height:9.2pt"></tr>
                           
                           </thead>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm2" select="$varOdm1[(n:ChapitreFonction/@V='930')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">930</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '930' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL930')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm3" select="$varOdm1[(n:ChapitreFonction/@V='9305')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">930-5</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '9305' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL9305')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm4" select="$varOdm1[(n:ChapitreFonction/@V='931')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">931</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '931' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL931')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm5" select="$varOdm1[(n:ChapitreFonction/@V='932')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">932</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '932' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL932')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm6" select="$varOdm1[(n:ChapitreFonction/@V='933')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">933</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '933' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL933')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm7" select="$varOdm1[(n:ChapitreFonction/@V='934')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">934</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '934' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (hors APA et RSA/régularisation de RMI)</span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL934')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm8" select="$varOdm1[(n:ChapitreFonction/@V='9343')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">934-3</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '9343' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL9343')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm9" select="$varOdm1[(n:ChapitreFonction/@V='9344')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">934-4</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '9344' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL9344')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm10" select="$varOdm1[(n:ChapitreFonction/@V='935')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">935</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '935' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL935')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm11" select="$varOdm1[(n:ChapitreFonction/@V='936')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">936</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '936' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL936')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm12" select="$varOdm1[(n:ChapitreFonction/@V='937')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">937</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '937' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL937')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm13" select="$varOdm1[(n:ChapitreFonction/@V='938')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">938</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '938' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL938')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">939</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '939' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#B2B2B2;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm14" select="$varOdm1[(n:RegroupFonction/@V='93')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">93</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '93' and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm14/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm14/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL93')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm14/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm15" select="$varOdm1[(n:ChapitreFonction/@V='940')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">940</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '940' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm15/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm15/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL940')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm15/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm16" select="$varOdm1[(n:ChapitreFonction/@V='941')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">941</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '941' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm16/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm16/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL941')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm16/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm17" select="$varOdm1[(n:ChapitreFonction/@V='942')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">942</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '942' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm17/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm17/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL942')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm17/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm18" select="$varOdm1[(n:ChapitreFonction/@V='943')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">943</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '943' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm18/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm18/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL943')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm18/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm19" select="$varOdm1[(n:ChapitreFonction/@V='944')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">944</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '944' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm19/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm19/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL944')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm19/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm20" select="$varOdm1[(n:ChapitreFonction/@V='945')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">945</span></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><span lang="FR" style="font-size: 8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '945' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (1)</span></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm20/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm20/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL945')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm20/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm21" select="$varOdm1[(n:ChapitreFonction/@V='946')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">946</span></i></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><i><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '946' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (1)</span></i></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm21/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm21/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL946')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm21/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm22" select="$varOdm1[(n:ChapitreFonction/@V='947')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">947</span></i></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><i><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '947' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></i></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm22/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm22/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL947')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm22/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm23" select="$varOdm1[(n:RegroupFonction/@V='94')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">94</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '94' and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm23/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm23/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL94')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm23/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm24" select="$varOdm1[(n:ChapitreFonction/@V='953')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">953</span></i></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><i><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '953' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (2)</span></i></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm24/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm24/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL953')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm24/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm25" select="$varOdm1[(n:RegroupFonction/@V='95')]"></xsl:variable>
                           
                           
                           <td width="6.5%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">95</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.9%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="margin-left:-3.55pt"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:FonctionLib/n:Compte[@Code = '95' and @Type = 'P']/@LibelleCourt)[1])"></xsl:value-of></span></b></p>
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm25/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm25/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='FCT_DEPFONTXREAL95')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm25/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           <xsl:variable name="varOdm26" select="$varOdm1[(n:ChapitreNature/@V='002')]"></xsl:variable>
                           
                           
                           <td width="20.5%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:double black 1.5pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">002 Résultat de fonctionnement reporté </span></b></p>
                              
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm26/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           </tr>
                        
                        
                        <tr style="page-break-inside:avoid">
                           
                           
                           <td width="20.5%" colspan="2" valign="top" style="border-top:none; border-left:double black 1.5pt;border-bottom:double black 1.5pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des dépenses de la section de fonctionnement</span></b></p>
                              
                              </td>
                           
                           
                           <td width="14.5%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPTOTFONCA')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="19.3%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPTOTFON')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> 
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPFONTXREALTOT')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="22.8%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GDEPTOTFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal" style="margin-top:0in;margin-right:76.5pt;margin-bottom: 0in;margin-left:21.3pt;margin-bottom:.0001pt;text-indent:-35.45pt"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal" style="text-indent:35.4pt"><span lang="FR" style="font-size: 6.0pt;font-family:&#34;Arial&#34;,sans-serif">(1) Les comptes 68 peuvent alimenter le chapitre 945 ou le chapitre 946 selon que
                     la collectivité applique le régime des provisions
                     semi-budgétaires ou</span></p>
               
               
               
               <p class="MsoNormal" style="text-indent:35.4pt"><span lang="FR" style="font-size: 6.0pt;font-family:&#34;Arial&#34;,sans-serif">budgétaires, conformément aux dispositions législatives et réglementaires afférentes.</span></p>
               
               
               
               <p class="MsoNormal" style="text-indent:35.4pt"><span lang="FR" style="font-size: 6.0pt;font-family:&#34;Arial&#34;,sans-serif">(2) Pour mémoire, crédits ouverts au budget mais ne faisant pas l’objet d’émission
                     de titres ou de mandats (opérations sans
                     réalisation).</span></p>
               
               
               
               <p class="MsoNormal"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               
               
               <p class="MsoNormal"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               </div>
            
            
            
            <div id="footer">
               
               <p xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" class="MsoNormal"><span style="font-size:8.0pt;line-height:115%">
                     
                     <xsl:if test="$HTML_OUTPUT_FORMAT">
                        
                        <xsl:variable name="link1" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"></xsl:variable>
                        
                        <xsl:variable name="link2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"></xsl:variable>
                        
                        <xsl:variable name="link3" select="'images/return.png'"></xsl:variable>
                        
                        <xsl:variable name="link4" select="'Accueil'"></xsl:variable>
                        
                        <xsl:variable name="link5" select="$link1"></xsl:variable>
                        
                        <xsl:variable name="link6" select="$link2"></xsl:variable>
                        
                        <xsl:call-template name="com:lienOutputImage">
                           
                           <xsl:with-param name="Param_0" select="'images/return.png'"></xsl:with-param>
                           
                           <xsl:with-param name="Param_1" select="$link3"></xsl:with-param>
                           
                           <xsl:with-param name="Param_2" select="$link4"></xsl:with-param>
                           
                           <xsl:with-param name="Param_3" select="$link5"></xsl:with-param>
                           
                           <xsl:with-param name="Param_4" select="$link6"></xsl:with-param>
                           </xsl:call-template>
                        </xsl:if></span></p>
               </div>
            </body>
         
         </html></xsl:template></xsl:stylesheet>