<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../number.xsl"></xsl:import><xsl:import href="../../date.xsl"></xsl:import><xsl:import href="../../table.xsl"></xsl:import><xsl:import href="../../style.xsl"></xsl:import><xsl:import href="../../lien.xsl"></xsl:import><xsl:import href="../../commons/constants.xsl"></xsl:import><xsl:import href="../../commons/fonctions.xsl"></xsl:import><xsl:import href="../../commons/templates.xsl"></xsl:import><xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param><xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param><xsl:param name="p_ARRESIGN"></xsl:param><xsl:param name="p_ETATCTRLCPT"></xsl:param><xsl:param name="p_PRESGENCPT"></xsl:param><xsl:param name="p_RESEXEC"></xsl:param><xsl:param name="p_LISTSRVINDIV"></xsl:param><xsl:param name="p_RSTREALDEP"></xsl:param><xsl:param name="p_RSTREALREC"></xsl:param><xsl:param name="p_BILANSYNTH"></xsl:param><xsl:param name="p_CPTRESSYNTH"></xsl:param><xsl:param name="p_MODVOTBDG"></xsl:param><xsl:param name="p_DEPEXP"></xsl:param><xsl:param name="p_RECEXP"></xsl:param><xsl:param name="p_DEPINV"></xsl:param><xsl:param name="p_RECINV"></xsl:param><xsl:param name="p_EXDEPEXP"></xsl:param><xsl:param name="p_EXRECEXP"></xsl:param><xsl:param name="p_EXDEPINV"></xsl:param><xsl:param name="p_EXRECINV"></xsl:param><xsl:param name="p_OPEEQUIP"></xsl:param><xsl:param name="p_BILAN"></xsl:param><xsl:param name="p_CPTRES"></xsl:param><xsl:param name="p_BALGE"></xsl:param><xsl:param name="p_RESCUMUL"></xsl:param><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="dcfu:CompteFinancierUnique"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docXHTML.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docPDF.css" />
      
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.MsoFootnoteText, li.MsoFootnoteText, div.MsoFootnoteText
  {
  margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
span.MsoFootnoteReference
  {vertical-align:super;}
a:link, span.MsoHyperlink
  {color:blue;
  text-decoration:underline;}
a:visited, span.MsoHyperlinkFollowed
  {color:purple;
  text-decoration:underline;}
span.NotedebasdepageCar
  {
  
  font-family:"Times New Roman",serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
span.Caractresdenotedebasdepage
  {}
span.En-tteCar
  {
  
  font-family:"Arial",sans-serif;}
span.PieddepageCar
  {
  
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style>
   </head>
   <body id="ETAT_SOMMAIRE" lang="FR" link="blue" vlink="purple"><div id="header">
         <xsl:variable name="tableau1"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size: 10.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:variable name="text1"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@CodeBC)"/></xsl:variable><xsl:variable name="text2"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/></xsl:variable><xsl:value-of select="concat ($text1, ' ', '-', ' ', $text2)" /></span></p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p class="MsoNormal" align="right" style="text-align:right;punctuation-wrap:simple"><span style="font-size:10.0pt;font-family:&#34;Arial&#34;,sans-serif"><xsl:variable name="text3"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V)"/></xsl:variable><xsl:value-of select="concat ('Exercice', ' ', $text3)" /></span></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
      </div>
      
      <div class="WordSection1">
         <div align="center">
            <xsl:variable name="tableau2"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="100%" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p class="MsoNormal" align="center" style="text-align:center"><xsl:variable name="text4"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Tresorerie/@Codique)"/></xsl:variable><xsl:variable name="text5"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Tresorerie/@LibellePoste)"/></xsl:variable><xsl:value-of select="concat ('POSTE COMPTABLE', ' ', $text4, ' ', $text5)" /></p></td></tr><tr><td width="100%" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:14.0pt"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/></span></p></td></tr><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BA' or $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BR'"><tr><td width="100%" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p class="MsoNormal" align="center" style="text-align:center"><xsl:variable name="text6"><xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:BudgetRattachement/@Libelle)"/></xsl:variable><xsl:value-of select="concat ('RELATIF AU BUDGET PRINCIPAL DE', ' ', $text6)" /></p></td></tr></xsl:when></xsl:choose><tr><td width="100%" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p class="MsoNormal" align="center" style="text-align:center"><b> </b></p><p class="MsoNormal" align="center" style="text-align:center"><b>NOMENCLATURE : <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Nomenclature/@V)"/></b></p></td></tr><tr><td width="100%" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p class="MsoNormal" align="center" style="text-align:center"><b> </b></p><p class="MsoNormal" align="center" style="text-align:center"><b>SIRET : <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret)"/></b></p></td></tr><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:NatFonc/@V = '1' or $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:NatFonc/@V = '3'"><tr><td width="100%" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"> </p>
                     <p class="MsoNormal" align="center" style="text-align:center"><b>Voté par Nature</b></p>
                  </td></tr></xsl:when></xsl:choose><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:NatFonc/@V = '2'"><tr><td width="100%" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center"> </p>
                     <p class="MsoNormal" align="center" style="text-align:center"><b>Voté par Fonction</b></p>
                  </td></tr></xsl:when></xsl:choose><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BP'"><tr><td width="100%" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center">BUDGET PRINCIPAL</p>
                  </td></tr></xsl:when></xsl:choose><xsl:choose><xsl:when test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BA' or $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@TypeBC = 'BR'"><tr><td width="100%" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                     <p class="MsoNormal" align="center" style="text-align:center">BUDGET ANNEXE</p>
                  </td></tr></xsl:when></xsl:choose></table></xsl:variable><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau2"></xsl:with-param></xsl:call-template></xsl:if>
         </div>
         <p class="MsoNormal" align="center" style="text-align:center"> </p>
         <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:14.0pt">Sommaire</span></b></p>
         <p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:6.0pt"> </span></p>
         <xsl:variable name="tableau3"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><xsl:choose><xsl:when test="$HTML_OUTPUT_FORMAT"><tr><td width="100%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                  <p class="MsoNormal"><span style="font-size:8.0pt"></span></p>
                  <p class="MsoNormal" style="margin-top:0cm;margin-right:255.1pt;margin-bottom: 0cm;margin-left:255.1pt;margin-bottom:.0001pt"><span style="font-size:8.0pt"><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:element name="span"><xsl:attribute name="class" select="'LIEN_ANCRE '" /><xsl:attribute name="onclick">scrollToElementId('CFU')</xsl:attribute><xsl:value-of select="'Le Compte Financier Unique'" /></xsl:element></xsl:if><xsl:if test="$PDF_OUTPUT_FORMAT"><xsl:element name="a"><xsl:attribute name="href">#CFU</xsl:attribute><xsl:value-of select="'Le Compte Financier Unique'" /></xsl:element></xsl:if></span></p>
                  <p class="MsoNormal" style="margin-top:0cm;margin-right:255.1pt;margin-bottom: 0cm;margin-left:255.1pt;margin-bottom:.0001pt"><span style="font-size:8.0pt"><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:element name="span"><xsl:attribute name="class" select="'LIEN_ANCRE '" /><xsl:attribute name="onclick">scrollToElementId('BEC')</xsl:attribute><xsl:value-of select="'Balance et autres états comptables'" /></xsl:element></xsl:if><xsl:if test="$PDF_OUTPUT_FORMAT"><xsl:element name="a"><xsl:attribute name="href">#BEC</xsl:attribute><xsl:value-of select="'Balance et autres états comptables'" /></xsl:element></xsl:if></span></p>
                  <p class="MsoNormal" style="margin-top:0cm;margin-right:255.1pt;margin-bottom: 0cm;margin-left:255.1pt;margin-bottom:.0001pt"><span style="font-size:8.0pt"><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:element name="span"><xsl:attribute name="class" select="'LIEN_ANCRE '" /><xsl:attribute name="onclick">scrollToElementId('DB')</xsl:attribute><xsl:value-of select="'Liens vers les Documents Budgétaires'" /></xsl:element></xsl:if><xsl:if test="$PDF_OUTPUT_FORMAT"><xsl:element name="a"><xsl:attribute name="href">#DB</xsl:attribute><xsl:value-of select="'Liens vers les Documents Budgétaires'" /></xsl:element></xsl:if></span></p>
                  <p class="MsoNormal" style="margin-top:0cm;margin-right:255.1pt;margin-bottom: 0cm;margin-left:255.1pt;margin-bottom:.0001pt"><span style="font-size:8.0pt"><xsl:if test="$HTML_OUTPUT_FORMAT"><xsl:element name="span"><xsl:attribute name="class" select="'LIEN_ANCRE '" /><xsl:attribute name="onclick">scrollToElementId('ADD')</xsl:attribute><xsl:value-of select="'Autres documents dématérialisés'" /></xsl:element></xsl:if><xsl:if test="$PDF_OUTPUT_FORMAT"><xsl:element name="a"><xsl:attribute name="href">#ADD</xsl:attribute><xsl:value-of select="'Autres documents dématérialisés'" /></xsl:element></xsl:if></span></p>
               </td></tr></xsl:when></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau3"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" align="center" style="text-align:center"><span style="font-size:14.0pt"><xsl:element name="span"><xsl:attribute name="id">CFU</xsl:attribute> </xsl:element>Le Compte Financier Unique</span></p>
         <xsl:variable name="tableau4"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="39.4%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt"></span></b></p>
               </td><td width="60.6%" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p class="Contenudetableau" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:variable name="link1" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link2" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link3" select="'Arrêté et signatures'"/><xsl:variable name="link4" select="'ARRESIGN'"/><xsl:variable name="link5" select="$link1"/><xsl:variable name="link6" select="$link2"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Arrêté et signatures'" /><xsl:with-param name="Param_1" select="$link3" /><xsl:with-param name="Param_2" select="$link4" /><xsl:with-param name="Param_3" select="$link5" /><xsl:with-param name="Param_4" select="$link6" /></xsl:call-template></span></p></td></tr><tr><td width="19.2%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="20.2%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="60.6%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:variable name="link7" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link8" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link9" select="'ECCF'"/><xsl:variable name="link10" select="'ETATCTRLCPT'"/><xsl:variable name="link11" select="$link7"/><xsl:variable name="link12" select="$link8"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'ECCF'" /><xsl:with-param name="Param_1" select="$link9" /><xsl:with-param name="Param_2" select="$link10" /><xsl:with-param name="Param_3" select="$link11" /><xsl:with-param name="Param_4" select="$link12" /></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:if test="$HTML_OUTPUT_FORMAT and $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:LigneSommairePlus/@RefEtat = 'BALGE.xsl'"><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau4"></xsl:with-param></xsl:call-template></xsl:if>
         <xsl:variable name="tableau5"><table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style=""><thead><tr style="height:.3pt"><td width="64.8%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1">
                     <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b><span style="font-size:8.0pt;line-height:115%"></span></b></p>
                  </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                     <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">Origine des données</span></p>
                  </td></tr></thead><tr style="height:.3pt"><td width="8.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">I. Informations générales et synthétiques</span></b></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link13" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link14" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link15" select="'Présentation générale du compte financier - Vue d’ensemble'"/><xsl:variable name="link16" select="'PRESGENCPT'"/><xsl:variable name="link17" select="$link13"/><xsl:variable name="link18" select="$link14"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Présentation générale du compte financier - Vue d’ensemble'" /><xsl:with-param name="Param_1" select="$link15" /><xsl:with-param name="Param_2" select="$link16" /><xsl:with-param name="Param_3" select="$link17" /><xsl:with-param name="Param_4" select="$link18" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link19" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link20" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link21" select="'Résultats d’exécution du budget principal et des budgets des services non personnalisés'"/><xsl:variable name="link22" select="'RESEXEC'"/><xsl:variable name="link23" select="$link19"/><xsl:variable name="link24" select="$link20"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Résultats d’exécution du budget principal et des budgets des services non personnalisés'" /><xsl:with-param name="Param_1" select="$link21" /><xsl:with-param name="Param_2" select="$link22" /><xsl:with-param name="Param_3" select="$link23" /><xsl:with-param name="Param_4" select="$link24" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link25" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link26" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link27" select="'Liste des services individualisés dans un budget annexe'"/><xsl:variable name="link28" select="'LISTSRVINDIV'"/><xsl:variable name="link29" select="$link25"/><xsl:variable name="link30" select="$link26"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Liste des services individualisés dans un budget annexe'" /><xsl:with-param name="Param_1" select="$link27" /><xsl:with-param name="Param_2" select="$link28" /><xsl:with-param name="Param_3" select="$link29" /><xsl:with-param name="Param_4" select="$link30" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">D1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link31" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link32" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link33" select="'Détail des restes à réaliser - Dépenses'"/><xsl:variable name="link34" select="'RSTREALDEP'"/><xsl:variable name="link35" select="$link31"/><xsl:variable name="link36" select="$link32"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Détail des restes à réaliser - Dépenses'" /><xsl:with-param name="Param_1" select="$link33" /><xsl:with-param name="Param_2" select="$link34" /><xsl:with-param name="Param_3" select="$link35" /><xsl:with-param name="Param_4" select="$link36" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">D2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link37" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link38" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link39" select="'Détail des restes à réaliser - Recettes'"/><xsl:variable name="link40" select="'RSTREALREC'"/><xsl:variable name="link41" select="$link37"/><xsl:variable name="link42" select="$link38"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Détail des restes à réaliser - Recettes'" /><xsl:with-param name="Param_1" select="$link39" /><xsl:with-param name="Param_2" select="$link40" /><xsl:with-param name="Param_3" select="$link41" /><xsl:with-param name="Param_4" select="$link42" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">E</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link43" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link44" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link45" select="'Bilan synthétique'"/><xsl:variable name="link46" select="'BILANSYNTH'"/><xsl:variable name="link47" select="$link43"/><xsl:variable name="link48" select="$link44"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Bilan synthétique'" /><xsl:with-param name="Param_1" select="$link45" /><xsl:with-param name="Param_2" select="$link46" /><xsl:with-param name="Param_3" select="$link47" /><xsl:with-param name="Param_4" select="$link48" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">F</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link49" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link50" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link51" select="'Compte de résultat synthétique'"/><xsl:variable name="link52" select="'CPTRESSYNTH'"/><xsl:variable name="link53" select="$link49"/><xsl:variable name="link54" select="$link50"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Compte de résultat synthétique'" /><xsl:with-param name="Param_1" select="$link51" /><xsl:with-param name="Param_2" select="$link52" /><xsl:with-param name="Param_3" select="$link53" /><xsl:with-param name="Param_4" select="$link54" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">II. Exécution budgétaire</span></b></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link55" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link56" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link57" select="'Modalités de vote du budget'"/><xsl:variable name="link58" select="'MODVOTBDG'"/><xsl:variable name="link59" select="$link55"/><xsl:variable name="link60" select="$link56"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Modalités de vote du budget'" /><xsl:with-param name="Param_1" select="$link57" /><xsl:with-param name="Param_2" select="$link58" /><xsl:with-param name="Param_3" select="$link59" /><xsl:with-param name="Param_4" select="$link60" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><i><span style="font-size: 8.0pt;line-height:115%">Vue d'ensemble</span></i></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A1.1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link61" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link62" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link63" select="'Dépenses d’exploitation'"/><xsl:variable name="link64" select="'DEPEXP'"/><xsl:variable name="link65" select="$link61"/><xsl:variable name="link66" select="$link62"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Dépenses d’exploitation'" /><xsl:with-param name="Param_1" select="$link63" /><xsl:with-param name="Param_2" select="$link64" /><xsl:with-param name="Param_3" select="$link65" /><xsl:with-param name="Param_4" select="$link66" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A1.2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link67" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link68" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link69" select="'Recettes d’exploitation'"/><xsl:variable name="link70" select="'RECEXP'"/><xsl:variable name="link71" select="$link67"/><xsl:variable name="link72" select="$link68"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Recettes d’exploitation'" /><xsl:with-param name="Param_1" select="$link69" /><xsl:with-param name="Param_2" select="$link70" /><xsl:with-param name="Param_3" select="$link71" /><xsl:with-param name="Param_4" select="$link72" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A2.1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link73" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link74" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link75" select="'Dépenses d’investissement'"/><xsl:variable name="link76" select="'DEPINV'"/><xsl:variable name="link77" select="$link73"/><xsl:variable name="link78" select="$link74"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Dépenses d’investissement'" /><xsl:with-param name="Param_1" select="$link75" /><xsl:with-param name="Param_2" select="$link76" /><xsl:with-param name="Param_3" select="$link77" /><xsl:with-param name="Param_4" select="$link78" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A2.2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link79" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link80" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link81" select="'Recettes d’investissement'"/><xsl:variable name="link82" select="'RECINV'"/><xsl:variable name="link83" select="$link79"/><xsl:variable name="link84" select="$link80"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Recettes d’investissement'" /><xsl:with-param name="Param_1" select="$link81" /><xsl:with-param name="Param_2" select="$link82" /><xsl:with-param name="Param_3" select="$link83" /><xsl:with-param name="Param_4" select="$link84" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><i><span style="font-size: 8.0pt;line-height:115%">Vue détaillée</span></i></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link85" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link86" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link87" select="'Dépenses d’exploitation'"/><xsl:variable name="link88" select="'EXDEPEXP'"/><xsl:variable name="link89" select="$link85"/><xsl:variable name="link90" select="$link86"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Dépenses d’exploitation'" /><xsl:with-param name="Param_1" select="$link87" /><xsl:with-param name="Param_2" select="$link88" /><xsl:with-param name="Param_3" select="$link89" /><xsl:with-param name="Param_4" select="$link90" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link91" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link92" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link93" select="'Recettes d’exploitation'"/><xsl:variable name="link94" select="'EXRECEXP'"/><xsl:variable name="link95" select="$link91"/><xsl:variable name="link96" select="$link92"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Recettes d’exploitation'" /><xsl:with-param name="Param_1" select="$link93" /><xsl:with-param name="Param_2" select="$link94" /><xsl:with-param name="Param_3" select="$link95" /><xsl:with-param name="Param_4" select="$link96" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link97" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link98" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link99" select="'Dépenses d’investissement'"/><xsl:variable name="link100" select="'EXDEPINV'"/><xsl:variable name="link101" select="$link97"/><xsl:variable name="link102" select="$link98"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Dépenses d’investissement'" /><xsl:with-param name="Param_1" select="$link99" /><xsl:with-param name="Param_2" select="$link100" /><xsl:with-param name="Param_3" select="$link101" /><xsl:with-param name="Param_4" select="$link102" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link103" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link104" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link105" select="'Recettes d’investissement'"/><xsl:variable name="link106" select="'EXRECINV'"/><xsl:variable name="link107" select="$link103"/><xsl:variable name="link108" select="$link104"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Recettes d’investissement'" /><xsl:with-param name="Param_1" select="$link105" /><xsl:with-param name="Param_2" select="$link106" /><xsl:with-param name="Param_3" select="$link107" /><xsl:with-param name="Param_4" select="$link108" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">D1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link109" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link110" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link111" select="'Opérations d’équipement - Détail des chapitres et articles'"/><xsl:variable name="link112" select="'OPEEQUIP'"/><xsl:variable name="link113" select="$link109"/><xsl:variable name="link114" select="$link110"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Opérations d’équipement - Détail des chapitres et articles'" /><xsl:with-param name="Param_1" select="$link111" /><xsl:with-param name="Param_2" select="$link112" /><xsl:with-param name="Param_3" select="$link113" /><xsl:with-param name="Param_4" select="$link114" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">III. États financiers</span></b></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link115" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link116" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link117" select="'Bilan'"/><xsl:variable name="link118" select="'BILAN'"/><xsl:variable name="link119" select="$link115"/><xsl:variable name="link120" select="$link116"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Bilan'" /><xsl:with-param name="Param_1" select="$link117" /><xsl:with-param name="Param_2" select="$link118" /><xsl:with-param name="Param_3" select="$link119" /><xsl:with-param name="Param_4" select="$link120" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link121" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link122" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link123" select="'Compte de résultat'"/><xsl:variable name="link124" select="'CPTRES'"/><xsl:variable name="link125" select="$link121"/><xsl:variable name="link126" select="$link122"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Compte de résultat'" /><xsl:with-param name="Param_1" select="$link123" /><xsl:with-param name="Param_2" select="$link124" /><xsl:with-param name="Param_3" select="$link125" /><xsl:with-param name="Param_4" select="$link126" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link127" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link128" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link129" select="'Balance des comptes'"/><xsl:variable name="link130" select="'BALGE'"/><xsl:variable name="link131" select="$link127"/><xsl:variable name="link132" select="$link128"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Balance des comptes'" /><xsl:with-param name="Param_1" select="$link129" /><xsl:with-param name="Param_2" select="$link130" /><xsl:with-param name="Param_3" select="$link131" /><xsl:with-param name="Param_4" select="$link132" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%"><xsl:if test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:EtatsAnnexes/dc:EtatAnnexe/@IdentifiantAtlas"><xsl:variable name="link133" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:EtatsAnnexes/dc:EtatAnnexe/@IdentifiantAtlas"/><xsl:variable name="link134" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:EtatsAnnexes/dc:EtatAnnexe/@Extension"/><xsl:variable name="link135" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:EtatsAnnexes/dc:EtatAnnexe/@TypePJ"/><xsl:variable name="link136" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link137" select="$link133"/><xsl:variable name="link138" select="$link134"/><xsl:variable name="link139" select="$link135"/><xsl:variable name="link140" select="$link136"/><xsl:element name="a"><xsl:attribute name="href" select="com:etatsAnnexesFunction($link137, $link138, $link139, $link140)" /><xsl:value-of select="'IV. États annexés'" /></xsl:element></xsl:if><xsl:if test="not( $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:EtatsAnnexes/dc:EtatAnnexe/@IdentifiantAtlas)"><xsl:value-of select="'IV. États annexés'" /></xsl:if></span></b></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Présentation agrégée du budget principal et des budgets annexes</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><i><span style="font-size: 8.0pt;line-height:115%">B. États annexés patrimoniaux</span></i></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Détail des crédits de trésorerie</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Répartition par nature de dette</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.3</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Répartition des emprunts par structure de taux</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.4</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Typologie de la répartition de l'encours</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.5</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Détail des opérations de couverture</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.6</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Remboursement anticipé d'un emprunt avec refinancement</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.7</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Emprunts renégociés au cours de l'année N</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.8</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Autres dettes</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Méthodes utilisées pour les amortissements</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B3</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des provisions et des dépréciations</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B4</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des charges transférées</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B5</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Détail des opérations pour le compte de tiers</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B6.1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des emprunts garantis</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B6.2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Calcul du ratio d'endettement relatif aux emprunts garantis</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B7.1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Subventions versées dans le cadre du vote du budget</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B8.1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des contrats de crédit-bail</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B8.2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des marchés de partenariat</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B8.3</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des autres engagements donnés</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B8.4</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des engagements reçus</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B9.1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État du personnel</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B9.2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État du personnel de la collectivité ou de l’établissement de rattachement employé
                        par la régie</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B10</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Liste des organismes dans lesquels a été pris un engagement financier</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><i><span style="font-size: 8.0pt;line-height:115%">C. États annexés budgétaires</span></i></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C1.1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Équilibre budgétaire</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C1.2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Équilibre budgétaire - Dépenses</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C1.3</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Équilibre budgétaire - Recettes</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C2.1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Situation des autorisations de programme</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C2.2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Situation des autorisations d’engagement</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C3</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%;color:black">Impact du budget pour la transition écologique – répartition par nature</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><i><span style="font-size: 8.0pt;line-height:115%">D. Autres éléments d’information</span></i></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%;color:black">D1.1.1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de ventilation des dépenses et recettes des services d’eau et d’assainissement
                        - Exploitation</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%;color:black">D1.1.2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de ventilation des dépenses et recettes des services d’eau et d’assainissement
                        - Investissement</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%;color:black">D1.2.1</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de ventilation des dép. et rec. des services d’assainissement collectif et non
                        collectif - Exploitation</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%;color:black">D1.2.2</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de ventilation des dép. et rec. des services d’assainissement collectif et non
                        collectif - Investissement</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">V. Arrêté et signatures</span></b></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A</span></p>
               </td><td width="61%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link141" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link142" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link143" select="'Arrêté et signatures'"/><xsl:variable name="link144" select="'ARRESIGN'"/><xsl:variable name="link145" select="$link141"/><xsl:variable name="link146" select="$link142"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Arrêté et signatures'" /><xsl:with-param name="Param_1" select="$link143" /><xsl:with-param name="Param_2" select="$link144" /><xsl:with-param name="Param_3" select="$link145" /><xsl:with-param name="Param_4" select="$link146" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur / Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"> </td></tr><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center;page-break-after: avoid;punctuation-wrap:simple"><b><span style="font-size:8.0pt"></span></b><span style="font-size:12.0pt"><xsl:element name="span"><xsl:attribute name="id">BEC</xsl:attribute> </xsl:element>Balance et autres états comptables</span></p>
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"> </span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="91.4%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link147" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link148" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link149" select="'Balance des Valeurs Inactives'"/><xsl:variable name="link150" select="'ETATBVI'"/><xsl:variable name="link151" select="$link147"/><xsl:variable name="link152" select="$link148"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Balance des Valeurs Inactives'" /><xsl:with-param name="Param_1" select="$link149" /><xsl:with-param name="Param_2" select="$link150" /><xsl:with-param name="Param_3" select="$link151" /><xsl:with-param name="Param_4" select="$link152" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="91.4%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link153" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link154" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link155" select="'État de solde : Reste A Recouvrer'"/><xsl:variable name="link156" select="'ETATRAR'"/><xsl:variable name="link157" select="$link153"/><xsl:variable name="link158" select="$link154"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'État de solde : Reste A Recouvrer'" /><xsl:with-param name="Param_1" select="$link155" /><xsl:with-param name="Param_2" select="$link156" /><xsl:with-param name="Param_3" select="$link157" /><xsl:with-param name="Param_4" select="$link158" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="91.4%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link159" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link160" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link161" select="'État de solde : Reste A Payer'"/><xsl:variable name="link162" select="'ETATRAP'"/><xsl:variable name="link163" select="$link159"/><xsl:variable name="link164" select="$link160"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'État de solde : Reste A Payer'" /><xsl:with-param name="Param_1" select="$link161" /><xsl:with-param name="Param_2" select="$link162" /><xsl:with-param name="Param_3" select="$link163" /><xsl:with-param name="Param_4" select="$link164" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="91.4%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link165" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link166" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link167" select="'État de Développement Des Soldes'"/><xsl:variable name="link168" select="'ETATEDDS'"/><xsl:variable name="link169" select="$link165"/><xsl:variable name="link170" select="$link166"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'État de Développement Des Soldes'" /><xsl:with-param name="Param_1" select="$link167" /><xsl:with-param name="Param_2" select="$link168" /><xsl:with-param name="Param_3" select="$link169" /><xsl:with-param name="Param_4" select="$link170" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="91.4%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link171" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link172" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link173" select="'Fiches Budgétaires'"/><xsl:variable name="link174" select="'ETATFICBUDG'"/><xsl:variable name="link175" select="$link171"/><xsl:variable name="link176" select="$link172"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Fiches Budgétaires'" /><xsl:with-param name="Param_1" select="$link173" /><xsl:with-param name="Param_2" select="$link174" /><xsl:with-param name="Param_3" select="$link175" /><xsl:with-param name="Param_4" select="$link176" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="91.4%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link177" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link178" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link179" select="'Livre Auxiliaire des Comptes de Tiers et des comptes Financiers'"/><xsl:variable name="link180" select="'ETATLACTF'"/><xsl:variable name="link181" select="$link177"/><xsl:variable name="link182" select="$link178"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Livre Auxiliaire des Comptes de Tiers et des comptes Financiers'" /><xsl:with-param name="Param_1" select="$link179" /><xsl:with-param name="Param_2" select="$link180" /><xsl:with-param name="Param_3" select="$link181" /><xsl:with-param name="Param_4" select="$link182" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="91.4%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link183" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link184" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link185" select="'État des Ordres de Paiement Comptable'"/><xsl:variable name="link186" select="'ETATOPC'"/><xsl:variable name="link187" select="$link183"/><xsl:variable name="link188" select="$link184"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'État des Ordres de Paiement Comptable'" /><xsl:with-param name="Param_1" select="$link185" /><xsl:with-param name="Param_2" select="$link186" /><xsl:with-param name="Param_3" select="$link187" /><xsl:with-param name="Param_4" select="$link188" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"> </td></tr><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center;page-break-after: avoid;punctuation-wrap:simple"><b><span style="font-size:8.0pt"></span></b><span style="font-size:12.0pt"><xsl:element name="span"><xsl:attribute name="id">DB</xsl:attribute> </xsl:element>Liens vers les Documents Budgétaires</span></p>
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"> </span></p>
               </td></tr><xsl:for-each select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:DocumentBudgetaires/dc:DocumentBudgetaire"><xsl:variable name="bclBloc_DCPT_ETT_SP_DB_DB_1" select="."></xsl:variable><tr xmlns:odm="http://www.axyus.com/2010/odm" style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="91.4%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"></span></p></td></tr><xsl:for-each select="$bclBloc_DCPT_ETT_SP_DB_DB_1/dc:ElementDocumentBudgetaire"><xsl:variable name="bclBloc_DCPT_ETT_SP_DB_DB_EDB_2" select="."></xsl:variable><tr xmlns:odm="http://www.axyus.com/2010/odm" style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="91.4%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"> <xsl:variable name="link189" select="$bclBloc_DCPT_ETT_SP_DB_DB_1[(./dc:ElementDocumentBudgetaire=$bclBloc_DCPT_ETT_SP_DB_DB_EDB_2)]/@Siret"/><xsl:variable name="link190" select="$bclBloc_DCPT_ETT_SP_DB_DB_EDB_2/@IdentifiantPJ"/><xsl:variable name="link191" select="$bclBloc_DCPT_ETT_SP_DB_DB_EDB_2/@LibelleDocument"/><xsl:variable name="link192" select="$bclBloc_DCPT_ETT_SP_DB_DB_EDB_2/@NumeroDecision"/><xsl:variable name="link193" select="$link189"/><xsl:variable name="link194" select="$link190"/><xsl:variable name="link195" select="$link191"/><xsl:variable name="link196" select="$link192"/><xsl:variable name="text7"><xsl:value-of select="distinct-values($bclBloc_DCPT_ETT_SP_DB_DB_EDB_2/@LibelleDocument)"/></xsl:variable><xsl:variable name="text8"><xsl:value-of select="distinct-values($bclBloc_DCPT_ETT_SP_DB_DB_EDB_2/@IdentifiantPJ)"/></xsl:variable><xsl:element name="a"><xsl:attribute name="href" select="com:documentBudgetaireFunction($link193, $link194, $link195, $link196)" /><xsl:value-of select="concat ($text7, ' ', $text8)" /></xsl:element></span></p></td></tr></xsl:for-each></xsl:for-each><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"> </td></tr><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center;page-break-after: avoid;punctuation-wrap:simple"><b><span style="font-size:8.0pt"></span></b><span style="font-size:12.0pt"><xsl:element name="span"><xsl:attribute name="id">ADD</xsl:attribute> </xsl:element>Autres documents dématérialisés</span></p>
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"> </span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="91.4%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:if test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:AutresDocumentsDematerialises/dc:DocumentOrmc/@NomListeOrmc"><xsl:variable name="link197" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link198" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link199" select="'ORMC'"/><xsl:variable name="link200" select="'ETATORMC'"/><xsl:variable name="link201" select="$link197"/><xsl:variable name="link202" select="$link198"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'ORMC'" /><xsl:with-param name="Param_1" select="$link199" /><xsl:with-param name="Param_2" select="$link200" /><xsl:with-param name="Param_3" select="$link201" /><xsl:with-param name="Param_4" select="$link202" /></xsl:call-template></xsl:if></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="91.4%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:if test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:AutresDocumentsDematerialises/dc:DocumentOpo/@NomListeOpo"><xsl:variable name="link203" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link204" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link205" select="'Ordres de Paiement Ordonnateur'"/><xsl:variable name="link206" select="'ETATOPO'"/><xsl:variable name="link207" select="$link203"/><xsl:variable name="link208" select="$link204"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Ordres de Paiement Ordonnateur'" /><xsl:with-param name="Param_1" select="$link205" /><xsl:with-param name="Param_2" select="$link206" /><xsl:with-param name="Param_3" select="$link207" /><xsl:with-param name="Param_4" select="$link208" /></xsl:call-template></xsl:if></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="91.4%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:if test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:AutresDocumentsDematerialises/dc:DocumentOro/@NomListeOro"><xsl:variable name="link209" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link210" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link211" select="'Ordres de Recette Ordonnateur'"/><xsl:variable name="link212" select="'ETATORO'"/><xsl:variable name="link213" select="$link209"/><xsl:variable name="link214" select="$link210"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Ordres de Recette Ordonnateur'" /><xsl:with-param name="Param_1" select="$link211" /><xsl:with-param name="Param_2" select="$link212" /><xsl:with-param name="Param_3" select="$link213" /><xsl:with-param name="Param_4" select="$link214" /></xsl:call-template></xsl:if></span></p></td></tr><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"> </td></tr></table></xsl:variable><xsl:if test="$HTML_OUTPUT_FORMAT and $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:LigneSommairePlus/@RefEtat = 'BALGE.xsl'"><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau5"></xsl:with-param></xsl:call-template></xsl:if>
         <xsl:variable name="tableau6"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="26.5%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:8.0pt"></span></b></p>
               </td><td width="48%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="25.5%" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_ARRESIGN, '_1')" /><xsl:attribute name="href" select="concat('#Page_', $p_ARRESIGN, '_1')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Arrêté et signatures'" /></xsl:element></span></p>
               </td></tr><tr><td width="26.5%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="48%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="25.5%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_ETATCTRLCPT, '_2')" /><xsl:attribute name="href" select="concat('#Page_', $p_ETATCTRLCPT, '_2')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'ECCF'" /></xsl:element></span></p>
               </td></tr></table></xsl:variable><xsl:if test="$PDF_OUTPUT_FORMAT and $docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable/dc:MtBalEntreeCre/@V"><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau6"></xsl:with-param></xsl:call-template></xsl:if>
         <xsl:variable name="tableau7"><table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style=""><thead>
               <tr style="height:.3pt"><td width="65.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1">
                     <p class="Contenudetableau"><b><span style="font-size:8.0pt"></span></b></p>
                  </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                     <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">Origine des données</span></p>
                  </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height: .3pt" rowspan="1" colspan="1">
                     <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">Page</span></p>
                  </td></tr>
            </thead><tr style="height:.3pt"><td width="9.1%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt">I. Informations générales et synthétiques</span></b></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_PRESGENCPT, '_3')" /><xsl:attribute name="href" select="concat('#Page_', $p_PRESGENCPT, '_3')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Présentation générale du compte financier - Vue d’ensemble'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_PRESGENCPT" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_RESEXEC, '_4')" /><xsl:attribute name="href" select="concat('#Page_', $p_RESEXEC, '_4')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Résultats d’exécution du budget principal et des budgets des services non personnalisés'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_RESEXEC" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_LISTSRVINDIV, '_5')" /><xsl:attribute name="href" select="concat('#Page_', $p_LISTSRVINDIV, '_5')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Liste des services individualisés dans un budget annexe'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_LISTSRVINDIV" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_RSTREALDEP, '_6')" /><xsl:attribute name="href" select="concat('#Page_', $p_RSTREALDEP, '_6')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Détail des restes à réaliser - Dépenses'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span lang="EN-US" style="font-size:8.0pt"><xsl:value-of select="$p_RSTREALDEP" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_RSTREALREC, '_7')" /><xsl:attribute name="href" select="concat('#Page_', $p_RSTREALREC, '_7')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Détail des restes à réaliser - Recettes'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span lang="EN-US" style="font-size:8.0pt"><xsl:value-of select="$p_RSTREALREC" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">E</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_BILANSYNTH, '_8')" /><xsl:attribute name="href" select="concat('#Page_', $p_BILANSYNTH, '_8')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Bilan synthétique'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_BILANSYNTH" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">F</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_CPTRESSYNTH, '_9')" /><xsl:attribute name="href" select="concat('#Page_', $p_CPTRESSYNTH, '_9')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Compte de résultat synthétique'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_CPTRESSYNTH" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt">II. Exécution budgétaire</span></b></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_MODVOTBDG, '_10')" /><xsl:attribute name="href" select="concat('#Page_', $p_MODVOTBDG, '_10')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Modalités de vote du budget'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_MODVOTBDG" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><i><span style="font-size:8.0pt">Vue d'ensemble</span></i></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_DEPEXP, '_11')" /><xsl:attribute name="href" select="concat('#Page_', $p_DEPEXP, '_11')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Dépenses d’exploitation'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_DEPEXP" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_RECEXP, '_12')" /><xsl:attribute name="href" select="concat('#Page_', $p_RECEXP, '_12')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Recettes d’exploitation'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_RECEXP" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_DEPINV, '_13')" /><xsl:attribute name="href" select="concat('#Page_', $p_DEPINV, '_13')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Dépenses d’investissement'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_DEPINV" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_RECINV, '_14')" /><xsl:attribute name="href" select="concat('#Page_', $p_RECINV, '_14')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Recettes d’investissement'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_RECINV" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><i><span style="font-size:8.0pt">Vue détaillée</span></i></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_EXDEPEXP, '_15')" /><xsl:attribute name="href" select="concat('#Page_', $p_EXDEPEXP, '_15')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Dépenses d’exploitation'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_EXDEPEXP" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_EXRECEXP, '_16')" /><xsl:attribute name="href" select="concat('#Page_', $p_EXRECEXP, '_16')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Recettes d’exploitation'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_EXRECEXP" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_EXDEPINV, '_17')" /><xsl:attribute name="href" select="concat('#Page_', $p_EXDEPINV, '_17')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Dépenses d’investissement'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_EXDEPINV" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_EXRECINV, '_18')" /><xsl:attribute name="href" select="concat('#Page_', $p_EXRECINV, '_18')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Recettes d’investissement'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_EXRECINV" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_OPEEQUIP, '_19')" /><xsl:attribute name="href" select="concat('#Page_', $p_OPEEQUIP, '_19')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Opérations d’équipement - Détail des chapitres et articles'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span lang="EN-US" style="font-size:8.0pt"><xsl:value-of select="$p_OPEEQUIP" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt">III. États financiers</span></b></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_BILAN, '_20')" /><xsl:attribute name="href" select="concat('#Page_', $p_BILAN, '_20')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Bilan'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_BILAN" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_CPTRES, '_21')" /><xsl:attribute name="href" select="concat('#Page_', $p_CPTRES, '_21')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Compte de résultat'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_CPTRES" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_BALGE, '_22')" /><xsl:attribute name="href" select="concat('#Page_', $p_BALGE, '_22')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Balance des comptes'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_BALGE" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt">IV. États annexés</span></b></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation agrégée du budget principal et des budgets annexes</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><i><span style="font-size:8.0pt">B. États annexés patrimoniaux</span></i></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Détail des crédits de trésorerie</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Répartition par nature de dette</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.3</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Répartition des emprunts par structure de taux</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.4</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Typologie de la répartition de l'encours</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.5</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Détail des opérations de couverture</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.6</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Remboursement anticipé d'un emprunt avec refinancement</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.7</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Emprunts renégociés au cours de l'année N</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.8</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Autres dettes</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Méthodes utilisées pour les amortissements</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B3</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des provisions et des dépréciations</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B4</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des charges transférées</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B5</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Détail des opérations pour le compte de tiers</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B6.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des emprunts garantis</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B6.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Calcul du ratio d'endettement relatif aux emprunts garantis</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B7.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Subventions versées dans le cadre du vote du budget</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des contrats de crédit-bail</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des marchés de partenariat</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.3</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des autres engagements donnés</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.4</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des engagements reçus</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B9.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État du personnel</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B9.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État du personnel de la collectivité ou de l’établissement de rattachement employé
                        par la régie</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B10</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des organismes dans lesquels a été pris un engagement financier</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><i><span style="font-size:8.0pt">C. États annexés budgétaires</span></i></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire - Dépenses</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.3</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire - Recettes</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Situation des autorisations de programme</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Situation des autorisations d’engagement</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C3</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt;color:black">Impact du budget pour la transition écologique – répartition par nature</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><i><span style="font-size:8.0pt">D. Autres éléments d’information</span></i></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D1.1.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de ventilation des dépenses et recettes des services d’eau et d’assainissement
                        - Exploitation</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D1.1.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de ventilation des dépenses et recettes des services d’eau et d’assainissement
                        - Investissement</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D1.2.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de ventilation des dép. et rec. des services d’assainissement collectif et non
                        collectif - Exploitation</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D1.2.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de ventilation des dép. et rec. des services d’assainissement collectif et non
                        collectif - Investissement</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt">V. Arrêté et signatures</span></b></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_ARRESIGN, '_23')" /><xsl:attribute name="href" select="concat('#Page_', $p_ARRESIGN, '_23')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Arrêté et signatures'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur / Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span lang="EN-US" style="font-size:8.0pt"><xsl:value-of select="$p_ARRESIGN" /></span></p></td></tr></table></xsl:variable><xsl:if test="$PDF_OUTPUT_FORMAT and $docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable/dc:MtBalEntreeCre/@V"><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau7"></xsl:with-param></xsl:call-template></xsl:if>
         <xsl:variable name="tableau8"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="39.4%" colspan="2" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="EN-US" style="font-size:8.0pt"></span></b></p>
               </td><td width="60.6%" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p class="Contenudetableau" align="right" style="text-align:right"><span lang="EN-US" style="font-size:8.0pt"><xsl:variable name="link215" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link216" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link217" select="'Arrêté et signatures'"/><xsl:variable name="link218" select="'ARRESIGN'"/><xsl:variable name="link219" select="$link215"/><xsl:variable name="link220" select="$link216"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Arrêté et signatures'" /><xsl:with-param name="Param_1" select="$link217" /><xsl:with-param name="Param_2" select="$link218" /><xsl:with-param name="Param_3" select="$link219" /><xsl:with-param name="Param_4" select="$link220" /></xsl:call-template></span></p></td></tr><tr><td width="19.2%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="20.2%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="60.6%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1"><p class="MsoNormal" align="right" style="text-align:right"><span lang="EN-US" style="font-size:8.0pt"><xsl:variable name="link221" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link222" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link223" select="'ECCF'"/><xsl:variable name="link224" select="'ETATCTRLCPT'"/><xsl:variable name="link225" select="$link221"/><xsl:variable name="link226" select="$link222"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'ECCF'" /><xsl:with-param name="Param_1" select="$link223" /><xsl:with-param name="Param_2" select="$link224" /><xsl:with-param name="Param_3" select="$link225" /><xsl:with-param name="Param_4" select="$link226" /></xsl:call-template></span></p></td></tr></table></xsl:variable><xsl:if test="$HTML_OUTPUT_FORMAT and not( $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:LigneSommairePlus/@RefEtat = 'BALGE.xsl')"><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau8"></xsl:with-param></xsl:call-template></xsl:if>
         <xsl:variable name="tableau9"><table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style=""><thead><tr style="height:.3pt"><td width="64.8%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1">
                     <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b><span lang="EN-US" style="font-size:8.0pt;line-height:115%"></span></b></p>
                  </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                     <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">Origine des données</span></p>
                  </td></tr></thead><tr style="height:.3pt"><td width="8.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61.9%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">I. Informations générales et synthétiques</span></b></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link227" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link228" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link229" select="'Présentation générale du compte financier - Vue d’ensemble'"/><xsl:variable name="link230" select="'PRESGENCPT'"/><xsl:variable name="link231" select="$link227"/><xsl:variable name="link232" select="$link228"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Présentation générale du compte financier - Vue d’ensemble'" /><xsl:with-param name="Param_1" select="$link229" /><xsl:with-param name="Param_2" select="$link230" /><xsl:with-param name="Param_3" select="$link231" /><xsl:with-param name="Param_4" select="$link232" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link233" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link234" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link235" select="'Détermination du résultat cumulé à la fin de l’exercice'"/><xsl:variable name="link236" select="'RESCUMUL'"/><xsl:variable name="link237" select="$link233"/><xsl:variable name="link238" select="$link234"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Détermination du résultat cumulé à la fin de l’exercice'" /><xsl:with-param name="Param_1" select="$link235" /><xsl:with-param name="Param_2" select="$link236" /><xsl:with-param name="Param_3" select="$link237" /><xsl:with-param name="Param_4" select="$link238" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link239" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link240" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link241" select="'Liste des services individualisés dans un budget annexe'"/><xsl:variable name="link242" select="'LISTSRVINDIV'"/><xsl:variable name="link243" select="$link239"/><xsl:variable name="link244" select="$link240"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Liste des services individualisés dans un budget annexe'" /><xsl:with-param name="Param_1" select="$link241" /><xsl:with-param name="Param_2" select="$link242" /><xsl:with-param name="Param_3" select="$link243" /><xsl:with-param name="Param_4" select="$link244" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">D1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link245" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link246" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link247" select="'Détail des restes à réaliser - Dépenses'"/><xsl:variable name="link248" select="'RSTREALDEP'"/><xsl:variable name="link249" select="$link245"/><xsl:variable name="link250" select="$link246"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Détail des restes à réaliser - Dépenses'" /><xsl:with-param name="Param_1" select="$link247" /><xsl:with-param name="Param_2" select="$link248" /><xsl:with-param name="Param_3" select="$link249" /><xsl:with-param name="Param_4" select="$link250" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">D2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link251" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link252" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link253" select="'Détail des restes à réaliser - Recettes'"/><xsl:variable name="link254" select="'RSTREALREC'"/><xsl:variable name="link255" select="$link251"/><xsl:variable name="link256" select="$link252"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Détail des restes à réaliser - Recettes'" /><xsl:with-param name="Param_1" select="$link253" /><xsl:with-param name="Param_2" select="$link254" /><xsl:with-param name="Param_3" select="$link255" /><xsl:with-param name="Param_4" select="$link256" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">E</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link257" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link258" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link259" select="'Bilan synthétique'"/><xsl:variable name="link260" select="'BILANSYNTH'"/><xsl:variable name="link261" select="$link257"/><xsl:variable name="link262" select="$link258"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Bilan synthétique'" /><xsl:with-param name="Param_1" select="$link259" /><xsl:with-param name="Param_2" select="$link260" /><xsl:with-param name="Param_3" select="$link261" /><xsl:with-param name="Param_4" select="$link262" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">F</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link263" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link264" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link265" select="'Compte de résultat synthétique'"/><xsl:variable name="link266" select="'CPTRESSYNTH'"/><xsl:variable name="link267" select="$link263"/><xsl:variable name="link268" select="$link264"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Compte de résultat synthétique'" /><xsl:with-param name="Param_1" select="$link265" /><xsl:with-param name="Param_2" select="$link266" /><xsl:with-param name="Param_3" select="$link267" /><xsl:with-param name="Param_4" select="$link268" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61.9%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">II. Exécution budgétaire</span></b></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link269" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link270" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link271" select="'Modalités de vote du budget'"/><xsl:variable name="link272" select="'MODVOTBDG'"/><xsl:variable name="link273" select="$link269"/><xsl:variable name="link274" select="$link270"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Modalités de vote du budget'" /><xsl:with-param name="Param_1" select="$link271" /><xsl:with-param name="Param_2" select="$link272" /><xsl:with-param name="Param_3" select="$link273" /><xsl:with-param name="Param_4" select="$link274" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61.9%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><i><span style="font-size: 8.0pt;line-height:115%">Vue d'ensemble</span></i></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A1.1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link275" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link276" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link277" select="'Dépenses d’exploitation'"/><xsl:variable name="link278" select="'DEPEXP'"/><xsl:variable name="link279" select="$link275"/><xsl:variable name="link280" select="$link276"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Dépenses d’exploitation'" /><xsl:with-param name="Param_1" select="$link277" /><xsl:with-param name="Param_2" select="$link278" /><xsl:with-param name="Param_3" select="$link279" /><xsl:with-param name="Param_4" select="$link280" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A1.2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link281" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link282" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link283" select="'Recettes d’exploitation'"/><xsl:variable name="link284" select="'RECEXP'"/><xsl:variable name="link285" select="$link281"/><xsl:variable name="link286" select="$link282"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Recettes d’exploitation'" /><xsl:with-param name="Param_1" select="$link283" /><xsl:with-param name="Param_2" select="$link284" /><xsl:with-param name="Param_3" select="$link285" /><xsl:with-param name="Param_4" select="$link286" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A2.1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link287" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link288" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link289" select="'Dépenses d’investissement'"/><xsl:variable name="link290" select="'DEPINV'"/><xsl:variable name="link291" select="$link287"/><xsl:variable name="link292" select="$link288"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Dépenses d’investissement'" /><xsl:with-param name="Param_1" select="$link289" /><xsl:with-param name="Param_2" select="$link290" /><xsl:with-param name="Param_3" select="$link291" /><xsl:with-param name="Param_4" select="$link292" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A2.2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link293" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link294" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link295" select="'Recettes d’investissement'"/><xsl:variable name="link296" select="'RECINV'"/><xsl:variable name="link297" select="$link293"/><xsl:variable name="link298" select="$link294"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Recettes d’investissement'" /><xsl:with-param name="Param_1" select="$link295" /><xsl:with-param name="Param_2" select="$link296" /><xsl:with-param name="Param_3" select="$link297" /><xsl:with-param name="Param_4" select="$link298" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61.9%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><i><span style="font-size: 8.0pt;line-height:115%">Vue détaillée</span></i></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link299" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link300" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link301" select="'Dépenses d’exploitation'"/><xsl:variable name="link302" select="'EXDEPEXP'"/><xsl:variable name="link303" select="$link299"/><xsl:variable name="link304" select="$link300"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Dépenses d’exploitation'" /><xsl:with-param name="Param_1" select="$link301" /><xsl:with-param name="Param_2" select="$link302" /><xsl:with-param name="Param_3" select="$link303" /><xsl:with-param name="Param_4" select="$link304" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link305" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link306" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link307" select="'Recettes d’exploitation'"/><xsl:variable name="link308" select="'EXRECEXP'"/><xsl:variable name="link309" select="$link305"/><xsl:variable name="link310" select="$link306"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Recettes d’exploitation'" /><xsl:with-param name="Param_1" select="$link307" /><xsl:with-param name="Param_2" select="$link308" /><xsl:with-param name="Param_3" select="$link309" /><xsl:with-param name="Param_4" select="$link310" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link311" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link312" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link313" select="'Dépenses d’investissement'"/><xsl:variable name="link314" select="'EXDEPINV'"/><xsl:variable name="link315" select="$link311"/><xsl:variable name="link316" select="$link312"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Dépenses d’investissement'" /><xsl:with-param name="Param_1" select="$link313" /><xsl:with-param name="Param_2" select="$link314" /><xsl:with-param name="Param_3" select="$link315" /><xsl:with-param name="Param_4" select="$link316" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link317" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link318" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link319" select="'Recettes d’investissement'"/><xsl:variable name="link320" select="'EXRECINV'"/><xsl:variable name="link321" select="$link317"/><xsl:variable name="link322" select="$link318"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Recettes d’investissement'" /><xsl:with-param name="Param_1" select="$link319" /><xsl:with-param name="Param_2" select="$link320" /><xsl:with-param name="Param_3" select="$link321" /><xsl:with-param name="Param_4" select="$link322" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">D1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link323" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link324" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link325" select="'Opérations d’équipement - Détail des chapitres et articles'"/><xsl:variable name="link326" select="'OPEEQUIP'"/><xsl:variable name="link327" select="$link323"/><xsl:variable name="link328" select="$link324"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Opérations d’équipement - Détail des chapitres et articles'" /><xsl:with-param name="Param_1" select="$link325" /><xsl:with-param name="Param_2" select="$link326" /><xsl:with-param name="Param_3" select="$link327" /><xsl:with-param name="Param_4" select="$link328" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61.9%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">III. États financiers</span></b></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link329" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link330" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link331" select="'Bilan'"/><xsl:variable name="link332" select="'BILAN'"/><xsl:variable name="link333" select="$link329"/><xsl:variable name="link334" select="$link330"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Bilan'" /><xsl:with-param name="Param_1" select="$link331" /><xsl:with-param name="Param_2" select="$link332" /><xsl:with-param name="Param_3" select="$link333" /><xsl:with-param name="Param_4" select="$link334" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link335" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link336" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link337" select="'Compte de résultat'"/><xsl:variable name="link338" select="'CPTRES'"/><xsl:variable name="link339" select="$link335"/><xsl:variable name="link340" select="$link336"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Compte de résultat'" /><xsl:with-param name="Param_1" select="$link337" /><xsl:with-param name="Param_2" select="$link338" /><xsl:with-param name="Param_3" select="$link339" /><xsl:with-param name="Param_4" select="$link340" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61.9%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%"><xsl:if test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:EtatsAnnexes/dc:EtatAnnexe/@IdentifiantAtlas"><xsl:variable name="link341" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:EtatsAnnexes/dc:EtatAnnexe/@IdentifiantAtlas"/><xsl:variable name="link342" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:EtatsAnnexes/dc:EtatAnnexe/@Extension"/><xsl:variable name="link343" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:EtatsAnnexes/dc:EtatAnnexe/@TypePJ"/><xsl:variable name="link344" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link345" select="$link341"/><xsl:variable name="link346" select="$link342"/><xsl:variable name="link347" select="$link343"/><xsl:variable name="link348" select="$link344"/><xsl:element name="a"><xsl:attribute name="href" select="com:etatsAnnexesFunction($link345, $link346, $link347, $link348)" /><xsl:value-of select="'IV. États annexés'" /></xsl:element></xsl:if><xsl:if test="not( $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:EtatsAnnexes/dc:EtatAnnexe/@IdentifiantAtlas)"><xsl:value-of select="'IV. États annexés'" /></xsl:if></span></b></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Présentation agrégée du budget principal et des budgets annexes</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61.9%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><i><span style="font-size: 8.0pt;line-height:115%">B. États annexés patrimoniaux</span></i></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Détail des crédits de trésorerie</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Répartition par nature de dette</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.3</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Répartition par structure de taux</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.4</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Typologie de la répartition de l'encours</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.5</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Détail des opérations de couverture</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.6</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Remboursement anticipé d'un emprunt avec refinancement</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.7</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Emprunts renégociés au cours de l'année N</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B1.9</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de la dette - Autres dettes</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Méthodes utilisées pour les amortissements</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B3.1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des provisions et des dépréciations</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B4</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des charges transférées</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B5</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Détail des opérations pour le compte de tiers</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B7.1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des emprunts garantis</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B7.2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Calcul du ratio d'endettement relatif aux emprunts garantis</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B8.1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Subventions versées dans le cadre du vote du budget</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B8.2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des contrats de crédit-bail</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B8.3</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des contrats de partenariat public-privé</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B8.4</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des autres engagements donnés</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B8.5</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État des engagements reçus</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B9</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État du personnel</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B9.2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État du personnel de la collectivité ou de l’établissement de rattachement employé
                        par la régie</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">B10</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Liste des organismes dans lesquels a été pris un engagement financier</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61.9%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><i><span style="font-size: 8.0pt;line-height:115%">C. États annexés budgétaires</span></i></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C1.1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Équilibre budgétaire - Dépenses</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C1.2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Équilibre budgétaire - Recettes</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C2.1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Situation des autorisations de programme</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">C2.2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Situation des autorisations d’engagement</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61.9%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><i><span style="font-size: 8.0pt;line-height:115%">D. Autres éléments d’information</span></i></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%;color:black">D1.1.1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de ventilation des dépenses et recettes des services d’eau et d’assainissement
                        - Exploitation</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%;color:black">D1.1.2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de ventilation des dépenses et recettes des services d’eau et d’assainissement
                        - Investissement</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%;color:black">D1.2.1</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de ventilation des dép. et rec. des services d’assainissement collectif et non
                        collectif - Exploitation</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%;color:black">D1.2.2</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">État de ventilation des dép. et rec. des services d’assainissement collectif et non
                        collectif - Investissement</span></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="61.9%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%">V. Arrêté et signatures</span></b></p>
               </td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="font-size:8.0pt;line-height:115%">A</span></p>
               </td><td width="61.9%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link349" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link350" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link351" select="'Arrêté et signatures'"/><xsl:variable name="link352" select="'ARRESIGN'"/><xsl:variable name="link353" select="$link349"/><xsl:variable name="link354" select="$link350"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Arrêté et signatures'" /><xsl:with-param name="Param_1" select="$link351" /><xsl:with-param name="Param_2" select="$link352" /><xsl:with-param name="Param_3" select="$link353" /><xsl:with-param name="Param_4" select="$link354" /></xsl:call-template></span></p></td><td width="29.5%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%">Ordonnateur / Comptable</span></p>
               </td></tr><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"> </td></tr><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center;page-break-after: avoid;punctuation-wrap:simple"><b><span style="font-size:8.0pt"></span></b><span style="font-size:12.0pt"><xsl:element name="span"><xsl:attribute name="id">BEC</xsl:attribute> </xsl:element>Balance et autres états comptables</span></p>
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"> </span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link355" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link356" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link357" select="'Balance Générale des Comptes'"/><xsl:variable name="link358" select="'BALGENCPT'"/><xsl:variable name="link359" select="$link355"/><xsl:variable name="link360" select="$link356"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Balance Générale des Comptes'" /><xsl:with-param name="Param_1" select="$link357" /><xsl:with-param name="Param_2" select="$link358" /><xsl:with-param name="Param_3" select="$link359" /><xsl:with-param name="Param_4" select="$link360" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link361" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link362" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link363" select="'Balance des Valeurs Inactives'"/><xsl:variable name="link364" select="'ETATBVI'"/><xsl:variable name="link365" select="$link361"/><xsl:variable name="link366" select="$link362"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Balance des Valeurs Inactives'" /><xsl:with-param name="Param_1" select="$link363" /><xsl:with-param name="Param_2" select="$link364" /><xsl:with-param name="Param_3" select="$link365" /><xsl:with-param name="Param_4" select="$link366" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link367" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link368" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link369" select="'État de solde : Reste A Recouvrer'"/><xsl:variable name="link370" select="'ETATRAR'"/><xsl:variable name="link371" select="$link367"/><xsl:variable name="link372" select="$link368"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'État de solde : Reste A Recouvrer'" /><xsl:with-param name="Param_1" select="$link369" /><xsl:with-param name="Param_2" select="$link370" /><xsl:with-param name="Param_3" select="$link371" /><xsl:with-param name="Param_4" select="$link372" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link373" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link374" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link375" select="'État de solde : Reste A Payer'"/><xsl:variable name="link376" select="'ETATRAP'"/><xsl:variable name="link377" select="$link373"/><xsl:variable name="link378" select="$link374"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'État de solde : Reste A Payer'" /><xsl:with-param name="Param_1" select="$link375" /><xsl:with-param name="Param_2" select="$link376" /><xsl:with-param name="Param_3" select="$link377" /><xsl:with-param name="Param_4" select="$link378" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link379" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link380" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link381" select="'État de Développement Des Soldes'"/><xsl:variable name="link382" select="'ETATEDDS'"/><xsl:variable name="link383" select="$link379"/><xsl:variable name="link384" select="$link380"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'État de Développement Des Soldes'" /><xsl:with-param name="Param_1" select="$link381" /><xsl:with-param name="Param_2" select="$link382" /><xsl:with-param name="Param_3" select="$link383" /><xsl:with-param name="Param_4" select="$link384" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link385" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link386" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link387" select="'Fiches Budgétaires'"/><xsl:variable name="link388" select="'ETATFICBUDG'"/><xsl:variable name="link389" select="$link385"/><xsl:variable name="link390" select="$link386"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Fiches Budgétaires'" /><xsl:with-param name="Param_1" select="$link387" /><xsl:with-param name="Param_2" select="$link388" /><xsl:with-param name="Param_3" select="$link389" /><xsl:with-param name="Param_4" select="$link390" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link391" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link392" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link393" select="'Livre Auxiliaire des Comptes de Tiers et des comptes Financiers'"/><xsl:variable name="link394" select="'ETATLACTF'"/><xsl:variable name="link395" select="$link391"/><xsl:variable name="link396" select="$link392"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Livre Auxiliaire des Comptes de Tiers et des comptes Financiers'" /><xsl:with-param name="Param_1" select="$link393" /><xsl:with-param name="Param_2" select="$link394" /><xsl:with-param name="Param_3" select="$link395" /><xsl:with-param name="Param_4" select="$link396" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:variable name="link397" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link398" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link399" select="'État des Ordres de Paiement Comptable'"/><xsl:variable name="link400" select="'ETATOPC'"/><xsl:variable name="link401" select="$link397"/><xsl:variable name="link402" select="$link398"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'État des Ordres de Paiement Comptable'" /><xsl:with-param name="Param_1" select="$link399" /><xsl:with-param name="Param_2" select="$link400" /><xsl:with-param name="Param_3" select="$link401" /><xsl:with-param name="Param_4" select="$link402" /></xsl:call-template></span></p></td></tr><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"> </td></tr><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center;page-break-after: avoid;punctuation-wrap:simple"><b><span style="font-size:8.0pt"></span></b><span style="font-size:12.0pt"><xsl:element name="span"><xsl:attribute name="id">DB</xsl:attribute> </xsl:element>Liens vers les Documents Budgétaires</span></p>
                  <p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"> </span></p>
               </td></tr><xsl:for-each select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:DocumentBudgetaires/dc:DocumentBudgetaire"><xsl:variable name="bclBloc_DCPT_ETT_SP_DB_DB_3" select="."></xsl:variable><tr xmlns:odm="http://www.axyus.com/2010/odm" style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"></span></p></td></tr><xsl:for-each select="$bclBloc_DCPT_ETT_SP_DB_DB_3/dc:ElementDocumentBudgetaire"><xsl:variable name="bclBloc_DCPT_ETT_SP_DB_DB_EDB_4" select="."></xsl:variable><tr xmlns:odm="http://www.axyus.com/2010/odm" style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"> <xsl:variable name="link403" select="$bclBloc_DCPT_ETT_SP_DB_DB_3[(./dc:ElementDocumentBudgetaire=$bclBloc_DCPT_ETT_SP_DB_DB_EDB_4)]/@Siret"/><xsl:variable name="link404" select="$bclBloc_DCPT_ETT_SP_DB_DB_EDB_4/@IdentifiantPJ"/><xsl:variable name="link405" select="$bclBloc_DCPT_ETT_SP_DB_DB_EDB_4/@LibelleDocument"/><xsl:variable name="link406" select="$bclBloc_DCPT_ETT_SP_DB_DB_EDB_4/@NumeroDecision"/><xsl:variable name="link407" select="$link403"/><xsl:variable name="link408" select="$link404"/><xsl:variable name="link409" select="$link405"/><xsl:variable name="link410" select="$link406"/><xsl:variable name="text9"><xsl:value-of select="distinct-values($bclBloc_DCPT_ETT_SP_DB_DB_EDB_4/@LibelleDocument)"/></xsl:variable><xsl:variable name="text10"><xsl:value-of select="distinct-values($bclBloc_DCPT_ETT_SP_DB_DB_EDB_4/@IdentifiantPJ)"/></xsl:variable><xsl:element name="a"><xsl:attribute name="href" select="com:documentBudgetaireFunction($link407, $link408, $link409, $link410)" /><xsl:value-of select="concat ($text9, ' ', $text10)" /></xsl:element></span></p></td></tr></xsl:for-each></xsl:for-each><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"> </td></tr><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b><span style="font-size:8.0pt;line-height:115%"></span></b><span style="font-size:12.0pt;line-height:115%"><xsl:element name="span"><xsl:attribute name="id">ADD</xsl:attribute> </xsl:element>Autres documents dématérialisés</span></p>
               </td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:if test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:AutresDocumentsDematerialises/dc:DocumentOrmc/@NomListeOrmc"><xsl:variable name="link411" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link412" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link413" select="'ORMC'"/><xsl:variable name="link414" select="'ETATORMC'"/><xsl:variable name="link415" select="$link411"/><xsl:variable name="link416" select="$link412"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'ORMC'" /><xsl:with-param name="Param_1" select="$link413" /><xsl:with-param name="Param_2" select="$link414" /><xsl:with-param name="Param_3" select="$link415" /><xsl:with-param name="Param_4" select="$link416" /></xsl:call-template></xsl:if></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:if test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:AutresDocumentsDematerialises/dc:DocumentOpo/@NomListeOpo"><xsl:variable name="link417" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link418" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link419" select="'Ordres de Paiement Ordonnateur'"/><xsl:variable name="link420" select="'ETATOPO'"/><xsl:variable name="link421" select="$link417"/><xsl:variable name="link422" select="$link418"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Ordres de Paiement Ordonnateur'" /><xsl:with-param name="Param_1" select="$link419" /><xsl:with-param name="Param_2" select="$link420" /><xsl:with-param name="Param_3" select="$link421" /><xsl:with-param name="Param_4" select="$link422" /></xsl:call-template></xsl:if></span></p></td></tr><tr style="height:.3pt"><td width="8.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td><td width="85.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"><p class="Contenudetableau" style="line-height:115%"><span style="font-size: 8.0pt;line-height:115%"><xsl:if test="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:AutresDocumentsDematerialises/dc:DocumentOro/@NomListeOro"><xsl:variable name="link423" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name="link424" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:variable name="link425" select="'Ordres de Recette Ordonnateur'"/><xsl:variable name="link426" select="'ETATORO'"/><xsl:variable name="link427" select="$link423"/><xsl:variable name="link428" select="$link424"/><xsl:call-template name="com:lienOutputTitle"><xsl:with-param name="Param_0" select="'Ordres de Recette Ordonnateur'" /><xsl:with-param name="Param_1" select="$link425" /><xsl:with-param name="Param_2" select="$link426" /><xsl:with-param name="Param_3" select="$link427" /><xsl:with-param name="Param_4" select="$link428" /></xsl:call-template></xsl:if></span></p></td></tr><tr style="height:.3pt"><td width="95.2%" colspan="3" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1"> </td></tr></table></xsl:variable><xsl:if test="$HTML_OUTPUT_FORMAT and not( $docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:SommairePlus/dc:LigneSommairePlus/@RefEtat = 'BALGE.xsl')"><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau9"></xsl:with-param></xsl:call-template></xsl:if>
         <xsl:variable name="tableau10"><table width="100%" class="MsoTableGrid" border="0" cellspacing="0" cellpadding="0" style="border:none"><tr><td width="26.5%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="center" style="text-align:center"><b><span lang="EN-US" style="font-size:8.0pt"></span></b></p>
               </td><td width="48%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="25.5%" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_ARRESIGN, '_24')" /><xsl:attribute name="href" select="concat('#Page_', $p_ARRESIGN, '_24')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Arrêté et signatures'" /></xsl:element></span></p>
               </td></tr><tr><td width="26.5%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="48%" valign="top" style="padding:0cm 0cm 0cm 0cm" rowspan="1" colspan="1"> </td><td width="25.5%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal" align="right" style="text-align:right"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_ETATCTRLCPT, '_25')" /><xsl:attribute name="href" select="concat('#Page_', $p_ETATCTRLCPT, '_25')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'ECCF'" /></xsl:element></span></p>
               </td></tr></table></xsl:variable><xsl:if test="$PDF_OUTPUT_FORMAT and not( $docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable/dc:MtBalEntreeCre/@V)"><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau10"></xsl:with-param></xsl:call-template></xsl:if>
         <xsl:variable name="tableau11"><table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style=""><thead>
               <tr style="height:.3pt"><td width="65.7%" colspan="2" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1">
                     <p class="Contenudetableau"><b><span lang="EN-US" style="font-size:8.0pt"></span></b></p>
                  </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                     <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">Origine des données</span></p>
                  </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height: .3pt" rowspan="1" colspan="1">
                     <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">Page</span></p>
                  </td></tr>
            </thead><tr style="height:.3pt"><td width="9.1%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt">I. Informations générales et synthétiques</span></b></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_PRESGENCPT, '_26')" /><xsl:attribute name="href" select="concat('#Page_', $p_PRESGENCPT, '_26')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Présentation générale du compte financier - Vue d’ensemble'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_PRESGENCPT" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_RESCUMUL, '_27')" /><xsl:attribute name="href" select="concat('#Page_', $p_RESCUMUL, '_27')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Détermination du résultat cumulé à la fin de l’exercice'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_RESCUMUL" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_LISTSRVINDIV, '_28')" /><xsl:attribute name="href" select="concat('#Page_', $p_LISTSRVINDIV, '_28')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Liste des services individualisés dans un budget annexe'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_LISTSRVINDIV" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_RSTREALDEP, '_29')" /><xsl:attribute name="href" select="concat('#Page_', $p_RSTREALDEP, '_29')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Détail des restes à réaliser - Dépenses'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span lang="EN-US" style="font-size:8.0pt"><xsl:value-of select="$p_RSTREALDEP" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_RSTREALREC, '_30')" /><xsl:attribute name="href" select="concat('#Page_', $p_RSTREALREC, '_30')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Détail des restes à réaliser - Recettes'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span lang="EN-US" style="font-size:8.0pt"><xsl:value-of select="$p_RSTREALREC" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">E</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_BILANSYNTH, '_31')" /><xsl:attribute name="href" select="concat('#Page_', $p_BILANSYNTH, '_31')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Bilan synthétique'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_BILANSYNTH" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">F</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_CPTRESSYNTH, '_32')" /><xsl:attribute name="href" select="concat('#Page_', $p_CPTRESSYNTH, '_32')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Compte de résultat synthétique'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_CPTRESSYNTH" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt">II. Exécution budgétaire</span></b></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_MODVOTBDG, '_33')" /><xsl:attribute name="href" select="concat('#Page_', $p_MODVOTBDG, '_33')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Modalités de vote du budget'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_MODVOTBDG" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><i><span style="font-size:8.0pt">Vue d'ensemble</span></i></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_DEPEXP, '_34')" /><xsl:attribute name="href" select="concat('#Page_', $p_DEPEXP, '_34')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Dépenses d’exploitation'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_DEPEXP" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A1.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_RECEXP, '_35')" /><xsl:attribute name="href" select="concat('#Page_', $p_RECEXP, '_35')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Recettes d’exploitation'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_RECEXP" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_DEPINV, '_36')" /><xsl:attribute name="href" select="concat('#Page_', $p_DEPINV, '_36')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Dépenses d’investissement'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_DEPINV" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A2.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_RECINV, '_37')" /><xsl:attribute name="href" select="concat('#Page_', $p_RECINV, '_37')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Recettes d’investissement'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_RECINV" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><i><span style="font-size:8.0pt">Vue détaillée</span></i></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_EXDEPEXP, '_38')" /><xsl:attribute name="href" select="concat('#Page_', $p_EXDEPEXP, '_38')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Dépenses d’exploitation'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_EXDEPEXP" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_EXRECEXP, '_39')" /><xsl:attribute name="href" select="concat('#Page_', $p_EXRECEXP, '_39')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Recettes d’exploitation'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_EXRECEXP" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_EXDEPINV, '_40')" /><xsl:attribute name="href" select="concat('#Page_', $p_EXDEPINV, '_40')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Dépenses d’investissement'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_EXDEPINV" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_EXRECINV, '_41')" /><xsl:attribute name="href" select="concat('#Page_', $p_EXRECINV, '_41')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Recettes d’investissement'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_EXRECINV" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">D1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_OPEEQUIP, '_42')" /><xsl:attribute name="href" select="concat('#Page_', $p_OPEEQUIP, '_42')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Opérations d’équipement - Détail des chapitres et articles'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span lang="EN-US" style="font-size:8.0pt"><xsl:value-of select="$p_OPEEQUIP" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt">III. États financiers</span></b></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_BILAN, '_43')" /><xsl:attribute name="href" select="concat('#Page_', $p_BILAN, '_43')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Bilan'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_BILAN" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_CPTRES, '_44')" /><xsl:attribute name="href" select="concat('#Page_', $p_CPTRES, '_44')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Compte de résultat'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt"><xsl:value-of select="$p_CPTRES" /></span></p></td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt">IV. États annexés</span></b></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Présentation agrégée du budget principal et des budgets annexes</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><i><span style="font-size:8.0pt">B. États annexés patrimoniaux</span></i></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Détail des crédits de trésorerie</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Répartition par nature de dette</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.3</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Répartition par structure de taux</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.4</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Typologie de la répartition de l'encours</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.5</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Détail des opérations de couverture</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.6</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Remboursement anticipé d'un emprunt avec refinancement</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.7</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Emprunts renégociés au cours de l'année N</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B1.9</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de la dette - Autres dettes</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Méthodes utilisées pour les amortissements</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B3.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des provisions et des dépréciations</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B4</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des charges transférées</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B5</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Détail des opérations pour le compte de tiers</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B7.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des emprunts garantis</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B7.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Calcul du ratio d'endettement relatif aux emprunts garantis</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Subventions versées dans le cadre du vote du budget</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des contrats de crédit-bail</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.3</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des contrats de partenariat public-privé</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.4</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des autres engagements donnés</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B8.5</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État des engagements reçus</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B9</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État du personnel</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B9.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État du personnel de la collectivité ou de l’établissement de rattachement employé
                        par la régie</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">B10</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Liste des organismes dans lesquels a été pris un engagement financier</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><i><span style="font-size:8.0pt">C. États annexés budgétaires</span></i></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire - Dépenses</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C1.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Équilibre budgétaire - Recettes</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Situation des autorisations de programme</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">C2.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Situation des autorisations d’engagement</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#E6E6E6;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><i><span style="font-size:8.0pt">D. Autres éléments d’information</span></i></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D1.1.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de ventilation des dépenses et recettes des services d’eau et d’assainissement
                        - Exploitation</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D1.1.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de ventilation des dépenses et recettes des services d’eau et d’assainissement
                        - Investissement</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D1.2.1</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de ventilation des dép. et rec. des services d’assainissement collectif et non
                        collectif - Exploitation</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt;color:black">D1.2.2</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">État de ventilation des dép. et rec. des services d’assainissement collectif et non
                        collectif - Investissement</span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="56.6%" style="background:#B2B2B2;padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="margin-top:2.85pt;margin-right: 0cm;margin-bottom:2.85pt;margin-left:0cm;text-align:center"><b><span style="font-size:8.0pt">V. Arrêté et signatures</span></b></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1"> </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"> </td></tr><tr style="height:.3pt"><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center"><span style="font-size:8.0pt">A</span></p>
               </td><td width="56.6%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt"><xsl:element name="a"><xsl:attribute name="id" select="concat('Page_', $p_ARRESIGN, '_45')" /><xsl:attribute name="href" select="concat('#Page_', $p_ARRESIGN, '_45')" /><xsl:attribute name="class" select="'DESTPDF'" /><xsl:value-of select="'Arrêté et signatures'" /></xsl:element></span></p>
               </td><td width="25.3%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt; height:.3pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau"><span style="font-size:8.0pt">Ordonnateur / Comptable</span></p>
               </td><td width="9.1%" style="padding:1.4pt 1.4pt 1.4pt 1.4pt;height:.3pt" rowspan="1" colspan="1"><p class="Contenudetableau" align="center" style="text-align:center"><span lang="EN-US" style="font-size:8.0pt"><xsl:value-of select="$p_ARRESIGN" /></span></p></td></tr></table></xsl:variable><xsl:if test="$PDF_OUTPUT_FORMAT and not( $docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable/dc:MtBalEntreeCre/@V)"><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$tableau11"></xsl:with-param></xsl:call-template></xsl:if>
         <p class="MsoNormal"><span lang="EN-US"> </span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
            function scrollToElementId(elementId) {
            document.getElementById(elementId).scrollIntoView();
            }
        </script>
</html></xsl:template></xsl:stylesheet>