<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="dcfu:CompteFinancierUnique"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0cm;}
ul
  {margin-bottom:0cm;}
--&gt;
/**/
}</style></head>
   <body lang="FR"><div id="header">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><td width="75%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p style="punctuation-wrap:simple">
                     <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@CodeBC)"/> – 
                     
                     
                     <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Libelle)"/>
                  </p></td><td width="25%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right;punctuation-wrap:simple">Exercice 
                     
                     
                     <xsl:value-of select="distinct-values($docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V)"/>
                  </p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"><span style="font-size:4.0pt"> </span></p>
      </div>
      
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><td width="90%" valign="top" style="border:solid black 1.0pt; border-right:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><span style="line-height:115%"><xsl:variable name ="Refer70">ABILAN</xsl:variable><xsl:variable name ="Refer71" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Collectivite/@Siret"/><xsl:variable name ="Refer72" select="$docbudg/dc:DocumentComptable/dc:EnteteComptable/dc:Infos/dc:Exercice/@V"/><xsl:call-template name="lien:reference"><xsl:with-param name="id" select="concat ($Refer70, '_', $Refer71, '_', $Refer72)"/></xsl:call-template></span><b>III – ÉTATS FINANCIERS</b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b>III</b></p>
               </td></tr><tr><td width="90%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:solid black 1.0pt;border-right:none; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b><span style="line-height:115%">Bilan (en euros)</span></b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b><span style="line-height:115%">A</span></b></p>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size:11.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoNormalTable BORDURE" border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm1" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:Etat/@V='BI_A') and (./dc:ModeTraitement/@V!='NOTE_BAS_PAGE')]"/><thead>
               <tr><xsl:variable name="varOdm2" select="$varOdm1"/><xsl:variable name="content253">
                     <p class="Contenudetableau"><span><b>ACTIF</b></span></p>
                     <p class="Contenudetableau"><span></span></p>
                  </xsl:variable><xsl:variable name="className479">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className479" /><xsl:with-param name="rowspan">2</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">44.9%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content253" /></xsl:call-template><xsl:variable name="content254">
                     <p class="Contenudetableau"><b><span>Note</span></b></p>
                  </xsl:variable><xsl:variable name="className480">VBORDER</xsl:variable><xsl:variable name="className481">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className480, ' ', $className481)" /><xsl:with-param name="rowspan">2</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7.1%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content254" /></xsl:call-template><xsl:variable name="content255">
                     <p class="Contenudetableau"><b><span>Exercice N</span></b></p>
                  </xsl:variable><xsl:variable name="className482">VBORDER</xsl:variable><xsl:variable name="className483">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className482, ' ', $className483)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">3</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content255" /></xsl:call-template><xsl:variable name="content256">
                     <p class="Contenudetableau"><b><span>Exercice N-1</span></b></p>
                  </xsl:variable><xsl:variable name="className484">VBORDER</xsl:variable><xsl:variable name="className485">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className484, ' ', $className485)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">11.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content256" /></xsl:call-template></tr>
               <tr><xsl:variable name="varOdm3" select="$varOdm1"/><xsl:variable name="content257">
                     <p class="Contenudetableau"><b><span>BRUT</span></b></p>
                  </xsl:variable><xsl:variable name="className486">VBORDER</xsl:variable><xsl:variable name="className487">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className486, ' ', $className487)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content257" /></xsl:call-template><xsl:variable name="content258">
                     <p class="Contenudetableau"><b><span>amortissements, dépréciations</span></b></p>
                  </xsl:variable><xsl:variable name="className488">VBORDER</xsl:variable><xsl:variable name="className489">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className488, ' ', $className489)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content258" /></xsl:call-template><xsl:variable name="content259">
                     <p class="Contenudetableau"><b><span>NET</span></b></p>
                  </xsl:variable><xsl:variable name="className490">VBORDER</xsl:variable><xsl:variable name="className491">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className490, ' ', $className491)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content259" /></xsl:call-template><xsl:variable name="content260">
                     <p class="Contenudetableau"><b><span>NET</span></b></p>
                  </xsl:variable><xsl:variable name="className492">VBORDER</xsl:variable><xsl:variable name="className493">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className492, ' ', $className493)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">11.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content260" /></xsl:call-template></tr>
            </thead><xsl:variable name="varOdm4" select="$varOdm1"/><xsl:variable name="varOdm5"><xsl:for-each select="$varOdm4"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content261"><xsl:value-of select="distinct-values($ligne/dc:Intitule1/@V)"/></xsl:variable><xsl:variable name="className494" select="$ligne/dc:Format/@V"/><xsl:variable name="className495">LIBELLE</xsl:variable><xsl:variable name="className496">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className494, ' ', $className495, ' ', $className496)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">44.9%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content261" /></xsl:call-template><xsl:variable name="content262">
                  <p class="MsoNormal"><span></span></p>
               </xsl:variable><xsl:variable name="className497" select="$ligne/dc:Format/@V"/><xsl:variable name="className498">LIBELLE</xsl:variable><xsl:variable name="className499">VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className497, ' ', $className498, ' ', $className499)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7.1%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content262" /></xsl:call-template><xsl:variable name="content263"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtBrut/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className500" select="$ligne/dc:Format/@V"/><xsl:variable name="className501">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className500, ' ', $className501)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content263" /></xsl:call-template><xsl:variable name="content264"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtAmo/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className502" select="$ligne/dc:Format/@V"/><xsl:variable name="className503">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className502, ' ', $className503)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content264" /></xsl:call-template><xsl:variable name="content265"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtNet/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className504" select="$ligne/dc:Format/@V"/><xsl:variable name="className505">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className504, ' ', $className505)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">12.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content265" /></xsl:call-template><xsl:variable name="content266"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtNet-1/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className506" select="$ligne/dc:Format/@V"/><xsl:variable name="className507">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className506, ' ', $className507)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">11.2%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content266" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm6"><xsl:choose><xsl:when test="count($varOdm5/*) = 0"><tr class=" #tech#"><td height="1px" width="12.2%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="12.2%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="12.2%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="11.2%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm5"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm6/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
         <xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><xsl:variable name="varOdm7" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="100%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal" style="punctuation-wrap:simple"><xsl:if test="not($varOdm7/dc:NumOrdre/@V and $varOdm7/dc:Etat/@V='BI_A')">Cet état ne contient pas d'information.</xsl:if></p>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
         <xsl:variable name="varOdmTmpTab5"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm8" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:ModeTraitement/@V='NOTE_BAS_PAGE') and (./dc:Etat/@V='BI_A')]"/><tr><td width="100%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="MsoNormal" style="line-height:115%;layout-grid-mode:char;punctuation-wrap: simple"><span style="font-size:6.0pt;line-height:115%"></span></p>
               </td></tr><xsl:variable name="varOdm9" select="$varOdm8"/><xsl:variable name="varOdm10"><xsl:for-each select="$varOdm9"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content267"><xsl:value-of select="distinct-values($ligne/dc:NoteBasTableau/@V)"/></xsl:variable><xsl:variable name="className508" select="$ligne/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className508" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">100%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content267" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm11"><xsl:choose><xsl:when test="count($varOdm10/*) = 0"><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding:2.75pt 2.75pt 2.75pt 2.75pt"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm10"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm11/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab5"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" style="margin-bottom:10.0pt;line-height:115%;page-break-before:always"><span style="font-size:4.0pt;line-height:115%"> </span></p>
         <xsl:variable name="varOdmTmpTab6"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><tr><td width="90%" valign="top" style="border:solid black 1.0pt; border-right:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b>III – ÉTATS FINANCIERS</b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b>III</b></p>
               </td></tr><tr><td width="90%" valign="top" style="border-top:none;border-left: solid black 1.0pt;border-bottom:solid black 1.0pt;border-right:none; padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b><span style="line-height:115%">Bilan (en euros)</span></b></p>
               </td><td width="10%" valign="top" style="border:solid black 1.0pt; border-top:none;padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="Contenudetableau" align="center" style="text-align:center;line-height: 115%"><b><span style="line-height:115%">A</span></b></p>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab6"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size:11.0pt"> </span></p>
         <xsl:variable name="varOdmTmpTab7"><table width="100%" class="MsoNormalTable BORDURE" border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm12" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:Etat/@V='BI_P') and (./dc:ModeTraitement/@V!='NOTE_BAS_PAGE')]"/><thead>
               <tr><xsl:variable name="varOdm13" select="$varOdm12"/><xsl:variable name="content268">
                     <p class="Contenudetableau"><span><b>FONDS PROPRES ET PASSIF</b></span></p>
                     <p class="Contenudetableau"><span></span></p>
                  </xsl:variable><xsl:variable name="className509">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className509" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">45%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content268" /></xsl:call-template><xsl:variable name="content269">
                     <p class="Contenudetableau"><b><span>Note</span></b></p>
                  </xsl:variable><xsl:variable name="className510">VBORDER</xsl:variable><xsl:variable name="className511">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className510, ' ', $className511)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content269" /></xsl:call-template><xsl:variable name="content270">
                     <p class="Contenudetableau"><b><span>Exercice N</span></b></p>
                  </xsl:variable><xsl:variable name="className512">VBORDER</xsl:variable><xsl:variable name="className513">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className512, ' ', $className513)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content270" /></xsl:call-template><xsl:variable name="content271">
                     <p class="Contenudetableau"><b><span>Exercice N-1</span></b></p>
                  </xsl:variable><xsl:variable name="className514">VBORDER</xsl:variable><xsl:variable name="className515">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className514, ' ', $className515)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content271" /></xsl:call-template></tr>
            </thead><xsl:variable name="varOdm14" select="$varOdm12"/><xsl:variable name="varOdm15"><xsl:for-each select="$varOdm14"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content272"><xsl:value-of select="distinct-values($ligne/dc:Intitule1/@V)"/></xsl:variable><xsl:variable name="className516" select="$ligne/dc:Format/@V"/><xsl:variable name="className517">LIBELLE VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className516, ' ', $className517)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">45%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content272" /></xsl:call-template><xsl:variable name="content273">
                  <p class="MsoNormal"><span></span></p>
               </xsl:variable><xsl:variable name="className518" select="$ligne/dc:Format/@V"/><xsl:variable name="className519">LIBELLE VBORDER</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className518, ' ', $className519)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">7%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content273" /></xsl:call-template><xsl:variable name="content274"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtNet/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className520" select="$ligne/dc:Format/@V"/><xsl:variable name="className521">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className520, ' ', $className521)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content274" /></xsl:call-template><xsl:variable name="content275"><xsl:call-template name="num:number"><xsl:with-param name="num" select="$ligne/dc:MtNet-1/@V"/></xsl:call-template></xsl:variable><xsl:variable name="className522" select="$ligne/dc:Format/@V"/><xsl:variable name="className523">DECIMAL</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className522, ' ', $className523)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">24%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content275" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm16"><xsl:choose><xsl:when test="count($varOdm15/*) = 0"><tr class=" #tech#"><td height="1px" width="45%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="7%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="24%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td><td height="1px" width="24%" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm15"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm16/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab7"></xsl:with-param></xsl:call-template>
         <xsl:variable name="varOdmTmpTab8"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><xsl:variable name="varOdm17" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable"/><td width="100%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal" style="punctuation-wrap:simple"><xsl:if test="not($varOdm17/dc:NumOrdre/@V and $varOdm17/dc:Etat/@V='BI_P')">Cet état ne contient pas d'information.</xsl:if></p>
               </td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab8"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
         <xsl:variable name="varOdmTmpTab9"><table width="100%" class="MsoNormalTable " border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm18" select="$docbudg/dc:DocumentComptable/dc:BudgetComptable/dc:LigneComptable[(./dc:ModeTraitement/@V='NOTE_BAS_PAGE') and (./dc:Etat/@V='BI_P')]"/><tr><td width="100%" valign="top" style="padding:2.75pt 2.75pt 2.75pt 2.75pt" rowspan="1" colspan="1">
                  <p class="MsoNormal" style="line-height:115%;layout-grid-mode:char;punctuation-wrap: simple"><span style="font-size:6.0pt;line-height:115%"></span></p>
               </td></tr><xsl:variable name="varOdm19" select="$varOdm18"/><xsl:variable name="varOdm20"><xsl:for-each select="$varOdm19"><xsl:sort select="./dc:NumOrdre/@V" data-type="number"/><xsl:variable name="ligne" select="."/><tr><xsl:variable name="content276"><xsl:value-of select="distinct-values($ligne/dc:NoteBasTableau/@V)"/></xsl:variable><xsl:variable name="className524" select="$ligne/dc:Format/@V"/><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className524" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">100%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content276" /></xsl:call-template></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm21"><xsl:choose><xsl:when test="count($varOdm20/*) = 0"><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding:2.75pt 2.75pt 2.75pt 2.75pt"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm20"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowStyled"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm21/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab9"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" style="punctuation-wrap:simple"><span style="font-size:4.0pt"> </span></p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
        </script>
</html></xsl:template></xsl:stylesheet>