<?xml version="1.0" encoding="UTF-8"?><xsl:stylesheet xmlns:com="http://www.xemelios.org/namespaces#cg-1.0" xmlns:data="http://odm-budgetaire.org/data" xmlns:date="http://exslt.org/dates-and-times" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:ds="http://www.w3.org/2000/09/xmldsig#" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:n="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:xad="http://uri.etsi.org/01903/v1.2.2#" xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data">
   <xsl:import href="../../number.xsl"></xsl:import>
   <xsl:import href="../../date.xsl"></xsl:import>
   <xsl:import href="../../table.xsl"></xsl:import>
   <xsl:import href="../../style.xsl"></xsl:import>
   <xsl:import href="../../lien.xsl"></xsl:import>
   <xsl:import href="../../commons/constants.xsl"></xsl:import>
   <xsl:import href="../../commons/fonctions.xsl"></xsl:import>
   <xsl:import href="../../commons/templates.xsl"></xsl:import>
   <xsl:param name="HTML_OUTPUT_FORMAT"></xsl:param>
   <xsl:param name="PDF_OUTPUT_FORMAT"></xsl:param>
   <xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/dcfu:CompteFinancierUnique"></xsl:variable>
   <xsl:param name="nomenclaturePasEnrichie"></xsl:param>
   <xsl:variable name="nomenclature" select="document('libellePlanCompte.xml')/n:Nomenclature"></xsl:variable>
   <xsl:variable name="data" select="document('libelleAffiche.xml')/data"></xsl:variable>
   <xsl:variable name="isPrint" select="1"></xsl:variable>
   <xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="/dcfu:CompteFinancierUnique"></xsl:template><xsl:template match="/dcfu:CompteFinancierUnique">
      <html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
         
         
         
         <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
            
            
            
            
            
            <meta name="generator" content="ODM" />
            
            
            
            
            <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
            
            
            
            <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
            
            
            
            <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:Tahoma;
  panose-1:2 11 6 4 3 5 4 4 2 4;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
h3
  {
  
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoHeading8, li.MsoHeading8, div.MsoHeading8
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  page-break-after:avoid;
  font-size:12.0pt;
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.MsoHeader, li.MsoHeader, div.MsoHeader
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoFooter, li.MsoFooter, div.MsoFooter
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoBodyTextIndent, li.MsoBodyTextIndent, div.MsoBodyTextIndent
  {
  margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:14.2pt;
  margin-bottom:.0001pt;
  font-size:8.0pt;
  font-family:"Times New Roman",serif;}
p.MsoAcetate, li.MsoAcetate, div.MsoAcetate
  {
  margin:0in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:8.0pt;
  font-family:"Tahoma",sans-serif;}
p.MsoListParagraph, li.MsoListParagraph, div.MsoListParagraph
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpFirst, li.MsoListParagraphCxSpFirst, div.MsoListParagraphCxSpFirst
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpMiddle, li.MsoListParagraphCxSpMiddle, div.MsoListParagraphCxSpMiddle
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
p.MsoListParagraphCxSpLast, li.MsoListParagraphCxSpLast, div.MsoListParagraphCxSpLast
  {margin-top:0in;
  margin-right:0in;
  margin-bottom:0in;
  margin-left:.5in;
  margin-bottom:.0001pt;
  text-align:center;
  font-size:10.0pt;
  font-family:"Times New Roman",serif;}
span.Titre3Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
span.Titre8Car
  {
  
  font-family:"Times New Roman",serif;
  font-weight:bold;}
p.BodyText21, li.BodyText21, div.BodyText21
  {
  margin:0in;
  margin-bottom:.0001pt;
  font-size:9.0pt;
  font-family:"Times New Roman",serif;}
span.En-tteCar
  {
  
  font-family:"Times New Roman",serif;}
span.PieddepageCar
  {
  
  font-family:"Times New Roman",serif;}
span.TextedebullesCar
  {
  
  font-family:"Tahoma",sans-serif;}
span.RetraitcorpsdetexteCar
  {
  
  font-family:"Times New Roman",serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
 /* Page Definitions */
 @page{size:297mm 210mm;
  }
div.WordSection1
  {}
 /* List Definitions */
 ol
  {margin-bottom:0in;}
ul
  {margin-bottom:0in;}
--&gt;
/**/
}</style>
            </head>
         
         
         
         <body id="ETAT_VUREC" lang="EN-US">
            
            
            <div id="header">
               
               
               
               <p class="MsoHeader"><b><span style="font-size:8.0pt;font-family: &#34;Arial&#34;,&#34;sans-serif&#34;">
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:EnTeteDocBudgetaire/n:LibelleColl/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:EnTeteBudget/n:LibelleEtab/@V)"></xsl:value-of> - 
                        
                        <xsl:value-of select="distinct-values($data/data:NatureDecision/data:valeur[@value = concat($docbudg//n:Budget/n:BlocBudget/n:NatDec/@V,                         if ($docbudg//n:Budget/n:BlocBudget/n:ProjetBudget/@V = 'true') then '-proj' else '')]/text())"></xsl:value-of>  - 
                        
                        <xsl:value-of select="distinct-values($docbudg/n:DocumentBudgetaire/n:Budget/n:BlocBudget/n:Exer/@V)"></xsl:value-of></span></b></p>
               
               </div>
            
            
            
            
            <div class="WordSection1">
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab1">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        
                        <tr>
                           
                           
                           <td width="88.8%" valign="top" style="border-top:double 1.5pt; border-left:double 1.5pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II – EXECUTION BUDGETAIRE</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.2%" valign="top" style="border-top:double black 1.5pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-size:12.0pt;font-family:&#34;Arial&#34;,sans-serif">II</span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="88.8%" valign="top" style="border-top:none;border-left: double black 1.5pt;border-bottom:double black 1.5pt;border-right: solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">EXECUTION BUDGETAIRE PAR NATURE - VUE D’ENSEMBLE - RECETTES</span></b></p>
                              
                              </td>
                           
                           
                           <td width="11.2%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal"><b><span lang="FR" style="font-family:&#34;Arial&#34;,sans-serif">B2</span></b></p>
                              
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab2">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        <xsl:variable name="varOdm1" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:CodRD/@V='R') and (not(./n:Fonction/@V))]"></xsl:variable>
                        
                        
                        <thead>
                           
                           
                           
                           <tr height="0" class="#tech# #fixWidths#">
                              
                              
                              <td width="7.3%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="38.3%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="14%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="13.4%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="13.4%" style="border:none" rowspan="1" colspan="1"></td>
                              
                              
                              <td width="13.4%" style="border:none" rowspan="1" colspan="1"></td>
                              </tr>
                           
                           
                           
                           <tr>
                              
                              
                              <td width="7.3%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitre</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="38.3%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Intitulé </span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="14%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Prévisions (a)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="13.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Réalisations</span></b></p>
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Titres émis (b)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="13.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Taux de réalisation (b/a)</span></b></p>
                                 
                                 </td>
                              
                              
                              <td width="13.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                                 
                                 
                                 
                                 <p class="MsoNormal"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Restes à réaliser </span></b></p>
                                 
                                 </td>
                              </tr>
                           
                           </thead>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm2" select="$varOdm1[(n:ChapitreNature/@V='018') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">018</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '018' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL018')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm2/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm3" select="$varOdm1[(n:ChapitreNature/@V='13') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">13</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '13' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL13')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm3/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm4" select="$varOdm1[(n:ChapitreNature/@V='16') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">16</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '16' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL16')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm4/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm5" select="$varOdm1[(n:ChapitreNature/@V='20') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">20</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '20' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of> (sauf 204)</span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL20')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm5/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm6" select="$varOdm1[(n:ChapitreNature/@V='204') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">204</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '204' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL204')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm6/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm7" select="$varOdm1[(n:ChapitreNature/@V='21') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">21</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '21' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL21')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm7/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm8" select="$varOdm1[(n:ChapitreNature/@V='22') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">22</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '22' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL22')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm8/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm9" select="$varOdm1[(n:ChapitreNature/@V='23') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">23</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '23' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL23')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm9/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm10" select="$varOdm1[(n:ChapitreNature/@V='10') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">10</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '10' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL10')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm10/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm11" select="$varOdm1[(n:ChapitreNature/@V='18') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">18</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '18' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL18')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm11/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm12" select="$varOdm1[(n:ChapitreNature/@V='26') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">26</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '26' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL26')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm12/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm13" select="$varOdm1[(n:ChapitreNature/@V='27') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">27</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '27' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL27')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm13/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm14" select="$varOdm1[(n:ChapitreNature/@V='024') and (./n:OpBudg/@V='0') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 1.5pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">024</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '024' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm14/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           </tr>
                        
                        
                        <tr style="height:34.9pt">
                           
                           
                           <td width="7.3%" valign="top" style="border:solid black 1.0pt; border-left:double black 1.5pt;padding:0in 3.55pt 0in 3.55pt;height: 34.9pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">45</span></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:34.9pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Chapitres d’opérations pour compte de tiers</span></p>
                              
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:34.9pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECOPCT')                                     and (./n:OpBudg/@V='0')]/n:CredOuv/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:34.9pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECOPCT')                                     and (./n:OpBudg/@V='0')]/n:MtReal/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:34.9pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREALOPCPT')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt;height:34.9pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECOPCT')                                     and (./n:OpBudg/@V='0')]/n:MtRAR3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="45.6%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des recettes réelles d’investissement</span></b></p>
                              
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINVREL')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINVREL')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREALEXEREL')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINVREL')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm15" select="$varOdm1[(n:ChapitreNature/@V='021') and (./n:OpBudg/@V='1') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">021</span></i></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '021' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></i></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm15/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1"> </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm16" select="$varOdm1[(n:ChapitreNature/@V='040') and (./n:OpBudg/@V='1') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">040</span></i></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '040' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></i></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm16/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm16/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL040')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm16/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           <xsl:variable name="varOdm17" select="$varOdm1[(n:ChapitreNature/@V='041') and (./n:OpBudg/@V='1') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="7.3%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">041</span></i></p>
                              
                              </td>
                           
                           
                           <td width="38.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '041' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></i></p>
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm17/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm17/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREAL041')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right"><i><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm17/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="45.6%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des recettes d’ordre en investissement</span></b></p>
                              
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINVORD')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINVORD')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREALEXEORD')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif"></span></b><b><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINVORD')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="45.6%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des recettes d’investissement de l’exercice</span></b></p>
                              
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINV')]/n:CredOuv/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINV')]/n:MtReal/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREALEXE')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXINV')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:19.75pt">
                           
                           <xsl:variable name="varOdm18" select="$varOdm1[(n:ChapitreNature/@V='001') and (./n:OpBudg/@V='T') and (./n:InfoOpe/@V='T')]"></xsl:variable>
                           
                           
                           <td width="45.6%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 19.75pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">001 Solde d’exécution positif reporté</span></b></p>
                              
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:19.75pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm18/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:19.75pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:19.75pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:double black 1.5pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:19.75pt" rowspan="1" colspan="1"> </td>
                           </tr>
                        
                        
                        <tr>
                           
                           
                           <td width="45.6%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:double black 1.5pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" align="left" style="text-align:left"><b><span lang="FR" style="font-size:8.0pt;font-family:&#34;Arial&#34;,sans-serif">Total des recettes de la section d’investissement</span></b></p>
                              
                              </td>
                           
                           
                           <td width="14%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTINVCA')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTINV')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECINVTXREALTOT')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 1.5pt;border-right:double black 1.5pt; padding:0in 3.55pt 0in 3.55pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTINV')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal" style="margin-right:46.45pt"><b><span style="font-size:6.0pt; font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <p class="MsoNormal" style="margin-right:46.45pt"><b><span style="font-size:6.0pt; font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <p class="MsoNormal" style="margin-right:46.45pt"><b><span style="font-size:6.0pt; font-family:&#34;Arial&#34;,sans-serif"> </span></b></p>
               
               
               
               <div align="center">
                  
                  
                  
                  <xsl:variable name="varOdmTmpTab3">
                     
                     
                     <table width="100%" class="MsoNormalTable" border="0" cellspacing="0" cellpadding="0" style="border-collapse:collapse;border:none">
                        
                        <xsl:variable name="varOdm19" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(./n:CodRD/@V='R') and (not(./n:Fonction/@V))                         and (./n:InfoOpe/@V='T') and (./n:OpBudg/@V='T')]"></xsl:variable>
                        
                        
                        <tr height="0" class="#tech# #fixWidths#">
                           
                           
                           <td width="5.5%" style="border:none" rowspan="1" colspan="1"></td>
                           
                           
                           <td width="23.4%" style="border:none" rowspan="1" colspan="1"></td>
                           
                           
                           <td width="10.8%" style="border:none" rowspan="1" colspan="1"></td>
                           
                           
                           <td width="13.1%" style="border:none" rowspan="1" colspan="1"></td>
                           
                           
                           <td width="13.1%" style="border:none" rowspan="1" colspan="1"></td>
                           
                           
                           <td width="10.6%" style="border:none" rowspan="1" colspan="1"></td>
                           
                           
                           <td width="10.3%" style="border:none" rowspan="1" colspan="1"></td>
                           
                           
                           <td width="13.4%" style="border:none" rowspan="1" colspan="1"></td>
                           </tr>
                        
                        
                        <tr style="height:.5in">
                           
                           
                           <td width="5.5%" valign="top" style="border-top:double 2.25pt; border-left:double 2.25pt;border-bottom:solid 1.0pt;border-right:solid 1.0pt; border-color:black;padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span style="font-size:8.0pt; line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Chapitre</span></b></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Intitulé </span></b></p>
                              
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Prévisions (a) </span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Réalisations</span></b></p>
                              
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Titres émis (b) </span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Rattachements (c) </span></b></p>
                              
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Total réalisations (d = b+c) </span></b></p>
                              
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Taux de réalisation (d/a)</span></b></p>
                              
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:double black 2.25pt; border-left:none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:.5in" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Restes à réaliser </span></b></p>
                              
                              </td>
                           </tr>
                        
                        
                        <tr style="height:9.45pt">
                           
                           <xsl:variable name="varOdm20" select="$varOdm19[(n:ChapitreNature/@V='013')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">013</span></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '013' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm20/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm20/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm20/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm20/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL013')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm20/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:8.8pt">
                           
                           <xsl:variable name="varOdm21" select="$varOdm19[(n:ChapitreNature/@V='016')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">016</span></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '016' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm21/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm21/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm21/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm21/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL016')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm21/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:9.45pt">
                           
                           <xsl:variable name="varOdm22" select="$varOdm19[(n:ChapitreNature/@V='017')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">017</span></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '017' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm22/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm22/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm22/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm22/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL017')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm22/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:8.8pt">
                           
                           <xsl:variable name="varOdm23" select="$varOdm19[(n:ChapitreNature/@V='70')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">70</span></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '70' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm23/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm23/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm23/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm23/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL70')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm23/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:9.45pt">
                           
                           <xsl:variable name="varOdm24" select="$varOdm19[(n:ChapitreNature/@V='73')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">73</span></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '73' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif"> (sauf 731)</span></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm24/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm24/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm24/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm24/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL73')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm24/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:9.45pt">
                           
                           <xsl:variable name="varOdm25" select="$varOdm19[(n:ChapitreNature/@V='731')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">731</span></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '731' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm25/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm25/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm25/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm25/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL731')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm25/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:8.8pt">
                           
                           <xsl:variable name="varOdm26" select="$varOdm19[(n:ChapitreNature/@V='74')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">74</span></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '74' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm26/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm26/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm26/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm26/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL74')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm26/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:9.45pt">
                           
                           <xsl:variable name="varOdm27" select="$varOdm19[(n:ChapitreNature/@V='75')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">75</span></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '75' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm27/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm27/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm27/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm27/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL75')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm27/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:20.4pt">
                           
                           
                           <td width="28.8%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 20.4pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Total des recettes de gestion des services</span></b></p>
                              
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECGESCOUFON')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECGESCOUFON')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECGESCOUFON')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif"> 
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECGESCOUFON')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREALGESCOUFON')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:20.4pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECGESCOUFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:9.45pt">
                           
                           <xsl:variable name="varOdm28" select="$varOdm19[(n:ChapitreNature/@V='76')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">76</span></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '76' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm28/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm28/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm28/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm28/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL76')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm28/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:8.8pt">
                           
                           <xsl:variable name="varOdm29" select="$varOdm19[(n:ChapitreNature/@V='77')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">77</span></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '77' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm29/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm29/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm29/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm29/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL77')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm29/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:9.45pt">
                           
                           <xsl:variable name="varOdm30" select="$varOdm19[(n:ChapitreNature/@V='78')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">78</span></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '78' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family: &#34;Arial&#34;,sans-serif"> (semi-budgétaires)</span></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm30/n:CredOuv/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm30/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm30/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm30/n:MtReal/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL78')]/n:TxReal3112/@V"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                    
                                    <xsl:call-template name="num:number">
                                       
                                       <xsl:with-param name="num" select="$varOdm30/n:MtRAR3112/@V"></xsl:with-param>
                                       
                                       <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                       </xsl:call-template></span></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:19.5pt">
                           
                           
                           <td width="28.8%" colspan="2" valign="top" style="border:solid black 1.0pt; border-left:double black 2.25pt;padding:0in 3.55pt 0in 3.55pt; height:19.5pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Total des recettes réelles et mixtes</span></b></p>
                              
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:19.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONREL')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:19.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONREL')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:19.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONREL')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:19.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONREL')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:19.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREALEXEREL')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:solid black 1.0pt; border-left:none;padding:0in 3.55pt 0in 3.55pt;height:19.5pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONREL')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:9.45pt">
                           
                           <xsl:variable name="varOdm31" select="$varOdm19[(n:ChapitreNature/@V='042')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:none;border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt; height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><i><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">042</span></i></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '042' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></i><i><span lang="FR" style="font-size:8.0pt;line-height:115%; font-family:&#34;Arial&#34;,sans-serif"> </span></i></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm31/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm31/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm31/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm31/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL042')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border:none;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:9.45pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm31/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:8.8pt">
                           
                           <xsl:variable name="varOdm32" select="$varOdm19[(n:ChapitreNature/@V='043')]"></xsl:variable>
                           
                           
                           <td width="5.5%" valign="top" style="border-top:none;border-left:double black 2.25pt; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><i><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">043</span></i></p>
                              
                              </td>
                           
                           
                           <td width="23.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><i><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:value-of select="distinct-values(($nomenclature/n:NatureLib/n:Compte[@Code = '043' and @Type = 'C']/@LibelleCourt)[1])"></xsl:value-of></span></i></p>
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm32/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm32/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm32/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm32/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREAL043')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:8.8pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><i><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm32/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></i></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:16.35pt">
                           
                           
                           <td width="28.8%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 16.35pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Total des recettes d’ordre</span></b></p>
                              
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.35pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONORD')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.35pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONORD')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.35pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONORD')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.35pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONORD')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.35pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREALEXEORD')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.35pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFONORD')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:18.85pt">
                           
                           
                           <td width="28.8%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 18.85pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Total des recettes de fonctionnement de l’exercice</span></b></p>
                              
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:18.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:18.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:18.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:18.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:18.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREALEXE')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:18.85pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECEXFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        
                        
                        <tr style="height:16.4pt">
                           
                           <xsl:variable name="varOdm33" select="$varOdm19[(n:ChapitreNature/@V='002')]"></xsl:variable>
                           
                           
                           <td width="28.8%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:solid black 1.0pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 16.4pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">002 Excédent de fonctionnement reporté de N-1</span></b></p>
                              
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:16.4pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$varOdm33/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:16.4pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:16.4pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:16.4pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:16.4pt" rowspan="1" colspan="1"> </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#A6A6A6;padding:0in 3.55pt 0in 3.55pt;height:16.4pt" rowspan="1" colspan="1"> </td>
                           </tr>
                        
                        
                        <tr style="height:23.1pt">
                           
                           
                           <td width="28.8%" colspan="2" valign="top" style="border-top:none; border-left:double black 2.25pt;border-bottom:double black 2.25pt; border-right:solid black 1.0pt;padding:0in 3.55pt 0in 3.55pt;height: 23.1pt" rowspan="1">
                              
                              
                              
                              <p class="MsoNormal" style="text-align:justify;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">Total des recettes de la section de fonctionnement</span></b></p>
                              
                              </td>
                           
                           
                           <td width="10.8%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:23.1pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTFONCA')]/n:CredOuv/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:23.1pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTFON')]/n:MtMdtTitreEmis/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.1%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:23.1pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTFON')]/n:MtSup[(@Code='ProdChaRat')]/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="10.6%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:23.1pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTFON')]/n:MtReal/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="10.3%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:23.1pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECFONTXREALTOT')]/n:TxReal3112/@V"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           
                           
                           <td width="13.4%" valign="top" style="border-top:none;border-left: none;border-bottom:double black 2.25pt;border-right:solid black 1.0pt; padding:0in 3.55pt 0in 3.55pt;height:23.1pt" rowspan="1" colspan="1">
                              
                              
                              <p class="MsoNormal" align="right" style="text-align:right;line-height:115%"><b><span lang="FR" style="font-size:8.0pt;line-height:115%;font-family:&#34;Arial&#34;,sans-serif">
                                       
                                       <xsl:call-template name="num:number">
                                          
                                          <xsl:with-param name="num" select="$docbudg/n:DocumentBudgetaire/n:Budget/n:LigneBudget[(n:Groupe/@V='GRECTOTFON')]/n:MtRAR3112/@V"></xsl:with-param>
                                          
                                          <xsl:with-param name="format" select="&#34;;unsec&#34;"></xsl:with-param>
                                          </xsl:call-template></span></b></p>
                              </td>
                           </tr>
                        </table>
                     </xsl:variable>
                  
                  
                  <xsl:call-template name="table:outputTable">
                     
                     
                     <xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param>
                     </xsl:call-template>
                  
                  </div>
               
               
               
               <p class="MsoNormal" align="left" style="text-align:left"><span lang="FR" style="font-size:6.0pt;font-family:&#34;Arial&#34;,sans-serif"> </span></p>
               
               </div>
            
            
            
            <div id="footer">
               
               <p xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" class="MsoNormal"><span style="font-size:8.0pt;line-height:115%">
                     
                     <xsl:if test="$HTML_OUTPUT_FORMAT">
                        
                        <xsl:variable name="link1" select="$docbudg/db:DocumentBudgetaire/db:EnTeteDocBudgetaire/db:IdColl/@V"></xsl:variable>
                        
                        <xsl:variable name="link2" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:BlocBudget/db:Exer/@V"></xsl:variable>
                        
                        <xsl:variable name="link3" select="'images/return.png'"></xsl:variable>
                        
                        <xsl:variable name="link4" select="'Accueil'"></xsl:variable>
                        
                        <xsl:variable name="link5" select="$link1"></xsl:variable>
                        
                        <xsl:variable name="link6" select="$link2"></xsl:variable>
                        
                        <xsl:call-template name="com:lienOutputImage">
                           
                           <xsl:with-param name="Param_0" select="'images/return.png'"></xsl:with-param>
                           
                           <xsl:with-param name="Param_1" select="$link3"></xsl:with-param>
                           
                           <xsl:with-param name="Param_2" select="$link4"></xsl:with-param>
                           
                           <xsl:with-param name="Param_3" select="$link5"></xsl:with-param>
                           
                           <xsl:with-param name="Param_4" select="$link6"></xsl:with-param>
                           </xsl:call-template>
                        </xsl:if></span></p>
               </div>
            </body>
         
         </html></xsl:template></xsl:stylesheet>