<?xml version="1.0" encoding="UTF-8"?><!--
            Copyright
            2010 axYus - http://www.axyus.com
            2010 J.Leger - johann.leger@axyus.com

            This file is part of ODM print-comp.

            ODM print-comp is free software; you can redistribute it and/or modify
            it under the terms of the GNU Lesser General Public License as published by
            the Free Software Foundation; either version 2 of the License, or
            (at your option) any later version.

            ODM print-comp is distributed in the hope that it will be useful,
            but WITHOUT ANY WARRANTY; without even the implied warranty of
            MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
            GNU Lesser General Public License for more details.

            You should have received a copy of the GNU Lesser General Public License
            along with ODM print-comp; if not, write to the Free Software
            Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
        --><xsl:stylesheet xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns:n="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dcfu="http://www.minefi.gouv.fr/cp/demat/doccfu" xmlns:dc="http://www.minefi.gouv.fr/cp/demat/doccomptable" xmlns:db="http://www.minefi.gouv.fr/cp/demat/docbudgetaire" xmlns:data="http://odm-budgetaire.org/data" xmlns:num="http://odm-budgetaire.org/utils/num" xmlns:date="http://exslt.org/dates-and-times" xmlns:table="http://odm-budgetaire.org/utils/table" xmlns:style="http://odm-budgetaire.org/utils/style" xmlns:lien="http://odm-budgetaire.org/utils/lien" xmlns:exomile="http://www.fr.gouv.finances.dgfip.exomile" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0" extension-element-prefixes="num date table style lien" exclude-result-prefixes="xsl n data"><xsl:import href="../../../../number.xsl"></xsl:import><xsl:import href="../../../../date.xsl"></xsl:import><xsl:import href="../../../../table.xsl"></xsl:import><xsl:import href="../../../../style.xsl"></xsl:import><xsl:import href="../../../../lien.xsl"></xsl:import><xsl:variable name="page-format" select="portrait"></xsl:variable><xsl:output encoding="UTF-8" method="xml" indent="yes"></xsl:output><xsl:variable name="docbudg" select="/AnomaliesCCA"></xsl:variable><xsl:param name="nomenclaturePasEnrichie"></xsl:param><xsl:variable name="nomenclature" select="$nomenclaturePasEnrichie/n:Nomenclature"></xsl:variable><xsl:variable name="data" select="document('../../libelleAffiche.xml')/data"></xsl:variable><xsl:variable name="isPrint" select="1"></xsl:variable><xsl:decimal-format name="decformat" decimal-separator="," grouping-separator=" " digit="#" pattern-separator=";" NaN="NaN" minus-sign="-"></xsl:decimal-format><xsl:template match="*"></xsl:template><xsl:template match="AnomaliesCCA"><html xmlns="http://www.w3.org/1999/xhtml" xml:space="preserve">
   <head><meta http-equiv="Content-Type" content="text/html; charset=UTF-8" /><meta name="generator" content="ODM" />
      
      <link rel="stylesheet" type="text/css" media="screen" href="docBudg.css" />
      <link rel="stylesheet" type="text/css" media="print" href="docBudgPrint.css" />
      
      <style type="text/css" xml:space="preserve">
/**/
&lt;!--
 /* Font Definitions */
 @font-face
  {font-family:SimSun;
  panose-1:2 1 6 0 3 1 1 1 1 1;}
@font-face
  {font-family:Mangal;
  panose-1:0 0 4 0 0 0 0 0 0 0;}
@font-face
  {font-family:"Cambria Math";
  panose-1:2 4 5 3 5 4 6 3 2 4;}
@font-face
  {font-family:"\@SimSun";
  panose-1:2 1 6 0 3 1 1 1 1 1;}
 /* Style Definitions */
 p.MsoNormal, li.MsoNormal, div.MsoNormal
  {margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
p.Contenudetableau, li.Contenudetableau, div.Contenudetableau
  {
  margin:0cm;
  margin-bottom:.0001pt;
  font-size:10.0pt;
  font-family:"Arial",sans-serif;}
.MsoChpDefault
  {font-family:"Calibri",sans-serif;}
.MsoPapDefault
  {margin-bottom:10.0pt;
  line-height:115%;}
@page{size:297mm 210mm;
  }
div.WordSection1
  {}
--&gt;
/**/
}</style></head>
   <body lang="FR">
      <div class="WordSection1">
         <xsl:variable name="varOdmTmpTab1"><table width="100%" class="MsoTableGrid " border="0" cellspacing="0" cellpadding="0"><tr><td width="36.4%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/></p></td><td width="63.6%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right">Exercice : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></p></td></tr><tr><td width="36.4%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></p></td><td width="63.6%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@PlanCpte)"/></p></td></tr><tr><td width="36.4%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="63.6%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right">Population : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/EnteteComptable/Infos/Collectivite/@Population"/><xsl:with-param name="format" select="&quot;# ##0&quot;"/></xsl:call-template></p></td></tr><tr><td width="36.4%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="63.6%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right">Type de budget : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@TypeBC)"/></p></td></tr><tr><td width="36.4%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="63.6%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right">Type de collectivité : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@TypeColl)"/></p></td></tr><tr><td width="36.4%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="63.6%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right">Édition : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@TypeEdition)"/></p></td></tr></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab1"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal" align="center" style="text-align:center"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@CodeBC)"/> <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Collectivite/@Libelle)"/></p>
         <p class="MsoNormal" align="center" style="text-align:center"><b><span style="font-size:14.0pt">État d’anomalies des contrôles comptables</span></b></p>
         <p class="MsoNormal" align="center" style="text-align:center"><b>Arrêté à la date du : <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateArrete)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></b></p>
         <p class="MsoNormal"> </p>
         <xsl:variable name="varOdmTmpTab2"><table width="100%" class="MsoTableGrid BORDURE" border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm1" select="$docbudg/BudgetCCA[(./Anomalie) and (./@IdNat=$docbudg/EnteteComptable/Infos/Collectivite/@IdNat)]/Anomalie"/><thead>
               <tr><xsl:variable name="varOdm2" select="$varOdm1"/><xsl:variable name="content386">
                     <p class="MsoNormal"><span></span><b>No</b><b></b></p>
                  </xsl:variable><xsl:variable name="className740">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className740" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">30%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content386" /></xsl:call-template><xsl:variable name="content387">
                     <p class="MsoNormal"><b><span></span></b><b>Anomalie</b></p>
                  </xsl:variable><xsl:variable name="className741">VBORDER</xsl:variable><xsl:variable name="className742">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className741, ' ', $className742)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">40%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content387" /></xsl:call-template><xsl:variable name="content388">
                     <p class="MsoNormal"><b><span>Observations du comptable</span></b></p>
                  </xsl:variable><xsl:variable name="className743">VBORDER</xsl:variable><xsl:variable name="className744">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className743, ' ', $className744)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">30%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content388" /></xsl:call-template></tr>
            </thead><xsl:variable name="varOdm3" select="$varOdm1"/><xsl:variable name="varOdm4"><xsl:for-each select="$varOdm3"><xsl:sort select="./NumRegle"/><xsl:variable name="ligne" select="."/><tr><td width="30%" style="border:solid black 1.0pt;border-top: none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p><span style="color:black"><xsl:value-of select="distinct-values($ligne/NumRegle)"/></span></p></td><td width="40%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p><span style="color:black"><xsl:value-of select="distinct-values($ligne/LibelleAnomalie)"/></span></p><p><span style="color:black"><xsl:value-of select="distinct-values($ligne/ComplementAnomalie)"/></span></p></td><td width="30%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#E5E5E5;padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm5"><xsl:choose><xsl:when test="count($varOdm4/*) = 0"><tr class=" #tech#"><td height="1px" width="30%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-left:none; border-right:none"></td><td height="1px" width="40%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-left:none; border-right:none"></td><td height="1px" width="30%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;; border-top:hidden; border-bottom:solid black 1.0pt; border-left:none; border-right:none"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm4"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowBorders"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm5/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab2"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
         <xsl:variable name="varOdmTmpTab3"><table width="100%" class="MsoTableGrid BORDURE" border="0" cellspacing="0" cellpadding="0"><xsl:choose><xsl:when test="$docbudg/EnteteComptable/Infos/Nomenclature/@V = &#34;M21&#34; or $docbudg/AnomaliesCCA/EnteteComptable/Infos/Nomenclature/@V = &#34;M22&#34; or $docbudg/AnomaliesCCA/EnteteComptable/Infos/Nomenclature/@V = &#34;M22_EPRD&#34;"><xsl:variable name="varOdm6" select="$docbudg/db:DocumentBudgetaire/db:Budget/db:LigneBudget"/><tr><td width="100%" valign="top" style="padding: 0cm 0cm 1.5pt 0cm;" rowspan="1" colspan="1">
                  <p class="MsoNormal">
                     
                     
                  </p>
                  <xsl:for-each select="$docbudg/BudgetCCA[(./Anomalie) and (./@IdNat=$docbudg/EnteteComptable/Infos/BudgetAnnexe/@IdNat)]"><xsl:sort select="."></xsl:sort><xsl:variable name="codeBoucleTable" select="."></xsl:variable><xsl:if test="position() &gt; 1"><div style="height: 8pt;"></div></xsl:if><xsl:variable name="varOdmTmpTab4"><table width="100%" class="MsoTableGrid BORDURE" border="0" cellspacing="0" cellpadding="0"><xsl:variable name="varOdm7" select="$codeBoucleTable/Anomalie"/><tr height="0" class="#tech# #fixWidths#"><td width="30%" style="border:none" rowspan="1" colspan="1"></td><td width="40%" style="border:none" rowspan="1" colspan="1"></td><td width="30%" style="border:none" rowspan="1" colspan="1"></td></tr><tr><td width="30%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal"></p>
                        </td><td width="40%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1">
                           <p class="MsoNormal"></p>
                        </td><td width="30%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td></tr><tr><td width="30%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@Codique)"/></p></td><td width="40%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="30%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right;page-break-before: always">Exercice : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Exercice/@V)"/></p></td></tr><tr><td width="30%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Tresorerie/@LibellePoste)"/></p></td><td width="40%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="30%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe/@PlanCpte)"/></p></td></tr><tr><td width="30%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="40%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="30%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right">Population : <xsl:call-template name="num:number"><xsl:with-param name="num" select="$docbudg/EnteteComptable/Infos/BudgetAnnexe/@Population"/><xsl:with-param name="format" select="&quot;# ##0&quot;"/></xsl:call-template></p></td></tr><tr><td width="30%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="40%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="30%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right">Type de budget : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe/@TypeBC)"/></p></td></tr><tr><td width="30%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="40%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="30%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right">Type de collectivité : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe/@TypeColl)"/></p></td></tr><tr><td width="30%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="40%" valign="top" style="padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td><td width="30%" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p align="right" style="text-align:right">Édition : <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@TypeEdition)"/></p></td></tr><tr><td width="30%" colspan="3" valign="top" style="padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1"><p align="center" style="text-align:center"><xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe/@CodeBC)"/> <xsl:value-of select="distinct-values($docbudg/EnteteComptable/Infos/BudgetAnnexe/@Libelle)"/></p><p align="center" style="text-align:center"><b><span style="font-size:14.0pt">État d’anomalies des contrôles comptables</span></b></p><p align="center" style="text-align:center"><b>Arrêté à la date du : <xsl:call-template name="date:format-dates"><xsl:with-param name="date-times" select="distinct-values($docbudg/EnteteComptable/Infos/Edition/@DateArrete)"/><xsl:with-param name="pattern" select="'dd/MM/yyyy'"/></xsl:call-template></b></p><p> </p></td></tr><tr><xsl:variable name="varOdm8" select="$varOdm7"/><xsl:variable name="content389">
                           <p class="MsoNormal"><span></span><b>No</b></p>
                        </xsl:variable><xsl:variable name="className745">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="$className745" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">30%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content389" /></xsl:call-template><xsl:variable name="content390">
                           <p class="MsoNormal"><b><span></span></b><b>Anomalie</b></p>
                        </xsl:variable><xsl:variable name="className746">VBORDER</xsl:variable><xsl:variable name="className747">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className746, ' ', $className747)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">40%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content390" /></xsl:call-template><xsl:variable name="content391">
                           <p class="MsoNormal"><b>Observations du comptable</b></p>
                        </xsl:variable><xsl:variable name="className748">VBORDER</xsl:variable><xsl:variable name="className749">TITRE</xsl:variable><xsl:call-template name="style:styler-cellule"><xsl:with-param name="style-class" select="concat($className748, ' ', $className749)" /><xsl:with-param name="rowspan">1</xsl:with-param><xsl:with-param name="colspan">1</xsl:with-param><xsl:with-param name="width">30%</xsl:with-param><xsl:with-param name="height"></xsl:with-param><xsl:with-param name="content" select="$content391" /></xsl:call-template></tr><xsl:variable name="varOdm9" select="$varOdm7"/><xsl:variable name="varOdm10"><xsl:for-each select="$varOdm9"><xsl:sort select="./NumRegle"/><xsl:variable name="ligne" select="."/><tr><td width="30%" style="border:solid black 1.0pt; border-top:none;padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p><span style="color:black"><xsl:value-of select="distinct-values($ligne/NumRegle)"/></span></p></td><td width="40%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; padding: 0cm 5.4pt 1.5pt 5.4pt;" rowspan="1" colspan="1"><p><span style="color:black"><xsl:value-of select="distinct-values($ligne/LibelleAnomalie)"/></span></p><p><span style="color:black"><xsl:value-of select="distinct-values($ligne/ComplementAnomalie)"/></span></p></td><td width="30%" style="border-top:none;border-left:none; border-bottom:solid black 1.0pt;border-right:solid black 1.0pt; background:#E5E5E5;padding:0cm 5.4pt 0cm 5.4pt" rowspan="1" colspan="1"> </td></tr></xsl:for-each></xsl:variable><xsl:variable name="varOdm11"><xsl:choose><xsl:when test="count($varOdm10/*) = 0"><tr class=" #tech#"><td height="1px" width="30%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td><td height="1px" width="40%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td><td height="1px" width="30%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 5.4pt 1.5pt 5.4pt;"></td></tr></xsl:when><xsl:otherwise><xsl:sequence select="$varOdm10"></xsl:sequence></xsl:otherwise></xsl:choose></xsl:variable><xsl:call-template name="table:processRowBorders"><xsl:with-param name="borderStyle" select="'solid 1.0pt'"></xsl:with-param><xsl:with-param name="rows" select="$varOdm11/xhtml:tr"></xsl:with-param></xsl:call-template></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab4"></xsl:with-param></xsl:call-template></xsl:for-each>
               </td></tr></xsl:when><xsl:otherwise><tr class=" #tech#"><td height="1px" width="100%" valign="top" rowspan="1" colspan="1" style="padding: 0cm 0cm 1.5pt 0cm;"></td></tr></xsl:otherwise></xsl:choose></table></xsl:variable><xsl:call-template name="table:outputTable"><xsl:with-param name="table" select="$varOdmTmpTab3"></xsl:with-param></xsl:call-template>
         <p class="MsoNormal"> </p>
      </div>
   </body><script type="text/javascript">
            function iframeLoadPage(href) {
            try {
            parent.loadPage(href);
            } catch(ex) {
            //si on n'arrive pas a acceder a la page parente
            document.location.href = href;
            }
            }
        </script>
</html></xsl:template></xsl:stylesheet>