# -*- coding: utf-8 -*-
#
# File: content/servicefolder.py
#
# Copyright (c) 2006 atReal
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#

"""
$Id$
"""

__author__ = """atReal <contact@atreal.net> : T.Benita, J-N.Bes & M.Broquet"""
__docformat__ = 'plaintext'
__licence__ = 'GPL'

from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import *
from Products.Archetypes.public import *
from Products.PloneDelib.config import *
from Products.CMFCore.utils import getToolByName
from Products.ATContentTypes.content.base import ATCTOrderedFolder
from Products.ATContentTypes.content.schemata import ATContentTypeSchema


ServiceFolder_schema = ATCTOrderedFolder.schema.copy()

ServiceFolder_schema['relatedItems'].widget.visible={'view': "invisible", 'edit': "invisible", }

class ServiceFolder(ATCTOrderedFolder):
    """ Rubrique de l'ordre du jour.
    """
    security = ClassSecurityInfo()

    # This name appears in the 'add' box
    archetype_name = 'Dossier de service'

    meta_type = 'ServiceFolder'
    portal_type = 'ServiceFolder'
    allowed_content_types = ['Folder','Act']
    filter_content_types = 1
    #global_allow = 0
    #immediate_view = 'base_view'
    #default_view = 'base_view'
    #suppl_views = ()
    typeDescription = "ServiceFolder"
    typeDescMsgId = 'description_edit_servicefolder'

    _at_rename_after_creation = True

    schema = ServiceFolder_schema

    security.declarePrivate('at_post_edit_script')
    def at_post_create_script(self):
      return ""

    security.declareProtected("PloneDelib: Add Act", 'manage_delObjects')
    def manage_delObjects(self, ids=[], REQUEST=None):
        """We need to enforce security."""
        mt = getToolByName(self, 'portal_membership')
        isAdmin=mt.checkPermission(CMFCorePermissions.DeleteObjects, self)
        if type(ids) is str:
            ids = [ids]
        for id in ids:
            item = self._getOb(id)
            if not mt.checkPermission(CMFCorePermissions.DeleteObjects, item):
                raise Unauthorized, (
                    "Do not have permissions to remove this object")
        return ATCTFolder.manage_delObjects(self, ids, REQUEST=REQUEST)


registerType(ServiceFolder, PROJECTNAME)
