"""
$Id: FSSItem.py,v 1.7 2005/05/11 15:42:59 clebeaupin Exp $
"""

# Zope imports
from AccessControl import ClassSecurityInfo

# CMF imports
from Products.CMFCore import CMFCorePermissions

# Archetypes imports
try:
    from Products.LinguaPlone.public import *
except ImportError: 
    # No multilingual support
    from Products.Archetypes.public import *

# Products imports
from Products.FileSystemStorage.FileSystemStorage import FileSystemStorage

#try:
#    from Products.AttachmentField.AttachmentField import AttachmentField as FileField
#except:
#    pass
    
schema = BaseSchema.copy() + Schema((
    FileField('file',
              required=False,
              primary=True,
              storage=FileSystemStorage(),
              widget = FileWidget(
                        description = "Select the file to be added by clicking the 'Browse' button.",
                        description_msgid = "help_file",
                        label= "File",
                        label_msgid = "label_file",
                        i18n_domain = "plone",
                        show_content_type = False,)),
    ImageField('image',
               required=False,
               storage=FileSystemStorage(),
               widget = ImageWidget()),
    TextField('text',
              required=False,
              storage=FileSystemStorage(),
              widget = TextAreaWidget(
                        )),
    ), marshall=PrimaryFieldMarshaller())


class FSSItem(BaseContent):
    """A simple item using FileSystemStorage"""
    archetypes_name = portal_type = meta_type = 'FSSItem'
    schema = schema
    _at_rename_after_creation = True


registerType(FSSItem)
