"""
$Id: testFSS.py,v 1.4 2005/05/13 16:44:27 clebeaupin Exp $
"""

from common import *

class TestFSS(FSSTestCase.FSSTestCase):
    def afterSetUp(self):
        self.loginAsPortalOwner()
        content_id = 'test_folder'
        self.portal.invokeFactory('Folder', id=content_id)
        self.test_folder = getattr(self.portal, content_id)
        self.logout()

# #############################################################################
# ADD 
# #############################################################################

    def testAddFileFromString(self):
        self.loginAsPortalOwner()
        content_id = 'test_file'
        self.file_content = self.addFileByString(self.test_folder, content_id)
        
        # Get file field
        file_field = self.file_content.getField('file')
        
        # Get file value
        file_value = file_field.get(self.file_content)
        
        # Test value
        self.assertEquals(str(file_value.data), 'mytestfile')
        
        # Test filename
        self.assertEquals(file_value.filename, '')
        
        # Test size
        self.assertEquals(file_value.get_size(), 10)
        
        # Test content type
        self.assertEquals(file_field.getContentType(self.file_content), 'text/plain')
        
        # Test using BaseUnit
        bu = file_field.getBaseUnit(self.file_content)
        bu_value = bu.getRaw()
        self.assertEquals(len(bu_value), 10)
        self.assertEquals(bu_value, """mytestfile""")
        
        # Test using manage_FTPget
        ftp_value = self.file_content.manage_FTPget()
        self.failIf(ftp_value is None)
        self.assertEquals(len(ftp_value), 10)
        self.assertEquals(ftp_value, """mytestfile""")
        self.logout()
    
    def _testDefaultContentFromUploadedFile(self):
        # Get file field
        file_field = self.file_content.getField('file')
        
        # Get file value
        file_value = file_field.get(self.file_content)
        
        # Test filename
        self.assertEquals(file_value.filename, 'word.doc')
        
        # Test size
        self.assertEquals(file_value.get_size(), 10240)
        
        # Test content type
        self.assertEquals(file_field.getContentType(self.file_content), 'application/msword')
        
        # Test using BaseUnit
        bu = file_field.getBaseUnit(self.file_content)
        bu_value = bu.getRaw()
        self.assertEquals(len(bu_value), 10240)
        
        # Test using manage_FTPget
        ftp_value = self.file_content.manage_FTPget()
        self.failIf(ftp_value is None)
        self.assertEquals(len(ftp_value), 10240)
        
    def testAddFileFromUploadedFile(self):
        self.loginAsPortalOwner()
        
        # Create file
        content_id = 'test_file'
        self.file_content = self.addFileByFileUpload(self.test_folder, content_id)
        
        self._testDefaultContentFromUploadedFile()
        
        self.logout()

# #############################################################################
# EDIT
# #############################################################################
    def testEditFile(self):
        self.loginAsPortalOwner()
        
        # Create file
        content_id = 'test_file'
        self.file_content = self.addFileByFileUpload(self.test_folder, content_id)
        
        self._testDefaultContentFromUploadedFile()
        
        # Update content
        data_path = self.getDataPath()
        self.updateContent(self.file_content, 'file', os.path.join(data_path, 'excel.xls'))
        
        # Get file field
        file_field = self.file_content.getField('file')
        
        # Get file value
        file_value = file_field.get(self.file_content)
        
        # Test filename
        self.assertEquals(file_value.filename, 'excel.xls')
        
        # Test size
        self.assertEquals(file_value.get_size(), 13824)
        
        # Test content type
        self.assertEquals(file_field.getContentType(self.file_content), 'application/vnd.ms-excel')
        
        self.logout()
        
# #############################################################################
# RENAME
# #############################################################################
    def testRenameContent(self):
        self.loginAsPortalOwner()
        
        # Create file
        content_id = 'test_file'
        self.file_content = self.addFileByFileUpload(self.test_folder, content_id)
        old_uid = self.file_content.UID()
        
        # Rename file
        new_content_id = 'new_test_file'
        self.test_folder.manage_renameObjects((content_id,), (new_content_id,))
        
        # Test file
        self.assertEquals(self.file_content.getId(), new_content_id)
        self.assertEquals(self.file_content.UID(), old_uid)
        self._testDefaultContentFromUploadedFile()
        self.logout()

# #############################################################################
# COPY
# #############################################################################
    def testCopyContent(self):
        self.loginAsPortalOwner()
        
        # Create file
        content_id = 'test_file'
        self.file_content = self.addFileByFileUpload(self.test_folder, content_id)
        
        # Copy file in another folder
        cb = self.test_folder.manage_copyObjects(ids=(content_id,))
        
        new_folder_id = 'new_test_folder'
        self.portal.invokeFactory('Folder', id=new_folder_id)
        new_folder = getattr(self.portal, new_folder_id)
        
        # Paste
        new_folder.manage_pasteObjects(cb_copy_data=cb)
        
        # Test source file
        self._testDefaultContentFromUploadedFile()
        
        # Test destination file
        new_file_content = getattr(new_folder, content_id)
        
        # Get file field
        file_field = new_file_content.getField('file')
        
        # Get file value
        file_value = file_field.get(new_file_content)
        
        # Test filename
        self.assertEquals(file_value.filename, 'word.doc')
        
        # Test size
        self.assertEquals(file_value.get_size(), 10240)
        
        # Test content type
        self.assertEquals(file_field.getContentType(new_file_content), 'application/msword')
        
        self.logout()
        
        
# #############################################################################
# CUT
# #############################################################################
    def testCutContent(self):
        self.loginAsPortalOwner()
        
        # Create file
        content_id = 'test_file'
        self.file_content = self.addFileByFileUpload(self.test_folder, content_id)
        old_uid = self.file_content.UID()
        
        # Copy file in another folder
        cb = self.test_folder.manage_cutObjects(ids=(content_id,))
        
        new_folder_id = 'new_test_folder'
        self.portal.invokeFactory('Folder', id=new_folder_id)
        new_folder = getattr(self.portal, new_folder_id)
        
        # Paste
        new_folder.manage_pasteObjects(cb_copy_data=cb)
        
        # Test source file
        self.failIf(hasattr(self.test_folder, content_id))
        
        # Test destination file
        new_file_content = getattr(new_folder, content_id)
        
        # Get file field
        file_field = new_file_content.getField('file')
        
        # Get file value
        file_value = file_field.get(new_file_content)
        
        # Test filename
        self.assertEquals(file_value.filename, 'word.doc')
        
        # Test size
        self.assertEquals(file_value.get_size(), 10240)
        
        # Test content type
        self.assertEquals(file_field.getContentType(new_file_content), 'application/msword')
        
        self.assertEquals(new_file_content.UID(), old_uid)
        
        self.logout()
        
# #############################################################################
# DELETE
# #############################################################################
    def testDeleteContent(self):
        self.loginAsPortalOwner()
        
        # Create file
        content_id = 'test_file'
        self.file_content = self.addFileByFileUpload(self.test_folder, content_id)
        
        # Delete file
        self.test_folder.manage_delObjects(ids=[content_id])
        
        # Test file
        self.failIf(hasattr(self.test_folder, content_id))
        self.logout()
        
# #############################################################################
# FIELD OPERATIONS
# #############################################################################
    def testDeleteField(self):
        self.loginAsPortalOwner()
        
        # Create content
        content_id = 'test_file'
        file_content = self.addFileByFileUpload(self.test_folder, content_id)
        
        # Get file field
        file_field = file_content.getField('file')
        
        # Get file value
        file_value = file_field.get(file_content)
        
        # Test filename
        self.assertEquals(file_value.filename, 'word.doc')
        
        # Test size
        self.assertEquals(file_value.get_size(), 10240)
        
        # Test content type
        self.assertEquals(file_field.getContentType(file_content), 'application/msword')
        
        # Delete file field value
        file_field.set(file_content, 'DELETE_FILE')
        
        # Get file value
        file_value = file_field.get(file_content)
        
        self.assertEquals(file_value, '')
    
    def testModifyField(self):
        self.loginAsPortalOwner()
        
        # Create content
        content_id = 'test_file'
        file_content = self.addFileByFileUpload(self.test_folder, content_id)
        
        # Get file field
        file_field = file_content.getField('file')
        
        # Get file value
        file_value = file_field.get(file_content)
        
        # Test filename
        self.assertEquals(file_value.filename, 'word.doc')
        
        # Test size
        self.assertEquals(file_value.get_size(), 10240)
        
        # Test content type
        self.assertEquals(file_field.getContentType(file_content), 'application/msword')
        
        # Delete file field value
        new_value = 'example of content'
        file_field.set(file_content, new_value)
        
        # Get file value
        file_value = file_field.get(file_content)
        
        # Test value
        self.assertEquals(str(file_value), new_value)
                
        # Test content type
        self.assertEquals(file_field.getContentType(file_content), 'text/plain')
        
# #############################################################################
# VIRTUAL BINARY OPERATIONS
# #############################################################################
    def testVirtualBinaryAbsoluteUrl(self):
        self.loginAsPortalOwner()
        
        # Create content
        content_id = 'test_file'
        file_content = self.addFileByFileUpload(self.test_folder, content_id)
        
        # Get file field
        file_field = file_content.getField('file')
        
        # Get file value
        file_value = file_field.get(file_content)
        
        # Test absolute_url
        url = '%(instance_url)s/fss_get/%(name)s' % {
            'instance_url': file_content.absolute_url(),
            'name': 'file',
            }
        self.assertEquals(file_value.absolute_url(), url)

def test_suite():
    from unittest import TestSuite, makeSuite
    suite = TestSuite()
    suite.addTest(makeSuite(TestFSS))
    return suite

if __name__ == '__main__':
    framework()
