# -*- coding: utf-8 -*-
#
# File: tool/plonedelib_tool.py
#
# Copyright (c) 2006 atReal
#
# GNU General Public License (GPL)
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
# 02110-1301, USA.
#

"""
$Id$
"""

__author__ = """atReal <contact@atreal.net> : T.Benita, J-N.Bes & M.Broquet"""
__docformat__ = 'plaintext'
__licence__ = 'GPL'


from AccessControl import ClassSecurityInfo
from Products.Archetypes.atapi import *
from Globals import InitializeClass
from Products.CMFCore.utils import UniqueObject
from OFS.SimpleItem import SimpleItem
from OFS.PropertyManager import PropertyManager
from Products.PloneDelib.config import *
from Products.CMFCore.utils import getToolByName
    

class PloneDelibTool(UniqueObject, PropertyManager, SimpleItem):
    """Simple Object
    """
    security = ClassSecurityInfo()
    id = 'plonedelib_tool'
    meta_type = 'PloneDelib Tool'


    # tool-constructors have no id argument, the id is fixed
    def __init__(self):
      return True    

    # tool should not appear in portal_catalog
    def at_post_edit_script(self):
        self.unindexObject()

    def getPlannedActsByMeeting(self):
      """ Return user's planned act by Meeting
      """
      mypath = []
      plannedRes = {} 

      pc = getToolByName(self,'portal_catalog')
      pmt = getToolByName(self,'portal_membership')
      user = pmt.getAuthenticatedMember()

      for folder in pc(portal_type='ServiceFolder'):
        obj = folder.getObject()
        roles = user.getRolesInContext(obj)
        if 'RefDir' in roles:
          mypath.append(folder.getPath())

#      import pdb; pdb.set_trace()

      acts = {}
      acts_set = set()
      actsList = []
      for act in pc(portal_type='Act',path=mypath,state_review='planned'):
        acts[act.UID] = act
        acts_set.add(act.UID)

#      for meeting in pc(portal_type='Meeting',state_review='preparation'):
#        delinks_set = set([delink.getTargetUID for delink in self.portal_catalog(portal_type='Delink',path=meeting.getPath())])

      for meeting in pc(portal_type='Meeting',state_review='preparation'):
        delinks_set = set([delink.getTargetUID for delink in self.portal_catalog(portal_type='Delink',path=meeting.getPath())])
        for uid in acts_set & delinks_set:
          actsList = []
          actsList.append(acts[uid])
        if len(actsList):
          plannedRes[(meeting.Title,meeting.getURL())] = actsList

      return plannedRes


    def getTargetedActsOrFolders(self,param):
      mypath = []
      myfolder = []

      pmt = getToolByName(self,'portal_membership')
      pc = getToolByName(self,'portal_catalog')
      user = pmt.getAuthenticatedMember()
      for folder in pc(portal_type='ServiceFolder'):
        obj = folder.getObject()
        roles = user.getRolesInContext(obj)
        if 'RefDir' in roles:
          myfolder.append(folder)
          mypath.append(folder.getPath())

      if param=='link':
        return myfolder
      else:
        return pc(portal_type='Act',path=mypath,review_state=param)



   
    # XXX A supprimer ou a connserver si reppasage en UID pour les seance suggérées  
    def getMeetingDateFromUid(self, meetuid):
      """
      Returns the date of the suggested meeting
      """
      uidRes = self.uid_catalog(uid=meetuid)
      if not len(uidRes):
        return "Aucune"
      meetRes = self.portal_catalog(id= uidRes[0].id, path=uidRes[0].getPath())
      if not len(meetRes):
        return ""
      #XXX remplacer Title par la date du meeting
      return meetRes[0].Title
    
InitializeClass(PloneDelibTool)
