<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" omit-xml-declaration="yes" encoding="UTF-8" indent="yes"/>

<!-- Transformation for table ca  -->


<xsl:template match="/">
 <xsl:apply-templates select="ROWSET"/>
</xsl:template>

<xsl:template match="ROWSET">
<table width="100%" border="1" cellspacing="1" cellpadding="1">
  <tr>
  <th></th>
  <th>Identifiant</th>
  <th>DN</th>
  <th>Statut</th>
  <th>Racine</th>
  <th>Ac de <br></br> confiance</th>
  <!-- 
  <th>crlissuer</th>
  <th>Statut de révocation</th>
  <th>Date de Début</th>
  <th>Date de Fin</th>
  <th>Politique de <br></br> publication</th>
  <th>PC de validation<br></br>de l'AC</th>
  <th>PC par défaut<br></br>des certificats</th>
  -->
  </tr>
  
  <xsl:if test="count(ROW) = 0">
  <tr><td align="center" colspan="10">Aucune AC</td></tr>
  </xsl:if>
  
  
  <xsl:for-each select="ROW">
	  <tr>
	  <xsl:if test="(position() mod 2) = 0">
		  <xsl:attribute name="class">
		  <xsl:text>altern0</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  <xsl:if test="(position() mod 2) = 1">
		  <xsl:attribute name="class">
		  <xsl:text>altern1</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  <td nowrap="true" align="center"> 
        <input type="radio" name="idca" >
	        <xsl:attribute name="value"><xsl:value-of select="idca"/></xsl:attribute>  	      
		 	<xsl:if test="(position()) = 1">
			  <xsl:attribute name="checked">
			  <xsl:text>checked</xsl:text>
			  </xsl:attribute>
		  	</xsl:if>
	 	</input>                
      </td>
	  <td nowrap="true" align="center"><xsl:value-of select="idca" /></td>
	  <td nowrap="true" align="left"><xsl:value-of select="dn" /></td>
	  <td nowrap="true" align="center"> <xsl:if test="status[.='M']">
	      <xsl:text>Mise à jour</xsl:text></xsl:if>
    	 <xsl:if test="status[.='T']">
      	      <xsl:text>Terminée
      	 </xsl:text>
	     </xsl:if> <xsl:if test="status[.='E']">
      	      <xsl:text>Erreur</xsl:text>
	     </xsl:if>
	     <xsl:if test="status[.='A']">
      	      <xsl:text>Attente</xsl:text>
	     </xsl:if>
	     <xsl:if test="status[.='S']">
      	      <xsl:text>Terminée sans LCR</xsl:text>
	     </xsl:if>
	      </td>
	      
	      <td nowrap="true" align="center"> <xsl:if test="root[.='Y']">
	      <xsl:text>Oui</xsl:text></xsl:if>
    	 <xsl:if test="root[.='N']">
      	      <xsl:text>Non
      	 </xsl:text>
	      </xsl:if>
	      </td>
	       
	      <td nowrap="true" align="center"> <xsl:if test="trustable[.='Y']">
	      <xsl:text>Oui</xsl:text></xsl:if>
    	 <xsl:if test="trustable[.='N']">
      	      <xsl:text>Non
      	 </xsl:text>
	      </xsl:if>
	      </td>
	      <!--  
	      <td nowrap="true" align="center">
	      <xsl:if test="ISCRLPUBLISHER[.='Y']">
	      <xsl:text>Oui</xsl:text></xsl:if>
	      <xsl:if test="ISCRLPUBLISHER[.='N']">
	      <xsl:text>Non</xsl:text>
	      </xsl:if>
	      </td>
	      <td nowrap="true" align="center"> <xsl:if test="LARSTATUS[.='V']">
	      <xsl:text>Valide</xsl:text></xsl:if>
    	 <xsl:if test="LARSTATUS[.='R']">
      	      <xsl:text>Révoquée
      	 </xsl:text>
      	 </xsl:if>
      	 </td>
	        <td nowrap="true" align="left"><xsl:value-of select="BEGINDATE" /></td>
	        <td nowrap="true" align="left"><xsl:value-of select="ENDDATE" /></td>
	        <td nowrap="true" align="left"><xsl:value-of select="LIB" /></td>
	        <td nowrap="true" align="left"><xsl:value-of select="OIDPC" />
	          	 <xsl:if test="OIDPC[.='']">
      	    	  <xsl:text>Aucune</xsl:text>
      			 </xsl:if>
	        </td>
	        <td nowrap="true" align="left"><xsl:value-of select="DFTCERTOIDPC" />
	          	 <xsl:if test="DFTCERTOIDPC[.='']">
      	    	  <xsl:text>Aucune</xsl:text>
      			 </xsl:if>
	        </td>
	        -->
	  </tr>
  </xsl:for-each>
  

</table>
</xsl:template>

</xsl:stylesheet>
