<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" omit-xml-declaration="yes" encoding="UTF-8" indent="yes"/>

<!-- Transformation for table pc  -->


<xsl:template match="/">
 <xsl:apply-templates select="ROWSET"/>
</xsl:template>

<xsl:template match="ROWSET">
<table width="100%" border="1" cellspacing="1" cellpadding="1">
  <tr>
  <th></th>
  <th>OID de PC</th>
  <th>Catégorie</th>
  <th>Type</th>
  <th>Service</th>
  <th>Niveau</th>
  </tr>
  
  <xsl:if test="count(ROW) = 0">
  <tr><td align="center" colspan="10">Aucune politique de certification</td></tr>
  </xsl:if>
  
  
  <xsl:for-each select="ROW">
	  <tr>
	  <xsl:if test="(position() mod 2) = 0">
		  <xsl:attribute name="class">
		  <xsl:text>altern0</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  <xsl:if test="(position() mod 2) = 1">
		  <xsl:attribute name="class">
		  <xsl:text>altern1</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  <td nowrap="true" align="center">
	    <!-- Copier l'indentiant oidpc dans la valeur, selectionner le premier  --> 
        <input type="radio" name="oidpc" >
	        <xsl:attribute name="value"><xsl:value-of select="oidpc"/></xsl:attribute>  	      
		 	<xsl:if test="(position()) = 1">
			  <xsl:attribute name="checked">
			  <xsl:text>checked</xsl:text>
			  </xsl:attribute>
		  	</xsl:if>
	 	</input>                
      </td>
	  <td nowrap="true" align="center"><xsl:value-of select="oidpc" /></td>
	  <td nowrap="true" align="center"><xsl:value-of select="categorie" /></td>
	  <td nowrap="true" align="center"><xsl:value-of select="type" /></td>
	  <td nowrap="true" align="center">
	  	<xsl:if test="service[.='auth']"><xsl:text>Authentification</xsl:text></xsl:if>
        <xsl:if test="service[.='sign']"><xsl:text>Signature</xsl:text></xsl:if>
	    <xsl:if test="service[.='conf']"><xsl:text>Confidentialité</xsl:text></xsl:if>
	    <xsl:if test="service[.='authSign']"><xsl:text>Authentification et Signature</xsl:text></xsl:if>
	    <xsl:if test="service[.='cach']"><xsl:text>Cachet</xsl:text></xsl:if>
	    <xsl:if test="service[.='authChif']"><xsl:text>Authentification Serveur SSL</xsl:text></xsl:if>
	    <xsl:if test="service[.='authSrvClient']"><xsl:text>Authentification Serveur Client</xsl:text></xsl:if>
	    <xsl:if test="service[.='horo']"><xsl:text>Horodatage</xsl:text></xsl:if>
	  </td>
	  <td nowrap="true" align="center">
	    <xsl:if test="niveau[.='1']"><xsl:text>une étoile</xsl:text></xsl:if>
        <xsl:if test="niveau[.='2']"><xsl:text>deux étoiles</xsl:text></xsl:if>
	    <xsl:if test="niveau[.='3']"><xsl:text>trois étoiles</xsl:text></xsl:if>
	  </td>
	</tr>
  </xsl:for-each>
</table>
</xsl:template>

</xsl:stylesheet>
