<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" omit-xml-declaration="yes" encoding="UTF-8" indent="yes"/>

<!-- Transformation for table ca  -->


<xsl:template match="/">
 <xsl:apply-templates select="ROWSET"/>
 
</xsl:template>

<xsl:template match="ROWSET">
<table width="100%" border="1" cellspacing="1" cellpadding="1">
  <tr>
  <th></th>
  <th>OID</th>
  <th>Version</th>
  <th>Nom</th>
  <th>Valide</th>
  <th>Active</th>
  </tr>
  
  <xsl:if test="count(ROW) = 0">
  <tr><td align="center" colspan="4">Aucune politique de validation</td></tr>
  </xsl:if>
  
  
  <xsl:for-each select="ROW">
	  <tr>
	  <xsl:if test="(position() mod 2) = 0">
		  <xsl:attribute name="class">
		  <xsl:text>altern0</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  <xsl:if test="(position() mod 2) = 1">
		  <xsl:attribute name="class">
		  <xsl:text>altern1</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	    
	  <td nowrap="true" align="center"> 
        <input type="radio" name="idvp" >
	        <xsl:attribute name="value"><xsl:value-of select="idvp"/>;<xsl:value-of select="version"/>;<xsl:value-of select="name"/>;<xsl:value-of select="idtrustdom"/></xsl:attribute>  
	          	      
		 	<xsl:if test="(position()) = 1">
			  <xsl:attribute name="checked">
			  <xsl:text>checked</xsl:text>
			  </xsl:attribute>
		  	</xsl:if>
	 	</input>                
      </td>
	  <td nowrap="true" align="center"><xsl:value-of select="idvp" /></td>
	  <td nowrap="true" align="left"><xsl:value-of select="version" /></td>
	  <td nowrap="true" align="left"><xsl:value-of select="name" /></td>
	  <td nowrap="true" align="left">  
	   <xsl:if test="isvalid[.='A']">
	      <xsl:text>A valider</xsl:text></xsl:if>
      <xsl:if test="isvalid[.='R']">
      	      <xsl:text>Refusée</xsl:text>
	      </xsl:if>
	      <xsl:if test="isvalid[.='V']">
      	      <xsl:text>Validée</xsl:text>
	      </xsl:if>
	     </td>
	       <td nowrap="true" align="left">
	        <xsl:if test="isactive[.='Y']">
	      <xsl:text>Active</xsl:text>
	      </xsl:if>
	      <xsl:if test="isactive[.='N']">
	      <xsl:text>Non Active</xsl:text>
	      </xsl:if></td>
	  
	  </tr>
  </xsl:for-each>
  

</table>
</xsl:template>
<xsl:template match="isactive">
<xsl:if test="isvalid[.='A']">
	      <xsl:text>toto</xsl:text></xsl:if>
	      <xsl:if test="isvalid[.='N']">
	      <xsl:text>toto</xsl:text>
	      </xsl:if>
</xsl:template>
</xsl:stylesheet>
