<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" omit-xml-declaration="yes" encoding="UTF-8" indent="yes"/>

<!-- Transformation for table policy  -->


<xsl:template match="/">
 <xsl:apply-templates select="ROWSET"/>
</xsl:template>

<xsl:template match="ROWSET">
<table width="100%" border="1" cellspacing="1" cellpadding="1">
  <tr>
  <th></th>
  <th>Id</th>
  <th>Libellé</th>
  <th>Pkix</th>
  <th>Validité</th>
  <th>Intervalle</th>
  <th>Domaine</th>
  </tr>
  
  <xsl:if test="count(ROW) = 0">
  <tr><td align="center" colspan="8">Aucune politique de publication</td></tr>
  </xsl:if>
  
  
  <xsl:for-each select="ROW">
	  <tr>
	  <xsl:if test="(position() mod 2) = 0">
		  <xsl:attribute name="class">
		  <xsl:text>altern0</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  <xsl:if test="(position() mod 2) = 1">
		  <xsl:attribute name="class">
		  <xsl:text>altern1</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  <td nowrap="true" align="center"> 
        <input type="radio" name="idpol" >
	        <xsl:attribute name="value"><xsl:value-of select="idpol"/></xsl:attribute>  	      
		 	<xsl:if test="(position()) = 1">
			  <xsl:attribute name="checked">
			  <xsl:text>checked</xsl:text>
			  </xsl:attribute>
		  	</xsl:if>
	 	</input>                
      </td>
	  <td nowrap="true" align="center"><xsl:value-of select="idpol" /></td>
	  <td nowrap="true" align="center"><xsl:value-of select="lib" /></td>
	  <td nowrap="true" align="center"><xsl:value-of select="pkix" /></td>
	  <td nowrap="true" align="center"><xsl:value-of select="validity" /></td>
	  <td nowrap="true" align="center"><xsl:value-of select="pollinterval" /></td>
	  <td nowrap="true" align="center"><xsl:value-of select="domlib" /></td>
	  </tr>
  </xsl:for-each>
  

</table>
</xsl:template>

</xsl:stylesheet>
