<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" omit-xml-declaration="yes" encoding="UTF-8" indent="yes"/>

<!-- Transformation for table ca  -->


<xsl:template match="/">
 <xsl:apply-templates select="ROWSET"/>
</xsl:template>

<xsl:template match="ROWSET">
<table width="100%" border="1" cellspacing="1" cellpadding="1">
  <tr>
  <th></th>
  <th>Nom</th>
  <th>Prénom</th>
  <th>Identifiant</th>
  <th>Email</th>
  <th>Reçoit les emails <br></br> de supervision</th>
  <th>Etat</th>
  <th>Rôle</th>
  </tr>
  
  <xsl:if test="count(ROW) = 0">
  <tr><td align="center" colspan="8">Aucun Administrateur</td></tr>
  </xsl:if>
  
  
  <xsl:for-each select="ROW">
	  <tr>
	  <xsl:if test="(position() mod 2) = 0">
		  <xsl:attribute name="class">
		  <xsl:text>altern0</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  <xsl:if test="(position() mod 2) = 1">
		  <xsl:attribute name="class">
		  <xsl:text>altern1</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  
	  <td nowrap="true" align="center"> 
        <input type="radio" name="iduser" >
	        <xsl:attribute name="value"><xsl:value-of select="iduser"/></xsl:attribute>  	      
		 	<xsl:if test="(position()) = 1">
			  <xsl:attribute name="checked">
			  <xsl:text>checked</xsl:text>
			  </xsl:attribute>
		  	</xsl:if>
	 	</input>                
      </td>
	  <td nowrap="true" align="center"><xsl:value-of select="name" /></td>
	  <td nowrap="true" align="left"><xsl:value-of select="firstname" /></td>
	  <td nowrap="true" align="left"><xsl:value-of select="iduser" /></td>
	  <td nowrap="true" align="center"><xsl:value-of select="email" /></td>
	  
	    <td nowrap="true" align="center"> <xsl:if test="receivesemails[.='Y']">
	      <xsl:text>Oui</xsl:text></xsl:if>
     <xsl:if test="receivesemails[.='N']">
      	      <xsl:text>Non</xsl:text>
	      </xsl:if></td>
	  
	  <td nowrap="true" align="center"> <xsl:if test="state[.='A']">
	      <xsl:text>Autorisé</xsl:text></xsl:if>
     <xsl:if test="state[.='S']">
      	      <xsl:text>Suspendu</xsl:text>
	      </xsl:if></td>
	      
	  <td nowrap="true" align="center"> <xsl:if test="role[.='E']">
	      <xsl:text>Exploitant</xsl:text></xsl:if>
     <xsl:if test="role[.='R']">
      	      <xsl:text>Responsable</xsl:text>
	      </xsl:if></td>
	  </tr>
  </xsl:for-each>
  

</table>
</xsl:template>

</xsl:stylesheet>
