<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" omit-xml-declaration="yes" encoding="UTF-8" indent="yes"/>

<!-- Transformation for table pc  -->


<xsl:template match="/">
 <xsl:apply-templates select="ROWSET"/>
</xsl:template>

<xsl:template match="ROWSET">
<table width="100%" border="1" cellspacing="1" cellpadding="1">
  <tr>
  <th></th>
  <th>Status</th>
  <th>Identifiant de PV</th>
  <th>Identifiant d'AC</th>
  <th>OID de PC</th>
  </tr>
  
  <xsl:if test="count(ROW) = 0">
  <tr><td align="center" colspan="10">Aucune association définie</td></tr>
  </xsl:if>
  
  
  <xsl:for-each select="ROW">
	  <tr>
	  <xsl:if test="(position() mod 2) = 0">
		  <xsl:attribute name="class">
		  <xsl:text>altern0</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  <xsl:if test="(position() mod 2) = 1">
		  <xsl:attribute name="class">
		  <xsl:text>altern1</xsl:text>
		  </xsl:attribute>
	  </xsl:if>
	  <td nowrap="true" align="center">
	    <!-- Copier l'indentiant oidpc dans la valeur, selectionner le premier  --> 
        <input type="radio" name="vpcapc" >
	        <xsl:attribute name="value"><xsl:value-of select="idvp"/>|<xsl:value-of select="idca"/>|<xsl:value-of select="oidpc"/></xsl:attribute>  	      
		 	<xsl:if test="(position()) = 1">
			  <xsl:attribute name="checked">
			  <xsl:text>checked</xsl:text>
			  </xsl:attribute>
		  	</xsl:if>
	 	</input>                
      </td>
	  <td nowrap="true" align="center">
	  	<xsl:if test="isvalid[.='M']"><xsl:text>Mise à jour</xsl:text></xsl:if>
    	<xsl:if test="isvalid[.='T']"><xsl:text>Terminée</xsl:text></xsl:if> 
	    <xsl:if test="isvalid[.='E']"><xsl:text>Erreur</xsl:text></xsl:if>
	    <xsl:if test="isvalid[.='A']"><xsl:text>Attente</xsl:text></xsl:if>
	  </td>
	  <td nowrap="true" align="center"><xsl:value-of select="idvp" /></td>
	  <td nowrap="true" align="left"><xsl:value-of select="dn" /></td>
	  <td nowrap="true" align="center"><xsl:value-of select="oidpc" /></td>
	</tr>
  </xsl:for-each>
</table>
</xsl:template>

</xsl:stylesheet>
