use svc;

drop table  if exists ca cascade;
drop table  if exists hashca cascade;
drop table  if exists revoline cascade;
drop table if exists crl cascade;
drop table if exists hcrl cascade;
drop table if exists icrl cascade;
drop table if exists policy cascade;
drop table if exists valdom cascade;
drop table if exists admusr cascade;
drop table if exists log cascade;
drop table if exists requestcrl cascade;

drop table if exists validationpolicy cascade; 
drop table if exists vptrustdom cascade; 
drop table if exists trustdom cascade;
drop table if exists catrustdom cascade;
drop table if exists polparam cascade ;
drop table if exists validpath cascade;
drop table if exists refparam cascade ;
drop table if exists extkeyusage cascade; 
drop table if exists svcparam cascade ;
drop table if exists pcparam cascade ;


/*
oracle

drop sequence crl_seq;
drop sequence ca_seq;
drop sequence dom_seq;
drop sequence pol_seq;
drop sequence trustdom_seq;
drop sequence refparam_seq;
drop sequence vp_seq;
*/

/* start svc pcparam */

 create table pcparam
(	oidpc varchar(256) not null, 
	categorie varchar(150 ), 
	type varchar(150 ), 
	service varchar(150 ), 
	niveau integer, 
	modifdate datetime, 
	modifuserid varchar(30), 
	modifcomment varchar(1024), 
	 constraint pcparam_pk primary key (oidpc)
  );
 
/* end svc pcparam */


/* 
 * start svc pcparam_pk
 * 
 */
 
 
 /* **** oracle 
  create unique index svc.pcparam_pk on svc.pcparam (oidpc);
 ******/
 
create unique index pcparam_pk on pcparam (oidpc);
	
	
	
/* end svc pcparam_pk */


/* start svc vpcacp */

  create table vpcacp 
   (	oidpc varchar(256), 
	idca integer, 
	idvp varchar(255), 
	isvalid char(1), 
	 constraint vpcacp_pk1 primary key (idvp, idca, oidpc)
	);
 

/* end svc vpcacp */


/*
 * start svc vpcacp_pk1
 * 
 */
 
 
 /* *** oracle :   create unique index svc.vpcacp_pk1 on svc.vpcacp (idvp, idca, oidpc) ; *****/
 
 create unique index vpcacp_pk1 on vpcacp (idvp, idca, oidpc);
 
/* 
 * end svc vpcacp_pk1
 */ 


/* 
 * start svc ca
 */
 
    create table ca 
   (	idca integer not null primary key auto_increment, 
	dn varchar(255) not null, 
	data blob not null, 
	status varchar(1) not null, 
	idpol integer not null, 
	root char(1) not null, 
	larstatus char(1) not null, 
	begindate datetime not null, 
	enddate  datetime not null, 
	larlastupdate datetime not null, 
	certnum varchar(150) not null, 
	trustable char(1) not null, 
	name varchar(20), 
	issuerdn varchar(255), 
	keyusage varchar(255), 
	extkeyusage varchar(255), 
	ski varchar(255), 
	aki varchar(255), 
	iscrlpublisher varchar(1), 
	hascrlpublisher integer unique, 
	crldp varchar(4000), 
	oidpc varchar(4000), 
	dftcertoidpc varchar(4000)
	
  )
auto_increment=0  ;
 
/*
 * rem end svc ca
 */
 
 
-- hashca




create table hashca
   (hpk			varchar(255)  not null,
    hdn			varchar(255)  not null,
    idca		integer   not null,
    algo		varchar(10)   not null,
    constraint pk_hashca primary key (hpk, hdn, algo));

alter table hashca
   add constraint fk_hashca
   foreign key (idca) references ca(idca);

-- crl

create table crl
   (idcrlissuer		integer not null,
    idcrl		integer primary key not null auto_increment,
    url			varchar(255) not null,    
    version		varchar(2) not null,
    subject		varchar(1) not null,
    type		varchar(1) not null,
    thisupdate		datetime ,
    nextupdate		datetime ,
    nextpoll		datetime ,
    crlnum		varchar(150) ,
    downloadtime  	datetime,
    issuerdn		varchar(255),
    aki				varchar(255),
    onlycontainscacerts		varchar(1),
    onlycontainsusercerts	varchar(1),
    onlysomereasons			varchar(1),
    valext					integer ,
    crlstatus				varchar(1) ,
    errormsg				varchar(255))
	auto_increment=0;

alter table crl
   add constraint fk_crl
   foreign key (idcrlissuer) references ca(idca);



 
create index id1_crl on crl (idcrl, idcrlissuer);   

-- icrl

create table icrl
   (idcertissuer	integer not null,
    idcrlissuer	 	integer not null,
    idcrl	 	integer not null,
    constraint pk_icrl primary key (idcrlissuer, idcrl));

alter table icrl
   add constraint fk_icrl
   foreign key (idcrl) references crl(idcrl);
   
-- revoline

create table revoline
   (idcertissuer	integer   not null,
    idcrl		integer   not null,
    certnum		varchar(150) not null,
    revodate		datetime 	     not null,
    reason 		varchar(1)
    );

alter table revoline
   add constraint fk_revoline
   foreign key (idcrl) references crl(idcrl);


create index idx_revoline on revoline (idcertissuer, certnum);
alter table revoline add constraint pk_revoline primary key (idcertissuer, certnum); /* using index idx_revoline; */



-- hcrl

create table hcrl
   (idcrl		integer not null,
    crlnum		varchar(150) ,
    basenum		varchar(150) ,
    thisupdate		datetime not null,
    nextupdate		datetime not null,
    data		varchar(500) not null , 
    constraint pk_hcrl primary key (idcrl, data) );

alter table hcrl
   add constraint fk_hcrl
   foreign key (idcrl) references crl(idcrl);


create index id1_hcrl on hcrl (idcrl, thisupdate);   


-- valdom

create table valdom
   (iddom		integer primary key not null auto_increment,
    lib			varchar(500) not null unique)
	auto_increment=0;


-- policy

create table policy
   (idpol		integer primary key not null auto_increment,
    iddom		integer not null,
    lib			varchar(500) not null unique,
    pkix		varchar(1) not null,    
    validity		integer ,
    pollinterval	integer )
	auto_increment=0;

alter table policy
   add constraint fk_policy
   foreign key (iddom) references valdom(iddom);

-- admusr

create table admusr
   (iduser			varchar(30) primary key not null,    
    passwd			varchar(30) not null,
    name  			varchar(500) not null,
    firstname  		varchar(500),
    state  			char(1) not null,
    role 			char(1) not null,
    email 			varchar(255),
    receivesemails 	char(1) );


create index id1_admusr on admusr (state, receivesemails, email);



-- log

create table log
   (iduser		varchar(30) not null,
    logdate		datetime not null,
    lib			varchar(1024) not null, 
    constraint pk_log primary key (iduser, logdate) );
    
alter table log
   add constraint fk_log
   foreign key (iduser) references admusr(iduser);    

-- requestcrl

create table requestcrl
   (idcrl		integer not null,    
    requestdate		datetime not null,
    processdate		datetime ,
    status		varchar(1) not null, 
    constraint pk_requestcrl primary key (idcrl, requestdate) );

create index id1_requestcrl on requestcrl (idcrl, requestdate, status);    



alter table requestcrl
   add constraint fk_requestcrl 
   foreign key (idcrl) references crl(idcrl);
       
-- validationpolicy

create table validationpolicy
   (idvp		varchar(255) not null,
    version		integer not null,
    name		varchar(255) not null unique,
    isvalid		char(1) not null,
    isactive		char(1) not null,
    vercer		char(1) not null,
    valrev		char(1) not null,
    vercac		char(1) not null,
    sigrep		char(1) not null,
    creationdate	datetime not null,
    creationuserid	varchar(30) not null,
    creationcomment	varchar(1024),
    validationdate	datetime,
    validationuserid	varchar(30),
    validationcomment	varchar(1024),        
 constraint pk_validationpolicy primary key (idvp, version));


create index id1_validationpolicy on validationpolicy (idvp, isvalid, isactive);



-- trustdom

create table trustdom
   (idtrustdom varchar(255) primary key not null,
    name varchar(255) not null unique);    
    
-- vptrustdom

create table vptrustdom
   (idtrustdom varchar(255) not null,
    idvp varchar(255) not null,
    isdefault		char(1) not null,
    constraint pk_vptrustdom primary key (idtrustdom,idvp),
    constraint fk_vptrustdom  foreign  key (idtrustdom)  references  trustdom(idtrustdom) );
    

create index id1_vptrustdom on vptrustdom (idvp);     

-- catrustdom

create table catrustdom
   (idca		integer not null,
    idtrustdom		varchar(255) not null,
    constraint pk_catrustdom primary key (idca, idtrustdom),
    constraint fk_catrustdom  foreign  key (idca) references  ca(idca) ,
    constraint fk_catrustdom2 foreign  key (idtrustdom) references  trustdom(idtrustdom) ); 
    
-- validpath
create table validpath
   (idvp		varchar(255) not null,
    version		integer not null,
    idtrustdom		varchar(255) not null, 
    idrootca		integer not null,
    idissuer		integer not null,
    idobject		integer not null,
    pathorder		integer not null,
    creationdate	datetime not null,
    constraint pk_validpath primary key (idvp,version,idtrustdom,idrootca,idobject),
    constraint fk_validpath foreign  key (idrootca) references ca(idca) ,
    constraint fk_validpath2 foreign  key (idissuer) references ca(idca),
    constraint fk_validpath3 foreign  key (idobject) references ca(idca),
    constraint fk_validpath4 foreign  key (idtrustdom,idvp) references vptrustdom(idtrustdom,idvp),
    constraint fk_validpath5 foreign  key (idvp,version) references validationpolicy(idvp,version));

	
	

create index id1_validpath on validpath (idvp,version,idtrustdom,idobject);

   
   
   
-- refparam
create table refparam
   (paramid	integer primary key not null auto_increment,
    paramname	varchar(30) not null,
    modulename	varchar(10) not null);
ALTER TABLE refparam AUTO_INCREMENT = 0;	

-- polparam

create table polparam
   (idvp		varchar(255) not null,
    version		integer not null,
    paramid		integer not null,
    paramvalue		varchar(1024),
     constraint pk_polparam primary key (idvp, version,paramid),
     constraint fk_polparam foreign  key (paramid) references refparam(paramid) ,
     constraint fk_polparam2 foreign  key (idvp,version) references validationpolicy(idvp,version));         

-- extkeyusage

create table extkeyusage
   (oid		varchar(255) primary key not null,
    name	varchar(20) not null unique);
    
    
-- svcparam                                          

create table svcparam
(
    svccertname            varchar(255)          not null,
    svccertnum             varchar(150)          not null,
    svcissuerdn            varchar(255)          not null,
    svcsubject             varchar(255)          not null,
    svcbegindate           datetime                   not null,
    svcenddate             datetime                   not null,
    svcski                 varchar(255)          not null,
    svcaki                 varchar(255)          not null,
    svckeyusage            varchar(255)          not null,
    svcextkeyusage         varchar(255)          not null,
    crlsize                integer             not null,
    constraint pk_svcparam primary key (svccertname)
);    


	
/* oracle
-- prompt creating sequences
-- prompt ==================

create sequence crl_seq
   increment by 1
   start with 1
   nomaxvalue
   nocycle
   cache 10;
   
create sequence ca_seq
   increment by 1
   start with 1
   nomaxvalue
   nocycle
   cache 10;

create sequence dom_seq
   increment by 1
   start with 1
   nomaxvalue
   nocycle
   cache 10;

create sequence pol_seq
   increment by 1
   start with 1
   nomaxvalue
   nocycle
   cache 10;  
   
create sequence trustdom_seq
   increment by 1
   start with 1
   nomaxvalue
   nocycle
   cache 10;

create sequence refparam_seq
   increment by 1
   start with 0
   minvalue 0
   nomaxvalue
   nocycle
   cache 10;

create sequence vp_seq
   increment by 1
   start with 2
   nomaxvalue
   nocycle
   cache 10;

   */

commit;

   
   
   
   

-- prompt initialisation

insert into admusr (iduser, passwd, name, state, role) values ('ADMIN','X03MO1qnZdYdgyfeuILPmQ==','ADMIN','A','R');
/* **** oracle 
insert into valdom (iddom, lib) values (dom_seq.nextval,'minefi');
   

-- prompt alimentation table refparam

insert into  refparam (paramid,paramname,modulename) values (refparam_seq.nextval,'unknown','valrev');

insert into  refparam (paramid,paramname,modulename) values (refparam_seq.nextval,'extendedkeyusage','vercer');

insert into  refparam (paramid,paramname,modulename) values (refparam_seq.nextval,'ac','vercer');

insert into  refparam (paramid,paramname,modulename) values (refparam_seq.nextval,'pathlengthconstraint','vercac');
***/

insert into valdom (lib) values ('minefi');
   

-- prompt alimentation table refparam

insert into  refparam (paramid,paramname,modulename) values (0,'unknown','valrev');

insert into  refparam (paramid,paramname,modulename) values (1,'extendedkeyUsage','vercer');

insert into  refparam (paramid,paramname,modulename) values (2,'aC','vercer');

insert into  refparam (paramid,paramname,modulename) values (3,'pathLengthConstraint','vercac');





-- prompt alimentation table extkeyusage

insert into extkeyusage (oid,name) values ('1.3.6.1.5.5.7.3.1','serverauth');
insert into extkeyusage (oid,name) values ('1.3.6.1.5.5.7.3.2','clientauth');
insert into extkeyusage (oid,name) values ('1.3.6.1.5.5.7.3.3','codesigning');
insert into extkeyusage (oid,name) values ('1.3.6.1.5.5.7.3.4','emailprotection');
insert into extkeyusage (oid,name) values ('1.3.6.1.5.5.7.3.8','timestamping');
insert into extkeyusage (oid,name) values ('1.3.6.1.5.5.7.3.9','ocspsigning');


-- prompt alimentation table trustdom 

insert into trustdom (idtrustdom,name) values ('1.2.250.1.131.1.5.4.7.1.0','svc');


-- prompt alimentation table validationpolicy

insert into validationpolicy (idvp,version,name,isvalid,isactive,vercer,valrev,vercac,sigrep,creationuserid,creationdate) 
values ('1.2.250.1.131.1.5.4.6.1.0',1,'svc_admin','V','Y','Y','N','N','N','ADMIN',sysdate());

insert into validationpolicy (idvp,version,name,isvalid,isactive,vercer,valrev,vercac,sigrep,creationuserid,creationdate) 
values ('1.2.250.1.131.1.5.4.6.1.1',1,'svc_vercac','V','Y','N','N','Y','N','ADMIN',sysdate());

insert into polparam (idvp,version,paramid,paramvalue) values ('1.2.250.1.131.1.5.4.6.1.0',1,2,'Y');

insert into vptrustdom (idvp, idtrustdom, isdefault) values ('1.2.250.1.131.1.5.4.6.1.0','1.2.250.1.131.1.5.4.7.1.0','N');

insert into vptrustdom (idvp, idtrustdom, isdefault) values ('1.2.250.1.131.1.5.4.6.1.1','1.2.250.1.131.1.5.4.7.1.0','N');

insert into  svcparam (svccertname,svccertnum,svcissuerdn,svcsubject,svcbegindate,svcenddate,svcski,svcaki,svckeyusage,svcextkeyusage,crlsize)
values ('svcsignature','41D21A8715B2EF62','cn=IGC V1, o=DG, c=FR','cn=SVCV22, ou=IGC V1, o=DGI, c=FR',str_to_date('2005/11/24 4:28:40','%Y/%m/%d %h:%i:%s'),str_to_date('2010/11/23 4:38:40','%Y/%m/%d %h:%i:%s'),'ski','aki','keyusage','extkeyusage',50000000);




commit;
