/*

  OpenLayers.js -- OpenLayers Map Viewer Library

  Copyright (c) 2006-2012 by OpenLayers Contributors
  Published under the 2-clause BSD license.
  See http://openlayers.org/dev/license.txt for the full text of the license, and http://openlayers.org/dev/authors.txt for full list of contributors.

  Includes compressed code under the following licenses:

  (For uncompressed versions of the code used, please see the
  OpenLayers Github repository: <https://github.com/openlayers/openlayers>)

*/

/**
 * Contains XMLHttpRequest.js <http://code.google.com/p/xmlhttprequest/>
 * Copyright 2007 Sergey Ilinsky (http://www.ilinsky.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 */

/**
 * OpenLayers.Util.pagePosition is based on Yahoo's getXY method, which is
 * Copyright (c) 2006, Yahoo! Inc.
 * All rights reserved.
 * 
 * Redistribution and use of this software in source and binary forms, with or
 * without modification, are permitted provided that the following conditions
 * are met:
 * 
 * * Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 * 
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * 
 * * Neither the name of Yahoo! Inc. nor the names of its contributors may be
 *   used to endorse or promote products derived from this software without
 *   specific prior written permission of Yahoo! Inc.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
 * POSSIBILITY OF SUCH DAMAGE.
 */
function valueFrom(value,defaultValue,allowBlank){if(typeof Ext!="undefined"){return Ext.valueFrom(value,defaultValue,allowBlank);}else{var isEmpty=function(value,allowEmptyString){return(value==null)||(!allowEmptyString?value==='':false)||((toString.call(value)==='[object Array]')&&value.length===0);}
return isEmpty(value,allowBlank)?defaultValue:value;}}
AbstractMapBuilder=new OpenLayers.Class({owscontext:null,keymapVisible:true,keymapVisible:true,id:null,renderTo:null,map:null,keymap:null,alwaysActivCtrls:["zoomin","zoomout","zoomhistory","zoomwheel","InfoCircle","InfoURL","InfoPolygon","InfoPolyline","areaExtractor","edition"],onlyActivCtrls:[],initialize:function()
{if(this.owscontext===null){throw"AbstractMapBuilder : the owscontext property is required for instanciation";}
this.renderTo=OpenLayers.Util.getElement(this.renderTo||document.body)||window;this.id=this.id||OpenLayers.Util.createUniqueID(this.CLASS_NAME+'-');this._cleanMap();this.buildMap();this.addControls();this.buildKeymap();this.buildLegend();this.addLayers();},_cleanMap:function(){if(this.map!=null){this.map.destroy();delete this.map;}},buildMap:function(config)
{var ctx=this.owscontext;var mapOptions={usage:this.usage,maxExtent:ctx.getMaxExtent(),projection:ctx.getProjection(),maxResolution:'auto',fractionalZoom:false,numZoomLevels:128,units:ctx.getProjectionUnits(),resolutions:Carmen.Util.MAP_RESOLUTIONS,controls:[]};if(ctx.hasLayerWMSC()){mapOptions.fractionalZoom=false;mapOptions.numZoomLevels=null;mapOptions.maxResolution=null;mapOptions.resolutions=Carmen.Util.WMSC_RESOLUTIONS;}
var map_minScaleDenom=ctx.getMinScaleDenom();var map_maxScaleDenom=ctx.getMaxScaleDenom();if(map_minScaleDenom!=null&&map_maxScaleDenom!=null){if(mapOptions.resolutions!=null){var res_filtered=[];for(var i=0;i<mapOptions.resolutions.length;i++){var sc=OpenLayers.Util.getScaleFromResolution(mapOptions.resolutions[i],"m").toFixed();if(sc>=map_minScaleDenom&&sc<=map_maxScaleDenom){res_filtered.push(mapOptions.resolutions[i]);}}
mapOptions.resolutions=res_filtered;mapOptions.numZoomLevels=mapOptions.resolutions.length;mapOptions.minScale=map_minScaleDenom;mapOptions.maxScale=map_maxScaleDenom;mapOptions.maxResolution=mapOptions.resolutions[0];mapOptions.minResolution=mapOptions.resolutions[mapOptions.resolutions.length-1];}
else{mapOptions.minScale=map_minScaleDenom;mapOptions.maxScale=map_maxScaleDenom;}}
mainPanel=this.ui.getMainPanel();if(mainPanel){var nodes=mainPanel.getElementsByClassName("PRODIGEAPI_MAP");if(nodes.length){this.renderTo=nodes[0];}}
if(!this.renderTo){this.renderTo=OpenLayers.Util.createDiv(this.id,{x:0,y:0},{w:mainPanel.style.width.replace(/[^\D.-]/g,''),h:mainPanel.style.height.replace(/[^\D.-]/g,'')});this.renderTo.add=this.renderTo.appendChild;this.mainPanel.add(this.renderTo);}
this.map=new Carmen.MapViewer(this.renderTo,mapOptions);this.map.app=this;},isToolActiv:function(toolKey)
{if(this.alwaysActivCtrls.indexOf(toolKey)!=-1)return true;if(this.onlyActivCtrls.length!=0)return this.onlyActivCtrls.indexOf(toolKey)!=-1;return this.owscontext.isToolActiv(toolKey);},addControls:function(config)
{var ctx=this.owscontext;var map=this.map;this.isToolActiv('zoomwheel')&&map.addControl(new Carmen.Control.Navigation({'zoomWheelEnabled':true,dragPanOptions:{enableKinetic:true}}));if(this.isToolActiv('fitall'))
map.addControl(new Carmen.Control.ZoomToMaxExtent({toolbarTarget:ctx.getToolbarTarget('fitall'),toolbarPos:0}));if(this.isToolActiv('zoom')){this.isToolActiv('zoomin')&&map.addControl(new Carmen.Control.ZoomIn({toolbarTarget:ctx.getToolbarTarget('zoom'),toolbarPos:0}));this.isToolActiv('zoomout')&&map.addControl(new Carmen.Control.ZoomOut({toolbarTarget:ctx.getToolbarTarget('zoom'),toolbarPos:1}));this.isToolActiv('zoomhistory')&&map.addControl(new Carmen.Control.ZoomHistory({displayConfig:Carmen.Control.ZoomHistory.PREV_BTN,toolbarTarget:ctx.getToolbarTarget('zoom'),toolbarPos:2}));}
if(this.isToolActiv('pan')){map.addControl(new Carmen.Control.DragPan({toolbarTarget:ctx.getToolbarTarget('pan'),toolbarPos:3}));}
if(this.isToolActiv('info')){map.addControl(new Carmen.Control.Info(window.CARMEN_URL_SERVER_FRONT+'/services/GetInformation/index.php',ctx.mdataMap.mapfile,{toolbarTarget:ctx.getToolbarTarget('info'),toolbarPos:5}));var controlsInfo=["InfoCircle","InfoURL","InfoPolygon"];if(Carmen.Util.FORCE_SPATIAL_SELECTION_TOOLS){controlsInfo=controlsInfo.concat(["InfoPolygon","InfoPolyline"])}
for(var c=0;c<controlsInfo.length;c++){var control=controlsInfo[c];this.isToolActiv(control)&&map.addControl(new Carmen.Control[control](window.CARMEN_URL_SERVER_FRONT+'/services/GetInformation/index.php',ctx.mdataMap.mapfile));}}
if(this.isToolActiv('buffer')){map.addControl(new Carmen.Control.Buffer(window.CARMEN_URL_SERVER_FRONT+'/services/Buffer/index.php',ctx.mdataMap.mapfile));}
if(this.isToolActiv('measure'))
map.addControl(new Carmen.Control.Measure());var controlScaleChooser=null;if(this.isToolActiv('scale')){controlScaleChooser=new Carmen.Control.ScaleChooser();map.addControl(controlScaleChooser);}
if(this.isToolActiv('geobookmark')){geoBookmarkConfig=ctx.getFavoriteAreas();map.addControl(new Carmen.Control.FavoriteAreas(geoBookmarkConfig));}
if(this.isToolActiv('context')){map.addControl(new Carmen.Control.ContextManager(window.CARMEN_URL_SERVER_FRONT+'/services/SaveContext/index.php',ctx.mdataMap.mapfile,{toolbarTarget:ctx.getToolbarTarget('context'),toolbarPos:5}));}
this.getLocateByAddress();if(this.isToolActiv('annotation')){var annotationConfig=ctx.getGeneralConfig('Annotation');var labelConfig=ctx.getGeneralConfig('Label');var annotationOptions={bufferOptions:{serviceUrl:window.CARMEN_URL_SERVER_FRONT+'/services/Buffer/index.php',mapfile:ctx.mdataMap.mapfile}};config=annotationConfig&&labelConfig?{Annotation:annotationConfig,Label:labelConfig}:null;Annotations=new Carmen.Control.AdvancedAnnotation(config,annotationOptions);map.addControl(Annotations);}
if(this.isToolActiv("areaExtractor")&&window.AreaExtractorHandlerURL&&window.AreaExtractorHandlerCallback){var areaExtractor=new Carmen.Control.AreaExtractor({activeAtStartup:true,processResponseURL:AreaExtractorHandlerURL,processResponseCallback:AreaExtractorHandlerCallback,sizeLimit:window.AreaExtractorSizeLimit?window.AreaExtractorSizeLimit:null,rectOnly:window.AreaExtractorRectOnly?window.AreaExtractorRectOnly:false});map.addControl(areaExtractor);this.inAreaExtractor=true;}
if(this.isToolActiv('queryAttributes')){map.addControl(new Carmen.Control.AdvancedQueryAttributes(window.CARMEN_URL_SERVER_FRONT+'/services/AdvancedQueryAttributes/index.php',ctx.mdataMap.mapfile,{toolbarTarget:ctx.getToolbarTarget('queryAttributes'),toolbarPos:4}));}
if(Carmen.Util.FORCE_SPATIAL_QUERY_TOOL||this.isToolActiv('querySpatial')){map.addControl(new Carmen.Control.QuerySpatial(window.CARMEN_URL_SERVER_FRONT+'/services/GetInformation/index.php',ctx.mdataMap.mapfile));}
if(this.isToolActiv('help'))
map.addControl(new Carmen.Control.Help());if(this.isToolActiv('exportImg'))
map.addControl(new Carmen.Control.ExportImg());if(this.isToolActiv('exportPdf'))
map.addControl(new Carmen.Control.ExportPdf());if(this.isToolActiv('print'))
map.addControl(new Carmen.Control.Print({toolbarTarget:ctx.getToolbarTarget('print'),toolbarPos:6}));if(this.isToolActiv('download'))
map.addControl(new Carmen.Control.DataDownload());if(this.isToolActiv('addLayerOGC'))
map.addControl(new Carmen.Control.AddOGC());if(this.isToolActiv('edition')){map.addControl(new Carmen.Control.EditorManager2(window.CARMEN_URL_SERVER_FRONT+'/services/EditionManager/index.php',ctx.mdataMap.mapfile,{workingScale:10000000,callbackUrl:"",user_id:0,emprise_id:0,emprise_tablename:"",modify_object_url:""}));map.addControl(new Carmen.Control.Coordinate());}
if(this.isToolActiv('zoomToPlace')){if(ctx.mdataTool.zoomToPlaceConfig!=null&&ctx.mdataTool.zoomToPlaceConfig!=""){var ztp_config=Url.decode(ctx.mdataTool.zoomToPlaceConfig);var combosConfig=Carmen.Util.chompAndSplit(ztp_config,';');for(var i=0;i<combosConfig.length;i++){combosConfig[i]=Carmen.Util.chompAndSplit(combosConfig[i],'|');}
ztp_configs=[];for(var i=0;i<combosConfig.length;i++){var config={labelText:combosConfig[i][0],fieldNameId:combosConfig[i][2],providerUrl:window.CARMEN_URL_SERVER_FRONT+'/services/GetAreas/index.php',providerBaseParams:{'map':ctx.mdataMap.mapfile,'layer':combosConfig[i][1],'fieldId':combosConfig[i][2],'fieldName':combosConfig[i][3],'fieldEchelle':combosConfig[i][4]}};if(combosConfig[i].length>5){if(combosConfig[i].length==7){var linkedCombo=combosConfig[i][5];config['linkedCombo']=linkedCombo;config['linkedFieldName']='filter_id';config['providerLinkParams']={'filter_item':combosConfig[i][6],'filter_id':''};}else{var linkedCombo=combosConfig[i][4];config['linkedCombo']=linkedCombo;config['linkedFieldName']='filter_id';config['providerLinkParams']={'filter_item':combosConfig[i][5],'filter_id':''};}}
ztp_configs.push(config);}
map.addControl(new Carmen.Control.ZoomToPlace({configs:ztp_configs}));}
else{var config={providerUrl:window.CARMEN_URL_SERVER_FRONT+'/services/GetAreasFromDB/index.php',providerBaseParams:{tablename:'prodige_search_param',service:'0'}};map.addControl(new Carmen.Control.ZoomToPlaceFromDB({config:config}));}};},buildKeymap:function()
{var me=this;var ctx=this.owscontext;var map=this.map;if(this.keymapVisible){var rm_config=ctx.mdataMap.ReferenceMap;var rm_imgUrl=rm_config.OnlineResource.attributes.href;var rm_size=new OpenLayers.Size(rm_config.attributes.width,rm_config.attributes.height);var rm_lc=rm_config.BoundingBox.LowerCorner.split(" ");var rm_uc=rm_config.BoundingBox.UpperCorner.split(" ");var rm_maxExtent=new OpenLayers.Bounds(rm_lc[0],rm_lc[1],rm_uc[0],rm_uc[1]);var rm_projection=ctx.getProjection();var rm_projectionUnits=ctx.getProjectionUnits();var a=document.createElement("img");a.onload=function(){var layerReference=new OpenLayers.Layer.Image("Reference Map",rm_imgUrl,rm_maxExtent,rm_size,{projection:rm_projection,units:rm_projectionUnits,singleTile:true});var RmOptions={size:new OpenLayers.Size(180,100),maximized:true,layers:[layerReference],minRectSize:5,mapOptions:{numZoomLevels:1,maxExtent:rm_maxExtent,projection:rm_projection,units:rm_projectionUnits}};var keymap=new Prodige.Keymap(RmOptions);map.addControl(keymap);me.keymap=keymap;}
a.src=rm_imgUrl;}},buildLegend:function()
{var ctx=this.owscontext;var map=this.map;this.layerTreeManager=new Carmen.Control.LayerTreeManager({visible:this.legendVisible});var jsonLayerTree=ctx.mdataMap.LayerTree;var jsonLayerList=ctx.layer;this.layerTreeManager.buildTree(jsonLayerTree,jsonLayerList);this.layerTreeManager.setMap(this.map);},addCopyrightScale:function(map,baseLayer,ctx)
{if(valueFrom(ctx.mdataMap.inlay,"0")=="1"){var inlayParams={displayTxt:valueFrom(ctx.mdataMap.scaleTxt,"0")=="1",displayImg:valueFrom(ctx.mdataMap.scaleImg,"0")=="1",displayLogo:valueFrom(ctx.mdataMap.logo,"0")=="1",fontSize:valueFrom(ctx.mdataMap.fontSize,null),color:valueFrom(ctx.mdataMap.fontColor,null),backgroundColor:valueFrom(ctx.mdataMap.backgroundColor,null),logoPath:valueFrom(Url.decode(ctx.jsOws.ViewContext.General.LogoURL.OnlineResource.attributes.href),null)};var a=document.createElement("img");a.onerror=function(){inlayParams.logoPath=null;this.onload();};a.onload=function(){if(ctx.mdataMap.font)
OpenLayers.Util.extend(inlayParams,Carmen.Util.carmenFontDescToFontStyles(ctx.mdataMap.font));if(valueFrom(ctx.mdataMap.copyright,"0")=="1"){baseLayer.attribution=Url.decode(ctx.mdataMap.copyrightTxt);map.addControl(new OpenLayers.Control.AttributionCarmen(inlayParams));}else if(valueFrom(ctx.mdataMap.logo,"0")=="1"){baseLayer.attribution="";map.addControl(new OpenLayers.Control.AttributionCarmen(inlayParams));}
if(inlayParams.displayTxt||inlayParams.displayImg){var options=OpenLayers.Util.extend(inlayParams,{serverUrl:window.CARMEN_URL_SERVER_DATA+'/cgi-bin/mapserv',mapfile:ctx.mdataMap.mapfile});map.addControl(new OpenLayers.Control.MapserverScale(options));}};if(inlayParams.logoPath){a.src=inlayParams.logoPath;}else{a.onload();}}},addLayers:function()
{var ctx=this.owscontext;var map=this.map;var layerTree=this.layerTreeManager.getLayerTree();var baseLayer=new Carmen.Layer.MapServerGroup("Base Map",window.CARMEN_URL_SERVER_DATA+"/cgi-bin/mapserv?map="+ctx.mdataMap.mapfile,{map_imagetype:ctx.mdataMap.outputFormat,LAYERS:''},{maxExtent:ctx.getMaxExtent(),projection:ctx.getProjection(),units:ctx.getProjectionUnits(),isBaseLayer:true,singleTile:true});map.addLayer(baseLayer);this.addCopyrightScale(map,baseLayer,ctx)
var labelLayer=new Carmen.Layer.MapServerGroup("Label layer",window.CARMEN_URL_SERVER_DATA+"/cgi-bin/mapserv?map="+ctx.mdataMap.mapfile,{LAYERS:'',map_imagetype:'png',map_transparent:true},{maxExtent:ctx.getMaxExtent(),projection:ctx.getProjection(),units:ctx.getProjectionUnits(),isBaseLayer:false,singleTile:true});var layers=this._buildLayers2(layerTree,ctx,labelLayer);for(var i=layers.length-1;i>=0;i--){var symbolscaledenom=-1;var isProportional=false;for(var a=0;a<ctx.layer.length;a++){if(ctx.layer[a].Title==layers[i].name){if(ctx.layer[a].Extension.TYPE_SYMBO&&ctx.layer[a].Extension.TYPE_SYMBO=="PROPORTIONAL"){isProportional=true;symbolscaledenom=(ctx.layer[a].Extension.layerSettings_symbolScaleDenom?ctx.layer[a].Extension.layerSettings_symbolScaleDenom:-1);}}}
if(isProportional){layers[i].params["ISPROPORTIONAL"]=isProportional;layers[i].params["SYMBOLSCALEDENOM"]=symbolscaledenom;}
if(layers[i].maxExtent==null)
layers[i].maxExtent=ctx.getMaxExtent();if(layers[i].resolutions!=null&&map.resolutions!=null){var newRes=[];if(map_minScaleDenom!=null&&map_maxScaleDenom!=null){for(var k=0;k<layers[i].resolutions.length;k++){var res=layers[i].resolutions[k];var sc=OpenLayers.Util.getScaleFromResolution(res,"m").toFixed();if(sc>=map_minScaleDenom&&sc<=map_maxScaleDenom){newRes.push(res);}}}else
newRes=[].concat(layers[i].resolutions);for(var j=0;j<map.resolutions.length;j++){newRes=OpenLayers.Util.set_add(newRes,map.resolutions[j],OpenLayers.Util.resNearTester);}
newRes.sort(OpenLayers.Util.descendingOrder);map.resolutions=newRes;}
layers[i].setIsBaseLayer(false);map.addLayer(layers[i]);}
map.addLayer(labelLayer);map.setLabelLayer(labelLayer);map.zoomToMaxExtent();},_getProviderUrl:function(providerUrl){var lastCar=providerUrl[providerUrl.length-1];if(lastCar=='?'||lastCar=='&'){return providerUrl;}
if(providerUrl.indexOf("?")==-1){providerUrl+="?";}else{providerUrl+="&";}
return providerUrl;},getLocateByAddress:function(){var c_config="";Ext.Ajax.timeout=120000;Ext.Ajax.request({url:'/services/GetByAddress/index.php',params:{service:'getconfig'},scope:this,success:function(response){var c_res=eval("("+response.responseText+")");c_config=c_res["prodige_settings_value"];if(c_config!=""){this.map.addControl(new Carmen.Control.LocateByAddress({"locateaddress":c_config}));return true;}else
return false;},failure:function(response){return false;}});},NODE_LAYER:0,NODE_GROUP:1,_buildLayers2:function(layerTree,ctx,labelLayer){var layers=new Array();var providerGrp={};this._getProvider2layers(layerTree,providerGrp);for(var i in providerGrp){var layerNames='';if(providerGrp[i]instanceof Array){for(var j=0;j<providerGrp[i].length;j++){var nodes=providerGrp[i];layerNames=layerNames+'+'+providerGrp[i][j].attributes.jsonLayerDesc.attributes.name;}
var layer=this._buildLayer2(providerGrp[i],i,ctx,labelLayer);if(layer!=null)
layers[layers.length]=layer;}}
return layers;},_getProvider2layers:function(node,provider2layers){if(node.attributes.type==this.NODE_LAYER){var providerId=node.attributes.providerId;if(!(provider2layers[providerId]instanceof Array)){provider2layers[providerId]=new Array();}
provider2layers[providerId].push(node);}
else if(node.attributes.type==this.NODE_GROUP){for(var i=0;i<node.childNodes.length;i++){this._getProvider2layers(node.childNodes[i],provider2layers);}}},_buildMapserverLayer2:function(layerNodes,providerUrl,ctx,labelLayer){var msParams={LAYERS:'',map_imagetype:ctx.mdataMap.outputFormat,map_transparent:'TRUE'};var layerNames="";var handleSelection=false;for(var i=0;i<layerNodes.length;i++){var node=layerNodes[i];var lname=node.attributes.jsonLayerDesc.attributes.name;layerNames=layerNames+'+'+lname;handleSelection=handleSelection||(layerNodes[i].attributes.jsonLayerDesc.Extension.layerSettings_infoFields!='')}
layerNames=layerNames.slice(1);var projection=ctx.getProjection();var projUnits=Carmen.Util.getProjectionUnits(projection);var mapfile=node.attributes.jsonLayerDesc.Extension.layerSettings_mapfile;mapfile=mapfile!=null?mapfile:ctx.mdataMap.mapfile;var layer=new Carmen.Layer.MapServerGroup(layerNames,providerUrl,msParams,{projection:projection,units:projUnits,singleTile:true,mapfile:mapfile,selectionSupport:handleSelection});layer.setVisibility(false);for(var i=0;i<layerNodes.length;i++){var desc=layerNodes[i].attributes.jsonLayerDesc;var lname=desc.attributes.name;var lvis=!(desc.attributes.hidden=="1");layer.addSubLayer(lname,lvis);var hasLabel=desc.Extension.hasLabel=="1";layerNodes[i].attributes.hasLabel=hasLabel;if(hasLabel){layer.params['map.layer['+lname+']']="LABELREQUIRES '0'";labelLayer.addSubLayer(lname,lvis);labelLayer.params['map.layer['+lname+']']="OPACITY 1 LABELREQUIRES '1'";}}
return layer;},_buildWMSLayer2:function(layerNodes,providerUrl,ctx){var layerNames="";for(var i=0;i<layerNodes.length;i++){var name=layerNodes[i].attributes.jsonLayerDesc.Title;layerNames=layerNames+','+name;}
layerNames=layerNames.slice(1);var firstLayerDesc=layerNodes[0].attributes.jsonLayerDesc;var version=Url.decode(firstLayerDesc.Server.attributes.version);var outputFormat=Url.decode(firstLayerDesc.Extension.wms_format);var projection=valueFrom(Url.decode(firstLayerDesc.Extension.wms_srs),ctx.getProjection(),false);var projUnits=Carmen.Util.getProjectionUnits(projection);var opacity=layerNodes[0].attributes.opacity;var layer=new Carmen.Layer.WMSGroup(layerNames,providerUrl,{LAYERS:'',version:version,format:outputFormat,transparent:true},{isBaseLayer:false,singleTile:true,projection:projection,units:projUnits,opacity:opacity});layer.setVisibility(false);for(var i=0;i<layerNodes.length;i++){var lname=layerNodes[i].attributes.jsonLayerDesc.attributes.name;var lwmsName=layerNodes[i].attributes.jsonLayerDesc.Name
var lvis=!(layerNodes[i].attributes.jsonLayerDesc.attributes.hidden=="1");layer.addSubLayer(lname,lvis,lwmsName);}
return layer;},_buildWMSCLayer2:function(layerNodes,providerUrl,ctx){var layerNames="";for(var i=0;i<layerNodes.length;i++){var name=layerNodes[i].attributes.jsonLayerDesc.Title;layerNames=layerNames+','+name;}
layerNames=layerNames.slice(1);var firstLayerDesc=layerNodes[0].attributes.jsonLayerDesc;var version=Url.decode(firstLayerDesc.Server.attributes.version);var outputFormat=Url.decode(firstLayerDesc.Extension.wms_format);var projection=valueFrom(Url.decode(firstLayerDesc.Extension.wms_srs),ctx.getProjection(),false);var projUnits=Carmen.Util.getProjectionUnits(projection);var opacity=layerNodes[0].attributes.opacity;layerOptions={isBaseLayer:false,buffer:0,tileSize:new OpenLayers.Size(256,256),projection:projection,resolutions:null,units:projUnits,opacity:opacity};var str_boundingbox=valueFrom(firstLayerDesc.Extension.wmsc_boundingbox,null,false);layerOptions.maxExtent=ctx.getMaxExtent();if(str_boundingbox){var sep=str_boundingbox.indexOf(',')!=-1?',':' ';var bb=Carmen.Util.chompAndSplit(Url.decode(str_boundingbox),sep);layerOptions.maxExtent=new OpenLayers.Bounds(bb[0],bb[1],bb[2],bb[3]);}
var str_res=valueFrom(firstLayerDesc.Extension.wmsc_resolution,null,false);if(str_res!=null){str_res=Url.decode(str_res);var sep=str_res.indexOf(',')!=-1?',':' ';var res=Carmen.Util.chompAndSplit(str_res,sep);if(!isNaN(new Number(res[0]))){layerOptions.resolutions=Carmen.Util.array_map(res,parseFloat);}}
var layer=new Carmen.Layer.WMSGroup(layerNames,providerUrl,{LAYERS:'',version:version,format:outputFormat},layerOptions);layer.setVisibility(false);for(var i=0;i<layerNodes.length;i++){var lname=layerNodes[i].attributes.jsonLayerDesc.attributes.name;var lwmsName=layerNodes[i].attributes.jsonLayerDesc.Name;var lvis=!(layerNodes[i].attributes.jsonLayerDesc.attributes.hidden=="1");layer.addSubLayer(lname,lvis,lwmsName);}
return layer;},_buildWMTSLayer2:function(layerNodes,providerUrl,ctx){var layerNames="";for(var i=0;i<layerNodes.length;i++){var name=layerNodes[i].attributes.jsonLayerDesc.Title;layerNames=layerNames+','+name;}
layerNames=layerNames.slice(1);var firstLayerDesc=layerNodes[0].attributes.jsonLayerDesc;var outputFormat=firstLayerDesc.Extension.wms_format;var style=firstLayerDesc.Extension.wmts_style;var tileset=firstLayerDesc.Extension.wmts_tileset;var wmts_layer_name=firstLayerDesc.Extension.wmts_wms_layer;var serverResolution=null;var str_res=Url.decode(firstLayerDesc.Extension.wmts_resolutions);var res=Carmen.Util.chompAndSplit(str_res,' ');if(!isNaN(new Number(res[0]))){serverResolution=Carmen.Util.array_map(res,parseFloat);}
for(var i=0;i<serverResolution.length;i++){serverResolution[i]=(serverResolution[i]/0.75)*0.7500000000000001;}
var matrixIds=[];var str_matrixids=Url.decode(firstLayerDesc.Extension.wmts_matrixids);var ids_matrix=Carmen.Util.chompAndSplit(str_matrixids,' ');var tileOrigins=[];var str_tileOrigins=Url.decode(firstLayerDesc.Extension.wmts_tileorigin);var tileorigins_coords=Carmen.Util.chompAndSplit(str_tileOrigins,' ');for(var i=0;i<ids_matrix.length;i++){var coords=Carmen.Util.chompAndSplit(tileorigins_coords[i],',');var tlc=new OpenLayers.LonLat(parseFloat(coords[0]),parseFloat(coords[1]));matrixIds.push({identifier:ids_matrix[i],topLeftCorner:tlc});}
var str_tileorigin=Url.decode(firstLayerDesc.Extension.wmts_tileorigin);var tileorigin_coords2=Carmen.Util.chompAndSplit(str_tileorigin,' ');var tileorigin_coords=[];for(var i=0;i<tileorigin_coords2.length;i++){tab=Carmen.Util.chompAndSplit(tileorigin_coords2[i].toString(),',')
tileorigin_coords.push(tab[0],tab[1]);}
var tileorigin=new OpenLayers.LonLat(parseFloat(tileorigin_coords[0]),parseFloat(tileorigin_coords[1]));var opacity=layerNodes[0].attributes.opacity;var layer=new Carmen.Layer.WMTSGroup({name:wmts_layer_name,url:providerUrl,layer:wmts_layer_name,matrixSet:tileset,matrixIds:matrixIds,format:"image/png",style:style,opacity:opacity,isBaseLayer:false,serverResolutions:serverResolution,resolutions:serverResolution,visibility:false});for(var i=0;i<layerNodes.length;i++){var lname=layerNodes[i].attributes.jsonLayerDesc.attributes.name;var lwmtsName=layerNodes[i].attributes.jsonLayerDesc.Extension.wmts_wms_layer;var lvis=!(layerNodes[i].attributes.jsonLayerDesc.attributes.hidden=="1");layer.addSubLayer(lname,lvis,lwmtsName);}
return layer;},_buildVectorAsWMSLayer2:function(jsonNode,jsonLayerList){var att=jsonNode.attributes;var item;var jsonLayerDesc=jsonLayerList[att.layerIdx];var providerUrl=this._getProviderUrl(jsonLayerDesc.DataURL.OnLineResource.attributes.url);var layer_Def={title:att.name,layerDefinition:{serverUrl:providerUrl,layerName:att.mapName,featureServerUrl:providerUrl,featureName:att.mapName},options:{visible:(att.visible=="1"),alwaysVisible:false,queryable:queryable,activeToQuery:queryable,activeToToolTip:activeToToolTip,sheetable:false,legend:[],minScale:minScale,maxScale:maxScale,opacity:att.opacity*100,opacityMax:100,metadataURL:jsonLayerDesc.Extension.layerSettings_Metadata,queryLimitedToMapMaxExtent:true,transparent:true,format:outputFormat,singleTile:true,configuration:{attributes:att,jsonLayerDesc:jsonLayerDesc}}};return this._buildWMSLayer2()},_buildVectorLayer2:function(node,ctx){var desc=node.attributes.jsonLayerDesc;var layer=new Carmen.Layer.Vector(desc.Title,{context_kml:desc.Document||desc.DataURL,context_style:desc.Extension.layerSettings_olStyle,useStyleMap:true});layer.setVisibility(true);return layer;},_buildLayer2:function(layerNodes,providerGrpId,ctx,labelLayer){var layer=null;var providerUrl=null;if(!layerNodes)
return;var firstLayerDesc=layerNodes[0].attributes.jsonLayerDesc;if('Server'in firstLayerDesc){if(!('wms_layer'in firstLayerDesc.Extension)){providerUrl=firstLayerDesc.Server.OnlineResource.attributes.href;var isMapserverLayer=(providerUrl.search(/mapserv/i)>0);if(isMapserverLayer){layer=this._buildMapserverLayer2(layerNodes,providerUrl,ctx,labelLayer);}}
else if('Server'in firstLayerDesc){var service=firstLayerDesc.Server.attributes.service;var providerUrl=firstLayerDesc.Server.OnlineResource.attributes.href;var isWMS=(service.search(/WMS/i)>-1);if(isWMS){layer=this._buildWMSLayer2(layerNodes,providerUrl,ctx);}
var isWMSC=valueFrom(firstLayerDesc.Extension.layerSettings_isWmsc,"OFF")=="YES";if(isWMSC){layer=this._buildWMSCLayer2(layerNodes,providerUrl,ctx);}
var isWMTS=valueFrom(firstLayerDesc.Extension.layerSettings_isWmts,"OFF")=="YES";if(isWMTS){layer=this._buildWMTSLayer2(layerNodes,providerUrl,ctx);}}
if(layer!=null){for(var i=0;i<layerNodes.length;i++){var node=layerNodes[i];var layerDesc=layerNodes[i].attributes.jsonLayerDesc;node.attributes.OlLayer=layer;node.attributes.labelLayer=labelLayer;}}}
else if('Document'in firstLayerDesc){node=layerNodes[0];layer=this._buildVectorLayer2(node,ctx);if(layer!=null){node.attributes.OlLayer=layer;}}
return layer;}});OpenLayers.Control.MapserverScale=new OpenLayers.Class(OpenLayers.Control,{MAIN_CSS_CLASS:'PRODIGEAPI_SCALE',serverUrl:'',mapfile:'',scaleImg:null,displayTxt:true,displayImg:true,font:null,fontFamily:'tahoma,arial,helvetica,sans-serif',color:'#000000',fontSize:'12px',fontWeight:'normal',fontStyle:'normal',backgroundColor:null,opacity:1.0,initialize:function(options){OpenLayers.Control.prototype.initialize.apply(this,arguments);this.fontFamily=this.font?this.font+','+this.fontFamily:this.fontFamily;if(this.fontSize&&this.fontSize.search(/^\d+$/g)!=-1)
this.fontSize=this.fontSize+'px';if(this.color&&this.color.charAt(0)!='#')
this.color='#'+this.color;if(this.backgroundColor&&this.backgroundColor.charAt(0)!='#')
this.backgroundColor='#'+this.backgroundColor;if(this.backgroundColor&&this.backgroundColor.length==9){this.opacity=1.0-(parseInt(this.backgroundColor.substring(7,9),16)/255);this.backgroundColor=this.backgroundColor.substring(0,7);}},setMap:function(map){OpenLayers.Control.prototype.setMap.apply(this,arguments);if(!this.div){var mainPanel=this.map.app.ui.getMainPanel();if(mainPanel){var nodes=mainPanel.getElementsByClassName(this.MAIN_CSS_CLASS);if(nodes.length){this.div=nodes[0];}}
this.div=OpenLayers.Util.getElement(this.MAIN_CSS_CLASS);if(!this.div){this.div=OpenLayers.Util.createDiv(OpenLayers.Util.createUniqueID(this.MAIN_CSS_CLASS+'_'),null,null,null,"absolute");OpenLayers.Element.addClass(this.div,this.MAIN_CSS_CLASS);this.map.app.ui.addToDataPanel(this.div);}}},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);this.div.style.display="block";this.div.style.position="absolute";this.div.style.backgroundColor=this.backgroundColor;this.div.style.fontFamily=this.fontFamily;this.div.style.fontWeight=this.fontWeight;this.div.style.color=this.color;this.div.style.fontSize=this.fontSize;this.div.style.fontStyle=this.fontStyle;OpenLayers.Util.modifyDOMElement(this.div,null,null,null,null,null,null,this.opacity);if(!this.scaleImg&&this.displayImg){this.scaleImg=document.createElement("img");this.scaleImg.style.verticalAlign='top';this.div.appendChild(this.scaleImg);}
if(!this.scaleTxt&&this.displayTxt){this.scaleTxt=document.createElement("span");this.scaleTxt.style.verticalAlign='top';this.scaleTxt.style.marginLeft='10px';this.div.appendChild(this.scaleTxt);}
this.map.events.register('moveend',this,this.update);this.update();return this.div;},update:function(){if(this.displayImg&&this.scaleImg){var params={MAP:this.mapfile,MAP_IMAGETYPE:'PNG',MODE:'SCALEBAR',map_resolution:Carmen.Mapserver_DOTS_PER_INCH,SCALE:this.map.getScale()};this.scaleImg.src=this.serverUrl+'?'+
OpenLayers.Util.getParameterString(params);}
if(this.displayTxt&&this.scaleTxt){this.scaleTxt.innerHTML=this.map.getScale()?'Echelle '+Carmen.SpecialChars["around"]+' '+
Carmen.Util.scaleTextFormater(Carmen.Util.roundIntToDigits(this.map.getScale())):'';}},CLASS_NAME:"OpenLayers.Control.MapserverScale"});Carmen.Layer.WMSGroup=new OpenLayers.Class(OpenLayers.Layer.WMS,{subLayers:[],mainLayers:'',wmsName:'',initialize:function(options){OpenLayers.Layer.WMS.prototype.initialize.apply(this,arguments);this.ratio=1.0;this.mainLayers=this.params.LAYERS;this.subLayers=[];if(!this.wmsName&&this.mainLayers&&this.mainLayers.length>0)
this.wmsName=this.mainLayers;if(this.mainLayers.length==0&&this.wmsName)
this.mainLayers=this.wmsName;},hasSubLayers:function(){return this.subLayers.length>0;},addSubLayer:function(layerName,visible,wmsName){var info=this.getSubLayerInfo(layerName);if(info==null){this.subLayers.push({name:layerName,visible:visible,wmsName:wmsName,index:this.subLayers.length});}
else{info.visible=visible;info.wmsName=wmsName;}
var layerVisibility=false;for(var i=0;i<this.subLayers.length;i++){layerVisibility=layerVisibility||this.subLayers[i].visible;}
this.setVisibility(layerVisibility);},moveSubLayer:function(layerName,index){var info=this.getSubLayerInfo(layerName);if(info!=null){var toBeUpdated=this.subLayers.splice(info.index+1);this.subLayers.pop();for(var i=0;i<toBeUpdated.length;i++)
toBeUpdated[i].index=toBeUpdated[i].index-1;this.subLayers=this.subLayers.concat(toBeUpdated);var toBeUpdated=this.subLayers.splice(index);info.index=index;this.subLayers.push(info);for(var i=0;i<toBeUpdated.length;i++)
toBeUpdated[i].index=toBeUpdated[i].index+1;this.subLayers=this.subLayers.concat(toBeUpdated);}},clone:function(obj){if(obj==null){obj=new Carmen.Layer.WMSGroup(this.name,this.url,this.params,this.options);}
obj=OpenLayers.Layer.Grid.prototype.clone.apply(this,[obj]);obj.setVisibility(this.visibility);obj.setIsBaseLayer(this.isBaseLayer);obj.subLayers=[].concat(this.subLayers);obj.mainLayers=this.mainLayers;obj.displayMode=this.DISPLAY_MAP;obj.qstring='';obj.qitem='';return obj;},split:function(index){var res=[];if(index>this.subLayers.length){res.push(this);res.push(null);}
else if(index<0){this.subLayers=[];newLayer=this.clone();res.push(this);res.push(newLayer);}
else{var newLayer=this.clone();newLayer.subLayers=new Array();var subLayers2=new Array();for(var i=0;i<this.subLayers.length;i++){if(i<=index)
subLayers2.push(this.subLayers[i]);else
newLayer.subLayers.push(this.subLayers[i]);}
delete this.subLayers;this.subLayers=subLayers2;for(var i=0;i<this.subLayers.length;i++){this.subLayers[i].index=i;}
for(var i=0;i<newLayer.subLayers.length;i++){newLayer.subLayers[i].index=i;}
res.push(this);res.push(newLayer);}
return res;},getSubLayerInfo:function(layerName){var i=0;while(i<this.subLayers.length&&this.subLayers[i].name!=layerName){i++;}
return(i<this.subLayers.length)?this.subLayers[i]:null;},setSubLayerVisibility:function(layerName,isVisible){var subLayer=this.getSubLayerInfo(layerName);if(subLayer!=null)
subLayer.visible=isVisible;var layerVisibility=false;for(var i=0;i<this.subLayers.length;i++){layerVisibility=layerVisibility||this.subLayers[i].visible;}
this.setVisibility(layerVisibility);this.display(layerVisibility);this.redraw();if(this.map!=null){this.map.events.triggerEvent("changelayer",{layer:this,property:"visibility"});}
this.events.triggerEvent("visibilitychanged");},getVisibility:function(layerName){var vis=true;if(layerName==null||layerName==this.mainLayers)
vis=OpenLayers.Layer.WMS.prototype.getVisibility.apply(this,[]);else
vis=this.getSubLayerVisibility(layerName);return vis;},getSubLayerVisibility:function(layerName){var subLayer=this.getSubLayerInfo(layerName);return subLayer.visible;},_getLayersParam:function(){var str=this.mainLayers;for(var i=0;i<this.subLayers.length;i++){if(this.subLayers[i].visible){str=str+","+this.subLayers[i].wmsName;}}
str=(str.length>0)&&(str.charAt(0)==',')?str.slice(1):str;return str;},redraw:function(){this.params.LAYERS=this._getLayersParam();var redrawn=OpenLayers.Layer.WMS.prototype.redraw.apply(this,arguments);return redrawn;},getURL:function(bounds){bounds=this.adjustBounds(bounds);var imageSize=this.getImageSize();var newParams={'BBOX':this.encodeBBOX?bounds.toBBOX():bounds.toArray(),'WIDTH':imageSize.w,'HEIGHT':imageSize.h};if(this.projection)
newParams.SRS=this.projection;var requestString=this.getFullRequestString(newParams);return requestString;},getLegendIcon:function(layerName){if(layerName==null||layerName.length==0){layerName=this.params.LAYERS.split(' ')[0];}
if(layerName.length==0){alert('Problème dans la récupération du caisson de légende de couches WMS.');return null;}
var getMapParams=Carmen.Util.clone(this.params);delete(this.params['LAYERS']);delete(this.params['REQUEST']);this.params.ICON=layerName;this.params.MODE="legendIcon";var url=OpenLayers.Layer.HTTPRequest.prototype.getFullRequestString.apply(this,[]);this.params=getMapParams;return url;},getLegendGraphicURL:function(layerName){if(layerName==null||layerName.length==0){layerName=this.params.LAYERS.split(' ')[0];}
if(layerName.length==0){alert('Problème dans la récupération du caisson de légende de couches WMS.');return null;}
var getMapParams=Carmen.Util.clone(this.params);delete(this.params['LAYERS']);this.params.LAYER=layerName;this.params.REQUEST='GetLegendGraphic';this.params.EXCEPTIONS='application/vnd.ogc.se_xml';var url=OpenLayers.Layer.HTTPRequest.prototype.getFullRequestString.apply(this,[]);this.params=getMapParams;return url;},getLegendGraphicInfo:function(layerName){if(layerName==null||layerName.length==0){layerName=this.params.LAYERS.split(' ')[0];}
if(layerName.length==0){alert('Problème dans la récupération du caisson de légende de couches WMS.');return null;}
var getMapParams=Carmen.Util.clone(this.params);delete(this.params['LAYERS']);this.params.LAYER=layerName;this.params.REQUEST='GetLegendGraphic';this.params.EXCEPTIONS='application/vnd.ogc.se_xml';var url=OpenLayers.Layer.HTTPRequest.prototype.getFullRequestString.apply(this,[]);this.params=getMapParams;return url;},getFeatureInfoURL:function(layerName,position,imgSize,mapExtent){if(layerName==null||layerName.length==0){layerName=this.params.LAYERS.split(' ')[0];}
if(layerName.length==0){alert('Wrong parameters in GetFeatureInfoURL.');return null;}
var getMapParams=Carmen.Util.clone(this.params);mapExtent=this.adjustBounds(mapExtent);var newParams={'BBOX':this.encodeBBOX?mapExtent.toBBOX():mapExtent.toArray(),'LAYERS':layerName,'QUERY_LAYERS':layerName,'REQUEST':'GetFeatureInfo','FEATURE_COUNT':1,'X':position.x,'Y':position.y,'HEIGHT':imgSize.h,'WIDTH':imgSize.w,'INFO_FORMAT':'application/vnd.ogc.gml'};var url=OpenLayers.Layer.HTTPRequest.prototype.getFullRequestString.apply(this,[newParams]);return url;},getFeatureInfoParams:function(layerName,position,imgSize,mapExtent){if(layerName==null||layerName.length==0){layerName=this.params.LAYERS.split(' ')[0];}
if(layerName.length==0){alert('Wrong parameters in GetFeatureInfoURL.');return null;}
mapExtent=this.adjustBounds(mapExtent);var params=OpenLayers.Util.extend({},this.params);params=OpenLayers.Util.extend(this.params,{'BBOX':mapExtent.toBBOX(),'LAYERS':layerName,'QUERY_LAYERS':layerName,'REQUEST':'GetFeatureInfo','FEATURE_COUNT':1,'X':position.x,'Y':position.y,'HEIGHT':imgSize.h,'WIDTH':imgSize.w,'INFO_FORMAT':'application/vnd.ogc.gml'});return params;},handleSelection:function(lname){return true;},layerNotRespondingHandler:function(){if(this.idImg)
var domImg=document.getElementById(this.idImg);if(domImg)
document.body.removeChild(domImg);alert("Couche WMS","Les couches "+this.control._getLayersParam()+" ne semblent pas joignables. Elles ne seront sans doute ni visibles, ni interrogeables.");},checkLayerWellResponding:function(map,failure){failure=failure==null?this.layerNotRespondingHandler:failure;var oldMap=this.map;this.map=map;this.imageSize=map.getCurrentSize();this.params.EXCEPTIONS='application/vnd.ogc.se_xml';var testImg=document.createElement('img');testImg.src=this.getURL(map.getMaxExtent())+"&test";testImg.style.display='none';testImg.id="testImg";var scope={idImg:"testImg",control:this};testImg.onerror=function(){failure.apply(scope);};document.body.appendChild(testImg);this.imageSize=null;this.map=oldMap;delete this.params.EXCEPTIONS;},CLASS_NAME:"Carmen.Layer.WMSGroup"});Prodige=window.Prodige||{};Prodige.OWSContext=Prodige.OWSContext||{};Prodige.OWSContext.VersionProdige=new OpenLayers.Class({jsOws:null,generalExt:null,layer:[],mapProjection:null,mdataTool:null,mdataMap:null,mdataLayer:null,mapExtent:null,maxExtent:null,mapMinScaleDenom:null,mapMaxScaleDenom:null,initialize:function(context){this.jsOws=context;this.generalExt=this.jsOws.ViewContext.General.Extension;if(this.jsOws.ViewContext.LayerList&&this.jsOws.ViewContext.LayerList.Layer){this.layer=this.jsOws.ViewContext.LayerList.Layer instanceof Array?this.jsOws.ViewContext.LayerList.Layer:[].concat(this.jsOws.ViewContext.LayerList.Layer);this.jsOws.ViewContext.LayerList.Layer=this.layer}
this.parseMdata();},getObj:function(){return this.jsOws;},getProjection:function(){if(this.mapProjection==null)
this.mapProjection=this.jsOws.ViewContext.General.BoundingBox.attributes.crs.split('=')[1].toLocaleUpperCase();return this.mapProjection;},getProjectionUnits:function(){if(this.mapProjectionUnits==null)
this.mapProjectionUnits=Carmen.Util.getProjectionUnits(this.getProjection());return this.mapProjectionUnits;},getExtent:function(){if(this.mapExtent==null){this.mapExtent=Carmen.Util.convertContextBBtoolBounds(this.jsOws.ViewContext.General.BoundingBox);}
return this.mapExtent;},getMaxExtent:function(){if(this.maxExtent==null){this.maxExtent=Carmen.Util.convertContextBBtoolBounds(this.jsOws.ViewContext.General.Extension.MaxBoundingBox);}
return this.maxExtent;},getMaxScaleDenom:function(){if(this.mapMaxScaleDenom==null&&this.jsOws.ViewContext.General.Extension.MaxScaleDenom!=null){this.mapMaxScaleDenom=parseFloat(this.jsOws.ViewContext.General.Extension.MaxScaleDenom);if(this.mapMaxScaleDenom==-1)
this.mapMaxScaleDenom=null;}
return this.mapMaxScaleDenom;},getMinScaleDenom:function(){if(this.mapMinScaleDenom==null&&this.jsOws.ViewContext.General.Extension.MinScaleDenom!=null){this.mapMinScaleDenom=parseFloat(this.jsOws.ViewContext.General.Extension.MinScaleDenom);if(this.mapMinScaleDenom==-1)
this.mapMinScaleDenom=null;}
return this.mapMinScaleDenom;},getTitle:function(){return Url.decode(this.jsOws.ViewContext.General.Title);},getFavoriteAreas:function(){return this.generalExt.GeoBookmark?this.generalExt.GeoBookmark:null;},setExtent:function(bounds){this.jsOws.ViewContext.General.BoundingBox.attributes.minx=bounds.left;this.jsOws.ViewContext.General.BoundingBox.attributes.miny=bounds.bottom;this.jsOws.ViewContext.General.BoundingBox.attributes.maxx=bounds.right;this.jsOws.ViewContext.General.BoundingBox.attributes.maxy=bounds.top;},setLayerVisibility:function(layerIdx,visible){this.jsOws.ViewContext.LayerList.Layer[layerIdx].attributes.hidden=visible?"0":"1";},setGeneralConfig:function(config){for(p in config)
this.generalExt[p]=config[p];},getGeneralConfig:function(configName){var config=null;if(configName in this.generalExt)
config=this.generalExt[configName];return config;},isToolActiv:function(toolName){var toolValue=this.mdataTool[toolName]||"0"
return(toolValue=="1"||toolValue=="ON"||toolValue=="simple"||toolValue=="advanced");},getToolbarTarget:function(toolName){var toolValue=(this.mdataTool[toolName]||"0")
return toolValue;},hasLayerWMSC:function(){var found=false;for(var k in this.mdataLayer){if((this.mdataLayer[k].wmscLayer||"OFF")=="ON"&&(this.mdataLayer[k].isWmts||"NO")=="NO"){found=true;break;}}
return found;},parseMdata:function(){this.mdataTool={};this.mdataMap={};for(var k in this.generalExt){var matched=k.match(/^tool_(.+)$/);if(matched!=null){var toolName=matched[1];this.mdataTool[toolName]=this.generalExt[k];}
else{matched=k.match(/^mapSettings_(.+)$/);if(matched!=null){var setting=matched[1];this.mdataMap[setting]=this.generalExt[k];}
else
this.mdataMap[k]=this.generalExt[k];}}
this.mdataLayer={};if(this.layer){if(this.layer instanceof Array){for(var i=0;i<this.layer.length;i++){var layerName=this.layer[i].Title;this.mdataLayer[layerName]={};for(var k in this.layer[i].Extension){var matched=k.match(/^layerSettings_(.+)$/);var setting=matched!=null?matched[1]:k;this.mdataLayer[layerName][setting]=this.layer[i].Extension[k];}}}
else{var layerName=this.layer.Title;this.mdataLayer[layerName]={};for(var k in this.layer.Extension){var matched=k.match(/^layerSettings_(.+)$/);var setting=matched!=null?matched[1]:k;this.mdataLayer[layerName][setting]=this.layer.Extension[k];}}}},getNextLayerId:function(){return this.layer.length;},addLayerDescs:function(descs){for(var i=0;i<descs.length;i++)
this.layer.push(descs[i]);return(this.layer.length-1);},getLayerDescFromMdataValue:function(attributeName,value){var i=0;for(var k in this.mdataLayer){var v=Url.decode(this.mdataLayer[k][attributeName]);if(v==value){break;}
i++;}
return i<=(this.layer.length-1)?this.layer[i]:null;}});Prodige.OWSContext.VersionCarmen=new OpenLayers.Class({jsOws:null,generalExt:null,layer:[],mapProjection:null,mdataTool:null,mdataMap:null,mdataLayer:null,mapExtent:null,maxExtent:null,annotationAttributes:null,initialize:function(context){this.jsOws=context;this.generalExt=this.jsOws.OWSContext.General.Extension;if(this.jsOws.OWSContext.ResourceList.Layer)
this.layer=this.jsOws.OWSContext.ResourceList.Layer instanceof Array?this.jsOws.OWSContext.ResourceList.Layer:[].concat(this.jsOws.OWSContext.ResourceList.Layer);if(this.jsOws.OWSContext.ResourceList.Layer[0]===undefined)
this.jsOws.OWSContext.ResourceList.Layer=[].concat(this.jsOws.OWSContext.ResourceList.Layer);;this.parseMdata();},getObj:function(){return this.jsOws;},getToolbarTarget:function(toolName){var toolValue=(this.mdataTool[toolName]||"0")
return toolValue;},getProjection:function(){if(this.mapProjection==null)
this.mapProjection=this.jsOws.OWSContext.General.BoundingBox.attributes.crs.split('=').pop().toLocaleUpperCase();return this.mapProjection;},getProjectionUnits:function(){if(this.mapProjectionUnits==null)
this.mapProjectionUnits=Carmen.Util.getProjectionUnits(this.getProjection());return this.mapProjectionUnits;},getExtent:function(){if(this.mapExtent==null){this.mapExtent=Carmen.Util.convertContextBBtoolBounds(this.jsOws.OWSContext.General.BoundingBox);}
return this.mapExtent;},getMaxExtent:function(){if(this.maxExtent==null){this.maxExtent=Carmen.Util.convertContextBBtoolBounds(this.jsOws.OWSContext.General.MaxBoundingBox);}
return this.maxExtent;},getMaxScaleDenom:function(){if(this.mapMaxScaleDenom==null&&this.jsOws.OWSContext.General.Extension.MAXSCALEDENOM!=null){this.mapMaxScaleDenom=parseFloat(this.jsOws.OWSContext.General.Extension.MAXSCALEDENOM);if(this.mapMaxScaleDenom==-1)
this.mapMaxScaleDenom=null;}
return this.mapMaxScaleDenom;},getMinScaleDenom:function(){if(this.mapMinScaleDenom==null&&this.jsOws.OWSContext.General.Extension.MINSCALEDENOM!=null){this.mapMinScaleDenom=parseFloat(this.jsOws.OWSContext.General.Extension.MINSCALEDENOM);if(this.mapMinScaleDenom==-1)
this.mapMinScaleDenom=null;}
return this.mapMinScaleDenom;},getAnnotationAttributes:function(){if(this.annotationAttributes==null){var attrs=null;if(this.mdataTool.attribut_value_annotation){attrs=decodeURIComponent(this.mdataTool.attribut_value_annotation).split(";");for(var i=0;i<attrs.length;i++){attrs[i]=decodeURIComponent(attrs[i]);}}
this.annotationAttributes=attrs;}
return this.annotationAttributes;},getTitle:function(){return Url.decode(this.jsOws.OWSContext.General.Title);},getFavoriteAreas:function(){if(this.generalExt.GeoBookmark){return this.generalExt.GeoBookmark;}
if(this.generalExt.zones_favorites){var fav=decodeURIComponent(this.generalExt.zones_favorites);fav=fav.replace(/'/g,'"');fav=fav.replace(/__G__/g,'\'');return JSON.parse(fav);}
return this.generalExt.GeoBookmark?this.generalExt.GeoBookmark:null;},setExtent:function(bounds){this.jsOws.OWSContext.General.BoundingBox.LowerCorner=bounds.left+" "+bounds.bottom;this.jsOws.OWSContext.General.BoundingBox.UpperCorner=bounds.right+" "+bounds.top;},setLayerVisibility:function(layerIdx,visible){this.jsOws.OWSContext.ResourceList.Layer[layerIdx].attributes.hidden=visible?"0":"1";},setGeneralConfig:function(config){for(p in config)
this.generalExt[p]=config[p];},getGeneralConfig:function(configName){var config=null;if(configName in this.generalExt)
config=this.generalExt[configName];return config;},isToolActiv:function(toolName){var toolValue=this.mdataTool[toolName]||"0";return(toolValue=="1"||toolValue=="ON");},isToolDefined:function(toolName){return this.mdataTool[toolName];},hasLayerWMSC:function(){var found=false;for(var k in this.mdataLayer){if((this.mdataLayer[k].wmscLayer||"OFF")=="ON"){found=true;break;}}
return found;},parseMdata:function(){this.mdataTool={};this.mdataMap={};for(var k in this.generalExt){var matched=k.match(/^tool_(.+)$/);if(matched!=null){var toolName=matched[1];this.mdataTool[toolName]=this.generalExt[k];}
else{matched=k.match(/^mapSettings_(.+)$/);if(matched!=null){var setting=matched[1];this.mdataMap[setting]=this.generalExt[k];}
else
this.mdataMap[k]=this.generalExt[k];}}
this.mdataLayer={};if(this.layer){if(this.layer instanceof Array){for(var i=0;i<this.layer.length;i++){var layerName=this.layer[i].Title;this.mdataLayer[layerName]={};for(var k in this.layer[i].Extension){var matched=k.match(/^layerSettings_(.+)$/);var setting=matched!=null?matched[1]:k;this.mdataLayer[layerName][setting]=this.layer[i].Extension[k];}}}
else{var layerName=this.layer.Title;this.mdataLayer[layerName]={};for(var k in this.layer.Extension){var matched=k.match(/^layerSettings_(.+)$/);var setting=matched!=null?matched[1]:k;this.mdataLayer[layerName][setting]=this.layer.Extension[k];}}}},getNextLayerId:function(){return this.layer.length;},addLayerDescs:function(descs){for(var i=0;i<descs.length;i++)
this.layer.push(descs[i]);return(this.layer.length-1);},getLayerDescFromMdataValue:function(attributeName,value){var i=0;for(var k in this.mdataLayer){var v=Url.decode(this.mdataLayer[k][attributeName]);if(v==value){break;}
i++;}
return i<=(this.layer.length-1)?this.layer[i]:null;},getLayerTreeNodeFromMdataValue:function(attributeName,value){var res=null;if(this.mdataMap.LayerTree.LayerTreeNode!=null)
res=this._findTreeNode(this.mdataMap.LayerTree.LayerTreeNode,attributeName,value);return res;},_findTreeNode:function(node,attributeName,value){var res=null;if(('LayerTreeNode'in node)&&!(node.LayerTreeNode instanceof Array)){node=node.LayerTreeNode;}
if((attributeName in node.attributes)&&(node.attributes[attributeName]==value)){res=node;}
else if(('LayerTreeNode'in node)&&(node.LayerTreeNode instanceof Array)){for(var i=0;i<node.LayerTreeNode.length;i++){var tmp=this._findTreeNode(node.LayerTreeNode[i],attributeName,value);if(tmp!==null){res=tmp;break;}}}
return res;}});Prodige.OWSContext.Reader=function(owscontext){OpenLayers.Util.extend(this,{JSONReader:new OpenLayers.Format.JSON(),XMLReader:new OpenLayers.Format.XML(),read:function(owscontext){if(owscontext){if(typeof owscontext=="object"&&owscontext instanceof XMLDocument){return this.xmlToJson(owscontext.firstChild,true);}
if(/<(OWS|View)Context[^>]*>/.test(String(owscontext))){return this.readXML(owscontext);}
if(/["']?(OWS|View)Context["']?\s*:\s*\{/.test(String(owscontext))){return this.readJSON(owscontext);}}
throw"Prodige.Map.OWSContextReader : unsupported format for owscontext contents.";},readXML:function(owscontext){var nodeXML=this.XMLReader.read(owscontext);var json={};return this.xmlToJson(nodeXML.firstChild,true);},readJSON:function(owscontext){return this.JSONReader.read(owscontext);},xmlToJson:function(xml,isRoot){var obj={};var root=obj;if(isRoot){obj[xml.tagName]={};root=obj;obj=obj[xml.tagName];}
var hasChildElement=false;if(xml.nodeType==1){if(xml.attributes.length>0){obj["attributes"]={};for(var j=0;j<xml.attributes.length;j++){hasChildElement=true;var attribute=xml.attributes.item(j);obj["attributes"][attribute.localName]=attribute.value;}}}
if(xml.hasChildNodes()){var texts=[];for(var i=0;i<xml.childNodes.length;i++){var item=xml.childNodes.item(i);if(item.nodeType==1){hasChildElement=true;var nodeName=item.tagName;if(typeof(obj[nodeName])=="undefined"){obj[nodeName]=this.xmlToJson(item);}else{if(typeof(obj[nodeName].push)=="undefined"){var old=obj[nodeName];obj[nodeName]=[];obj[nodeName].push(old);}
obj[nodeName].push(this.xmlToJson(item));}}else if(item.nodeType==3){texts.push(item);}}}
if(!hasChildElement){root=xml.textContent;}
return root;}});var jsonContext;if(typeof owscontext=="string"){jsonContext=this.read(owscontext);}else if(typeof owscontext=="object"){jsonContext=owscontext;}
if(jsonContext&&typeof jsonContext.OWSContext!="undefined"){Prodige.OWSContext.Version=Prodige.OWSContext.VersionCarmen;}
else if(jsonContext&&typeof jsonContext.ViewContext!="undefined"){Prodige.OWSContext.Version=Prodige.OWSContext.VersionProdige;}
else{throw"Prodige.OWSContext.Reader : Root of the owscontext is not recognized";}
return new Prodige.OWSContext.Version(jsonContext);}
Carmen.MapViewer=new OpenLayers.Class(OpenLayers.Map,{USAGE_API:'API',USAGE_OTHER:'OTHER',app:null,layerTreeManager:null,labelLayer:null,legend:null,toolTipControl:null,selectionLayers:[],CARMEN_EVENT_TYPES:["addSelection","changeSelection","emptySelection","layerTreeLoaded"],initialize:function(options){this.usage=this.USAGE_OTHER;OpenLayers.Util.extend(this.EVENT_TYPES,this.CARMEN_EVENT_TYPES);OpenLayers.Map.prototype.initialize.apply(this,arguments);if(this.usage!=this.USAGE_API){this.events.register("move",this,function(e){this.hideControls();return true;});}},getLayerTreeManager:function(){if(this.layertreeManager==null){var controls=this.getControlsByClass('Carmen.Control.LayerTreeManager');this.layerTreeManager=controls.length==0?null:controls[0];}
return this.layerTreeManager;},getLegend:function(){if(this.legend==null){var legendControls=this.getControlsByClass("Carmen.Control.Legend");if(legendControls.length>0)
this.legend=legendControls[0];}
return this.legend;},clearSelection:function(){for(var i=0;i<this.selectionLayers.length;i++){layer=this.selectionLayers[i];layer.clearSelection();layer.setDisplayMode(Carmen.Layer.MapServerGroup.DISPLAY_MAP);}
this.removeAllSelectionLayers();},clearGraphicalSelection:function(){for(var i=0;i<this.selectionLayers.length;i++){layer=this.selectionLayers[i];layer.setDisplayMode(Carmen.Layer.MapServerGroup.DISPLAY_MAP);}},addLayer:function(layer,idx){for(var i=0,len=this.layers.length;i<len;i++){if(this.layers[i]==layer){var msg=OpenLayers.i18n('layerAlreadyAdded',{'layerName':layer.name});return false;}
else{var pos=layer.fixedPosition;if(pos!=null&&pos<this.layers.length){if(this.layers[pos].fixedPosition!=null&&this.layers[pos].fixedPosition==pos){OpenLayers.Console.warn("Trying to add a layer at a fixed position already taken");return false;}}}}
this.events.triggerEvent("preaddlayer",{layer:layer});layer.div.className="olLayerDiv";layer.div.style.overflow="";this.setLayerZIndex(layer,this.layers.length);if(layer.isFixed){this.viewPortDiv.appendChild(layer.div);}else{this.layerContainerDiv.appendChild(layer.div);}
this.layers.push(layer);layer.setMap(this);if(layer.isBaseLayer){if(this.baseLayer==null){this.setBaseLayer(layer);}else{layer.setVisibility(false);}}else{layer.redraw();}
this.events.triggerEvent("addlayer",{layer:layer});idx=layer.fixedPosition!=null?this.layers.length-1-layer.fixedPosition:idx;if(idx!=null){this.setLayerIndex(layer,idx)}
for(var i=this.layers.length-1;i>=0;i--){var pos=this.layers[i].fixedPosition;if(pos!=null){var stackPos=this.layers.length-1-pos;if(stackPos!=this.getLayerIndex(this.layers[i])){this.setLayerIndex(this.layers[i],stackPos);}}}
for(var i=this.layers.length-1;i>=0;i--){var pos=this.layers[i].fixedPosition;}},addControl:function(control,px){this.controls.push(control);this.addControlToMap(control,px);},addControlToMap:function(control,px){if(control.CLASS_NAME.indexOf("OpenLayers")>-1){OpenLayers.Map.prototype.addControlToMap.apply(this,arguments);}
else{control.setMap(this);if(this.displayProjection&&!control.displayProjection){control.displayProjection=this.displayProjection;}
control.draw();}},getControl:function(id){var returnControl=null;for(var i=0,len=this.controls.length;i<len;i++){var control=this.controls[i];if(control.id==id){returnControl=control;break;}}
return returnControl;},removeControl:function(control){if((control)&&(control==this.getControl(control.id))){if(control.div&&(control.div.parentNode==this.viewPortDiv)){this.viewPortDiv.removeChild(control.div);}
OpenLayers.Util.removeItem(this.controls,control);}},zoomToSuitableExtent:function(bounds,minScale,maxScale){var center=bounds.getCenterLonLat();var zoom=this.getZoomForExtent(bounds);if(minScale&&maxScale){var resolution=this.getResolutionForZoom(zoom);var scale=OpenLayers.Util.getScaleFromResolution(resolution,this.units);var newScale=scale<minScale?minScale:(scale>maxScale?maxScale:scale);if(newScale!=scale){resolution=OpenLayers.Util.getResolutionFromScale(newScale,this.units);zoom=this.getZoomForResolution(resolution);}}else if(minScale){var resolution=this.getResolutionForZoom(zoom);var scale=OpenLayers.Util.getScaleFromResolution(resolution,this.units);var newScale=scale<minScale?minScale:scale;if(newScale!=scale){resolution=OpenLayers.Util.getResolutionFromScale(newScale,this.units);zoom=this.getZoomForResolution(resolution);}}
this.setCenter(center,zoom);},getUniqueLayerName:function(prefix){var pre=(prefix&&prefix.length>0)?prefix:'layer';var i=layers.length;var n=pre+i;while(this.getLayersByName(n).length>0){i++;n=pre+i;}
return n;},setLabelLayer:function(layer){this.labelLayer=layer;},getLabelLayer:function(){return this.labelLayer;},_getTooltipControl:function(){if(this.toolTipControl==null){var toolTipControls=this.getControlsByClass("Carmen.Control.ToolTip");if(toolTipControls.length>0)
this.toolTipControl=toolTipControls[0];}
return this.toolTipControl;},toolTipActivate:function(){this._getTooltipControl();if(this.toolTipControl)
this.toolTipControl.activate();},toolTipDeactivate:function(){this._getTooltipControl();if(this.toolTipControl)
this.toolTipControl.deactivate();},addToSelectionLayers:function(l){Carmen.Util.set_add(this.selectionLayers,l);this.events.triggerEvent('addSelection',{layers:this.selectionLayers});},removeAllSelectionLayers:function(){this.selectionLayers=[];this.events.triggerEvent('emptySelection');},getSelectionLayers:function(){return this.selectionLayers;},hideControls:function(){for(var i in this.controls){if(typeof this.controls[i].hide=="function")
this.controls[i].hide();}},_launchLayerTreeLoaded:function(){this.events.triggerEvent('layerTreeLoaded');},CLASS_NAME:"Carmen.Map"});Prodige.Legend=new OpenLayers.Class(OpenLayers.Control,{MAIN_CSS_CLASS:'PRODIGEAPI_LEGEND',title:'Légende',layerManagerPanel:null,getPanel:function(){if(!this.map)return;var mainPanel=this.map.app.ui.getMainPanel();if(mainPanel){var nodes=mainPanel.getElementsByClassName(this.MAIN_CSS_CLASS);if(nodes.length){this.layerManagerPanel=nodes[0];}}
this.layerManagerPanel=this.layerManagerPanel||OpenLayers.Util.getElement('layerManagerPanel');if(!this.layerManagerPanel){if(!this.layerManagerPanel){this.layerManagerPanel=OpenLayers.Util.createDiv('layerManagerPanel',{x:0,y:0},{w:420,h:420},null,"absolute","1px solid black","hidden",1.0);OpenLayers.Element.addClass(this.layerManagerPanel,this.MAIN_CSS_CLASS);this.layerManagerPanel.innerHTML="<div id='layerManagerPanelTitle'>"+this.title+"</div>";this.map.app.ui.addToDataPanel(this.layerManagerPanel,0,true);}}
this.layerTreePanel=this.layerTreePanel||OpenLayers.Util.getElement('layerManagerPanel');if(!this.layerTreePanel){this.layerTreePanel=OpenLayers.Util.createDiv('layerTreePanel',{x:0,y:0},null,null,"relative",null,"auto",1.0);OpenLayers.Element.addClass(this.layerTreePanel,"treepanel");this.layerManagerPanel.appendChild(this.layerTreePanel);}
return this.layerTreePanel;},layerTree:null,visible:true,styleControler:null,initialize:function(options){OpenLayers.Control.prototype.initialize.apply(this,arguments);this.layerTreeStore=new Prodige.Tree.Store({id:'layerTreeStore',attributes:{expanded:true,text:Prodige.Legend.TREE_NODE_ROOT_LABEL}});},isHidden:false,show:function(){if(this.layerTreeStore.isDrawn){this.getPanel().style.display="";this.getPanel().style.visibility="visible";this.isHidden=false;}else{this.draw();}},hide:function(){if(this.layerTreeStore.isDrawn){this.getPanel().style.display="none";this.isHidden=true;}},draw:function(){var panel=this.getPanel();this.layerTreeStore.draw(panel);this.layerTreeStore.registerEvents();this.initNodes();if(panel){this.isHidden=panel.style.display=="none"||panel.style.visibility=="hidden";}},setMap:function(map){OpenLayers.Control.prototype.setMap.apply(this,arguments);this.layerTreeStore.setRenderer(this.map.app.legendRenderer);this.draw();this.map.app.ui.doLayout();},treeLayoutInit:function(){},initNodes:function(){var me=this;this.layerTreeStore.each(function(n){if(n){me._updateWMSNodeIcon(n);me._updateNodeVisibilityFromScale(n);me._updateLayerProperties(n);}});},initNode:function(n){n.expand();this._updateWMSNodeIcon(n);},buildTree:function(jsonLayerTree,jsonLayerList){this.layerTree=this._buildLayerTree(this.layerTreeStore.getRoot(),jsonLayerTree.LayerTreeNode,jsonLayerList);this.layerTreeStore.setRoot(this.layerTree);},getLayerTree:function(){return this.layerTree;},getSubLayerTreeBy:function(filter){var tree=this.getLayerTree().clone();tree.filterChildNodes(filter);return tree;},_collectVisibilityInfo:function(node){var collector=[];if('type'in node.attributes&&node.attributes.type==Prodige.Legend.NODE_LAYER){collector.push({layerName:node.attributes.layerName,layerIdx:node.attributes.layerIdx,visible:node.attributes.OlLayer.getVisibility(node.attributes.layerName)});}
else if('type'in node.attributes&&node.attributes.type==Prodige.Legend.NODE_GROUP){for(var i=0;i<node.childNodes.length;i++){var infos=this._collectVisibilityInfo(node.childNodes[i]);collector=collector.concat(infos);}}
return collector;},getLayersVisibility:function(){return this._collectVisibilityInfo(this.layerTree);},_filterVisibleNode:function(node){var res=true;res=('type'in node.attributes)&&((node.attributes.type==this.NODE_GROUP&&node.hasChildNodes())||(node.attributes.type==this.NODE_LAYER&&node.attributes.OlLayer.getSubLayerVisibility(node.attributes.jsonLayerDesc.attributes.name)));return res;},_filterWMSLayerNodes:function(n){var type=valueFrom(n.attributes.type,-1,false);var res=(type==Prodige.Legend.NODE_LAYER&&n.attributes.OlLayer instanceof Carmen.Layer.WMSGroup);return res;},_filterMapserverLayerNodes:function(n){var type=valueFrom(n.attributes.type,-1,false);var res=(type==Prodige.Legend.NODE_LAYER&&n.attributes.OlLayer instanceof Carmen.Layer.MapServerGroup);return res;},_groupNodeFilter:function(n){var type=valueFrom(n.attributes.type,-1,false);return(type==Prodige.Legend.NODE_GROUP);},_updateWMSNodeIcon:function(n){if(this._filterWMSLayerNodes(n)){var layer=n.attributes.OlLayer;var layerName=n.attributes.layerName;var info=layer.getSubLayerInfo(layerName);var wmsName='jsonLayerDesc'in n.attributes?n.attributes.jsonLayerDesc.Name:layerName;var layerSettings_isWmsc='jsonLayerDesc'in n.attributes?n.attributes.jsonLayerDesc.Extension.layerSettings_isWmsc=="YES":false;if(!layerSettings_isWmsc){n.data.icon=layer.getLegendGraphicURL(wmsName);n.data.iconCls='cmnLayerTreeLayerWMSNodeIcon';n.attributes.iconDisplayStrategy=true;if(n.attributes.linkedNodes){var legendNode=n.attributes.linkedNodes[0];if(legendNode&&info){n.attributes.iconDisplayStrategy=true;legendNode.data.icon=layer.getLegendGraphicURL(wmsName);legendNode.data.iconCls='cmnLayerTreeLayerWMSNodeIcon';}}}}},_getLegendNode:function(n){var res=n.attributes&&n.attributes.linkedNodes&&n.attributes.linkedNodes.length>0?n.attributes.linkedNodes[0]:null;return res;},_filterOpacityHandlingNodes:function(n){return n.attributes.forceOpacityControl;},CLASS_NAME:"Prodige.Legend",showMetadata:function(node){if(node.attributes.metadata_url!=null){var url=node.attributes.metadata_url;Carmen.Util.openWindowIframe("M&eacute;tadonn&eacute;es de la couche ",url,false,700,500);}},downloadData:function(node){if(node.attributes.download_url!=null)
var url=node.attributes.download_url;window.open(url,"download","location=no, toolbar=no, scrollbars=yes");},removeLayerNode:function(node){var layer=node.attributes.OlLayer;var map=layer.map;map.removeLayer(layer);node.remove();if(node.attributes&&node.attributes.linkedNodes){var legendNode=node.attributes.linkedNodes[0];legendNode.remove();}
return false;},styleLayerNode:function(node){if(!this.styleControler)
this.styleControler=new Carmen.Control.LocalStyler();actualNodeId=node.attributes.layerName;var layer=node.attributes.OlLayer;this.styleControler.activate(layer,node);return false;},sliderChange:function(slider,newVal,thumb,eOpts){var opacity=1.0-(newVal/100);var node=this.node;var olLayers=Carmen.Util.set_from_array(node.collect('OlLayer'));for(var i=0;i<olLayers.length;i++){olLayers[i].setOpacity(opacity);}
var layerOrClassNodes=node.collectChildNodes(function(n){return('type'in n.attributes&&(n.attributes.type==Prodige.Legend.NODE_LAYER||n.attributes.type==Prodige.Legend.NODE_CLASS));});var sliderNodes=node.collectChildNodes(function(n){return n.attributes.forceOpacityControl;});},NODE_LAYER:0,NODE_GROUP:1,NODE_CLASS:2,NODE_FEATURE:3,_getLayer:function(jsonLayerList,layerName){var layer=null;if(jsonLayerList instanceof Array){var i=0;while(i<jsonLayerList.length&&jsonLayerList[i].attributes.name!=layerName){i++;}
if(i<jsonLayerList.length){layer=jsonLayerList[i];}}
else{if(jsonLayerList.attributes.name!=layerName){layer=jsonLayerList;}}
return layer;},_getSingleClassLegendUrl:function(jsonLayerDesc){var url=window.CARMEN_URL_SERVER_FRONT+'/IHM/images/NoTreeIcon.gif';if('StyleList'in jsonLayerDesc){if('Style'in jsonLayerDesc.StyleList&&!(jsonLayerDesc.StyleList.Style instanceof Array)&&'LegendURL'in jsonLayerDesc.StyleList.Style){var url=jsonLayerDesc.StyleList.Style.LegendURL.OnlineResource.attributes.href;}}
return url;},_buildMutliClassLegend:function(jsonLayerDesc,displayClass){var classeNodes=[];for(var i=0;i<jsonLayerDesc.StyleList.Style.length;i++){if(displayClass!=null&&displayClass[i]!="OFF"){var style=jsonLayerDesc.StyleList.Style[i];var url=style.LegendURL.OnlineResource.attributes.href;if(style.Name!=""){var classNode={text:style.Title,icon:url};classeNodes.push(classNode);}}}
return classeNodes;},_buildLayerTree:function(parentNode,jsonNode,jsonLayerList){var tree=this._buildLayerTree_aux_ext5(parentNode,jsonNode,jsonLayerList);return tree;},_buildLayerTree_aux_ext5:function(parentNode,jsonNode,jsonLayerList){var att=jsonNode.attributes;var groupNode=(att.type=="group");var jsonLayerDesc=jsonLayerList[att.layerIdx];var multiClass=!groupNode&&('StyleList'in jsonLayerDesc)&&('Style'in jsonLayerDesc.StyleList)&&(jsonLayerDesc.StyleList.Style instanceof Array);var nameSymbo="";var tmp_layer=this._getLayer(jsonLayerList,jsonNode.attributes.mapName);if(tmp_layer&&tmp_layer.Extension.TYPE_SYMBO&&tmp_layer.Extension.TYPE_SYMBO=="PROPORTIONAL"){var scale=(this.map?this.map.getScale():1);var symbolsscaledenom=(tmp_layer.Extension.layerSettings_symbolScaleDenom?tmp_layer.Extension.layerSettings_symbolScaleDenom:-1);nameSymbo="<table style='display:inline'>"+" <tr><td id='"+tmp_layer.Title+"_valueSymboHigh'><span class='valueSymboHigh'>&nbsp;</span></td></tr>"+" <tr><td id='"+tmp_layer.Title+"_valueSymboLow'><span class='valueSymboLow'>&nbsp;</span></td></tr>"+"</table> "+att.name;}else{nameSymbo=att.name;}
var node=parentNode.createNode({text:att.name=="root"?Prodige.Legend.TREE_NODE_ROOT_LABEL:nameSymbo,leaf:!groupNode,expandable:true,expanded:(groupNode&&att.open=="1")||multiClass,checked:(groupNode?false:jsonLayerDesc.attributes.hidden=="0"),cls:(!groupNode&&'layerSettings_MetadataFile'in jsonLayerDesc.Extension)?'cmnLayerTreeLayerNodeMetadata':'',iconCls:groupNode?'cmnLayerTreeGroupNodeIcon':!jsonNode.iconStyle?'cmnLayerTreeLayerNodeIcon':null,icon:jsonNode.iconStyle?null:groupNode||multiClass?'/IHM/images/empty.gif':this._getSingleClassLegendUrl(jsonLayerDesc),allowDrop:groupNode});node.attributes={};node.attributes.iconCls=groupNode?'cmnLayerTreeGroupNodeIcon':(!jsonNode.iconStyle?'cmnLayerTreeLayerNodeIcon':null);node.attributes.visible=true;node.attributes.opacity=parseFloat(valueFrom(att.opacity,"1.0",false));node.attributes.forceOpacityControl=parseInt(valueFrom(att.forceOpacityControl,"0",false))==1;node.attributes.iconDisplayStrategy=parseInt(valueFrom(att.iconDisplayStrategy,"0",false))==1;if(groupNode){node.attributes.type=this.NODE_GROUP;if('LayerTreeNode'in jsonNode){if(jsonNode.LayerTreeNode instanceof Array){for(var i=0;i<jsonNode.LayerTreeNode.length;i++){var subNode=jsonNode.LayerTreeNode[i];if(typeof subNode.LayerTreeNode!="undefined"&&!(subNode.LayerTreeNode instanceof Array)){subNode=subNode.LayerTreeNode;}
node.appendChild(this._buildLayerTree_aux_ext5(parentNode,subNode,jsonLayerList));}}
else
node.appendChild(this._buildLayerTree_aux_ext5(parentNode,jsonNode.LayerTreeNode,jsonLayerList));}
node.attributes.expanded=(att.open=="1");node.attributes.checked=this._hasChildNodeChecked(node)>0;}
else{var displayClassLegend=valueFrom(Url.decode(jsonLayerDesc.Extension.layerSettings_ActivThemes),'ON',false);if(displayClassLegend=="OFF"){node.attributes.visible=false;}
else if(multiClass){var displayClass=displayClassLegend.split('|');displayClass=displayClass.length>0?displayClass:null;var classLegend=this._buildMutliClassLegend(jsonLayerDesc,displayClass);node.attributes.classLegend=classLegend;}
node.attributes.jsonLayerDesc=this._getLayer(jsonLayerList,att.mapName);node.attributes.jsonLayerDesc=jsonLayerList[att.layerIdx];node.attributes.layerIdx=att.layerIdx;node.attributes.layerName=node.attributes.jsonLayerDesc.attributes.name;if(node.attributes.jsonLayerDesc.Extension.layerSettings_infoFields)
node.attributes.infoFields=decodeURIComponent(node.attributes.jsonLayerDesc.Extension.layerSettings_infoFields);if(node.attributes.jsonLayerDesc.Extension.layerSettings_briefFields)
node.attributes.briefFields=decodeURIComponent(node.attributes.jsonLayerDesc.Extension.layerSettings_briefFields);if(node.attributes.jsonLayerDesc.Extension.layerSettings_ToolTipFields)
node.attributes.toolTipFields=decodeURIComponent(node.attributes.jsonLayerDesc.Extension.layerSettings_ToolTipFields);node.attributes.infoData="";node.attributes.baseQueryURL=decodeURIComponent(node.attributes.jsonLayerDesc.Extension.layerSettings_queryURL);var minScale=valueFrom(node.attributes.jsonLayerDesc.MinScaleDenominator,null,false);minScale=minScale!=null?parseFloat(minScale):minScale;if(!isNaN(minScale))
node.attributes.minScale=minScale;var maxScale=valueFrom(node.attributes.jsonLayerDesc.MaxScaleDenominator,null,false);maxScale=maxScale!=null?parseFloat(maxScale):maxScale;if(!isNaN(maxScale))
node.attributes.maxScale=maxScale;node.attributes.type=this.NODE_LAYER;node.attributes.providerId=att.providerGrpId;node.attributes.initialChecked=jsonLayerDesc.attributes.hidden=="0";node.attributes.metadata_url='MetadataURL'in jsonLayerDesc?Url.decode(jsonLayerDesc.MetadataURL.OnlineResource.attributes.href):null;node.attributes.download_url='DataURL'in jsonLayerDesc?Url.decode(jsonLayerDesc.DataURL.OnlineResource.attributes.href||jsonLayerDesc.DataURL.OnlineResource.attributes.url):null;}
node.attributes.open=(groupNode&&att.open=="1")||multiClass;return node;},updateTreeNodes:function(node,f,ctx,applyToChildrenFilter){ctx=valueFrom(ctx,null,false);if(ctx==null)
f(node);else
f.call(this,node);if(applyToChildrenFilter!=null&&!applyToChildrenFilter(node))
return;for(var i=0;i<node.childNodes.length;i++){this.updateTreeNodes(node.childNodes[i],f,ctx,applyToChildrenFilter);}},_updateNodeVisibilityFromScale:function(node){if(node.attributes.type==this.NODE_LAYER){if(node.attributes.minScale&&node.attributes.maxScale){this.map.events.registerPriority('zoomend',{node:node,control:this},this.updateNodeFromScale);this.updateNodeFromScale.apply({node:node,control:this});}}},_countChecked:function(n){var res=0;if(n.isLeaf()){res=n.get('checked')?1:0;}
else{for(i=0;i<n.childNodes.length;i++){res=res+this._countChecked(n.childNodes[i]);}}
return res;},_updateNodeCheck:function(node){if(!node.isLeaf())
node.set('checked',this._hasChildNodeChecked(node));},_updateNodeCollapse:function(node){if(node.attributes.open)
node.expand();else
node.collapse();},_hasChildNodeChecked:function(node){var res=false;var i=0;while((!res)&&i<node.childNodes.length){res=res||(node.childNodes[i].data.checked===true);i++;}
if(!res){var i=0;while((!res)&&i<node.childNodes.length){res=res||this._hasChildNodeChecked(node.childNodes[i]);i++;}}
return res;},_updateLayerProperties:function(node){if(this._filterMapserverLayerNodes(node)){var olLayer=node.attributes.OlLayer;var lname=node.attributes.layerName;if(olLayer.handleSelection(lname)&&node.attributes.infoFields){var fieldsDesc=Carmen.Util.buildFieldsDesc(node.attributes.infoFields,node.attributes.baseQueryURL);var colModel=Carmen.Util.buildColumnModel(fieldsDesc,false,true);olLayer.setSelectionConfig(lname,{store:null,cm:colModel});}}},updateNodeFromScale:function(){node=this.node;view=this.view;control=this.control;var desc=node.attributes.jsonLayerDesc;var olLayer=node.attributes.OlLayer;var scaleDependant=(desc.Extension&&desc.Extension.layerSettings_legendScaleDisplay&&desc.Extension.layerSettings_legendScaleDisplay=='ON');if(olLayer!=null&&olLayer.map!=null){var scale=olLayer.map.getScale();scale=scale>0?Math.round(scale):scale;var outOfScale=(scale>desc.MaxScaleDenominator||scale<desc.MinScaleDenominator);var layerVisible=!outOfScale;olLayer.setSubLayerVisibility(node.attributes.layerName,layerVisible);var el=OpenLayers.Util.getElement(node.id);if(!el)return;if(outOfScale){if(scaleDependant){OpenLayers.Element.removeClass(el,'hidden');OpenLayers.Element.addClass(el,'hidden');}
else{OpenLayers.Element.removeClass(el,'disabled');OpenLayers.Element.addClass(el,'disabled');node.recurse(function(){OpenLayers.Element.removeClass(this,'disabled');OpenLayers.Element.addClass(this,'disabled');});}}
else{if(scaleDependant){OpenLayers.Element.removeClass(el,'hidden');}
else{OpenLayers.Element.removeClass(el,'disabled');node.recurse(function(){OpenLayers.Element.removeClass(this,'disabled');});}}
control.updateLegendNodeVisibility(node);}},updateLegendNodeVisibility:function(node,noRefresh){if(node.attributes&&node.attributes.linkedNodes){var legendNode=node.attributes.linkedNodes[0];var checked=node.get('checked');var visibility=checked&&(node.get('disabled')!=true)&&node.attributes.visible;var legendTreePanel=legendNode.getOwnerTree();if(legendTreePanel){legendNode.attributes.visibility=visibility;}}},cloneLayerTree:function(newRoot,transform){var root=this.layerTreePanel.getRootNode();if(!newRoot){newRoot=root.copy();if(root.attributes)
newRoot.attributes=root.attributes;if(transform!=null)
newRoot=transform.apply(this,[newRoot]);}
for(i=0;i<root.childNodes.length;i++){newRoot.appendChild(root.childNodes[i].clone(transform));}
return newRoot;},findPreviousLayer:function(groupNode,index){var res=null;if(index==0){res=groupNode.getDepth()==0?null:this.findPreviousLayer(groupNode.parentNode,groupNode.parentNode.indexOf(groupNode));}
else{var brother=groupNode.childNodes[index-1];var layers=brother.collect("OlLayer",true);res=layers[layers.length-1];}
return res;},linkLayerToNode:function(OLlayer,parentNode){var layerNames=[];for(var i=0;i<OLlayer.subLayers.length;i++){layerNames.push(OLlayer.subLayers[i].name);}
var layerNodesToUpdate=parentNode.collectChildNodes(function(n){return('layerName'in n.attributes&&Carmen.Util.set_member(layerNames,n.attributes.layerName));});for(var i=0;i<layerNodesToUpdate.length;i++){var n=layerNodesToUpdate[i];n.attributes.OlLayer=OLlayer;}},moveGroupNode:function(node,oldParent,newParent,indexNode){listNodes=oldParent.childNodes;var prevIndex=node.attributes.index;var bb=node.previousSibling;var ba=node.nextSibling;if(bb!=null&&ba!=null&&bb.attributes.type==this.NODE_LAYER&&ba.attributes.type==this.NODE_LAYER&&bb.attributes.OlLayer==ba.attributes.OlLayer){var index=ba.attributes.OlLayer.getSubLayerInfo(ba.attributes.layerName).index-1;var newLayers=ba.attributes.OlLayer.split(index);this.linkLayerToNode(newLayers[1],newParent);var pos=this.map.getLayerIndex(bb.attributes.OlLayer);this.map.addLayer(newLayers[1],pos);newLayers[0].redraw();newLayers[1].setVisibility(true);}
var layerBefore=this.findPreviousLayer(newParent,indexNode);var startIndex=layerBefore==null?this.map.layers.length:this.map.getLayerIndex(layerBefore);layersToMove=Carmen.Util.set_from_array(node.collect('OlLayer',true));for(var i=0;i<layersToMove.length;i++){this.map.setLayerIndex(layersToMove[i],(startIndex-1)-i);}
newParent.updateIndex(true);},getLastLayerFromGroupNode:function(node){var res=node;if(node.hasChildNodes()){var lastChild=node.childNodes[node.childNodes.length-1];if('type'in lastChild.attributes){switch(lastChild.attributes.type){case this.NODE_GROUP:res=this.getLastLayerFromGroupNode(lastChild);break;case this.NODE_LAYER:res=lastChild.attributes.OlLayer;break;default:res=null;break;}}}
return res;},getFirstLayerFromGroupNode:function(node){var res=null;if(node.hasChildNodes()){var firstChild=node.childNodes[0];if('type'in firstChild.attributes){switch(firstChild.attributes.type){case this.NODE_GROUP:res=this.getFirstLayerFromGroupNode(firstChild);break;case this.NODE_LAYER:res=firstChild.attributes.OlLayer;break;default:res=null;break;}}}
return res;},updateNodeLayerControl:function(node){var layer=node.attributes.OlLayer;},moveLayerNode:function(node,oldParent,newParent,indexNode){listNodes=oldParent.childNodes;var prevIndex=node.attributes.index;var descending=prevIndex<indexNode;indexNode=descending?indexNode-1:indexNode;var bb=node.previousSibling;var ba=node.nextSibling;var pbb=null;var pba=null;var i=0;while(i<listNodes.length&&(pba==null||pbb==null)){if(listNodes[i].attributes.index==prevIndex-1){pbb=listNodes[i];}
else{if(listNodes[i].attributes.index==prevIndex+1)
pba=listNodes[i];}
i++;}
var Lpos_node=node.attributes.layerIdx;if((pbb!=null)&&(pbb.attributes.type==this.NODE_LAYER)&&(pbb.attributes.OlLayer==node.attributes.OlLayer)&&((!descending&&(ba!=null)&&((ba.attributes.type==this.NODE_LAYER&&ba.attributes.OlLayer!=node.attributes.OlLayer)||ba.attributes.type==this.NODE_GROUP))||(descending&&(bb!=null)&&((bb.attributes.type==this.NODE_LAYER&&bb.attributes.OlLayer!=node.attributes.OlLayer)||bb.attributes.type==this.NODE_GROUP)))){var indexSLn=node.attributes.OlLayer.getSubLayerInfo(node.attributes.layerName).index-1;var newLayers=pbb.attributes.OlLayer.split(indexSLn);this.linkLayerToNode(newLayers[1],newParent);var indexLpbb=this.map.getLayerIndex(pbb.attributes.OlLayer);this.map.addLayer(newLayers[1],indexLpbb);newLayers[0].redraw();newLayers[1].setVisibility(true);}
if((pba!=null)&&(pba.attributes.type==this.NODE_LAYER)&&(pba.attributes.OlLayer==node.attributes.OlLayer)&&((!descending&&(ba!=null)&&((ba.attributes.type==this.NODE_LAYER&&ba.attributes.OlLayer!=node.attributes.OlLayer)||ba.attributes.type==this.NODE_GROUP))||(descending&&(bb!=null)&&((bb.attributes.type==this.NODE_LAYER&&bb.attributes.OlLayer!=node.attributes.OlLayer)||bb.attributes.type==this.NODE_GROUP)))){var indexSLn=node.attributes.OlLayer.getSubLayerInfo(node.attributes.layerName).index;var newLayers=node.attributes.OlLayer.split(indexSLn);this.linkLayerToNode(newLayers[1],newParent);var indexLn=this.map.getLayerIndex(node.attributes.OlLayer);this.map.addLayer(newLayers[1],indexLn);newLayers[0].redraw();newLayers[1].setVisibility(true);}
if(bb!=null){var Lpos_bb=bb.attributes.layerIdx;if(bb.attributes.type==this.NODE_LAYER){if(bb.attributes.OlLayer==node.attributes.OlLayer){var indexSLbb=bb.attributes.OlLayer.getSubLayerInfo(bb.attributes.layerName).index;indexSLn=descending?indexSLbb:indexSLbb+1;node.attributes.OlLayer.moveSubLayer(node.attributes.layerName,indexSLn);}
else{if(ba!=null){if(ba.attributes.type==this.NODE_LAYER){if(ba.attributes.OlLayer==bb.attributes.OlLayer){var indexSLba=ba.attributes.OlLayer.getSubLayerInfo(ba.attributes.layerName).index;var newLayers=ba.attributes.OlLayer.split(indexSLba-1);this.linkLayerToNode(newLayers[1],newParent);var indexLbb=this.map.getLayerIndex(bb.attributes.OlLayer);this.map.addLayer(newLayers[1],indexLbb);newLayers[0].redraw();newLayers[1].setVisibility(true);var indexLbb=this.map.getLayerIndex(bb.attributes.OlLayer);var indexLn=descending?indexLbb:indexLbb-1;this.map.setLayerIndex(node.attributes.OlLayer,indexLn);}
else{if(ba.attributes.OlLayer==node.attributes.OlLayer){var indexSLba=ba.attributes.OlLayer.getSubLayerInfo(ba.attributes.layerName).index;var indexSLn=descending?indexSLba-1:indexSLba;node.attributes.OlLayer.moveSubLayer(node.attributes.layerName,indexSLn);}
else{var indexLbb=this.map.getLayerIndex(bb.attributes.OlLayer);var indexLn=descending?indexLbb:indexLbb-1;this.map.setLayerIndex(node.attributes.OlLayer,indexLn);}}}
else{var indexLbb=this.map.getLayerIndex(bb.attributes.OlLayer);var indexLn=descending?indexLbb:indexLbb-1;this.map.setLayerIndex(node.attributes.OlLayer,indexLn);}}
else{var indexLbb=this.map.getLayerIndex(bb.attributes.OlLayer);var indexLn=descending?indexLbb:indexLbb-1;this.map.setLayerIndex(node.attributes.OlLayer,indexLn);}}}
else{if(ba!=null){if(ba.attributes.type==this.NODE_LAYER){if(ba.attributes.OlLayer==node.attributes.OlLayer){var indexSLba=ba.attributes.OlLayer.getSubLayerInfo(ba.attributes.layerName).index;var indexSLn=descending?indexSLba-1:indexSLba;node.attributes.OlLayer.moveSubLayer(node.attributes.layerName,indexSLn);}
else{var indexLba=this.map.getLayerIndex(ba.attributes.OlLayer);var indexLn=descending?indexLba+1:indexLba;this.map.setLayerIndex(node.attributes.OlLayer,indexLn);}}
else{var indexLbb=this.map.getLayerIndex(this.getLastLayerFromGroupNode(bb));var indexLn=descending?indexLbb:indexLbb-1;this.map.setLayerIndex(node.attributes.OlLayer,indexLn);}}
else{var indexSLbb=this.map.getLayerIndex(this.getLastLayerFromGroupNode(bb));var indexLn=descending?indexLbb:indexLbb-1;this.map.setLayerIndex(node.attributes.OlLayer,indexLn);}}}
else{if(ba!=null){if(ba.attributes.type==this.NODE_LAYER){if(ba.attributes.OlLayer==node.attributes.OlLayer){var indexSLba=ba.attributes.OlLayer.getSubLayerInfo(ba.attributes.layerName).index;node.attributes.OlLayer.moveSubLayer(node.attributes.layerName,indexSLba);}
else{var indexLba=this.map.getLayerIndex(ba.attributes.OlLayer);var indexLn=descending?indexLba+1:indexLba;this.map.setLayerIndex(node.attributes.OlLayer,indexLn);}}
else{var indexLba=this.map.getLayerIndex(this.getFirstLayerFromGroupNode(ba));var indexLn=descending?indexLba+1:indexLba;this.map.setLayerIndex(node.attributes.OlLayer,indexLn);}}
else{}}
if(bb!=null&&bb.attributes.type==this.NODE_LAYER&&bb.attributes.OlLayer==node.attributes.OlLayer&&bb.attributes.layerIdx<node.attributes.layerIdx){var indexSLbb=bb.attributes.OlLayer.getSubLayerInfo(bb.attributes.layerName).index;var newLayers=node.attributes.OlLayer.split(indexSLbb);this.linkLayerToNode(newLayers[1],newParent);var indexLb=this.map.getLayerIndex(bb.attributes.OlLayer);this.map.addLayer(newLayers[1],indexLb);newLayers[0].redraw();newLayers[1].setVisibility(true);}
if(ba!=null&&ba.attributes.type==this.NODE_LAYER&&ba.attributes.OlLayer==node.attributes.OlLayer&&ba.attributes.layerIdx>node.attributes.layerIdx){var indexSLba=ba.attributes.OlLayer.getSubLayerInfo(node.attributes.layerName).index;var newLayers=ba.attributes.OlLayer.split(indexSLba);this.linkLayerToNode(newLayers[1],newParent);var indexLba=this.map.getLayerIndex(node.attributes.OlLayer);this.map.addLayer(newLayers[1],indexLba);newLayers[0].redraw();newLayers[1].setVisibility(true);}
newParent.updateIndex(true);},addLayerNode:function(node,toLegend){var tree=this.getLayerTree();if(tree.hasChildNodes())
node=tree.insertBefore(node,tree.childNodes[0]);else
node=tree.appendChild(node);this.initNode(node);var legendControl=this.getLegendControl();if(toLegend&&legendControl){legendControl.addLegendNode(node);}},getLegendControl:function(){if(this.legendControl==null){var controls=this.map.getControlsByClass('Carmen.Control.Legend');this.legendControl=controls.length==0?null:controls[0];}
return this.legendControl;},buildLayerNode:function(cfg,atts){var nodeCfg=OpenLayers.Util.extend({},OpenLayers.Util.extend(Prodige.Legend.LayerNodesConfig["default"].cfg,cfg));var attributes=OpenLayers.Util.extend({},OpenLayers.Util.extend(Prodige.Legend.LayerNodesConfig["default"].atts,atts));nodeCfg.id=OpenLayers.Util.createUniqueID("legendNode_");var node=this.getLayerTree().createNode(nodeCfg);node.attributes=attributes;return node;},serializeForContext:function(kmlAsString){var res={LayerTree:{LayerTreeNode:this.serializeNodeForContext(this.layerTree)}};return res;},serializeNodeForContext:function(node){var layerTreeNode={};switch(node.attributes.type){case(this.NODE_GROUP):layerTreeNode.attributes={name:node.attributes.text,open:Carmen.Util.bool2IntStr(node.isExpanded()),depth:node.getDepth().toString(),type:"group",opacity:node.attributes.opacity.toString(),forceOpacityControl:node.attributes.forceOpacityControl?"1":"0"};var subNodes=[];for(var i=0;i<node.childNodes.length;i++){child=node.childNodes[i];subNodes.push(this.serializeNodeForContext(child));}
if(subNodes.length>0)
layerTreeNode.LayerTreeNode=subNodes;break;case(this.NODE_LAYER):layerTreeNode.attributes={name:node.data.text,mapName:node.attributes.layerName,depth:node.getDepth().toString(),type:'layer',visible:Carmen.Util.bool2IntStr(node.attributes.visible),displayClass:Carmen.Util.bool2IntStr(node.hasChildNodes()),providerGrpId:(this.map.getNumLayers()-this.map.getLayerIndex(node.attributes.OlLayer)).toString(),layerId:node.attributes.layerIdx.toString(),layerIdx:node.attributes.layerIdx.toString(),opacity:node.attributes.opacity.toString(),forceOpacityControl:node.attributes.forceOpacityControl?"1":"0",addedByUser:'addedByUser'in node.attributes?"1":"0"};if(node.attributes.iconStyle){layerTreeNode.iconStyle=node.attributes.iconStyle;}
break;default:break;};return layerTreeNode;},getControlByName:function(ctlName){var ctl=null;if(this.map){var ctls=this.map.getControlsByClass(ctlName);if(ctls.length>0){ctl=ctls[0];}}
return ctl;}});Prodige.Legend.isDropValid=function(targetNode,position,dragData,e,eOpts){if(targetNode.parentNode==null)
return false;var srcNode=dragData.records[0];var indexSrc=srcNode.parentNode.indexOf(srcNode);var indexTarget=targetNode.parentNode.indexOf(targetNode);var result=(srcNode.parentNode==targetNode.parentNode)&&((position=='before'&&(indexTarget-indexSrc)!=1)||(position=='after'&&(indexTarget-indexSrc)!=-1));return result;};Prodige.Legend.addTransparencySliderToNode=function(n,initialOpacity){return;var transparencySlider=Ext.create('Ext.Slider.Single',{id:node.id+'_slider',renderTo:node.id+'_ext',width:75,minValue:0,maxValue:100,plugins:new Ext.ux.SliderTip()});transparencySlider.on('change',function(slider,newVal){var opacity=1.0-(newVal/100);var olLayers=Carmen.Util.set_from_array(this.collect('OlLayer',false));for(var i=0;i<olLayers.length;i++){olLayers[i].setOpacity(opacity);}
var layerOrClassNodes=this.collectChildNodes(function(n){return('type'in n.attributes&&(n.attributes.type==Prodige.Legend.NODE_LAYER||n.attributes.type==Prodige.Legend.NODE_CLASS));});var sliderNodes=this.collectChildNodes(function(n){return n.attributes.forceOpacityControl;});for(var i=0;i<layerOrClassNodes.length;i++){var icon=layerOrClassNodes[i].getUI().getIconEl();OpenLayers.Util.modifyDOMElement(icon,null,null,null,null,null,null,opacity);}
for(var i=0;i<sliderNodes.length;i++){var gSlider=Ext.getCmp(sliderNodes[i].id+'_slider');gSlider.setValue(newVal,true);}},node);if(initialOpacity){var val=100-(initialOpacity*100);transparencySlider.setValue(val,true);}};Prodige.Legend.LayerNodesConfig={'removable':{cfg:{leaf:true,expanded:false,checked:true,iconCls:'cmnLayerTreeLayerNodeIcon',visible:true,expanded:false,opacity:1.0},atts:{visible:true,expanded:false,opacity:1.0,forceOpacityControl:true,addedByUser:true,iconCls:'cmnLayerTreeLayerNodeIcon',removable:true}},'default':{cfg:{leaf:true,expanded:false,checked:true,iconCls:'cmnLayerTreeLayerNodeIcon',visible:true,expanded:false,opacity:1.0},atts:{visible:true,expanded:false,opacity:1.0,forceOpacityControl:true,addedByUser:true,iconCls:'cmnLayerTreeLayerNodeIcon',removable:true}}};Prodige.Legend.NODE_LAYER=0;Prodige.Legend.NODE_GROUP=1;Prodige.Legend.NODE_CLASS=2;Prodige.Legend.NODE_FEATURE=3;Prodige.Legend.TREE_NODE_ROOT_LABEL="";Carmen.Control.LocalStyler=new OpenLayers.Class(OpenLayers.Control,{vectorLayer:null,id:"LocalStyler",pointStyle:null,lineStyle:null,polygonStyle:null,defaultStyle:OpenLayers.Feature.Vector.style['default'],stylePointStore:{fields:['styleDef','styleDesc','styleName','stylePreview'],data:[[{graphicName:'circle',ms_symbolName:'ms_circle'},'disque plein','point_style_1','/IHM/images/sym_annot_circle.png'],[{graphicName:'square',ms_symbolName:'ms_square'},'carré plein','point_style_2','/IHM/images/sym_annot_square.png'],[{graphicName:'triangle',ms_symbolName:'ms_triangle'},'triangle plein','point_style_3','/IHM/images/sym_annot_triangle.png'],[{graphicName:'x',ms_symbolName:'ms_cross'},'croix (multiplication)','point_style_4','/IHM/images/sym_annot_x.png'],[{graphicName:'cross',ms_symbolName:'ms_plus'},'croix (addition)','point_style_5','/IHM/images/sym_annot_cross.png'],[{graphicName:'star',ms_symbolName:'ms_star'},'étoile','point_style_6','/IHM/images/sym_annot_star.png']]},styleLineStore:{fields:['styleDef','styleDesc','styleName','stylePreview'],data:[[{strokeDashstyle:'solid',ms_symbolName:'ms_line_solid'},'trait plein','line_style_1','/IHM/images/sym_annot_lineplain.png'],[{strokeDashstyle:'dot',ms_symbolName:'ms_line_dot'},'pointillés','line_style_2','/IHM/images/sym_annot_linedot.png'],[{strokeDashstyle:'longdash',ms_symbolName:'ms_line_dash'},'tiretés','line_style_3','/IHM/images/sym_annot_linedash.png'],[{strokeDashstyle:'dashdot',ms_symbolName:'ms_line_dashdot'},'tiretés - pointillés','line_style_4','/IHM/images/sym_annot_linedashdot.png']]},stylePolygonStore:{fields:['styleDef','styleDesc','styleName','stylePreview'],data:[[{fillOpacity:0.4,ms_symbolName:'ms_area_fill'},'surface pleine','polygon_style_1','/IHM/images/sym_annot_areaplain.png'],[{fillOpacity:0.0,ms_symbolName:'ms_area_empty'},'contour','polygon_style_2','/IHM/images/sym_annot_areaempty.png']]},createNewStyle:true,styleRenderer:null,initialize:function(vectorLayer,options){this.vectorLayer=vectorLayer;OpenLayers.Control.prototype.initialize.apply(this,[options]);this.pointStyle=OpenLayers.Util.extend({},this.defaultStyle);this.lineStyle=OpenLayers.Util.extend(OpenLayers.Util.extend({},this.defaultStyle),{strokeWidth:2});this.polygonStyle=OpenLayers.Util.extend({},this.defaultStyle);var renderer=OpenLayers.Util.getParameters(window.location.href).renderer;renderer=(renderer)?[renderer]:OpenLayers.Layer.Vector.prototype.renderers;this.styleRenderer=new OpenLayers.Class(OpenLayers.Renderer[renderer[0]],{resolution:1.0,left:0.0,top:10.0,getResolution:function(){return 1.0;}});this.initializeUIComponents();},initializeUIComponents:function(){return;Carmen.ComboStyle=Ext.extend(Ext.form.ComboBox,{mode:'local',editable:false,typeAhead:true,listConfig:{loadingText:'Chargement',getInnerTpl:function(){return'<tpl for="."><div id="" ext:qtip="{styleDesc}" class="x-combo-list-item"><img src="{stylePreview}" alt="{styleDesc}"/></div></tpl>';}},displayTpl:new Ext.XTemplate('<tpl for=".">'+'{[values["styleDesc"]]}'+'</tpl>'),forceSelection:true,triggerAction:'all',displayField:'styleDesc',valueField:'styleDef',lazyInit:false,width:200,styleStoreCfg:null,styleRenderer:null,initComponent:function(){this.doQueryTask=Ext.create('Ext.util.DelayedTask',this.doRawQuery,this);this.id=Ext.id();this.tpl='<tpl for="."><div id="tpl_'+this.id+'" ext:qtip="{styleDesc}" class="x-boundlist-item"><img src="{stylePreview}" alt="{styleDesc}"/></div></tpl>';this.store=new Ext.data.ArrayStore(this.styleStoreCfg);this.on('afterrender',function(){this.setValue(this.store.getAt(0).data.styleDef);},this);this.on('select',function(c,r,i){nv=r[0].get('styleDef');OpenLayers.Util.extend(this.linkedStyle,nv);},this);},updateStylePreview:function(){var styleBox=OpenLayers.Util.getElement('tpl_'+this.id);renderer=new this.styleRenderer(styleBox.id);var point=new OpenLayers.Geometry.Point(1.0,1.0);renderer.drawGeometry(point,OpenLayers.Feature.Vector.style['default'],Ext.id(null,'style_geom_'));}});this.pointStyler=new Ext.form.FieldContainer({fieldLabel:'Style',id:'oPointShape',items:[new Carmen.ComboStyle({styleStoreCfg:this.stylePointStore,linkedStyle:this.pointStyle,styleRenderer:this.styleRenderer})]});Carmen.PointColorChooserStyle=Ext.extend(Ext.ux.ColorChooser,{linkedStyle:null,listeners:{'select':{fn:function(cp,colorStr){OpenLayers.Util.extend(cp.linkedStyle,{strokeColor:'#'+colorStr,fillColor:'#'+colorStr});}}},id:'oPointColor'});this.pointStylerColor=new Carmen.PointColorChooserStyle({linkedStyle:this.pointStyle});Carmen.PointSizeChooser=Ext.extend(Ext.form.TextField,{allowDecimals:true,decimalSeparator:".",decimalPrecision:2,allowNegative:false,minValue:0,maxValue:100,width:275,fieldLabel:'Taille',minText:"La valeur minimale pour ce champ est 0",maxText:"La valeur maximale pour ce champ est 100",nanText:"Ce champ nécessite un nombre",baseChars:"0123456789",emptyText:"Taille",id:'oPointSize',maxLength:3,maxLengthText:'La valeur doit être compris entre 0 et 100'});this.pointSizeChooser=new Carmen.PointSizeChooser();this.lineStyler=new Ext.form.FieldContainer({fieldLabel:'Style',id:'oLineShape',items:[new Carmen.ComboStyle({styleStoreCfg:this.styleLineStore,linkedStyle:this.lineStyle,styleRenderer:this.styleRenderer})]});Carmen.LineColorChooserStyle=Ext.extend(Ext.ux.ColorChooser,{linkedStyle:null,listeners:{'select':{fn:function(cp,colorStr){OpenLayers.Util.extend(cp.linkedStyle,{strokeColor:'#'+colorStr,fillColor:'#'+colorStr});}}},id:'oLineColor'});this.lineStylerColor=new Carmen.LineColorChooserStyle({linkedStyle:this.lineStyle});Carmen.LineThicknessChooser=Ext.extend(Ext.form.TextField,{allowDecimals:true,decimalSeparator:".",decimalPrecision:2,allowNegative:false,fieldLabel:'Epaisseur',width:275,minValue:0,maxValue:100,minText:"La valeur minimale pour ce champ est 0",maxText:"La valeur maximale pour ce champ est 100",nanText:"Ce champ nécessite un nombre",baseChars:"0123456789",emptyText:"Epaisseur",id:'oLineThickness',maxLength:3,maxLengthText:'La valeur doit être compris entre 0 et 100'});this.lineThicknessChooser=new Carmen.LineThicknessChooser();this.polygonStyler=new Ext.form.FieldContainer({fieldLabel:'Style',id:'oPolygonShape',items:[new Carmen.ComboStyle({styleStoreCfg:this.stylePolygonStore,linkedStyle:this.polygonStyle,styleRenderer:this.styleRenderer})]});Carmen.PolygonColorChooserStyle=Ext.extend(Ext.ux.ColorChooser,{linkedStyle:null,fieldLabel:'Remplissage',listeners:{'select':{fn:function(cp,colorStr){OpenLayers.Util.extend(cp.linkedStyle,{strokeColor:'#'+colorStr,fillColor:'#'+colorStr});}}},id:'oPolygonColor'});this.polygonStylerColor=new Carmen.PolygonColorChooserStyle({linkedStyle:this.polygonStyle});this.polygonStylerColor.colorBtn.setTooltip('Modifier couleur du remplissage');Carmen.PolygonEdgeColorChooser=Ext.extend(Ext.ux.ColorChooser,{linkedStyle:null,fieldLabel:'Contour',listeners:{'select':{fn:function(cp,colorStr){OpenLayers.Util.extend(cp.linkedStyle,{strokeColor:'#'+colorStr,fillColor:'#'+colorStr});}}},id:'oPolygonEdgeColor'});this.polygonEdgeColorChooser=new Carmen.PolygonEdgeColorChooser({linkedStyle:this.polygonStyle});this.polygonEdgeColorChooser.colorBtn.setTooltip('Modifier couleur du contour');Carmen.PolygonEdgeSizeChooser=Ext.extend(Ext.form.TextField,{allowDecimals:true,decimalSeparator:".",decimalPrecision:2,allowNegative:false,fieldLabel:'Epaisseur',width:275,minValue:0,maxValue:100,minText:"La valeur minimale pour ce champ est 0",maxText:"La valeur maximale pour ce champ est 100",nanText:"Ce champ nécessite un nombre",baseChars:"0123456789",emptyText:"Epaisseur",id:'oPolygonEdgeSize',maxLength:3,maxLengthText:'La valeur doit être compris entre 0 et 100'});this.polygonEdgeSizeChooser=new Carmen.PolygonEdgeSizeChooser();},activate:function(layer,node){this.vectorLayer=layer;this.layerTreeNode=node;var state=OpenLayers.Control.prototype.activate.apply(this,arguments);if(state){this.styleWindow.show();}
return state;},deactivate:function(){var state=OpenLayers.Control.prototype.deactivate.apply(this,arguments);if(state)
this.styleWindow.hide();return state;},displayClassName:"CmnControlLocalStyler",CLASS_NAME:"Carmen.Control.LocalStyler"});Prodige.Map=OpenLayers.Class(AbstractMapBuilder,{usage:'API',DEFAULT_WIDTH:500,DEFAULT_HEIGHT:700,onlyActivCtrls:["zoom"],CLASS_NAME:"Prodige.Map",DEFAULTS:{defaultControl:'pan'},id:null,renderTo:null,owscontext:null,legendVisible:true,keymapVisible:true,defaultControl:null,legendRenderer:"default",toolbar:null,legend:null,keymap:null,initialize:function(options){if(typeof options=="string"){options={owscontext:options};}
var me=this;options=options||{};OpenLayers.Util.extend(this,options);this.legendRenderer=this.legendRenderer||"default";if(typeof this.legendRenderer=="string"){this.legendRenderer=eval("new "+Prodige.Tree.Renderer.ALIASES[this.legendRenderer]+"()");}
if(this.id&&/^[a-z_]\w+$/i.test(this.id)){eval(this.id+" = this;");}
this.id=this.id||OpenLayers.Util.createUniqueID(this.CLASS_NAME+'-');this.mainPanel=OpenLayers.Util.getElement(this.renderTo||document.body)||document.body;this.mainPanel.style.width=this.mainPanel.style.width||(this.DEFAULT_WIDTH+'px');this.mainPanel.style.height=this.mainPanel.style.height||(this.DEFAULT_HEIGHT+'px');this.mainPanel.add=this.mainPanel.appendChild;this.ui={getMainPanel:function(){return OpenLayers.Util.getElement(me.mainPanel);},doLayout:function(){},addToDataPanel:function(child){this.getMainPanel().appendChild(child);}};this.defaultControl=this.defaultControl||this.DEFAULTS.defaultControl;this.loadContext();},loadContext:function(owscontext)
{var me=this;this.owscontext=owscontext||this.owscontext;if(this.owscontext===null){throw"Prodige.Map : the owscontext property is required for instanciation";}
if(typeof this.owscontext=="string"){var request=new OpenLayers.Request.GET({url:this.owscontext,async:false,success:function(request){me.owscontext=Prodige.OWSContext.Reader(request.responseXML||request.responseText);},failure:function(){throw"Prodige.Map : the owscontext property cant not be opened or read. ["+me.owscontext+"]";}});}else{this.owscontext=Prodige.OWSContext.Reader(this.owscontext);}
AbstractMapBuilder.prototype.initialize.apply(this);this.legend=this.layerTreeManager;},addControl:function(control)
{if(this.toolbar){switch(control.type){case OpenLayers.Control.TYPE_BUTTON:case OpenLayers.Control.TYPE_TOGGLE:case OpenLayers.Control.TYPE_TOOL:this.toolbar.addControls((control instanceof Array?control:[control]));return;}}
this.map.addControl(control);},getLayerTree:function()
{return this.legend.getLayerTree();},getLegend:function()
{return this.legend;},getKeymap:function()
{return this.keymap;},addControls:function(){this.toolbar=new Prodige.NavToolbar({defaultControl:this.defaultControl});this.map.addControl(this.toolbar);}});Prodige.Tree=Prodige.Tree||{};Prodige.Tree.Node=OpenLayers.Class({renderer:null,parent:null,childNodes:[],attributes:{},isRoot:true,isLeaf:true,isDrawn:false,expanded:false,initialize:function(definition,attributes,parent,childNodes){if(typeof definition=="string"){definition={id:definition};}
OpenLayers.Util.extend(this,definition||{});this.data=this.data||definition||{};this.id=this.id||OpenLayers.Util.createUniqueID('Prodige_Tree_Node_');this.setAttributes(attributes);this.setParent(parent);this.addChildren(childNodes||[]);},createNode:function(definition){if(typeof definition=="string"){definition={id:definition};}
definition=definition||{};var node=new Prodige.Tree.Node(definition);this.addChildren(node);return node;},_isRoot:function(){this.isRoot=!(typeof this.parent!="undefined"&&this.parent!==null);},_isLeaf:function(){this.isLeaf=this.childNodes.length==0;},moveUp:function(){if(this.parent){var index=this.parent.childNodes.indexOf(this);if(index!=-1){var tmp=[];for(var i=0;i<this.parent.childNodes.length;i++){if(i==index-1){tmp.push(this);tmp.push(this.parent.childNodes[i]);i++;}
else{tmp.push(this.parent.childNodes[i]);}}
this.parent.childNodes=tmp;}}},moveDown:function(){if(this.parent){var index=this.parent.childNodes.indexOf(this);if(index!=-1){var tmp=[];for(var i=0;i<this.parent.childNodes.length;i++){if(i==index&&index+1<this.parent.childNodes.length){tmp.push(this.parent.childNodes[i+1]);tmp.push(this);i++;}
else{tmp.push(this.parent.childNodes[i]);}}
this.parent.childNodes=tmp;}}},resetChildren:function(){this.childNodes=[];for(var i=0;i<this.childNodes.length;i++){childNodes[i].setParent(null);}},appendChild:function(childNodes){this.addChildren(childNodes);},addChildren:function(childNodes){if(arguments.length>1){childNodes=Array.prototype.slice.apply(arguments);}
this.childNodes=this.childNodes.concat((childNodes instanceof Array?childNodes:[childNodes]));for(var i=0;i<this.childNodes.length;i++){this.childNodes[i].setParent(this);}
this._isLeaf();},removeChildren:function(){if(arguments.length>1){childNodes=Array.prototype.splice.apply(arguments);}
if(!(childNodes instanceof Array)){childNodes=[childNodes];}
for(var i=0;i<childNodes.length;i++){var index=this.childNodes.indexOf(childNodes[i]);childNodes[i].setParent(null);if(index!=-1){if(index==0){this.childNodes=this.childNodes.slice(1);}
else if(index==this.childNodes.length-1){this.childNodes=this.childNodes.slice(0,this.childNodes.length-1);}
else{this.childNodes=this.childNodes.slice(0,index).concat(this.childNodes.slice(index+1))}}}
this._isLeaf();},setParent:function(parent){if(parent&&parent.childNodes.indexOf(this)==-1){parent.addChildren(this);return;}
this.parent=parent;this._isRoot();this.redraw();},setRenderer:function(renderer){this.renderer=renderer;for(var i=0;i<this.childNodes.length;i++){this.childNodes[i].setRenderer(renderer);}},registerEvents:function(){if(!this.isDrawn)return;if(!this.renderer)return;if(typeof this.renderer.registerEvents!="undefined"){this.renderer.registerEvents()}},draw:function(container){if(this.isDrawn){this.redraw(container);return;}
if(!this.renderer)return;var string=this.renderer.draw(this);this.isDrawn=true;if(container){if(typeof container.write=="function"){container.write(string);}else if(typeof container.innerHTML!="undefined"){container.innerHTML=string;}else{return string;}
return;}
return string;},redraw:function(){if(!this.isDrawn){this.draw();return;}
if(!this.renderer)return;var string=this.renderer.redraw(this);for(var i=0;i<this.childNodes.length;i++){this.childNodes[i].redraw();}
return string;},each:function(fn,arguments,bSelf){if(bSelf)fn.apply(this,[this].concat(arguments||[]));for(var i=0;i<this.childNodes.length;i++){fn.apply(this.childNodes[i],[this.childNodes[i]].concat(arguments||[]));}},recurse:function(fn,arguments,bSelf){if(bSelf)fn.apply(this,arguments||[]);for(var i=0;i<this.childNodes.length;i++){this.childNodes[i].recurse(fn,arguments,true);}},toString:function(depth){depth=depth||0;var string="";for(var i=0;i<depth;i++)string+="  ";string+="> ";string+=this.id+'(isRoot='+this.isRoot+', isLeaf='+this.isLeaf+', nb_children='+this.childNodes.length+', text='+this.text+')';for(var i=0;i<this.childNodes.length;i++){string+="\n"+this.childNodes[i].toString(depth+1);}
return string;},setAttributes:function(attributes){this.attributes=attributes;},addAttributes:function(name,value){if(typeof name=="object"&&arguments.length==1){OpenLayers.Util.extend(this.attributes,name);return;}
this.attributes[name]=value;},getAttributes:function(){return OpenLayers.Util.extend({id:this.id},this.attributes);}});Prodige.Tree.Store=OpenLayers.Class(Prodige.Tree.Node,{root:null,getRoot:function(){if(!this.root){this.root=this;}
return this.root;},setRoot:function(root){this.root=root;if(this.root){this.root.isRoot=true;this.root.setRenderer(this.renderer);}
return this;},draw:function(container){if(this.isDrawn){this.redraw();return;}
if(!this.renderer)return;if(this.getRoot()!==this){this.isDrawn=true;return this.root.draw(container);}else{return Prodige.Tree.Node.prototype.draw.call(this,container);}},registerEvents:function(){if(this.getRoot()!==this){this.root.registerEvents();}else{return Prodige.Tree.Node.prototype.registerEvents.call(this);}}})
Prodige.Tree.Renderer=OpenLayers.Class({BLANK_IMAGE_URL:'data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==',CLASS_NAME:"Prodige.Tree.Renderer",baseCls:"prodigetreenode",initialize:function(baseCls){this.baseCls=baseCls||this.baseCls;},apply:function(html,values)
{var oldHtml=html;do{oldHtml=html;html=html.replace(/\{(\w+)\}/g,function(fullmatch,match){return(typeof values[match]!="undefined"?values[match]:"{"+match+"}");});}while(html!=oldHtml);return html;},extendIf:function(destination,source){destination=destination||{};source=source||{};for(var prop in source){if(typeof destination[prop]=="undefined"){destination[prop]=source[prop];}}
return destination;},getTplValues:function(node){var values={};values=this.extendIf(values,{baseCls:this.baseCls,blankUrl:this.BLANK_IMAGE_URL});values=this.extendIf(values,{expandCls:(node.expanded?"expanded":"collapsed")});values=this.extendIf(values,{cls:(node.isRoot?"root":(node.isLeaf?"leaf":"node"))});values=this.extendIf(values,node);values=this.extendIf(values,node.getAttributes());return values;},applyTpl:function(tpl,node){return this.apply(this[tpl]||"",this.getTplValues(node));},redraw:function(node){return this.draw(node);},draw:function(node){var html=[];if(node.isRoot){html.push(this.applyTpl("rootTplStart",node));}
html.push(this.applyTpl("nodeTpl",node));if(node.childNodes.length){html.push(this.applyTpl("childTplStart",node));for(var i=0;i<node.childNodes.length;i++){html.push(node.childNodes[i].draw());}
html.push(this.applyTpl("childTplEnd",node));}
if(node.isRoot){html.push(this.applyTpl("rootTplEnd",node));}
return html.join("");},registerEvents:function(){var roots=document.getElementsByClassName(this.baseCls+'-root');for(var rootIndex=0;rootIndex<roots.length;rootIndex++){var root=roots[rootIndex];var childNodes=root.getElementsByClassName(this.baseCls);for(var childIndex=0;childIndex<childNodes.length;childIndex++){var child=childNodes[childIndex];child.onclick=function(){var nodes=this.parentNode.getElementsByClassName('childNodes-'+this.id+'');if(nodes.length){var isExpanded=this.className.indexOf("expanded")!=-1;OpenLayers.Element.removeClass(this,"expanded");OpenLayers.Element.removeClass(this,"collapsed");if(isExpanded){OpenLayers.Element.addClass(this,"collapsed");}else{OpenLayers.Element.addClass(this,"expanded");}
for(var nodeIndex=0;nodeIndex<nodes.length;nodeIndex++){var node=nodes[nodeIndex];OpenLayers.Element.removeClass(node,"expanded");OpenLayers.Element.removeClass(node,"collapsed");if(isExpanded){OpenLayers.Element.addClass(node,"collapsed");}else{OpenLayers.Element.addClass(node,"expanded");}}}}}}}});Prodige.Tree.Renderer.ALIASES={"Prodige.Tree.DefaultRenderer":"Prodige.Tree.DefaultRenderer","DefaultRenderer":"Prodige.Tree.DefaultRenderer","default":"Prodige.Tree.DefaultRenderer","Prodige.Tree.AdvancedRenderer":"Prodige.Tree.AdvancedRenderer","AdvancedRenderer":"Prodige.Tree.AdvancedRenderer","advanced":"Prodige.Tree.AdvancedRenderer"};Prodige.Tree.DefaultRenderer=OpenLayers.Class(Prodige.Tree.Renderer,{CLASS_NAME:"Prodige.Tree.DefaultRenderer",rootTplStart:'<ul class="{baseCls}-root expanded">',rootTplEnd:'</ul>',childTplStart:'<ul class="{baseCls}-childNodes {expandCls} childNodes-{id}">',childTplEnd:'</ul>',nodeTpl:'<li class="{baseCls} {cls} {expandCls}" id="{id}">{text}</li>'});Prodige.Tree.AdvancedRenderer=OpenLayers.Class(Prodige.Tree.DefaultRenderer,{CLASS_NAME:"Prodige.Tree.AdvancedRenderer",rootTplStart:'<ul class="{baseCls}-root expanded">',rootTplEnd:'</ul>',childTplStart:'<ul class="{baseCls}-childNodes {expandCls} childNodes-{id}">',childTplEnd:'</ul>',nodeTpl:'<li class="{baseCls} {cls} {expandCls}" id="{id}">'+'<i class="fa fa-angle-right"></i>'+'<i class="fa fa-angle-down"></i>'+'{iconText}'+'{legendLayer}</li>',getTplValues:function(node){var values=Prodige.Tree.DefaultRenderer.prototype.getTplValues.call(this,node);var attributes=node.getAttributes();var complement={};var iconText="{text}";var legendLayer=[];if(attributes.classLegend){for(var i=0;i<attributes.classLegend.length;i++){legendLayer.push(['<span class="{baseCls} layerlegenditem multiple" ','style="'+"background-image:url("+attributes.classLegend[i].icon+");"+(attributes.iconStyle||"")+'">',attributes.classLegend[i].text,'</span>'].join(''));}}else if(node.icon){var time=new Date().getTime();iconText=['<span class="{baseCls} layerlegenditem"','style="'+"background-image:url("+node.icon+");"+(attributes.iconStyle||"")+'">','{text}','</span>'].join('');var a=document.createElement("img");a.onerror=function(){var elt=document.getElementById("_"+time);if(elt){elt.style.display="none";}else{setTimeout(this.onerror,200);}
iconText="{text}";}
a.sync=true;a.src=node.icon;}
if(legendLayer.length){legendLayer=[""].concat(legendLayer);}
values=this.extendIf(values,{iconText:iconText,legendLayer:legendLayer.join('<br/>')});return values;},nodeTpl2:['<div class="row0" style="width:300px;">','<div class="row0_first" style="width:{[20+(values.record.getDepth()*20)+20]}px;" >','<tpl for="lines">','<img src="{parent.blankUrl}" class="{parent.childCls} {parent.elbowCls}-img ','{parent.elbowCls}-<tpl if=".">line<tpl else>empty</tpl>" role="presentation"/>','</tpl>','<img src="{blankUrl}" class="{childCls} {elbowCls}-img {elbowCls}','<tpl if="isLast">-end</tpl>','<tpl if="expandable">-plus {expanderCls}</tpl>','" role="presentation"/>','<tpl if="checked !== null">','<input type="button" {ariaCellCheckboxAttr}',' class="{childCls} {checkboxCls}<tpl if="checked"> {checkboxCls}-checked</tpl>"/>','</tpl>','</div>','<div class="row0_second">','<tpl if="href">','<a href="{href}" role="link" target="{hrefTarget}" class="{textCls} {childCls}">{value}</a>','<tpl else>','<span class="{textCls} {childCls} layerTreeNode">{value}','</span>','<tpl if="values.record.attributes.classLegend">','<tpl for="values.record.attributes.classLegend">','<br/>','<img src="{parent.blankUrl}" role="presentation" class=" x-tree-elbow-img x-tree-elbow-empty"','style="" ></img>','<img src="{parent.blankUrl}" role="presentation" class=" x-tree-icon x-tree-icon-leaf cmnLayerTreeLayerNodeIcon"','style="background-image:url({icon})" ></img>','<span class="x-tree-node-text" >{text}</span>','</tpl>','<tpl elseif="values.record.attributes.iconDisplayStrategy"/>','<img id="legendNode-{record.internalId}_iconDisplay" src="<tpl if="icon">{icon}<tpl else>{blankUrl}</tpl>" role="presentation" class="{iconCls}"/>','</tpl>','</tpl>','<tpl if="record.attributes.forceOpacityControl">','</tpl>','</div>','</div>'].join('')});OpenLayers.Control.AttributionCarmen=new OpenLayers.Class(OpenLayers.Control,{separator:", ",displayLogo:true,logoPath:null,font:null,fontFamily:'tahoma,arial,helvetica,sans-serif',color:'#000000',fontSize:'12px',fontWeight:'normal',fontStyle:'normal',backgroundColor:null,opacity:1.0,initialize:function(options){OpenLayers.Control.prototype.initialize.apply(this,arguments);this.fontFamily=this.font?this.font+','+this.fontFamily:this.fontFamily;if(this.fontSize&&this.fontSize.search(/^\d+$/g)!=-1)
this.fontSize=this.fontSize+'px';if(this.color&&this.color.charAt(0)!='#')
this.color='#'+this.color;if(this.backgroundColor&&this.backgroundColor.charAt(0)!='#')
this.backgroundColor='#'+this.backgroundColor;if(this.backgroundColor&&this.backgroundColor.length==9){this.opacity=1.0-(parseInt(this.backgroundColor.substring(7,9),16)/255);this.backgroundColor=this.backgroundColor.substring(0,7);}},destroy:function(){this.map.events.un({"removelayer":this.updateAttribution,"addlayer":this.updateAttribution,"changelayer":this.updateAttribution,"changebaselayer":this.updateAttribution,scope:this});OpenLayers.Control.prototype.destroy.apply(this,arguments);},draw:function(){OpenLayers.Control.prototype.draw.apply(this,arguments);this.div.style.display="block";this.div.style.position="absolute";this.div.style.backgroundColor=this.backgroundColor;this.div.style.fontFamily=this.fontFamily;this.div.style.fontWeight=this.fontWeight;this.div.style.color=this.color;this.div.style.fontSize=this.fontSize;this.div.style.fontStyle=this.fontStyle;this.div.style.textAlign='center';this.div.id="AttributionCarmenElt";OpenLayers.Util.modifyDOMElement(this.div,null,null,null,null,null,null,this.opacity);if(!this.logo&&this.displayLogo&&this.logoPath){this.logo=document.createElement("img");this.logo.style.verticalAlign='top';this.logo.src=this.logoPath;this.logo.onload=function(){document.getElementById("AttributionCarmenElt").style.width=this.clientWidth+30+"px";};this.div.appendChild(this.logo);}
if(!this.txt){this.txt=document.createElement("span");this.txt.style.verticalAlign='bottom';this.txt.style.marginRight='10px';this.txt.style.display='block';this.div.appendChild(this.txt);}
this.map.events.on({'changebaselayer':this.update,'changelayer':this.update,'addlayer':this.update,'removelayer':this.update,scope:this});this.update();return this.div;},update:function(){var attributions=[];if(this.map&&this.map.layers){for(var i=0,len=this.map.layers.length;i<len;i++){var layer=this.map.layers[i];if(layer.attribution&&layer.getVisibility()){attributions.push(layer.attribution);}}
this.txt.innerHTML=attributions.join(this.separator);}},CLASS_NAME:"OpenLayers.Control.AttributionCarmen"});Prodige.Keymap=new OpenLayers.Class(OpenLayers.Control.OverviewMap,{referencePanel:null,getPanel:function(){this.referencePanel=this.referencePanel||OpenLayers.Util.getElement('referencePanel')
if(!this.referencePanel){this.referencePanel=OpenLayers.Util.createDiv('referencePanel',{x:0,y:0},{w:220,h:110},null,"absolute","1px solid black","hidden",1.0);var mapPanel=this.map.app.ui.getMainPanel();mapPanel.add(this.referencePanel);this.map.app.ui.doLayout();}
return this.referencePanel;},isHidden:true,show:function(){if(this.div){this.div.style.display="";this.div.style.visibility="visible";this.isHidden=false;}else{this.draw();}},hide:function(){if(this.div){this.div.style.display="none";this.isHidden=true;}},initialize:function(options){OpenLayers.Control.OverviewMap.prototype.initialize.apply(this,[options]);this.displayClass=this.CLASS_NAME_EXTEND.replace("Prodige.","prodige").replace(/\./g,"")+" "+(this.displayClass||"");},draw:function(){OpenLayers.Control.OverviewMap.prototype.draw.apply(this,arguments);if(!this.outsideViewport){if(this.maximizeDiv){this.maximizeDiv.innerHTML='<i class="fa fa-plus"></i>';}
if(this.minimizeDiv){this.minimizeDiv.innerHTML='<i class="fa fa-minus"></i>';}}
var h=Math.min(this.size.h+10,140);this.mapDiv.style.height=h.toString()+'px';var eltMapDiv=OpenLayers.Util.getElement(this.mapDiv);OpenLayers.Element.removeClass(eltMapDiv,'olMap');OpenLayers.Element.addClass(eltMapDiv,'cmnControlOverviewMap');this.isHidden=false;return this.div;},update:function(){OpenLayers.Control.OverviewMap.prototype.update.apply(this,arguments);var eltMapDiv=OpenLayers.Util.getElement(this.mapDiv);OpenLayers.Element.removeClass(eltMapDiv,'olMap');OpenLayers.Element.addClass(eltMapDiv,'cmnControlOverviewMap');},CLASS_NAME_EXTEND:"Prodige.Keymap"});Carmen.Layer.Vector=new OpenLayers.Class(OpenLayers.Layer.Vector,{geometryDefaultStyles:{Point:OpenLayers.Util.extend({},OpenLayers.Feature.Vector.style['default']),LineString:OpenLayers.Util.extend(OpenLayers.Util.extend({},OpenLayers.Feature.Vector.style['default']),{strokeWidth:2}),Polygon:OpenLayers.Util.extend({},OpenLayers.Feature.Vector.style['default'])},sketchStyle:OpenLayers.Util.extend(OpenLayers.Util.extend({},OpenLayers.Feature.Vector.style['default']),{strokeColor:"#000000",fillColor:"#000000"}),geomTypePrefix:{"Point":'pt',"LineString":'ln',"Polygon":'po'},currentStyle:0,updateStamp:0,useStyleMap:false,context_kml:null,context_style:null,KMLAttributes:new OpenLayers.Class(OpenLayers.Format.KML,{createPlacemarkXML:function(feature){var placemarkNode=OpenLayers.Format.KML.prototype.createPlacemarkXML.apply(this,arguments);for(var att in feature.attributes){if(att!='name'&&att!='description'){value=att;var attDesc=this.createElementNS(this.kmlns,att);attDesc.appendChild(this.createTextNode(feature.attributes[att]));placemarkNode.appendChild(attDesc);}}
return placemarkNode;}}),initialize:function(name,options){OpenLayers.Layer.Vector.prototype.initialize.apply(this,arguments);if(this.context_kml||this.context_style)
this.initFromContext(this.context_kml,this.context_style);if(!this.context_style&&this.useStyleMap){this.styleMap.styles['default'].addRules(new OpenLayers.Rule({elseFilter:true}));this.styleMap.addUniqueValueRules('default','description',{'pt0':OpenLayers.Util.extend({},this.geometryDefaultStyles['Point']),'ln0':OpenLayers.Util.extend({},this.geometryDefaultStyles['LineString']),'po0':OpenLayers.Util.extend({},this.geometryDefaultStyles['Polygon'])});this.styleMap.styles['default'].defaultStyle=OpenLayers.Util.extend({},OpenLayers.Feature.Vector.style['default']);}},initFromContext:function(context_kml,context_style){if(context_style){this._initStyleMap(context_style);}
if(context_kml){var kml=new OpenLayers.Format.KML({extractStyles:true,extractAttributes:true});var features=kml.read(context_kml);this.addFeatures(features);}},serializeForContext:function(kmlAsString){var out_options={'internalProjection':new OpenLayers.Projection(mapProjection),'externalProjection':new OpenLayers.Projection(mapProjection)};var features=this.features;for(var i=0;i<this.features.length;i++){this.features[i].attributes.name=this.features[i].attributes.textConfig_label?this.features[i].attributes.textConfig_label:"";}
var kml=new this.KMLAttributes(out_options)
var strKml=kml.write(this.features);var style=this._serializeStyleMap(this.styleMap);return kmlAsString?{kml:strKml,style:style}:{kml:{"#text":strKml},style:style};},exportAsKML:function(geomType){var out_options={'internalProjection':new OpenLayers.Projection(mapProjection),'externalProjection':new OpenLayers.Projection(mapProjection)};var kml=new this.KMLAttributes(out_options)
var strKml="";var features=this.features;for(var i=0;i<this.features.length;i++){this.features[i].attributes.name=this.features[i].attributes.textConfig_label?this.features[i].attributes.textConfig_label:"";}
if(geomType){features=[];for(var i=0;i<this.features.length;i++){if(this.getGeomType(this.features[i].geometry)==geomType){features.push(this.features[i]);}}}
if(features.length>0)
strKml=kml.write(features);return strKml;},_serializeStyleMap:function(){var stl=this.styleMap.styles['default'];var attMap={};var elseSymbolizer={};var filterProperty='';for(var i=0;i<stl.rules.length;i++){var r=stl.rules[i];if(r.elseFilter)
elseSymbolizer=stl.defaultStyle;else{attMap[r.filter.value.toString()]=r.symbolizer;filterProperty=r.filter.property;}};var serializeMap={defaultStyle:stl.defaultStyle,filterRules:{elseSymbolizer:elseSymbolizer,filterProperty:filterProperty,map:attMap},currentStyle:this.currentStyle};return serializeMap},_initStyleMap:function(serializedMap){var symboliser={};var attMap=serializedMap.filterRules.map;if(attMap!=""){for(var k in attMap){symboliser[k]=OpenLayers.Util.extend({},attMap[k]);for(var l in symboliser[k]){symboliser[k][l]=(symboliser[k][l]=="false"||symboliser[k][l]=="true")?symboliser[k][l]=="true":symboliser[k][l];}}}
this.styleMap.styles['default'].defaultStyle=OpenLayers.Util.extend({},serializedMap.defaultStyle);this.styleMap.styles['default'].addRules(new OpenLayers.Rule({elseFilter:true}));var stl=OpenLayers.Util.extend({},this.styleMap.styles['default'].defaultStyle);stl=OpenLayers.Util.extend(stl,serializedMap.defaultStyle);this.styleMap.styles['default'].defaultStyle=stl;this.styleMap.styles['default'].rules=[];this.styleMap.addUniqueValueRules('default',serializedMap.filterRules.filterProperty,symboliser);this.currentStyle=serializedMap.currentStyle;},drawFeature:function(feature,style){if(feature._sketch){feature.style=this.sketchStyle;}
if(this.useStyleMap){if(style==null&&feature.style==null&&feature.attributes.description==null){this.addFeatureStyle(feature);}}
OpenLayers.Layer.Vector.prototype.drawFeature.apply(this,[feature,style]);},addFeatureStyle:function(feature,style,derive){var geomType=this.getGeomType(feature.geometry);if(feature.attributes.description&&derive){var symboliser={};var featureSymboliser=this.styleMap.createSymbolizer(feature,'default');feature.attributes.description=feature.attributes.description+'_'+this.updateStamp.toString();this.updateStamp++;symboliser[feature.attributes.description]=OpenLayers.Util.extend(OpenLayers.Util.extend({},featureSymboliser),style);this.styleMap.addUniqueValueRules('default','description',symboliser);}
else{if(style!=null){this.currentStyle++;var symboliser={};symboliser[this.geomTypePrefix[geomType]+this.currentStyle.toString()]=OpenLayers.Util.extend({},this.geometryDefaultStyles[geomType]);this.styleMap.addUniqueValueRules('default','description',symboliser);this.redraw();}
feature.attributes.description=this.geomTypePrefix[geomType]+this.currentStyle.toString();}},updateGeometryDefaultStyle:function(pointStyle,lineStyle,polygonStyle){OpenLayers.Util.extend(this.geometryDefaultStyles['Point'],pointStyle);OpenLayers.Util.extend(this.geometryDefaultStyles['LineString'],lineStyle);OpenLayers.Util.extend(this.geometryDefaultStyles['Polygon'],polygonStyle);this.currentStyle++;var symboliser={};symboliser[this.geomTypePrefix['Point']+this.currentStyle.toString()]=OpenLayers.Util.extend({},this.geometryDefaultStyles['Point']);symboliser[this.geomTypePrefix['LineString']+this.currentStyle.toString()]=OpenLayers.Util.extend({},this.geometryDefaultStyles['LineString']);symboliser[this.geomTypePrefix['Polygon']+this.currentStyle.toString()]=OpenLayers.Util.extend({},this.geometryDefaultStyles['Polygon']);this.styleMap.addUniqueValueRules('default','description',symboliser);},getGeomType:function(geometry){var res='Point';switch(geometry.CLASS_NAME){case"OpenLayers.Geometry.Point":res="Point";break;case"OpenLayers.Geometry.LineString":res="LineString";break;case"OpenLayers.Geometry.Polygon":res="Polygon";break;}
return res;},getFeatureByAttribute:function(att,value){var found=null;var i=0;while(found==null&&i<this.features.length){found=(this.features[i].attributes[att]!=null&&this.features[i].attributes[att]==value)?this.features[i]:null;i++;}
return found;},CLASS_NAME:"Carmen.Layer.Vector"});var oldMapfile="";var oldUrl="";Carmen.Layer.MapServerGroup=new OpenLayers.Class(OpenLayers.Layer.MapServer,{subLayers:null,mainLayers:'',displayMode:0,qstring:'',qitem:'',selectionSupport:true,selectionStore:null,selectionColumnModel:null,initialize:function(options){OpenLayers.Layer.MapServer.prototype.initialize.apply(this,arguments);this.ratio=1.0;this.mainLayers=this.params.LAYERS;this.subLayers=[];this.params.map_imagetype=this.params.map_imagetype;},hasSubLayers:function(){return this.subLayers.length>0;},addSubLayer:function(layerName,visible){var info=this.getSubLayerInfo(layerName);if(info==null){this.subLayers.push({name:layerName,visible:visible,index:this.subLayers.length});}
else
info.visible=visible;var layerVisibility=false;for(var i=0;i<this.subLayers.length;i++){layerVisibility=layerVisibility||this.subLayers[i].visible;}
this.setVisibility(layerVisibility);},moveSubLayer:function(layerName,index){var info=this.getSubLayerInfo(layerName);if(info!=null){var toBeUpdated=this.subLayers.splice(info.index+1);this.subLayers.pop();for(var i=0;i<toBeUpdated.length;i++)
toBeUpdated[i].index=toBeUpdated[i].index-1;this.subLayers=this.subLayers.concat(toBeUpdated);var toBeUpdated=this.subLayers.splice(index);info.index=index;this.subLayers.push(info);for(var i=0;i<toBeUpdated.length;i++)
toBeUpdated[i].index=toBeUpdated[i].index+1;this.subLayers=this.subLayers.concat(toBeUpdated);}},clone:function(obj){if(obj==null){obj=new Carmen.Layer.MapServerGroup(this.name,this.url,this.params,this.options);}
obj=OpenLayers.Layer.Grid.prototype.clone.apply(this,[obj]);obj.setVisibility(this.visibility);obj.setIsBaseLayer(this.isBaseLayer);obj.subLayers=[].concat(this.subLayers);obj.mainLayers=this.mainLayers;obj.displayMode=this.DISPLAY_MAP;obj.qstring='';obj.qitem='';return obj;},split:function(index){var res=[];if(index>this.subLayers.length){res.push(this);res.push(null);}
else if(index<0){this.subLayers=[];newLayer=this.clone();res.push(this);res.push(newLayer);}
else{var newLayer=this.clone();newLayer.subLayers=new Array();var subLayers2=new Array();for(var i=0;i<this.subLayers.length;i++){if(i<=index)
subLayers2.push(this.subLayers[i]);else
newLayer.subLayers.push(this.subLayers[i]);}
delete this.subLayers;this.subLayers=subLayers2;for(var i=0;i<this.subLayers.length;i++){this.subLayers[i].index=i;}
for(var i=0;i<newLayer.subLayers.length;i++){newLayer.subLayers[i].index=i;}
res.push(this);res.push(newLayer);}
return res;},getSubLayerInfo:function(layerName){var i=0;while(i<this.subLayers.length&&this.subLayers[i].name!=layerName){i++;}
return(i<this.subLayers.length)?this.subLayers[i]:null;},setSubLayerVisibility:function(layerName,isVisible){var subLayer=this.getSubLayerInfo(layerName);if(subLayer!=null)
subLayer.visible=isVisible;var layerVisibility=false;for(var i=0;i<this.subLayers.length;i++){layerVisibility=layerVisibility||this.subLayers[i].visible;}
this.setVisibility(layerVisibility);this.display(layerVisibility);this.redraw();if(this.map!=null){this.map.events.triggerEvent("changelayer",{layer:this,property:"visibility"});}
this.events.triggerEvent("visibilitychanged");},getSubLayerVisibility:function(layerName){var subLayer=this.getSubLayerInfo(layerName);return subLayer.visible;},getVisibility:function(layerName){var vis=true;if(layerName==null||layerName==this.mainLayers)
vis=OpenLayers.Layer.WMS.prototype.getVisibility.apply(this,[]);else
vis=this.getSubLayerVisibility(layerName);return vis;},_getLayersParam:function(){var str=this.mainLayers;for(var i=0;i<this.subLayers.length;i++){if(this.subLayers[i].visible){str=str+" "+this.subLayers[i].name;}}
str=(str.length>0)&&(str[0]==' ')?str.slice(1):str;return str;},getURL:function(bounds){var url=null;if(valueFrom(this.map,null)!=null&&this.displayMode==this.DISPLAY_MAP){bounds=this.adjustBounds(bounds);var extent=[bounds.left,bounds.bottom,bounds.right,bounds.top];var imageSize=this.getImageSize();var center=bounds.getCenterLonLat();var scale=this.map.getScale();url=this.getFullRequestString({map_size:[imageSize.w,imageSize.h],imgx:imageSize.w/2,imgy:imageSize.h/2,imgxy:[imageSize.w,imageSize.h],mapxy:[center.lon,center.lat],scaledenom:scale});}
else{url=OpenLayers.Layer.MapServer.prototype.getURL.apply(this,arguments);}
return url;},redraw:function(){this.params.LAYERS=this._getLayersParam();this.params.map_resolution=Carmen.Mapserver_DOTS_PER_INCH;var redrawn=OpenLayers.Layer.MapServer.prototype.redraw.apply(this,arguments);return redrawn;},setDisplayMode:function(mode,qlayer,fid,qfile,ogrMapfile){switch(mode){case this.DISPLAY_QUERYMAP:this.params.mode='INDEXQUERY';this.params['QLAYER']=qlayer;this.params['SHAPEINDEX']=fid;delete this.params['QUERYFILE'];delete this.params['TIME'];break;case this.DISPLAY_NQUERYMAP:if(typeof ogrMapfile!="undefined"&&ogrMapfile!=""){oldMapfile=this.mapfile;oldUrl=this.url;oldLayer=this.mainLayers;this.params.mode='map';this.mainLayers+=' layerOgr';this.params.LAYERS+=' layerOgr';this.mapfile=ogrMapfile;this.url=window.CARMEN_URL_SERVER_DATA+"/cgi-bin/mapserv?map="+ogrMapfile;delete this.params['SHAPEINDEX'];delete this.params['QLAYER'];delete this.params['QUERYFILE'];delete this.params['TIME'];}else{this.params.mode='nquery';this.params['qformat']='png24';this.params['QUERYFILE']=qfile;this.params['TIME']=new Date().getTime();delete this.params['SHAPEINDEX'];delete this.params['QLAYER'];}
break;case this.DISPLAY_MAP:default:if(oldMapfile!=""&&oldUrl!=""){this.mapfile=oldMapfile;this.url=oldUrl;this.mainLayers=oldLayer;this.params.LAYERS=oldLayer;}
this.params.mode='map';delete this.params['SHAPEINDEX'];delete this.params['QLAYER'];delete this.params['QUERYFILE'];delete this.params['TIME'];break;}
this.displayMode=mode;this.redraw();},DISPLAY_MAP:0,DISPLAY_QUERYMAP:1,DISPLAY_NQUERYMAP:2,CLASS_NAME:"Carmen.Layer.MapServerGroup",handleSelection:function(lname){return this.selectionSupport;},hasSelection:function(lname){var res=false;if(lname==null){for(var i=0;i<this.subLayers.length;i++){res=res||this.hasSelection(this.subLayers[i].name);}}
else{var lInfo=this.getSubLayerInfo(lname);if(lInfo&&lInfo.selection&&lInfo.selection.store)
res=lInfo.selection.store&&lInfo.selection.store.getCount()>0;}
return res;},clearSelection:function(lname){if(lname==null){for(var i=0;i<this.subLayers.length;i++){this.clearSelection(this.subLayers[i].name);}}
else{var lInfo=this.getSubLayerInfo(lname);if(lInfo&&lInfo.selection&&lInfo.selection.store)
lInfo.selection.store.removeAll();}},setSelectionConfig:function(lname,config){var lInfo=this.getSubLayerInfo(lname);if(lInfo){lInfo.selection=config;}},setSelectionStore:function(lname,st){var lInfo=this.getSubLayerInfo(lname);if(lInfo)
lInfo.selection.store=st;},getSelection:function(lname){var lInfo=this.getSubLayerInfo(lname);return lInfo?lInfo.selection:null;}});Carmen.Layer.MapServerGroup.DISPLAY_MAP=0;Carmen.Layer.MapServerGroup.DISPLAY_QUERYMAP=1;Carmen.Layer.MapServerGroup.DISPLAY_NQUERYMAP=2;Carmen.Layer.WMTSGroup=new OpenLayers.Class(OpenLayers.Layer.WMTS,{subLayers:[],mainLayers:'',wmtsName:'',initialize:function(options){OpenLayers.Layer.WMTS.prototype.initialize.apply(this,arguments);this.ratio=1.0;this.mainLayers=this.options.layer;this.subLayers=[];if(!this.wmtsName&&this.mainLayers&&this.mainLayers.length>0)
this.wmtsName=this.mainLayers;if(this.mainLayers.length==0&&this.wmtsName)
this.mainLayers=this.wmtsName;},hasSubLayers:function(){return this.subLayers.length>0;},addSubLayer:function(layerName,visible,wmtsName){var info=this.getSubLayerInfo(layerName);if(info==null){this.subLayers.push({name:layerName,visible:visible,wmsName:wmtsName,index:this.subLayers.length});}
else{info.visible=visible;info.wmtsName=wmtsName;}
var layerVisibility=false;for(var i=0;i<this.subLayers.length;i++){layerVisibility=layerVisibility||this.subLayers[i].visible;}
this.visibility=layerVisibility;},moveSubLayer:function(layerName,index){var info=this.getSubLayerInfo(layerName);if(info!=null){var toBeUpdated=this.subLayers.splice(info.index+1);this.subLayers.pop();for(var i=0;i<toBeUpdated.length;i++)
toBeUpdated[i].index=toBeUpdated[i].index-1;this.subLayers=this.subLayers.concat(toBeUpdated);var toBeUpdated=this.subLayers.splice(index);info.index=index;this.subLayers.push(info);for(var i=0;i<toBeUpdated.length;i++)
toBeUpdated[i].index=toBeUpdated[i].index+1;this.subLayers=this.subLayers.concat(toBeUpdated);}},clone:function(obj){if(obj==null){obj=new Carmen.Layer.WMTSGroup(this.name,this.url,this.params,this.options);}
obj=OpenLayers.Layer.Grid.prototype.clone.apply(this,[obj]);obj.setVisibility(this.visibility);obj.setIsBaseLayer(this.isBaseLayer);obj.subLayers=[].concat(this.subLayers);obj.mainLayers=this.mainLayers;obj.displayMode=this.DISPLAY_MAP;obj.qstring='';obj.qitem='';return obj;},split:function(index){var res=[];if(index>this.subLayers.length){res.push(this);res.push(null);}
else if(index<0){this.subLayers=[];newLayer=this.clone();res.push(this);res.push(newLayer);}
else{var newLayer=this.clone();newLayer.subLayers=new Array();var subLayers2=new Array();for(var i=0;i<this.subLayers.length;i++){if(i<=index)
subLayers2.push(this.subLayers[i]);else
newLayer.subLayers.push(this.subLayers[i]);}
delete this.subLayers;this.subLayers=subLayers2;for(var i=0;i<this.subLayers.length;i++){this.subLayers[i].index=i;}
for(var i=0;i<newLayer.subLayers.length;i++){newLayer.subLayers[i].index=i;}
res.push(this);res.push(newLayer);}
return res;},getSubLayerInfo:function(layerName){var i=0;while(i<this.subLayers.length&&this.subLayers[i].name!=layerName){i++;}
return(i<this.subLayers.length)?this.subLayers[i]:null;},setSubLayerVisibility:function(layerName,isVisible){var subLayer=this.getSubLayerInfo(layerName);if(subLayer!=null)
subLayer.visible=isVisible;var layerVisibility=false;for(var i=0;i<this.subLayers.length;i++){layerVisibility=layerVisibility||this.subLayers[i].visible;}
this.setVisibility(layerVisibility);this.display(layerVisibility);this.redraw();if(this.map!=null){this.map.events.triggerEvent("changelayer",{layer:this,property:"visibility"});}
this.events.triggerEvent("visibilitychanged");},getVisibility:function(layerName){var vis=true;if(layerName==null||layerName==this.mainLayers)
vis=OpenLayers.Layer.WMTS.prototype.getVisibility.apply(this,[]);else
vis=this.getSubLayerVisibility(layerName);return vis;},getSubLayerVisibility:function(layerName){var subLayer=this.getSubLayerInfo(layerName);return subLayer.visible;},_getLayersParam:function(){var str=this.mainLayers;for(var i=0;i<this.subLayers.length;i++){if(this.subLayers[i].visible){str=str+","+this.subLayers[i].wmsName;}}
str=(str.length>0)&&(str.charAt(0)==',')?str.slice(1):str;return str;},redraw:function(){var redrawn=false;this.params.LAYERS=this._getLayersParam();redrawn=OpenLayers.Layer.WMTS.prototype.redraw.apply(this,arguments);OpenLayers.Layer.WMTS.prototype.updateMatrixProperties.apply(this,arguments);return redrawn;},handleSelection:function(lname){return true;},layerNotRespondingHandler:function(){if(this.idImg)
var domImg=document.getElementById(this.idImg);if(domImg)
document.body.removeChild(domImg);alert("Couche WMTS","Les couches "+this.control._getLayersParam()+" ne semblent pas joignables. Elles ne seront sans doute ni visibles, ni interrogeables.");},checkLayerWellResponding:function(map,failure){failure=failure==null?this.layerNotRespondingHandler:failure;var oldMap=this.map;this.map=map;this.imageSize=map.getCurrentSize();this.params.EXCEPTIONS='application/vnd.ogc.se_xml';var testImg=document.createElement('img');testImg.src=this.getURL(map.getMaxExtent())+"&test";testImg.style.display='none';testImg.id="testImg";var scope={idImg:"testImg",control:this};testImg.onerror=function(){failure.apply(scope);};document.body.appendChild(testImg);this.imageSize=null;this.map=oldMap;delete this.params.EXCEPTIONS;},CLASS_NAME:"Carmen.Layer.WMTSGroup"});Carmen=window.Carmen||{};Carmen.Util={};Carmen.DOTS_PER_INCH=96;Carmen.Mapserver_DOTS_PER_INCH=96;Carmen.CARMEN_ERROR=256;Carmen.CARMEN_ERROR_SESSION_EXPIRED=257;Carmen.Util.WMS_FULL_LEGEND_MIN_WIDTH=82;Carmen.Util.WMS_FULL_LEGEND_MIN_HEIGHT=40;Carmen.Util.WMSC_RESOLUTIONS=[2113.267326,1056.633663,528.3168317,264.1584158,132.0792079,66.03960396,26.41584158,13.229166668,6.614583334,4.630208105,2.645833334,1.322916667,0.661458333];Carmen.Util.MAP_RESOLUTIONS=[156543.03395208137,78271.516843749,39135.758554166176,19567.879277083088,9783.939506249877,4891.969885416605,2445.984810416636,1222.9925374999846,611.4962687499923,305.7480020833295,152.8741333333314,76.4370666666657,38.21853333333285,19.109266666666425,9.554633333333213,4.777316666666606,2.388658333333303,1.1943291666666516,0.5971645833333258,0.2984499999999962,0.1492249999999981,0.07461249999999905];Carmen.SpecialChars={"around":String.fromCharCode(0x02248)};Carmen.Util.INFO_TOOL_XY_TOLERANCE=5;Carmen.Util.initLegend=function(){this.context=new Carmen.JSONContext(jsOws);var ctx=this.context;var layerTreeManager=new Carmen.Control.LayerTreeManager();var jsonLayerTree=ctx.mdataMap.LayerTree;var jsonLayerList=ctx.layer;layerTreeManager.buildTree(jsonLayerTree,jsonLayerList);var legend=new Carmen.Control.Legend();legend.layerTreeManager=layerTreeManager;legend.renderHTMLto("legendDiv");submitForm();}
Carmen.Util.activeControl=null;Carmen.Util.buildExt2olHandlerToggle=function(olControl){return function(extBtn,state){if(Carmen.Util.activeControl&&Carmen.Util.activeControl!=olControl&&!state){return;}
if(Carmen.Util.activeControl&&Carmen.Util.activeControl!=olControl){Carmen.Util.activeControl.state=false;Carmen.Util.activeControl.deactivate();}
if(state&&Carmen.Util.activeControl!=olControl){Carmen.Util.activeControl=olControl;}
if(Carmen.Util.activeControl&&Carmen.Util.activeControl==olControl&&!state){Carmen.Util.activeControl.deactivate();Carmen.Util.activeControl=null;}
if(Carmen.Util.activeControl){Carmen.Util.activeControl.activate();Carmen.Util.activeControl.active=true;}}};Carmen.Util.buildExt2olHandlerButton=function(olControl){return function(){olControl.trigger();}};Carmen.Util.handleAjaxFailure=function(response,callerName,skipExceptSession){};Carmen.Util.olRegisterProfilerEvents=function(layer){layer.logEvent=function(event){}
layer.events.register("loadstart",layer,function(){this.logEvent("Load Start");});layer.events.register("tileloaded",layer,function(){this.logEvent("Tile loaded. "+this.numLoadingTiles
+" left.");});layer.events.register("loadend",layer,function(){this.logEvent("Load End. Grid:"+this.grid.length+"x"
+this.grid[0].length);});};Carmen.Util.getTimeStamp=function(){var date=new Date();var timeParts=[date.getHours(),date.getMinutes(),date.getSeconds()];var timeStamp=timeParts.join(":");return timeStamp;};Carmen.Util.openHelp=function(){window.open('http://carmen.ecologie.gouv.fr','Help',"location=no, toolbar=no, scrollbars=yes");}
Carmen.Util.openWindow=function(title,url){window.open(url,title,"location=no, toolbar=no, scrollbars=yes");};Carmen.Util.openWindowExt=function(title,url,autosize){};Carmen.Util.forceScrollOnToolbarInIE=function(tb){var scrollHeight=tb.getEl().dom.scrollHeight;var clientHeight=tb.getEl().dom.clientHeight;var viewWidth=tb.getEl().getComputedWidth();var tbWidth=tb.getEl().first().getComputedWidth();var style={paddingBottom:"2px",overflowX:"auto"};if(scrollHeight>clientHeight||tbWidth>viewWidth){style.overflowX="scroll";}
tb.getEl().applyStyles(style);};Carmen.Util.openDownloadData=function(){};function myEditFunction(){alert("ok");};Carmen.Util.doAjax=function(url,MsgBoxTitle,useClassicAlert){}
Carmen.Util.encode_utf8=function(s){return unescape(encodeURIComponent(s));};Carmen.Util.decode_utf8=function(s){return decodeURIComponent(escape(s));};Carmen.Util.array_find=function(arr,value){var i=-1;while(i<arr.length&&arr[i]!=value){i++;}
return i;};Carmen.Util.json2xml=function(jsonObj,header){return json2xml(jsonObj,null,header);}
function json2xml(o,tab,header){var toXml=function(v,name,ind){var xml="";if(typeof v!='undefined'){if(v instanceof Array){for(var i=0,n=v.length;i<n;i++)
xml+=ind+toXml(v[i],name,ind+"\t")+"\n";}else if(typeof(v)=="object"){var hasChild=false;xml+=ind+"<"+name;for(var m in v){if(m.charAt(0)=="@")
xml+=" "+m.substr(1)+"=\""+Carmen.Util.htmlspecialchars(v[m].toString())+"\"";else if(m=="attributes"){for(n in v[m]){if(typeof v[m][n]=='undefined'){v[m][n]="";}
xml+=" "+n.toString()+'="'+Carmen.Util.htmlspecialchars(v[m][n].toString())+'"';}}else
hasChild=true;}
xml+=hasChild?">":"/>";if(hasChild){for(var m in v){if(m=="#text")
xml+=v[m];else if(m=="#cdata")
xml+="<![CDATA["+v[m]+"]]>";else if(m.charAt(0)!="@"&&m!="attributes")
xml+=toXml(v[m],m,ind+"\t");}
xml+=(xml.charAt(xml.length-1)=="\n"?ind:"")+"</"
+name+">";}}else{xml+=ind+"<"+name+">"+Carmen.Util.htmlspecialchars(v.toString())+"</"+name+">";}}
return xml;};var xml=header?header:"";for(var m in o)
xml+=toXml(o[m],m,"");return tab?xml.replace(/\t/g,tab):xml.replace(/\t|\n/g,"");}
Carmen.Util.htmlspecialchars=function(str){str=str.replace(/&/g,'&amp;');str=str.replace(/"/g,'&quot;');str=str.replace(/>/g,'&gt;');str=str.replace(/</g,'&lt;');return str;}
Carmen.Util.unhtmlspecialchars=function(str){str=str.replace(/&amp;/g,'&');str=str.replace(/&quot;/g,'"');str=str.replace(/&gt;/g,'>');str=str.replace(/&lt;/g,'<');return str;}
Carmen.Util.olInherits=function(daughter,mother){var res=(daugther.prototype.CLASS_NAME==mother.prototype.CLASS_NAME);if('parent'in daughter&&!res){res=Carmen.Util.olInherits(daughter.parent,mother);}
return res;};Carmen.Util.chompAndSplit=function(str,sep){if((typeof str!=="undefined")&&str.length>0&&str.substr(str.length-1,1)==sep){str=str.substr(0,str.length-1);}
return str.split(sep);};Carmen.Util.decodeCarmenFieldDesc=function(fieldDesc,baseURL){var arrFieldDesc=Carmen.Util.chompAndSplit(fieldDesc,'|');if(baseURL=="null")
baseURL='';return arrFieldDesc.length>=3?{name:arrFieldDesc[0],alias:arrFieldDesc[1],type:arrFieldDesc[2],url:(arrFieldDesc[2]!='URL'&&arrFieldDesc[2]!='IMG')?null:(arrFieldDesc.length>3?baseURL+arrFieldDesc[3]:baseURL+'<'+arrFieldDesc[0]+'>')}:null;};Carmen.Util.carmenTypeToExtType=function(carmenStr){var res='auto';switch(carmenStr){case'TXT':res='string';break;case'URL','IMG':res='auto';break;case'AAAAMMJJ','AAAAJJMM','MMJJAAAA','JJMMAAAA':res='date';break;default:break;}
return res;};Carmen.Util.fieldFilter_URL=function(field){return field.type=='URL';};Carmen.Util.fieldFilter_TXT=function(field){return field.type=='TXT';};Carmen.Util.carmenDateTypeToExtDateFormat=function(carmenStr){var res='d-m-Y';switch(carmenStr){case'AAAAMMJJ':res='Y-m-d';break;case'AAAAJJMM':res='Y-d-m';break;case'MMJJAAAA':res='m-d-Y';break;case'JJMMAAAA':res='d-m-Y';break;default:break;}
return res;};Carmen.Util.textRenderer=function(v){var html='<span>'+v+'</span>';return html;};Carmen.Util.URL2Html=function(v){var url_info=Carmen.Util.parseURL(unescape(v.href));var url=url_info==null?v.href:url_info.protocol+'://'+url_info.host+'/'+url_info.mid+url_info.end;var html='<u><span onclick="javascript:window.open(\''+
url+'\', \'_blank\');" >'+v.text+'</span></u>';return html;};Carmen.Util.URLRenderer=function(v){var html='<span class="cmnLayerTreeLayerNodeMetadata">'+Carmen.Util.URL2Html(v)+'</span>';return html;};Carmen.Util.imgRenderer=function(src){var html='<span>Aucune image associée</span>';if(src!=null&&src!='')
var url_info=Carmen.Util.parseURL(unescape(src));var url=url_info==null?src:url_info.protocol+'://'+url_info.host+'/'+url_info.mid+url_info.end;html='<span class="cmnImgRenderer"><img src="'+
url+'" onclick="javascript:window.open(\''+
url+'\', \'_blank\');" /></span>';return html;};Carmen.Util.extentRenderer=function(v){return'<div class="cmnInfoGridZoomIcon"> </div>';};Carmen.Util.carmenTypeToExtRenderer=function(carmenStr){};Carmen.Util.carmenFontDescToFontStyles=function(fontDesc){var desc={};desc.font=fontDesc;var t=fontDesc.match(/[^-]+/g);if(t!=null){desc.font=t[0];for(var i=1;i<t.length;i++){switch(t[i].toLowerCase()){case"gras":desc.fontWeight='bold'
break;case"italique":desc.fontStyle='italic'
break;}}}
return desc;}
Carmen.Util.clone=function(obj){var cloned={};for(a in obj){cloned[a]=obj[a];}
return cloned;};Carmen.Util.strExtentToOlBounds=function(extentStr,punctualBufferRadius){var tabExtent=extentStr.substr(1,extentStr.length-1).split(",");for(var i=0;i<4;i++)
tabExtent[i]=parseFloat(tabExtent[i]);if(punctualBufferRadius){if(tabExtent[1]==tabExtent[3]){tabExtent[1]=tabExtent[1]-punctualBufferRadius;tabExtent[3]=tabExtent[3]+punctualBufferRadius;}
if(tabExtent[2]==tabExtent[4]){tabExtent[2]=tabExtent[2]-punctualBufferRadius;tabExtent[4]=tabExtent[4]+punctualBufferRadius;}}
return new OpenLayers.Bounds(tabExtent[0],tabExtent[1],tabExtent[2],tabExtent[3]);};Carmen.Util.positionToStr=function(position){var str="";if(position instanceof OpenLayers.Bounds){str='('+position.left+','+position.bottom+','+position.right+','+position.top+')';}
else if(position instanceof OpenLayers.LonLat){str='('+position.lon+','+position.lat+')';}
else if(position instanceof OpenLayers.Pixel){str='('+position.x+','+position.y+')';}
return str;};Carmen.Util.circleToStr=function(circle){var str="";if(circle.radius!=undefined&&circle.origin!=undefined){str='('+circle.origin.x+','+circle.origin.y+','+circle.radius+')';}
return str;};Carmen.Util.convertContextBBtoolBounds=function(bb){return new OpenLayers.Bounds(bb.attributes.minx,bb.attributes.miny,bb.attributes.maxx,bb.attributes.maxy);};Carmen.Util.array_filter=function(aray,filter){var res=[];for(var i=0;i<aray.length;i++){if(filter(aray[i])){res.push(aray[i]);}}
return res;}
Carmen.Util.array_map=function(aray,f){var res=[];for(var i=0;i<aray.length;i++){res.push(f(aray[i]));}
return res;}
Carmen.Util.array_forEach=function(aray,f){var i=0,l=this.length,j;for(i=0;i<l;i++){if((j=this[i])){f(j);}}}
Carmen.Util.buildColumnModel=function(fieldsDesc,withExtent,noSpecialRenderer){};Carmen.Util.buildFieldsDesc=function(cmnFieldStr,baseQueryURL){var fieldsDesc=[];baseQueryURL=baseQueryURL?baseQueryURL:"";var list=Carmen.Util.chompAndSplit(cmnFieldStr,';');for(var j=0;j<list.length;j++){var desc=Carmen.Util.decodeCarmenFieldDesc(list[j],baseQueryURL);fieldsDesc.push(desc);}
return fieldsDesc;}
Carmen.Util.set_add=function(aray,el,f_merge){var i=0;if(!f_merge)
f_merge=function(e1,e2){return e1===e2;};while(i<aray.length&&!(f_merge(aray[i],el)))
i++;if(i>=aray.length)
aray.push(el);return aray;}
Carmen.Util.set_from_array=function(aray){var set=[];for(var i=0;i<aray.length;i++){Carmen.Util.set_add(set,aray[i]);}
return set;}
Carmen.Util.set_member=function(aray,el){var i=0;while(i<aray.length&&(aray[i]!=el))
i++;return i<aray.length;}
Carmen.Util.loadPage=function(URL){if(URL)
top.window.location.replace(URL);else{top.window.location.reload();}}
Carmen.Util.loadXML=function(xmlStr){var xmlDoc={};if(document.implementation&&document.implementation.createDocument){xmlDoc=document.implementation.createDocument("","",null);}
else if(window.ActiveXObject){xmlDoc=new ActiveXObject("Microsoft.XMLDOM");xmlDoc.onreadystatechange=function(){if(xmlDoc.readyState==4){}};}
else{xmlDoc=xmlStr;alert('Your browser can\'t load the XML file: '+e.toString());}
xmlDoc.async="false";xmlDoc.load(xmlStr);return xmlDoc;}
Carmen.Util.bool2IntStr=function(bool){return bool?"1":"0";};Carmen.Util.descendingOrder=function(a,b){return b-a;};Carmen.Util.roundIntTo2Digits=function(n){var res=new Number(n).toFixed();var n_str=res.toString();if(n_str.length>2){var n_str_1=n_str.substr(0,2);var n_str_2=n_str.substr(2);var n2_str=n_str_1+'.'+n_str_2;var n_dec_digits=n_str_2.length;var n2=parseFloat(n2_str).toFixed();res=n2*Math.pow(10,n_dec_digits);}
return res;};Carmen.Util.roundIntToNdigits=function(n,d){var res=new Number(n).toFixed();res=Math.round(res/100)*100;var n_str=res.toString();if(n_str.length>d){var n_str_1=n_str.substr(0,d);var n_str_2=n_str.substr(d);var n2_str=n_str_1+'.'+n_str_2;var n_dec_digits=n_str_2.length;var n2=parseFloat(n2_str).toFixed();res=n2*Math.pow(10,n_dec_digits);}
return res;};Carmen.Util.roundIntToDigits=function(n){var res=new Number(n).toFixed();var n_str=res.toString();var n_digits=res>50000?2:3;res=Carmen.Util.roundIntToNdigits(n,n_digits);return res;};Carmen.Util.scaleTextFormater=function(scale){var denom=parseInt(scale).toString();var newDenom='';for(var i=0;i<denom.length;i++){newDenom=denom.charAt(denom.length-1-i)+newDenom;if((i+1)%3==0&&(i+1)<denom.length)
newDenom=' '+newDenom;}
return' 1 / '+newDenom;};Carmen.Util.isGeographicProjection=function(cs){var prj=null;if(typeof cs=="string")
prj=new OpenLayers.Projection(cs);else if(cs instanceof OpenLayers.Projection)
prj=cs;return(prj!=null)?(prj.getUnits()==null):false;};Carmen.Util.loadProjection=function(crs)
{var prj=null;if(typeof crs=="string")
prj=new OpenLayers.Projection(crs);else if(cs instanceof OpenLayers.Projection)
prj=crs;return prj;};Carmen.Util.getProjectionUnits=function(cs){var prj=Carmen.Util.loadProjection(cs);return(prj==null)?'dd':prj.getUnits()==null?'dd':prj.getUnits();};Carmen.Util.resNearTester=function(r1,r2){var denom1=OpenLayers.Util.getScaleFromResolution(r1,"m");var denom2=OpenLayers.Util.getScaleFromResolution(r2,"m");var delta=Math.abs(denom1-denom2)/Math.max(denom1,denom2);return(delta<0.01);}
Carmen.Util.OLWMSGroup2CarmenOWSDesc=function(layer,nextLayerId,extraDesc){};Carmen.Util.OLWMTSGroup2CarmenOWSDesc=function(layer,nextLayerId,extraDesc){};Carmen.Util.OLVector2CarmenOWSDesc=function(layer,nextLayerId,extraDesc){};Carmen.Util.OLWFSGroup2CarmenOWSDesc=function(layer,nextLayerId,extraDesc){};Carmen.Util.OLWFSCarmenOWSDesc=function(layer,nextLayerId,extraDesc){};Carmen.Util.OLLOCALDATACarmenOWSDesc=function(layer,layerId,extraDesc){}
var XD=function(){var interval_id,last_hash,cache_bust=1,attached_callback,window=this;return{postMessage:function(message,target_url,target){if(!target_url){return;}
target=target||parent;if(window['postMessage']){target['postMessage'](message,target_url.replace(/([^:]+:\/\/[^\/]+).*/,'$1'));}else if(target_url){target.location=target_url.replace(/#.*$/,'')+'#'+(+new Date)+(cache_bust++)+'&'+message;}},receiveMessage:function(callback,source_origin){if(window['postMessage']){if(callback){attached_callback=function(e){if((typeof source_origin==='string'&&e.origin!==source_origin)||(Object.prototype.toString.call(source_origin)==="[object Function]"&&source_origin(e.origin)===!1)){return!1;}
callback(e);};}
if(window['addEventListener']){window[callback?'addEventListener':'removeEventListener']('message',attached_callback,!1);}else{window[callback?'attachEvent':'detachEvent']('onmessage',attached_callback);}}else{interval_id&&clearInterval(interval_id);interval_id=null;if(callback){interval_id=setInterval(function(){var hash=document.location.hash,re=/^#?\d+&/;if(hash!==last_hash&&re.test(hash)){last_hash=hash;callback({data:hash.replace(re,'')});}},100);}}}};}();var Url={encode:function(string){return escape(this._utf8_encode(string));},decode:function(string){return this._utf8_decode(unescape(string));},_utf8_encode:function(string){string=string.replace(/\r\n/g,"\n");var utftext="";for(var n=0;n<string.length;n++){var c=string.charCodeAt(n);if(c<128){utftext+=String.fromCharCode(c);}else if((c>127)&&(c<2048)){utftext+=String.fromCharCode((c>>6)|192);utftext+=String.fromCharCode((c&63)|128);}else{utftext+=String.fromCharCode((c>>12)|224);utftext+=String.fromCharCode(((c>>6)&63)|128);utftext+=String.fromCharCode((c&63)|128);}}
return utftext;},_utf8_decode:function(utftext){var string="";var i=0;var c=c1=c2=0;while(i<utftext.length){c=utftext.charCodeAt(i);if(c<128){string+=String.fromCharCode(c);i++;}else if((c>191)&&(c<224)){c2=utftext.charCodeAt(i+1);string+=String.fromCharCode(((c&31)<<6)|(c2&63));i+=2;}else{c2=utftext.charCodeAt(i+1);c3=utftext.charCodeAt(i+2);string+=String.fromCharCode(((c&15)<<12)|((c2&63)<<6)|(c3&63));i+=3;}}
return string;}};Carmen.Util.addCssSheet=function(windowElt,filename,firstPos){var css_style=windowElt.document.createElement("link");css_style.setAttribute("rel","stylesheet");css_style.setAttribute("type","text/css");css_style.setAttribute("href",filename);var head=windowElt.document.getElementsByTagName("head")[0];if(firstPos)
head.insertBefore(css_style,head.firstChild);else
head.appendChild(css_style);}
Carmen.Util.addCssClass=function(elt,className){elt.className=elt.className+" "+className;}
Carmen.Util.colorStr2css=function(colorStr){var r,g,b;r=parseInt(colorStr.slice(0,2),16);g=parseInt(colorStr.slice(2,4),16);b=parseInt(colorStr.slice(4),16);return{r:r,g:g,b:b};};Carmen.Util.isComplexGeometry=function(geom){return(geom.CLASS_NAME=="OpenLayers.Geometry.Collection"||geom.CLASS_NAME=="OpenLayers.Geometry.MultiLineString"||geom.CLASS_NAME=="OpenLayers.Geometry.MultiPolygon"||geom.CLASS_NAME=="OpenLayers.Geometry.MultiPoint");};Carmen.Util.simplifyFeature=function(feature){var newFeatures=[];var res=[];var geom=feature.geometry;if(Carmen.Util.isComplexGeometry(geom)){for(var j=0;j<geom.components.length;j++){var f=feature.clone();f.geometry=f.geometry.components[j];newFeatures.push(f);}
res=res.concat([],newFeatures);}
else
res=[feature];if(newFeatures.length>0){for(var i=0;i<newFeatures.length;i++){var newFeatures2=Carmen.Util.simplifyFeature(newFeatures[i]);if(newFeatures2.length>0)
res=res.concat(newFeatures2);}}
return res;};Carmen.Util.parseURL=function(url){res=null;var url_pattern=url_pattern=/(\w+):\/\/([^\/]+)\/(.+\/)*([^\/]*)$/;var matched=url.match(url_pattern);if(matched!=null){res={fullurl:matched[0],protocol:matched[1],host:matched[2],mid:matched[3]?matched[3]:"",end:matched[4]};res.start=res.protocol+'://'+res.host+'/'+res.mid;}
return res;};Carmen.Util.parsePath=function(path){var path_pattern=/(.*\/)*([^\/]+)$/;var matched=path.match(path_pattern);var res=null;if(matched!=null){res={start:matched[1]?matched[1]:"",end:matched[2]?matched[2]:""};}
return res;};Carmen.Util.parseFilename=function(filename){var file_pattern=/([^\.]*)\.?(.*)$/;var matched=filename.match(file_pattern);var res=null;if(matched!=null){res={basename:matched[1]?matched[1]:"",suffix:matched[2]?matched[2]:""};}
return res;};Carmen.Util.doFormUpload=function(f,url,queryParams){};Carmen.Util.computeLinearMidPoint=function(line){var vertices=line.getVertices();var a=vertices[0];var x=a.x;var y=a.y;var lmid=line.getLength()/2.0;if(vertices.length>2){var b=vertices[1];var ab=new OpenLayers.Geometry.Curve([a,b]);var lab=ab.getLength();var l=lab;var i=0;while(!(l>=lmid)){i++;a=b;b=vertices[i];ab=new OpenLayers.Geometry.Curve([a,b]);lab=ab.getLength();l=l+lab;}
ldelta=lab-l+lmid;x=a.x+(b.x-a.x)*(ldelta/lab);y=a.y+(b.y-a.y)*(ldelta/lab);}
return new OpenLayers.Geometry.Point(x,y);};Carmen.Util.stats=function(values){var res={};res.count=values.length;if(values.length>0){var sum=0;var min=Number.MAX_VALUE;var max=Number.MIN_VALUE;var average=Number.MIN_VALUE;for(var i=0;i<values.length;i++){value=parseFloat(values[i]);sum=sum+value;min=min>value?value:min;max=max<value?value:max;}
if(!isNaN(sum)){average=sum/values.length;res.sum=sum;res.min=min;res.max=max;res.average=average;if(values.length>1){var variance=0.0
for(var i=0;i<values.length;i++){value=parseFloat(values[i]);variance=variance+((value-average)*(value+average));}
res.variance=variance/(values.length-1);res.stddeviation=Math.sqrt(variance);}}}
return res;}
initBanner=function(){var frame=document.getElementById("iframe-banner").contentWindow;if(typeof(frame!="undefined")&&frame!=null&&frame.document.getElementById("CARTE_NOM")!=null){frame.document.getElementById("CARTE_NOM").innerHTML=Url.decode(jsOws.ViewContext.General.Title);Carmen.Util.addCssSheet(frame,overloadExtTheme,true);Carmen.Util.addCssClass(frame.document.body,"x-window-mc");}
if(typeof(frame!="undefined")&&frame!=null&&frame.document.querySelectorAll(".title").length==1){frame.document.querySelectorAll(".title")[0].innerHTML=Url.decode(jsOws.ViewContext.General.Title);Carmen.Util.addCssSheet(frame,overloadExtTheme,true);Carmen.Util.addCssClass(frame.document.body,"x-window-mc");}
if(typeof(frame!="undefined")&&frame!=null&&frame.document.querySelectorAll(".commentaire").length==1){if(jsOws.ViewContext.General.Extension&&jsOws.ViewContext.General.Extension.COMMENTAIRE)
frame.document.querySelectorAll(".commentaire")[0].innerHTML=Url.decode(jsOws.ViewContext.General.Extension.COMMENTAIRE);else
frame.document.querySelectorAll(".commentaire")[0].innerHTML="";}};function NavToolbarFontAwesome(icon){return"fa "+icon;}
Prodige.Control=Prodige.Control||{};Prodige.Control.ZoomIn=OpenLayers.Class(OpenLayers.Control.ZoomBox,{CLASS_NAME:"Prodige.Control.ZoomIn"});Prodige.Control.ZoomOut=OpenLayers.Class(OpenLayers.Control.ZoomBox,{out:true,CLASS_NAME:"Prodige.Control.ZoomOut"});Prodige.NavToolbar=OpenLayers.Class(OpenLayers.Control.Panel,{controlsDefinitions:{"Navigation":{'zoomWheelEnabled':true,dragPanOptions:{enableKinetic:true},fontAwesome:NavToolbarFontAwesome("fa-arrows")},"ZoomIn":{'zoomWheelEnabled':true,dragPanOptions:{enableKinetic:true},fontAwesome:NavToolbarFontAwesome("fa-search-plus")},"ZoomOut":{'zoomWheelEnabled':true,dragPanOptions:{enableKinetic:true},type:OpenLayers.Control.TYPE_TOOL,fontAwesome:NavToolbarFontAwesome("fa-search-minus")},"ZoomToMaxExtent":{fontAwesome:NavToolbarFontAwesome("fa-globe")}},initialize:function(options){OpenLayers.Control.Panel.prototype.initialize.apply(this,[options]);var controls=[];this.displayClass="prodigeControlNavToolbar";for(var klassName in this.controlsDefinitions){if(typeof Prodige.Control[klassName]=="undefined"){Prodige.Control[klassName]=OpenLayers.Class(OpenLayers.Control[klassName],{CLASS_NAME:"Prodige.Control."+klassName});}
var klass=Prodige.Control[klassName];var definition=this.controlsDefinitions[klassName];var control=new klass(definition);controls.push(control);}
this.addControls(controls);},draw:function(){var div=OpenLayers.Control.Panel.prototype.draw.apply(this,arguments);if(typeof this.defaultControl=="string"){for(var i=0;i<this.controls.length;i++){if(this.controls[i].type==OpenLayers.Control.TYPE_TOOL&&this.controls[i].CLASS_NAME.toLowerCase().indexOf(this.defaultControl.toLowerCase())!=-1){this.defaultControl=this.controls[i];break;}}
if(typeof this.defaultControl=="string"){this.defaultControl=null;}}
if(this.defaultControl===null){this.defaultControl=this.controls[0];}
return div;},addControls:function(controls){if(!(controls instanceof Array)){controls=[controls];}
for(var i=0;i<controls.length;i++){controls[i].displayClass="";}
OpenLayers.Control.Panel.prototype.addControls.apply(this,[controls]);},createControlMarkup:function(control){var div=document.createElement("div");if(control.fontAwesome){var awesome=document.createElement("i");awesome.className=control.fontAwesome;div.appendChild(awesome);}
return div;},CLASS_NAME:"OpenLayers.Control.NavToolbar"});