function valueFrom(value, defaultValue, allowBlank){
  if ( typeof Ext !="undefined" ){
    return valueFrom(value, defaultValue, allowBlank);
  } else {
    var isEmpty = function(value, allowEmptyString) {
      return (value == null) || (!allowEmptyString ? value === '' : false) || ((toString.call(value) === '[object Array]') && value.length === 0);
    }
    return isEmpty(value, allowBlank) ? defaultValue : value;
  }
}

AbstractMapBuilder = new OpenLayers.Class({
  owscontext : null,
  keymapVisible : true,
  keymapVisible : true,
  id : null,
  renderTo : null,
  
  map : null,
  keymap : null,
  alwaysActivCtrls : [
    "zoomin", "zoomout", "zoomhistory", "zoomwheel", 
    "InfoCircle",
    "InfoURL",
    "InfoPolygon",
    "InfoPolyline",
    "areaExtractor",
    "edition"
  ],
  onlyActivCtrls : [
  ],
  
  initialize : function()
  { 
    if ( this.owscontext===null ){
      throw "AbstractMapBuilder : the owscontext property is required for instanciation";
    }
    
    this.renderTo = OpenLayers.Util.getElement(this.renderTo || document.body) || window;
    this.id = this.id || OpenLayers.Util.createUniqueID(this.CLASS_NAME+'-');
    
    this._cleanMap();
    this.buildMap();
    this.addControls();
    this.buildKeymap();
    this.buildLegend();
    this.addLayers();
    
    this.map.zoomToExtent(this.owscontext.getExtent());
    this.layerTreeManager.initNodes();
  },
  /**
   * @brief delete the map object and 
   * clean all its dependencies
   * 
   */ 
  _cleanMap: function() {
    if (this.map!=null) {
      // destroying ol map
      this.map.destroy();
      // destroying descartes map
      delete this.map;
    }
  },
  
  buildMap : function(config)
  {
    var ctx = this.owscontext;
   
    var mapOptions = {
    	usage : this.usage,
    	
      maxExtent: ctx.getMaxExtent(),
      projection: ctx.getProjection(),
      maxResolution : 'auto',
      fractionalZoom : false,
      numZoomLevels : 128,
      //allOverlays : true,
      units : ctx.getProjectionUnits(), 
      resolutions : Carmen.Util.MAP_RESOLUTIONS,  
      controls: []
    };
    
    // checking for Tile Cache (aka WMS-C layers)
    // if tile cache --> predefined zoom levels
    // so chganging default mapOptions
    if (ctx.hasLayerWMSC()) {
      mapOptions.fractionalZoom = false;
      mapOptions.numZoomLevels = null;
      mapOptions.maxResolution = null;
      mapOptions.resolutions = Carmen.Util.WMSC_RESOLUTIONS; 
    }
   
    // retrieving map min/max scale from context
    var map_minScaleDenom = ctx.getMinScaleDenom();
    var map_maxScaleDenom = ctx.getMaxScaleDenom();
    
    // filtering resolutions with respect to map min/max scale options
    if (map_minScaleDenom!=null && map_maxScaleDenom!=null) {
      if (mapOptions.resolutions!=null) {
            var res_filtered = [];
            for (var i=0; i<mapOptions.resolutions.length; i++) {
              var sc = OpenLayers.Util.getScaleFromResolution(mapOptions.resolutions[i], "m").toFixed();
              if (sc>=map_minScaleDenom && sc<=map_maxScaleDenom) {
                res_filtered.push(mapOptions.resolutions[i]);
              }
            }
            mapOptions.resolutions = res_filtered;
            mapOptions.numZoomLevels = mapOptions.resolutions.length;
            mapOptions.minScale = map_minScaleDenom;
            mapOptions.maxScale = map_maxScaleDenom;
            mapOptions.maxResolution = mapOptions.resolutions[0];
            mapOptions.minResolution = mapOptions.resolutions[mapOptions.resolutions.length-1];
      }
      else {
        mapOptions.minScale = map_minScaleDenom;
        mapOptions.maxScale = map_maxScaleDenom;  
      }
    }
    
    
    mainPanel = this.ui.getMainPanel();
    if ( mainPanel ){
      var nodes = mainPanel.getElementsByClassName("PRODIGEAPI_MAP");
      if ( nodes.length ){
        this.renderTo = nodes[0];
      }
    }
    if ( !this.renderTo ){
      this.renderTo = OpenLayers.Util.createDiv(this.id, {x:0, y:0}, {w : mainPanel.style.width.replace(/[^\D.-]/g, ''), h : mainPanel.style.height.replace(/[^\D.-]/g, '')});
      this.renderTo.add = this.renderTo.appendChild;
      this.mainPanel.add(this.renderTo);
    }
    
    
    this.map = new Carmen.MapViewer(this.renderTo, mapOptions);
    this.map.app = this;
  },
  
  isToolActiv : function(toolKey)
  {
    if ( this.alwaysActivCtrls.indexOf(toolKey)!=-1 ) return true;
    if ( this.onlyActivCtrls.length!=0 ) return this.onlyActivCtrls.indexOf(toolKey)!=-1;
    return this.owscontext.isToolActiv(toolKey);
  },
  
  addControls : function(config)
  {
    // adding toolbar tools
    var ctx = this.owscontext;
    var map = this.map;
    
   this.isToolActiv('zoomwheel') &&  map.addControl(new Carmen.Control.Navigation({
      'zoomWheelEnabled': true,
       dragPanOptions: {
            enableKinetic: true
        }
    }));
  
    if (this.isToolActiv('fitall')) 
      map.addControl(new Carmen.Control.ZoomToMaxExtent({
          toolbarTarget : ctx.getToolbarTarget('fitall'),
          toolbarPos : 0
        }));

    if (this.isToolActiv('zoom')) {
      this.isToolActiv('zoomin') && map.addControl(
        new Carmen.Control.ZoomIn({
          toolbarTarget : ctx.getToolbarTarget('zoom'),
          toolbarPos : 0
        })
      );
      this.isToolActiv('zoomout') && map.addControl(
        new Carmen.Control.ZoomOut({
          toolbarTarget : ctx.getToolbarTarget('zoom'),
          toolbarPos : 1
        })
      );
      this.isToolActiv('zoomhistory') && map.addControl(
        new Carmen.Control.ZoomHistory({
          displayConfig: Carmen.Control.ZoomHistory.PREV_BTN,
          toolbarTarget : ctx.getToolbarTarget('zoom'),
          toolbarPos : 2
        })
      );
    }
    if (this.isToolActiv('pan')) {
      map.addControl(
        new Carmen.Control.DragPan({
          toolbarTarget : ctx.getToolbarTarget('pan'),
          toolbarPos : 3
        })
      );
      // pan arrow not active anymore...
      //map.addControl(new Carmen.Control.PanArrows());
    }
    
    
    if (this.isToolActiv('info')) {
      map.addControl(new Carmen.Control.Info(
        window.CARMEN_URL_SERVER_FRONT + '/services/GetInformation/index.php',
        ctx.mdataMap.mapfile, { 
          toolbarTarget : ctx.getToolbarTarget('info'),
          toolbarPos : 5
      }));
    
      var controlsInfo = [
        "InfoCircle",
        "InfoURL",
        "InfoPolygon"
      ];
      if (Carmen.Util.FORCE_SPATIAL_SELECTION_TOOLS) {
        controlsInfo = controlsInfo.concat([
          "InfoPolygon",
          "InfoPolyline"
        ])
      }
      
      for(var c=0; c<controlsInfo.length; c++){
        var control = controlsInfo[c];
        this.isToolActiv(control) && map.addControl(new Carmen.Control[control](window.CARMEN_URL_SERVER_FRONT + '/services/GetInformation/index.php', ctx.mdataMap.mapfile));
      }
    }
  
  
    if (this.isToolActiv('buffer')) {
      map.addControl(new Carmen.Control.Buffer(
        window.CARMEN_URL_SERVER_FRONT + '/services/Buffer/index.php',
        ctx.mdataMap.mapfile));
    }
    
    if (this.isToolActiv('measure')) 
       map.addControl(new Carmen.Control.Measure());

    var controlScaleChooser = null;
    if (this.isToolActiv('scale')) {
      controlScaleChooser = new Carmen.Control.ScaleChooser();
      map.addControl(controlScaleChooser);
    }
    
    if (this.isToolActiv('geobookmark')) {   
      geoBookmarkConfig = ctx.getFavoriteAreas();
      map.addControl(new Carmen.Control.FavoriteAreas(geoBookmarkConfig));
    }
    
    if (this.isToolActiv('context')) {
      map.addControl(new Carmen.Control.ContextManager(
        window.CARMEN_URL_SERVER_FRONT + '/services/SaveContext/index.php',
        ctx.mdataMap.mapfile,
        {
          toolbarTarget : ctx.getToolbarTarget('context'),
          toolbarPos : 5
          } 
        )
      );
    }
    //console.log("application 4 2b");
    
    this.getLocateByAddress();
      
    if (this.isToolActiv('annotation')) {  
      var annotationConfig = ctx.getGeneralConfig('Annotation');
      var labelConfig = ctx.getGeneralConfig('Label');
      var annotationOptions = {
        bufferOptions : {
          serviceUrl : window.CARMEN_URL_SERVER_FRONT + '/services/Buffer/index.php',
          mapfile : ctx.mdataMap.mapfile 
        }
      };
      config = annotationConfig && labelConfig ?
       { Annotation  : annotationConfig,
         Label : labelConfig } : null;
      
      Annotations = new Carmen.Control.AdvancedAnnotation(config, annotationOptions);
      map.addControl(Annotations);
    }
  
    if (this.isToolActiv("areaExtractor") && window.AreaExtractorHandlerURL && window.AreaExtractorHandlerCallback) {
      //window.AreaExtractorHandlerURL = '';
      //window.AreaExtractorHandlerCallback = function(){};
      var areaExtractor = new Carmen.Control.AreaExtractor({
          activeAtStartup : true,
          processResponseURL: AreaExtractorHandlerURL,
          processResponseCallback: AreaExtractorHandlerCallback,
          sizeLimit : window.AreaExtractorSizeLimit ? window.AreaExtractorSizeLimit : null,
          rectOnly : window.AreaExtractorRectOnly ? window.AreaExtractorRectOnly : false
        });
      map.addControl(areaExtractor);
      this.inAreaExtractor = true;
    }
  
  //alert("application 4 3");
    if (this.isToolActiv('queryAttributes')) {
      map.addControl(new Carmen.Control.AdvancedQueryAttributes(
        window.CARMEN_URL_SERVER_FRONT + '/services/AdvancedQueryAttributes/index.php',
        ctx.mdataMap.mapfile,
        {
          toolbarTarget : ctx.getToolbarTarget('queryAttributes'),
          toolbarPos : 4
          } 
      
      ));
    }
    if (Carmen.Util.FORCE_SPATIAL_QUERY_TOOL || this.isToolActiv('querySpatial')) {
      map.addControl(new Carmen.Control.QuerySpatial(
        window.CARMEN_URL_SERVER_FRONT + '/services/GetInformation/index.php',
        ctx.mdataMap.mapfile));
    }

    if (this.isToolActiv('help')) 
      map.addControl(new Carmen.Control.Help());
    
    if (this.isToolActiv('exportImg'))
      map.addControl(new Carmen.Control.ExportImg());
    if (this.isToolActiv('exportPdf'))  
      map.addControl(new Carmen.Control.ExportPdf());
    if (this.isToolActiv('print'))
      map.addControl(new Carmen.Control.Print({
        toolbarTarget : ctx.getToolbarTarget('print'),
        toolbarPos : 6
        })
      );
    if (this.isToolActiv('download'))      
      map.addControl(new Carmen.Control.DataDownload());
  
    if (this.isToolActiv('addLayerOGC'))
      map.addControl(new Carmen.Control.AddOGC());
  
  //TODO à modifier
    if (this.isToolActiv('edition')) {
      map.addControl(new Carmen.Control.EditorManager2(
        window.CARMEN_URL_SERVER_FRONT + '/services/EditionManager/index.php',
        ctx.mdataMap.mapfile,
        {
          workingScale: 10000000,//Carmen.Util.EDITION_TOOL_WORKING_SCALE,
          callbackUrl: "",//window.computeNumerisationUrl ? window.computeNumerisationUrl : '',
          user_id: 0,//parseInt(valueFrom(ctx.mdataMap['userIdNumerisation'], -1,false)),
          emprise_id: 0,//parseInt(valueFrom(ctx.mdataMap['empriseIdNumerisation'], -1, false)),
          emprise_tablename : "",//window.empriseTablename ? window.empriseTablename : '',
          modify_object_url : ""//window.computeSelectionUrl ? window.computeSelectionUrl : ''
        })
      );
      map.addControl(new Carmen.Control.Coordinate());
    }
  
  // Zoom to place
    if (this.isToolActiv('zoomToPlace')) {
      // looking for a map specific zoomtoPlace config
      if (ctx.mdataTool.zoomToPlaceConfig != null &&
       ctx.mdataTool.zoomToPlaceConfig != "") {
        var ztp_config = Url.decode(ctx.mdataTool.zoomToPlaceConfig);
        var combosConfig = Carmen.Util.chompAndSplit(ztp_config,';');
        
        for (var i=0; i<combosConfig.length; i++) {
          combosConfig[i] = Carmen.Util.chompAndSplit(combosConfig[i],'|'); 
        }
   
        ztp_configs = [];
        for (var i=0; i<combosConfig.length; i++) {
          var config = {
            labelText : combosConfig[i][0],
            fieldNameId: combosConfig[i][2],
            providerUrl: window.CARMEN_URL_SERVER_FRONT + 
               '/services/GetAreas/index.php',
            providerBaseParams: { 
              'map' : ctx.mdataMap.mapfile, 
              'layer':  combosConfig[i][1], 
              'fieldId': combosConfig[i][2], 
              'fieldName': combosConfig[i][3],
              'fieldEchelle': combosConfig[i][4]
            }
          };
          // Testing if the combo is linked
          if (combosConfig[i].length>5) {
            if(combosConfig[i].length==7){//new version with fieldEchelle
            var linkedCombo = combosConfig[i][5];
            config['linkedCombo'] = linkedCombo;
            config['linkedFieldName'] = 'filter_id';
            config['providerLinkParams'] = {
                'filter_item': combosConfig[i][6],
                'filter_id' : ''
              };
          }else {//old version without fieldEchelle
            var linkedCombo = combosConfig[i][4];
            config['linkedCombo'] = linkedCombo;
            config['linkedFieldName'] = 'filter_id';
            config['providerLinkParams'] = {
              'filter_item': combosConfig[i][5],
              'filter_id' : ''
            };
          }
       }
          ztp_configs.push(config);
        }
        map.addControl(new Carmen.Control.ZoomToPlace({configs : ztp_configs}));
      }
      else {
        // if the map has no specific zoomtoPlace config, we take the default one form DB 
        var config = {
            providerUrl: window.CARMEN_URL_SERVER_FRONT + 
               '/services/GetAreasFromDB/index.php',
            providerBaseParams: { 
              tablename : 'prodige_search_param', 
              service:  '0' // fake one for compatibility reason... 
            }
          };
      
        map.addControl(new Carmen.Control.ZoomToPlaceFromDB({config : config}));
      }
    };
  },
  
  buildKeymap : function()
  {
    var me = this;
    var ctx = this.owscontext;
    var map = this.map;
    
    if (this.keymapVisible) {
      var rm_config = ctx.mdataMap.ReferenceMap;
      var rm_imgUrl = rm_config.OnlineResource.attributes.href;
      var rm_size = new OpenLayers.Size(rm_config.attributes.width, rm_config.attributes.height);
      var rm_lc = rm_config.BoundingBox.LowerCorner.split(" ");
      var rm_uc = rm_config.BoundingBox.UpperCorner.split(" ");
      var rm_maxExtent = new OpenLayers.Bounds(rm_lc[0],
                  rm_lc[1], rm_uc[0], rm_uc[1]);
      var rm_projection = ctx.getProjection();
      var rm_projectionUnits = ctx.getProjectionUnits();
      
      var a = document.createElement("img");
      a.onload = function(){
        // Warning a layer used for an overviewmap should not be used as a base layer 
        // for the general map or for another overviewmap control
        var layerReference =  new OpenLayers.Layer.Image(
          "Reference Map",
          rm_imgUrl,
          rm_maxExtent,
          rm_size, 
          {
            projection : rm_projection,
            units : rm_projectionUnits,
            singleTile : true
          });
        var RmOptions = {
          size: new OpenLayers.Size(180,100),
          maximized : true,
          layers : [layerReference],
          minRectSize : 5,
          mapOptions : {
            numZoomLevels: 1,
            maxExtent : rm_maxExtent,
            projection : rm_projection,
            units : rm_projectionUnits
          } 
        };
        var keymap = new Prodige.Keymap(RmOptions);
        map.addControl(keymap);
        me.keymap = keymap;
      }
      a.src = rm_imgUrl;
    } 
  },
  
  buildLegend : function()
  {
    var ctx = this.owscontext;
    var map = this.map;
    
    this.layerTreeManager = new Carmen.Control.LayerTreeManager({ 
      visible: this.legendVisible
    });
    var jsonLayerTree = ctx.mdataMap.LayerTree;
    var jsonLayerList = ctx.layer;
    this.layerTreeManager.buildTree(jsonLayerTree, jsonLayerList);
    this.layerTreeManager.setMap(this.map);
    if ( !this.legendVisible ) this.layerTreeManager.hide();
  },
  
  addCopyrightScale : function(map, baseLayer, ctx)
  {
    // inlays: scale, attributions...
    if (valueFrom(ctx.mdataMap.inlay, "0") == "1") {
      // parameters for map inlays
      var inlayParams = {
        displayTxt      : valueFrom(ctx.mdataMap.scaleTxt, "0") == "1",
        displayImg      : valueFrom(ctx.mdataMap.scaleImg, "0") == "1",
        displayLogo     : valueFrom(ctx.mdataMap.logo, "0") == "1",
        fontSize        : valueFrom(ctx.mdataMap.fontSize, null),
        color           : valueFrom(ctx.mdataMap.fontColor, null),
        backgroundColor : valueFrom(ctx.mdataMap.backgroundColor, null),
        logoPath        : valueFrom(Url.decode(ctx.jsOws.ViewContext.General.LogoURL.OnlineResource.attributes.href), null)
      };
      var a = document.createElement("img");
      a.onerror = function(){
        inlayParams.logoPath = null;
        this.onload();
      };
      a.onload = function(){
        // incrustation
        if (ctx.mdataMap.font)
          OpenLayers.Util.extend(inlayParams, Carmen.Util.carmenFontDescToFontStyles(ctx.mdataMap.font));
        // Setting map attribution to the base layer
        if (valueFrom(ctx.mdataMap.copyright, "0") == "1") {
          baseLayer.attribution = Url.decode(ctx.mdataMap.copyrightTxt);
          map.addControl(new OpenLayers.Control.AttributionCarmen(inlayParams));
        } else if (valueFrom(ctx.mdataMap.logo, "0") == "1") {
          baseLayer.attribution = "";
          map.addControl(new OpenLayers.Control.AttributionCarmen(inlayParams));
        }
        if (inlayParams.displayTxt || inlayParams.displayImg) {
          var options = OpenLayers.Util.extend(inlayParams, {
            serverUrl : window.CARMEN_URL_SERVER_DATA + '/cgi-bin/mapserv',
            mapfile : ctx.mdataMap.mapfile
          });
          map.addControl(new OpenLayers.Control.MapserverScale(options));
        }
      };
      if ( inlayParams.logoPath ){
        a.src = inlayParams.logoPath;
      } else {
        a.onload();
      }
    }
  },
  
  addLayers : function()
  {
    var ctx = this.owscontext;
    var map = this.map;
    // var layerTreeManager = map.getLayerTreeManager();
    var layerTree = this.layerTreeManager.getLayerTree();
    // need a base layer, get one from mapserver with no layers selected...
    var baseLayer = new Carmen.Layer.MapServerGroup(
      "Base Map",
      window.CARMEN_URL_SERVER_DATA + "/cgi-bin/mapserv?map="+ ctx.mdataMap.mapfile, 
      {
        map_imagetype : ctx.mdataMap.outputFormat,
        // map_transparent: ctx.mdataMap.backgroundTransparency=="ON" ? "TRUE"
        // : "FALSE",
        LAYERS : ''
      }, {
        maxExtent : ctx.getMaxExtent(),
        // maxResolution: 'auto',
        projection : ctx.getProjection(),
        units : ctx.getProjectionUnits(), // Used in WMS/WFS requests.
        // transitionEffect: 'resize',
        isBaseLayer : true,
        singleTile : true
      }
    );
    map.addLayer(baseLayer);
    
    // inlays: scale, attributions...
    this.addCopyrightScale(map, baseLayer, ctx)
    
    // classic overlay layer
    // label layer
    var labelLayer = new Carmen.Layer.MapServerGroup(
      "Label layer",
      window.CARMEN_URL_SERVER_DATA + "/cgi-bin/mapserv?map="+ ctx.mdataMap.mapfile, 
      {
        LAYERS : '',
        map_imagetype : 'png',
        map_transparent : true
      }, {
        maxExtent : ctx.getMaxExtent(),
        projection : ctx.getProjection(),
        units : ctx.getProjectionUnits(),
        isBaseLayer : false,
        singleTile : true
      }
    );

    // build and add layers
    var layers = this._buildLayers2(layerTree, ctx, labelLayer);
    for (var i = layers.length - 1; i >= 0; i--) {
      var symbolscaledenom = -1;
      var isProportional = false;
      for (var a = 0; a < ctx.layer.length; a++) {
        if (ctx.layer[a].Title == layers[i].name) {
          if (ctx.layer[a].Extension.TYPE_SYMBO && ctx.layer[a].Extension.TYPE_SYMBO == "PROPORTIONAL") {
            isProportional = true;
            symbolscaledenom = (
              ctx.layer[a].Extension.layerSettings_symbolScaleDenom
              ? ctx.layer[a].Extension.layerSettings_symbolScaleDenom
              : -1
            );
          }
        }
      }
      if (isProportional) {
        layers[i].params["ISPROPORTIONAL"] = isProportional;
        layers[i].params["SYMBOLSCALEDENOM"] = symbolscaledenom;
      }
      if (layers[i].maxExtent == null)
        layers[i].maxExtent = ctx.getMaxExtent();
      // handling resolutions for WMSC layers
      if (layers[i].resolutions != null && map.resolutions != null) {
        // taking default WMS-C resolutions in map and inserting new ones from
        // WMS-C layers
        // or replacing existing which are close to new resolutions by new
        // resolutions
        var newRes = [];
        // if map min/max resolutions defined, filtering layer resolutions
        // before merging them with map resolutions
        if (map_minScaleDenom != null && map_maxScaleDenom != null) {
          for (var k = 0; k < layers[i].resolutions.length; k++) {
            var res = layers[i].resolutions[k];
            var sc = OpenLayers.Util.getScaleFromResolution(res, "m").toFixed();
            if (sc >= map_minScaleDenom && sc <= map_maxScaleDenom) {
              newRes.push(res);
            }
          }
        } else
          newRes = [].concat(layers[i].resolutions);
        for (var j = 0; j < map.resolutions.length; j++) {
          newRes = Carmen.Util.set_add(newRes, map.resolutions[j], Carmen.Util.resNearTester);
        }
        newRes.sort(Carmen.Util.descendingOrder);
        map.resolutions = newRes;

      }
      // layers considered as overlay
      layers[i].setIsBaseLayer(false);

      map.addLayer(layers[i]);
    }
    map.addLayer(labelLayer);
    map.setLabelLayer(labelLayer);
  },
  
  _getProviderUrl : function(providerUrl) {
    //l'url doit terminer par ? ou &
    
    var lastCar = providerUrl[providerUrl.length-1];
    if (lastCar == '?' || lastCar == '&') {
      //--> ok;
      return providerUrl;
    }
    
    if (providerUrl.indexOf("?") == -1) {
      //Il n'y a pas de ?
      providerUrl += "?";
    } else {
      providerUrl += "&";
    }

    return providerUrl;
  },
  
  getLocateByAddress : function(){
    var c_config = "";
    Ext.Ajax.timeout = 120000;
    Ext.Ajax.request({
      url    : '/services/GetByAddress/index.php',
      params : { service : 'getconfig'},
      scope  : this,
      success: function(response){
        var c_res = eval("("+response.responseText+")");
        c_config = c_res["prodige_settings_value"];
        if(c_config != ""){
          this.map.addControl(new Carmen.Control.LocateByAddress({"locateaddress" : c_config}));
          return true;
        }else
          return false;
      },
      failure: function(response){
      return false;
      }
    });
  },
  
/*********************************************************************************************
 * Building Layers....
 *********************************************************************************************/   
  NODE_LAYER : 0,
  NODE_GROUP : 1,
  
  _buildLayers2 : function(layerTree, ctx, labelLayer) {

    var layers = new Array();
    var providerGrp = {};
    this._getProvider2layers(layerTree, providerGrp);
    
    for(var i in providerGrp) {
      var layerNames = '';
      if (providerGrp[i] instanceof Array) {
        for (var j=0; j< providerGrp[i].length; j++) {
         var nodes =  providerGrp[i];
         layerNames = layerNames + '+' + providerGrp[i][j].attributes.jsonLayerDesc.attributes.name;
        }
        var layer = this._buildLayer2(providerGrp[i], i, ctx, labelLayer);
        if (layer!=null)
          layers[layers.length] = layer;
      }
    }
    return layers;
  },

  /*
   * @brief descend the tree to fill the provider2layers array so that 
   * provider2layers[providerGrpId]=[list of layers node...]
   */
  _getProvider2layers : function(node, provider2layers) {
    if (node.attributes.type == this.NODE_LAYER) {
      var providerId = node.attributes.providerId;
      if (!(provider2layers[providerId] instanceof Array)) {
        provider2layers[providerId] = new Array();
      }
      provider2layers[providerId].push(node);
      //console.log('/*adding layer ' + node.attributes.jsonLayerDesc.Title + ' to group ' + providerId);
    }
    else if (node.attributes.type == this.NODE_GROUP) {
      //obedel migration
      for (var i=0; i<node.childNodes.length; i++) {
        this._getProvider2layers(node.childNodes[i], provider2layers);
      }
    }
  },  
  
  _buildMapserverLayer2 : function(layerNodes, providerUrl, ctx, labelLayer) {
    var msParams = {
        LAYERS : '',
        map_imagetype : ctx.mdataMap.outputFormat,
        map_transparent: 'TRUE'
    };    
    var layerNames = "";
    var handleSelection = false;
    for (var i =0; i<layerNodes.length; i++) {
      var node = layerNodes[i];
      var lname = node.attributes.jsonLayerDesc.attributes.name;
      layerNames = layerNames + '+' + lname;
     
      handleSelection = handleSelection ||
        (layerNodes[i].attributes.jsonLayerDesc.Extension.layerSettings_infoFields!='')
    }
    layerNames = layerNames.slice(1);
    
    // little hack to retrieve mapfile from wfs...
    var mapfile = node.attributes.jsonLayerDesc.Extension.layerSettings_mapfile;
    mapfile = mapfile!=null ? mapfile : window.mapfile;
    var layer = new Carmen.Layer.MapServerGroup(
          layerNames,  
          providerUrl,
          msParams,  
          {
            projection: ctx.getProjection(), 
            units: ctx.getProjectionUnits(), 
            singleTile: true, 
            mapfile: mapfile,
            selectionSupport: handleSelection  
          });
    layer.setVisibility(false);
    for (var i =0; i<layerNodes.length; i++) {
      var desc = layerNodes[i].attributes.jsonLayerDesc;
      var lname = desc.attributes.name;
      var lvis =  !(desc.attributes.hidden == "1");
      layer.addSubLayer(lname, lvis);
      var hasLabel = desc.Extension.hasLabel=="1";
      layerNodes[i].attributes.hasLabel = hasLabel;

      if (hasLabel) {
        layer.params['map.layer[' + lname + ']'] = "LABELREQUIRES '0'";
        // then, add a copy of this layer in the composite label layer,
        // and switch off its symbols
        labelLayer.addSubLayer(lname, lvis);
        labelLayer.params['map.layer[' + lname + ']'] = "OPACITY 1 LABELREQUIRES '1'";
      }
    }
    return layer;         
  },
  
  _buildWMSLayer2 : function (layerNodes, providerUrl, ctx) {
    var layerNames = "";
    for (var i =0; i<layerNodes.length; i++) {
      var name = layerNodes[i].attributes.jsonLayerDesc.Title;
      layerNames = layerNames + ',' + name;
    }
    
    layerNames = layerNames.slice(1);
    firstLayerDesc = layerNodes[0].attributes.jsonLayerDesc;
    var version =  Url.decode(firstLayerDesc.Server.attributes.version);
    var outputFormat = Url.decode(firstLayerDesc.Extension.wms_format);
    var projection = valueFrom(Url.decode(firstLayerDesc.Extension.wms_srs), ctx.getProjection(), false);
    var projUnits = Carmen.Util.getProjectionUnits(projection);
    var opacity = layerNodes[0].attributes.opacity;
    
    var layer = new Carmen.Layer.WMSGroup(
      layerNames,  
      providerUrl,
      {
        LAYERS : '',
        version: version,
        format : outputFormat,
        transparent: true
      }, 
      {
        isBaseLayer : false,
        singleTile : true,
        projection : projection, 
        units : projUnits,
        opacity: opacity
      }
    );

    //console.log("version " + version + " outputFormat " + outputFormat + " projection " + projection + " providerURL " + providerUrl);

    layer.setVisibility(false);
    for (var i =0; i<layerNodes.length; i++) {
      var lname = layerNodes[i].attributes.jsonLayerDesc.attributes.name;
      var lwmsName = layerNodes[i].attributes.jsonLayerDesc.Name
      var lvis =  !(layerNodes[i].attributes.jsonLayerDesc.attributes.hidden == "1");
      layer.addSubLayer(lname, lvis, lwmsName);
      //var domIconEl = layerNodes[i].getUI().getIconEl();
      //domIconEl.src = layer.getLegendGraphicURL(lwmsName);
      //console.log("name " + lname + " lwmsname " + lwmsName );
    }
    return layer;
  },
  
  _buildWMSCLayer2 : function (layerNodes, providerUrl, ctx) {
    var layerNames = "";
    for (var i =0; i<layerNodes.length; i++) {
      var name = layerNodes[i].attributes.jsonLayerDesc.Title;
      layerNames = layerNames + ',' + name;
    } 
    layerNames = layerNames.slice(1);
    firstLayerDesc = layerNodes[0].attributes.jsonLayerDesc;
    var version =  Url.decode(firstLayerDesc.Server.attributes.version);
    var outputFormat = Url.decode(firstLayerDesc.Extension.wms_format);
    var projection = valueFrom(Url.decode(firstLayerDesc.Extension.wms_srs), ctx.getProjection(), false);
    var projUnits = Carmen.Util.getProjectionUnits(projection);
    var opacity = layerNodes[0].attributes.opacity;
    
    layerOptions = {
      isBaseLayer : false,
      buffer : 0,
      tileSize : new OpenLayers.Size(256,256),
      projection : projection,
      resolutions : null,
      units : projUnits,
      opacity : opacity };
   
    // getting wmsc boundingbox if defined
    var str_boundingbox = valueFrom(firstLayerDesc.Extension.wmsc_boundingbox, null, false);
    
    layerOptions.maxExtent = ctx.getMaxExtent();
    if (str_boundingbox) {
      var sep = str_boundingbox.indexOf(',') != -1 ? ',' : ' ';
      var bb = Carmen.Util.chompAndSplit(Url.decode(str_boundingbox), sep);
      layerOptions.maxExtent = new OpenLayers.Bounds(bb[0], bb[1], bb[2], bb[3]);
    }
    // getting wmsc resolution if defined
    var str_res = valueFrom(firstLayerDesc.Extension.wmsc_resolution, null, false);
    if (str_res!=null) {
      str_res = Url.decode(str_res);
      var sep = str_res.indexOf(',') != -1 ? ',' : ' ';
      var res = Carmen.Util.chompAndSplit(str_res, sep);
      // kind of defensive prog to prevent wrong format...
      if (!isNaN(new Number(res[0]))) {
        layerOptions.resolutions = Carmen.Util.array_map(res, parseFloat);
      }
    }
          //this.context.mapExtent = layerOptions.maxExtent;
    var layer = new Carmen.Layer.WMSGroup(
          layerNames,  
          providerUrl,
          {
            LAYERS : '',
            version: version,
            format : outputFormat 
          }, 
          layerOptions);
    layer.setVisibility(false);
    for (var i =0; i<layerNodes.length; i++) {
      var lname = layerNodes[i].attributes.jsonLayerDesc.attributes.name;
      var lwmsName = layerNodes[i].attributes.jsonLayerDesc.Name;
      var lvis =  !(layerNodes[i].attributes.jsonLayerDesc.attributes.hidden == "1");
      layer.addSubLayer(lname, lvis, lwmsName);
      // updating wms icon
      //var domIconEl = layerNodes[i].getUI().getIconEl();
      //domIconEl.src = layer.getLegendGraphicURL(lwmsName);
    }

          //console.log(layer);
    return layer;
  },

  _buildWMTSLayer2 : function (layerNodes, providerUrl, ctx) {
      var layerNames = "";
      for (var i =0; i<layerNodes.length; i++) {
        var name = layerNodes[i].attributes.jsonLayerDesc.Title;
        layerNames = layerNames + ',' + name;
      } 
      layerNames = layerNames.slice(1);
      firstLayerDesc = layerNodes[0].attributes.jsonLayerDesc;
      //var version =  firstLayerDesc.Server.attributes.version;
      var outputFormat = firstLayerDesc.Extension.wms_format;
      var style = firstLayerDesc.Extension.wmts_style;
      var tileset = firstLayerDesc.Extension.wmts_tileset;
      var wmts_layer_name = firstLayerDesc.Extension.wmts_wms_layer;
      // resolution
      var serverResolution = null;
      var str_res = Url.decode(firstLayerDesc.Extension.wmts_resolutions);
      var res = Carmen.Util.chompAndSplit(str_res, ' ');
      if (!isNaN(new Number(res[0]))) {
        serverResolution = Carmen.Util.array_map(res, parseFloat);
      }
      // matrixIds
      var matrixIds = [];
      var str_matrixids = Url.decode(firstLayerDesc.Extension.wmts_matrixids);
      var ids_matrix = Carmen.Util.chompAndSplit(str_matrixids, ' ');
      var tileOrigins = [];
      var str_tileOrigins = Url.decode(firstLayerDesc.Extension.wmts_tileorigin);                  
      var tileorigins_coords = Carmen.Util.chompAndSplit(str_tileOrigins, ' ');
      for (var i=0; i<ids_matrix.length; i++) {
          
          var coords = Carmen.Util.chompAndSplit(tileorigins_coords[i], ',');
          var tlc = new OpenLayers.LonLat(
            parseFloat(coords[0]),
            parseFloat(coords[1]));

          matrixIds.push({
            identifier : ids_matrix[i],
            topLeftCorner : tlc });

      }
      // tileOrigin
      var str_tileorigin =  Url.decode(firstLayerDesc.Extension.wmts_tileorigin);
      var tileorigin_coords2 = Carmen.Util.chompAndSplit(str_tileorigin, ' ');
      var tileorigin_coords = [];
      for(var i=0; i<tileorigin_coords2.length;i++){   
        tab=Carmen.Util.chompAndSplit(tileorigin_coords2[i].toString(),',')
        tileorigin_coords.push(tab[0],tab[1]);
      }
      var tileorigin = new OpenLayers.LonLat(
        parseFloat(tileorigin_coords[0]),
        parseFloat(tileorigin_coords[1]));
      var opacity = layerNodes[0].attributes.opacity;
      
      var layer = new Carmen.Layer.WMTSGroup({
        name: wmts_layer_name,
        url: providerUrl,
        layer: wmts_layer_name,
        matrixSet: tileset,
        matrixIds : matrixIds,
        format:"image/png",
        style: style,
        opacity: opacity,
        isBaseLayer: false,
        //singleTile: false,
        serverResolutions : serverResolution,
        resolutions : serverResolution,
        visibility: false                  
      });
      //layer.setVisibility(false);
      //layer.setVisibility(false);
        
        for (var i =0; i<layerNodes.length; i++) {
          var lname = layerNodes[i].attributes.jsonLayerDesc.attributes.name;
          var lwmtsName = layerNodes[i].attributes.jsonLayerDesc.Extension.wmts_wms_layer;
          var lvis =  !(layerNodes[i].attributes.jsonLayerDesc.attributes.hidden == "1");
          layer.addSubLayer(lname, lvis, lwmtsName);
          // updating wms icon
          //var domIconEl = layerNodes[i].getUI().getIconEl();
          //domIconEl.src = layer.getLegendGraphicURL(lwmsName);
        }


      return layer;
    },

  _buildVectorLayer2 : function(node, ctx) {
    var desc = node.attributes.jsonLayerDesc;
    var layer = new Carmen.Layer.Vector(desc.Title, 
      { context_kml : desc.Document, 
        context_style : desc.Extension.layerSettings_olStyle,
        useStyleMap : true });
    layer.setVisibility(true);
    return layer;         
  },

  _buildLayer2 : function(layerNodes, providerGrpId, ctx, labelLayer) {
    var layer = null;
    var providerUrl = null;
    if (!layerNodes)
      return;
  
    var firstLayerDesc = layerNodes[0].attributes.jsonLayerDesc;
    if ('Server' in firstLayerDesc) {
      
    //TODO élément de différenciation à améliorer
      if (!('wms_layer' in firstLayerDesc.Extension)) {
        // Mapserver-CGI layer ? 
        providerUrl = firstLayerDesc.Server.OnlineResource.attributes.href;
        // @Todo: add better mapserver detection 
        var isMapserverLayer = (providerUrl.search(/mapserv/i)>0);
        if (isMapserverLayer) {
          layer = this._buildMapserverLayer2(layerNodes, providerUrl, ctx, labelLayer);
        }
      }
      else if ('Server' in firstLayerDesc) {
        // WMS layer ?
        var service = firstLayerDesc.Server.attributes.service;

        var providerUrl = firstLayerDesc.Server.OnlineResource.attributes.href;
        var isWMS = (service.search(/WMS/i)>-1);
        if (isWMS) {
          layer = this._buildWMSLayer2(layerNodes, providerUrl, ctx);
        }
        var isWMSC = valueFrom(firstLayerDesc.Extension.layerSettings_isWmsc,"OFF")=="YES";
        if (isWMSC) {
          layer = this._buildWMSCLayer2(layerNodes, providerUrl, ctx);
        }
        var isWMTS = valueFrom(firstLayerDesc.Extension.layerSettings_isWmts,"OFF")=="YES";
        if (isWMTS) {
            layer = this._buildWMTSLayer2(layerNodes, providerUrl, ctx);
          }
      }
      
      if (layer != null) {
        // linking nodes with OpenLayers layer 
        for (var i=0; i< layerNodes.length; i++) {
          var node = layerNodes[i];
          var layerDesc = layerNodes[i].attributes.jsonLayerDesc;
          node.attributes.OlLayer = layer;
          node.attributes.labelLayer = labelLayer;
          // linking check control to layer display
        }
      }
    }
    else if ('Document' in firstLayerDesc) {
      node = layerNodes[0];
      layer = this._buildVectorLayer2(node, ctx);
      if (layer != null) {
        // linking nodes with OpenLayers layer 
        node.attributes.OlLayer = layer;
        // linking check control to layer display
      }
    } 
    return layer;
  }  
  


});