Prodige.Tree = Prodige.Tree || {};
Prodige.Tree.Node = OpenLayers.Class({
  text : "",
  renderer : null,
  parent : null,
  childNodes : [],
  attributes : {},
  isRoot : true,
  isLeaf : true,
  isDrawn : false,
  expanded : false,
  initialize : function(definition, attributes, parent, childNodes){
    if ( typeof definition == "string" ){
      definition = {id : definition};
    }
    OpenLayers.Util.extend(this, definition || {});
    this.data = this.data || definition || {};
    this.id = this.id || OpenLayers.Util.createUniqueID('Prodige_Tree_Node_');
    this.setAttributes(attributes);
    this.setParent(parent);
    this.addChildren(childNodes||[]);
  },
  createNode : function(definition){
    if ( typeof definition == "string" ){
      definition = {id : definition};
    }
    definition = definition || {};
    var node = new Prodige.Tree.Node(definition);
    this.addChildren(node);
    return node;
  },
  _isRoot : function(){
    this.isRoot = !(typeof this.parent != "undefined" && this.parent!==null);
  },
  _isLeaf : function(){
    this.isLeaf = this.childNodes.length==0;
  },
  isExpanded : function(){
    return this.expanded;
  },
  moveUp : function(){
    if ( this.parent ){
      var index = this.parent.childNodes.indexOf(this);
      if ( index!=-1 ){
        var tmp = [];
        for (var i=0; i<this.parent.childNodes.length; i++){
          if ( i==index-1 ){
            tmp.push(this);
            tmp.push(this.parent.childNodes[i]);
            i++;
          }
          else {
            tmp.push(this.parent.childNodes[i]);
          }
        }
        this.parent.childNodes = tmp;
      }
    }
  },
  moveDown : function(){
    if ( this.parent ){
      var index = this.parent.childNodes.indexOf(this);
      if ( index!=-1 ){
        var tmp = [];
        for (var i=0; i<this.parent.childNodes.length; i++){
          if ( i==index && index+1<this.parent.childNodes.length){
            tmp.push(this.parent.childNodes[i+1]);
            tmp.push(this);
            i++;
          }
          else {
            tmp.push(this.parent.childNodes[i]);
          }
        }
        this.parent.childNodes = tmp;
      }
    }
  },
  resetChildren : function(){
    this.childNodes = [];
    for(var i=0; i<this.childNodes.length; i++){
      childNodes[i].setParent(null);
    }
  },
  appendChild : function(childNodes){
    this.addChildren(childNodes);
  },
  addChildren : function(childNodes){
    if ( arguments.length>1 ){
      childNodes = Array.prototype.slice.apply(arguments);
    }
    this.childNodes = this.childNodes.concat((childNodes instanceof Array ? childNodes : [childNodes]));
    for(var i=0; i<this.childNodes.length; i++){
      this.childNodes[i].setParent(this);
    }
    this._isLeaf();
  },
  removeChildren : function(){
    if ( arguments.length>1 ){
      childNodes = Array.prototype.splice.apply(arguments);
    }
    if ( !(childNodes instanceof Array) ){
      childNodes = [childNodes];
    }
    for(var i=0; i<childNodes.length; i++){
      var index = this.childNodes.indexOf(childNodes[i]);
      childNodes[i].setParent(null);
      if ( index!=-1 ){
        if ( index==0 ){
          this.childNodes = this.childNodes.slice(1);
        }
        else if ( index==this.childNodes.length-1 ){
          this.childNodes = this.childNodes.slice(0, this.childNodes.length-1);
        }
        else {
          this.childNodes = this.childNodes.slice(0, index).concat(this.childNodes.slice(index+1))
        }
      }
    }
    this._isLeaf();
  },
  setParent : function(parent){
    if ( parent && parent.childNodes.indexOf(this)==-1 ){
      parent.addChildren(this);
      return;
    }
    this.parent = parent;
    this._isRoot();
    this.redraw();
  },
  setRenderer : function(renderer){
    this.renderer = renderer;
    for(var i=0; i<this.childNodes.length; i++){
      this.childNodes[i].setRenderer(renderer);
    }
  },
  registerEvents : function(){
    if (!this.isDrawn) return;
    if (!this.renderer) return;
    if ( typeof this.renderer.registerEvents !="undefined" ){
      this.renderer.registerEvents()
    }
  },
  draw : function(container){
    if (this.isDrawn) {
      this.redraw(container);
      return;
    }
    if (!this.renderer) return;
    var string = this.renderer.draw(this);
    this.isDrawn = true;
    if ( container ){
      if ( typeof container.write == "function" ){
        container.write(string);
      } else if ( typeof container.innerHTML != "undefined" ){
        container.innerHTML = string;
      } else {
        return string;
      }
      return;
    }
    return string;
  },
  redraw : function(){
    if (!this.isDrawn) {
      this.draw();
      return;
    }
    if (!this.renderer) return;
    var string = this.renderer.redraw(this);
    for(var i=0; i<this.childNodes.length; i++){
      this.childNodes[i].redraw();
    }
    return string;
  },
  each : function(fn, arguments, bSelf){
    if ( bSelf ) fn.apply(this, [this].concat(arguments || []));
    for(var i=0; i<this.childNodes.length; i++){
      fn.apply(this.childNodes[i], [this.childNodes[i]].concat(arguments || []));
    }
  },
  recurse : function(fn, arguments, bSelf){
    if ( bSelf ) fn.apply(this, arguments || []);
    for(var i=0; i<this.childNodes.length; i++){
      this.childNodes[i].recurse(fn, arguments, true);
    }
  },
  
  toString : function(depth){
    depth = depth || 0;
    var string = "";
    for (var i=0; i<depth;i++) string += "  ";
    string += "> ";
    string += this.id+'(isRoot='+this.isRoot+', isLeaf='+this.isLeaf+', nb_children='+this.childNodes.length+', text='+this.text+')';
    for(var i=0; i<this.childNodes.length; i++){
      string += "\n"+this.childNodes[i].toString(depth+1);
    }
    return string;
  },
  
  setAttributes : function(attributes){
    this.attributes = attributes;
  },
  
  addAttributes : function(name, value){
    if ( typeof name=="object" && arguments.length==1 ){
      OpenLayers.Util.extend(this.attributes, name);
      return;
    }
    this.attributes[name] = value;
  },
  
  getAttributes : function(){
    return OpenLayers.Util.extend({
      id : this.id
    }, this.attributes);
  }
});

Prodige.Tree.Store = OpenLayers.Class(Prodige.Tree.Node, {
  root : null,
  getRoot : function(){
    if ( !this.root ){
      this.root = this;
    }
    return this.root;
  },
  setRoot : function(root){
    this.root = root;
    if ( this.root ){
      this.root.isRoot = true;
      this.root.setRenderer(this.renderer);
    }
    return this;
  },
  draw : function(container){
    if (this.isDrawn) {
      this.redraw();
      return;
    }
    if (!this.renderer) return;
    if ( this.getRoot() !== this ){
      this.isDrawn = true;
      return this.root.draw(container);
    } else {
      return Prodige.Tree.Node.prototype.draw.call(this, container);
    }
  },
  registerEvents : function(){
    if ( this.getRoot() !== this ){
      this.root.registerEvents();
    } else {
      return Prodige.Tree.Node.prototype.registerEvents.call(this);
    }
  }
})


Prodige.Tree.Renderer = OpenLayers.Class({
  BLANK_IMAGE_URL: 'data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==',
  
  CLASS_NAME : "Prodige.Tree.Renderer",
  baseCls : "prodigetreenode",
  initialize : function(baseCls) {
    this.baseCls = baseCls || this.baseCls;
  },
  
  apply : function(html, values)
  {
    var oldHtml = html;
    do {
      oldHtml = html;
      html = html.replace(/\{(\w+)\}/g, function(fullmatch, match){return (typeof values[match]!="undefined" ? values[match] : "{"+match+"}");});
    }while (html!=oldHtml);
    return html;
  },
  
  extendIf : function(destination, source){
    destination = destination || {};
    source = source || {};
    for(var prop in source){
      if ( typeof destination[prop]=="undefined" ){
        destination[prop] = source[prop];
      }
    }
    return destination;
  },
  getTplValues : function(node){
    var values = {};
    values = this.extendIf(values, {baseCls : this.baseCls, blankUrl : this.BLANK_IMAGE_URL});
    values = this.extendIf(values, {expandCls : (node.expanded ? "expanded" : "collapsed")});
    values = this.extendIf(values, {cls : (node.isRoot ? "root" : (node.isLeaf ? "leaf" : "node"))});
    values = this.extendIf(values, node);
    values = this.extendIf(values, node.getAttributes());
    return values;
  },
  
  applyTpl : function(tpl, node){
    return this.apply(this[tpl] || "", this.getTplValues(node));
  },
  
  redraw : function(node){
    return this.draw(node);
  },
  
  draw : function(node){
    var html = [];
    if ( node.isRoot ){
      html.push(this.applyTpl("rootTplStart", node));
    }
    
    html.push(this.applyTpl("nodeTpl", node));
    
    if ( node.childNodes.length ){
      html.push(this.applyTpl("childTplStart", node));
      for(var i=0; i<node.childNodes.length; i++){
        html.push(node.childNodes[i].draw());
      }
      html.push(this.applyTpl("childTplEnd", node));
    }
    
    if ( node.isRoot ){
      html.push(this.applyTpl("rootTplEnd", node));
    }
    return html.join("");
  },
  
  registerEvents : function(){
    var roots = document.getElementsByClassName(this.baseCls+'-root');
    for (var rootIndex=0; rootIndex<roots.length; rootIndex++){
      var root = roots[rootIndex];
      var childNodes = root.getElementsByClassName(this.baseCls);
      for (var childIndex=0; childIndex<childNodes.length; childIndex++){
        var child = childNodes[childIndex];
        child.onclick = function(){
          var nodes = this.parentNode.getElementsByClassName('childNodes-'+this.id+'');
          if ( nodes.length ){
            var isExpanded = this.className.indexOf("expanded")!=-1;
            OpenLayers.Element.removeClass(this, "expanded");
            OpenLayers.Element.removeClass(this, "collapsed");
            if (isExpanded){
              OpenLayers.Element.addClass(this, "collapsed");
            } else {
              OpenLayers.Element.addClass(this, "expanded");
            }
            for(var nodeIndex=0; nodeIndex<nodes.length; nodeIndex++){
              var node = nodes[nodeIndex];
              OpenLayers.Element.removeClass(node, "expanded");
              OpenLayers.Element.removeClass(node, "collapsed");
              if (isExpanded){
                OpenLayers.Element.addClass(node, "collapsed");
              }else {
                OpenLayers.Element.addClass(node, "expanded");
              }
            }
          }
        }
      }
    }
  }
});
Prodige.Tree.Renderer.ALIASES = {
  "Prodige.Tree.DefaultRenderer"  : "Prodige.Tree.DefaultRenderer",
  "DefaultRenderer"  : "Prodige.Tree.DefaultRenderer",
  "default"          : "Prodige.Tree.DefaultRenderer",
  
  "Prodige.Tree.AdvancedRenderer"  : "Prodige.Tree.AdvancedRenderer",
  "AdvancedRenderer" : "Prodige.Tree.AdvancedRenderer",
  "advanced"         : "Prodige.Tree.AdvancedRenderer"
};

Prodige.Tree.DefaultRenderer = OpenLayers.Class(Prodige.Tree.Renderer, {
  CLASS_NAME : "Prodige.Tree.DefaultRenderer",
  
  rootTplStart  : '<ul class="{baseCls}-root expanded">',
  rootTplEnd    : '</ul>',
  childTplStart : '<ul class="{baseCls}-childNodes {expandCls} childNodes-{id}">',
  childTplEnd   : '</ul>',
  nodeTpl       : '<li class="{baseCls} {cls} {expandCls}" id="{id}">{text}</li>'
});


Prodige.Tree.AdvancedRenderer = OpenLayers.Class(Prodige.Tree.DefaultRenderer, {
  CLASS_NAME : "Prodige.Tree.AdvancedRenderer",
  
  rootTplStart  : '<ul class="{baseCls}-root expanded">',
  rootTplEnd    : '</ul>',
  childTplStart : '<ul class="{baseCls}-childNodes {expandCls} childNodes-{id}">',
  childTplEnd   : '</ul>',
  nodeTpl       : '<li class="{baseCls} {cls} {expandCls}" id="{id}">' +
      '<i class="fa fa-angle-right"></i>' +
      '<i class="fa fa-angle-down"></i>' +
      '{iconText}' +
      '{legendLayer}</li>',
  
  getTplValues : function(node){
    var values = Prodige.Tree.DefaultRenderer.prototype.getTplValues.call(this, node);
    var attributes = node.getAttributes();
    var complement = {};
    var iconText = "{text}";
    var legendLayer = [];
    if ( attributes.classLegend ){
      for (var i=0; i<attributes.classLegend.length; i++){
        legendLayer.push([
            '<span class="{baseCls} layerlegenditem multiple" ',
            'style="'+"background-image:url("+attributes.classLegend[i].icon+");" + (attributes.iconStyle || "")+'">',
            attributes.classLegend[i].text,
            '</span>'
          ].join('')
        );
      }
    } else if ( node.icon ){
      var time = new Date().getTime();
      iconText = [
        '<span class="{baseCls} layerlegenditem"',// <img id="_'+time+'"src="{blankUrl}" role="presentation" class="{iconCls}"',
        'style="'+"background-image:url("+node.icon+");" + (attributes.iconStyle || "")+'">',  
        '{text}',
        '</span>'
      ].join('');
      
      var a = document.createElement("img");
      a.onerror = function(){
        var elt = document.getElementById("_"+time);
        if ( elt ){
          elt.style.display = "none";
        } else {
          setTimeout(this.onerror, 200);
        }
        iconText = "{text}";
      }
      a.sync = true;
      a.src = node.icon;
    }
    
    if ( legendLayer.length ){
      legendLayer = [""].concat(legendLayer);
    }
    values = this.extendIf(values, {iconText : iconText, legendLayer : legendLayer.join('<br/>')});
    return values;
  },
  
  nodeTpl2 : [
    '<div class="row0" style="width:300px;">',
    '<div class="row0_first" style="width:{[20+(values.record.getDepth()*20)+20]}px;" >',
    '<tpl for="lines">',
        '<img src="{parent.blankUrl}" class="{parent.childCls} {parent.elbowCls}-img ',
        '{parent.elbowCls}-<tpl if=".">line<tpl else>empty</tpl>" role="presentation"/>',
    '</tpl>',
    '<img src="{blankUrl}" class="{childCls} {elbowCls}-img {elbowCls}',
        '<tpl if="isLast">-end</tpl>',
        '<tpl if="expandable">-plus {expanderCls}</tpl>',
        '" role="presentation"/>',
    '<tpl if="checked !== null">',
    '<input type="button" {ariaCellCheckboxAttr}',
        ' class="{childCls} {checkboxCls}<tpl if="checked"> {checkboxCls}-checked</tpl>"/>',
    '</tpl>',
    '</div>',
    '<div class="row0_second">',


    '<tpl if="href">',
        '<a href="{href}" role="link" target="{hrefTarget}" class="{textCls} {childCls}">{value}</a>',
    '<tpl else>',
        '<span class="{textCls} {childCls} layerTreeNode">{value}',
        '</span>',

        '<tpl if="values.record.attributes.classLegend">', 
            '<tpl for="values.record.attributes.classLegend">',
              '<br/>',
              '<img src="{parent.blankUrl}" role="presentation" class=" x-tree-elbow-img x-tree-elbow-empty"',
              'style="" ></img>',
              '<img src="{parent.blankUrl}" role="presentation" class=" x-tree-icon x-tree-icon-leaf cmnLayerTreeLayerNodeIcon"',
              'style="background-image:url({icon})" ></img>',
              '<span class="x-tree-node-text" >{text}</span>',
            '</tpl>',  
        '<tpl elseif="values.record.attributes.iconDisplayStrategy"/>',
            '<img id="legendNode-{record.internalId}_iconDisplay" src="<tpl if="icon">{icon}<tpl else>{blankUrl}</tpl>" role="presentation" class="{iconCls}"/>',
        '</tpl>',
     '</tpl>', 
    '<tpl if="record.attributes.forceOpacityControl">',
    '</tpl>',
    '</div>',
    '</div>'
  ].join('')
  
});
