<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

define("ALK_BUTTONTYPE_SUBMIT", "submit");
define("ALK_BUTTONTYPE_RESET",  "reset");
define("ALK_BUTTONTYPE_BUTTON", "button");
define("ALK_BUTTONTYPE_LINK",   "link");

define("ALK_BUTTONSTYLE_IMG",  "img");
define("ALK_BUTTONSTYLE_LINK", "link");

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");

/**
 * @package Alkanet_Class_form
 * 
 * @class AlkHtmlButon
 * @brief Classe de base d'affichage d'un lien texte ou image
 */
class AlkHtmlButton extends AlkHtmlCtrl
{

  /** texte info bulle, par défaut = $strTxt */
  protected $toolTip;

  /** fenetre cible */
  protected $target;

  /** boolean : indique s'il s'agit d'un lien texte ou d'un bouton */
  protected $bInline;

  /** numéro identifiant le bouton graphique */
  protected static $iNumImg = 0;

  /** nom du base du bouton graphique */
  protected $strImgBaseName;
  
  /** label utilisé par les blocks */
  protected $blockLabel;
  
  /** titre de l'image */
  protected $alt;
  
  /** Définit le type de bouton : submit ou reset */
  protected $buttonType = null;

  /** Définit le stype de bouton : page, form, icon, img ou link */
  protected $buttonStyle = null;
  
  /** Définit le raccourci clavier */
  protected $accessKey;
  
  /** Mémorise si l'événement onclick a été ajouté au HTML */
  protected $bAddEvent;
  

  /**
   *  Constructeur par défaut
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        Texte contenu du bouton ou du lien
   * @param strToolTip    Texte info bulle
   * @param bInline       vari pour affiche le bouton en inline, false en block
   * @param strTarget     fenêtre cible du lien, =vide par défaut
   * @param name          Identifiant HTML du boutton
   */
  public function __construct($strLink, $strTxt, $strToolTip, $bInline=false, $strTarget="", $name= "")
  {
    parent::__construct(null, 0, "", $strLink, $strTxt);
    
    //$strLink -> $this->value
    //$strTxt  -> $this->label
    
    $this->toolTip  = $strToolTip;
    $this->alt  = "";
    $this->buttonType = ALK_BUTTONTYPE_LINK;
    $this->buttonStyle = ALK_BUTTONSTYLE_LINK;
    $this->cssLink = "text";
    $this->target  = $strTarget;
    $this->bInline = $bInline;
    $this->strImgBaseName = "";
    $this->blockLabel = "";
    $this->accessKey = "";
    $this->iWidth = 0;
    $this->iHeight = 0;
    $this->setDefaultCss("alkhtmlbutton.css");
    $this->bAddEvent = false;
  }

/**
 * Définit le type de bouton
 */
 public function setButtonType($buttonType)
  {
    $buttonTypes = array(ALK_BUTTONTYPE_SUBMIT, ALK_BUTTONTYPE_RESET, ALK_BUTTONTYPE_BUTTON, ALK_BUTTONTYPE_LINK);
    if ( !in_array($buttonType, $buttonTypes) ){
      $this->triggerError(__CLASS__."::".__FUNCTION__."[".__LINE__."] : Type de bouton inconnu : ".$buttonType.". Veuillez choisir parmi ".implode(", ", $buttonTypes), E_USER_ERROR);
    }
    $this->buttonType = $buttonType;
  }
  /**
   *  Génère puis retourne le code html associé au controle de saisie
   */
  protected function getCtrlHtml($key=0, $tabLg=array())
  {
    return $this->getHtml();
  }

  /**
   * Transforme puis retourne le texte d'un bouton en un nom d'image ou d'une classe de style
   * Transforme les caractètes accentués et supprime les espaces
   * @param strTitle  Titre du lien ou bouton
   * @return string
   */
  protected function getClassName($strTitle)
  {
    $strTitle = str_replace(" ", "", $strTitle);
    $strTitle = str_replace("_", "", $strTitle);
    return strtolower(strtr($strTitle, "éèêëäàâüùûiîïôöç", "eeeeaaauuuiiiooc"));
  }

  /**
   *  Retourne le nom de l'image rol
   * @return string
   */
  protected function getImgRol()
  {
    if( $this->strImgBaseName == "" ) {
      return "";
    }

    $strImg = $this->strImgBaseName;
    $iPos = mb_strrpos($strImg, ".");
    if( $iPos === false ) {
      return $strImg.'_rol';
    }

    return mb_substr($strImg, 0, $iPos).'_rol'.mb_substr($strImg, $iPos);
  }
  
  /**
   *  Retourne le nom de base de l'image (sans extension)
   * @return string
   */
  protected function getImgBase()
  {
    if( $this->strImgBaseName == "" ) {
      return "";
    }

    $strImg = $this->strImgBaseName;
    $iPos = mb_strrpos($strImg, ".");
    if( $iPos === false ) {
      return $strImg;
    }

    return mb_strtolower(mb_substr($strImg, 0, $iPos));
  }
  
  /**
   * Génère puis retourne le code html associé au controle de saisie
   * - Type de sortie :
   *   - <a>text</a>           : ALK_BUTTONTYPE_LINK & ALK_BUTTONSTYLE_LINK
   *   - <a><img></a>          : ALK_BUTTONTYPE_LINK & ALK_BUTTONSTYLE_IMG
   *   - <button>text</button> : [ALK_BUTTONTYPE_SUBMIT|ALK_BUTTONTYPE_RESET|ALK_BUTTONTYPE_BUTTON] & ALK_BUTTONSTYLE_LINK 
   *   - <button><img></button>: [ALK_BUTTONTYPE_SUBMIT|ALK_BUTTONTYPE_RESET|ALK_BUTTONTYPE_BUTTON] & ALK_BUTTONSTYLE_IMG
   * 
   * - si url en http ou mailto ou target !="", utilisation de href
   * - sinon utilisation de onclick="" avec href="javascript:void(1)"
   * 
   * 
   */
  public function getHtml()
  {
    $this->addDefaultCss();

    $strHtmlInner = "";
    $bUseCss = false;
    $strFirstCss = "";
    $strOtherCss = "";
    if( $this->cssLink != "" ) {
      $tabCss = explode(" ", $this->cssLink, 2);
      $strFirstCss = $tabCss[0];
      $strOtherCss = ( count($tabCss) > 1 ? $tabCss[1] : "" );
    }
    
    switch( $this->buttonStyle ) {
    case ALK_BUTTONSTYLE_IMG:
      $strUrlImg = ALK_MEDIA_URL.'images/transp.gif';
      if( $this->strImgBaseName != "" ) {
        $strUrlImg = $this->strImgBaseName;
        if( substr($strUrlImg, 0, 7) != "http://" ) {      
          $strUrlImg = $this->urlBaseImg.$strUrlImg;
        }
      }
      
      $bUseCss = ( $this->cssLink != "" );
      
      $strHtmlInner = '<img'.
        ' id="btImg'.self::$iNumImg.'"'.
        ( $this->cssLink != ""
          ? ' class="'.$this->cssLink.'"'
          : '' ).
        ' src="'.$strUrlImg.'"'.
        ( $this->iWidth != "" 
          ? ' width="'.$this->iWidth.'"'
          : '' ).
        ( $this->iHeight != ""
          ? ' height="'.$this->iHeight.'"'
          : '' ).        
        ( $this->alt != ""
          ? ' alt="'.$this->alt.'"'
          : '' ).
        ( $this->toolTip != "" 
          ? ' title="'.$this->toolTip.'"'
          : '' ).
        ' border="0"'.
        '/>';
      break;

    case ALK_BUTTONSTYLE_LINK:
    default:
      $strHtmlInner = $this->label;
      break;
    }

    // css appliquées à la balise a ou button
    $strClassCss = "";
    if( $this->cssLink!="" && preg_match("/^page|^form|^icon/i", $this->cssLink) > 0 ) {
      $strClassCss = ( $this->bInline ? "bt" : "bt" ).$strFirstCss." ";
    }
    if( !$bUseCss ) {
      $strClassCss .= ( $strClassCss!="" ? $strOtherCss : $this->cssLink );
    }
    $strClassCss = trim($strClassCss);
    
    $strHtmlOuterStart = "";
    $strHtmlOuterEnd = "";
    switch( $this->buttonType ) {
    case ALK_BUTTONTYPE_LINK:
      $strUrl = $this->value;
      $bHRef = ( substr($this->value, 0, 7)=="mailto:" ||
                 substr($this->value, 0, 7)=="http://" ||
                 substr($this->value, 0, 8)=="https://" ||
                 $this->target != "" );
        
      if( !$this->bAddEvent && !$bHRef && substr($this->value, 0, 11)=="javascript:") {
        $this->addEvent("onclick", $this->value);
        $this->bAddEvent = true;
      } 
            
      $strHtmlOuterStart = '<a '.
        ( $strClassCss != ""
          ? ' class="'.$strClassCss.'"'
          : '' ).
        ( $bHRef
          ? ' href="'.$this->value.'"'
          : ' href="javascript:void(1)"' ).
        ( $this->accessKey != ""
          ? ' accesskey="'.$this->accessKey.'"'
          : '' ).  
        ( $this->target != ""  
          ? ' target="'.$this->target.'"' 
          : '' ).
        ( $this->toolTip != "" 
          ? ' title="'.$this->toolTip.'"' 
          : '' ).
        $this->getHtmlEvent().
        '>';
      $strHtmlOuterEnd = '</a>';
      break;
      
    default:  
      $strHtmlOuterStart = '<button '.
        ' class="'.$strClassCss.'"'.
        ( $this->name != ""
          ? ' name="'.$this->name.'"'
          : '' ).
        ( $this->label != ""
          ? ' value="'.$this->label.'"'
          : ( $this->alt != ""
              ? ' value="'.$this->alt.'"'
              : '' )).
        ' type="'.$this->buttonType.'"'.
        ( $this->accessKey != ""
          ? ' accesskey="'.$this->accessKey.'"'
          : '' ).  
        ( $this->toolTip != "" 
          ? ' title="'.$this->toolTip.'"' 
          : '' ).
        $this->getHtmlEvent().
        '>';
      $strHtmlOuterEnd = '</button>';
      break;
    }
    
    self::$iNumImg++;
    $strHtml = $strHtmlOuterStart.$strHtmlInner.$strHtmlOuterEnd;
    //return substr($this->buttonType, 0, 1).substr($this->buttonStyle, 0, 1).$strHtml;
    return $strHtml;
  }
  
  /**
   *  retourne le label d'un ctrl
   *        ce champ correspond également au titre de formulaire
   * @return string 
   */
  public function getLabel()
  {
    return $this->blockLabel; 
  }
  
  /**
   *  Définit le label utilisé par les blocs
   * @param blockLabel    Nouveau label
   */
  public function setBlockLabel($blockLabel)
  {
    $this->blockLabel = $blockLabel;
  }
}

?>