<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlbutton.class.php");

/**
 * @package Alkanet_Class_form
 * 
 * @class AlkHtmlButonForm
 * 
 * Classe d'affichage d'un bouton de formulaire ou de tableau
 */
class AlkHtmlButtonForm extends AlkHtmlButton
{
  /**
   * Constructeur par défaut
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        Texte contenu du bouton ou du lien ou tableau contenant la clé de traduction et le résultat de la traduction
   * @param strToolTip    Texte info bulle
   * @param bInline       vari pour affiche le bouton en inline, false en block
   * @param strTarget     fenêtre cible du lien, =vide par défaut
   * @param name          Identifiant HTML du boutton
   */
  public function __construct($strLink, $strTxt, $strToolTip, $bInline=false, $strTarget="", $name="")
  {
    parent::__construct($strLink, "", $strToolTip, $bInline, $strTarget, $name);

    $strTxtLg = _t($strTxt);
    if( is_array($strTxt) ) {
      $strTxt   = $strTxt[0]; // clé de traduction
      $strTxtLg = $strTxt[1]; // résultat de la traduction
    }
    
    if( ALK_BTIMAGE ) {
      $this->buttonStyle = ALK_BUTTONSTYLE_IMG;
      $baseNameImg = getClassName($strTxt);
      $this->alt = $strTxtLg;
      $this->label = "";
      $this->cssLink = "form alkimgform alkimgform".$baseNameImg;
      $this->strImgBaseName = "transp.gif";
    } else {
    $this->buttonStyle = ALK_BUTTONSTYLE_LINK;
      $this->cssLink = "form";
      $this->alt = "";
      $this->label = $strTxtLg;
      $this->strImgBaseName = "";
      $this->iWidth = 75;
      $this->iHeight = 15;
    }
  }

}

?>