<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkformdata.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlFactory
 * 
 * Classe factory et singleton qui centralise la création 
 * et la mémorisation des instances hérités de AlkHtmlPanel
 */
final class AlkHtmlFactory extends AlkObject
{
  //private $tabCtrl = array();

  /**
   *  Constructeur par défaut
   */
  public function __construct() { }

  /**
   * Retourne un objet de type AlkHtml
   * @param oDataForm    Soit de type string (contient le code html), soit de type AlkFormData
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @return AlkHtml
   */
  private static function checkHtmlNoVisible($oDataForm)
  {
    return ( !$oDataForm->checkCtrlVisibility() );
  }

  /**
   * Retourne un objet de type AlkHtmlAdapter
   * @param name        Nom (GUID) du panel
   * @param label       titre du composant, =vide par défaut
   * @return AlkHtmlPanel
   */
  public static function getHtmlAdapter($name, $label="")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmladapter.class.php");
    return new AlkHtmlAdapter($name, $label); 
  }

  /**
   * Retourne un objet de type AlkHtmlPanel
   * @param name        Nom (GUID) du panel
   * @param label titre du panel, =vide par défaut
   * @return AlkHtmlPanel
   */
  public static function getHtmlPanel($name, $label="")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlpanel.class.php");
    return new AlkHtmlPanel($name, $label); 
  }

  /**
   * Retourne un objet de type AlkHtmlPanelFilterLink
   * @param oDataForm    Soit de type string (contient le code html), soit de type AlkFormData
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param strName      Nom du controle
   * @return AlkHtmlPanelFilterLink
   */
  public static function getHtmlPanelFilterLink($strTitle, $idSelect)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlpanelfilterlink.class.php");
    return new AlkHtmlPanelFilterLink($strTitle, $idSelect); 
  }
    
  /**
   * Retourne un objet de type AlkHtml
   * @param oDataForm    Soit de type string (contient le code html), soit de type AlkFormData
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param strName      Nom du controle
   * @return AlkHtml
   */
  public static function getHtml($oDataForm, $strLabel="", $strName="")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtml.class.php");
    if( is_object($oDataForm) && $oDataForm->isTypeOf("alkformdata") ){
      if ( self::checkHtmlNoVisible($oDataForm) ) return null;      
      return  new AlkHtml($oDataForm->value, $strLabel, $oDataForm->name);
    } 
    return new AlkHtml($oDataForm, $strLabel, $strName); 
  }

  /**
   * Retourne un objet de type AlkHtmlCheckbox créé à partir d'un AlkFormData
   * @param oDataForm       Référence sur le dataForm associé
   * @param strLabel        Etiquette texte associée au controle de saisie
   * @param valueChecked    Valeur de la case à cocher cochée dans le cas 1 checkbox
   * @param valueNotChecked Valeur de la case à cocher non cochée dans le cas 1 checkbox
   * @return AlkHtmlCheckbox
   */
  public static function getHtmlCheckbox(AlkFormData $oDataForm, $strLabel, $valueChecked="1", $valueNotChecked="0", 
                                         $labelChecked="oui", $labelNotChecked="non")
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    $oCtrl = self::getNewHtmlCheckbox($oDataForm->oForm, 0, $oDataForm->name, $oDataForm->value, $strLabel, $valueChecked, 
                                      $valueNotChecked, $labelChecked, $labelNotChecked); 
    $oDataForm->checkCtrlState($oCtrl);
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlcheckbox
   * @param oForm           Référence sur le formulaire propriétaire
   * @param iMode           Mode d'affichage du controle
   * @param name            Nom du controle
   * @param value           Valeur du controle
   * @param strLabel        Etiquette texte associée au controle de saisie
   * @param valueChecked    Valeur de la case à cocher cochée dans le cas 1 checkbox
   * @param valueNotChecked Valeur de la case à cocher non cochée dans le cas 1 checkbox
   * @return AlkHtmlCheckbox
   */
  public static function getNewHtmlCheckbox($oForm, $iMode, $name, $value, $strLabel, $valueChecked="1", 
                                            $valueNotChecked="0", $labelChecked="oui", $labelNotChecked="non")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlcheckbox.class.php");
    $oCtrl = new AlkHtmlCheckbox($oForm, $iMode, $name, $value, $strLabel, $valueChecked, $valueNotChecked, $labelChecked, $labelNotChecked); 
    return $oCtrl;
  }
  
  /**
   * Retourne un objet de type AlkHtmlColor créé à partir d'un AlkFormData
   * @param oDataForm      Référence sur le dataForm associé
   * @param strLabel       Etiquette texte associée au controle de saisie
   * @param iWidth         largeur du control
   * @param iHeight        hauteur du control
   * @param strNoneAllowed Aucune couleur selectionnable : oui ou non
   * @return AlkHtmlColor
   */
  public static function getHtmlColor(AlkFormData $oDataForm, $strLabel, $iWidth="20", $iHeight="20", $strNoneAllowed="non")
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    $oCtrl = self::getNewHtmlColor($oDataForm->oForm, $oDataForm->name, $oDataForm->value, 
                              $strLabel, $iWidth, $iHeight, $strNoneAllowed); 
    $oDataForm->checkCtrlState($oCtrl);
    return $oCtrl;
  }
  
  /**
   * Retourne un objet de type AlkHtmlColor
   * @param oForm           Référence sur le formulaire propriétaire
   * @param iMode           Mode d'affichage du controle
   * @param name            Nom du controle
   * @param value           Valeur du controle
   * @param strLabel        Etiquette texte associée au controle de saisie
   * @param iWidth          largeur du control
   * @param iHeight         hauteur du control
   * @param strNoneAllowed  Aucune couleur selectionnable : oui ou non
   * @return AlkHtmlColor
   */
  public static function getNewHtmlColor($oForm, $name, $value, $strLabel, $iWidth="20", $iHeight="20", $strNoneAllowed="non")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlcolor.class.php");
    $oCtrl = new AlkHtmlColor($oForm, $name, $value, $strLabel, $iWidth, $iHeight, $strNoneAllowed); 
    return $oCtrl;
  }
  
  /**
   * Retourne un objet de type AlkHtmlColor créé à partir d'un AlkFormData
   * @param oDataForm      Référence sur le dataForm associé
   * @param strLabel       Etiquette texte associée au controle de saisie
   * @param strColor        Couleur de fond du symbole
   * @param strBorderColor  Couleur de bordure du symbole
   * @param strImage        Image de fond du symbole
   * @param strActionJs     Action sur clic 
   * @param iSize           Taille du symbole
   * @return AlkHtmlSymbolColor
   */
  public static function getHtmlSymbolColor(AlkFormData $oDataForm, $strLabel, $strColor="", 
                                            $strBorderColor="", $strImage="", $strActionJs="", $iSize="20")
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    
    $oCtrl = self::getNewHtmlSymbolColor($oDataForm->oForm, $oDataForm->name, $oDataForm->value, $strLabel, 
                                         $strColor, $strBorderColor, $strImage, $strActionJs, $iSize); 
    $oDataForm->checkCtrlState($oCtrl);
    return $oCtrl;
  }
  
  /**
   * Retourne un objet de type AlkHtmlColor
   * @param oForm           Référence sur le formulaire propriétaire
   * @param iMode           Mode d'affichage du controle
   * @param name            Nom du controle
   * @param value           Valeur du controle 
   * @param strLabel        Etiquette texte associée au controle de saisie
   * @param strColor        Couleur de fond du symbole
   * @param strBorderColor  Couleur de bordure du symbole
   * @param strImage        Image de fond du symbole
   * @param strActionJs     Action sur clic 
   * @param iSize           Taille du symbole
   * @return AlkHtmlSymbolColor
   */
  public static function getNewHtmlSymbolColor($oForm, $name, $value="", $strLabel="", $strColor="", $strBorderColor="", $strImage="", $strActionJs="", $iSize="20")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlsymbolcolor.class.php");
    $oCtrl = new AlkHtmlSymbolColor($oForm, $name, $value, $strLabel, $strColor, $strBorderColor, $strImage, $strActionJs, $iSize); 
    return $oCtrl;
  }
  
  /**
   * Retourne un objet de type AlkHtmlDate créé à partir d'un AlkFormData
   * @param oDataForm    Référence sur le dataForm associé
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param dateMin      Date minimale accepté au format jj/mm/aaaa, vide par défaut
   * @param dateMax      Date maximale accepté au format jj/mm/aaaa, vide par défaut
   * @return AlkHtmlDate
   */
  public static function getHtmlDate(AlkFormData $oDataForm, $strLabel, $dateMin="", $dateMax="")
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    $oCtrl = self::getNewHtmlDate($oDataForm->oForm, 0, $oDataForm->name, $oDataForm->value, $strLabel, $dateMin, $dateMax); 
    $oDataForm->checkCtrlState($oCtrl);
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlDate
   * @param oForm           Référence sur le formulaire propriétaire
   * @param iMode           Mode d'affichage du controle
   * @param name            Nom du controle
   * @param value           Valeur du controle
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param dateMin      Date minimale accepté au format jj/mm/aaaa, vide par défaut
   * @param dateMax      Date maximale accepté au format jj/mm/aaaa, vide par défaut
   * @return AlkHtmlDate
   */
  public static function getNewHtmlDate($oForm, $iMode, $name, $value, $strLabel, $dateMin="", $dateMax="")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmltext.class.php");
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmldate.class.php");
    $oCtrl = new AlkHtmlDate($oForm, $iMode, $name, $value, $strLabel, $dateMin, $dateMax); 
    return $oCtrl;
  }
  
  /**
   * Crée deux controles AlkHtmlDate matérialisant un intervalle de date. 
   * <b>Seul l'objet placé à l'index "inf" du tableau de retour est à insérer dans un bloc (le controle sup est ajouté au controle inf).</b>
   * Le nom des controles résultant suivront le schéma [oDataForm->name][strPrefixPart][part][strSuffixPart] 
   * avec [part]=inf pour la date minimale de l'intervalle et [part]=sup pour la date maximale de l'intervalle 
   * @param oDataForm    Référence sur le dataForm associé
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param tabParam     Paramètre les deux controles dates résultant et les textes de label
   *                     Clés attendues :
   *                        - strPrefixPart  : préfixe devant les termes "inf"/"sup" ajoutés au nom du controle. default="["
   *                        - strSuffixPart  : suffixe derrière les termes "inf"/"sup" ajoutés au nom du controle. default="]" 
   *                        - strLabelBefore : Label écrit devant le controle date inf. default=" Du "
   *                        - strLabelInter  : Label écrit entre les deux controles. default=" Au "
   *                        - strLabelAfter  : Label écrit après le controle date sup. default=""
   *                        - dateMinInf     : date minimale du calendrier inf. default=""
   *                        - dateMaxInf     : date maximale du calendrier inf. default=""
   *                        - dateMinSup     : date minimale du calendrier sup. default=""
   *                        - dateMaxSup     : date maximale du calendrier sup. default=""
   * @return AlkHtmlDate
   */
  public static function getHtmlDateInterval(AlkFormData $oDataForm, $strLabel, $tabParam=array())
  {
    
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    $tabCtrl = self::getNewHtmlDateInterval($oDataForm->oForm, 0, $oDataForm->name, $oDataForm->value, $strLabel, $tabParam); 
    foreach($tabCtrl as $oCtrl)
      $oDataForm->checkCtrlState($oCtrl);
    return $tabCtrl;
  }

  
  /**
   * Crée deux controles AlkHtmlDate matérialisant un intervalle de date. 
   * <b>Seul l'objet placé à l'index "inf" du tableau de retour est à insérer dans un bloc (le controle sup est ajouté au controle inf).</b>
   * Le nom des controles résultant suivront le schéma [name][strPrefixPart][part][strSuffixPart] 
   * avec [part]=inf pour la date minimale de l'intervalle et [part]=sup pour la date maximale de l'intervalle 
   * @param oForm        Référence sur le formulaire propriétaire
   * @param iMode        Mode d'affichage du controle
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param tabParam     Paramètre les deux controles dates résultant et les textes de label
   *                     Clés attendues :
   *                        - strPrefixPart  : préfixe devant les termes "inf"/"sup" ajoutés au nom du controle. default="["
   *                        - strSuffixPart  : suffixe derrière les termes "inf"/"sup" ajoutés au nom du controle. default="]" 
   *                        - strLabelBefore : Label écrit devant le controle date inf. default=" Du "
   *                        - strLabelInter  : Label écrit entre les deux controles. default=" Au "
   *                        - strLabelAfter  : Label écrit après le controle date sup. default=""
   *                        - dateMinInf     : date minimale du calendrier inf. default=""
   *                        - dateMaxInf     : date maximale du calendrier inf. default=""
   *                        - dateMinSup     : date minimale du calendrier sup. default=""
   *                        - dateMaxSup     : date maximale du calendrier sup. default=""
   * @return array("inf"=>AlkHtmlDate, "sup"=>AlkHtmlDate) 
   */
  public static function getNewHtmlDateInterval($oForm, $iMode, $name, $value, $strLabel, $tabParam=array())
  {
    $strPrefixPart  =  "["; 
    $strSuffixPart = "]"; 
    $strLabelBefore = " Du "; 
    $strLabelInter = " Au "; 
    $strLabelAfter = ""; 
    $dateMinInf = ""; 
    $dateMaxInf = ""; 
    $dateMinSup = ""; 
    $dateMaxSup = "";
    foreach ($tabParam as $varName=>$varValue){
      //Initialisation des paramètres par lecture du tableau où les clés sont parmis les noms de variables ci-dessus (utilisation de $$)  
      $$varName = $varValue;
    }
    $valueInf = "";
    $valueSup = "";
    if ( is_array($value) ){
      $valueInf = $value["inf"];
      $valueSup = $value["sup"];
    }
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmltext.class.php");
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmldate.class.php");
    $oCtrlInf = new AlkHtmlDate($oForm, $iMode, $name . $strPrefixPart."inf".$strSuffixPart, $valueInf, $strLabel, $dateMinInf, $dateMinInf); 
    $oCtrlInf->setLabelBefore($strLabelBefore);
    $oCtrlSup = new AlkHtmlDate($oForm, $iMode, $name . $strPrefixPart."sup".$strSuffixPart, $valueSup, $strLabelInter, $dateMinSup, $dateMinSup);
    $oCtrlSup->setLabelAfter($strLabelAfter);
    $oCtrlInf->addCtrl($oCtrlSup); 
    
    return array("inf"=>$oCtrlInf, "sup"=>$oCtrlSup);
  }
  
  /**
   * Retourne un objet de type AlkHtmlSlider créé à partir d'un AlkFormData
   * @param oDataForm    Référence sur le dataForm associé
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param dateMin      Date minimale accepté au format jj/mm/aaaa, vide par défaut
   * @param dateMax      Date maximale accepté au format jj/mm/aaaa, vide par défaut
   * @return AlkHtmlSlider
   */
  public static function getHtmlSlider(AlkFormData $oDataForm, $strLabel, $row=1, $column=0, $maxlength=0, $iWidthSlider=150)
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    $oCtrl = self::getNewHtmlSlider($oDataForm->oForm, 0, $oDataForm->name, $oDataForm->value, $strLabel, $row, $column, $maxlength, $iWidthSlider); 
    $oDataForm->checkCtrlState($oCtrl);
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlSlider
   * @param oForm           Référence sur le formulaire propriétaire
   * @param iMode           Mode d'affichage du controle
   * @param name            Nom du controle
   * @param value           Valeur du controle
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param dateMin      Date minimale accepté au format jj/mm/aaaa, vide par défaut
   * @param dateMax      Date maximale accepté au format jj/mm/aaaa, vide par défaut
   * @return AlkHtmlSlider
   */
  public static function getNewHtmlSlider($oForm, $iMode, $name, $value, $strLabel, $row=1, $column=0, $maxlength=0, $iWidthSlider=150)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmltext.class.php");
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlslider.class.php");
    $oCtrl = new AlkHtmlSlider($oForm, $iMode, $name, $value, $strLabel, $row, $column, $maxlength, $iWidthSlider); 
    return $oCtrl;
  }
  
  /**
   * Retourne un objet de type AlkHtmlCalendar créé à partir d'un AlkFormData
   * @param oDataForm    Référence sur le dataForm associé
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param calendarMin      Calendar minimale accepté au format jj/mm/aaaa, vide par défaut
   * @param calendarMax      Calendar maximale accepté au format jj/mm/aaaa, vide par défaut
   * @return AlkHtmlCalendar
   */
  public static function getHtmlCalendar(AlkFormData $oDataForm, $iJourCur, $iMoisCur, $iAnneeCur, $strUrlPagine, $iCalWidth=650, $iCalCellHeight=50)
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    $oCtrl = self::getNewHtmlCalendar($oDataForm->oForm, 0, $oDataForm->name, $iJourCur, $iMoisCur, $iAnneeCur, $strUrlPagine, $iCalWidth, $iCalCellHeight); 
    $oDataForm->checkCtrlState($oCtrl);
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlCalendar
   * @param oForm           Référence sur le formulaire propriétaire
   * @param iMode           Mode d'affichage du controle
   * @param name            Nom du controle
   * @param value           Valeur du controle
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param calendarMin      Calendar minimale accepté au format jj/mm/aaaa, vide par défaut
   * @param calendarMax      Calendar maximale accepté au format jj/mm/aaaa, vide par défaut
   * @return AlkHtmlCalendar
   */
  public static function getNewHtmlCalendar($oForm, $iMode, $name, $iJourCur, $iMoisCur, $iAnneeCur, $strUrlPagine, $iCalWidth, $iCalCellHeight)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlcalendar.class.php");
    $oCtrl = new AlkHtmlCalendar($oForm, $iMode, $name, $iJourCur, $iMoisCur, $iAnneeCur, $strUrlPagine, $iCalWidth, $iCalCellHeight); 
    return $oCtrl;
  }
  
  /**
   * Retourne un objet de type AlkHtmlWdCalendar créé à partir d'un AlkFormData
   * @param oDataForm    Référence sur le dataForm associé
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param calendarMin      Calendar minimale accepté au format jj/mm/aaaa, vide par défaut
   * @param calendarMax      Calendar maximale accepté au format jj/mm/aaaa, vide par défaut
   * @return AlkHtmlCalendar
   */
  public static function getHtmlWdCalendar(AlkFormData $oDataForm)
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    $oCtrl = self::getNewHtmlWdCalendar($oDataForm->oForm, 0, $oDataForm->name); 
    $oDataForm->checkCtrlState($oCtrl);
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlWdCalendar
   * @param oForm           Référence sur le formulaire propriétaire
   * @param iMode           Mode d'affichage du controle
   * @param name            Nom du controle
   * @return AlkHtmlCalendar
   */
  public static function getNewHtmlWdCalendar($oForm, $iMode, $name)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlwdcalendar.class.php");
    $oCtrl = new AlkHtmlWdCalendar($oForm, $iMode, $name); 
    return $oCtrl;
  }
  
  /**
   * Retourne un objet de type AlkHtmlFile créé à partir d'un AlkFormData
   * @param oDataForm    Référence sur le dataForm associé
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param column       Taille en caractère de la zone de saisie (sans prendre en compte la taille du bouton)
   * @param maxlength    Longueur max du nom de fichier
   * @return AlkHtmlFile
   */
  public static function getHtmlFile(AlkFormData $oDataForm, $strLabel, $column=0, $maxlength=0)
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    $oCtrl = self::getNewHtmlFile($oDataForm->oForm, 0, $oDataForm->name, $oDataForm->value, $strLabel, $column, $maxlength);  
    $oDataForm->checkCtrlState($oCtrl);
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlFile
   * @param oForm           Référence sur le formulaire propriétaire
   * @param iMode           Mode d'affichage du controle
   * @param name            Nom du controle
   * @param value           Valeur du controle
   * @param strLabel        Etiquette texte associée au controle de saisie
   * @param column          Taille en caractère de la zone de saisie (sans prendre en compte la taille du bouton)
   * @param maxlength       Longueur max du nom de fichier
   * @return AlkHtmlFile
   */
  public static function getNewHtmlFile($oForm, $iMode, $name, $value, $strLabel, $column=0, $maxlength=0)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlfile.class.php");
    $oCtrl = new AlkHtmlFile($oForm, $iMode, $name, $value, $strLabel, $column, $maxlength); 
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlHidden créé à partir d'un AlkFormData
   * @param oDataForm    Référence sur le dataForm associé
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @return AlkHtmlHidden
   */
  public static function getHtmlHidden(AlkFormData $oDataForm)
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    return self::getNewHtmlHidden($oDataForm->oForm, $oDataForm->name, $oDataForm->value);
  }

  /**
   * Retourne un objet de type AlkHtmlHidden
   * @param oForm           Référence sur le formulaire propriétaire
   * @param name            Nom du controle
   * @param value           Valeur du controle
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @return AlkHtmlHidden
   */
  public static function getNewHtmlHidden($oForm, $name, $value)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlhidden.class.php");
    return new AlkHtmlHidden($oForm, $name, $value);
  }


  /**
   * Retourne un objet de type AlkHtmlRadio créé à partir d'un AlkFormData
   * @param oDataForm    Référence sur le dataForm associé
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @return AlkHtmlRadio
   */
  public static function getHtmlRadio(AlkFormData $oDataForm, $strLabel)
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlradio.class.php");
    $oCtrl = self::getNewHtmlRadio($oDataForm->oForm, 0, $oDataForm->name, $oDataForm->value, $strLabel);  
    $oDataForm->checkCtrlState($oCtrl);
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlRadio
   * @param oForm           Référence sur le formulaire propriétaire
   * @param iMode           Mode d'affichage du controle
   * @param name            Nom du controle
   * @param value           Valeur du controle
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @return AlkHtmlRadio
   */
  public static function getNewHtmlRadio($oForm, $iMode, $name, $value, $strLabel)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlradio.class.php");
    $oCtrl = new AlkHtmlRadio($oForm, $iMode, $name, $value, $strLabel);  
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlSelect créé à partir d'un AlkFormData
   * @param oDataForm    Référence sur le dataForm associé
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param size         hauteur de la zone sélection (=1 : comboBox, >1 : liste sélection). =1 par défaut
   * @param widthSelect  Largeur en pixel de la saisie de sélection
   * @param widthOption  largeur en pixel de la dropdown list box
   * @return AlkHtmlSelect
   */
  public static function getHtmlSelect(AlkFormData $oDataForm, $strLabel, $size="1", $widthSelect="", $widthOption="")
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    $oCtrl = self::getNewHtmlSelect($oDataForm->oForm, 0, $oDataForm->name, $oDataForm->value, 
                             $strLabel, $size, $widthSelect, $widthOption); 
    $oDataForm->checkCtrlState($oCtrl);
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlSelect
   * @param oForm        Référence sur le formulaire propriétaire
   * @param iMode           Mode d'affichage du controle
   * @param name         Nom du controle
   * @param value        Valeur du controle
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param size         hauteur de la zone sélection (=1 : comboBox, >1 : liste sélection). =1 par défaut
   * @param widthSelect  Largeur en pixel de la saisie de sélection
   * @param widthOption  largeur en pixel de la dropdown list box
   * @return AlkHtmlSelect
   */
  public static function getNewHtmlSelect($oForm, $iMode, $name, $value, $strLabel, $size="1", $widthSelect="", $widthOption="")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlselect.class.php");
    $oCtrl = new AlkHtmlSelect($oForm, $iMode, $name, $value, 
                             $strLabel, $size, $widthSelect, $widthOption); 
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlText créé à partir d'un AlkFormData
   * @param oDataForm   Référence sur le dataForm associé
   * @param strLabel    Etiquette texte associée au controle de saisie
   * @param row         Nombre de ligne (=1 : <input type=text>, >1 : <textarea>). =1 par défaut
   * @param column      Nombre de colonnes. =0 par défaut
   * @param maxlength   Longueur max du texte saisi. =0 par défaut
   * @return AlkHtmlText
   */
  public static function getHtmlText(AlkFormData $oDataForm, $strLabel, $row=1, $column=0, $maxlength=0)
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    $oCtrl = self::getNewHtmlText($oDataForm->oForm, 0, $oDataForm->name, $oDataForm->value, $strLabel, $row, $column, $maxlength);
    $oCtrl->setBMultiLanguage($oDataForm->getBMultiLanguage());
    $oDataForm->checkCtrlState($oCtrl);
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlText
   * @param oForm       Référence sur le formulaire propriétaire
   * @param iMode       Mode d'affichage du controle
   * @param name        Nom du controle
   * @param value       Valeur du controle
   * @param strLabel    Etiquette texte associée au controle de saisie
   * @param row         Nombre de ligne (=1 : <input type=text>, >1 : <textarea>). =1 par défaut
   * @param column      Nombre de colonnes. =0 par défaut
   * @param maxlength   Longueur max du texte saisi. =0 par défaut
   * @return AlkHtmlText
   */
  public static function getNewHtmlText($oForm, $iMode, $name, $value, $strLabel, $row=1, $column=0, $maxlength=0)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmltext.class.php");
    $oCtrl = new AlkHtmlText($oForm, $iMode, $name, $value, $strLabel, $row, $column, $maxlength);
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlUpload créé à partir d'un AlkFormData
   * @param oDataForm    Référence sur le dataForm associé
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param strPathBase  Chemin de base vers les fichiers joints
   * @param strUrlBase   Url de base vers les fichiers joints
   * @param strUrlIcone  Url de base vers les icones des fichiers joints
   * @param nbLg         Nombre de langue prise en compte par l'extranet (=1 par defaut)
   * @param dir_rootUploadTree Repertoire racine de l'arbre de pwd_file_browser
   * @return AlkHtmlUpload
   */
  public static function getHtmlUpload(AlkFormData $oDataForm, $strLabel, $tableName, $data_id, $dir_upload, $nbLg=1, $dir_rootUploadTree="")
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlupload.class.php");
    $oCtrl = self::getNewHtmlUpload($oDataForm->oForm, 3, $oDataForm->name, 
                             $strLabel, $tableName, $data_id, $dir_upload, $nbLg,$dir_rootUploadTree); 
    
    //$oDataForm->checkCtrlState($oCtrl);
    $oCtrl->setHidden($oDataForm->getIsHidden());
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlUpload
   * @param oForm       Référence sur le formulaire propriétaire
   * @param iMode       Mode d'affichage du controle
   * @param name        Nom du controle
   * @param strLabel     Etiquette texte associée au controle de saisie
   * @param strPathBase  Chemin de base vers les fichiers joints
   * @param strUrlBase   Url de base vers les fichiers joints
   * @param strUrlIcone  Url de base vers les icones des fichiers joints
   * @param nbLg         Nombre de langue prise en compte par l'extranet (=1 par defaut)
   * @param dir_rootUploadTree Repertoire racine de l'arbre de pwd_file_browser
   * @return AlkHtmlUpload
   */
  public static function getNewHtmlUpload($oForm, $iMode, $name, $strLabel, $tableName, $data_id, $dir_upload, $nbLg=1, $dir_rootUploadTree="")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlupload.class.php");
    $oCtrl = new AlkHtmlUpload($oForm, $iMode, $name, 
                             $strLabel, $tableName, $data_id, $dir_upload, $nbLg,$dir_rootUploadTree); 
    return $oCtrl;
  }

  

  /**
   * Retourne un objet de type AlkHtmlTag créé à partir d'un AlkFormData
   * @param oDataForm   Référence sur le dataForm associé
   * @param strLabel    Etiquette texte associée au controle de saisie
   * @param row         Nombre de ligne (=1 : <input type=text>, >1 : <textarea>). =1 par défaut
   * @param column      Nombre de colonnes. =0 par défaut
   * @param maxlength   Longueur max du texte saisi. =0 par défaut
   * @return AlkHtmlTag
   */
  public static function getHtmlTag(AlkFormData $oDataForm, $strLabel, $tabParams, $separator="||")
  {
    if ( self::checkHtmlNoVisible($oDataForm) ) return null;
    $oCtrl = self::getNewHtmlTag($oDataForm->oForm, 0, $oDataForm->name, $oDataForm->value, $strLabel, $tabParams, $separator);
    $oCtrl->setBMultiLanguage($oDataForm->getBMultiLanguage());
    $oDataForm->checkCtrlState($oCtrl);
    return $oCtrl;
  }

  /**
   * Retourne un objet de type AlkHtmlTag
   * @param oForm       Référence sur le formulaire propriétaire
   * @param iMode       Mode d'affichage du controle
   * @param name        Nom du controle
   * @param value       Valeur du controle
   * @param strLabel    Etiquette texte associée au controle de saisie
   * @param row         Nombre de ligne (=1 : <input type=text>, >1 : <textarea>). =1 par défaut
   * @param column      Nombre de colonnes. =0 par défaut
   * @param maxlength   Longueur max du texte saisi. =0 par défaut
   * @return AlkHtmlTag
   */
  public static function getNewHtmlTag($oForm, $iMode, $name, $value, $strLabel, $tabParams, $separator="||")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmltag.class.php");
    $oCtrl = new AlkHtmlTag($oForm, $iMode, $name, $value, $strLabel, $tabParams, $separator);
    return $oCtrl;
  }
  
  /**
   * Retourne un objet de type AlkHtmlList

   * @return AlkHtmlList
   */
  public static function getHtmlList($oForm, $iNbElt=0, $iNumPage=1, $iNbEltParPage=20, $bPagine=true, 
                                     $strUrlPagine="", $strMsgNoResult="", $bAllData=false, 
                                     $strName="tabPagine", $bSelectNbElts = false, $tabValSelect = array())
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmllist.class.php");
    return new AlkHtmlList($oForm, $iNbElt, $iNumPage, $iNbEltParPage, $bPagine, $strUrlPagine, 
                           $strMsgNoResult, $bAllData, $strName, $bSelectNbElts, $tabValSelect);
  }
  
    /**
   * Retourne un objet de type AlkHtmlListJquery

   * @return AlkHtmlListJQuery
   */
  public static function getHtmlListJQuery($oForm, $iNbElt=0, $bPagine=true, $strUrlPagine="", $strName="tabPagine")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmllistjquery.class.php");
    return new AlkHtmlListJQuery($oForm, $iNbElt, $bPagine, $strUrlPagine, $strName);
  }

  /**
   * Retourne un objet de type AlkHtmlTreeTable
   * @param oForm     Formulaire propriétaire
   * @param name      Nom de l'arbre
   * @return AlkHtmlTreeTable
   */
  public static function getHtmlTreeTable($oForm, $name, $strTitle="", $strDesc="", $iWidthLabel="180", $iWidthCtrl="390", $iFirstNiv=0)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmltreetable.class.php");
    return new AlkHtmlTreeTable($oForm, $name, $strTitle, $strDesc, $iWidthLabel, $iWidthCtrl, $iFirstNiv);
  }

  /**
   * Retourne un objet de type AlkHtmlLink
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        Texte associé au lien ou à l'image en info-bulle
   * @param strImg        Nom de l'image
   * @param strImgRol     Nom de l'image roll
   * @param strUrlBaseImg Url de base des images
   * @return AlkHtmlLink
   */
  public static function getHtmlLink($strLink, $strTxt, $strImg="", $strImgRol="", $strUrlBaseImg="")
  {
    //require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmllink.class.php");
    if( $strImg == "" ) {
      require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlbutton.class.php");
      return new AlkHtmlButton($strLink, $strTxt, $strTxt, true, "", "");
    } 
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlbuttonimg.class.php");
    return new AlkHtmlButtonImg($strLink, $strImg, $strTxt, "", "", true, "", "");
  }

  /**
   * Retourne un objet de type AlkHtmlButton
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        Texte contenu du bouton ou du lien
   * @param strToolTip    Texte info bulle
   * @param bInline       vari pour affiche le bouton en inline, false en block
   * @param strName       fenêtre cible du lien, =vide par défaut
   * @return AlkHtmlButton
   */
  public static function getHtmlButton($strLink, $strTxt, $strToolTip, $bInline=false, $strTarget="", $strName="")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlbutton.class.php");
    return new AlkHtmlButton($strLink, $strTxt, $strToolTip, $bInline, $strTarget, $strName);
  }

  /**
   * Retourne un objet de type AlkHtmlButtonForm
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        Texte contenu du bouton ou du lien
   * @param strToolTip    Texte info bulle
   * @param bInline       vari pour affiche le bouton en inline, false en block
   * @param strTarget     fenêtre cible du lien, =vide par défaut
   * @param strName       Identifiant HTML du boutton
   * @return AlkHtmlButtonForm
   */
  public static function getHtmlButtonForm($strLink, $strTxt, $strToolTip, $bInline=false, $strTarget="", $strName="")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlbuttonform.class.php");
    return new AlkHtmlButtonForm($strLink, $strTxt, $strToolTip, $bInline, $strTarget, $strName);
  }

  /**
   * Retourne un objet de type AlkHtmlButtonPage
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        Texte contenu du bouton ou du lien
   * @param strToolTip    Texte info bulle
   * @param bInline       vari pour affiche le bouton en inline, false en block
   * @param strTarget     fenêtre cible du lien, =vide par défaut
   * @param strName       Identifiant HTML du boutton
   * @return AlkHtmlButtonPage
   */
  public static function getHtmlButtonPage($strLink, $strTxt, $strToolTip, $bInline=false, $strTarget="", $strName="")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlbuttonpage.class.php");
    return new AlkHtmlButtonPage($strLink, $strTxt, $strToolTip, $bInline, $strTarget, $strName);
  }

  /**
   * Retourne un objet de type AlkHtmlButtonIcon
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        Texte contenu du bouton ou du lien
   * @param strToolTip    Texte info bulle
   * @param bInline       vari pour affiche le bouton en inline, false en block
   * @param strTarget     fenêtre cible du lien, =vide par défaut
   * @param strName       Identifiant HTML du boutton
   * @return AlkHtmlButtonPage
   */
  public static function getHtmlButtonIcon($strLink, $strTxt, $strToolTip, $bInline=false, $strTarget="", $strName="")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlbuttonicon.class.php");
    return new AlkHtmlButtonIcon($strLink, $strTxt, $strToolTip, $bInline, $strTarget, $strName);
  }

  /**
   * Retourne un objet de type AlkHtmlButtonImg
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        url complète de l'image avec extension ou nom de l'image avec extension (présent dans le répertoire urlBaseImg)
   * @param strToolTip    Texte info bulle
   * @param iWidth        largeur de l'image, =vide par défaut (automatiquement détecté)
   * @param iHeight       hauteur de l'image, =vide par défaut (automatiquement détecté)
   * @param bInline       vari pour affiche le bouton en inline, false en block
   * @param strTarget     fenêtre cible du lien, =vide par défaut
   * @param strName       Identifiant HTML du boutton
   * @return AlkHtmlButtonPage
   */
  public static function getHtmlButtonImg($strLink, $strTxt, $strToolTip, $iWidth="", $iHeight="", $bInline=false, $strTarget="", $strName="")
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlbuttonimg.class.php");
    return new AlkHtmlButtonImg($strLink, $strTxt, $strToolTip, $iWidth, $iHeight, $bInline, $strTarget, $strName);
  }
  
  
  
  /**
   * Retourne un objet de type Map
   * @param name        Nom du controle (correspond à la balise div de la carte)
   * @param mapStyle    style de la carte  (correspond à la classe CSS)
   * @return AlkHtmlOpenLayersMap
   */
  public static function getNewOpenLayersMap($name, $width)
  {
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlopenlayersmap.class.php");
    $oCtrl = new AlkHtmlOpenLayersMap($name, $width);
    return $oCtrl;
  }
  
}
 
?>