<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");

/**
 * @package Alkanet_Class_form
 * @class AlkHtmlLink
 * 
 * Classe d'affichage d'un lien texte ou image.
 *        génère : <a href=></a>
 *                 <a href=><img /></a>
 */
class AlkHtmlLink extends AlkHtmlCtrl
{
  /** compteur d'images */
  static protected $iNumImg = 0;

  /** texte info bulle, par défaut = $strTxt */
  protected $toolTip;

  /** classe CSS sur le lien texte, par défaut aContenuLien */
  protected $class;

  /** url de l'image */
  protected $strUrlImg;

  /** url de l'image roll */
  protected $strUrlImgRol;

  /** fenetre cible */
  protected $target;

  /** nom de l'image */
  protected $strImgName;

  /** alignement vertical de l'image */
  protected $imgVerticalAlign;

  /**
   *  Constructeur par défaut
   *
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        Texte associé au lien ou à l'image en info-bulle
   * @param strImg        Nom de l'image
   * @param strImgRol     Nom de l'image roll
   * @param strUrlBaseImg Url de base des images
   */
  public function __construct($strLink, $strTxt, $strImg="", $strImgRol="", $strUrlBaseImg="")
  {
    parent::__construct(null, 0, "", $strLink, $strTxt);
    $this->toolTip = "";
    $this->class = "";
    $this->urlImg = $strImg;
    $this->urlImgRol = $strImgRol;
    $this->target = "";
    $this->urlBaseImg = "";
    if(  $strUrlBaseImg != "" ) {
      $this->urlBaseImg = $strUrlBaseImg;
    } elseif( defined("ALK_URL_SI_IMAGES") ==true ) {
      $this->urlBaseImg = ALK_URL_SI_IMAGES;
    }
    if( $strImg != "" )
      $this->toolTip = $strTxt;
    $this->strImgName = "";
    $this->imgVerticalAlign = "middle";
  }

  /**
   *  Génère puis retourne le code html associé au controle de saisie
   */
  protected function getCtrlHtml($key=0, $tabLg=array()){}
  
  /**
   *  Génère puis retourne le code html associé au controle de saisie
   */
  public function getHtml()
  {
    // compteur pour identifier les images
    if( $this->class != "" ) 
      $this->cssLink = $this->class;

    // contruit le controle
    $strHtml = "";
    if( $this->urlImg == "" &&  $this->urlImgRol == "" ) {
      // lien hypertexte
      $strHtml = "<a".
        " class=\"".$this->cssLink."\"".
        " href=\"".$this->value."\"".
        ( $this->target != "" ? " target=\"".$this->target."\"" : "" ).
        ( $this->toolTip != "" ? " title=\"".$this->toolTip."\"" : "" ).
        " ".$this->GetHtmlEvent().
        ">".
        $this->label.
        "</a>";
    } else {
      // lien image
      if( isset($_GET["print"]) && $_GET["print"]=="1" ) return "&nbsp;";
      
      self::$iNumImg++;
      
      $strImgName = $this->urlImg.self::$iNumImg;
      $this->strImgName = $strImgName;

      $strToolTip = "";
      if( $this->toolTip != "" ) $strToolTip = " title=\"".$this->toolTip."\"";
      $strTarget = "";
      if( $this->target != "" ) $strTarget = " target=\"".$this->target."\"";

      if( $this->urlImg != "#" && $this->urlImg != "" ) {
        if( $this->urlImgRol != "" ) {
          $strHtml = "<a ".
            $strTarget.
            $strToolTip.
            " href=\"".$this->value."\"".
            $this->GetHtmlEvent().
            " onMouseOut=\"MM_swapImgRestore()\"". 
            " onMouseOver=\"MM_swapImage('".$strImgName."', '', '". $this->urlBaseImg.$this->urlImgRol."', 1)\">".
            "<img ".
            " alt=\"".$this->toolTip."\"".
            " align=\"".$this->imgVerticalAlign."\"".
            " name=\"".$strImgName."\"".
            " id=\"".$strImgName."\"".
            " border=\"0\"".
            " src=\"".$this->urlBaseImg.$this->urlImg."\" />".
            "</a>";
        } else {
          $strHtml = "<a ".
            $strTarget.
            $this->GetHtmlEvent().
            $strToolTip.
            " href=\"".$this->value."\">".
            "<img ".
            " alt=\"".$this->toolTip."\"".
            " align=\"".$this->imgVerticalAlign."\"".
            " name=\"".$strImgName."\"".
            " id=\"".$strImgName."\"".
            " border=\"0\"".
            " src=\"".$this->urlBaseImg.$this->urlImg."\" />".
            "</a>";
        }
      } else {
        $strHtml = "<img ".
          $strToolTip.
          " alt=\"".$this->toolTip."\"".
          " align=\"".$this->imgVerticalAlign."\"".
          " name=\"".$strImgName."\"".
          " id=\"".$strImgName."\"".
          " border=\"0\"".
          " src=\"".$this->urlBaseImg.$this->urlImg."\" />";
      }
    }
    return $strHtml;
  }

  /**
   *  Retourne le nom de l'image normale
   *
   * @return Retourne un string
   */
  public function getImageName()
  {
    return $this->strImgName;
  }

}

?>