<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkobject.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alksheetsmanager.class.php");

/* TODO Choisir entre define et const 
define("ALK_CLASS_HTMLPANEL", "alkhtmlpanel");
define("ALK_CLASS_HTMLPAGE" , "alkhtmlpage");
define("ALK_CLASS_HTMLSHEET", "alkhtmlsheet");
define("ALK_CLASS_HTMLFORM" , "alkhtmlform");
define("ALK_CLASS_HTMLBLOCK", "alkhtmlblock");
define("ALK_CLASS_HTMLLIST" , "alkhtmllist");
define("ALK_CLASS_HTMLCTRL" , "alkhtmlctrl");
*/

/** Mode d'initialisation */
if( !defined("ALK_INIT_MODE_DEFAULT") ) define("ALK_INIT_MODE_DEFAULT", pow(2, ($initMode=0)));
if( !defined("ALK_INIT_MODE_DATASET") ) define("ALK_INIT_MODE_DATASET", pow(2, ++$initMode));
if( !defined("ALK_INIT_MODE_DATAROW") ) define("ALK_INIT_MODE_DATAROW", pow(2, ++$initMode));
if( !defined("ALK_INIT_MODE_REQUEST") ) define("ALK_INIT_MODE_REQUEST", pow(2, ++$initMode));

/**
 * @package Alkanet_Class_Form 
 *          Module de classes génériques des contrôles d'affichage
 * @class AlkHtmlPanel
 * 
 * Classe représentant un panneau d'affichage html
 */
class AlkHtmlPanel extends AlkObject
{
  const ALK_CLASS_HTMLPANEL   = "alkhtmlpanel";
  const ALK_CLASS_HTMLPAGE    = "alkhtmlpage";
  const ALK_CLASS_HTMLSHEET   = "alkhtmlsheet";
  const ALK_CLASS_HTMLFORM    = "alkhtmlform";
  const ALK_CLASS_HTMLBLOCK   = "alkhtmlblock";
  const ALK_CLASS_HTMLLIST    = "alkhtmllist";
  const ALK_CLASS_HTMLCTRL    = "alkhtmlctrl";
  const ALK_CLASS_HTMLBUTTON  = "alkhtmlbutton";
  const ALK_CLASS_HTMLCOMPONENT  = "alkinthtmlcomponent";

  /* --------------------------------
   * attributs statiques
   * --------------------------------*/
  /** Indique que la contrainte d'unicité des noms de panels doit être vérifiée */
  static public $bUniqueName   = true; 
  
  /** tableau contenant la liste des identifiants d'objets créés au cours d'une exécution */
  static public $tabPanelIds   = array(); 
 
  /** tableau contenant les actions onload de la page */
  static protected $tabOnload         = array();
 
  /** tableau contenant les actions onunload de la page */
  static protected $tabOnUnload         = array();
 
  /** tableau contenant du code js */
  static protected $tabJs         = array();

  /** tableau contenant l'ensemble des variables js */
  static protected $tabVarJs      = array();

  /** tableau contenant l'ensemble des sources js nécessaire au formulaire */
  static protected $tabSrcJs      = array();  
  
  /** tableau contenant du code css */
  static protected $tabCss        = array();

  /** tableau contenant l'ensemble des sources css nécessaire au formulaire */
  static protected $tabSrcCss     = array();
  static protected $tabSrcCssLast = array();

  /** tableau associatif contenant la déclaration de css */
  static protected $tabClassCss   = array();

  /** type de navigateur : IE, Opera, netscape4, netscape6 */
  static protected $strNavigator = ALK_NAV;
  
  /* --------------------------------
   * attributs de gestion du contenu
   * --------------------------------*/
  /** panel propriétaire de l'onglet */
  protected $oParent;
  
  /** tableau contenant l'ensemble des sous-panels ajoutés */
  protected $tabPanels;
  
  /** tableau donnant l'ordre des panels ajoutés */
  protected $tabPanelsOrder;

  /** Gestionnaire d'onglets */
  protected $oSheetsManager;

  /** tableau des boutons liés au formulaire (validation, suppression, annulation, etc...) rangé par niveau */
  protected $tabHtmlLink;

  /** référence vers l'objet Smarty utilisé pour les templates */
  protected $oTemplate;

  /** fichier template utilisé */
  protected $strTemplateFile;

  /* --------------------------------
   * propriétés de l'objet
   * --------------------------------*/
  /** Identifiant unique du panel (liste de controles compris) */
  protected $guid;
  
  /** Identifiant et nom  du panel */
  protected $name;
  
  /** label du panel */
  protected $label;
  
  /** titre du panel */
  protected $title;

  /** texte ou conseil pour le panel */
  protected $labelDesc;

  /** texte erreur ou warning pour le panel */
  protected $labelWarning;
  
  /** largeur du panel */
  protected $iWidth;
  
  /** hauteur du panel */
  protected $iHeight;
  
  /** liste d'événements associés */
  protected $tabEvents;

  /** url de base pour les images*/
  protected $urlBaseImg;

  /** vrai si multilingue pris en compte */
  public $bMultiLanguage;

  /** url de base pour les images drapeaux*/
  protected $urlBaseFlag;

  /** vrai = champ langue étrangère affichée, faux = champs cachés */
  protected $bShowMultiLanguage;

  /** Nom des classes CSS pour respectivement : texte courant, lien courant */
  protected $cssText;
  protected $cssLink;
  protected $cssFormLabel;
  protected $cssFormCtrl;
  protected $cssHelp;
  protected $cssWarning;
  protected $cssAdvice;

  /** contenu de l'attribut style et class d'un tag html */
  protected $cssStyle;
  protected $cssClass;

  /** contenu de l'attribut style d'un tag html */
  private $bStyleTitle;
  
  protected $defaultCssFile;
  
  
  /* --------------------------------
   * propriétés d'initalisation de l'objet
   * --------------------------------*/
  
  /** données d'initialisation */
  protected $oData;
  
  /** propriété de lecture des données d'initialisation */
  protected $dataFields;
  
  /** Type d'initialisation de l'objet */
  protected $initMode;
  
  /** Détermine si l'initalisation à été effectuée */
  protected $bIsInit;
  
  /** Détermine si les onglets doivent être affichés */
  protected $bSheetVisible;

  /**
   *  Constructeur par défaut
   * 
   * @param name  Identifiant et non du panel
   * @param label titre du panel, =vide par défaut
   */
  public function __construct($name, $label="", &$manager=null)
  {
    parent::__construct();
    $this->name = "";
    $guid = $this->getGUIDForName($name);
    $this->checkName($guid, $name, E_USER_ERROR);
    
    $this->guid = $guid;
    $this->name = $name;
    if ( self::$bUniqueName )
      self::$tabPanelIds[$this->guid] = $this->guid;
    
    $this->label        = $label;
    $this->title        = "";
    $this->labelDesc    = "";
    $this->labelWarning = "";
    
    $this->initMode    = ALK_INIT_MODE_DEFAULT;
    $this->bIsInit     = false;
    $this->oData       = null;
    $this->dataFields  = null;
    
    $this->tabPanels       = array();
    $this->tabPanelsOrder  = array();
    $this->tabHtmlLink     = array();
    $this->oParent         = null;
    //$this->oSheetsManager  = new AlkSheetsManager($this);
    //$this->oSheetsManager  = new AlkSheetsManager_neodesign($this);
    $this->oSheetsManager = ($manager == null ? new AlkSheetsManager($this) : $manager); 

    $this->cssText      = "txtNormal";
    $this->cssLink      = "linkNormal";
    $this->cssFormLabel = "";
    $this->cssFormCtrl  = "";
    $this->cssHelp      = "txtHelp";
    $this->cssWarning   = "txtWarning";
    $this->cssAdvice    = "txtAdvice";
    $this->cssHelp      = "txtHelp";
    $this->cssStyle     = "";
    $this->cssClass     = "";
    $this->defaultCssFile = array();

    $this->urlBaseImg = ALK_MEDIA_URL."images/";

    $this->bMultiLanguage     = false;
    $this->urlBaseFlag        = ALK_MEDIA_URL."images/";
    $this->bShowMultiLanguage = true;

    $this->tabEvents = array();

    $this->oTemplate       = null;
    $this->strTemplateFile = "";
    
    $this->bSheetVisible = true;
    
    $this->bStyleTitle = true;
  }

  /**
   *  destructeur par défaut
   */
  function __destruct()
  {
  	unset(self::$tabPanelIds[$this->guid]);
  }

  /**
   *  Ajoute une variable globale javascript à l'ensemble
   *        Permet de passer la valeur d'une variable php à une variable js
   * 
   * @param strVarName nom de la variable
   * @param strValue   valeur de la variable
   */
  public function addVarJs($strVarName, $strValue)
  {
    if( !array_key_exists($strVarName, self::$tabVarJs) )
      self::$tabVarJs[$strVarName] = $strValue;
  }

  /**
   *  Ajoute du code javascript au onload du body
   * 
   * @param strCodeJs  code javascript
   */
  public function addOnload($strActionOnload)
  {
    if ( !in_array($strActionOnload, self::$tabOnload) )
      self::$tabOnload[] = $strActionOnload;
  }

  /**
   *  Ajoute du code javascript au onunload du body
   * 
   * @param strCodeJs  code javascript
   */
  public function addOnUnload($strActionOnUnload)
  {
    if ( !in_array($strActionOnUnload, self::$tabOnUnload) )
      self::$tabOnUnload[] = $strActionOnUnload;
  }

  /**
   *  Ajoute du code javascript au formulaire
   * 
   * @param strCodeJs  code javascript
   */
  public function addJs($strCodeJs)
  {
    self::$tabJs[] = $strCodeJs;
  }

  /**
   *  Ajoute une source javascript au formulaire
   *        Se charge de vérifier si le script n'est pas déjà demandé
   *
   * @param strSourceJs  Nom de la source javascript
   * @param strEncoding  Encodage de la source
   * @param bOptimize    =false par défaut, = true pour indiquer que le script est déjà optimisé
   */
  public function addScriptJs($strSourceJs, $strEncoding="", $bOptmize=false)
  {
    $strTmp = mb_ereg_replace("([^_a-zA-Z0-9\%])", "_", $strSourceJs);
    $strTmp = mb_ereg_replace("\\\\", "", $strTmp);
    if( ord(substr($strTmp, 0, 1)) >=48 && ord(substr($strTmp, 0, 1))<=57 )
      $strTmp = "_".$strTmp;
    $strConstJs = mb_strtoupper($strTmp);
    if( !defined($strConstJs) ) {
      define($strConstJs, true);
      self::$tabSrcJs[] = array("src" => $strSourceJs, "charset" => $strEncoding, "optimize" => $bOptmize);
    }
  }

  /**
   * Défini le nom du fichier CSS par défaut qui sera recherché dans les répertoires /classes/form et /styles
   * @param defaultCssFile  le nom du fichier css par défaut sur la classe courante (égal au nom de la classe générique courante)
   */
  public function setDefaultCss($defaultCssFile)
  {
    $this->defaultCssFile[] = $defaultCssFile;
  }
  
  /**
   *  Retourne le code Html d'écriture des CSS et d'inclusion du fichier calendrier.js du calendrier 
   * @return string html
   */
  public function addDefaultCss()
  {
    if( empty($this->defaultCssFile) ) return;
    foreach($this->defaultCssFile as $strCssFile) {
      if( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/".$strCssFile) ){
        $this->addScriptCss(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/".$strCssFile);
      }
      if( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_STYLE.$strCssFile) ){
        $this->addScriptCss($strCssFile);
      }
    }
  }
  
  /**
   * Retourne le code html du code javascript nécessaire au formulaire
   * Cette méthode ne peut être appelée que par AlkHtmlPage et AlkHtmlForm non contenue dans un AlkHtmlPage
   * L'appel de cette fonction vide les tableaux mémorisant les informations à afficher
   * @return Retourne un string
   */
  protected function getHtmlJs()
  {
    if( !$this->isTypeOf(self::ALK_CLASS_HTMLPAGE) && 
        !($this->isTypeOf(self::ALK_CLASS_HTMLFORM) && !$this->isInHtmlPage()) ) {
      return "";
    }
    
    $bMinimize = ( defined("ALK_B_CSSJS_MINIMIZE") && ALK_B_CSSJS_MINIMIZE==true ); 
    $glue = ( !$bMinimize ? "\n" : " " );
    $strHtml = "";

    $strHtmlJs = "";
    if( !empty(self::$tabVarJs) ) {
      foreach(self::$tabVarJs as $strParamName => $strValue) {
        $strHtmlJs .= $glue."var ".$strParamName." = ".$strValue.";";
      }      
      self::$tabVarJs = array();
    }

    if( $strHtmlJs != "" ) {
      $strHtml .= '<script type="text/javascript">'.$strHtmlJs.' </script>';
    }

    $tabFilesJs["_"] = array();
    foreach(self::$tabSrcJs as $tabFileJs) {
      if( !isset($tabFilesJs["_".$tabFileJs["charset"]]) ) {
        $tabFilesJs["_".$tabFileJs["charset"]] = array();
      }
      if( $bMinimize && $tabFileJs["optimize"] == false ) {
        // regroupe les fichiers non optimisés par charset
        $strPathFileJs = str_replace(ALK_ALKANET_ROOT_URL, ALK_ALKANET_ROOT_PATH, str_replace(".js", ".alkmin.js", $tabFileJs["src"]));
        if( !file_exists($strPathFileJs) ) {
          $strPathFileJs = str_replace(ALK_ALKANET_ROOT_URL, ALK_ALKANET_ROOT_PATH, $tabFileJs["src"]);
        }
        $tabFilesJs["_".$tabFileJs["charset"]][] = $strPathFileJs;
      } else {
        // charge les fichiers js déjà optimisé à part
        $strHtml .= '<script type="text/javascript" src="'.$tabFileJs["src"].'" '.
          ( $tabFileJs["charset"] != "" 
            ? 'charset="'.$tabFileJs["charset"].'"' 
            : '' ).
          '></script>';
      }
    } 
    self::$tabSrcJs = array();

    foreach($tabFilesJs as $strKeyCharSet=>$tabFileJs) {
      if( empty($tabFileJs) ) continue;
      sort($tabFileJs);
      $strFilesJs = implode(" ", $tabFileJs);
      $strCharset = substr($strKeyCharSet, 1);
      $strUrlSrc = ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD."cache/".md5($strFilesJs).".js";
      $strPathSrc = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD."cache/".md5($strFilesJs).".js";
      
      if( preg_match("/Win32/", $_SERVER['SERVER_SOFTWARE']) > 0) {
        $strCmd = 'IF NOT EXIST "'.$strPathSrc.'" COPY /B /Y "'.str_replace("/", "\\", str_replace(' ', '" + "', $strFilesJs)).'" "'.str_replace("/", "\\", $strPathSrc).'"';
      } else {
        $strCmd = 'if [ ! -f "'.$strPathSrc.'" ]; then cat '.$strFilesJs.' > '.$strPathSrc.'; fi';
      }
      @shell_exec($strCmd);

      $strHtml .= '<script type="text/javascript" src="'.$strUrlSrc.'" '.
        ( $strCharset != "" 
          ? 'charset="'.$strCharset.'"' 
          : '' ).
        '></script>';
    }

    $strHtmlJs = "";
    if( !empty(self::$tabJs) ) {
      foreach(self::$tabJs as $strSrcJs) {
        $strHtmlJs .= $glue.$strSrcJs;
      }
      self::$tabJs = array();
    }
    
    if( $strHtmlJs != "" ) {
      $strHtml .= '<script type="text/javascript">'.$strHtmlJs.' </script>';
    }
    
    return $strHtml;
  }

  /**
   * Retourne le code html du code Css nécessaire au formulaire
   * L'appel de cette fonction vide les tableaux mémorisant les informations à afficher
   * @return Retourne un string
   */
  protected function getHtmlCss()
  {
  	 if( !$this->isTypeOf(self::ALK_CLASS_HTMLPAGE) && 
        !($this->isTypeOf(self::ALK_CLASS_HTMLFORM) && !$this->isInHtmlPage()) ) {
      return "";
    }
    
    // ordre de chargement des CSS
    $tabOrder = array(ALK_NAVCSS_FF);
    if( !in_array(ALK_NAVCSS, $tabOrder) ) {
      // ajout du niveau de surcharge css
      array_push($tabOrder, ALK_NAVCSS);
    }
    
    $bMinimize = ( defined("ALK_B_CSSJS_MINIMIZE") && ALK_B_CSSJS_MINIMIZE==true ); 
    
    $strHtml = "";
    foreach($tabOrder as $strNavCss) {
      if( isset(self::$tabSrcCss[$strNavCss]) ) {
        foreach(self::$tabSrcCss[$strNavCss] as $strMedia => $tabFileCss) {

          $strHtmlMedia = ( $strMedia != "default"
                            ? ' media="'.$strMedia.'"'
                            : '' );
          
          foreach($tabFileCss as $iKey=>$strFileCss) {
            if( $bMinimize ) {
              $strFileMinCss = ALK_ALKANET_ROOT_PATH.'styles/'.str_replace(".css", ".alkmin.css", $strFileCss);
              if( !file_exists($strFileMinCss) ) {
                $tabFileCss[$iKey] = ALK_ALKANET_ROOT_PATH.'styles/'.$strFileCss;
              } else {
                $tabFileCss[$iKey] = $strFileMinCss;
              }
            } else {
            	$strFileTempCss = ALK_ALKANET_ROOT_PATH.'styles/'.$strFileCss;
                      
              if( file_exists($strFileTempCss) ) {
                $strHtml .= '<link rel="stylesheet" type="text/css" href="'.ALK_ALKANET_ROOT_URL.'styles/'.$strFileCss.'" '.$strHtmlMedia.'/>';
              } else {
                $strHtml .= '<link rel="stylesheet" type="text/css" href="'.$strFileCss.'" '.$strHtmlMedia.'/>';
            	}
            }
          }
          
          if( $bMinimize && !empty($tabFileCss) ) {
            $strFilesCss = implode(" ", $tabFileCss);
            $strUrlSrc = ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD."cache/css/".$strMedia."_".md5($strFilesCss).".css";
            $strPathSrc = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD."cache/css/".$strMedia."_".md5($strFilesCss).".css";
            
            if( preg_match("/Win32/", $_SERVER['SERVER_SOFTWARE']) > 0 ) {
              $strCmd = 'IF NOT EXIST "'.$strPathSrc.'" COPY /B /Y "'.str_replace("/", "\\", str_replace(' ', '" + "', $strFilesCss)).'" "'.str_replace("/", "\\", $strPathSrc).'"';
            } else {
              $strCmd = 'if [ ! -f "'.$strPathSrc.'" ]; then cat '.$strFilesCss.' > '.$strPathSrc.'; fi';
            }
            @shell_exec($strCmd);
  
            $strHtml .= '<link rel="stylesheet" type="text/css" href="'.$strUrlSrc.'" '.$strHtmlMedia.'/>';
          }
        }
      }
    }

    if( !empty(self::$tabCss) || !empty(self::$tabClassCss) ) {
      $strHtml .= '<style type="text/css">';
      foreach(self::$tabCss as $strCss) {
        $strHtml .= $strCss;
      }
      foreach(self::$tabClassCss as $strClass => $strCss) {
        $strHtml .= ' '.$strClass.' { '.$strCss.' } ';
      }
      $strHtml .= ' </style>';
      self::$tabCss = array();
    }

    return $strHtml;
  }
  
  /**
   *  Ajoute du code Css au formulaire
   * 
   * @param strCodeCss  code Css
   */
  public function addCss($strCodeCss)
  {
    self::$tabCss[] = $strCodeCss;
  }

  /**
   *  Ajoute une classe css 
   * @param strClass    entête de déclaration
   * @param strCss      code Css
   */
  public function addClassCss($strClass, $strCss)
  {
    if ( !array_key_exists($strClass, self::$tabClassCss) )
      self::$tabClassCss[$strClass] = "";
    self::$tabClassCss[$strClass] .= $strCss.";";
  }

  /**
   *  Ajoute une source Css au formulaire
   *        Se charge de vérifier si le script n'est pas déjà demandé (pour un même type de navigateur)
   *
   *  strSourceCss  Nom de la source Css
   */
  public function addScriptCss($strSourceCss, $strModeMedia="", $strNavCSS=ALK_NAVCSS_FF)
  {
    $strTmp = mb_ereg_replace("([^_a-zA-Z0-9\%])", "_", $strSourceCss."_".$strNavCSS);
    $strTmp = mb_ereg_replace("\\\\", "", $strTmp);
    if( ord($strTmp[0]) >=48 && ord($strTmp[0])<=57 )
      $strTmp = "_".$strTmp;
    $strConstCss = mb_strtoupper($strTmp);
    if( !defined($strConstCss) ) {
      define($strConstCss, true);
      if( !isset(self::$tabSrcCss[$strNavCSS]) ) {
        self::$tabSrcCss[$strNavCSS] = array("default" => array());
      }
      $strIndex = ( $strModeMedia != "" ? strtolower($strModeMedia) : "default" );
      self::$tabSrcCss[$strNavCSS][$strIndex][] = $strSourceCss;
    }
  }

  /**
   *  Construit un lien, l'ajoute au panel puis retourne une référence sur l'objet créé
   * @param idLink        Identifiant du bouton
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        Texte associé au lien ou à l'image en info-bulle. Utilisé pour définier le nom de l'image en fonction du type
   * @param strToolTip    Texte info bulle
   * @param bInline       =false par défaut, =true si le bouton doit avoir un élément qui le suit sur la même ligne
   * @param strButtonType Type de bouton. =button par défaut. Peut valoir aussi : buttonImg, buttonIcon, buttonPage ou buttonForm
   * @param strTarget     Nom de la fenêtre cible, vide par défaut pour la fenêtre courante
   * @param strPosition   Position du controle si ajouté à un autre controle. = after par défaut. Peut valoir aussi : before.
   * @return AlkHtmlButton
   */
  public function &addButton($idLink, $strLink, $strTxt, $strToolTip="", $bInline=false, 
                             $strButtonType="button", $strTarget="", $strPosition="after", $bAddOnRead=false)
  {
    $strFunction = "getHtml".ucfirst($strButtonType);
    
    $oLink = AlkHtmlFactory::$strFunction($strLink, $strTxt, $strToolTip, $bInline, $strTarget);
        
    $oLink->setName($idLink);
    //$oLink->position = $strPosition;
    $this->tabHtmlLink[] = $oLink;
    return $oLink;
  }

  /**
   *  Construit un lien de type Form, l'ajoute au panel puis retourne une référence sur l'objet créé
   * @param idLink        Identifiant du bouton
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        Texte associé au lien ou à l'image en info-bulle. Utilisé pour définier le nom de l'image en fonction du type
   * @param strToolTip    Texte info bulle
   * @param bInline       =false par défaut, =true si le bouton doit avoir un élément qui le suit sur la même ligne
   * @param strTarget     Nom de la fenêtre cible, vide par défaut pour la fenêtre courante
   * @param strPosition   Position du controle si ajouté à un autre controle. = after par défaut. Peut valoir aussi : before.
   * @return AlkHtmlButtonForm
   */
  public function &addButtonForm($idLink, $strLink, $strTxt, $strToolTip="", $bInline=false, $strTarget="", $strPosition="after", $bAddOnRead=false)
  {
    return $this->addButton($idLink, $strLink, $strTxt, $strToolTip, $bInline, "buttonForm", $strTarget, $strPosition, $bAddOnRead);
  }

  /**
   *  Construit un lien de type Page, l'ajoute au panel puis retourne une référence sur l'objet créé
   * @param idLink        Identifiant du bouton
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        Texte associé au lien ou à l'image en info-bulle. Utilisé pour définier le nom de l'image en fonction du type
   * @param strToolTip    Texte info bulle
   * @param bInline       =false par défaut, =true si le bouton doit avoir un élément qui le suit sur la même ligne
   * @param strTarget     Nom de la fenêtre cible, vide par défaut pour la fenêtre courante
   * @param strPosition   Position du controle si ajouté à un autre controle. = after par défaut. Peut valoir aussi : before.
   * @return AlkHtmlButtonPage
   */
  public function &addButtonPage($idLink, $strLink, $strTxt, $strToolTip="", $bInline=false, $strTarget="", $strPosition="after", $bAddOnRead=false)
  {
    return $this->addButton($idLink, $strLink, $strTxt, $strToolTip, $bInline, "buttonPage", $strTarget, $strPosition, $bAddOnRead);
  }

  /**
   *  Construit un lien de type Icon, l'ajoute au panel puis retourne une référence sur l'objet créé
   * @param idLink        Identifiant du bouton
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        Texte associé au lien ou à l'image en info-bulle. Utilisé pour définier le nom de l'image en fonction du type
   * @param strToolTip    Texte info bulle
   * @param bInline       =false par défaut, =true si le bouton doit avoir un élément qui le suit sur la même ligne
   * @param strTarget     Nom de la fenêtre cible, vide par défaut pour la fenêtre courante
   * @param strPosition   Position du controle si ajouté à un autre controle. = after par défaut. Peut valoir aussi : before.
   * @return AlkHtmlButtonIcon
   */
  public function &addButtonIcon($idLink, $strLink, $strTxt, $strToolTip="", $bInline=false, $strTarget="", $strPosition="after", $bAddOnRead=false)
  {
    return $this->addButton($idLink, $strLink, $strTxt, $strToolTip, $bInline, "buttonIcon", $strTarget, $strPosition, $bAddOnRead);
  }

  /**
   *  Construit un lien de type Icon, l'ajoute au formulaire puis retourne une référence sur l'objet créé
   * @param idLink        Identifiant du bouton
   * @param strlink       Lien placé sur le texte ou l'image
   * @param strTxt        url complète de l'image avec extension ou nom de l'image avec extension (présent dans le répertoire urlBaseImg)
   * @param strToolTip    Texte info bulle
   * @param iWidth        largeur de l'image, =vide par défaut (automatiquement détecté)
   * @param iHeight       hauteur de l'image, =vide par défaut (automatiquement détecté)
   * @param bInline       =false par défaut, =true si le bouton doit avoir un élément qui le suit sur la même ligne
   * @param strTarget     Nom de la fenêtre cible, vide par défaut pour la fenêtre courante
   * @param strPosition   Position du controle si ajouté à un autre controle. = after par défaut. Peut valoir aussi : before.
   * @return AlkButtonImg
   */
  public function &addButtonImg($idLink, $strLink, $strTxt, $strToolTip, $iWidth="", $iHeight="", $bInline=false, 
                                $strTarget="", $strPosition="after", $bAddOnRead=false)
  {
    $oLink = AlkHtmlFactory::getHtmlButtonImg($strLink, $strTxt, $strToolTip, $iWidth, $iHeight, $bInline, $strTarget, $strPosition, $bAddOnRead);
        
    $oLink->setName($idLink);
    //$oLink->position = $strPosition;
    $this->tabHtmlLink[] = $oLink;
    return $oLink;
  }

  /** 
   *  Affecte un template à l'objet
   * 
   * @param strAppliPath     nom du répertoire de l'appli utilisant le template pour former le chemin ../[strPathAppli]/templates
   * @param strTemplateFile  nom du fichier xxx.tpl
   */
  public function setTemplate($strPathAppli, $strTemplateFile)
  {
    $this->oTemplate =& AlkFactory::getTemplate();
    $this->oTemplate->assign('alkRootTemplate', ALK_ROOT_TEMPLATE);
    if($strPathAppli == ALK_ROOT_TEMPLATE){
      $this->strTemplateFile = ALK_ALKANET_ROOT_PATH.ALK_ROOT_TEMPLATE.$strTemplateFile;
    }else{
      $this->strTemplateFile = ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."".$strPathAppli."/templates/".$strTemplateFile;
    }
  }
  
  /**
   *  Assigne une valeur de variable au template de l'objet (s'il existe)
   * @param var_name    Nom de la variable de template à assigner
   * @param var_value   Valeur de la variable de template à assigner
   * @return boolean : assignation effectuée (si template existe)
   */
  public function assign($vars_name, $var_value)
  {
    if ( is_null($this->oTemplate) )
      return false;
    $this->oTemplate->assign($vars_name, $var_value);
    return true;
  }

  /**
   *  Assigne une valeur d'objet au template de l'objet (s'il existe)
   * @param var_name    Nom de la variable de template à assigner
   * @param var_value   Valeur de la variable de template à assigner
   * @return boolean : assignation effectuée (si template existe)
   */
  public function assignByRef($vars_name, $var_value)
  {
    if ( is_null($this->oTemplate) )
      return false;
    $this->oTemplate->assign_by_ref($vars_name, $var_value);
    return true;
  }
  
  /**
   *  Assigne au template de l'objet (s'il existe) la valeur de l'attribut d'objet demandé (valeur scalaire ou tableau)
   * @param attribute  Nom de l'attribut de l'objet à assigner
   * @return boolean : assignation effectuée (si template existe)
   */
  public function assignOnThis($attribute)
  {
    if ( is_null($this->oTemplate) )
      return false;
    $this->oTemplate->assign($attribute, $this->$attribute);
    return true;
  }

  /**
   *  Assigne au template de l'objet (s'il existe) la valeur de l'attribut d'objet demandé (objet)
   * @param attribute  Nom de l'attribut de l'objet à assigner
   * @return boolean : assignation effectuée (si template existe)
   */
  public function assignByRefOnThis($attribute)
  {
    if ( is_null($this->oTemplate) )
      return false;
    $this->oTemplate->assign_by_ref($attribute, $this->$attribute);
    return true;
  }

  /**
   *  Ajoute un événement dans la liste
   * 
   * @param strEvent      Nom de l'événement
   * @param strFunctionJS Nom de la fonction javascript appelée (pas nécessaire d'ajouter 'javascript:')
   */
  public function addEvent($strEvent, $strFunctionJS)
  {
    $_strEvents = mb_strtolower($strEvent);
    if ($_strEvents=="onload"){
      $this->addOnload($strFunctionJS);
      return;
    }
    if ( array_key_exists($_strEvents, $this->tabEvents) ){
      $this->tabEvents[$_strEvents] .= ";".$strFunctionJS;
    } else {
      $this->tabEvents[$_strEvents] = $strFunctionJS;
    }
  }

  /**
   *  Genere puis retourne tous les evenements liés au controle html
   *
   * @return Retourne les événements concaténés dans une chaine pour être inclus dans
   *         dans un tag html de type controle de saisie
   */
  protected function getHtmlEvent()
  {
    $strHtml = "";

    foreach($this->tabEvents as $strEvent => $strFunctionJs)
      $strHtml .= " ".$strEvent."=" .
        ( substr($strFunctionJs, 0, 6) !="return" && substr($strFunctionJs, 0, 11) !="javascript:" 
          ? "\"javascript:".$strFunctionJs."\""
          : "\"".$strFunctionJs."\"");
      
    if ( $this->isTypeOf(self::ALK_CLASS_HTMLPAGE)){
      if ( !empty(self::$tabOnload) ){
        $strHtml .= " onload=\"javascript:";
        foreach(self::$tabOnload as $strFunctionJs)
          $strHtml .= $strFunctionJs.";";
        $strHtml .= "\"";
      }
      if ( !empty(self::$tabOnUnload) ){
        $strHtml .= " onunload=\"javascript:";
        foreach(self::$tabOnUnload as $strFunctionJs)
          $strHtml .= $strFunctionJs.";";
        $strHtml .= "\"";
      }
    }
    return $strHtml;
  }

  /**
   *  Retourne le code html l'entête du formulaire
   *
   * @return Retourne un string
   */
  protected function getHtmlHeader()
  {
    $strHtml = "<div id='".$this->guid."' ".
      $this->getHtmlEvent().
      ($this->cssStyle!="" ? " style='".$this->cssStyle."'" : "").
      ($this->cssClass!="" ? " class='".$this->cssClass."'" : "").">";
    return $strHtml;
  }

  /**
   *  Retourne le code html de la fin du formulaire
   *
   *  Retourne un string
   */
  protected function getHtmlFooter()
  {
    return "</div>";
  }

  /**
   *  Retourne le code html de la fin du formulaire
   *
   *  Retourne un string
   */
  public function getHtmlButtons()
  {
    $strHtml = "";
    if( !empty($this->tabHtmlLink) ) {
      $strHtml .= '<div class="buttons">';
      foreach($this->tabHtmlLink as $oLink) {
        $strHtml .= $oLink->getHtml();
      }
      $strHtml .= '</div>';
    }
    return $strHtml;
  }

  /**
   *  Retourne le code html de la fin du formulaire
   *
   *  Retourne un string
   */
  protected function getHtmlLabel()
  {
    $strTxt = $this->getLabel();
    if( $strTxt=="" ) return "";
    return ($this->bStyleTitle ? '<div align="center" class="txtTitlePage">'.$strTxt.'</div>' : $strTxt);
  }

  /**
   *  Retourne le code html de la fin du formulaire
   *
   *  Retourne un string
   */
  protected function getHtmlLabelDesc()
  {
    $strTxt = $this->getLabelDesc();
    if( $strTxt=="" ) return "";
    return "<div align='center' class='txtAdvice'>".$strTxt."</div>";
  }

  /**
   *  Retourne le code html de la fin du formulaire
   *
   *  Retourne un string
   */
  protected function getHtmlLabelWarning()
  {
    $strTxt = $this->getLabelWarning();
    if( $strTxt=="" ) return "";
    return '<div align="center" class="txtWarning">'.$strTxt.'</div>';
  }

  /**
   *  Retourne le code html du panel
   * @return string html
   */
  public function getHtml()
  {
    $this->addDefaultCss();
    if ( !$this->bIsInit )
      $this->initialize();
 
    $strHtml = "";
    if( $this->strTemplateFile == "" ) {
      
      // retourne le html des titres de panels
      $strHtml .= $this->getHtmlLabel();
      $strHtml .= $this->getHtmlLabelDesc();
      $strHtml .= $this->getHtmlLabelWarning();
      
      // retourne le html des différents panels ajoutés
      $strHtml .= $this->getHtmlPanels();
      
      // retourne les onglets et le contenu des onglets
      $strHtml .= $this->getHtmlSheets();
      
      // retourne le html des différents boutons ajoutés
      $strHtml .= $this->getHtmlButtons();
      
      $strHtml .= $this->getHtmlFooter();
      
      $strHtml = $this->getHtmlHeader().$strHtml;
      
    } else {
      // assignation du sheet manager
      $this->oTemplate->assign("sheetManager", $this->getHtmlSheets());

      $this->oTemplate->assign("title",   $this->getLabel());
      $this->oTemplate->assign("desc",    $this->getLabelDesc());
      $this->oTemplate->assign("warning", $this->getLabelWarning());

      $this->oTemplate->assign("panels_list",  array_keys($this->tabPanels));
      // assignation des sous panels
      foreach($this->tabPanels as  $guid => $oPanel) {
        $this->oTemplate->assign($guid,  $oPanel->getHtml());
      }

      $this->oTemplate->assign("links_list",  array_keys($this->tabHtmlLink));
      // assignation des boutons
      foreach($this->tabHtmlLink as $oLink) {
        $this->oTemplate->assign($oLink->getName(), $oLink->getHtml());
      }

      // assignation de l'objet Panel
      $this->oTemplate->assign_by_ref("oPanel", $this);

      $strHtml .= $this->oTemplate->fetch($this->strTemplateFile);
      $strHtml .= $this->getHtmlFooter();

      $strHtml = $this->getHtmlHeader().$strHtml;
    }

    return $strHtml;
  }

  /**
   *  Retourne le code html des onglets
   * @return string html
   */
  protected function getHtmlSheets()
  {
    return $this->oSheetsManager->getHtml();
  }

  /**
   *  Retourne le code html des panels intégrés
   * @return string html
   */
  protected function getHtmlPanels()
  {
    $strHtml = "";
    asort($this->tabPanelsOrder, SORT_NUMERIC);
    foreach ($this->tabPanelsOrder as $name=>$index){
      $oPanel = $this->tabPanels[$name];
      $strHtml .= $oPanel->getHtml();
    }
    return $strHtml;
  }
  
  /**
   *  Evalue l'ajout d'un objet de la hiérarchie panel au tableau de panels courant
   * 
   * @param  oPanel   Objet de type panel que l'on souhaite ajouter au tableau des panels
   * @return boolean
   */
  static protected function hasSameType($oObject)
  {
    $type = self::ALK_CLASS_HTMLPANEL;
    return (get_class($oObject)==$type) || $oObject->isTypeOf($type);    
  } 
  
  /**
   *  Détermine le panel conteneur de l'objet
   * 
   * @param  oParent   Panel conteneur
   * @return boolean : affectation réussie (pas de boucle circulaire)
   */
  protected function setParent($oParent)
  {
    if ( $this->isParentOf($oParent) )
      return false;
    if ( !is_null($this->oParent) && $this->oParent->guid!=$oParent->guid )
      $this->oParent->removePanel($this);
    $this->oParent = $oParent;
    return true;
  } 
  
  /**
   *  Détermine si le panel conteneur ne fait pas parti des contenus (aussi profond qu'il le faut) de l'objet courant
   * 
   * @param  oPanel   Panel contenu
   * @return boolean : true si boucle circulaire
   */
  protected function isParentOf($oPanel)
  {
    $bFound = false;
    foreach ($this->tabPanels as $oChild){
      if ( $oChild->getGUID() == $oPanel->getGUID() )
        return true;
      $bFound |= $oChild->isParentOf($oPanel);
      if ( $bFound ) break;
    }
    return $bFound;
  } 
  
  /**
   *  Détermine si le panel donné est dans la liste des contenus de l'objet courant
   * 
   * @param  oPanel   Panel contenu
   * @return boolean : true si boucle circulaire
   */
  public function isInHtmlForm()
  {
    if ( is_null($this->oParent) )
      return is_subclass_of($this, self::ALK_CLASS_HTMLFORM);
    return is_subclass_of($this, self::ALK_CLASS_HTMLFORM) || $this->oParent->isInHtmlForm();
  } 
  
  /**
   *  Détermine si le panel donné est dans la liste des contenus de l'objet courant
   * 
   * @param  oPanel   Panel contenu
   * @return boolean : true si boucle circulaire
   */
  public function isInHtmlPage()
  {
    if ( is_null($this->oParent) )
      return is_subclass_of($this, self::ALK_CLASS_HTMLPAGE);
    return is_subclass_of($this, self::ALK_CLASS_HTMLPAGE) || $this->oParent->isInHtmlPage();
  }  
  
  /**
   *  Evalue l'ajout d'un objet de la hiérarchie panel au tableau de panels courant
   * 
   * @param  oPanel   Objet de type panel que l'on souhaite ajouter au tableau des panels
   * @return boolean
   */
  protected function canAddPanel($oPanel)
  {
    return !$oPanel->isTypeOf(self::ALK_CLASS_HTMLCTRL) || $oPanel->isTypeOf(self::ALK_CLASS_HTMLCOMPONENT);    
  } 
  
  protected function checkSheetVisibility(AlkHtmlPanel $oPanel)
  {
    $this->bSheetVisible &= $oPanel->getSheetVisible();
  }
  
  /**
   *  Ajoute un objet de type panel (ou dérivé) au tableau des panels
   * @return boolean : ajout effectué
   */
  public function addPanel($oPanel)
  {
    if ( is_null($oPanel) ) return false;
    if ( AlkHtmlPanel::hasSameType($oPanel) && $this->canAddPanel($oPanel)){
      if ( $oPanel->setParent($this) ){
        $this->tabPanels[$oPanel->guid] =& $oPanel;
        $this->checkSheetVisibility($oPanel);
        if ( !array_key_exists($oPanel->guid, $this->tabPanelsOrder) ){
          $cpt = count($this->tabPanelsOrder);
          $this->tabPanelsOrder[$oPanel->guid]  = $cpt;
        } 
      }
      else {
        $this->triggerError("class ".get_class($this)."::".__FUNCTION__.
                            " : Erreur de boucle circulaire => Ne peut pas ajouter l'objet d'identifiant [".
                            $oPanel->guid."]", E_USER_ERROR);
        return false;
      }
      $oPanel->setInializationProperties($this->getInitMode(), $this->getDataFields(), $this->getObjData());
      return true;
    }
    $this->triggerError("class ".get_class($this)."::".__FUNCTION__.
                        " : Erreur de typage de l'élément ajouté => Ne peut pas ajouter l'objet d'identifiant [".
                        $oPanel->guid."] car est de type [".get_class($oPanel)."]", E_USER_ERROR);    
    return false;
  }
  
  /**
   *  Ajoute un objet de type panel (ou dérivé) au tableau des panels
   * @return boolean : ajout effectué
   */
  public function removePanel(&$oPanel)
  {
    if ( array_key_exists($oPanel->guid, $this->tabPanels) ){
      unset($this->tabPanels[$oPanel->guid]);
      unset($this->tabPanelsOrder[$oPanel->guid]);
      $oPanel->oParent = null;
      return true;
    }
    return false;
  }
  
  /**
   *  Ajoute et créé un onglet au panel
   * @param idSheet    Identifiant de l'onglet
   * @param sheetLabel titre de l'onglet
   * @param oUrl       url sur l'onglet, chaine vide pour sélection par javascript
   *                   tableau associatif pour construire le token vers alkanet.php. le tableau doit comporter bPopup=true pour 
   *                   appeler alkanet_popup.php
   * @param iTypeSheet type d'onglet, =0 par défaut
   * @return null ou AlkHtmlSheet
   */
  public function addSheet($idSheet, $sheetLabel, $oUrl="", $iTypeSheet=0)
  {
    $oSheet = new AlkHtmlSheet($this, $idSheet, $sheetLabel, $oUrl);
    if ( $this->oSheetsManager->addSheet($oSheet, $iTypeSheet) ){
      $oSheet->setInializationProperties($this->getInitMode(), $this->getDataFields(), $this->getObjData());
      return $oSheet;
    }
    return null;
  }
  /**
   *  Supprime un onglet du panel
   * @param idSheet    Identifiant de l'onglet
   * @param iTypeSheet type d'onglet, =0 par défaut
   * @return boolean  : suppression réussie
   */
  public function removeSheet($idSheet, $iTypeSheet=0)
  {
    return $this->oSheetsManager->removeSheet($idSheet, $iTypeSheet=0);
  }
  
  /**
   *  sélectionne un onglet donné par son identifiant
   * @param idSheet    Identifiant de l'onglet
   * @param iTypeSheet type d'onglet, =0 par défaut
   */
  public function setSelectedSheetByGUID($idSheet, $iTypeSheet=0)
  {
    $this->oSheetsManager->setSelectedSheetByGUID($idSheet, $iTypeSheet);
  }

  /**
   *  Renvoie un identifiant unique pour les nom de type <name>[] (liste de controle)
   * @param name    Nom initialement donné
   * 
   * @return string identifiant unique en cas de liste ou nom donné en entrée
   */
  protected function getGUIDForName($name)
  {
    $guid = preg_replace("!\[([^]]+)\]!usi", "_$1", $name);
    $guid = preg_replace("!\.!usi", "_$1", $guid);
    if ( $guid!=$name ){
      if ( preg_match("!\[!usi", $guid) )
        return $this->getGUIDForName($guid);
      return $guid;
    }
    $tabMatch = array();
    $bListe = preg_match("!\[!usi", $name);
    
    if ( $bListe ){
      $countItem = 0;
      foreach (self::$tabPanelIds as $panelId){
        if ( preg_match("!".preg_replace("!\[[^]]*\]!usi", "", $name)."_\d+!usi", $panelId) )
          $countItem++;
      }
      $guid = preg_replace("!\[[^]]*\]!usi", "", $name)."_".$countItem;
      if ( $guid!=$name ){
        if ( preg_match("!\[!usi", $guid) )
          return $this->getGUIDForName($guid);
        return $guid;
      }
    }
    return $name;
  }
  
  /**
   *  Vérifie l'unicité de l'identifiant dans l'exécution de la page
   * @param identifiant    Identifiant (unique en cas de listes) à vérifier
   * @param name           Nom / Identifiant à vérifier
   * @param iError  Erreur à lever. Si -1 pas d'erreur levée
   * 
   * @return boolean  identifiant accepté
   */
  protected function checkName($identifiant, $name, $iError=-1)
  {
    if ( $identifiant!="" && self::$bUniqueName && in_array($identifiant, self::$tabPanelIds) ){
      if ($iError!=-1)
        $this->triggerError("class ".get_class($this)."::".__FUNCTION__.
                            ($this->name!="" ? "[current_id=".$this->name." ]" : "").
                            " => un objet d'identifiant '".$name."' existe déjà dans la page" .
                            "<br>".print_r(self::$tabPanelIds, true), 
                            E_USER_ERROR);
      return false;
    }
    return true;
  }
  
  /**
   *  initialise le panel
   */
  protected function initialize()
  {
    if ($this->bIsInit) return;
    $this->bIsInit = true;
    
    switch ($this->initMode){
    case ALK_INIT_MODE_DATASET :
      $this->initializeByDataset();
      break;
      
    case ALK_INIT_MODE_DATAROW :
      $this->initializeByDatarow();
      break;
      
    case ALK_INIT_MODE_REQUEST :
      $this->initializeByRequest();
      break;
      
    case ALK_INIT_MODE_DEFAULT : 
    default : 
      break;
    }
    
    foreach ($this->tabPanels as $oPanel){
      $oPanel->initialize();
    }
  }
  
  /**
   *  Methode virtuelle : initialise le panel à partir des requests
   */
  protected function initializeByRequest() { }
  
  /**
   *  Methode virtuelle : initialise le panel à partir d'un dataset
   */
  protected function initializeByDataset() { }
  
  /**
   *  Methode virtuelle : initialise le panel à partir d'un datarow
   */
  protected function initializeByDatarow() { }
  
  /**
   *  Détermine les propriétés d'initialisation
   * @param initMode    Mode d'initialisation
   * @param dataFields  Informations d'interrogation de la donnée d'initialisation
   * @param oData       Données d'initialisation
   */
  public function setInializationProperties($initMode, $dataFields, $oData=null)
  {
    switch ($initMode){
    case ALK_INIT_MODE_DATASET :
      if ( !( !is_null($oData) && $oData->isTypeOf("alkds") ) ){
        $this->triggerError("class ".get_class($this)."::".__FUNCTION__.
                            ($this->name!="" ? "[current_id=".$this->name."]" : "").
                            "=> initialisation en mode Dataset avec des données de type non Dataset",
                            E_USER_ERROR);
      }
      if ( !(is_array($dataFields) && !empty($dataFields)) ){
        $this->triggerError("class ".get_class($this)."::".__FUNCTION__.
                            ($this->name!="" ? "[current_id=".$this->name."]" : "").
                            "=> initialisation en mode Dataset avec un dataFields mal typé (tableau non vide)",
                            E_USER_ERROR);
      }
      break;
      
    case ALK_INIT_MODE_DATAROW :
      if ( !( !is_null($oData) && $oData->isTypeOf("alkdr") ) ){
        $this->triggerError("class ".get_class($this)."::".__FUNCTION__.
                            ($this->name!="" ? "[current_id=".$this->name."]" : "").
                            "=> initialisation en mode Datarow avec des données de type non Datarow",
                            E_USER_ERROR);
      }
      /*if ( !(is_string($dataFields) && $dataFields!="") ){
          $this->triggerError("class ".get_class($this)."::".__FUNCTION__.
                              ($this->name!="" ? "[current_id=".$this->name."]" : "").
                              "=> initialisation en mode Datarow avec un dataFields mal typé (chaine non vide)",
                              E_USER_ERROR);
        }*/
      break;
      
    case ALK_INIT_MODE_REQUEST :
      $tabReqMethod = array(REQ_GET, REQ_POST, REQ_GET_POST, REQ_POST_GET);
      if ( !in_array($dataFields["reqMethod"], $tabReqMethod) ){
        $this->triggerError("class ".get_class($this)."::".__FUNCTION__.
                            ($this->name!="" ? "[current_id=".$this->name."]" : "").
                            "=> initialisation en mode Request avec un dataFields non égal aux constantes de REQUEST",
                            E_USER_ERROR);
      }
      break;
      
    case ALK_INIT_MODE_DEFAULT :
      break;
    default : return false;
    }
    if ( $this->setInitMode($initMode) ){
      $this->setDataFields($dataFields);
      $this->setObjData($oData);
    }
    return true;
  }
  
  /**
   *  Détermine l'égalité entre cet objet et celui passé en paramètre
   * 
   * @param  oObject  AlkObject Objet à comparer
   * @return boolean : les deux objets sont égaux 
   */
  public function equals(AlkObject $oObject)
  {
    return ( get_class($this)==get_class($oObject) ) && ( $this->getGUID() == $oObject->getGUID() );
  }
  
  /**
   *  Extrait le (prochain) type d'initialisation en fonction d'une combinaison des modes d'initialisation
   *        Ordre d'extraction : ALK_INIT_MODE_DATASET --> ALK_INIT_MODE_DATAROW --> ALK_INIT_MODE_REQUEST
   *        Si -1 retourne -1;
   * 
   * @param & iTypeInit   Combinaison des modes d'initialisation 
   * 
   * @return prochaine étape d'initialisation parmi les constantes ALK_INIT_MODE ou -1
   * @reference Supprime l'étape d'initialisation retournée de la combinaison
   */
  protected function getTypeInit(&$iTypeInit)
  {
    $initModeReturn = -1;
    $tabEtapes = array( ALK_INIT_MODE_DEFAULT, ALK_INIT_MODE_DATASET, ALK_INIT_MODE_DATAROW, ALK_INIT_MODE_REQUEST );
    foreach ($tabEtapes as $iEtape) {
      if ( ($iTypeInit & $iEtape) == $iEtape ){
        $initModeReturn = $iEtape;
        $iTypeInit = ($iTypeInit-$initModeReturn);
        return $initModeReturn;
      }
    }
    return $initModeReturn;
  }

  /* --------------------------------
   * accesseurs
   * --------------------------------*/
  
  /**
   *  change le identifiant/nom du panel
   * @param name            Nouvel identifiant
   * @param bTriggerError   boolean : Leve une erreur si non unicité de nouveau nom
   * @return boolean : changement effectué
   */
  public function setName($name, $bTriggerError=false)
  {
    /* necéssaire pour  pas utiliser */
    $this->name = $name;
    return true;
    /* TODO à confirmer : ne pas effacer
    $iError = ($bTriggerError ? "-1" : E_USER_ERROR);
    
    $guid = $this->getGUIDForName($name);
    if ( $this->checkName($guid, $name, $iError) ){
      $oldName = $this->name;
      unset(self::$tabPanelIds[$this->guid]);
      $this->name = $name;
      self::$tabPanelIds[$guid] = $guid;
      
      if ( !is_null($this->oParent) ){
        $this->oParent->tabPanels[$this->guid] = $this->oParent->tabPanels[$oldName];
        $this->oParent->tabPanelsOrder[$this->guid] = $this->oParent->tabPanelsOrder[$oldName];
        unset($this->oParent->tabPanels[$oldName]);
        unset($this->oParent->tabPanelsOrder[$oldName]);
      }
      return true;
    }
    return false; */
  }  
  
  /**
   *  retourne le identifiant/nom du panel
   * @return string  
   */
  public function getName()
  {
    return $this->name; 
  } 
  
  /**
   *  retourne le identifiant du panel
   * @return string  
   */
  public function getGUID()
  {
    return $this->guid; 
  } 

  /**
   *  change le titre du panel
   * @return boolean : changement effectué
   */
  public function setTitle($title)
  {
    $this->title = $title; 
    return true;
  } 
  
  /**
   *  change le label du panel
   * @return boolean : changement effectué
   */
  public function setLabel($label)
  {
    $this->label = $label; 
    return true;
  }  

  /**
   *  change le identifiant/nom du panel
   * @return boolean : changement effectué
   */
  public function setLabelDesc($strHtml)
  {
    $this->labelDesc = $strHtml; 
    return true;
  } 
 
  /**
   *  change le identifiant/nom du panel
   * @return boolean : changement effectué
   */
  public function setLabelWarning($strHtml)
  {
    $this->labelWarning = $strHtml; 
    return true;
  }  
  
  /**
   *  retourne le label d'un ctrl
   *        ce champ correspond également au titre de formulaire
   * @return string 
   */
  public function getLabel()
  {
    return $this->label; 
  }  
  
  /**
   *  retourne le titre.
   *        ce champ est utilisé pour les titres de popup et de bloc.
   *        le titre de formulaire est label
   * @return string 
   */
  public function getTitle()
  {
    return $this->title;
  }  

  /**
   *  retourne le label conseil
   * @return string
   */
  public function getLabelDesc()
  {
    return $this->labelDesc; 
  } 
 
  /**
   *  retourne le label warning
   * @return string
   */
  public function getLabelWarning()
  {
    return $this->labelWarning; 
  }  
  
  /**
   * Mémorise le nom de la classe de style sur le lien
   * @param cssLink  nom de la classe css
   */
  public function setCssLink($cssLink)
  {
    $this->cssLink = $cssLink;
  }
  
  /**
   * Retourne le nom de la classe de style sur le lien
   * @return string
   */
  public function getCssLink()
  {
    return $this->cssLink;
  }
  
  /**
   *  change le mode d'intialisation
   * @return boolean : changement effectué
   */
  public function setInitMode($iInitMode)
  {
    if ( true ){ /*TODO choisir entre true et $this->initMode == ALK_INIT_MODE_DEFAULT*/
      $this->initMode = $iInitMode;
      foreach ($this->tabPanels as $oPanel){
        $oPanel->setInitMode($iInitMode);
      }
      return true; 
    }
    return false;
  }  
  
  /**
   *  retourne le mode d'initialisation
   * @return int parmi constantes ALK_INIT_MODE 
   */
  public function getInitMode()
  {
    return $this->initMode; 
  }  
  
  /**
   *  Affecte les données d'initialisation
   * @param oData AlkObject Données d'initialisation
   * @return boolean : changement effectué
   */
  protected function setObjData($oData)
  {
    if ( true ){
      $this->oData = $oData;
      foreach ($this->tabPanels as $oPanel){
        $oPanel->setObjData($oData);
      }
      return true;
    }
    return false;
  }
  
  /**
   *  Retourne les données d'initialisation
   * @return AlkObject ou null
   */
  public function getObjData()
  {
    return $this->oData; 
  }

  /**
   *  Affecte les informations d'interrogation de la donnée d'initialisation
   * @param dataFields  informations d'interrogation de la donnée d'initialisation
   * @return boolean : changement effectué
   */
  public function setDataFields($dataFields)
  {
    if ( is_null($this->dataFields) ){
      $this->dataFields = $dataFields;
      
      if ( $this->getInitMode()!=ALK_INIT_MODE_DATAROW ){
        foreach ($this->tabPanels as $oPanel){
          $oPanel->setDataFields($dataFields);
        }
      }
      
      return true;
    }
    return false;
  }
 
  /**
   *  Retourne les informations d'interrogation de la donnée d'initialisation
   * @return string ou array ou null
   */
  public function getDataFields()
  {
    return $this->dataFields; 
  }
  
  /**
   *  retourne le panel parent 
   * 
   * @return AlkHtmlPanel ou null
   */
  public function getParent()
  {
    return $this->oParent;
  }
 
  /**
   *  Retourne la valeur de l'attribut bMultiLanguage
   * @return boolean
   */
  public function getBMultiLanguage()
  {
    return $this->bMultiLanguage; 
  }
  
  /**
   *  Affecte l'attribut bMultiLanguage
   * 
   * @return boolean : affectation réussie
   */
  public function setBMultiLanguage($bMultiLanguage)
  {
    $this->bMultiLanguage = $bMultiLanguage;
    return true;
  }
  
  /**
   * Lit un fichier d'aide puis retourne son contenu
   * @param strPathFileName  chemin et nom du fichier d'aide
   * @return string
   */
  protected function readHelp($strPathFileName)
  {
   /* 
   //Retourne le contenu du fichier d'aide 
    ob_start();
    readfile($strPathFileName);
    $strHtmlHelp = ob_get_contents();
    ob_end_clean();*/
    
    // retourne l'url du fichier d'aide
    if(defined("ALK_B_WIKIDIST_HELP") && ALK_B_WIKIDIST_HELP){
      $oAppliWiki = AlkFactory::getAppli(ALK_ATYPE_ID_WIKIDIST);
      $strUrlHelp = ALK_ALKANET."?token=".$oAppliWiki->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_FORM, ALK_SHEET_NONE, "&applitype_id=".ALK_ATYPE_ID_WIKIDIST."&pageTitle=".$this->oAppli->getHelp());
   
    }else{
      $strUrlHelp = "..".mb_substr($strPathFileName, mb_strlen(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE));
       
    }
    return $strUrlHelp;
  }
  
  /**
   * Retourne le code html de l'aide associée au panel courant
   * @return string
   */
   public function getHelp()
   {
      return "";
   }
   
  /**
   * Retourne le code html de l'aide associée au panel courant
   * @return string
   */
   public function getSheetVisible()
   {
      return $this->bSheetVisible;     
   }
  /**
   * Retourne le code html de l'aide associée au panel courant
   * @return string
   */
   public function setSheetVisible($bVisible, $bPropagate=false)
   {
      $this->bSheetVisible = $bVisible;
      $this->oSheetsManager->setVisible($bVisible);
      if ($bPropagate && !is_null($this->oParent)){     
        $this->oParent->setSheetVisible($bVisible, $bPropagate);
      }
   } 
   
   /**
    * Défini si le label (=contenu) du panel doit être affiché comme un titre de page ou pas (aucun style appliqué)
    * @param bStyleTitle Boolean
    */  
  public function setIsStyleTitle($bStyleTitle)
  {
    $this->bStyleTitle = $bStyleTitle;
  }
  
  /**
   * Définition d'un nouveau sheetmanager
   */
  public function setSheetsManager($manager)
  {
  	$this->oSheetsManager = $manager;
  }
}

?>