<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlSelect
 * 
 * Classe d'affichage d'un composant de saisie selection.
 *        génère : <select ></select>
 */
class AlkHtmlSelect extends AlkHtmlCtrl
{
  /** hauteur de la liste sélection ou =1 pour un combobox */
  protected $size;

  /** largeur en pixels du controle */
  protected $widthSelect;
  protected $widthOption;

  /** association (valeur par défaut, texte) inscrit en premier dans la liste */
  protected $tabValTxtDefault;

  /** association (valeur par défaut, texte) inscrit en dernier dans la liste */
  protected $tabValTxtLast;

  /** liste des couples (Valeur, Texte) */
  protected $tabValTxt;

  /** object contenant la liste des couples (texte, valeur) contenant un iterateur getRowIter() */
  protected $oValTxt;

  /** Nom du champ de BD permettant la lecture de la valeur dans le dataset */
  protected $strFieldValue;

  /** Nom du champ de BD permettant la lecture du texte dans le dataset */
  protected $strFieldText;

  /** =vrai si selection multiple, =faux par défaut */
  protected $bMultiple;

  /** =vrai si suppression automatique du premier caractère pour les clés numériques contenus dans les tableaux */
  /** utile car php ne maintient pas les clés numériques pour un tableau associatif */
  protected $bSuppFirstCharId;
  
  /** =vrai si ajout de l'attribut "title" sur les options contenant le texte de chaque option, =faux par défaut */
  protected $bTitleOption;

  /**
   *  Constructeur par défaut
   * @param oForm    référence sur l'objet formulaire
   * @param iMode       Mode du controle de saisie : =0 modif, =1 lecture
   * @param name        Nom du controle de saisie
   * @param value       Valeur par défaut du controle de saisie. Dans le cas d'un select multiple, value peut être un tableau contenant les valeurs sélectionnées par défaut
   * @param label       Etiquette texte associée au controle de saisie
   * @param size        hauteur de la zone sélection (=1 : comboBox, >1 : liste sélection). =1 par défaut
   * @param widthSelect Largeur en pixel de la saisie de sélection
   * @param widthOption largeur en pixel de la dropdown list box
   */
  function __construct($oForm, $iMode, $name, $value="", $label="" ,$size="1", $widthSelect="", $widthOption="")
  {
    parent::__construct($oForm, $iMode, $name, $value, $label);
    $this->size = $size;
    $this->widthSelect = $widthSelect;
    $this->widthOption = $widthOption;
    $this->bMultiple = false;
    $this->tabValTxtDefault = array();
    $this->tabValTxtLast = array();
    $this->tabValTxt = array();
    $this->oValTxt = null;
    $this->bSuppFirstCharId = false;
    
    $this->strFieldValue = "";
    $this->strFieldText = "";
    
    $this->bTitleOption = false;
  }
  
  /**
   *  Vérifie si l'élément de la liste est sélectionné
   *        Retourne true si sélectionné, retourne false sinon
   * 
   * @param strVal   Valeur de l'élément en cours d'affichage
   * @param bDefault vrai si la valeur provient de tabValTxtDefault, false par défaut
   * @return Retourne un booleen
   */
  protected function isSelected($strVal, $bDefault=false)
  {
    $bRes = false;
    if( $this->bMultiple==true && is_array($this->value) ) {
      if( $bDefault == true ) {
        $bRes = ( (count($this->value)==0) || in_array($strVal, $this->value) );
      } else {
        $bRes = in_array($strVal, $this->value);
      }
    } elseif( !is_array($this->value) ) {
      if( $bDefault == true )
        $bRes = ( ($this->value=="") || (strcmp($strVal, $this->value)==0) );
      else
        $bRes = ( strcmp($strVal, $this->value)==0 );
    }
    return $bRes;
  }

  /**
   *  Génère puis retourne le code html associé au controle de saisie
   */
  protected function getCtrlHtml($key=0, $tabLg=array())
  {
    // contruit le controle
    $strHtml = "";

    $strClass = ( $this->cssFormCtrl!="" 
                  ? ' class="'.$this->cssFormCtrl.'"'
                  : '' );

    $strDisabled = "";
    if( $this->bDisabled == true ) $strDisabled = ' disabled="true" ';

    if( $this->iMode == "1" ) {
      $strListTxt = "";

      // affiche le ou les éléments sélectionnés à partir du tableau de valeur
      if( is_array($this->tabValTxt) && count($this->tabValTxt)>0 ) {
        $strListTxt .= $this->_getSelected($this->tabValTxt);
      } 

      // affiche le ou les éléments sélectionnés à partir du dataSet
      if( $this->oValTxt!=null &&
          is_object($this->oValTxt) && 
          method_exists($this->oValTxt, "getRowIter")==true ) {
        $this->oValTxt->moveFirst();
        while( $drSelect = $this->oValTxt->getRowIter() ) {
          $strVal = $strTxt = null;
          if ( $this->strFieldValue!="" )
            $strVal = $drSelect->getValueName($this->strFieldValue, $strVal);
          if ( is_null($strVal) )
            $strVal = $drSelect->getValueNum(1);
            
          if ( $this->strFieldText!="" )
            $strTxt = $drSelect->getValueName($this->strFieldText, $strTxt);
          if ( is_null($strTxt) )
            $strTxt = $drSelect->getValueNum(0);
            
          if( $this->isSelected($strVal) ) {
            $strListTxt .= ($strListTxt!="" ? ", " : "").$strTxt;
            if( $this->bMultiple==false ) 
              // stop la boucle while
              break;
          }
        }
      }

      // mode lecture : affiche le texte associé à la valeur par défaut
      $strHtml = '<span '.$strClass.'>'.$strListTxt.'</span>';

    } else {

      // mode modif : tag select
      
      $bIE = true;
      if( self::$strNavigator == ALK_NAV_OTHER ) {
        $strClass = "";
        $bIE = false;
      }

      $strHtml = '<select '.
        $strClass.
        $strDisabled.
        ' name="'.$this->name.'"'.
        ' id="'.$this->guid.'"'.
        ' size="'.$this->size.'"'.
        ( $this->bMultiple==true 
          ? ' multiple="multiple"' 
          : '' ).
        ( $this->widthSelect != "" 
          ? ' style="width: '.$this->widthSelect.'px"' 
          : '' ).
        $this->GetHtmlEvent().
        '>';
          
      // valeur par défaut au début
      if( is_array($this->tabValTxtDefault) && count($this->tabValTxtDefault)>0 ) {
        $strHtml .= '<option value="'.$this->tabValTxtDefault[0].'"'.
          ( $this->isSelected($this->tabValTxtDefault[0], true) 
            ? ' selected="selected"' 
            : '' ).
          ( $this->widthOption != "" 
            ? ' style="width: '.$this->widthOption.'px"' 
            : '' ).
          ( $this->bTitleOption == true
            ? ' title="'.$this->tabValTxtDefault[1].'"'
            : '' ).
          '>'.$this->tabValTxtDefault[1].'</option>';
      }

      // liste de valeurs par tableau associatif
      if( is_array($this->tabValTxt) && count($this->tabValTxt)>0 ) {
        foreach($this->tabValTxt as $strVal => $strTxt) {
          if( is_array($strTxt) ) {
            $strHtml .= $this->_getHtmlOptGroup($strVal, $strTxt);
          } else {
            $strValAff = $strVal;
            if( $this->bSuppFirstCharId == true ) $strValAff = mb_substr($strValAff, 1);
            $strHtml .= '<option value="'.$strValAff.'"'.
              ( $this->isSelected($strValAff) 
                ? ' selected="selected"' 
                : '' ).
              ( $this->widthOption != "" 
                ? ' style="width: '.$this->widthOption.'px"' 
                : '' ).
              ( $this->bTitleOption == true
                ? ' title="'.$strTxt.'"'
                : '' ).
              '>'.$strTxt.'</option>';
          }
        }
      }
        
      // liste de valeurs par dataSet
      if( $this->oValTxt!=null &&
          is_object($this->oValTxt) &&
          method_exists($this->oValTxt, "getRowIter")==true ) {
        $this->oValTxt->moveFirst();
        while( $drSelect = $this->oValTxt->getRowIter() ) {
          $strVal = $strTxt = null;
          if ( $this->strFieldValue!="" )
            $strVal = $drSelect->getValueName($this->strFieldValue, $strVal);
          if ( is_null($strVal) )
            $strVal = $drSelect->getValueNum(1);
            
          if ( $this->strFieldText!="" )
            $strTxt = $drSelect->getValueName($this->strFieldText, $strTxt);
          if ( is_null($strTxt) )
            $strTxt = $drSelect->getValueNum(0);
            
          $strHtml .= '<option value="'.$strVal.'"'.
            ( $this->isSelected($strVal) 
              ? ' selected="selected"' 
              : '' ).
            ( $this->widthOption != "" 
              ? ' style="width: '.$this->widthOption.'px"' 
              : '' ).
            ( $this->bTitleOption == true
              ? ' title="'.$strTxt.'"'
              : '' ).
            '>'.$strTxt.'</option>';
        }
      }

      // Dernière valeur
      if( is_array($this->tabValTxtLast) && count($this->tabValTxtLast)>0 ) {
        $strHtml .= '<option value="'.$this->tabValTxtLast[0].'"'.
          ( $this->isSelected($this->tabValTxtLast[0], true) 
            ? ' selected="selected"' 
            : '' ).
          ( $this->widthOption != "" 
            ? ' style="width: '.$this->widthOption.'px"' 
            : '' ).
          ( $this->bTitleOption == true
            ? ' title="'.$this->tabValTxtLast[1].'"'
            : '' ).
          '>'.$this->tabValTxtLast[1].'</option>';
      }
      $strHtml .= '</select>';
    }

    return $strHtml;
  }
  
  /**
   *  Crée une balise OPTGROUP dont le label est optGroupLabel et le contenu est tabValues={value, text}
   *        Si text est un tableau, appelle récursivement la fonction, sinon construit une OPTION
   * 
   * @param optGroupLabel   chaine donnant le label de l'OPTGROUP
   * @param tabValues       tableau (value => text) contenant les options associées à l'OPTGROUP ou les sous-OPTGROUP (si text tableau)
   * @param iDepth          profondeur de l'optgroup permettant de décaler les sous-optgroup
   * 
   * @return code html de OPTGROUP 
   */
  protected function _getHtmlOptGroup($optGroupLabel, $tabValues, $iDepth=0)
  {
    $strHtml = "<optgroup label=\"".$optGroupLabel."\"".
      ( $this->cssFormCtrl!=""
        ? ' class="'.$this->cssFormCtrl.'"'
        : '' ).
      ' style="padding-left:'.($iDepth*10).'px">';
      
    foreach($tabValues as $value=>$text){
      if( is_array($text) ) {
        $strHtml .= $this->_getHtmlOptGroup($value, $text, $iDepth+1);
      } else {
        $strValAff = $value;
        if( $this->bSuppFirstCharId == true ) {
          $strValAff = mb_substr($strValAff, 1);
        }
        $strHtml .= '<option value="'.$strValAff.'"'.
          ( $this->isSelected($strValAff) 
            ? ' selected="selected"' 
            : '' ).
          ( $this->widthOption != "" 
            ? ' style="width: '.$this->widthOption.'px"' 
            : '' ).
          ( $this->bTitleOption == true
            ? ' title="'.$text.'"'
            : '' ).
          '>'.$text.'</option>';
      }
    }
    $strHtml .= '</optgroup>';
    return $strHtml;
  }
  
  /**
   *  Retourne la ou les valeurs sélectionnées de la liste
   *        que l'on soit avec des optgroup (tableaux de tableaux) ou en fonctionnement normale
   *
   * @param tabValues  Tableaux de valeurs de la liste
   * @return Retourne un string
   */
  protected function _getSelected($tabValues)
  {
    $strListTxt = "";
    foreach($tabValues as $strVal=>$strTxt) {
      if( is_array($strTxt) ) {
        $selected = $this->_getSelected($strTxt);
        $strListTxt .= ( $strListTxt!="" && $selected!="" ? ", " : "" ).$selected;
      } else {
        if( $this->bSuppFirstCharId == true )
          $strVal = mb_substr($strVal, 1);
        if( $this->isSelected($strVal) ) {
          $strListTxt .= ($strListTxt!="" ? ", " : "").$strTxt;
          if( $this->bMultiple==false ) 
            // stop la boucle while
            break;
        }
      }
    }
    return $strListTxt;
  }
  
}

?>