<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlSlider
 * 
 * Classe représentant un control de saisie date
 */
class AlkHtmlSlider extends AlkHtmlText
{
  /** Largeur du slider dessiné */
  protected $iWidthSlider;
  
  /** Valeur minimale du slider */
  protected $min_value;
  
  /** Valeur maximale du slider */
  protected $max_value;
  
  /** Fonction JS de calcul de la nouvelle valeur */
  protected $strIncrementFunction;
  /**
   *  Constructeur par défaut
   *
   * @param iMode     Mode du controle de saisie : =0 modif, =1 lecture
   * @param name      Nom du controle de saisie
   * @param value     Valeur par défaut du controle de saisie
   * @param label     Etiquette texte associée au controle de saisie
   * @param separator caractère séparateur entre jour mois et année ( / par défaut)
   */
  public function __construct($oForm, $iMode, $name, $value="", $label="", $row=1, $column=0, $maxlength=0, $iWidthSlider=150)
  {
    parent::__construct($oForm, $iMode, $name, $value, $label, $row, $column, $maxlength);
    
    $this->iWidthSlider = $iWidthSlider;
    $this->min_value = 0;
    $this->max_value = 100;
    $this->strIncrementFunction = "numericIncrementSlider";
  }
  
  
  /**
   *  Génère puis retourne le code html associé au controle de saisie
   *
   * @return Retourne un string dans le cas 1 langue
   *         Retourne un tableau dans le cas n langues
   */
  protected function getCtrlHtml($key=0, $tabLg=array())
  {
    $this->AddScriptJs($this->tabConstJs["SLIDER"]); 
    
    $this->addEvent("onblur", "objSlider_".$this->guid.".setPosition(this.value/100);");
    
    $this->addOnload(
        "objSlider_".$this->guid." = CreateSlider(" .
            "'".$this->name."', " .
            $this->value.", " .
            "'".$this->strIncrementFunction."'," .
            "'".$this->min_value."'," .
            "'".$this->max_value."'," .
            "'".$this->iWidthSlider."'" .
        ");");
    
    $strHtml = "<div style='float:left'>" .
                "<div id='slider_".$this->name."' style='float:left;margin-left:5px;margin-right:5px;'></div>" .
                "<div>".parent::getCtrlHtml()."</div>" .
               "</div>";
    return $strHtml;
  }
  
  /**
   * Paramètre le slider
   * @param min_value               Valeur minimale du slider 
   * @param max_value               Valeur maximale du slider 
   * @param strIncrementFunction    Fonction JS de calcul de la nouvelle valeur
   */
  protected function setParametersSlider($min_value, $max_value, $strIncrementFunction)
  {
    $this->min_value = $min_value;
    $this->max_value = $max_value;
    $this->strIncrementFunction = $strIncrementFunction;
  }
}
?>