<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");
require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_file.php");

/**
 * @package Alkanet_Class_Form
 * @class alkHtmlUpload
 * 
 * classe d'affichage d'un composant avancé.
 *        génère un bloc de fichiers joint disponible selon 2 modes :
 *         1=lecture
 *         2=modif
 *         Le mode 2 affiche une case à cocher par fichier pour le supprimer
 *         un bouton ajout qui appelle une fonction javascript AjouterPJ()
 */
class AlkHtmlUpload extends AlkHtmlCtrl
{
  /** 
   * dataSet contenant les pièces jointes
   * Nécessite d'avoir les alias : ID, FILENAME, FILENAME_AFF, DATE_CREA, AUTEUR_MAIL
   */
  protected $dsPJ;

  /** = vrai si affichage en popup, faux sinon (par défaut) */
  protected $bPopup;

  /** largeur du controle en pixels, = 380 par défaut */
  protected $width;

  /** chemin physique de base vers les pièces jointes */
  protected $strPathBase;
  
  /** adresse url de base vers les pièces jointes */
  protected $strUrlBase;
  
  /** chemin uri de base vers les icones des pieces jointes */
  protected $strUrlIcone;

  /** nb de langues prises en compte */
  protected $nbLg;

  /** bouton de validation pour valider l'étape */
  protected $buttonAdd;
  protected $buttonAddRol;

  /** bouton de suppression */
  protected $buttonDel;
  protected $buttonDelRol;

  
  /** bouton serveur */
  protected $bButtonServer;
  
  /** 
   * url de téléchargement, 
   * =vide, téléchargement en direct, 
   * sinon téléchargement controlé, url de type : http://www.domaine.ext/..../fichier.ext?param1=val1&...&paramPJ_ID=
   * pour permettre la concatenation de l'identifiant du fichier joint
   */
  protected $strUrlDownload;
  
  /** Nom du formulaire (optionnel) */
  protected $formName;
  
  /** Etat coché si =1 ou décoché si =0 des cases à cocher permettant la suppression */
  protected $defaultStateCheck;


  /** Nom de la table de référence de la donnée sur laquelle on ajoute les pj */
  protected $tableName;

  /** Identifiant de la donnée sur laquelle on ajoute les pj */
  protected $data_id;

  /** Nom du répertoire accueillant le fichier joint (à terminer par /) */
  protected $strDirUpload;
  
  /** Nom du répertoire racine de l'arbre de pdw_file_browser (à terminer par /) */
  protected $strDirRootUpload;

  /** Nombre maximal de PJ acceptées par le controle : -1=illimité, 0 non accepté */
  protected $nbMaxPj;

  /** Si vrai : gestion des versions de fichiers */
  protected $bVersionning;
  
  /** appli_id */
  protected $appli_id;
  
  /** cont_id */
  protected $cont_id;
  
  /**
   *  Constructeur par défaut
   *
   * @param oForm        Formulaire contenant ce champ
   * @param iMode        Mode du controle de saisie : =1 lecture, =0 ou =2 case à cocher + bouton ajouter
   * @param name         Nom du controle de saisie
   * @param label        Etiquette texte associée au controle de saisie
   * @param tableName    Nom de la table sur laquelle on ajoute les pj (ex. FDOC_01_PJ)
   * @param data_id      Identifiant de la donnée sur laquelle on ajoute les pj
   * @param strDirUpload Nom du répertoire accueillant le fichier joint (à terminer par /)
   * @param nbLg         nombre de langue prise en compte par l'extranet (=1 par defaut)
   * @param strDirRootUpload Nom du répertoire racine de l'arborescence de pdw_file_browser
   */
  public function __construct($oForm, $iMode, $name, $label, $tableName, $data_id, $strDirUpload, $nbLg=1,$strDirRootUpload="")
  {
    parent::__construct($oForm, $iMode, $name, "", $label);
    $this->width = 380;
    $this->tableName = $tableName;
    $this->data_id = $data_id;
    $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
    if($tableName != ""){
    	$this->dsPJ = $oQuery->getDsListePJ($this->tableName, $this->data_id, $this->name);
    }
    $this->bPopup = false;
    $this->strDirUpload = $strDirUpload;
    $this->strDirRootUpload = $strDirRootUpload;
    $this->strPathBase = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.$this->strDirUpload;
    $this->strUrlBase  = ALK_ALKANET_ROOT_URL.ALK_ROOT_UPLOAD.$this->strDirUpload;
    $this->strUrlIcone = $this->urlBaseImg;
    $this->strUrlDownload = "";
    $this->formName = (is_null($this->oForm) ? "" : $this->oForm->getName());
    $this->defaultStateCheck = "0";
    $this->nbMaxPj = -1;
    $this->nbLg = count($this->tabLangue);
    $this->buttonAdd = "tab_ajouter.gif";  
    $this->buttonAddRol = "tab_ajouter_rol.gif";
    $this->buttonDel = "tab_supprimer.gif";  
    $this->buttonDelRol = "tab_supprimer_rol.gif";
    $this->bVersionning = false;
    $this->bButtonServer = defined("ALK_B_UPLOAD_FILEMANAGER")&& ALK_B_UPLOAD_FILEMANAGER==true;
    
    $this->cont_id = AlkFactory::getSProperty("cont_id", "-1");
    $this->appli_id = AlkFactory::getSProperty("appli_id", "-1");
    
    // utile pour les champs IPTC
    global $tabPJDetails;
    if ( $this->oForm && isset($tabPJDetails) && is_array($tabPJDetails) && !empty($tabPJDetails) ) {
      $this->oForm->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_form.js");
    }
    
    // chargement des styles CSS nécessaires à l'affichage des icônes
    if ( $this->oForm ) {
      $this->oForm->addScriptCss("../".ALK_ROOT_MODULE."alkanet/styles/alkimgpic.css");
      $this->oForm->addScriptCss("../".ALK_ROOT_MODULE."alkanet/styles/alkimgpicto.css");
      $this->oForm->addScriptCss("../".ALK_ROOT_MODULE."alkanet/styles/alkimgicon.css");
    }
  }
  
  /**
   * Active/Désactive le versionning des fichiers
   * @param bVersionning    Nouvelle valeur booléenne
   */
  public function setVersionning($bVersionning)
  {
    $this->bVersionning = $bVersionning;
  }
  
  /**
   * Passe la valeur de l'identifiant d'application courante
   * @param appli_id    Nouvelle valeur d'appli_id
   */
  public function setAppli($appli_id)
  {
    $this->appli_id = $appli_id;
  }  

  /**
   * Setteur bButtonServeur
   */
  public function setbButtonServer($bool)
  {
  	if(defined("ALK_B_UPLOAD_FILEMANAGER")&& ALK_B_UPLOAD_FILEMANAGER==true && $bool)
  	  $this->bButtonServer = $bool;
  	else
      $this->bButtonServer = false;
  }
  
  /**
   *  Génère puis retourne le code html associé au controle de saisie
   *        Construit le tableau html de la liste des fichiers joints d'un document en mode modification
   */
  protected function getCtrlHtml($key=0, $tabLg=array())
  {
    $oHide = AlkHtmlFactory::getNewHtmlHidden($this->oForm, "nbMaxPj_".$this->name, $this->nbMaxPj);
    
    $tabHelp = $this->getTabHtmlHelp();
    if( $this->iMode == "0" ) 
      $this->iMode = "2";

    $strAlign = "left";
    if( $this->bPopup == true ) $strAlign = "right";

    $strHtml = "";
    
    if( $this->iMode == "3" ) {
      return $oHide->getHtml().$this->getDynamicHtml();
    }
    return $oHide->getHtml().$this->getListDynamicHtml();
  }
  
  /**
   *  Static - Permet un appel static à la méthode d'objet getListDynamicHtml. 
   *        Les paramètres suivants contiennent les valeurs des attributs non donnés par cet appel statique
   * 
   * @param dsPJ              Dataset des fichiers
   * @param name              Nom du controle de formulaire
   * @param iMode             Mode d'affichage
   * @param defaultStateCheck Etat initial des checkbox
   * @param nbLg              Nombre de langages utilisés
   * @param strDirUpload      Nom du répertoire d'upload des fichiers
   * @param strUrlIcone       URL du répertoire des images présentées
   * @param strUrlDownload    URL du répertoire de téléchargement
   * 
   * @return string html  
   */
  public static function staticGetListDynamicHtml($dsPJ, $name, $iMode, $defaultStateCheck, $nbLg, $strDirUpload, $strUrlIcone, $strUrlDownload, $bVersionning="0")
  {
    return self::getListDynamicHtml($dsPJ, $name, $iMode, $defaultStateCheck, $nbLg, $strDirUpload, $strUrlIcone, $strUrlDownload, $bVersionning);
  }
  
  /**
   *  Retourne le code html de la liste des fichiers joints
   *        - Liste des fichiers joints avec en face lien de suppression
   *        - Enregistrement et actualisation transparents à l'utilisateur
   * @return string html  
   */
  public function getListDynamicHtml()
  {
    global $tabPJDetails; // tableau de définition des champs détaillés des pièces jointes
    global $PJDetailsShowDefault;
    $tabValidator = array(
      "iSheet" => "-1",
      "sheetManager" => (!is_null($this->oForm) ? $this->oForm->getGUID() : "")
    );
    $oSheetOwner = $this->getSheetOwner();
    if (!is_null($oSheetOwner)){
      $tabValidator["iSheet"] = $oSheetOwner->getGUID();
      $tabValidator["sheetManager"] = $oSheetOwner->getParent()->getGUID();
    }
    $this->addOnload("AddValidatorPJDetails(true)");
    
    $width = 380;
    $iMode = 3;
    $nbLg = count($this->tabLangue);
    $dsPJ = null;
    $name = "";
    $defaultStateCheck = 0;
    $bVersionning = false;
    $tabData = array("dsPJ", "name", "iMode", "defaultStateCheck", "nbLg", "strDirUpload",
                     "strUrlIcone", "strUrlDownload", "width", "bVersionning");
    if ( ( $nbArgs = func_num_args() )>0 ){
      foreach ($tabData as $iData=>$dataName){
        if ($nbArgs>$iData)
          $$dataName = func_get_arg($iData);
      } 
    }
    else {
      foreach ($tabData as $iData=>$dataName){
        $$dataName = $this->$dataName;
      } 
    }
     
    self::addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alkhtmlupload.js");
    
    // chargement des librairies nécessaires aux champs IPTC (utile pour rechargement AJAX)
    self::addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formnumber.js");
    self::addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
    self::addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formtxt.js");
    
    // le controle date suivant est un controle fictif qui permet de charger toutes les librairies nécessaires au controle
    // utile lorsque les métadonnées IPTC contiennent un champ date
    $oCtrl = AlkHtmlFactory::getNewHtmlDate(null, 0, $this->name."_fictive_".rand(), "", "");
    
    $strHtml = '<div style="display:none">'.$oCtrl->getHtml().'</div>';
    
    $strHtml .= '<ul class="alkUploadFiles">'.
      '<input type="hidden" id="formNameGlobal" value="'.$this->formName.'" />'.
      '<input type="hidden" name="uploadName" value="'.$this->name.'" />';
    
    $iColSpan = 3;
    $cpt = 0;
    $lg_id = 0;
    
    $strList = '<span class="txtNormal">'._t("Aucun fichier dans la liste").'</span>';
    while( $dsPJ!=null && $drPJ = $dsPJ->GetRowIter() ) {
      $strList = "";
      $id             = $drPJ->getValueName("ID");
      $strDate        = $drPJ->getValueName("DATE_CREA");
      $strFileName    = $drPJ->getValueName("FILENAME");
      $strFileNameAff = $drPJ->getValueName("FILENAME_AFF");
      $strMail        = $drPJ->getValueName("AUTEUR_MAIL");
      $duration       = $drPJ->getValueName("PJ_DURATION");
      $bitrate        = $drPJ->getValueName("PJ_BITRATE");
      $iMarginLeft    = 0;
      if( $nbLg >  1 ) {
        $lg_id = $drPJ->getValueName("PJ_LANG");
        if( !($lg_id!="" && is_numeric($lg_id) && $lg_id>=0 && $lg_id<=$nbLg) ) 
          $lg_id = 0;
      }

      $strPathFile = $this->strPathBase.$strFileName;
      if( file_exists($strPathFile) && is_file($strPathFile) ) {
        $iFileSize = filesize($strPathFile);
        $strTaille = getFileSize($iFileSize, false);
        $strDuration = getFileDuration($duration, false);
        
        $strHtml .= '<li><p>';
        
        if( $iMode=="3" ) {
          // case a cocher
          $strHtml .= '<input type="checkbox" class="formCtrlRCB" name="suppj_'.$this->name.'_'.$cpt.'" '.
            ( $defaultStateCheck=="1" ? 'checked="checked"' : 'value="1"' ).' />'.
            '<input type="hidden" name="pj_'.$this->name.'_id" value="'.$id.'" />'.
            '<input type="hidden" name="id_'.$this->name.'_'.$cpt.'" value="'.$id.'" />'.
            '<input type="hidden" id="pj_name_'.$this->name.'_'.$id.'" value="'.getFileRadical($strFileNameAff).'" />'.
            '<input type="hidden" name="fileName_'.$this->name.'_'.$cpt.'" value="'.$strFileName.'" />';
          $iMarginLeft += 16;
        } else {
          // email du publicateur
          if( $strMail != "" ) {
            $strHtml .= '<a title="'.$strMail.'" href="mailto:'.$strMail.'">'.
              '<img class="alkimgicon alkimgiconcourriel" src="'.$this->strUrlIcone.'transp.gif"  border="0" alt="Courriel"></a>';
            $iMarginLeft += 16;
          }
        }

        if( $nbLg > 1 ) {
          $strHtml .= '<img class="alkimgicon alkimgicondrapeau'.$this->tabLangue[$lg_id]["rep"].'" src="'.$this->urlBaseFlag.'transp.gif"'.
            ' alt="'.$this->tabLangue[$lg_id]["rep"].'"' .
            ' title="'.$this->tabLangue[$lg_id]["rep"].'"' .
            ' align="top"/>';                  
          $iMarginLeft += 16;
        }
        $strVersionning = "";
        $iVersionCur = -1;
        if ( $bVersionning ){
          $matches = array();
          if ( preg_match("!^v(\d+)_(\d+_".$id."_)(.+)$!", $strFileName, $matches) ){
            $iVersionCur = $matches[1];
            $prefixe = $matches[2];
            $strRadicalName = $matches[3];
            $iVersion = $iVersionCur;
            $nbVersionMax = 3; 
            while( file_exists($this->strPathBase."v".$iVersion."_".$prefixe.$strRadicalName) 
                   && $iVersion>=1 && $iVersionCur>1 && ($iVersionCur-$iVersion)<$nbVersionMax ) {
              $strPathFileVersion = $this->strPathBase."v".$iVersion."_".$prefixe.$strRadicalName;
              $strUrlFileVersion = $this->strUrlBase."v".$iVersion."_".$prefixe.$strRadicalName;
              
              $strTokenDel = "cont_id=".AlkFactory::getSProperty("cont_id", "-1") .
                "&champName=".$this->name .
                "&formName=".$this->formName .
                "&tableName=".$this->tableName .
                "&dirUpload=".$this->strDirUpload .
                "&data_id=".$this->data_id .
                "&pj_id=".$id .
                "&lang_id=".ALK_LG.
                "&versionning=".($bVersionning ? "1" : "0").
                "&filename="."v".$iVersion."_".$prefixe.$strRadicalName;
              $strTokenDel = AlkRequest::getEncodeParam($strTokenDel);
              
              $strVersionning .= 
                '<li style="padding-left:10px">'.
                '&gt; <a target="_blank" href="'.$strUrlFileVersion.'">version '.$iVersion.'</a>'.
                ( $iVersion==$iVersionCur && $iVersion>1
                  ? '&nbsp;&nbsp;&nbsp;&nbsp;' .
                    '<a class="button form text"  ' .
                    ' onclick="javascript:delVersionPJ(\''.$strTokenDel.'\')"'.
                    ' title="'._t("Supprimer les fichiers sélectionnés").'"' .
                    '>'.
                    _t("Supprimer").'</a>'
                  : '' ).
                '<p>('.
                getFileSize(filesize($strPathFileVersion), false).', '.
                date("d/m/Y H:i", filemtime($strPathFileVersion)).')' .
                '</p>'.
                '</li>';
              
              $iVersion--;
            }
          }
        }
        
        // création des contrôles des champs détaillés des pièces jointes
        require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlblock.class.php");
        $blockLabelWidth = 70;
        $block = new AlkHtmlBlock($this->oForm, "block_pj_details_".$id, "", "", $blockLabelWidth, $this->width - $blockLabelWidth);
        
        $titre = null;
        if ( isset($tabPJDetails) && is_array($tabPJDetails) && !empty($tabPJDetails) ) {
          foreach ( $tabPJDetails as  $tabFieldInfo ) {
            $ctrlName = $tabFieldInfo["field"]."_".$id;
            $ctrlValue = $drPJ->getValueName($tabFieldInfo["field"]);
            $typeCtrl = $tabFieldInfo["type"];
            $min = ( array_key_exists("min", $tabFieldInfo) ? $tabFieldInfo["min"] : "" );
            $max = ( array_key_exists("max", $tabFieldInfo) ? $tabFieldInfo["max"] : "" );
            if ( $tabFieldInfo["field"] == "pj_title" ) {
              $titre = $ctrlValue;
            }
            $column = ($this->width - $blockLabelWidth)/(8) - ($tabFieldInfo["row"]=="1" ? 0 : 2);
            switch ( $typeCtrl ) {
              case "date10" :
                $oCtrl = AlkHtmlFactory::getNewHtmlDate(null, ( $tabFieldInfo["readOnly"] ? 1 : ( $iMode > 1 ? 0 : $iMode ) ), 
                                                        $ctrlName, $ctrlValue, $tabFieldInfo["label"], $min, $max);
                $oCtrlHidden = AlkHtmlFactory::getNewHtmlHidden(null, "hidden_".$ctrlName, $ctrlValue);
              break;
              case "int" :
                $oCtrl = AlkHtmlFactory::getNewHtmlText(null, ( $tabFieldInfo["readOnly"] ? 1 : ( $iMode > 1 ? 0 : $iMode ) ), 
                                                        $ctrlName, $ctrlValue, $tabFieldInfo["label"], $tabFieldInfo["row"], 
                                                        min($tabFieldInfo["column"], $column));
                $oCtrlHidden = AlkHtmlFactory::getNewHtmlHidden(null, "hidden_".$ctrlName, $ctrlValue);
              break;
              case "select" :
                $oCtrl = AlkHtmlFactory::getNewHtmlSelect(null, ( $tabFieldInfo["readOnly"] ? 1 : ( $iMode > 1 ? 0 : $iMode ) ), 
                                                          $ctrlName, $ctrlValue, $tabFieldInfo["label"], $tabFieldInfo["row"], 
                                                          min($tabFieldInfo["column"], $column));
                $oCtrl->setProperty("tabValTxt", $tabFieldInfo["tabValTxt"]);
                $oCtrlHidden = AlkHtmlFactory::getNewHtmlHidden(null, "hidden_".$ctrlName, $ctrlValue);
              break;
              case "text" :
              default :
                $oCtrl = AlkHtmlFactory::getNewHtmlText(null, ( $tabFieldInfo["readOnly"] ? 1 : ( $iMode > 1 ? 0 : $iMode ) ), 
                                                        $ctrlName, $ctrlValue, $tabFieldInfo["label"], $tabFieldInfo["row"], 
                                                        min($tabFieldInfo["column"], $column), ( $max != "" ? $max : "0" ));
                $oCtrlHidden = AlkHtmlFactory::getNewHtmlHidden(null, "hidden_".$ctrlName, "0-0-0-0-0");
                $oCtrl->addEvent("onfocus", "setControlHiddenValue('".$ctrlName."');");
              break;
            }
            $oCtrl->setIsRequire($tabFieldInfo["required"]);
            $block->addCtrl($oCtrl);
            $block->addCtrl($oCtrlHidden);
          }
          
          $oButtonValid = $oButtonValidAll = null;
          if ( $iMode > 1 ) {
            $strToken = "cont_id=".AlkFactory::getSProperty("cont_id", "-1") .
              "&tableName=".$this->tableName .
              "&dirUpload=".$this->strDirUpload;
            // enregistrement par fichier
            $strTokenUpdate = AlkRequest::getEncodeParam($strToken);
            $oButtonValid = AlkHtmlFactory::getHtmlButtonForm("javascript:ValidatePJDetails('".$this->formName."', '".$this->name."', ".$id.", '".$strTokenUpdate."', 0)", 
                                                              _t("Enregistrer"), _t("Enregistrer les métadonnées pour ce fichier"));
            
            // enregistrement pour tous les fichiers
            $strTokenUpdate = AlkRequest::getEncodeParam($strToken);
            $oButtonValidAll = AlkHtmlFactory::getHtmlButtonForm("javascript:ValidatePJDetails('".$this->formName."', '".$this->name."', ".$id.", '".$strTokenUpdate."', 1)", 
                                                                 _t("Propager"), _t("Enregistrer les métadonnées pour tous les fichiers de la liste"));
            
            $varCtrl = AlkHtmlFactory::getHtml($oButtonValid->getHtml()."&nbsp;&nbsp;".$oButtonValidAll->getHtml());
            $block->addCtrl($varCtrl,ALK_HTMLFORM_1L2C);
          }
        }
        
        if ( is_null($titre) || empty($titre) ) {
          $titre = getFileRadical($strFileNameAff);
        }
        
        // nom du fichier + date + taille en ko            
        $strTokenDn = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=".$this->appli_id."&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                 "&data_id=".$this->data_id."&pj_id=".$id."&iMode=".
                                                 ( isFileMultimedia($strFileNameAff) ? ALK_DOWNLOAD_MODE_MEDIA : ALK_DOWNLOAD_MODE_DEFAULT ).
                                                 "&tableName=".$this->tableName.
                                                 "&dirUpload=".$this->strDirUpload.
                                                 "&bStat=0");
        $idUnique = md5(uniqid(mt_rand(), true));
        $strTokenAddPJ = AlkRequest::getEncodeParam("ids=".session_id()."&idUnique=".$idUnique.
                                                    "&dtmp=".ini_get("upload_tmp_dir").
                                                    "&data_id=".$this->data_id."&pj_id=".$id.
                                                    "&strFileName=".$strFileName.
                                                    "&tableName=".$this->tableName.
                                                    "&champName=".$this->name .
                                                    "&dirUpload=".$this->strDirUpload.
                                                    "&lang_id=".ALK_LG.
                                                    "&versionning=".($bVersionning ? "1" : "0").
                                                    "&user_id=".AlkFactory::getSProperty("user_id", "").
                                                    "&strDirPath=".ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.$this->strDirUpload.getFileRadical($strFileName));
        $strTokenProgress = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=".$this->appli_id."&idUnique=".$idUnique);
        $strTokenUnzip = AlkRequest::getEncodeParam("ids=".session_id()."&idUnique=".$idUnique.
                                                    "&dtmp=".ini_get("upload_tmp_dir").
                                                    "&strFilePathSrc=".ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.$this->strDirUpload.$strFileName.
                                                    "&strDirPathDest=".ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.$this->strDirUpload.getFileRadical($strFileName));
        $strTokenRefreshList = AlkRequest::getEncodeParam($strToken = "cont_id=".$this->cont_id.
                                                          "&appli_id=".$this->appli_id.
                                                          "&champName=".$this->name .
                                                          "&formName=".$this->formName .
                                                          "&tableName=".$this->tableName .
                                                          "&dirUpload=".$this->strDirUpload .
                                                          "&data_id=".$this->data_id .
                                                          "&lang_id=".ALK_LG.
                                                          "&versionning=".($this->bVersionning ? "1" : "0"));
        $strHtml .= 
          '<a target="_blank" href="'.ALK_ALKANET_DOWNLOAD.'?token='.$strTokenDn.'">'.
          '<img class="alkimgicon alkimg'.getFileIcon($strFileName, true).'" src="'.$this->strUrlIcone.'transp.gif" border="0" title="'._t("Télécharger").'" /></a>'. 
          '&nbsp;'.
          ( getFileExtension($strFileName, false, -1) == "zip" 
            ? '<a title="'._t("Décompresser").'" href="javascript:UnzipPJ(\''.$strTokenUnzip.'\', \''.$strTokenProgress.'\', \''.$strTokenAddPJ.'\', \''.$strTokenRefreshList.'\', \'alkHtmlUploadProgressBar'.$this->getGUID().'\', \'file_'.$this->getGUID().'\')">'.
              '<img class="alkimgicon alkimgicontransform" border="0" src="'.$this->strUrlIcone.'transp.gif"/></a>&nbsp;' 
            : '' ).
          ( isset($tabPJDetails) && is_array($tabPJDetails) && !empty($tabPJDetails)
            ? '<a id="link_pj_show_hide_details" title="'.( isset($PJDetailsShowDefault) && $PJDetailsShowDefault ? _t("Masquer les métadonnées") : _t("Afficher les métadonnées") ).'" href="javascript:ShowHidePJDetails('.$id.')">'.
              '<span id="span_pj_title_'.$id.'">'.$titre.'</span></a>'
            : $titre
          ).
          '</p>'.
          '<p class="txtNormal" style="margin-left:'.($iMarginLeft+24).'px">'. 
          truncFileName($strFileNameAff, 20).", ".
          $strTaille.", ".
          ( $strDuration ? $strDuration.", " : "" ).
          $strDate.
          '</p>'.
          '<div id="div_pj_details_'.$id.'" style="'.( isset($PJDetailsShowDefault) && $PJDetailsShowDefault ? '' : 'display:none;' ).'">'.
          $block->getHtml().
          '</div>'.
          ( $strVersionning != ""
            ? '<ul>'.$strVersionning.'</ul>'
            : '' ).
          '</li>';

        $cpt++;
      }else{
        $strHtml .= '<li><p>';
        $strHtml .= '<input type="checkbox" class="formCtrlRCB" name="suppj_'.$this->name.'_'.$cpt.'" '.
            ( $defaultStateCheck=="1" ? 'checked="checked"' : 'value="1"' ).' />'.
            '<input type="hidden" name="pj_'.$this->name.'_id" value="'.$id.'" />'.
            '<input type="hidden" name="id_'.$this->name.'_'.$cpt.'" value="'.$id.'" />'.
            '<input type="hidden" id="pj_name_'.$this->name.'_'.$id.'" value="'.getFileRadical($strFileNameAff).'" />'.
            '<input type="hidden" name="fileName_'.$this->name.'_'.$cpt.'" value="'.$strFileName.'" />';
        $strHtml .= _t("Le lien vers le fichier est mort.");
        $strHtml .= '</p></li>';
      }
    }
    $strHtml .= $strList;
    
    // mémorise le nombre de pieces jointes
    $nbPj = ( !is_null($dsPJ) ? $dsPJ->getCountTotDr() : 0 );
    $strHtml .= '<input type="hidden" name="nbPJ_'.$name.'" value="'.$nbPj.'"/>';
    $strHtml .= '<input type="hidden" name="nbPJ" value="'.$nbPj.'"/>';
    $strHtml .= '</ul>';

    return $strHtml.
      "<script type=\"text/javascript\">
      var jsonPJDetails = ".json_encode(( isset($tabPJDetails) && is_array($tabPJDetails) && !empty($tabPJDetails) ? $tabPJDetails : array() )).";".
      "var validatorPJInfo = window.validatorPJInfo || ".json_encode($tabValidator).";".
      "</script>";
  }
  
  /**
   *  Retourne le code html de ce controle sous la nouvelle génération :
   *        - Liste des fichiers joints avec en face lien de suppression
   *        - Un champ de sélection de fichier avec en face lien d'ajout
   *        - Enregistrement et actualisation transparents à l'utilisateur
   * @return string html  
   */
  protected function getDynamicHtml()
  {
    $strToken = "cont_id=".$this->cont_id.
      "&appli_id=".$this->appli_id.
      "&champName=".$this->name .
      "&formName=".$this->formName .
      "&tableName=".$this->tableName .
      "&dirUpload=".$this->strDirUpload .
      "&data_id=".$this->data_id .
      "&lang_id=".ALK_LG.
      "&versionning=".($this->bVersionning ? "1" : "0")."";
    $strTokenEncode = AlkRequest::getEncodeParam($strToken);
    $strParam = "'".$this->formName."', '".$this->name."', '".$strTokenEncode."'"; 
    $strFctAdd = "AjouterPJ(".$strParam.");";
    $strFctDel = "SupprimerPJ(".$strParam.");";
    $strFctDelPj = "delPJ(".$strParam.");";
    if (defined("ALK_B_UPLOAD_FILEMANAGER")&& ALK_B_UPLOAD_FILEMANAGER==true){
      if ( defined("ALK_B_EDITEUR_PDW_FILEBROWSER") && ALK_B_EDITEUR_PDW_FILEBROWSER==true ){ 
        $strTokenFileManager = ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/editor/pdw_file_browser/index.php?editor=ckeditor&ServerPath=".ALK_VIRTUAL_DIR.ALK_ROOT_UPLOAD.( $this->strDirRootUpload != "" ? $this->strDirRootUpload : $this->strDirUpload).
        	"&UrlRoot=".ALK_ROOT_URL;
      } else {
        $strTokenFileManager = ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."editeur/editor/filemanager2/index.html?&ServerPath=".ALK_VIRTUAL_DIR.ALK_ROOT_UPLOAD.( $this->strDirRootUpload != "" ? $this->strDirRootUpload : $this->strDirUpload).
          "&UrlRoot=".ALK_ROOT_URL.
          "&CKEditor=TextHtml" .
          "&CKEditorFuncNum=1" .
          "&langCode=fr";
      }
      $strUrlFileManager = "OpenFileManager('".$strTokenFileManager."', '".$this->name."','".$this->formName."','".$strTokenEncode."')";
    }

    
    $strUrlRefreshList = ALK_ALKANET_PROCESS."?iMode=7&token=".$strTokenEncode;
    
    $oCheckbox = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "check_all_".$this->name, "0", "");
    $oCheckbox->addEvent("onclick", "CheckAll('".$this->formName."', '".$this->name."', this)");
    
    // fichier présent sur le ftp
    $strHtmlFtp = "";
    if( ALK_B_UPLOAD_FTP == true ) {
      $user_id = AlkFactory::getSProperty("user_id", "-1");
      $strPathFtp = ALK_ROOT_PATH.ALK_UPLOAD_FTP_PATH;
      $tabPrefix = array($user_id."_");
      $tabFiles = getTabFilesByDir($strPathFtp, array(), false, $tabPrefix);

      if( !empty($tabFiles) ) {
        $strHtmlFtp .= '<select name="files_'.$this->name.'" class="'.$this->cssFormCtrl.'" style="width:'.($this->width-90).'px">'.
          '<option value="">'._n("Fichier présent sur le FTP", "Fichiers présents sur le FTP", count($tabFiles)).'</option>';
        foreach($tabFiles as $strFile) {
          $strHtmlFtp .= '<option value="'.$strFile.'">'.$strFile.'</option>';
        }
        $strHtmlFtp .= '</select>';
      }      
    }
    
    self::addScriptCss("../".ALK_ROOT_CLASSE."form/alkhtmlupload.css");
    
    if( defined("ALK_B_UPLOAD_SWF") && ALK_B_UPLOAD_SWF==true ) {
      self::addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alkhtmlupload.js");
      self::addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/swfu.js");
      
      $strMaxFileSize = ini_get("upload_max_filesize");
      $strMaxFileSize = str_replace("M", " MB", $strMaxFileSize);
      
      $strJsSWFUpload = "var oAlkUpload".$this->getGUID().";
    function initUpload_".$this->getGUID()."() {
      var oSettings = {
        flash_url              : '".ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/swfu.swf',
        upload_url             : '".ALK_ALKANET_PROCESS."',
        post_params            : {
          'PHPSESSID'  : '".session_id()."',
          'pathUpload' : '".$this->strPathBase."',
          'iMode'      : '5',
          'token'      : '".$strTokenEncode."'
        },
        alkCtrlName            : 'list_upload_".$this->name."',
        alkUrlUpdateFilesList  : '".$strUrlRefreshList."',
            
        file_post_name         : 'file_".$this->name."',
        file_size_limit        : '".$strMaxFileSize."', // limite php.ini, doit être écrit xxxM pour xxx méga-octets
        file_types             : '*.*',
        file_types_description : '"._t("Tous fichiers")."',
        file_upload_limit      : ".( $this->nbMaxPj>0 ? $this->nbMaxPj : 0).",
        file_queue_limit       : ".( $this->nbMaxPj>0 ? $this->nbMaxPj : 0).",
        custom_settings : {
          progressTarget : 'alkUploadProgress".$this->getGUID()."',
          cancelButtonId : 'alkUploadBtnCancel".$this->getGUID()."'
          /*upload_target  : 'divFileProgressContainer' */
        },

        file_queued_handler          : fileQueued,
        file_queue_error_handler     : fileQueueError,
        file_dialog_complete_handler : fileDialogComplete,
        upload_progress_handler      : uploadProgress,
        upload_error_handler         : uploadError,
        upload_success_handler       : uploadSuccess,
        upload_complete_handler      : uploadComplete,

        /* button_image_url : superposer les images sur la hauteur : normal / hover / down / disabled */
        button_image_url          : '".ALK_MEDIA_URL."images/bt_browse.gif', 
        button_placeholder_id     : 'alkUploadBtnBrowse".$this->getGUID()."',
        button_width              : 75,
        button_height             : 17,
        button_action             : SWFUpload.BUTTON_ACTION.SELECT_FILES,
        button_window_mode        : SWFUpload.WINDOW_MODE.TRANSPARENT,
        button_cursor             : SWFUpload.CURSOR.HAND,
        
        // Debug Settings
        debug: false
      };
      
      oAlkUpload".$this->getGUID()." = new SWFUpload(oSettings);
    };";
      self::addJs($strJsSWFUpload);
      self::addOnload("initUpload_".$this->getGUID()."();");

      $strHtml = '<div id="alkhtmlupload_'.$this->getGUID().'" class="AlkUploadFlash">'.
        ( $strHtmlFtp != ""
          ? ' <div>'.$strHtmlFtp.'</div>'
          : '' ).
        ' <fieldset id="alkUploadProgress'.$this->getGUID().'">'.
        '  <legend>'._t("Cliquez sur Parcourir pour sélectionner les fichiers à transférer").'</legend>'.
        ' </fieldset>'.
        ' <div>'.
        '  <div style="float:left;"><span id="alkUploadBtnBrowse'.$this->getGUID().'"></span></div>'.
        '  <a id="alkUploadBtnCancel'.$this->getGUID().'" class="btform" style="float:left;"'.
        '     onclick="javascript:cancelQueue(oAlkUpload'.$this->getGUID().')"' .
        '     title="'._t("Annuler les téléchargements en cours").'">'._t("Annuler").'</a>'.
        '  <div style="width:0px; height:0px; clear:left;"></div>'.
        ' </div>'.
        ' <div style="white-space:nowrap">'.
        '  <div style="float:left;">'.$oCheckbox->getHtml().'</div>'.
        '  <a class="btform" style="float:left;" onclick="javascript:'.$strFctDelPj.'"'.
        '     title="'._t("Supprimer les fichiers sélectionnés").'">'._t("Supprimer").'</a>'.
        '  <div style="width:0px; height:0px; clear:left;"></div>'.
        '</div>' .
        ' <div class="label" style="vertical-align:bottom">'.
        ( $this->nbMaxPj!=-1 
          ? '('._nf("%s fichier accepté", "%s fichiers acceptés", $this->nbMaxPj).')' 
          : '' ).
        '</div>' .
        ' <div style="overflow:hidden;width:'.$this->width.'px" id="list_upload_'.$this->name.'">'.
        $this->getListDynamicHtml().
        ' </div>'.
        '</div>';
    } 
    elseif( defined("ALK_B_UPLOAD_CGI") && ALK_B_UPLOAD_CGI==true ) {
      self::addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alkhtmlupload.js");
      
      $oFile = AlkHtmlFactory::getNewHtmlFile($this->oForm, 0, "file_".$this->getGUID(), "", $this->label, 0, 255);
      $oFile->setProperty("width", $this->width-16);
      $idSession = md5(uniqid(mt_rand(), true));
      $strTmpPath = ini_get("upload_tmp_dir");
      $strToken .= "&idSession=".$idSession;
      $strTokenEncode = $strTokenEncode = AlkRequest::getEncodeParam($strToken);
      $oFile->addEvent("onChange", "doAjaxUpload('".$this->formName."', 'alkIfrUpload".$this->getGUID().
                                                 "', 'alkUploadProgress".$this->getGUID()."', 'alkHtmlUploadProgressBar".$this->getGUID().
                                                 "', this, '".$strTokenEncode."', '".$idSession."_".session_id()."', '".$strTmpPath."', '".
                                                 ALK_ALKANET_ROOT_URL."', '".$strUrlRefreshList."', '".
                                                 ( $this->nbMaxPj == 1 ? "pjid_".$this->getGUID() : "")."')");
      
      $strHtml = '<div id="alkhtmlupload_'.$this->getGUID().'" class="AlkUploadFlash">'.
        ( $this->nbMaxPj == 1
          // utilisé uniquement pour récupérer le pj_id avant soumission du formulaire en mode création, =0 pour pas de pj_id, sinon >0
          ? ' <input type="hidden" name="pjid_'.$this->getGUID().'" value="0"/>' 
          : '' ).
        ' <fieldset id="alkUploadProgress'.$this->getGUID().'">'.
        '  <legend>'._t("Cliquez sur Parcourir pour sélectionner le fichier à transférer").'</legend>'.
        $oFile->getHtml().
        '  <div id="alkHtmlUploadProgressBar'.$this->getGUID().'" class="progressBarCgi" style="width:".($this->width-16)."px;"></div>'.
        '  <iframe id="alkIfrUpload'.$this->getGUID().'" name="alkIfrUpload'.$this->getGUID().'"'.
        '          style="display:none; width:0px; height:0px"></iframe>'.
        ' </fieldset>'.
        ' <div>';
      if($this->tableName != ""){  
      	$strHtml .= 
      	' <div style="white-space:nowrap">'.
        '  <div style="float:left;">'.$oCheckbox->getHtml().'</div>'.
        '  <a class="btform" style="float:left;" onclick="javascript:'.$strFctDelPj.'"'.
        '     title="'._t("Supprimer les fichiers sélectionnés").'">'._t("Supprimer").'</a>'.
        // pas de fonction annuler pour IE
        ( substr(ALK_NAV, 0, 2) != "IE"
          ? '  <a id="alkUploadBtnCancel'.$this->getGUID().'" class="btform" style="float:left;"'.
            '     onclick="javascript:cancelAjaxUpload(\'alkIfrUpload'.$this->getGUID().'\')"' .
            '     title="'._t("Annuler le téléchargement en cours").'">'._t("Annuler").'</a>'
          : '' ).
        ( $this->bButtonServer 
        ? '  <a class="btform" style="float:left;" onclick="javascript:'.$strUrlFileManager.'"'.
          '     title="'._t("Explorer les images du serveur").'">'._t("Serveur").'</a>'
        : "").
        '  <div style="width:0px; height:0px; clear:left;"></div>'.
        '</div>' .
        ' <div class="label" style="vertical-align:bottom">'.
        ( $this->nbMaxPj!=-1 
          ? '('._nf("%s fichier accepté", "%s fichiers acceptés", $this->nbMaxPj).')' 
          : '' ).
        '</div>' .
        ' <div style="overflow:hidden;width:'.$this->width.'px" id="list_upload_'.$this->name.'">'.
        $this->getListDynamicHtml().
        ' </div>';
      }
      $strHtml .= '</div>';
    }
    else {
      $strHtml = "AlkHtmlUpload : mode CGI ou FLASH uniquement disponible"; 
    }    
    return $strHtml;
  }

  /**
   *  Retourne le code html donnant un lien et des sous-menus de pièces jointes pour la consultation
   * @param bDownload   Indique si un mode de téléchargement des PJ est accepté
   * @param strSuffixe  Suffixe de la liste des outils générés
   * @param pictoSize   Dimension de l'image PJ
   * @return string html
   */
  public function getHtmlJoinTool($bDownload, $strSuffixe="", $pictoSize=16)
  {
    if ( $this->dsPJ->isEndOfFile() ) return "";

    $strHtml = "";
        
    $tabTxtDownload = array(1=>"Télécharger", 2=>"Download", 3=>"Download", 4=>"Download", 5=>"Download");     
    $tabTxtRun = array(1=>"Ouvrir", 2=>"Open", 3=>"Open", 4=>"Open", 5=>"Open");
    
    self::addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_CLASSE."form/alkhtmlupload.js");
    self::addScriptCss("../".ALK_ROOT_CLASSE."form/alkhtmlupload.css");
    
    $nbPj = 0;
    $sizePj = 0;
    $strFiles = "";
        
    if ( $bDownload && mb_substr(phpversion(), 0, 3)>=5.2 ) {
      $strTokenDnAll = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=".$this->appli_id."&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                   "&data_id=".$this->data_id."&iMode=".ALK_DOWNLOAD_MODE_ZIP."&tableName=".$this->tableName);
      $strFiles .= "<div class='item separator' style='white-space:nowrap'".
          " onmouseover=\"OpenCloseMenu(this, '', 'over', true);\"" .
          " onmouseout=\"OpenCloseMenu(this, '', 'out', true);\" >" .
        "&nbsp;" .
        " <img class='alkimgicon alkimgicondoc7' src='".ALK_MEDIA_URL."images/transp.gif' border='0' title=''/>&nbsp;" .
        "<a href=\"javascript:DownloadAll('".$strTokenDnAll."')\" class='item' style='display:inline;'>" .
        "Tout ".$tabTxtDownload[1].
        "</a></div>";
    }
    
    while( $this->dsPJ!=null && $drPJ = $this->dsPJ->GetRowIter() ) {
      $strList = "";
      $iWidthMail = 0; 
      $iWidthLg = 0; 
      $pj_id = $drPJ->getValueName("ID");
      $strDate = $drPJ->getValueName("DATE_CREA");
      $strFileName = $drPJ->getValueName("FILENAME");
      $strFileNameAff = $drPJ->getValueName("FILENAME_AFF");
      $strMail = $drPJ->getValueName("AUTEUR_MAIL");
      $lg_id = $drPJ->getValueName("LG_ID");
      if( $this->nbLg >  1 ) {
        if( !($lg_id!="" && is_numeric($lg_id) && $lg_id>0 && $lg_id<=$this->nbLg) ) 
          $lg_id = "1";
      }

      $strUrl = $this->strUrlBase.$strFileName;
      $strPathFile = $this->strPathBase.$strFileName;
      if( file_exists($strPathFile) && is_file($strPathFile) ) {
        $nbPj++;
        $sizePj += $iFileSize = filesize($strPathFile);
        $strTaille = getFileSize($iFileSize);
        
        if ( $bDownload && isFileMultimedia($strFileNameAff) ) {
          $strTokenDnMedia = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=".$this->appli_id."&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                        "&data_id=".$this->data_id."&pj_id=".$pj_id."&iMode=".ALK_DOWNLOAD_MODE_MEDIA.
                                                        "&tableName=".$this->tableName);
          $strTokenDn = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=".$this->appli_id."&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                        "&data_id=".$this->data_id."&pj_id=".$pj_id."&iMode=".ALK_DOWNLOAD_MODE_DEFAULT.
                                                        "&tableName=".$this->tableName);
          $strUrlOpen = "javascript:DownloadMedia('".$strTokenDnMedia."')";
          $strUrlDLoad = (ALK_B_DOWNLOAD_PJ==true ? "javascript:Download('".$strTokenDn."')" : $strUrl);
          $targetOpen = "";
          $targetDLoad = (ALK_B_DOWNLOAD_PJ==true ? "" : "_blank");
        } elseif ( $bDownload ) {
          $strTokenDn = AlkRequest::getEncodeParam("cont_id=".$this->cont_id."&appli_id=".$this->appli_id."&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                                   "&data_id=".$this->data_id."&pj_id=".$pj_id."&iMode=".ALK_DOWNLOAD_MODE_DEFAULT.
                                                   "&tableName=".$this->tableName);
          $strUrlDLoad = "javascript:Download('".$strTokenDn."')";
          $strUrlOpen = $strUrl;
          $targetDLoad = "";
          $targetOpen = "_blank";
        }
        
        $strFileNameAffLink = truncFileName($strFileNameAff);
        $strTitle = ( mb_strlen($strFileNameAff) > 250/8 ? " title=\"".$strFileNameAff."\"" : "" );
        
        $strFiles .= 
          "<div class='item".($this->dsPJ->isEndOfFile() ? " last" : "")."'" .
          $strTitle.
          " onmouseover=\"OpenCloseMenu(this, 'pj_".$this->data_id."_".$pj_id.$strSuffixe."', 'over', true);\"" .
          " onmouseout=\"OpenCloseMenu(this, 'pj_".$this->data_id."_".$pj_id.$strSuffixe."', 'out', true);\"" .
          " style='white-space:nowrap; width:276px; '>" .
          
          "&nbsp;" .
          " <img class='alkimgicon alkimg".getFileIcon($strFileName, true)."' src='".ALK_MEDIA_URL."images/transp.gif' border='0' title=''/>&nbsp;" .
          ( !$bDownload 
            ? "<a href='".$strUrlOpen."'".($targetOpen!="" ? "target='".$targetOpen."'" : "")." class='item' style='display:inline'>"
            : "").
          $strFileNameAffLink.$strTaille. 
          ( !$bDownload ? "</a>" : "").
          "&nbsp;" .
          
          
          ( $bDownload 
            ? "<div class='submenu' id='pj_".$this->data_id."_".$pj_id.$strSuffixe."'>" .
              " <div class='subitem' style='padding:2px;'" .
              ">" .
              "  <a href=\"".$strUrlOpen."\"".($targetOpen!="" ? "target='".$targetOpen."'" : "").">" .
              _t("Ouvrir") .
              "  </a>" .
              " </div>" .
              " <div class='subitem last' style='padding:2px;'" .
              " >" .
              "  <a href=\"".$strUrlDLoad."\"".($targetDLoad!="" ? "target='".$targetDLoad."'" : "").">" .
              $tabTxtDownload[$lg_id] .
              "  </a>" .
              " </div>" .
              "</div>"
            : "").
          
          "</div>";
      }
    }
    if ( $nbPj==0 ) return "";
    
    $strHtml .= "<div class='alkhtmlupload'>" .
      "<div class='menuopener'" .
      " onmouseover=\"OpenCloseMenu(this, 'pjs_".$this->data_id.$strSuffixe."', 'over');\"" .
      " onmouseout=\"OpenCloseMenu(this, 'pjs_".$this->data_id.$strSuffixe."', 'out');\"" .
      ">" .
      "<img class='alkimgicon alkimgiconpiecesjointes' src='".ALK_MEDIA_URL."images/transp.gif' title='"._nf("%s fichier %s", "%s fichiers %s", $nbPj, $nbPj, getFileSize($sizePj))."'" .
      "     border='0' style='vertical-align:bottom'/>" .
      "<div id='pjs_".$this->data_id.$strSuffixe."' class='menu'" .
      "     onmouseover=\"OpenCloseMenu(this, 'pjs_".$this->data_id.$strSuffixe."', 'over');\">" .
      $strFiles.
      "</div>" .
      "</div>" .
      "</div>";
    return $strHtml;
  }
  
  /**
   * Retourne la liste des fichiers joints pour un affichage en layer popup
   * Répond au cas iMode=3 de alkanet_process.php 
   * suite à une requête ajax
   * @param bDownload   Indique si un mode de téléchargement des PJ est accepté, 
   *                    - true pour une téléchargement en direct, 
   *                    - false pour un téléchargement indirect et controlé en php
   * @param strSuffixe  suffixe apposé à l'id du layer généré par cette méthode, ="" par défaut
   * @param lg          suffixe de la langue sélectionnée, =_FR par défaut
   *
  public function getHtmlListFilesMenuPopup($bDownload, $strSuffixe="", $lg="_FR")
  {
    $nbPj = $this->dsPJ->getCountTotDr();
    $strHtml = "";
    
    $cpt = 0;
    $sizePj = 0;
    $strFiles = "";
    while( $this->dsPJ!=null && $drPJ = $this->dsPJ->GetRowIter() ) {
      $strList = "";
      $iWidthMail = 0; 
      $iWidthLg = 0; 
      $pj_id          = $drPJ->getValueName("ID");
      $strDate        = $drPJ->getValueName("DATE_CREA");
      $strFileName    = $drPJ->getValueName("FILENAME");
      $strFileNameAff = $drPJ->getValueName("FILENAME_AFF");
      $strMail        = $drPJ->getValueName("AUTEUR_MAIL");
      $lg_id          = $drPJ->getValueName("LG_ID");
      if( $lg != $this->tabLangue[$lg_id]["bdd"] ) {
        $strFiles .= "ko ";
        continue;
      }
      if( $this->nbLg >  1 ) {
        if( !($lg_id!="" && is_numeric($lg_id) && $lg_id>0 && $lg_id<=$this->nbLg) ) 
          $lg_id = "1";
      }

      $strFileNameAffLink = truncFileName($strFileNameAff); 

      $strUrl = $this->strUrlBase.$strFileName;
      $strPathFile = $this->strPathBase.$strFileName;
      if( file_exists($strPathFile) && is_file($strPathFile) ) {
        $sizePj += $iFileSize = filesize($strPathFile);
        $strTaille = getFileSize($iFileSize);
        
        $strUrlDLoad = "javascript:Download(".$this->cont_id.", ".$this->appli_id.", ".$this->data_id.", ".$pj_id.")";
        $strUrlOpen = $strUrl;
        $targetDLoad = "";
        $targetOpen = "_blank";
        
        // largeur popup menu item : 280 px avec padding 2, d'ou 276px
        
        $strFiles .= 
          "<div class='item' align='left' style='white-space:nowrap; width:276px'>".
          "<img src='".ALK_MEDIA_URL."images/".getFileIcon($strFileName)."' width='16' height='16' border='0' title=''/>&nbsp;".
          "<a title=\""._f("Télécharger %", $strFileNameAff)."\"".
          " href='".$strUrlOpen."'".
          ($targetOpen!="" ? "target='".$targetOpen."'" : "").
          " style='display:inline'>".
          $strFileNameAffLink.$strTaille .
          "</a>".
          "</div>";
      } else {
        $strFiles .= "<div class='item' align='left' style='white-space:nowrap; width:276px'>".
          _t("Fichier non disponible.")."</div>";
      }
    }

    return $strFiles;
  }*/

  /**
   *  indique si le controle necessite un formulaire de type upload 
   * @return boolean  
   */
  public function isUpload()
  {
    return !$this->isHidden() && !$this->isFieldNotView(); 
  } 
  
  /** 
   *  Détermine le maximal de PJ acceptées par le controle : -1=illimité, 0 non accepté
   *        Si =1 présentation comme AlkHtmlFile mais enregistrement dans la table des uploads
   * @param iNbMaxPj    Nouveau nombre maximal de PJ 
   */
  public function setNbMaxPj($iNbMaxPj)
  {
    if ( $iNbMaxPj!=0 )
      $this->nbMaxPj = $iNbMaxPj;
  }
  
  /** 
   * Retourne le nombre de pièces jointes associées au controle
   * @return int 
   */
  public function getNbPj()
  {
    if ( !is_null($this->dsPJ) )
      return $this->dsPJ->getCountTotDr();
    return 0;
  }
  
}

?>