<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Class::Form
Module fournissant les classes d'affichage Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlctrl.class.php");

/**
 * @package Alkanet_Class_Form
 * @class AlkHtmlWdCalendar
 * 
 * Classe d'affichage d'un calendier avec le plugin jQuery wdCalendar
 */
class AlkHtmlWdCalendar extends AlkHtmlCtrl
{
  /** tableau de définition du format de la date Javascript */
  protected static $dateformat=null;
  
  protected $defaultView;
  
  /** URLs de traitements AJAX */
  protected $urlList;             // URL de récupération de la liste des événements
  protected $quickAddUrl;         // URL de création rapide d'un événement
  protected $quickUpdateUrl;      // URL de modification rapide d'un événement (utilisée notamment pour les déplacements d'événements par Drag & Drop)
  protected $quickDeleteUrl;      // URL de suppression rapide d'un événement
  
  /** fonctions Javascript */
  protected $addHandler;          // fonction Javascript appelée pour l'ajout d'un événement
  protected $quickAddHandler;     // fonction Javascript appelée pour l'ajout rapide d'un événement (popup wdCalendar utilisée)
  protected $viewCmdhandler;      // fonction Javascript appelée pour la consultation d'un événement
  protected $editCmdhandler;      // fonction Javascript appelée pour la modification d'un événement
  protected $deleteCmdhandler;    // fonction Javascript appelée pour la suppression d'un événement
  
  /** chargement automatique ou non */
  protected $bAutoLoad;
  
  public function __construct($oForm, $iMode, $strName) {
    
    parent::__construct($oForm, $iMode, $strName);
    
    $this->defaultView = "month";
    
    $this->urlList          = "";
    $this->quickAddUrl      = "";
    $this->quickUpdateUrl   = "";
    $this->quickDeleteUrl   = "";
    
    $this->quickAddHandler    = "";
    $this->viewCmdhandler     = "";
    $this->editCmdhandler     = "";
    $this->deleteCmdhandler   = "";
    
    $this->bAutoLoad = true;
    
    $this->addScriptCss("../".ALK_ROOT_LIB."jquery/wdCalendar/css/calendar.css");
    $this->addScriptCss("../".ALK_ROOT_LIB."jquery/wdCalendar/css/dp.css");
    $this->addScriptCss("../".ALK_ROOT_LIB."jquery/wdCalendar/css/main.css");
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/wdCalendar/src/Plugins/Common.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/wdCalendar/src/Plugins/datetime.min.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/wdCalendar/src/Plugins/variable.min.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/wdCalendar/src/Plugins/datepicker_lang_FR.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/wdCalendar/src/Plugins/jquery.datepicker.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/wdCalendar/src/Plugins/wdCalendar_lang_FR.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."jquery/wdCalendar/src/Plugins/jquery.calendar.js");
  }
  
  /**
   * modification de la vue par défaut
   * @param defaultView vue par défaut {day|week|month}
   */
  public function setDefaultView($defaultView) {
    $this->defaultView = $defaultView;
  }
  
  /**
   * set URL de récupération des événements en AJAX
   * @param urlList  URL de récupération des événements en AJAX
   */
  public function setUrlList($urlList) {
    $this->urlList = $urlList;
  }
  
  /**
   * set URL d'ajout rapide d'un événement en AJAX
   * @param quickAddUrl  URL d'ajout rapide d'un événement en AJAX
   */
  public function setQuickAddUrl($quickAddUrl) {
    $this->quickAddUrl = $quickAddUrl;
  }
  
  /**
   * set URL de modification rapide d'un événement en AJAX
   * @param quickUpdateUrl  URL d'ajout rapide d'un événement en AJAX
   */
  public function setQuickUpdateUrl($quickUpdateUrl) {
    $this->quickUpdateUrl = $quickUpdateUrl;
  }
  
  /**
   * set URL de suppression rapide d'un événement en AJAX
   * @param quickDeleteUrl  URL de suppression d'un événement en AJAX
   */
  public function setQuickDeleteUrl($quickDeleteUrl) {
    $this->quickDeleteUrl = $quickDeleteUrl;
  }
  
  /**
   * set fonction Javascript de consultation d'un événement
   * @param viewCmdhandler  fonction Javascript de consultation d'un événement
   */
  public function setViewCmdhandler($viewCmdhandler) {
    $this->viewCmdhandler = $viewCmdhandler;
  }
  
  /**
   * set fonction Javascript d'ajout d'un événement
   * @param addHandler  fonction Javascript d'ajout d'un événement
   */
  public function setAddHandler($addHandler) {
    $this->addHandler = $addHandler;
  }
  
  /**
   * set fonction Javascript d'ajout rapide d'un événement
   * @param quickAddHandler  fonction Javascript d'ajout rapide d'un événement
   */
  public function setQuickAddHandler($quickAddHandler) {
    $this->quickAddHandler = $quickAddHandler;
  }
  
  /**
   * set fonction Javascript de modification d'un événement
   * @param editCmdhandler  fonction Javascript de modification d'un événement
   */
  public function setEditCmdhandler($editCmdhandler) {
    $this->editCmdhandler = $editCmdhandler;
  }
  
  /**
   * set fonction Javascript de suppression d'un événement
   * @param deleteCmdhandler  fonction Javascript de suppression d'un événement
   */
  public function setDeleteCmdhandler($deleteCmdhandler) {
    $this->deleteCmdhandler = $deleteCmdhandler;
  }
  
  /**
   * set booléen pour chargement automatique ou non
   * @param bAutoLoad true pour chargement automatique, false sinon
   */
  public function setAutoload($bAutoLoad) {
    $this->bAutoLoad = $bAutoLoad;
  }
  
  /**
   *  Retourne le code html du formulaire complet
   *
   * @return Retourne un string
   */
  public function getHtml() {
    
    $strJs    = "";
    $strHtml  = "";
    
    $strJs .= "var wdCalendar;";
    $strJs .= "function initWdCalendar() {
      var op = {
          view:\"".$this->defaultView."\",
          theme:3,
          showday:new Date(),
          addHandler:".( $this->addHandler ? $this->addHandler : "false" ).",
          quickAddHandler:".( $this->quickAddHandler ? $this->quickAddHandler : "false" ).",
          EditCmdhandler:".( $this->editCmdhandler ? $this->editCmdhandler : "false" ).",
          DeleteCmdhandler:".( $this->deleteCmdhandler ? $this->deleteCmdhandler : "false" ).",
          ViewCmdhandler:".( $this->viewCmdhandler ? $this->viewCmdhandler : "false" ).",    
          //onWeekOrMonthToDay:wtd,
          onBeforeRequestData:function(){},
          onAfterRequestData:function(){},
          onRequestDataError:function(){}, 
          autoload:".( $this->bAutoLoad ? "true" : "false" ).",
          url:\"".$this->urlList."\",
          quickAddUrl:".( $this->quickAddUrl ? "\"".$this->quickAddUrl."\"" : "\"\"" ).",
          quickUpdateUrl:".( $this->quickUpdateUrl ? "\"".$this->quickUpdateUrl."\"" : "\"\"" ).",
          quickDeleteUrl:".( $this->quickDeleteUrl ? "\"".$this->quickDeleteUrl."\"" : "\"\"" )."
      };
      wdCalendar = jQuery(\"#".$this->name."\").bcalendar(op);
      var p = wdCalendar.BcalGetOp();
      if (p && p.datestrshow) {
        jQuery(\"#txtdatetimeshow\").text(p.datestrshow);
      }
      
      /* exemple pour ajouter des paramètres en Javascript à l'url $this->urlList */
      //wdCalendar.BcalSetOp({extParam:[{name:\"<name>\", value:\"<value>\"}]});
      
      /* pour recharger le calendrier (rappel de l'url $this->urlList) */
      //wdCalendar.reload();
      
      jQuery(\"#showreflashbtn\").click(function(e){
          wdCalendar.reload();
      });
      
      //go to today
      jQuery(\"#showtodaybtn\").click(function(e) {
          wdCalendar.gotoDate();
          setTxtDatetimeShow();
      });
      
      //to show day view
      jQuery(\"#showdaybtn\").click(function(e) {
          jQuery(\"#caltoolbar div.fcurrent\").each(function() {
              jQuery(this).removeClass(\"fcurrent\");
          })
          jQuery(this).addClass(\"fcurrent\");
          wdCalendar.swtichView(\"day\");
          setTxtDatetimeShow();
      });
      
      //to show week view
      jQuery(\"#showweekbtn\").click(function(e) {
          jQuery(\"#caltoolbar div.fcurrent\").each(function() {
              jQuery(this).removeClass(\"fcurrent\");
          })
          jQuery(this).addClass(\"fcurrent\");
          wdCalendar.swtichView(\"week\");
          setTxtDatetimeShow();
      });
      
      //to show month view
      jQuery(\"#showmonthbtn\").click(function(e) {
          jQuery(\"#caltoolbar div.fcurrent\").each(function() {
              jQuery(this).removeClass(\"fcurrent\");
          })
          jQuery(this).addClass(\"fcurrent\");
          wdCalendar.swtichView(\"month\");
          setTxtDatetimeShow();
      });
      
      //previous date range
      jQuery(\"#sfprevbtn\").click(function(e) {
          wdCalendar.previousRange().BcalGetOp();
          setTxtDatetimeShow();
      });
      //next date range
      jQuery(\"#sfnextbtn\").click(function(e) {
          wdCalendar.nextRange().BcalGetOp();
          setTxtDatetimeShow();
      });
      
      function setTxtDatetimeShow() {
        p = wdCalendar.BcalGetOp();
        if (p && p.datestrshow) {
          jQuery(\"#txtdatetimeshow\").text(p.datestrshow);
        }
      }
    }";
    
    $this->addJs($strJs);
    
    $strHtml .= "<div id=\"caltoolbar\" class=\"ctoolbar\">";
    $strHtml .= "<div id=\"showreflashbtn\" class=\"fbutton\"><div><span title=\"Rafraichir\" class=\"showdayflash\">Actualiser</span></div></div>";
    $strHtml .= "<div class=\"btnseparator\"></div>";
    $strHtml .= "<div id=\"showtodaybtn\" class=\"fbutton\"><div><span title=\"Date du jour\" class=\"showtoday\">Aujourd'hui</span></div></div>";
    $strHtml .= "<div class=\"btnseparator\"></div>";
    $strHtml .= "<div id=\"showdaybtn\" class=\"fbutton".( $this->defaultView == "day" ? " fcurrent" : "" )."\"><div><span title=\"Day\" class=\"showdayview\">Jour</span></div></div>";
    $strHtml .= "<div class=\"btnseparator\"></div>";
    $strHtml .= "<div id=\"showweekbtn\" class=\"fbutton".( $this->defaultView == "week" ? " fcurrent" : "" )."\"><div><span title=\"Week\" class=\"showweekview\">Semaine</span></div></div>";
    $strHtml .= "<div class=\"btnseparator\"></div>";
    $strHtml .= "<div id=\"showmonthbtn\" class=\"fbutton".( $this->defaultView == "month" ? " fcurrent" : "" )."\"><div><span title=\"Month\" class=\"showmonthview\">Mois</span></div></div>";
    $strHtml .= "<div class=\"btnseparator\"></div>";
    $strHtml .= "<div id=\"sfprevbtn\" title=\"Précédent\" class=\"fbutton\"><span class=\"fprev\"></span></div>";
    $strHtml .= "<div class=\"btnseparator\"></div>";
    $strHtml .= "<div id=\"sfnextbtn\" title=\"Suivant\" class=\"fbutton\"><span class=\"fnext\"></span></div>";
    $strHtml .= "<div class=\"fshowdatep fbutton\"><div><input type=\"hidden\" name=\"txtshow\" id=\"hdtxtshow\"/><span id=\"txtdatetimeshow\">Loading</span></div></div>";
    $strHtml .= "</div>";
    
    $strHtml .= "<div id=\"dvCalMain\" class=\"calmain printborder\"><div id=\"".$this->name."\" style=\"position:relative;\"></div></div>";
    
    return $strHtml;
  }
  
  /**
   *  Méthode abstraite non implémentée
   *        qui se charge de retourner le code html du ctrl de saisie seul
   *        Méthode appelée par GetHtml qui se chargera d'ajouter le code JS
   *        les textes before et after, les drapeaux, le bouton d'aide
   */
  protected function GetCtrlHtml($key=0, $tabLg=array()) { /** rien à faire */ }
  
  /**
   * fonction static pour initialiser la variable static dateformat qui contient les formats de date Javascript
   * les formats sont initialisés dans les fichiers Javascript wdCalendar_lang_XX.js
   * @param dateformat
   */
  public static function setDateFormat($dateformat=array("fulldayvalue" => "d/M/yyyy")) {
    self::$dateformat = $dateformat;
  }
  
  /**
   * fonction static qui retourne l'interval des dates en timestamp
   * à utiliser dans l'action de récupération des événements en AJAX, se base sur les paramètres postés "showdate" (date de début) et "viewtype" (type d'affichage {day|week|month})
   * @param showdate  date du jour courant
   * @param viewtype  type de vue (day|week|month)
   * @return array [int <deb>, int <fin>] où <deb> et <fin> sont des timestamp
   */
  public static function getTimeStartEnd($showdate=null, $viewtype="month") {
    $phpTime    = self::js2PhpTime($showdate);
    switch($viewtype){
      case "day":
        $st = mktime(0, 0, 0, date("m", $phpTime), date("d", $phpTime), date("Y", $phpTime));
        $et = mktime(0, 0, -1, date("m", $phpTime), date("d", $phpTime)+1, date("Y", $phpTime));
        break;
      case "week":
        //suppose first day of a week is monday 
        $monday = date("d", $phpTime) - date('N', $phpTime) + 1;
        $st = mktime(0,0,0,date("m", $phpTime), $monday, date("Y", $phpTime));
        $et = mktime(0,0,-1,date("m", $phpTime), $monday+7, date("Y", $phpTime));
        break;
      case "month":
      default:
        //suppose first day of a month is monday 
        $st = mktime(0, 0, 0, date("m", $phpTime), 1, date("Y", $phpTime));
        $monday = date("d", $st) - date('N', $st) + 1;
        $st = mktime(0, 0, 0, date("m", $st), $monday, date("Y", $st));
        //suppose last day of a month is sunday
        $et = mktime(0, 0, -1, date("m", $phpTime)+1, 1, date("Y", $phpTime));
        $sunday =  7 - date('N', $et) + 1;
        $et = mktime(0, 0, -1, date("m", $et)+1, $sunday, date("Y", $et));
        break;
    }
    return array($st, $et);
  }
  
  /**
   * fonction static qui retourne l'interval des dates
   * à utiliser dans l'action de récupération des événements en AJAX, se base sur les paramètres postés "showdate" (date de début) et "viewtype" (type d'affichage {day|week|month})
   * @param showdate  date du jour courant
   * @param viewtype  type de vue (day|week|month)
   * @return array [int <deb>, int <fin>] où <deb> et <fin> sont des string
   */
  public static function getDateStartEnd($showdate=null, $viewtype="month") {
    list($st, $et) = self::getTimeStartEnd($showdate, $viewtype);
    return array(self::php2JsTime($st), self::php2JsTime($et));
  }
  
  /**
   * transforme une date Javascript en date PHP timestamp
   * @pre : self::dateformat doit être initialisé
   * @param jsdate      date Javascript
   * @return int timestamp
   */
  protected static function js2PhpTime($jsdate){
    if ( is_null(self::$dateformat) ) {
      throw new Exception("self::dateformat doit être initialisé en appelant la méthode static setDateFormat($dateformat)");
    }
    
    $res = -1;
    
    $format = self::$dateformat["fulldayvalue"];
    
    $tabEscape = array("M+","d+","h+","H+","m+","s+","q+","w","W","L","y+");
    foreach ( $tabEscape as $jsFormat ) {
      $format = preg_replace("!(".$jsFormat.")!", "[$1]", $format);
    }
    
    $tabTrad = array(
      "\[dd\]"    => "%d",
      "\[d\]"     => "%j",
      "\[MM\]"    => "%m",
      "\[M\]"     => "%m",
      "\[yyyy\]"  => "%Y",
      "\[yy\]"    => "%y",
    );
    foreach ( $tabTrad as $jsFormat => $phpFormat ) {
      $format = preg_replace("!(".$jsFormat.")!", $phpFormat, $format);
    }
    
    $tabDate = strptime($jsdate, $format);
    $res = mktime($tabDate["tm_hour"], $tabDate["tm_min"], $tabDate["tm_sec"], $tabDate["tm_mon"]+1, $tabDate["tm_mday"], $tabDate["tm_year"]+1900);
    
    return $res;
  }
  
  /**
   * transforme une date PHP timestamp en date Javascript
   * @pre : self::dateformat doit être initialisé
   * @param phpdate   date PHP timestamp
   * @return string date Javascript
   */
  protected static function php2JsTime($phpdate) {
    if ( is_null(self::$dateformat) ) {
      throw new Exception("self::dateformat doit être initialisé en appelant la méthode static setDateFormat($dateformat)");
    }
    
    $res = -1;
    
    $format = self::$dateformat["fulldayvalue"];
    
    $tabEscape = array("M+","d+","h+","H+","m+","s+","q+","w","W","L","y+");
    foreach ( $tabEscape as $jsFormat ) {
      $format = preg_replace("!(".$jsFormat.")!", "[$1]", $format);
    }
    
    $tabTrad = array(
      "\[dd\]"    => "d",
      "\[d\]"     => "j",
      "\[MM\]"    => "m",
      "\[M\]"     => "m",
      "\[yyyy\]"  => "Y",
      "\[yy\]"    => "y",
    );
    foreach ( $tabTrad as $jsFormat => $phpFormat ) {
      $format = preg_replace("!(".$jsFormat.")!", $phpFormat, $format);
    }
    
    $res = date($format." H:i", $phpdate);
    
    return $res;
  }
  
  /**
   * fonction static permettant de formatter la réponse contenant la liste des événements
   */
  public static function formatResponse(&$res, $id="", $subject="", $startTime="", $endTime="", $bAllDayEvent="", $bMoreOneDay="", $bRecurring="", $color="", $bEditable="", $location="", $tabMore=array()) {
    if ( !is_array($res) ) {
      $res = array();
    }
    if ( !array_key_exists("events", $res) ) {
      $res["events"] = array();
    }
    $tabArgs = func_get_args();
    $bOk = false;
    for ( $i=1; $i<count($tabArgs); $i++ ) {
        if ( is_array($tabArgs[$i]) ) {
          $bOk |= count($tabArgs[$i]) > 0;
        } else {
          $bOk |= $tabArgs[$i] != "";
        }
    }
    if ( $bOk ) {
      $res["events"][] = array_merge(array(
        $id,
        $subject,
        self::php2JsTime($startTime),
        self::php2JsTime($endTime),
        ( $bAllDayEvent ? 1 : 0 ),
        ( $bMoreOneDay ? 1 : 0 ),
        ( $bRecurring ? 1 : 0 ),
        $color,
        ( $bEditable ? 1 : 0 ),
        $location,
      ), $tabMore);
    }
  }
}
?>