<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

define("ALK_B_ATYPE_ESPACE", true);
define("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE, "Espace");
define("ALK_B_ATYPE_ANNU", true);
define("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ANNU, "Annu");


$oQueryAnnuAction   = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU);
$oQueryEspace       = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
$oQueryEspaceAction = AlkFactory::getQueryAction(ALK_ATYPE_ID_ESPACE);

function getUrlDefaut($cont_id_start, $idUser)
{
  global $oQueryEspace, $oQueryEspaceAction;

  if( $_SESSION["alk_userAdminAuth"] == "1" ) {
    $clientIp = ( isset($_SERVER["REMOTE_ADDR"]) ? $_SERVER["REMOTE_ADDR"] : AlkRequest::_POST("client", "") );
    $windSize = "";
     
    $tabAppli = $oQueryEspace->getTab_appliDefautByAgent($_SESSION["alk_idUser"], $cont_id_start);
    $cont_id = $tabAppli["cont_id"]; 
    $appli_id = $tabAppli["appli_id"]; 
      
    // enregistrement de la date de derniere connexion
    $oQueryEspaceAction->maj_agentDateConn($_SESSION["alk_idUser"], $_SERVER["HTTP_USER_AGENT"], $windSize, $clientIp);
        
    $strUrl = ALK_ALKANET."?token=".AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id);
  } else {
    $strUrl = ALK_ALKANET_ROOT_URL."accueil";
  }
  
  return $strUrl;
}

function SendMailAdmin($strLogin)
{
	$strSujet = ALK_APP_TITLE." : Annuaire";

  $strDate = " le ".date("d/m/Y H:i:s"); 
  $strUrl = ALK_ROOT_URL;
  
  $strMsgTxt = "Bonjour\n\n";
  $strMsgTxt .= "Un nouvel utilisateur s'est connecté à l'Intranet avec le login ActiveDirectory ($strLogin) le ".$strDate.".\n".
                "Son compte a été créé dans l'annuaire avec le profil Anonyme.\n".
                "La mise à jour de son profil et de ses droits peut être effectué dans l'annuaire.";

  $strMsgHtml = str_replace("\n", "<br>", $strMsgTxt);  

  // ------------------------------------------------------------
  // Préparation du mail
  // ------------------------------------------------------------

  // Expediteur : SIT
  $strMailFrom = ALK_SI_MAIL;
  $strNomFrom = ALK_APP_TITLE;

  $strMsgTxt .= $strNomFrom."\n\n".
    "PS : Ce message est généré puis envoyé automatiquement par ".ALK_APP_TITLE.".";
  $strMsgHtml .= $strNomFrom."<br><br>".
    "PS : Ce message est généré puis envoyé automatiquement par ".ALK_APP_TITLE.".";

  // initialisation de l'objet mail
  $oAlkMail = new AlkMail();
  
  $oAlkMail->SetSubject($strSujet);
  $oAlkMail->SetHtml(true);
  $oAlkMail->SetBody($strMsgHtml);
  $oAlkMail->SetAltBody($strMsgTxt);
  $oAlkMail->SetFrom($strNomFrom, $strMailFrom);

  $res = $oAlkMail->AddCCi(ALK_SI_MAIL, ALK_SI_MAIL);
  
  // envoi du message
  $oAlkMail->bDebugMode = ALK_MODE_DEBUG;
  $oAlkMail->maxSend = ALK_MAX_SENDMAIL;
  return $oAlkMail->Send();
}

/**
 * Charge en session, les informations de l'utilisateur connecté
 * Retourne true si l'utilisateur est connecté à l'AD, false sinon
 * @param login_detect  identifiant de la personne détectée
 * @return boolean
 */
function loadUserInfo($login_detect)
{
  $oQueryAnnu = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
  
  $bConnectAD = false;
  $dsAgent = $oQueryAnnu->getDs_ficheAgentByLoginPwd($login_detect, "", "=1", 1);          
  if( $drAgent = $dsAgent->getRowIter() ) {
    //echo"t14;";
    $_SESSION["alk_idUser"]       = $drAgent->getValueName("AGENT_ID");
    list($_SESSION["alk_idAbonne"], $_SESSION["alk_pseudoAbonne"]) = $oQueryAnnu->getAbonneIdByAgentId($_SESSION["alk_idUser"]);
    $_SESSION["alk_idProfil"]     = $drAgent->getValueName("PROFIL_ID");
    $_SESSION["alk_idService"]    = $drAgent->getValueName("SERVICE_ID");
    $_SESSION["alk_serviceName"]  = $drAgent->getValueName("SERVICE_INTITULE");
    $_SESSION["alk_serviceSigle"] = $drAgent->getValueName("SERVICE_SIGLE");
    $_SESSION["alk_idDept"]       = $drAgent->getValueName("DEPT_ID");
    $_SESSION["alk_userPriv"]     = $drAgent->getValueName("AGENT_PRIV");
    $_SESSION["alk_userLogin"]    = $drAgent->getValueName("AGENT_LOGIN");
    $_SESSION["alk_userPwd"]      = $drAgent->getValueName("AGENT_PWD");
    $_SESSION["alk_userName"]     = $drAgent->getValueName("NOM");
    $_SESSION["alk_userFirstName"]= $drAgent->getValueName("AGENT_PRENOM");
    $_SESSION["alk_userLastName"] = $drAgent->getValueName("AGENT_NOM");
    $_SESSION["alk_userMail"]     = $drAgent->getValueName("AGENT_MAIL");
    $agent_valide                 = $drAgent->getValueName("AGENT_VALIDE");
    $_SESSION["alk_userAdminAuth"]= $drAgent->getValueName("AGENT_ADMINAUTH");
    $_SESSION["alk_userLg"]       = $drAgent->getValueName("AGENT_LG");
    $_SESSION["alk_userHome"]     = "";
    $_SESSION["alk_userHomeSite"] = "/accueil";
    $_SESSION["alk_idPerf"]       = "-1";
    $_SESSION["alk_userDeltaGMT"] = "-1";
    $_SESSION["alk_idHpaUser"]    = "";
    $cont_id_start             = $drAgent->getValueName("CONT_ID_START");

    if( $agent_valide == "1" ) { 
      $_SESSION["alk_userHome"] = getUrlDefaut($cont_id_start, $_SESSION["alk_idUser"]);
      $bConnectAD = true;
    } 
  }
  return $bConnectAD;
}

function getEncodeName($strTmp)
{
  $strRes = "";
  for($i=0; $i<strlen($strTmp); $i++) {
    $strRes = $strTmp[$i].chr(000);
  }
  return $strRes;
}

function writeTrame($strTrame)
{
  for($i=0; $i<strlen($strTrame); $i++) {
    $o = ord($strTrame[$i]);
	$o = ( strlen($o) == 2 ? "0".$o : ( strlen($o) == 1 ? "00".$o : $o ));
    echo $o." ";
	if( ($i+1) % 8 == 0 ) echo "<br>";
  }
}

/** true si intérogation */
$bConnectAD = false;

if( defined("ALK_AUTH") && defined("ALK_AUTH_NTLM_NAV") && ALK_AUTH==ALK_AUTH_NTLM_NAV ) {
  
  /**
   * Récupère l'entête dans un tableau
   */
  $tabHeaders = getallheaders();
  
  /**
   *  Variable de session : vraie si navigateur IE
   */
  $bNavNTLM = false;
  $strUserAgent = $_SERVER["HTTP_USER_AGENT"];
  if( eregi('msie', $strUserAgent) && !eregi('opera', $strUserAgent) || eregi('firefox', $strUserAgent)) {
    $bNavNTLM = true;
  }
  
  /** true si authentification NTLM demandée */
  $bNTLM = false;
  /** true si vérification NTLM faite */
  $bNTLMOk = false;
  /** information retournée par AD */
  $login_detect = "";
  $domain_detect = "";
  
  //echo "t1";
  if( $bNavNTLM == true ) {// verifie qu'on est dans le mode d'identification sinon demande ce mode (etape 1)
    //echo "t2";
    if (isset ($_SERVER['HTTP_VIA']) ) {
      //echo "t3";
      // Proxy bypass!
    } elseif (!isset ($tabHeaders['Authorization'])) {
      //echo "t4";
      // si l'entete "autorisation" est inexistante
      //envoi au client le mode d'identification 
  
      header("HTTP/1.0 401 Unauthorized");
      header("WWW-Authenticate: NTLM"); //dans notre cas le NTLM
      exit; // on quite
    }
  }
  
  // dans le mode d'identification, dans le cas d'une authorisation (etape 2)
  if( $bNavNTLM == true && array_key_exists("Authorization", $tabHeaders) ) {
    //echo "t5";
    $chaine = $tabHeaders['Authorization'];
    $chaine = substr($chaine, 5); // recuperation du base64-encoded type1 message
    $chained64 = base64_decode($chaine); // decodage base64 dans $chained64
    
	//echo "t1<br>";
	//writeTrame($chained64); echo "<br><br>";
	
    $numPasse = ord($chained64 {8});
    
    if( $numPasse == 1 ) {
      // |_ byte signifiant l'etape du processus d'identification (etape 3)      
      //echo "t6";
  
      /* domain
      //$lenght_domain = (ord($chained64[17]) * 256 + ord($chained64[16])); // longueur du domain
      //$offset_domain = (ord($chained64[21]) * 256 + ord($chained64[20])); // position du domain.    
      $domain_detect = getEncodeName("messagerie"); //substr($chained64, $offset_domain, $lenght_domain);
      $length_domain = strlen($domain_detect);
	  $dsn_suffix = getEncodeName("ermont.local");
  
      // hostname
      //$lenght_hostname = (ord($chained64[25]) * 256 + ord($chained64[24])); // longueur du login.
      //$offset_hostname = (ord($chained64[29]) * 256 + ord($chained64[28])); // position du login.
      $hostname_detect = "SSIT11"; //substr($chained64, $offset_hostname, $lenght_hostname);
      $length_hostname = strlen($hostname_detect);
      
      $typeNtlm = chr(002).chr(000).chr(000).chr(000);
      $tnSecurity = chr($length_hostname).chr(000). // longueur hostname
	     chr($length_hostname ).chr(000).           // longueur hostname
         chr(048).chr(000).chr(000).chr(000);       // offset du hostname
      $flag = chr(000).chr(001).chr(130).chr(000);
      $challenge = chr(rand(0, 254)).chr(rand(0, 254)).chr(rand(0, 254)).chr(rand(0, 254)).
        chr(rand(0, 254)).chr(rand(0, 254)).chr(rand(0, 254)).chr(rand(0, 254));
      
	  $zero8Bit = chr(000).chr(000).chr(000).chr(000).chr(000).chr(000).chr(000).chr(000);

	  $infoData = chr(002).chr(000).chr($length_domain).chr(000).$domain_detect.
        ( $length_hostname> 0
		  ? chr(001).chr(000).chr($length_hostname).chr(000).$hostname_detect
		  : "" ).
        chr(004).chr(000).chr(strlen($dsn_suffix)).chr(000).$dsn_suffix.
        ( $length_hostname> 0
		  ? chr(003).chr(000).chr(strlen($hostname_detect.$dsn_suffix)+2).chr(000).$hostname_detect.".".chr(000).$dsn_suffix
		  : "" ).
        chr(000).chr(000).chr(000).chr(000);

	  $tiSecurity = chr(strlen($infoData)).chr(000). // longueur de info data
	    chr(strlen($infoData)).chr(000).             // longueur de info data
		chr(48+$length_hostname).chr(000).chr(000).chr(000);       // offset de info data
	  
      $retAuth = "NTLMSSP".chr(000).
        $typeNtlm.
		$tnSecurity.$flag.
		$challenge.
        $zero8Bit.
        $tiSecurity.
		$domain_detect.
        $infoData;*/
		
//echo writeTrame($retAuth)."<vr><br>" ;
      //echo "domaine : ".$domain_detect."<br>";
      //echo "hostname : ".$hostname_detect."<br>";
    
  
      //if( $bNTLM == true ) {// renvoie des infos d'identification au serveur ldap (etape 4)
       // echo "t9";
        $retAuth = "NTLMSSP".chr(000).
          chr(002).chr(000).chr(000).chr(000).chr(002).chr(000).chr(000).chr(000).
          chr(030).chr(000).chr(000).chr(000).chr(001).chr(130).chr(000).chr(000).
          //chr(rand(0, 254)).chr(rand(0, 254)).chr(rand(0, 254)).chr(rand(0, 254)).chr(rand(0, 254)).chr(rand(0, 254)).chr(rand(0, 254)).chr(rand(0, 254)).
          chr(000).chr(000).chr(000).chr(000).chr(000).chr(000).chr(000).chr(000).
          chr(000).chr(000).chr(000).chr(000).chr(000).chr(000).chr(000).chr(000);
          
  
      $retAuth64 = base64_encode($retAuth); // encode en base64
      $retAuth64 = trim($retAuth64); // enleve les espaces de debut et de fin
  
      header("HTTP/1.0 401 Unauthorized"); // envoi le nouveau header
      header("WWW-Authenticate: NTLM $retAuth64"); // avec les informations d'identification supplementaire
      exit;
    } 
    elseif( $numPasse == 3 ) {// recuperation des données d'identification NTML
      //  |_ byte signifiant l'etape du processus d'identification (etape 5)
      //echo "t10";
      $bNTLM = true;
      $bNTLMOk = true; 
  
      // on recupere le domaine
      $lenght_domain = (ord($chained64[31]) * 256 + ord($chained64[30])); // longueur du domain
      $offset_domain = (ord($chained64[33]) * 256 + ord($chained64[32])); // position du domain.    
      $domain_detect = str_replace("\0", "", substr($chained64, $offset_domain, $lenght_domain)); // decoupage du du domain
  
      //le login
      $lenght_login = (ord($chained64[39]) * 256 + ord($chained64[38])); // longueur du login.
      $offset_login = (ord($chained64[41]) * 256 + ord($chained64[40])); // position du login.
  
      $login_detect = str_replace("\0", "", substr($chained64, $offset_login, $lenght_login)); // decoupage du login
       
      /*echo  " ".$login_detect."<br>"; //print($adldap);
      echo "le login: ".$login_detect."<br>";
      echo "le domaine: ".$domain_detect."<br>";
      exit();*/
      
      if( $domain_detect!="" && $domain_detect==ALK_LDAP_AD_DOMAIN_NAME && $login_detect!="" ) {
        //echo "t11 ".$login_detect." ".$domain_detect;
        // vérifie la connexion, stockage des donnees dans des variable de session
        $bConnectAD = loadUserInfo($login_detect);
      } 
      else {
        // authentification AD echoue ou pas sur le bon domaine, connexion à l'utilisateur anonyme
        //echo "t15;";die();
      }
    } 
  }
}
elseif( defined("ALK_AUTH") && defined("ALK_AUTH_NTLM_APACHE") && ALK_AUTH==ALK_AUTH_NTLM_APACHE ) {
  if( defined("ALK_B_COOKIE") && ALK_B_COOKIE == true &&
      isset($_COOKIE["REMOTE_USER"]) && $_COOKIE["REMOTE_USER"]!="" ) {
     $_SESSION["REMOTE_USER"] = $_COOKIE["REMOTE_USER"];
  }
  
  if( !isset($_SESSION["REMOTE_USER"]) ) {
    // Mémorise les éléments postés
    $_SESSION["ALK_MEM_POST"] = array("URL" => $_SERVER["REQUEST_URI"], "B_HOME" => !( empty($_POST) && empty($_FILES)));
    echo getBodyOnLoadExec("window.location.href = '".ALK_ALKANET_ROOT_URL."auth_ntlm/index.php';");
    exit();
  } else {
    // retour de /auth/index.php avec $_SESSION["REMOTE_USER"] mis à jour après authentification ntlm par apache/mod-perl
    $login_detect = ( isset($_SESSION["REMOTE_USER"]) ? $_SESSION["REMOTE_USER"] : "" );
    
    if( $login_detect != "" && defined("ALK_B_COOKIE") && ALK_B_COOKIE == true ) {
      // cookie expire dans 1 mois par défaut
      $iExpire = ( defined("ALK_COOKIE_EXPIRE") ? 60*ALK_COOKIE_EXPIRE : 60*60*24*30 );    
      setcookie("REMOTE_USER", $login_detect, time()+$iExpire); 
    }
    
    unset($_SESSION["ALK_MEM_POST"]);
  } 
  if( $login_detect != "" )
    $bConnectAD = loadUserInfo($login_detect);
}

if( !$bConnectAD ) {
  AlkFactory::initAnonymousSession();

  $cont_id_start = "1";
  $_SESSION["alk_userHome"] = getUrlDefaut($cont_id_start, $_SESSION["alk_idUser"]);
  $bConnectAD = true;
}

/**
 * l'utilisateur est forcément connecté et identifié par :
 *   - soit un compte dédié dont le login est identique au compte activeDirectory
 *   - soit un compte anonyme
 */
$_SESSION["alk_ldapuser"] = $bConnectAD;

?>