/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

var g_oCtrlFocusOnError = null;
function isRadioRequire(oCtrl) {
  var oCtrlList = oCtrl.form.elements[oCtrl.name];
  var nbElt = oCtrlList.length; 
  if ( !nbElt ){
    return oCtrlList.checked;
  }   
  var bRes = false;
  for(var i=0; i<nbElt; i++) 
    bRes = bRes || oCtrlList.item(i).checked;
  return bRes;
}
function AlkAlertMsg(oCtrl, strMsg)
{
	// affiche l'alerte
  alkAlert(strMsg);
  
  // si le formulaire est de type AlkFormSheets, sélectionne l'onglet
  if( oCtrl.alkSheetManager != "" && oCtrl.alkFormSheetIndex != "-1" && window.AlkSheetOnClick )
	  AlkSheetOnClick(oCtrl.alkSheetManager, oCtrl.alkFormSheetIndex);
	
	// fixe le focus sur le ctrl fautif
  if( oCtrl.focus ) 
  	oCtrl.focus();
  	
  //ajoute un style à la classe du ctrl
  oCtrl.className=oCtrl.className+' inputalert';
  
  // mémorise le ctrl fautif
  g_oCtrlFocusOnError = oCtrl; 
  return;
}

/**
 * NB : si oCtrl.alkType=="select", oMin = liste des index interdits sous forme de chaine séparés par ','
 * @param f                 objet formulaire possédant les controles
 * @param tabCtrlIncluded   tableau contenant les controles à vérifier dans le formulaire (optionnel)
 * @param tabCtrlExcluded   tableau contenant les controles à ne pas vérifier dans le formulaire (optionnel)
 */
function AlkVerifCtrl(f, tabCtrlIncluded, tabCtrlExcluded)
{
  oAlkVerifManager.verifForm(f.name);
  
  var nbCtrl = f.elements.length;
  for(var i=0; i<nbCtrl; i++) {
    var oCtrl = f.elements[i];
    if ( oCtrl.disabled ) continue;
    if( typeof(oCtrl) != "undefined" && typeof(oCtrl.bAlk) != "undefined" ){
      
      // vérifie que le controle est présent dans tabCtrlIncluded
      if ( tabCtrlIncluded ) {
        var bCtrlIncluded = false;
        var j = 0;
        while ( j < tabCtrlIncluded.length ) {
         if ( oCtrl.id == tabCtrlIncluded[j].id ) {
            bCtrlIncluded = true;
          }
          j++;
        }
        if ( !bCtrlIncluded ) {
          continue;
        }
      }
      // vérifie que le controle est absent de tabCtrlExcluded
      if ( tabCtrlExcluded ) {
        var k = 0;
        while ( k < tabCtrlExcluded.length ) {
          if ( oCtrl.id == tabCtrlIncluded[k].id ) {
            continue;
          }
          k++;
        }
      }
      
      var strLabel = oCtrl.alkLabel;
      var bRequire = oCtrl.alkRequire;
      var strType  = oCtrl.alkType;
      var oMin = oCtrl.alkMin;
      var oMax = oCtrl.alkMax;
      var strMsgErr = oCtrl.alkMsgErr; 
      var strExcept = oCtrl.alkExcept;
      var bStrict = oCtrl.alkStrict;
      var strReason = "";

      /*if( oCtrl.type && (oCtrl.type == "text" || oCtrl.type=="textarea") && window.AlkReplaceSpecialChar )
        AlkReplaceSpecialChar(oCtrl);*/
      if( bRequire == true ) {
        if( strType=="memo" || strType=="text" || strType=="mail" || strType=="heure5" ||
            strType=="date10" || strType=="int" || strType=="textnum" || strType=="textalpha" ) {
          if( oCtrl.type!="file" && String.trim ) {
            var oValue = new String(oCtrl.value);
            oCtrl.value = oValue.trim();
          }
          if( oCtrl.value=="" ) { 
            AlkAlertMsg(oCtrl, ( strMsgErr!="" ? strMsgErr : _gtf("Le champ %s est obligatoire.", strLabel))); 
            return false; 
          }
          else if ( strType=="date10" && oCtrl.value=="jj/mm/aaaa" ){
            AlkAlertMsg(oCtrl, (strMsgErr!="" ? strMsgErr : _gtf("Le champ %s est obligatoire.", strLabel))); 
            return false;             
          }
        } else {
          if( strType == "radio" ) {
            if( isRadioRequire(oCtrl) == false ){
              AlkAlertMsg(oCtrl, (strMsgErr!="" ? strMsgErr : _gtf("Le champ %s est obligatoire.", strLabel))); 
              return false;
            }
          } else if( strType == "checkgroup" ) {
            if( isCheckboxRequire(f, oCtrl) == false ){
              AlkAlertMsg(oCtrl, (strMsgErr!="" ? strMsgErr : _gtf("Le champ %s nécessite qu'une case, au moins, soit cochée.", strLabel)));
              return false; 
            }
          } else if ( strType == "select"){
            if( isSelectRequire(f, oCtrl, oMin) == false ){
              AlkAlertMsg(oCtrl, (strMsgErr!="" ? strMsgErr : _gtf("Le champ %s est obligatoire.", strLabel)));
              return false; 
            }
          }
        } 
      }

      switch( strType ) {
        case "memo" :
        case "text" :
          if( oCtrl.value != "" ) {
            if( oMin.toString() != "" && oCtrl.value.length<oMin ) {
              strReason = _ngtf("Le champ %s nécessite au moins "+oMin.toString()+" caractère.", 
                                "Le champ %s nécessite au moins "+oMin.toString()+" caractères.",
                                oMin, strLabel, oMin.toString()); 
              AlkAlertMsg(oCtrl, (strMsgErr!="" ? strMsgErr +"\n" : "" )+strReason);
              return false;
            } 
            if( oMax.toString() != "" && oCtrl.value.length>oMax ) {
              strReason = _ngtf("Le champ %s est limité à "+oMax.toString()+" caractère.", 
                                "Le champ %s est limité à "+oMax.toString()+" caractères.",
                                oMax, strLabel, oMax.toString()); 
              AlkAlertMsg(oCtrl, (strMsgErr!="" ? strMsgErr +"\n" : "" )+strReason);
              return false;
            } 
          }
          break;

        case "textnum" :
          if( oCtrl.value != "" ) {
          var bExcept=false;
              
            if (strExcept != "") {
              var reg=new RegExp("[|]+", "g");
              var tabExcept=strExcept.split(reg);
              for (var j=0; j<tabExcept.length; j++) {
                if ( oCtrl.value == tabExcept[j]) {
                  bExcept=true;
                  break;
                }
              }
            }
            
            strReason = verifTextNum(oCtrl.value, oMin, oMax, strLabel);
            if( strReason != "" && bExcept==false ) {
              AlkAlertMsg(oCtrl, ( strMsgErr!="" ? strMsgErr +"\n" : "") + strReason);
              return false;
            }
          }
          break;

        case "textalpha" :
          if( oCtrl.value != "" ) {
            strReason = verifTextAlpha(oCtrl.value, oMin, oMax, strLabel);
            if( strReason != "" ) {
              AlkAlertMsg(oCtrl, ( strMsgErr!="" ? strMsgErr +"\n" : "") + strReason);
              return false;
            }
          }
          break;

        case "int" :
          if( oCtrl.value != "" ) {
            var bExcept=false;
              
            if (strExcept != "") {
              var reg=new RegExp("[|]+", "g");
              var tabExcept=strExcept.split(reg);
              for (var j=0; j<tabExcept.length; j++) {
                if ( oCtrl.value == tabExcept[j]) {
                  bExcept=true;
                  break;
                }
              }
            }

            strReason = verifNumValid(oCtrl.value, oMin, oMax, bStrict, strLabel);
            if( strReason != "" && bExcept==false ) {
              AlkAlertMsg(oCtrl, ( strMsgErr!="" ? strMsgErr +"\n" : "") + strReason);
              return false;
            }
          }
          break;

       case "date10" : 
          if( oCtrl.value!="" && oCtrl.value!="jj/mm/aaaa" ) {
            strReason = verifDateValidJJMMAAAA(oCtrl.value, oMin, oMax, strLabel);
            if( strReason != "" ) {
              AlkAlertMsg(oCtrl, ( strMsgErr!="" ? strMsgErr +"\n" : "") + strReason);
              return false; 
            }
          }
          break;
       
       case "heure5" : 
          if( oCtrl.value!="" ) {
            strReason = verifHeureValidHHMN(oCtrl.value, oMin, oMax, strLabel);
            if( strReason != "" ) {
              AlkAlertMsg(oCtrl, ( strMsgErr!="" ? strMsgErr +"\n" : "") + strReason);
              return false; 
            }
          }
          break;

       case "datetime16" : 
          if( oCtrl.value!="" ) {
            strReason = verifDateTimeValidJJMMAAAA_HHMN(oCtrl.value, oMin, oMax, strLabel);
            if( strReason != "" ) {
              AlkAlertMsg(oCtrl, ( strMsgErr!="" ? strMsgErr +"\n" : "") + strReason);
              return false; 
            }
          }
          break;

       case "mail" : 
         if( oCtrl.value != "" ) {
           strReason = verifMailValid(oCtrl.value, strLabel);
          if( strReason != "" ) {
            AlkAlertMsg(oCtrl, ( strMsgErr!="" ? strMsgErr +"\n" : "") + strReason); 
            return false;             
          }
        }
        break;
        
       case "checkgroup" :
         strReason = verifNbCheck(f, oCtrl, oMin, oMax, strLabel);
         if( strReason != "" ) {
           AlkAlertMsg(oCtrl, ( strMsgErr!="" ? strMsgErr +"\n" : "") + strReason);
           return false;
         }
       break;
      }
    }
  }
  return true;
}

function AlkAddCtrl(formName, ctrlName, typeCtrl, bRequire, strLabel, oMin, oMax) 
{
  var strMsg = "";
  if( AlkAddCtrl.arguments.length > 7 ) {
    // récupère le param optionnel : message d'erreur personnalisé
    strMsg = AlkAddCtrl.arguments[7];
  }
  
  var strExcept = "";
  if( AlkAddCtrl.arguments.length > 8 ) {
    // récupère le param optionnel : strExcept
    strExcept = AlkAddCtrl.arguments[8];
  }

  var bStrict = true;
  if( AlkAddCtrl.arguments.length > 9 ) {
    // récupère le param optionnel : bStrict
	  bStrict = AlkAddCtrl.arguments[9];
  }

  var iFormSheetIndex = "-1";
  if( AlkAddCtrl.arguments.length > 10 ) {
    // récupère le param optionnel : iFormSheetIndex
	  iFormSheetIndex = AlkAddCtrl.arguments[10];
  }

  var strSheetManager = formName;
  if( AlkAddCtrl.arguments.length > 11 ) {
    // récupère le param optionnel : strSheetManager
	  strSheetManager = AlkAddCtrl.arguments[11];
  }

  oAlkVerifManager.addCtrl(formName, ctrlName, true, typeCtrl, bRequire, strLabel, oMin, oMax, strMsg, strExcept, bStrict, iFormSheetIndex, strSheetManager);
  
  var f = eval("document."+formName);
  var oCtrl = ( f ? f.elements[ctrlName] : null );
  if( oCtrl ) {
    oCtrl.bAlk = true;
    oCtrl.alkType = typeCtrl;
    oCtrl.alkRequire = bRequire;
    oCtrl.alkLabel = strLabel;
    oCtrl.alkMin = oMin;
    oCtrl.alkMax = oMax;
    oCtrl.alkMsgErr = strMsg;
    oCtrl.alkExcept = strExcept;
    oCtrl.alkStrict = bStrict;
    oCtrl.alkFormName = formName;
    oCtrl.alkFormSheetIndex = iFormSheetIndex;
    oCtrl.alkSheetManager   = strSheetManager;
  }
}

AlkCtrl.prototype.constructor = AlkCtrl;
function AlkCtrl(alkCtrlName, bAlk, alkType, alkRequire, alkLabel, alkMin, alkMax, alkMsgErr, alkExcept, alkStrict, alkFormSheetIndex, alkSheetManager)
{
  this.alkCtrlName        = alkCtrlName; 
  this.bAlk               = bAlk;
  this.alkType            = alkType; 
  this.alkRequire         = alkRequire; 
  this.alkLabel           = alkLabel; 
  this.alkMin             = alkMin; 
  this.alkMax             = alkMax; 
  this.alkMsgErr          = alkMsgErr; 
  this.alkExcept          = alkExcept; 
  this.alkStrict          = alkStrict; 
  this.alkFormSheetIndex  = alkFormSheetIndex;
  this.alkSheetManager    = alkSheetManager;
}
AlkCtrl.prototype.setCtrlProperties = function (oCtrl)
{
  if (oCtrl.name!=this.alkCtrlName) return; 
  oCtrl.bAlk               = this.bAlk;
  oCtrl.alkType            = this.alkType; 
  oCtrl.alkRequire         = this.alkRequire; 
  oCtrl.alkLabel           = this.alkLabel; 
  oCtrl.alkMin             = this.alkMin; 
  oCtrl.alkMax             = this.alkMax; 
  oCtrl.alkMsgErr          = this.alkMsgErr; 
  oCtrl.alkExcept          = this.alkExcept; 
  oCtrl.alkStrict          = this.alkStrict; 
  oCtrl.alkFormSheetIndex  = this.alkFormSheetIndex;
  oCtrl.alkSheetManager    = this.alkSheetManager;
}

AlkVerifManager.prototype.constructor = AlkVerifManager;
function AlkVerifManager()
{
  this.tabForms = new Array();
}
AlkVerifManager.prototype.addForm = function (formName)
{
  for (var form in this.tabForms){
    if (form==formName) return;
  } 
  this.tabForms[formName] = new Array();
}
AlkVerifManager.prototype.addCtrlObj = function (formName, alkCtrl)
{
  this.addForm(formName);
  this.tabForms[formName][alkCtrl.alkCtrlName] = alkCtrl;
}
AlkVerifManager.prototype.addCtrl = function (formName, alkCtrlName, bAlk, alkType, alkRequire, alkLabel, alkMin, alkMax, alkMsgErr, alkExcept, alkStrict, alkFormSheetIndex, alkSheetManager)
{
  var oAlkCtrl = new AlkCtrl(alkCtrlName, bAlk, alkType, alkRequire, alkLabel, alkMin, alkMax, alkMsgErr, alkExcept, alkStrict, alkFormSheetIndex, alkSheetManager);
  this.addCtrlObj(formName, oAlkCtrl);
}
AlkVerifManager.prototype.verifForm = function (formName)
{
  var bFound = false;
  for (var form in this.tabForms){
    bFound = (form==formName);
    if (bFound) break;
  } 
  if (!bFound) return;
  var oForm = eval("document."+formName);
  if (!oForm) return;

  for (var ctrlName in this.tabForms[formName]){
	var oAlkCtrl = this.tabForms[formName][ctrlName];
	var oCtrl = oForm.elements[ctrlName];
    if (!oCtrl) continue;
    if( oCtrl.tagName=='INPUT' || oCtrl.tagName=='TEXTAREA' || oCtrl.tagName=='SELECT' || oCtrl.tagName=='OPTION' 
       || (oCtrl.item && oCtrl[0].tagName=="INPUT" && (oCtrl[0].type=="radio" || oCtrl[0].type=="checkbox")) 
    ){
      if ( oCtrl.item && !oCtrl.options ){
      	oCtrl.name = ctrlName;
      	oAlkCtrl.setCtrlProperties(oCtrl);
      	for (var iItem=0; iItem<oCtrl.length; iItem++){
  	      oCtrl.item(iItem).alkFormName = formName;
  	      if(oCtrl.item(iItem).tagName=='INPUT' || oCtrl.item(iItem).tagName=='TEXTAREA' || oCtrl.item(iItem).tagName=='SELECT' || oCtrl.item(iItem).tagName=='OPTION'){
  	        oAlkCtrl.setCtrlProperties(oCtrl.item(iItem));
  	      }
  	    }
      }
      oAlkCtrl.setCtrlProperties(oCtrl);
    }
  }
}
var oAlkVerifManager = new AlkVerifManager();

/** 
 * Exemple de fonction de validation
 *
var AlkNbClickValid = 0;
function ValidateForm()
{
  var f = document.formName;
  if( AlkNbClickValid == 0 ) {
    var bRes = AlkVerifCtrl(f);
    if( bRes == true ) {
      AlkNbClickValid++;
      f.submit();
    }
  }
}
*/
