/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


function AlertMessageCheck(Ctrl, strMsg)
{
  alkAlert(strMsg);
  return;
}

function isCheckboxRequire(oForm, oCtrl) {
  // ensemble de checkbox de même nom (nom avec [])
  var oListCheck = oForm.elements[oCtrl.name];
  if ( oListCheck ){
    if ( oListCheck.length>1 ){
      var bRes = false;
      for (var i=0; i<oListCheck.length && !bRes; i++){
        bRes = bRes || oListCheck[i].checked;
      }
      return bRes;
    }
    else {
      return oListCheck.checked;
    }
  }
  
  var nbElt = oCtrl.value;
  var bRes = false;
  for(var i=0; i<nbElt; i++) {
    var oCB = oForm.elements[oCtrl.name+"_"+i.toString()];
    bRes = bRes || oCB.checked;
  }
  return bRes;
}

function verifNbCheck(oForm, oCtrl, oMin, oMax, strLabel)
{
  var nbCheck = 0;
  var oListCheck = oForm.elements[oCtrl.name];
  if ( oListCheck ){
    if ( oListCheck.length>1 ){
      for (var i=0; i<oListCheck.length; i++){
        if ( oListCheck[i].checked )
          nbCheck++;
      }
    }
    else {
      if ( oListCheck.checked )
        nbCheck++;
    }
  } else {
    var nElt = oCtrl.value;
    for(var i=0; i<nbElt; i++) {
      var oCB = oForm.elements[oCtrl.name+"_"+i.toString()];
      if (oCB.checked)
        nbCheck++;
    }
  }
    
  var reason = "";
  if( oMin != "" && nbCheck < oMin ) {
    reason = ( oMin==oMax
               ? _ngtf("Le champ %s nécessite que %s case soit cochée", "Le champ %s nécessite que %s cases soient cochées.", oMin, strLabel, oMin)  
               : _ngtf("Le champ %s nécessite qu'au moins %s case soit cochée", "Le champ %s nécessite qu'au moins %s cases soient cochées.", oMin, strLabel, oMin) ); 
    return reason;
  }
  
  if( oMax != "" && nbCheck > oMax ) {
    reason = ( oMin==oMax
               ? _ngtf("Le champ %s nécessite que %s case soit cochée", "Le champ %s nécessite que %s cases soient cochées.", oMax, strLabel, oMax)  
               : _ngtf("Le champ %s nécessite qu'au plus %s case soit cochée", "Le champ %s nécessite qu'au plus %s cases soient cochées.", oMax, strLabel, oMax) ); 
    return reason;    
  }

  return reason;
}
