<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/** 
 * @file lib_global.php
 * @package Alkanet_Library
 * @brief Initialise les objects oSpace, oAppli et récupères les variables de bases
 */

// on interdit l'appel direct au lib_global.php
if( isset($_SERVER["PHP_SELF"]) && !(strpos($_SERVER["PHP_SELF"], "lib_global.php") === false) ) {
  exit();
}

// chargement multilingue
if( !isset($bFrontOffice) ) {
  $bFrontOffice = ( defined("ALK_ROOT_URL_FRONTOFFICE") 
                   ? ( ALK_ROOT_URL_FRONTOFFICE==ALK_ROOT_URL ? true : false )
                   : false );
} 
AlkFactory::initLocale($bFrontOffice);

if ( !AlkRequest::readToken() ) {
  echo '<html><head><script type="text/javascript">'.
    ' function onLoadWind() {'.
    '   window.top.location = "'.ALK_ALKANET_IDENT.'?err=7";'.
    ' } </script></head><body onload="onLoadWind()"></body></html>';
  exit();
}

$cont_id = AlkRequest::getToken("cont_id", "-1");
$appli_id = AlkRequest::getToken("appli_id", "-1");

/** 
 * @brief applitype_id permet d'instancier une application n'ayant pas de appli_id
 *        comme l'éditeur, le circuit de validation
 *        Ces applis sont instanciés avec le appli_id qui utilise cette sous-appli
 */
$applitype_id = AlkRequest::getToken("applitype_id", "-1");

if( !(is_numeric($cont_id) && floor($cont_id)==$cont_id && $cont_id > 0) ) {
  echo '<html><head><script type="text/javascript">'.
    ' function onLoadWind() {'.
    '   window.top.location = "'.ALK_ALKANET_IDENT.'?err=7";'.
    ' } </script></head><body onload="onLoadWind()"></body></html>';
  exit();
}

if( !defined("ALK_B_ATYPE_ESPACE") ) define("ALK_B_ATYPE_ESPACE", true);
if( !defined("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE) ) define("ALK_B_ATYPE_ABREV_".ALK_ATYPE_ID_ESPACE, "Espace");

$oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
if( $applitype_id == "-1" ) {
  switch( $appli_id ) {
  case -3: $atype_id = ALK_ATYPE_ID_FORM; break;
  case -2: $atype_id = ALK_ATYPE_ID_SYND; break;
  case -1: $atype_id = ALK_ATYPE_ID_ESPACE; break;
  case 0:  $atype_id = ALK_ATYPE_ID_ANNU;   break;
  default: $atype_id = $oQueryEspace->getATypeID($appli_id); break;
  }
} else {
  $atype_id = $applitype_id;
}

/**
 * initialise la constante ALK_B_IEDIT_MODE_BROUILLON à false si l'on se trouve sur une appli COLLAB ou une appli IEDIT liée à COLLAB
 * doit obligatoirement être effectué avant le chargement des constantes (fonction loadConstants()) sinon ALK_B_IEDIT_MODE_BROUILLON est initialisée avec la valeur définie dans SIT_CONSTANTE
 * remarque : à ce stade la constante ALK_B_ATYPE_COLLAB n'est pas encore définie, il n'est donc pas possible de savoir si l'appli COLLAB est installée en testant cette dernière
 */
if ( $atype_id == ALK_ATYPE_ID_COLLAB ) {
  define("ALK_B_IEDIT_MODE_BROUILLON", false);
}
if ( $atype_id == ALK_ATYPE_ID_IEDIT ) {
  if ( AlkFactory::isAppliTypeInstalled("COLLAB", true) ) {
    $oQueryCollab = AlKFactory::getQuery(ALK_ATYPE_ID_COLLAB);
    if ( $oQueryCollab->isAppliIdLie($appli_id, $atype_id) ) {
      define("ALK_B_IEDIT_MODE_BROUILLON", false);
    }
  }
}

/** chargement des constantes */
$tabCont = array();
$tabAppli = array();
$tabAtype = array();

// paramètres liés au chargement des constantes génériques 
$tabAtype[] = -1;
$tabAtype[] = 1;
$tabAtype[] = 0;
$tabCont[] = -1;
$tabAppli[] = -1;

$tabCont[] = $cont_id;
$tabAppli[] = $appli_id;
$tabAtype[] = $atype_id;
$tabAtype[] = ALK_ATYPE_ID_GEDIT;

// récupération des applications liées
if ($atype_id == ALK_ATYPE_ID_COLLAB){
  if ( !defined("ALK_B_ATYPE_COLLAB") ) define("ALK_B_ATYPE_COLLAB", true);
  $oQueryCollab = AlKFactory::getQuery(ALK_ATYPE_ID_COLLAB);
  $dsAppli = $oQueryCollab->getDsAppliIdLie($appli_id);
  
  while($drAppli = $dsAppli->getRowIter()){
     $tabAtype[] = $drAppli->getValueName("ATYPE_IDL");
     $tabAppli[] = $drAppli->getValueName("APPLI_IDL");
  }
}

AlkFactory::loadConstants($tabCont, $tabAppli, $tabAtype);
//AlkFactory::loadConstants($cont_id, $appli_id);

AlkFactory::setSProperty("cont_id", $cont_id);
AlkFactory::setSProperty("appli_id", $appli_id);
AlkFactory::setSProperty("atype_id", $atype_id);

$oSpace = AlkFactory::getSpace($cont_id);
if( $atype_id > 0 ) {
  $oAppli = AlkFactory::getAppli($atype_id, $appli_id);
} else {
  $oAppli = $oSpace;
}

if( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."app_conf_template.php") ) { 
  require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."app_conf_template.php");
}
if( !defined("ALK_ROOT_TEMPLATE") )  define("ALK_ROOT_TEMPLATE",  ALK_ROOT_CONF."templates/");
/**
 * @brief oAppli->verifSecu() 
 *        met à jour user_priv et user_right par rapport 
 *        à l'espace courant et à l'application courante
 */
$binternet = AlkFactory::getSProperty("bInternet", false);
 
/**
 * Cas particulier pour les popup "mot de passe oublié" ou "Demande de création de compte"
 */
$iTypeSheet = AlkRequest::getToken("iTypeSheet", -1);
$iSheet     = AlkRequest::getToken("iSheet", -1);
$iSSheet    = AlkRequest::getToken("iSSheet", -1);
      
$bPartCase = ( $cont_id>=1 && $appli_id==-1 && 
               (( $iTypeSheet==ALK_TYPESHEET_POPUP && $iSheet==ALK_SHEET_CONTACT && $iSSheet== ALK_SHEET_NONE ) 
                || ( $iTypeSheet==ALK_TYPESHEET_POPUP && $iSheet==ALK_SHEET_CREATEUSER && $iSSheet== ALK_SHEET_NONE ) 
                || ( $iTypeSheet==ALK_TYPESHEET_POPUP && $iSheet==ALK_SHEET_USER_MOTIVATION && $iSSheet== ALK_SHEET_NONE )
                || ( $iTypeSheet==ALK_TYPESHEET_POPUP && $iSheet==ALK_SHEET_FORM && $iSSheet== ALK_SHEET_NONE )
                || ( $iTypeSheet==ALK_TYPESHEET_POPUP && $iSheet==ALK_SHEET_USER && $iSSheet== ALK_SHEET_NONE )
                )) 
          || ( $atype_id==ALK_ATYPE_ID_COLLAB && ($iTypeSheet==ALK_TYPESHEET_POPUP || $iTypeSheet==ALK_TYPESHEET_CONSULT)); 

if( ($atype_id == ALK_ATYPE_ID_FORM && $appli_id==-3 && !$binternet) ||
    ($atype_id == ALK_ATYPE_ID_SYND && $appli_id==-2 && !$binternet) ||
    $binternet && $appli_id>0 ) {
  /* utilisateur authentifié, pas de vérification */
  /* on n'autorise pas l'accès aux applis annuaire et espace en mode internet */
} 
elseif( !is_null($oAppli) && !$oAppli->verifSecu() && !$bPartCase ) {
  echo '<html><head><script type="text/javascript">'.
    ' function onLoadWind() {'.
    '   window.top.location = "'.ALK_ALKANET_IDENT.'?err=6";'.
    ' } </script></head><body onload="onLoadWind()"><!--<a href="javascript:onLoadWind()">Aucun droit, redirection vers l\'authentification.</a>--></body></html>';
  exit();
}
else {
  /* l'utilisateur est authentifié et ses droits vérifiés */
  
  /* on autorise $oAppli à null : cas prodigedist par exemple */
}

if( $oSpace!=null ) {
  $oSpace->updateStat($cont_id, $appli_id);
  
  // enregistrement des connexions
  $oSpace->updateConnnexionUser($_SESSION["alk_idUser"], session_id(), $cont_id, $appli_id);
}

/* par sécurité, on met oSpace à null également, après enregistrement des stats */
if( is_null($oAppli) ) {
  $oSpace = null; 
}

// traduction des éléments déclarés avant l'appel de AlkFactory::initLocale()
translateConf();

?>