<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet
Projet Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH."classes/form/alkhtmlpagealkanet.class.php"); 

/**
 * @file alkhtmlpagealk.class.php
 * @class AlkHtmlPageAlk
 * @package Alkanet_Appli
 * @brief Classe représentant la page html pour le contexte SIT
 */
class AlkHtmlPageAlk extends AlkHtmlPageAlkanet
{

  /**
   * @brief constructeur par défaut
   *
   */
  public function __construct(&$oSpace, &$oAppli)
  {
    parent::__construct($oSpace, $oAppli);

    $this->addLink("icon", ALK_MEDIA_PATH."site/favicon.png");
    $this->addScriptCss($oSpace->getAppliProperty("CONT_CSS"));
    $this->addVarJs("ALK_APPLI_TOKEN", "'".AlkRequest::getEncodeParam("cont_id=".$this->oAppli->cont_id."&appli_id=".$this->oAppli->appli_id, false)."'");
    $this->addVarJs("ALK_CONT_ID", "'".$this->oAppli->cont_id."'");
    $this->addVarJs("ALK_APPLI_ID", "'".$this->oAppli->appli_id."'");

    $this->addOnLoad(" document.onmousemove = position; ");

    if ( ALK_NAV==ALK_NAV_IE7 ){// Traitements spécifiques IE
      $this->addClassCss("body",                       "behavior:url(".ALK_ROOT_DIR."styles/csshover.htc)");
      $this->addClassCss(".menuopener .menu",          "top:15px;");
      $this->addClassCss(".menuopener .submenu",       "left:98.1%;");
    }
    
    $iTypeSheet = AlkRequest::getToken("iTypeSheet", ALK_TYPESHEET_CONSULT);
    $strPopup = ( $iTypeSheet == ALK_TYPESHEET_POPUP ? "_popup" : "" );
    if( $iTypeSheet == ALK_TYPESHEET_POPUP ) {
      $strPopup = "_popup";
      $this->addClassCss("body", "background-color:#ffffff;");
    } else {
      $strPopup = "";
    }

    $strInterfaceType = $oSpace->getAppliProperty("CONT_TYPE");
    if( !defined("ALK_INTERFACE_TYPE") ) {
      define("ALK_INTERFACE_TYPE", mb_strtolower($strInterfaceType));
    }
    
  }

  /**
   * @brief Retourne le code html du menu de gauche
   *        Le menu contient : 
   *          - la liste des applis de l'espace en cours
   *          - la liste des sous-espaces
   * @return string
   */
  protected function getHtmlMenu()
  {
    $cont_id    = AlkRequest::getToken("cont_id",  "-1");
    $appli_id   = AlkRequest::getToken("appli_id", "-1");

    /** Tableau contenant une sous-arbo dans l'appli en cours */
    $tabAppliSubMenu = array();
    $tabAppliMenus = $this->oSpace->getTabMenuAppli($tabAppliSubMenu);

    $tabAppliMenu = $tabAppliMenus["appli"];

    $strMenu = "";
    if( defined("ALK_B_ATYPE_SYND") && ALK_B_ATYPE_SYND==true ) {
      $strMenu .= "<dt class='typeSheet typeSheetMySpace".($appli_id == -2 ? " selected" : "")."'>".
        "<a title=\"Mon espace de publication\" href='".ALK_ALKANET."?token=".AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=-2")."'>Mon espace</a></dt>";
    }

    foreach($tabAppliMenu as $tabAppli) {
      $strTaget = ( $tabAppli["target"] != ""
                    ? " target=\"".$tabAppli["target"]."\" "
                    : "" );
      $strMenu .= "<dt class='typeSheet typeSheetAppli".($appli_id == $tabAppli["id"] ? " selected" : "")."'>".
        "<a ".$strTaget." title=\"".$tabAppli["titre"]."\" href='".$tabAppli["url"]."'>".$tabAppli["titreCourt"]."</a></dt>";
    }

    $tabSpaceMenus = $this->oSpace->getTabMenuSpace(3);
    $tabSpaceMenu = $tabSpaceMenus["child"];
    foreach($tabSpaceMenu as $tabSpace) {
      $strMenu .= "<dt class='typeSheet typeSheetSpace'>".
        "<a title=\"".$tabSpace["title"]."\" href='".$tabSpace["url"]."'>".$tabSpace["shortTitle"]."</a></dt>";
    }
    $tabSpaceMenu = $tabSpaceMenus["brother"];
    foreach($tabSpaceMenu as $tabSpace) {
      $strMenu .= "<dt class='typeSheet typeSheetSpace'>".
        "<a title=\"".$tabSpace["title"]."\" href='".$tabSpace["url"]."'>".$tabSpace["shortTitle"]."</a></dt>";
    }
    
    $strHtml = "<div class='leftMenu'>".( $strMenu != "" ? "<dl>".$strMenu."</dl>" : "" )."</div>";
    return $strHtml;

    /*  return "<div class=leftMenu>           
            <dl id='menu'>            
               <dt class='typeSheet typeSheetMySpace'><a href=\"\">Mon espace</a></dt>
               <dt class='typeSheet typeSheetAppli'><a href=\"\">S.I.T</a></dt>  
               <dt class='typeSheet typeSheetAppli'><a href=\"\">Documents</a></dt>
               <dt class='typeSheet typeSheetAppli'><a href=\"\">Définitions des termes du S.I.T</a></dt>
               <dt class='typeSheet typeSheetSpace'><a href=\"\">Lexique des abréviations</a></dt>
               <dt class='typeSheet typeSheetSpace'><a href=\"\">Dév. économique emploi</a></dt>
               <dt class='typeSheet typeSheetSpace selected'><a href=\"\">Performance de l'Etat</a></dt>

                <dd id='smenu4'>
                  <ul>
                    <li><a href=''>Sous-Menu 4.1</a></li>
                    <li class='selected'><a href=''>Sous-Menu 4.1</a></li>
                  </ul>
                </dd>             
            </dl></div>";*/ 
  }
}
?>