<?php
/*licence/

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Library
Librairie js et php globale à Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once("../../lib/lib_session.php");

$iMode = AlkRequest::_REQUEST("iMode", -1);
switch($iMode){
	case "1": // chargement ajax des services
		$coord_x = AlkRequest::_REQUEST("coord_x", 0);
		$coord_y = AlkRequest::_REQUEST("coord_y", 0);
		if( !defined("ALK_B_ATYPE_CRBN_CAT") )
		define("ALK_B_ATYPE_CRBN_CAT", true);
		$oQueryCRBN = AlkFactory::getQuery(ALK_ATYPE_ID_CRBN_CAT);
		$array["success"] = true;
		$oAppliCRBN = AlkFactory::getAppli(ALK_ATYPE_ID_CRBN_CAT);
		$oDsCommunes = $oQueryCRBN->getDsGeomByCoordinates($coord_x,$coord_y);
		$array["data_com"] = array();
		while ( $oDrList = $oDsCommunes->getRowIter() ) {
			$array["data_com"][] = array(
    				$oDrList->getValueNum(0),
    				trim($oDrList->getValueNum(1))." (".$oDrList->getValueNum(0).")",
    				$oDrList->getValueNum(2)
			);
		}
		echo json_encode($array);
		break;
		
	case "2": // recherche par geometrie
    $box = AlkRequest::_REQUEST("box", "");
    if( !defined("ALK_B_ATYPE_CRBN_CAT") )
    define("ALK_B_ATYPE_CRBN_CAT", true);
    $oQueryCRBN = AlkFactory::getQuery(ALK_ATYPE_ID_CRBN_CAT);
    $oAppliCRBN = AlkFactory::getAppli(ALK_ATYPE_ID_CRBN_CAT);
    $oDsCommunes = $oQueryCRBN->getDsGeomByBox($box);
    $array["data_com"] = array();
    while ( $oDrList = $oDsCommunes->getRowIter() ) {
      $array["data_com"][] = array(
            $oDrList->getValueNum(0),
            trim($oDrList->getValueNum(1)),
            $oDrList->getValueNum(2)
      );
    }

    echo json_encode($array);
    break;	
}
?>