{*licence 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::CEdit
Module consultation éditoriale..
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

licence*}
{php}
require_once ALK_ALKANET_ROOT_PATH."classes/pattern/alkmailing.class.php";

$dbConn = AlkFactory::getDbConn();

if( !defined("ALK_B_ATYPE_ESPACE") ) define("ALK_B_ATYPE_ESPACE", true);
if( !defined("ALK_B_ATYPE_ANNU") ) define("ALK_B_ATYPE_ANNU", true);
if( !defined("ALK_B_ATYPE_COMMENT") ) define("ALK_B_ATYPE_COMMENT", true);
if( !defined("ALK_ANNU_LG_MAX_PSEUDO") ) define("ALK_ANNU_LG_MAX_PSEUDO", 20);
if( !defined("ALK_APP_TITLE") ) define("ALK_APP_TITLE", "MEITO");

$oQueryAnnu   = AlkFactory::getQuery(ALK_ATYPE_ID_ANNU);
$oQueryComment   = AlkFactory::getQuery(ALK_ATYPE_ID_COMMENT);
$oQueryActionComment   = AlkFactory::getQueryAction(ALK_ATYPE_ID_COMMENT);

$dbConn = AlkFactory::getDbConn();

$strHtml      = "";

AlkRequest::readToken();

$cont_id_data   = AlkRequest::getToken("cont_id",  "-1");
$appli_id       = AlkRequest::getToken("appli_id",  "-1");
$appli_id_data  = AlkRequest::getToken("appli_id_data",  "-1");
$data_id        = AlkRequest::getToken("data_id",  "-1");
$formName       = AlkRequest::getToken("formName",  "");

$iMode        = AlkRequest::_REQUEST("iMode",  "-1");
$strLg        = ( isset($this->tabLangue[ALK_LG]["rep"]) ? $this->tabLangue[ALK_LG]["rep"] : ALK_LG_FR );

//echo "cont_id=".$cont_id."&appli_id=".$appli_id."&appli_id_data=".$appli_id_data."&data_id=".$data_id."<br/>";
$strTokenComment = AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=".$appli_id."&appli_id_data=".$appli_id_data."&data_id=".$data_id."&formName=".$formName);

if (!isset($_SESSION["alk_idAboComment"]) && $iMode==4) {
  $iMode = 0;
}

/* form message */
function getFormCommentaire($strToken, $formName, $bNew=false)
{
  $strHtml = '<form name="'.$formName.'" method="post" >
      <input type="hidden" name="iModeAddCtrl" value="5"/>
      <input type="hidden" name="iModeValide" value="5"/>
      <input type="hidden" name="tokenComment" value="'.$strToken.'"/> 
      <h3>Déposez '.( $bNew==true ? 'un nouveau' : 'votre' ).' commentaire</h3>
      <p>
        Votre pseudo*<br/>
        <strong>'.$_SESSION["alk_pseudoAboComment"].'</strong>
        <input type="hidden" value="'.$_SESSION["alk_pseudoAboComment"].'" name="nom_abo"/>
      </p>
      <p>
        Votre commentaire*<br/>
        <textarea rows="5" cols="60" style="width: 400px;" class="formCtrl" name="message" ></textarea>
      </p>
      <p>
        Code de s&eacute;curit&eacute;*<br/>
        <a title="Obtenir un autre code" href="javascript:loadSecureImg(\'sImgSecureCode\')">
          <img id="sImgSecureCode" src="/scripts/alkanet/alkanet_security_image.php" height="25" border="0" align="absmiddle" />
        </a>&nbsp;&nbsp;
        <input type="text" name="securecode" value="" class="formCtrl" style="width: 146px;" size="20" maxlength="20">
      </p>
      <div id="retour_ligne"></div>
      <p class=""><a class="" href="javascript:ValidationComment(\''.$formName.'\');">Valider</a></p>
      <div id="retour_ligne"></div>
    </form>';

  return $strHtml;
}
      
/* Form identification */
function getFormIdentification($strToken, $formName, $bErr=false)
{
  $strHtml = '<form name="'.$formName.'" method="post" >
      <input type="hidden" name="iModeAddCtrl" value="1"/>
      <input type="hidden" name="iModeValide" value="1"/>
      <input type="hidden" name="tokenComment" value="'.$strToken.'"/>'.
      ( $bErr
        ? '<h3>Abonn&eacute; inconnu, veuillez r&eacute;essayer</h3>'
        : '<h3>Pour d&eacute;poser un commentaire, merci de vous identifier</h3>' ).'
      <p>
        Votre courriel*<br/>
        <input type="text" maxlength="255" size="40" style="width: 296px;" class="formCtrl" value="" name="mail_abo"/>
      </p>
      <p>
        Votre mot de passe*<br/>
        <input type="password" maxlength="10" size="12" style="width: 96px;" class="formCtrl" value="" name="pwd_abo"/>
      </p>
      <div id="retour_ligne"></div>
        <p class="bouton">
          <a class="bouton" href="javascript:ValidationConnexion(\''.$formName.'\');">Valider</a>
        </p>
        <div id="retour_ligne"></div>
        <ul class="liens">
          <li>
            <a href="javascript:changeFormulaire(2, \''.$formName.'\')">cliquez ici si vous n\'&ecirc;tes pas encore inscrit</a><br/>
          </li>
          <li>
            <a href="javascript:changeFormulaire(6, \''.$formName.'\')">cliquez ici si vous avez oubli&eacute; votre mot de passe</a>
          </li>
        </ul>
      </form>';
        
  return $strHtml;
}

function getFormInscription($strToken, $formName)
{
  $strHtml = '<form name="'.$formName.'" method="post">
    <input type="hidden" name="iModeAddCtrl" value="2"/>
    <input type="hidden" name="iModeValide" value="3"/>
    <input type="hidden" name="tokenComment" value="'.$strToken.'"/>
    <h3>Inscription</h3>
    <p>Votre nom<br/><input type="text" maxlength="255" size="40" style="width: 296px;" class="formCtrl" value="" name="nom_abo"/>
    <p>Votre prénom<br/><input type="text" maxlength="255" size="40" style="width: 296px;" class="formCtrl" value="" name="prenom_abo"/>
    <p>Votre pseudo<br/><input type="text" maxlength="255" size="40" style="width: 296px;" class="formCtrl" value="" name="pseudo_abo"/>
    <p>Votre courriel<br/><input type="text" maxlength="255" size="40" style="width: 296px;" class="formCtrl" value="" name="mail_abo"/>
    <p>Votre mot de passe<br/><input type="password" maxlength="12" size="10" style="width: 296px;" class="formCtrl" value="" name="pwd_abo"/>
    <p>Confirmez votre mot de passe<br/><input type="password" maxlength="12" size="10" style="width: 296px;" class="formCtrl" value="" name="pwd_abo2"/>
    <p>
      Code de sécurité*<br/>
      <a title="Obtenir un autre code" href="javascript:loadSecureImg(\'sImgSecureCode\')">
        <img id="sImgSecureCode" src="/scripts/alkanet/alkanet_security_image.php" height="25" border="0" align="absmiddle" />
      </a>&nbsp;&nbsp;
      <input type="text" name="securecode" value="" class="formCtrl" style="width: 146px;" size="20" maxlength="20">
    </p>
    <div id="retour_ligne"><p class="bouton"><a href="javascript:ValidationInscription(\''.$formName.'\');" class="bouton">Valider</a></p>
    <div id="retour_ligne"><p class="bouton"><a href="javascript:changeFormulaire(1, \''.$formName.'\')" class="bouton">Annuler</a></p><div id="retour_ligne">
    </form>';
}

function getFormOubliPwd($strToken, $formName)
{
  $strHtml = '<form name="'.$formName.'" method="post">
    <input type="hidden" name="iModeAddCtrl" value="6"/>
    <input type="hidden" name="iModeValide" value="7"/>
    <input type="hidden" name="tokenComment" value="'.$strToken.'"/>
    <h3>Oubli de mot de passe</h3>
    <p>Votre courriel<br/><input type="text" maxlength="150" size="40" style="width: 296px;" class="formCtrl" value="" name="mail_abo"/>
    <div id="retour_ligne"><p class="bouton"><a href="javascript:ValidationConnexion(\''.$formName.'\');" class="bouton">Valider</a></p>
    <div id="retour_ligne"><p class="bouton"><a href="javascript:changeFormulaire(1, \''.$formName.'\')" class="bouton">Annuler</a></p><div id="retour_ligne">
    </form>';
    
  return $strHtml;
}

switch ($iMode){

  case 0:
    //formulaire d'authentification
    echo getFormIdentification(strTokenComment, $formName, $bErr==1);
    break;

  case 1 :
    //Authentification normale
    $abonne_mail  = AlkRequest::_POST("mail_abo","");
    $abonne_pwd   = AlkRequest::_POST("pwd_abo", "");
    $strDecode    = "";
    for($i=0; $i<strlen($abonne_pwd); $i+=2 ) {
      $strDecode .= chr(hexdec($abonne_pwd[$i].$abonne_pwd[$i+1]));
    }
    $abonne_pwd = $strDecode;
        
    $dsAbonne = $oQueryAnnu->getDsAbonneByMailMdp($abonne_mail, $abonne_pwd); 
    if( $dsAbonne->isEndOfFile()==false ) {
      $drAbonne = $dsAbonne->getRowIter();      
      $_SESSION["alk_idAboComment"]     = $drAbonne->getValueName("ABONNE_ID");
      $_SESSION["alk_pseudoAboComment"] = $drAbonne->getValueName("ABONNE_PSEUDO");
      $_SESSION["alk_mailAboComment"]   = $drAbonne->getValueName("ABONNE_MAIL");
      echo getFormCommentaire($strTokenComment, $formName);
    } else {
      echo getFormIdentification($strTokenComment, $formName, true);
    } 
    break;
        
  case 2 :
    // Formulaire Inscription
    echo getFormInscription(strTokenComment, $formName); 
    break;
    
  case 3 :
    // Traitement Inscription
    $abonne_nom     = AlkRequest::_POST("nom_abo", REQ_POST, "");
    $abonne_prenom  = AlkRequest::_POST("prenom_abo", REQ_POST, "");
    $abonne_pseudo  = AlkRequest::_POST("pseudo_abo", REQ_POST, "");
    $abonne_mail    = AlkRequest::_POST("mail_abo", REQ_POST, "");
    $abonne_pwd     = AlkRequest::_POST("pwd_abo", REQ_POST, "");
    $abonne_valide  = 1;
        
    $strDecode = "";
    for($i=0; $i<strlen($abonne_pwd); $i+=2 ) {
      $strDecode .= chr(hexdec($abonne_pwd[$i].$abonne_pwd[$i+1]));
    }
    
    $abonne_pwd = $strDecode;
      
    $abonne_id = AlkFactory::getQueryAction(ALK_ATYPE_ID_ANNU)->addAbonne( $appli_id, "null", $abonne_nom, $abonne_prenom, $abonne_mail, $abonne_valide, "", "", "", "", "", $abonne_pwd, $abonne_pseudo);
    if( $abonne_id>0 ) {
      $_SESSION["alk_idAboComment"] = $abonne_id;
      $dsAbonne = $oQueryAnnu->getDsAbonne($abonne_id); 
      if( $drAbonne = $dsAbonne->getRowIter() ) {
        $abonne_pseudo = $drAbonne->getValueName("ABONNE_PSEUDO");
      }
      $_SESSION["alk_pseudoAboComment"] = $abonne_pseudo;
      $_SESSION["alk_mailAboComment"] = $abonne_mail;
        
      /* envoi du mail de confirmation */
      $strMessage = '<p>'.$abonne_nom.',<br/><br/>
         Veuillez trouver ci-dessous le rappel de vos paramètres de connexion :</p>
         <p> - Pseudo : '.abonne_pseudo.'</p>
         <p> - Identifiant : '.$abonne_mail.'</p>
         <p> - Mot de passe : '.$abonne_pwd.'</p>
         <p>Ils vont vous permettre de déposer des commentaires sur les pages du site '.ALK_APP_TITLE.'.</p>
         <p>Bonne visite sur notre site internet.</p>
         <p>'.ALK_MAIL_ADMIN_NAME.'</p>';
         
      $oAlkMail = AlkFactory::getMail();
      $oAlkMail->SetSubject(ALK_APP_TITLE." - vos identifiants");
      $oAlkMail->SetHtml(true);
      $oAlkMail->SetBody($strMessage);
      $oAlkMail->SetFrom(ALK_MAIL_ADMIN_NAME, ALK_MAIL_ADMIN_MAIL);
      $oAlkMail->AddTo($abonne_nom, $abonne_mail);
      $res = $oAlkMail->Send();

      echo getFormCommentaire($strTokenComment, $formName);

      //echo "<form name=\"message\" method=\"post\" action=\"\"><p><strong>Vous pouvez désormais poster des messages sur le forum</strong></p></form>";
    } 
    break;   
    
  case 4 : 
    // Dépot de commentaire
    echo getFormCommentaire($strTokenComment, $formName, true);  
    break;
           
  case 5 : 
    //Traitement dépot de commentaire
    $abonne_nom   = AlkRequest::_POST("nom_abo", "");
    $strMessage   = AlkRequest::_POST("message", "");
    $bModeration  = 0;
    
    $oQueryEspace  = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);

    switch ($oQueryEspace->getATypeID($appli_id_data)) {
      case 21: //actualité
        $nom_table="ACTU_01_ACTUALITE";
        $champ_id="ACTU_ID";
        break;
        
      case 23://gestion éditoriale
        $nom_table="GEDIT_01_PAGE";
        $champ_id="PAGE_ID";
        break;

      case 66: //iedit
         $nom_table="IEDIT_DATA";
         $champ_id="DATA_ID";
         break;
    }
        
    $dsAutorisation = $oQueryComment->GetDs_Autorisation($appli_id, $appli_id_data, $data_id, $nom_table, $champ_id);
    if( $drAutorisation = $dsAutorisation->GetRowIter() ) {
      $bModeration = $drAutorisation->getValueName("AUTORISATION_MODERATION");
    }
    $titre = $oQueryEspace->GetStr_applicationIntitule($appli_id_data);
    $comment_id = $oQueryActionComment->insertComment($titre, $abonne_nom, $strMessage, (($bModeration==1)?0:1), $_SESSION["alk_idAboComment"], $nom_table, $champ_id, $data_id, $appli_id, $appli_id_data);
        
    if( $bModeration==1 ) {//commentaire modéré
      echo '<p class="message">Votre commentaire a bien été pris en compte.<br/>
        Il sera ajouté à la liste après modération par notre administrateur.</p>';
    } else {      
      echo '<p class="message">Votre commentaire a été ajouté</p>';
    } 
    echo getFormCommentaire($strTokenComment, $formName, true); 

    break;   
              
  case 6 : 
    //Oubli de mot de passe
    echo getFormOubliPwd(strToken, $formName); 
    break;
        
  case 7 : 
    //Traitement Oubli de mot de passe
    $abonne_mail = AlkRequest::_REQUEST("mail_abo", "");
    $dsAbonne = $oQueryAnnu->getDsAbonneByMailMdp($abonne_mail, ""); 
    if( $drAbonne = $dsAbonne->getRowIter() ) {
      $abonne_mail   = $drAbonne->getValueName("ABONNE_MAIL");
      $abonne_nom    = ( $drAbonne->getValueName("ABONNE_PRENOM") != ""
                         ? $drAbonne->getValueName("ABONNE_PRENOM")." "
                         : "")."".$drAbonne->getValueName("ABONNE_NOM");
      $abonne_pseudo = $drAbonne->getValueName("ABONNE_PSEUDO");
      $abonne_pwd    = $drAbonne->getValueName("ABONNE_PWD");
      
      $strMessage    = '<p>'.$abonne_nom.' ('.$abonne_pseudo.'),<br/><br/>
         Veuillez trouver ci-dessous le rappel de vos paramètres de connexion :</p>
         <p> - Identifiant : '.$abonne_mail.'</p>
         <p> - Mot de passe : '.$abonne_pwd.'</p>
         <p>Ils vont vous permettre de déposer des commentaires sur les pages du site '.ALK_APP_TITLE.'.</p>
         <p>Bonne visite sur notre site internet.</p>
         <p>'.ALK_MAIL_ADMIN_NAME.'</p>';
        
      $oAlkMail = AlkFactory::getMail();
      $oAlkMail->SetSubject(ALK_APP_TITLE." - vos identifiants");
      $oAlkMail->SetHtml(true);
      $oAlkMail->SetBody($strMessage);
      $oAlkMail->SetFrom(ALK_MAIL_ADMIN_NAME, ALK_MAIL_ADMIN_MAIL);
      $oAlkMail->AddTo($abonne_nom, $abonne_mail);
      $res = $oAlkMail->Send();
      
      //Envoi du mail
      echo '<p class="message">Vous allez recevoir par mail (<i>'.$abonne_mail.'</i>) vos identifiants de connexion.</p>';
      echo getFormIdentification($strTokenComment, $formName);        
    } else {
      echo getFormIdentification($strTokenComment, $formName, true);
    } 
    break;

  case 8: // mise à jour de la liste des commentaires
    $dsComments = $oQueryComment->GetDs_CommentsList($appli_id, $appli_id_data, $data_id, 1, 0, -1, "", "", true);
    $strHtml = '';
        
    while( $drComments = $dsComments->GetRowIter() ) {
      $comment_id          = $drComments->GetValueName("COMMENT_ID");
      $comment_description = $drComments->GetValueName("COMMENT_DESC");
      $nom_table           = $drComments->GetValueName("NOM_TABLE");
      $champ_id            = $drComments->GetValueName("CHAMP_ID");
      $valeur_id           = $drComments->GetValueName("VALEUR_ID");
      $comment_titre       = $drComments->GetValueName("COMMENT_TITRE");
      $comment_auteur      = $drComments->GetValueName("AUTEUR");
      $comment_date        = $drComments->GetValueName("COMMENT_DATEL");
          
      $strHtml .= '<div class="commentaire">
        <p class="auteur"><span class="date">'.$comment_date.'</span><br/>
        <span class="nom">'.$comment_auteur.'</span> a dit</p>
        <p>'.nl2br($comment_description).'</p>
        </div>';
    }
    echo $strHtml;
    break; 
      
  case 9: //mise à jour du nombre de commentaires
    $dsComments = $oQueryComment->GetDs_CommentsList($appli_id, $appli_id_data, $data_id);
    //echo $dsComments->getCountDr()." commentaire".(($dsComments->getCountDr()>1?"s":""));
    echo $dsComments->getCountDr();
    break;
}  
{/php}
