<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet
Page d'accueil extranet Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


session_start();

session_destroy();
$_SESSION = array();

require("lib/lib_session.php");

if( !defined("ALK_B_ATYPE_ESPACE") ) define("ALK_B_ATYPE_ESPACE", true);
if( !defined("ALK_B_ATYPE_IEDIT") ) define("ALK_B_ATYPE_IEDIT", true);
if( !defined("ALK_B_ATYPE_GEDIT") ) define("ALK_B_ATYPE_GEDIT", true);

define("ALK_LG", $_SESSION["ALK_LG"]);

if( !defined("ALK_LG_BDD") ) {
  define("ALK_LG_BDD", $GLOBALS["_LG_tab_langue"][ALK_LG]["bdd"]);
}
if( !defined("ALK_LG_REP") ) {
  define("ALK_LG_REP", $GLOBALS["_LG_tab_langue"][ALK_LG]["rep"]);
}

$cont_id     = AlkRequest::_GET("cont_id", "-1");
$appli_id    = AlkRequest::_GET("appli_id", "-1");
$datatype_id = AlkRequest::_GET("datatype_id", "-1");
$data_id     = AlkRequest::_GET("data_id", "-4");
$cat_id      = AlkRequest::_GET("cat_id", "-1");
$pub         = AlkRequest::_GET("pub", "1"); 
$une         = AlkRequest::_GET("une", "0");
$user_id     = AlkRequest::_GET("user_id", "-1");
$lg          = AlkRequest::_GET("lg", "_FR");

if ($appli_id==-1){
	switch ($datatype_id) {
		case ALK_ATYPE_ID_ACTU:
			$page_appli_id = $GLOBALS["appli_id_actu"];
			break;
		case ALK_ATYPE_ID_EVENT:
			$page_appli_id = $GLOBALS["appli_id_agenda"];
			break;
	}
} else {
	$page_appli_id = $appli_id;
}

$oSpace       = AlkFactory::getSpace(($cont_id=="-1" ? 1 : $cont_id));
$oAppli       = AlkFactory::getAppli($datatype_id, $page_appli_id);
$idAppliGedit = -1;

if(!defined("ALK_APP_TITLE")) define("ALK_APP_TITLE", $oSpace->getAppliProperty("CONT_INTITULE"));

$oQueryEspace  = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
$oQueryIEdit   = AlkFactory::getQuery(ALK_ATYPE_ID_IEDIT);
$oQueryGEdit   = AlkFactory::getQuery(ALK_ATYPE_ID_GEDIT);

$dsApplisEspace = $oQueryEspace->getDs_listeAppliByEspace(($cont_id=="-1" ? 1 : $cont_id));
while ($drApplisEspace = $dsApplisEspace->getRowIter()){
  switch ($drApplisEspace->getValueName("ATYPE_ID")) {
    case ALK_ATYPE_ID_GEDIT:
      $idAppliGedit = $drApplisEspace->getValueName("APPLI_ID");
      break;
  }
}

/* url réécrite de l'application */
$strPageUrl = ALK_ROOT_URL;
$dsArbo = $oQueryGEdit->getArboAutorise(ALK_USER_ID_INTERNET, $idAppliGedit, true, "-1", true, "-1", "-1", 1, true);
while($drArbo = $dsArbo->getRowIter()){
	if ($drArbo->getValueName("PAGE_APPLIID")==$page_appli_id && $drArbo->getValueName("PAGE_CATID")=="-1"){
		$strPageUrl = ALK_ROOT_URL.$drArbo->getValueName("PAGE_URL_FR");
	  break;
	}
}

$strDataTypeName = $oQueryIEdit->getStrTypeData($datatype_id, $page_appli_id);
$bOk = true;

// info publiée = 16, info à la une = 4
$iFiltre = ( $une == "1" ? TASSOC_ALAUNE : TASSOC_PUBLIE );
if( $user_id != "-1" && $pub == "0" ) {
  // vérifie que l'utilisateur a le droit de publication sur l'application
  $iRight = $oAppli->getUserAppliRight();
  $bOk = ( $iRight == ALK_APPLI_RIGHT_PUBLI );
  // info à valider
  $iFiltre = TASSOC_AVALIDER; 
  if( $data_id > 0 ) $data_id = -1; 
} else {
  // filtre sur données syndiquée uniquement
  $iFiltre += 128; 
}

$oFSyndXml = AlkFactory::getFSyndXmlWriter(ALK_RSS2);
if( defined("ALK_USER_ID_INTERNET") && $user_id == "-1") {
  $oFSyndXml->setTitle(ALK_APP_TITLE." - ".$oAppli->getAppliProperty("APPLI_INTITULE"));
  $oFSyndXml->setDescription("Flux RSS 2.0 listant toutes les informations éditoriales".( $pub=="0" ? " à valider" : ( $une == "1" ? " à la une" : "" ))." de ".ALK_APP_TITLE);
} else {
  $oFSyndXml->setTitle($user_id."Toutes les informations éditoriales".( $pub=="0" ? " à valider" : ( $une == "1" ? " à la une" : "" ))." de type ".$strDataTypeName);
  $oFSyndXml->setDescription("Flux RSS 2.0 provenant de ".ALK_APP_TITLE);
}
$oFSyndXml->setLink(ALK_ROOT_URL.$_SERVER["REQUEST_URI"]);

if( $bOk ) {
  $typeAssoc = TASSOC_BYDATA; 
  $object_id = $data_id;
  switch( $data_id ) {
    case -4: $typeAssoc = TASSOC_EMPTY+TASSOC_SYNDIC; $object_id = -1;        break;
    case -3: $typeAssoc = TASSOC_EMPTY; $object_id = $cont_id;  break;
    case -2: $typeAssoc = TASSOC_BYAPPLI; $object_id = $appli_id; break;
    case -1: $typeAssoc = TASSOC_BYCATEG; $object_id = $cat_id;   break;
  }
  $typeAssoc." + ".$iFiltre;
  $typeAssoc += $iFiltre;
  
  // recherche les infos à syndiquer
  $tabData = $oAppli->getDataContents($object_id, $typeAssoc, $user_id, $lg, $datatype_id, TASSOC_DATEPUB_DESC);
  $tabDataId = array();
  foreach($tabData as $tabContent ) {
    if(!in_array($tabContent["data_id"],$tabDataId)){
    	$tabDataId[] = $tabContent["data_id"];
    	$newItem = $oFSyndXml->createNewItem();
      
      if( $datatype_id == ALK_ATYPE_ID_FAQS ) {
        // faqs
        $newItem->setTitle($tabContent["data_desc"]);
      } else {
        // actu, lien, glos
        $newItem->setTitle($tabContent["data_title"]);
      }
      
      /**/
      if( $datatype_id == ALK_ATYPE_ID_ACTU ) {
        if( $data_id < 0 ) {
          // en mode liste, uniquement desc courte
          $newItem->setDescription($tabContent["data_desc"]);
        } else {
          // en mode fiche, desc courte + desc longue
          $newItem->setDescription($tabContent["data_desc"]."<br/>".$tabContent["data_descl"]);
        }          
      } else {
        $newItem->setDescription($tabContent["data_descl"]);
      }

      // lien et actu
      $newItem->setLink(getRewriteUrlData($strPageUrl, "", false, $tabContent["cat_id"], $tabContent["data_id"], -1, "", $tabContent["data_title"]));
      
      //$newItem->setGuid(ALK_ALKANET_ROOT_URL."rss.php/".$cont_id."_".$appli_id."_".$tabContent["data_id"]);

      if( $datatype_id == ALK_ATYPE_ID_ACTU ) {
        // actu
        if( $tabContent["data_datedeb"] != "" )
          $newItem->setDate($tabContent["data_datedeb"], "%d/%m/%Y");
        elseif( $tabContent["data_datepdeb"] != "" )
          $newItem->setDate($tabContent["data_datepdeb"], "%d/%m/%Y");
        else
          $newItem->setDate($tabContent["data_datemaj"], "%d/%m/%Y");
      } else {
        $newItem->setDate($tabContent["data_datemaj"], "%d/%m/%Y");
      }
      
      
      
      if( $tabContent["data_visuel"] != "" ) {
         if ( function_exists("resizeImage") ){
           // si le flux est destiné à un téléphone mobile on renvoie le visuel small
           $strKey = ($data_id>0 ? "large" : "small");
           $data_visuel_defaut = substr($tabContent["data_visuel"], 0,-4)."_".$strKey.strtolower(substr($tabContent["data_visuel"],-4));
           $newItem->setEncloser($data_visuel_defaut, $tabContent["data_visuel_size"], $tabContent["data_visuel_typemime"]);             
         } else {
           $newItem->setEncloser($tabContent["data_visuel"], $tabContent["data_visuel_size"], $tabContent["data_visuel_typemime"]);
         }
      }
      if ( $tabContent["data_nbpj"]>0 ){
        foreach($tabContent["data_pj"] as $tabPj) {
          $newItem->setEncloser($tabPj["strUrlFile"], filesize($tabPj["strPathFile"]), 
                                getTypeMime($tabPj["strPathFile"]), $tabPj["strNameAff"]);
        }
      }
      $oFSyndXml->addItem($newItem);
    }
  }

}

$oFSyndXml->genarate(); 
?>