<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::{$appli_abrev_classe}
Module {$appli_abrev_classe}.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkappli.class.php";

/**
 * @package Alkanet_Module_{$appli_abrev_classe} 
 *          Une description longue du package et de ses classes
 * 
 * @class AlkAppli{$appli_abrev_classe}
 * @brief Description de la classe
 *
 * Description longue de la classe
 */
class AlkAppli{$appli_abrev_classe} extends AlkAppli implements AlkIntAppli, AlkIntRights 
{

  /**
   * Constructeur par défaut
   *
   * @param oSpace Référence vers l'objet de l'espace en cours
   */
  public function __construct($appli_id)
  {
    parent::__construct(ALK_ATYPE_ID_{$appli_constante}, $appli_id);
  }

  /**
   * Destructeur par défaut
   */
  public function __destruct() { }
  
  // --------- interface AlkIntAppli ----------
  
  /**
   * Méthode appelée après création puis ajout de l'application à un espace.
   * Implémenter les actions à effectuer pour initialiser l'application
   * @param tabFields tableau associatif des champs nécessaires à la création d'une appli
   * @return int
   */
  public function addAppli($tabFields) { /** rien à faire */ }

  /**
   * Méthode appelée après modification des propriétés d'une application à un espace.
   * @param tabFields tableau associatif des champs nécessaires à la création d'une appli
   */
  public function updateAppli($tabFields) { /** rien à faire */ }

  /**
   * Méthode appelée avant suppression définitive d'une application d'un espace
   * Implémenter les actions effectuant le ménage interne à l'application
   */
  public function delAppli() { /** rien à faire */ }

  /**
   *  Déplacement d'une application d'un espace vers un autre
   *        Cette méthode se charge d'appelé la recopie des droits
   * @param appli_id  identifiant de l'appli
   * @param idContTo  identifiant de l'espace recevant l'appli
   */
  public function moveAppli($idContTo) { /** rien à faire */  }

  /**
   * Duplication de la structure et du paramètrage de l'application src à la courante
   * @param appli_id_src  identifiant de l'application source
   * @param iTypeDup      type de duplication : 0 = application vierge (ne fait rien) 
   *                                            1 = structure et paramétrage
   *                                            2 = structure, paramétrage et données  
   */
  public function dupAppli($appli_id_src, $iTypeDup) { /** rien à faire */ }
  
  // --------- interface AlkIntRights ----------
  
  /**
   *  Transfère de propriété d'un utilisateur à un autre
   *        Méthode à appeler avant suppression définitive d'un utilisateur
   * @param idUserFrom  identifiant de l'utilisateur perdant la propriété des ses données
   * @param idUserTo    identifiant de l'utilisateur récupérant la propriété des données
   */
  public function replaceUser($idUserFrom, $idUserTo) { /** rien à faire */ }

  /**
   *  Invitation d'un utilisateur à un espace (tous si cont_id=-1, tous les espaces publics si cont_id=-2)
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces. -2 tous les espaces publics
   * @param priv_id  identifiant du privilège
   */
  public function addUserToSpace($user_id, $cont_id, $priv_id) { /** rien à faire */ }

  /**
   *  Modification du privilège espace pour l'utilisateur à un espace (tous si cont_id=-1)
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces.
   * @param priv_id  identifiant du privilège
   */
  public function updateUserPrivToSpace($user_id, $cont_id, $priv_id) { /** rien à faire */ }

  /**
   *  Suppression de l'accès à un espace (ou tous si cont_id=-1) pour un utilisateur
   * @param user_id  identifiant d'un utilisateur
   * @param cont_id  identifiant de l'espace. -1 pour tous les espaces.
   */
  public function removeUserFromSpace($user_id, $cont_id) { /** rien à faire */ }

  /**
   *  Personnalisation des droits d'un utilisateur
   * @note Appelé en admin. annuaire avec gestion des droits sur un profil sur l'espace courant
   * @param cont_id       identifiant de l'espace
   * @param user_id       identifiant de l'utilisateur sélectionné
   * @param iRight        non utilisé
   * @param iDefaultRight non utilisé
   */
  public function setUserRightsOnSpace($cont_id, $user_id, $iRight=-1, $iDefaultRight=-1) { /** rien à faire */ }

  /**
   *  Enregistre les droits des profils sur les applications d'un espace
   * @param cont_id       identifiant d'utilisateur
   * @param tabRight      non utilisé dans le cas espace, 
   *                      sinon tableau de type "_".idProfil => droid_id pour les autres applis
   */
  public function setProfilRightsOnSpace($cont_id, $tabRight=array()) { /** rien à faire */ }

  /**
   *  Application de droits sur les profils pour l'application
   * @note Appelé en config. espace avec gestion des droits sur les profils pour l'appli
   * @param atype_id  type d'application
   * @param appli_id  identifiant de l'application
   */
  public function setRightsOnAppli($atype_id, $appli_id) { /** rien à faire */ }
  
  /**
   * Applique les droits d'un utilisateur par rapport à ses profils
   * @param user_id  identifiant de l'utilisateur 
   */
  public function setProfilRightToUser($user_id) {}
  
  
  /** 
   *  Ajout d'un profil sur l'extranet.
   *        Si l'application gère des droits, il faut y associer le droit NONE
   * @param profil_id  identifiant du profil à supprimer
   * @param cont_id    identifiant de l'espace associé, =0 pour tous les espaces (par défaut)
   */
  public function addProfil($profil_id, $cont_id=0) { /** rien à faire */ }
  
  /** 
   *  Suppression d'un profil sur l'extranet.
   *        Si l'application gère des droits, il faut supprimer les droits associés
   * @param profil_id  identifiant du profil à supprimer
   */
  public function delProfil($profil_id) { /** rien à faire */ }
  
  
  /** heritage AlkAppli */
  
  /**
   * Retourne l'objet Panel correspondant au iSheet et iSSheet sélectionné
   * 
   * @param oAppliFrom    AlkAppli   Application appelant cette fonction (principe call services par dérivation)
   * 
   * @return AlkHtmlPanel
   */
  public function getPanel(AlkAppli $oAppliFrom=null)
  {  
    $oPanel = null;
    switch( $this->iTypeSheet ) {
      case ALK_TYPESHEET_CONSULT: // partie consultation
        switch ( $this->iSheet ){
        case ALK_SHEET_CONSULTATION : 
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."{$appli_dir}/classes/alkhtmlformconsult{$appli_abrev_fichier}list.class.php");
          $oPanel = new AlkHtmlFormConsult{$appli_abrev_classe}List($this);
          break; 
        }
        break;
  
      case ALK_TYPESHEET_ADMIN: // partie admin
        switch ( $this->iSheet ){
        case ALK_SHEET_ADMINISTRATION : //
          require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."{$appli_dir}/classes/alkhtmlformadmin{$appli_abrev_fichier}form.class.php");
          $oPanel = new AlkHtmlFormAdmin{$appli_abrev_classe}Form($this);
          break; 
        }
        break;
     
      case ALK_TYPESHEET_PROPRIETE: // partie parametres
        switch ( $this->iSheet ){
        case ALK_SHEET_PROPRIETE : //
          //require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."{$appli_dir}/classes/alkhtmlformparam{$appli_abrev_fichier}form.class.php");
          //$oPanel = new AlkHtmlFormParam{$appli_abrev_classe}Form($this);
          $oPanel = AlkHtmlFactory::getHtmlPanel("default", "(Panel par défaut)");
          break; 
        }
        break;
    }
    
    return $oPanel;
  }
  
  /**
   *  Fonction virtuelle appelée par le constructeur permettant d'initialiser le tableau this->tabSheets
   */
  public function setTabSheets() 
  { 
    $iTypeSheet = AlkRequest::getToken("iTypeSheet",  ALK_TYPESHEET_CONSULT);
    if( $iTypeSheet==ALK_TYPESHEET_POPUP ) 
      return;
    
    $strUrl = ALK_ALKANET;
    
    // onglets de consultation
    $this->addSheet(ALK_TYPESHEET_CONSULT, ALK_SHEET_CONSULTATION, ALK_SHEET_LIST, 
                    "Consultation {$appli_abrev_classe}", $strUrl, "", "",
                    ALK_APPLI_RIGHT_READ, ALK_PRIV_SPACE_USER, true);
    
    // onglets d'administration
    $this->addSheet(ALK_TYPESHEET_ADMIN, ALK_SHEET_ADMINISTRATION, ALK_SHEET_FORM, 
                    "Administration {$appli_abrev_classe}", $strUrl, "", "",
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);
                    
    // onglets des propriétés
    $this->addSheet(ALK_TYPESHEET_PROPRIETE, ALK_SHEET_PROPRIETE, ALK_SHEET_NONE, 
                    "Propriétés {$appli_abrev_classe}", $strUrl, "", "",
                    ALK_APPLI_RIGHT_ADMIN, ALK_PRIV_SPACE_USER, true);
  }
  
}
?>