<?php

/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::{$appli_abrev_classe}
Module {$appli_abrev_classe}.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @class AlkHtmlFormAdmin{$appli_abrev_classe}Form
 * @brief Description de la classe
 */
class AlkHtmlFormAdmin{$appli_abrev_classe}Form extends AlkHtmlForm 
{
  
  // TODO : à compléter
  protected $table_champ;
  
  /**
   * Constructeur
   * @param oAppli    Application appelante
   */
  public function __construct(AlkAppli &$oAppli) 
  {
    parent::__construct($oAppli, "form{$appli_abrev_classe}Form");

    // configuration du formulaire
    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_ADMINISTRATION, ALK_SHEET_FORM, "&iMode=".$iModeForm);
    $strAction = ALK_ALKANET_SQL."?token=".$strToken;
    
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, $strAction);
  }
  
  /**
   *  Abstract : Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit)
  {
    $theme_id = AlkRequest::getToken("theme_id", AlkRequest::_REQUESTint("theme_id", "-1"));
    
    // creation des propriétés AlkFormData
    // TODO : à compléter
    $this->table_champ     = new AlkFormData($this, "table_champ", "", ALK_SQL_TEXT);
        
    // initialisation des propriétés par REQUEST ou DATAROW
    $tabData = array(null);
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      
      // TODO : à compléter
      //$oDsData = $this->oAppli->oQuery->getThemeById($theme_id);
      //$tabData[] = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
      
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
      
    foreach ($tabData as $oDrData){
      $this->initData($iTypeInit, $oDrData, $reqMethod);
    }
  }
  
  /**
   * Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);
    $tabQuery = $this->getTabQuery(array());
        
    switch( $this->iMode ) {
    case ALK_FORM_MODE_ADD:
      // TODO : à compléter
      //$this->oAppli->oQueryAction->insert_data($tabQuery);
      break;
      
    case ALK_FORM_MODE_UPDATE:
      // TODO : à compléter  
      //$this->oAppli->oQueryAction->update_data($tabQuery);
      break;
    
    case ALK_FORM_MODE_DEL:
      // TODO : à compléter
      //$this->oAppli->oQueryAction->delete_data($tabQuery);
      break;
    }
    
    // url de retour après traitement
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_ADMINISTRATION, ALK_SHEET_FORM);
    return ALK_ALKANET."?token=".$strToken;
  }
  
  /**
   * Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $this->setData(ALK_INIT_MODE_DATAROW);
    
    $this->setLabel("Exemple de formulaire");
    $this->setLabelDesc("Description d&eacute;taill&eacute;e du formulaire");
    
    $strTitle = $this->iMode==ALK_FORM_MODE_ADD ? "Formulaire en mode cr&eacute;ation" 
                                                : "Formulaire en mode modification";
    
    $oCtrlTxt = AlkHtmlFactory::getHtmlText($this->table_champ, "Champ", 1, 60, 80);
    $oCtrlTxt->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
    
    $oBlock = $this->addBlock("block_group", $strTitle, "", "100", "390", true);
    $oBlock->addCtrl($oCtrlTxt);

    $this->addValidButton("", "", "Valider", "Valider");
    $this->addCancelButton(ALK_TYPESHEET_ADMIN, ALK_SHEET_ADMINISTRATION, ALK_SHEET_FORM, "");
  }
  
  /**
  * Retourne l'aide associée au formulaire
  * @return string
  */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."{$appli_dir}/help/{$appli_abrev_fichier}_01_admin_form.htm");
  }
}
?>