<?php

require_once 'PHPUnit2/Framework/TestSuite.php';
require_once 'PHPUnit2/Runner/Version.php';
require_once 'PHPUnit2/Runner/BaseTestRunner.php';
require_once 'PHPUnit2/TextUI/ResultPrinter.php';
require_once 'PHPUnit2/Util/Fileloader.php';

require_once 'Console/Getopt.php';
require_once 'Benchmark/Timer.php';

class PHPUnitRunner extends PHPUnit2_Runner_BaseTestRunner {
  
  public static function run($classname, $filePath, $xmlLogfile) {
    ob_start();
    
    $aTestRunner = new PHPUnitRunner;
    $aTestRunner->doRun($classname, $filePath, $xmlLogfile);
    
    ob_end_clean();
  }
  
  public function doRun($classname, $filePath, $xmlLogfile) {
    $suite = $this->getTest($classname, $filePath);
        
    $result =  new PHPUnit2_Framework_TestResult;
    $timer  = new Benchmark_Timer;

    //$this->printer = new PHPUnit2_TextUI_ResultPrinter;
    //$this->printer->write(
    //  PHPUnit2_Runner_Version::getVersionString() . "\n\n"
    //);
    //$result->addListener($this->printer);

    if ($xmlLogfile !== FALSE) {
        require_once("PHPUnit2/Util/Log/XML.php");
        require_once("XML.php");
          
        $result->addListener(
          new PHPUnitXML($xmlLogfile)
        );
    }

    
    $timer->start();
    $suite->run($result);
    $timer->stop();
    $timeElapsed = $timer->timeElapsed();
    

    //$this->printer->printResult($result, $timeElapsed);

    //return $result;
  }
  
  public function testStarted($testName) {
  }
  
  public function testEnded($testName) {
  }
  
  public function testFailed($status, PHPUnit2_Framework_Test $test, PHPUnit2_Framework_AssertionFailedError $e) {
  }
  
  protected function runFailed($message) {
    echo "FAILED : $message<br/>";
  }
  
}
?>