<?php
/*
 * Created on 6 juil. 11
 *
 * To change the template for this generated file go to
 * Window - Preferences - PHPeclipse - PHP - Code Templates
 */

include_once("lib/lib_session.php");
include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_file.php");

AlkFactory::initLocale();

// répertoire racine du projet
$strPath = ALK_ALKANET_ROOT_PATH;

// chemin du répertoire locales du projet
$strPathLocalProject = ALK_ALKANET_ROOT_PATH."locales/";

/**
 * Execute un tableau de cmd bash
 * Retourne le log des exécutions
 * @param tabCmd  tableau de cmd bash
 * @param bTrace  true par défaut pour afficher les cmd sur la sortie standard, false sinon
 * @return string
 */
function doExecCmd($strPath, $strCmd, $strParam, $bTrace=true)
{
  $tabDescriptors = array(
    0 => array("pipe", "r"),  // // stdin est un pipe où le processus va lire
    1 => array("pipe", "w"),  // stdout est un pipe où le processus va écrire
    2 => array("pipe", "w")   // stderr est un fichier
  );
  
  $cwd = "/";
  $strLog = "";
  $iReturnVar = 0;
  $tabPipes = array();
  
  $strLog = "";
  
  $hProcess = proc_open($strCmd." ".$strParam, $tabDescriptors, $tabPipes, $strPath);  
  if( is_resource($hProcess) ) {
      // écrit les paramètres
    //fwrite($tabPipes[0], $strParam);
    fclose($tabPipes[0]);
    
    // récupère la sortie standard
    $strLogRes = stream_get_contents($tabPipes[1]);
    fclose($tabPipes[1]);
    
    // récupère la sortie d'erreur 
    $strLogErr = stream_get_contents($tabPipes[2]);
    if( $strLogErr != "" ) {
      $strLog .= "Résultat = ".$strLogRes."<br/>";
      $strLog .= "Erreur = ".$strLogErr."<br/>";
    } else {
      $strLog .= "Résultat = ".( $strLogRes == "" ? '<font color="green"><b>Ok</b></font>' : $strLogRes)."<br/>";
    }
    fclose($tabPipes[2]);
    
    $iReturnVar = proc_close($hProcess);
    
    $strLog = "Retour = ".$iReturnVar."<br/>".$strLog;
  } else {
    $strLog = "Erreur = Impossible d'exécuter la commande de concaténation.";
  }
  
  $strLog = "Commande exécutée = ".$strCmd." ".$strParam."<br/>".$strLog;
  
  /*exec($strCmd, $tabRes, $iReturnVar);
  
  if( $strLogErr != 0 ) { 
    $strLog .= implode("\r\n", $tabRes);  
  }*/
  
  
  return array($iReturnVar, $strLog);
}

/**
 * Retourne un tableau contenant les chemins vers les locales de modules
 * @param strPath  chemin de base
 * @return array
 */
function getTabDirLocales($strPath)
{
  global $strPathLocalProject;
  
  if( $strPath!="" && $strPath[strlen($strPath)-1] != '/' )
    $strPath .= '/';

  if( !file_exists($strPath) )
    return array();

  $tabRes = array();
  $hDir = opendir($strPath);
  while( $strFile = readdir($hDir) ) {
    if( $strFile=='.' || $strFile=='..' )
      continue;
    if( @is_dir($strPath.$strFile) ) {
      if( $strFile == "locales" ) {
        if( $strPath.$strFile."/" != $strPathLocalProject ) {
          $tabRes[] =  $strPath.$strFile;
        }
      } else {
        $tabRes = array_merge($tabRes, getTabDirLocales($strPath.$strFile));
      }
    }
  }
  closedir($hDir);
 
  return $tabRes;
}

// arbo du projet
$tabDir = getTabDirLocales($strPath);

$tabPrLocales = array();
$tabPrLocales = $GLOBALS["tabLocales"]["frontoffice"];
/*if( $GLOBALS["tabLocales"]["backoffice"] != $GLOBALS["tabLocales"]["frontoffice"] ) {
  $tabPrLocales[1] = $GLOBALS["tabLocales"]["backoffice"];
} */

echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> 
  <html>
  <head>
    <meta http-equiv=\"content-type\" content=\"text/html; charset=".ALK_HTML_ENCODING."\" />
    <link rel='stylesheet' href='styles/sit.css' type='text/css'/>
    <title>Administration Alkanet</title>
  </head>
  <body style='margin:10px'>
    <form name='formGenerate' action='".$_SERVER['PHP_SELF']."' method='POST'>
    <div class='divContenuTexte'><b>Création des .po et .json pour le projet à partir de ceux contenus dans les modules</b></div><p></p>
    <div class='divContenuTexte'>Sélection des modules :<br/>";

$tabContentsJson = array();
foreach($tabPrLocales as $iKey => $strLocale) {
  $strPathFilePo   = $strPathLocalProject.$strLocale."/".ALK_LG_CATEGORY."/locales_php.po";
  $strPathFileMo   = $strPathLocalProject.$strLocale."/".ALK_LG_CATEGORY."/locales_php.mo";
  $strPathFileJson = $strPathLocalProject.$strLocale."/".ALK_LG_CATEGORY."/locales_js.json";
  
  echo '<b>Locale '.$strLocale.'</b><ul>';
  if( !(file_exists($strPathLocalProject.$strLocale) && is_dir($strPathLocalProject.$strLocale)) ) {
    echo '<li>Création du répertoire '.$strPathLocalProject.$strLocale.' :';
    $bRes = @mkdir($strPathLocalProject.$strLocale, 0777);
    echo ( $bRes ? '<font color="green"><b>Ok</b></font>' : '<font color="red"><b>Ko</b></font>' ).'</li>';
  }
  if( !(file_exists($strPathLocalProject.$strLocale."/".ALK_LG_CATEGORY) && is_dir($strPathLocalProject.$strLocale."/".ALK_LG_CATEGORY)) ) {
    echo '<li>Création du répertoire '.$strPathLocalProject.$strLocale."/".ALK_LG_CATEGORY.' : ';
    $bRes = @mkdir($strPathLocalProject.$strLocale."/".ALK_LG_CATEGORY, 0777);
    echo ( $bRes ? '<font color="green"><b>Ok</b></font>' : '<font color="red"><b>Ko</b></font>' ).'</li>';
  }
  
  $strContentsJson = "{";
  $strCmdPo   = " --force-po --use-first --output-file=".$strPathFilePo;
  $strGlue="";
  foreach($tabDir as $strPathDir) {
    $strPathModulePo = $strPathDir."/".$strLocale."/".ALK_LG_CATEGORY."/locales_php.po";
    
    echo '<li>'.$strPathModulePo.' : ';
    if( file_exists($strPathModulePo) && is_file($strPathModulePo) ) {
      $strCmdPo .= " ".$strPathModulePo;
      echo '<font color="green"><b>Ok</b></font></li>';
    } else {
      echo '<font color="red"><b>Ko</b></font></li>';
    }

    $strPathModuleJson = $strPathDir."/".$strLocale."/".ALK_LG_CATEGORY."/locales_js.json";
    echo '<li>'.$strPathModuleJson.' : ';
    if( file_exists($strPathModuleJson) && is_file($strPathModuleJson) ) {
      $strContents = file_get_contents($strPathModuleJson);
      if(trim($strContents)!="{}"){
        $strContentsJson .= $strGlue.substr(trim($strContents), 1, -1);
        $strGlue = ",";
        echo '<font color="green"><b>Ok</b></font></li>';
      }else{
      	echo '<font color="green"><b>Vide</b></font></li>';
      }
      
      
    } else {
      echo '<font color="red"><b>Ko</b></font></li>';
    }
  }

  if( !empty($tabDir) ) {
    echo '<li>Concaténation des fichiers .po<br/>';
    list($iResPo, $strLog) = doExecCmd($strPath, "msgcat", $strCmdPo);
    echo '<ul>'.$strLog.'</ul></li>';

    if( $iResPo == 0 ) {
      echo '<li>Compilation du fichier .po :';
      $strCmdMo = " --check --output-file=".$strPathFileMo." ".$strPathFilePo;
      list($iResMo, $strLog) = doExecCmd($strPath, "msgfmt", $strCmdMo);
      echo '<ul>'.$strLog.'</ul></li>';
    }


    $strContentsJson = str_replace("\n", "", str_replace("\r", "", $strContentsJson)).'}';
    $hf = @fopen($strPathFileJson, "w");
    if( $hf ) {
      fwrite($hf, ' var oAlkTranslate = '.$strContentsJson);
      fclose($hf);
      $tabContentsJson[$strLocale] = " tabAlkTranslate[".$iKey."] =".$strContentsJson;
      echo '<li>Création de '.$strPathFileJson.' : <font color="green"><b>Ok</b></font></li>';
    } else {
      $tabContentsJson[$strLocale] = " tabAlkTranslate[".$iKey."] = {}";
      echo '<li>Création de '.$strPathFileJson.' : <font color="red"><b>Ko</b></font></li>';
    }
  } else {
    echo '<li>Aucun module multilingue trouvé</li>';
  }
  
  echo '</ul><br/>';
}

echo '<ul>';
$strPathFileJson = $strPathLocalProject."locales_js.json";
$hf = @fopen($strPathFileJson, "w");
if( $hf ) {
  fwrite($hf, " var tabAlkTranslate = new Array();\n");
  foreach($tabContentsJson as $strLocale => $strContents) {
    fwrite($hf, $strContents.";\n");
  }
  fclose($hf);
  echo '<li>Création de '.$strPathFileJson.' : <font color="green"><b>Ok</b></font></li>';
} else {
  echo '<li>Création de '.$strPathFileJson.' : <font color="red"><b>Ko</b></font></li>';
}
echo '</ul><br/>';
    
echo '</body></html>';
?>