<?php
include_once("../../lib/lib_session.php");
include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_file.php");

$suffixPatch = "sql.patch.php";
$xmlFileVersion = ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."version_init.xml";

$dbConn = AlkFactory::getDbConn();

$strPathScripts =  
$tabFiles = getTabFilesByDir(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."", array("sql.patch.php"), true, array(), true);
$tabFiles = array_merge($tabFiles, getTabFilesByDir(ALK_ALKANET_ROOT_PATH."/", array("sql.patch.php"), true, array(), true));
$tabFiles = array_merge($tabFiles, getTabFilesByDir(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."", array("sql.patch.php"), true, array(), true));
$tabFiles = array_merge($tabFiles, getTabFilesByDir(ALK_ALKANET_ROOT_PATH.ALK_ROOT_SERVICE, array("sql.patch.php"), true, array(), true));

$tabPathModule = array("97" => "", "98" => ALK_ROOT_SERVICE, "99" => ALK_ROOT_CLASSE."");

/* Variables et Tableaux de type "include" => les fichiers *.sql.patch.php doivent les déclarer */
/* --- */
$tabTable     = array();
$tabDropTable = array();
$tabView      = array();
$tabDropView  = array();
$tabSeq       = array();
$tabDropSeq   = array();
$tabPk        = array();
$tabDropPk    = array();
$tabIdx       = array();
$tabDropIdx   = array();
$tabFk        = array();
$tabDropFk    = array();
$tabUq        = array();
$tabDropUq    = array();
$tabIns       = array();
$tabAlterTable= array();
/* --- */

echo "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">". 
  "<html><head>".
  "<meta http-equiv=\"content-type\" content=\"text/html; charset=".ALK_HTML_ENCODING."\" />".
  "<link rel='stylesheet' href='styles/sit.css' type='text/css'/>";
echo "<style type='text/css'><!-- ";
echo "body { padding: 10px; }";
echo "table { border-collapse:collapse; border:1px solid grey; padding:4px; } ";
echo "tr { border: 1px solid lightgrey; padding: 4px; } ";
echo "td { border: 1px solid lightgrey; padding: 8px; } ";
echo "th { border: 1px solid grey; padding: 8px; background-color: lightgrey; } ";
echo "--></style>";
echo "</head><body>";
  
/* création du fichier libconf/version.xml */

$dom = new DomDocument();
$dom->preserveWhiteSpace = false;
$dom->loadXml("<?xml version=\"1.0\" encoding=\"UTF-8\"?><updates></updates>");
$dom->formatOutput = true;

$update = $dom->createElement("update");
$update->setAttribute("livraison", "1");
$update->setAttribute("date", date('j/m/Y'));
$update->setAttribute("name", "pct");
	
foreach($tabFiles as $strFileName => $strPathFileName) {
  if( file_exists($strPathFileName) && is_file($strPathFileName) ) {
    $strNum = "3.0.0";
    include_once($strPathFileName);
    
    $strPathCVS = "";
    $iPos = mb_strrpos($strPathFileName, "/");
    if( $iPos === false ) {
      $strPathCVS = $strPathFileName."/CVS";
    } else {
      $strPathCVS = mb_substr($strPathFileName, 0, $iPos)."/CVS";
    } 
    $tabCVS = readCVS($strPathCVS);
    
    $tabName = explode("_", $strFileName);
    $strNameTmp = str_replace(".sql.patch.php", "", $tabName[1]);
    $strPathTmp = ( array_key_exists($tabName[0], $tabPathModule)
                    ? $tabPathModule[$tabName[0]]
                    : ALK_ROOT_MODULE."" );
    
    $moduleName = $strPathTmp.$strNameTmp;
    $newVersion = $strNum;
    
		$module = $dom->createElement("module");
		$module->setAttribute("name", $moduleName);
		$module->setAttribute("version", $newVersion);
    $module->setAttribute("cvs_repository", $tabCVS["repository"]);
    $module->setAttribute("cvs_module", $tabCVS["module"]);
    $module->setAttribute("cvs_branch", $tabCVS["branch"]);
		$update->appendChild($module);
    
    echo "<div class='divContenuTexte'>".$moduleName." : ".$newVersion."</div>";
	}
	else {
		echo "Erreur : Module non trouvé : ".$strPathFileName."</div>";
  }
}


// Mise à jour du fichier XML version
$root = $dom->documentElement;
$root->insertBefore($update, $root->getElementsByTagName("update")->item(0));
$dom->save($xmlFileVersion);

echo "<br><b>Le fichier libconf/version.xml contient maintenant la liste de tous les modules et versions du projet.<br>".
  "Veuillez vérifier qu'il ne manque aucun module.".
  "</b>".
  "<br><br>Opération terminée.";
echo "</body></html>";

/**
 * Lecture des infos CVS du répertoire
 * Retourne un tableau contenant les clés suivantes : depot, module, branche 
 * 
 * @param strPatchCVS  chemin du répertoire CVS à analyser
 * @return array  
 */
function readCVS($strPathCVS)
{
  $tabRes = array("repository" => "", "module" => "", "branch" => "");
  
  // obtenir la version de la branche
  // se situe sur la première ligne du fichier, avec un premier caractère à supprimer en début de ligne
  $strPathFile = $strPathCVS."/Tag";
  $tabTmp = @file($strPathFile);
  if( count($tabTmp)>0 ) {
    $tabRes["branch"] = mb_substr(trim($tabTmp[0]), 1);
  } 
  
  // obtenir le nom du dépot
  // ligne de connexion au dépot avec en fin de chaine, le chemin vers le dépot
  $strPathFile = $strPathCVS."/Root";
  $tabTmp = @file($strPathFile);
  if( count($tabTmp)>0 ) {
    $tabRes["repository"] = extractFileName(trim($tabTmp[0]));
  } 
  
  // obtenir le nom du module
  // se situe sur la première ligne, supprimer les répertoires éventuelles
  $strPathFile = $strPathCVS."/Repository";
  $tabTmp = @file($strPathFile);
  if( count($tabTmp)>0 ) {
    $iPos = mb_strrpos($tabTmp[0], "/");
    if( $iPos === false ) {
      $strModule = trim($tabTmp[0]);
    } else {
      $strModule = mb_substr(trim($tabTmp[0]), 0, $iPos);
    } 
    $tabRes["module"] = $strModule;
  } 
  
  return $tabRes;
}
?>
