<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Alkanet
Module fournissant les pages adressables Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

/**
 * @file alkanet_process.php
 * @package	Alkanet_Module_Alkanet
 * @brief	Gestion des processus généraux Alkanet
 */
require_once("../../lib/lib_session.php"); 
if( file_exists(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."lib_global.php") ) { 
  require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CONF."lib_global.php");
} else {
  require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_LIB."lib_global.php");
}

$iMode = AlkRequest::_REQUESTint("iMode", "-1");

switch( $iMode ) {
  case 1 : // Ajout d'un fichier joint
  case 2 : // Suppression d'un fichier joint

    /**
     * @brief Modifie la liste des pj en fonction du mode
     * @param iMode =1 pour l'ajout, =2 pour la modif
     */
    function ChangeListPj($iMode)
    {
      require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlupload.class.php"); 
      $user_id =  AlkFactory::getSProperty("user_id", "-1"); 

      $atype_id   = AlkRequest::getToken("atype_id", "-1");
      $data_id    = AlkRequest::getToken("data_id", "-1");
      $lang_id    = AlkRequest::getToken("lang_id", "-1");
      $tableName  = AlkRequest::getToken("tableName", "");
      $dirUpload  = AlkRequest::getToken("dirUpload", "");
      $formName   = AlkRequest::getToken("formName", "");
      $champName  = AlkRequest::getToken("champName", "");
      $bVersionning  = AlkRequest::getToken("versionning", "0")=="1";
      
      $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ALKANET);
      if( $iMode==1 ) {
        $bMaj = $oQuery->AddPj($tableName, $data_id, $champName, $user_id, ALK_ALKANET_ROOT_PATH, 
                               ALK_ROOT_UPLOAD.$dirUpload, $lang_id, true, "", $bVersionning);
      } else {
        $bMaj = false;
        $nbPJ = AlkRequest::_POSTint("nbPJ".($champName!="" ? "_".$champName : ""), "-1");
        for($i=0; $i<$nbPJ; $i++) {
          $valCase     = AlkRequest::_POSTint("suppj_".($champName!="" ? $champName."_" : "").$i, "-1");
          $pj_id       = AlkRequest::_POSTint("id_".($champName!="" ? $champName."_" : "").$i, "-1");
          $strFileName = AlkRequest::_POST("fileName_".($champName!="" ? $champName."_" : "").$i);
          if( $valCase == "1" ) {
            $oQuery->DelPj($pj_id, $strFileName, $tableName, ALK_ALKANET_ROOT_PATH, ALK_ROOT_UPLOAD.$dirUpload, $bVersionning);
            $bMaj = true;
          }
        }
      }
       
      $dsPJ = $oQuery->GetDslistePJ($tableName, $data_id, $champName);
      $defaultStateCheck = "0";
       
      if( $bMaj ) {
        $strHtml = AlkHtmlUpload::staticGetListDynamicHtml($dsPJ, $champName, 3, $defaultStateCheck, 1, $dirUpload, 
                                                           ALK_MEDIA_URL."images/", "", $bVersionning);
        $strHtml = str_replace("</", "</", $strHtml);
        $strHtml = 
          " if( !parent ) return;".
          " var oDiv = parent.document.getElementById('list_upload_".$champName."');".
          " if( !oDiv ) return;".
          " oDiv.innerHTML = \"".addslashes($strHtml)."\";".
          " var oForm = parent.document.".$formName.";".
          " if( !oForm ) return;" .
          " var oCtrl = oForm.file_".$champName.";".
          " if( !oCtrl ) return;".
          " oCtrl.value = '';".
          " oCtrl = oForm.files_".$champName.";".
          " if( oCtrl && oCtrl.selectedIndex>0 ) {".
          "   RemoveSelectedFromSelect(oCtrl);".
          " }";
      }
      else if( $iMode == 1 ) {
        $strHtml = "alkAlert(\""._f("L'ajout de ce fichier n'a pu être effectué.%sType de fichier incorrect ou fichier déjà ajouté.", "\\\n")."\");";
      } else {
        $strHtml = "alkAlert(\""._f("La suppression de ce fichier n'a pu être effectuée.%sFichier non trouvé.", "\\\n")."\");";
      }
      
      echo "<html>".
        "<head>".
        "<script type='text/javascript' src='".ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js'></script>".
        "<script type='text/javascript'>" .
        "function onLoadExec() { ".$strHtml." } ".
        "</script></head>".
        "<body onload='onLoadExec()'></body>".
        "</html>";
    }// fin de ChangeListPj

    ChangeListPj($iMode);
    break;
   
 case 3: // retourne le code html du menu popup contenant la liste des fichiers joints
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlupload.class.php"); 
     
    $data_id       = AlkRequest::getToken("data_id", "-1");
    $lg            = AlkRequest::getToken("lg", "_FR");
    $strTableName  = AlkRequest::getToken("tablepj", "");
    $strFieldName  = AlkRequest::getToken("fieldpj", "");
    $strUploadDir  = AlkRequest::getToken("uploadDir", "");
    $bVersionning  = AlkRequest::getToken("versionning", "0")=="1";
    $layerName     = AlkRequest::_GET("ln", "");
       
    $oCtrl = new AlkHtmlUpload(null, 0, $strFieldName, "", $strTableName, $data_id, $strUploadDir);
       
    echo $layerName.$oCtrl->getHtmlListFilesMenuPopup(false, "", $lg);
    break;
   
  case 4: // retourne le timerStart suite à une requete ajax
    for($i=0; $i<131072; $i++) {
      echo "a";
    }
    break;
   
  case 5: // Effectue l'enregistrement du fichier joint via le plugin swf
    $user_id =  AlkFactory::getSProperty("user_id", "-1");
    $data_id    = AlkRequest::getToken("data_id", "-1");
    $lang_id    = AlkRequest::getToken("lang_id", "-1");
    $tableName  = AlkRequest::getToken("tableName", "");
    $dirUpload  = AlkRequest::getToken("dirUpload", "");
    $champName  = AlkRequest::getToken("champName", ""); 
    $formName   = AlkRequest::getToken("formName", ""); 
    $bVersionning  = AlkRequest::getToken("versionning", "0")=="1";
  
    $strPath = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.$dirUpload;
    ob_start();
    if( !($strPath!="" && file_exists($strPath) && is_dir($strPath)) ) {
      header("HTTP/1.1 501 Chemin destination n'existe pas.");
      //echo "<br>t1";
      exit();
    } else {
      if( substr($strPath, -1, 1)!="/" ) {
        $strPath .= "/";
      }
      
      if( empty($_FILES) ) {
        header("HTTP/1.1 502 Fichier non transféré.");
        //echo "<br>t2 ";
        exit();  
      } else {
        $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ALKANET);
        foreach($_FILES as $strCtrlName => $tabFile) {
          if( is_uploaded_file($tabFile['tmp_name']) && file_exists($tabFile['tmp_name']) ) {
            if( $tabFile["size"] > 0 ) {
              $strFileName = trim(VerifyFileName($tabFile["name"]));
              $pathFile = $strPath.$strFileName;
              move_uploaded_file($tabFile["tmp_name"], $pathFile);
              //echo "<br>$pathFile transféré";
              $oQuery->AddPj($tableName, $data_id, $champName, $user_id, ALK_ALKANET_ROOT_PATH, ALK_ROOT_UPLOAD.$dirUpload, $lang_id, true, $strFileName, $bVersionning);
            }
          } else {
            header("HTTP/1.1 500 Echec du transfert.");
            //echo $_FILES[$strCtrlName]["error"];
          }
        }
      }
    }

    $strEcho = ob_get_contents();
    ob_end_clean();
    
    /*
     * Pas de retour ajax, utilisation du mode 7 en indirect pour cause de bug swf sous linux 
     *
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlupload.class.php");
    $oCtrl = new AlkHtmlUpload(null, 3, $champName, "", $tableName, $data_id, $dirUpload);
    $oCtrl->setProperty("formName", $formName);
    echo $oCtrl->getListDynamicHtml();*/

    //$hFile = fopen("/home/devperso/pcliquet/intranetermont/upload/log.htm", "w");
    //fwrite($hFile, $strEcho);
    //fclose($hFile);   
    break;
    
  case 6: // suppression ajax de pièce jointe
  case 7: // 
  case 10: // suppression d'une version de pj 
    $data_id    = AlkRequest::getToken("data_id", "-1");
    $tableName  = AlkRequest::getToken("tableName", "");
    $dirUpload  = AlkRequest::getToken("dirUpload", "");
    $champName  = AlkRequest::getToken("champName", "");
    $formName   = AlkRequest::getToken("formName", "");
    $bVersionning  = AlkRequest::getToken("versionning", "0")=="1";
    
    if( $iMode == 6 ) {
      $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ALKANET);
      $nbPJ = AlkRequest::_POSTint("nbPJ".($champName!="" ? "_".$champName : ""), "-1");
      for($i=0; $i<$nbPJ; $i++) {
        $valCase     = AlkRequest::_POSTint("suppj_".($champName!="" ? $champName."_" : "").$i, "-1");
        $pj_id       = AlkRequest::_POSTint("id_".($champName!="" ? $champName."_" : "").$i, "-1");
        $strFileName = AlkRequest::_POST("fileName_".($champName!="" ? $champName."_" : "").$i);
        if( $valCase == "1" ) {
          $oQuery->DelPj($pj_id, $strFileName, $tableName, ALK_ALKANET_ROOT_PATH, ALK_ROOT_UPLOAD.$dirUpload, $bVersionning);
        }
      }
    }
    if( $iMode == 10 ) {
      $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ALKANET);
      $oQuery->DelVersionPj($tableName, ALK_ALKANET_ROOT_PATH, ALK_ROOT_UPLOAD.$dirUpload);
    }
    
    require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlupload.class.php");
    $oCtrl = new AlkHtmlUpload(null, 3, $champName, "", $tableName, $data_id, $dirUpload);
    if ( $bVersionning ) $oCtrl->setVersionning(true);
    $oCtrl->setProperty("formName", $formName);
    $tabRes = array("layerName"     => "list_upload_".$champName,
                    "htmlContents"  => $oCtrl->getListDynamicHtml()); 
    echo json_encode($tabRes);
    break; 
  
  case 8: // upload ajax
    $user_id =  AlkFactory::getSProperty("user_id", "-1");
    $data_id     = AlkRequest::getToken("data_id", "-1");
    $lang_id     = AlkRequest::getToken("lang_id", "-1");
    $tableName   = AlkRequest::getToken("tableName", "");
    $dirUpload   = AlkRequest::getToken("dirUpload", "");
    $champName   = AlkRequest::getToken("champName", "");
    $idSession   = AlkRequest::getToken("idSession", "");
    $bVersionning  = AlkRequest::getToken("versionning", "0")=="1";
    $strFileName = AlkRequest::_GET("fn", "");
    
    $strPath    = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.$dirUpload;
    $strTmpPath = ini_get("upload_tmp_dir")."/";
    $pj_id = "0"; 
    
    //ob_start();
    if( !($strPath!="" && file_exists($strPath) && is_dir($strPath)) ) {
      header("HTTP/1.1 501 Chemin destination n'existe pas.");
      echo "Erreur : Chemin destination n'existe pas.";
      exit();
    } else {
      $strPathTmpFileName = $strTmpPath.$idSession."_postdata";
      $strPathInfoFileName = $strTmpPath.$idSession."_flength";
      $strFileInfo = @file_get_contents($strPathInfoFileName);
      $tabFileInfo = explode("|", $strFileInfo);
      //print_r($tabFileInfo);
      $bOk = ( is_array($tabFileInfo) && count($tabFileInfo)==2 && $tabFileInfo[0]==$tabFileInfo[1] );
        
      $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ALKANET);
      if( $bOk && file_exists($strPathTmpFileName) && is_file($strPathTmpFileName) ) {
        if( filesize($strPathTmpFileName) > 0 ) {
          $strFileName = trim(VerifyFileName($strFileName));
          $pathFile = $strPath.$strFileName;
          rename($strPathTmpFileName, $pathFile);
          
          //echo "<br>$pathFile transféré";
          $pj_id = $oQuery->AddPj($tableName, $data_id, $champName, $user_id, ALK_ALKANET_ROOT_PATH, ALK_ROOT_UPLOAD.$dirUpload, $lang_id, true, $strFileName, $bVersionning);
          $strUploadMsg = "Ok";
        } else {
          @unlink($strPathTmpFileName);
        }

        // supprime les fichiers annexes créés par le l'upload cgi
        @unlink($strPathInfoFileName);
        @unlink($strTmpPath.$idSession."_err");
      } else {
        @unlink($strPathInfoFileName);
        @unlink($strTmpPath.$idSession."_err");
        //header("HTTP/1.1 500 Echec du transfert.");
        //echo $_FILES[$strCtrlName]["error"];
      }
    }
    $strEcho = ob_get_contents();
    //ob_end_clean(); 
    echo $pj_id;
    break;
  
  case 9: // calcul la taille du fichier en cours de transfert
    $idSession = AlkRequest::_GET("ids", "");

    $tabFiles = array("_flength","_postdata","_err");
    
    $strTmpPath = ini_get("upload_tmp_dir")."/";
    $strPathTmpFileName = $strTmpPath.$idSession.$tabFiles[1];
    $strPathInfoFileName = $strTmpPath.$idSession.$tabFiles[0];
    $strPathErrFileName  = $strTmpPath.$idSession.$tabFiles[2];

    $strStatus = "";

    if( file_exists($strPathErrFileName) && is_file($strPathErrFileName)) {
      // erreur rencontrée
      $strMsg = @file_get_contents($strPathErrFileName);
      if( $strMsg == "" ) {
        $strMsg = _t("Erreur rencontrée. Annulation du transfert.");
      }
      $strStatus = "0|".$strMsg;
    } else {
      $iTotalSizePipeCurentSize = @file_get_contents($strPathInfoFileName);
      $tabFileInfo = explode("|", $iTotalSizePipeCurentSize);
      if( is_array($tabFileInfo) && count($tabFileInfo)==2 ) {
        if( $tabFileInfo[0]+1 == $tabFileInfo[1] && $tabFileInfo[0]>0 ) {
          // erreur survenue en fin de transfert
          $strStatus = "0|"._t("Erreur rencontrée. Annulation du transfert.");
        } else {
          $strStatus = "1|".$iTotalSizePipeCurentSize;
        }
      } else {
        // information non reçue
        $strStatus = "2|"._t("Transfert en cours...");
      } 
    }

    if( substr($strStatus, 0, 1) == "0" ) {
      // suppression des fichiers temporaires
      foreach($tabFiles as $strSuffixe) {
        @unlink($strTmpPath.$idSession.$strSuffixe);
      }
    }
    echo $strStatus;
    break;
  //case 10 utilisé avec case 6 et 7
  
  case 11 : // modifie les métadonnées d'une pièce jointe
    if( isset($GLOBALS["tabPJDetails"]) && is_array($GLOBALS["tabPJDetails"]) && !empty($GLOBALS["tabPJDetails"]) ) {
      $tableName    = AlkRequest::getToken("tableName", "");
      $pj_id        = AlkRequest::_REQUEST("pj_id", array());
      $dirUpload    = AlkRequest::getToken("dirUpload", "");
      
      $tabFields = array();
      foreach ( $GLOBALS["tabPJDetails"] as $key => $tabFieldInfo ) {
        $tabFields[] = array_merge($tabFieldInfo, array("value" => AlkRequest::_REQUEST($tabFieldInfo["field"], "")));
      }
    
      $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ALKANET);
      echo $oQuery->UpdatePjDetails($tableName, $pj_id, $dirUpload, $tabFields);
    }
  break;
  
  case 12: // calcul l'avancement de la décompression
    $idSession = AlkRequest::getToken("idUnique", AlkRequest::_REQUEST("idUnique", ""));

    $tabFiles = array("_unzip_progress", "_unzip_error");
    
    $strTmpPath = ini_get("upload_tmp_dir")."/";
    $strPathInfoFileName = $strTmpPath.$idSession.$tabFiles[0];
    $strPathErrFileName  = $strTmpPath.$idSession.$tabFiles[1];

    $strStatus = "";

    if( file_exists($strPathErrFileName) && is_file($strPathErrFileName)) {
      // erreur rencontrée
      $strMsg = @file_get_contents($strPathErrFileName);
      if( $strMsg == "" ) {
        $strMsg = _t("Erreur rencontrée. Annulation de la décompression.");
      }
      $strStatus = "0|".$strMsg;
    } else {
      $iTotalSizePipeCurentSize = @file_get_contents($strPathInfoFileName);
      $tabFileInfo = explode("|", $iTotalSizePipeCurentSize);
      if( is_array($tabFileInfo) && count($tabFileInfo)==2 ) {
        if( $tabFileInfo[0] > $tabFileInfo[1] && $tabFileInfo[1]>0 ) {
          // erreur survenue en fin de transfert
          $strStatus = "0|"._t("Erreur rencontrée. Annulation de la décompression.");
        } else {
          $strStatus = "1|".$iTotalSizePipeCurentSize;
        }
      } else {
        // information non reçue
        $strStatus = "2|"._t("Décompression en cours...");
      } 
    }

    if( substr($strStatus, 0, 1) == "0" ) {
      // suppression des fichiers temporaires
      foreach($tabFiles as $strSuffixe) {
        @unlink($strTmpPath.$idSession.$strSuffixe);
      }
    }
    echo $strStatus;
    break;
  
  case 13: // calcul l'avancement de l'ajout des pièces jointes décompressées
    $idSession = AlkRequest::getToken("idUnique", AlkRequest::_REQUEST("idUnique", ""));

    $tabFiles = array("_addpj_progress", "_addpj_error");
    
    $strTmpPath = ini_get("upload_tmp_dir")."/";
    $strPathInfoFileName = $strTmpPath.$idSession.$tabFiles[0];
    $strPathErrFileName  = $strTmpPath.$idSession.$tabFiles[1];

    $strStatus = "";

    if( file_exists($strPathErrFileName) && is_file($strPathErrFileName)) {
      // erreur rencontrée
      $strMsg = @file_get_contents($strPathErrFileName);
      if( $strMsg == "" ) {
        $strMsg = _t("Erreur rencontrée. Echec de l'ajout des pièces jointes.");
      }
      $strStatus = "0|".$strMsg;
    } else {
      $iTotalSizePipeCurentSize = @file_get_contents($strPathInfoFileName);
      $tabFileInfo = explode("|", $iTotalSizePipeCurentSize);
      if( is_array($tabFileInfo) && count($tabFileInfo)==2 ) {
        if( $tabFileInfo[0] > $tabFileInfo[1] && $tabFileInfo[1]>0 ) {
          // erreur survenue en fin de transfert
          $strStatus = "0|"._t("Erreur rencontrée. Echec de l'ajout des pièces jointes.");
        } else {
          $strStatus = "1|".$iTotalSizePipeCurentSize;
        }
      } else {
        // information non reçue
        $strStatus = "2|"._t("Ajout des pièces jointes en cours...");
      } 
    }

    if( substr($strStatus, 0, 1) == "0" ) {
      // suppression des fichiers temporaires
      foreach($tabFiles as $strSuffixe) {
        @unlink($strTmpPath.$idSession.$strSuffixe);
      }
    }
    echo $strStatus;
    break;
 case 14: // Ajout pièce jointe via le filemanager
   $user_id       =  AlkFactory::getSProperty("user_id", "-1");
   $data_id       = AlkRequest::getToken("data_id", "-1");
   $lang_id       = AlkRequest::getToken("lang_id", "-1");
   $tableName     = AlkRequest::getToken("tableName", "");
   $dirUpload     = AlkRequest::getToken("dirUpload", "");
   $champName     = AlkRequest::getToken("champName", "");
   $bVersionning  = AlkRequest::getToken("versionning", "0")=="1";  
   $formName      = AlkRequest::getToken("formName", ""); 
   $strFileName   = AlkRequest::_REQUEST("strPath");
   
   // enlever le ALK_ALKANET_ROOT_URL
   if (defined("ALK_ALKANET_ROOT_URL") && ALK_ALKANET_ROOT_URL != ""){
     $strFileName = str_replace(ALK_ALKANET_ROOT_URL, "", $strFileName);
   }
   // enlever le ALK_VIRTUAL_DIR
   if (defined("ALK_VIRTUAL_DIR") && ALK_VIRTUAL_DIR != "/"){
     $strFileName = str_replace(ALK_VIRTUAL_DIR, "", $strFileName);
   }
   $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ALKANET);
   $tabFileName = explode("/", $strFileName);
   $strFileName2 = $tabFileName[count($tabFileName)-1];
   
   // on tente de supprimer le préfixe
   $strFileNameT = mb_ereg_replace("^[0-9]+_[0-9]+_", "", $strFileName2);
   if ($strFileNameT != ""){
     $strFileName2 = $strFileNameT;
   }
   $strPathFileNameSrc = ALK_ALKANET_ROOT_PATH.$strFileName;
   $strPathFileNameDest = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.$dirUpload.$strFileName2;
   if ($strPathFileNameSrc==$strPathFileNameDest || file_exists($strPathFileNameDest)){
     $strFileName2 = getFileRadical($strFileName2)."_".$data_id.getFileExtension($strFileName2, true);
     $strPathFileNameDest = ALK_ALKANET_ROOT_PATH.ALK_ROOT_UPLOAD.$dirUpload.$strFileName2;
   }
   // recopie du fichier
   $bCopy = copyFile($strPathFileNameSrc, $strPathFileNameDest);
   $pj_id = $oQuery->AddPj($tableName, $data_id, $champName, $user_id, ALK_ALKANET_ROOT_PATH, ALK_ROOT_UPLOAD.$dirUpload, $lang_id, true, $strFileName2, $bVersionning);
   
   // rafraichissement de la page
   require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlupload.class.php");
   $oCtrl = new AlkHtmlUpload(null, 3, $champName, "", $tableName, $data_id, $dirUpload);
   if ( $bVersionning ) $oCtrl->setVersionning(true);
   $oCtrl->setProperty("formName", $formName);
   $tabRes = array("layerName"     => "list_upload_".$champName,
                    "htmlContents"  => $oCtrl->getListDynamicHtml()); 
   echo json_encode($tabRes);
  break;
  
  case 15: // suppression du cache
   $strCacheName = AlkRequest::getToken("c", "");
   AlkFactory::memCacheFlush($strCacheName);
   echo "1";exit();
  break;
}
?>
