<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormAgentForm
 * 
 * Classe de gestion formulaire fiche utilisateur de l'Annuaire
 */
class AlkHtmlFormAgentForm extends AlkHtmlForm 
{
  protected $bOwner;
  protected $bAdminAll;         // user_id admin de tout l'annuaire
  protected $bAdminService;     // user_id admin du service  
  protected $bAdminServiceForUser;  // bAdminService && user_id.service_id = agent_id.service_id
  protected $user_priv;
  protected $strDefaultPwd;

  /** dataForm */
  protected $agent_id;
  protected $agent_civilite;
  protected $agent_nom;
  protected $agent_prenom;
  protected $agent_trigramme;
  protected $agent_lg;

  protected $agent_photo;
  protected $agent_mail;

  protected $agent_tel;
  protected $agent_telposte;
  protected $agent_fax;
  protected $agent_mobile;

  protected $adr_adr1;
  protected $adr_adr2;
  protected $adr_adr3;
  protected $adr_post;
  protected $adr_ville;
  protected $adr_pays;

  protected $service_id;
  protected $servNiv1_id;

  protected $agent_priv;
  protected $profil_id;

  protected $agent_fonction;
  protected $agent_desc;

  protected $agent_dateconn;
  protected $agent_datecrea;
  protected $agent_datemaj;
  protected $agent_nomcrea;
  protected $agent_nommaj;

  protected $agent_date_valid;
  protected $agent_valide;
  protected $agent_date_limit;

  protected $agent_login;
  protected $agent_pwd;
  protected $agent_pwd2;
  protected $agent_pwdinit;
  protected $agent_ldap;
  protected $agent_adminauth;

  protected $cont_id_start;

  protected $bInternet;

  /**
   *  constructeur par défaut
   * @param oAppli Référence sur l'application par défaut
   */  
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formUser"); 
    $this->iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $strAction = ALK_ALKANET_SQL."?".$_SERVER["QUERY_STRING"];
    $this->setProperties($this->iMode, ALK_FORM_METHOD_POST, $strAction);    	 
    
    $this->bInternet = false;    	 
  }

  /**
   * Modifie ou retourne la valeur de l'attribut bInternet
   * Si le paramètre est présent, la fonction fait office d'accesseur modificateur
   * Sinon, la fonction retourne uniquement la valeur de l'attribut
   * @param bInternet  booléen optionnel
   * @return bool
   */
  public function setInternet()
  {
    if( func_num_args() == 1 && is_bool($bInternet = func_get_arg(0))) {
      $this->bInternet = $bInternet;
    }

    return $this->bInternet;
  }

  /**
   *  Retourne le mot de passe par défaut
   * @return string
   */
  protected function makeDefaultPwd()
  {
    $strPwd = "";
    for($i=0; $i<ALK_ANNU_LG_MAX_PWD; $i++) {
      $strPwd .= "*";
    }
    return $strPwd;
  }
  
  /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   * @param iTypeInit  type de récupération
   */  
  protected function setData($iTypeInit)
  {
    $user_id   = AlkFactory::getSProperty("user_id", "-1");
    $agent_id  = AlkRequest::getToken("agent_id", "-1");
    $user_priv = AlkFactory::getSProperty("user_priv", "0");
    
    $this->bAdminAll     = AlkFactory::isAnnuAdminAll();
    $this->bAdminService = AlkFactory::isAnnuAdminServ(); //AlkFactory::isAnnuAdminAll();
    $this->bAdminServiceForUser = false; // false par defaut; modifier en fin de fonction
    $this->bOwner        = ( $agent_id == $user_id );
    $this->strDefaultPwd = $this->makeDefaultPwd();
    
    $this->agent_id        = new AlkFormData($this, "agent_id", $agent_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->agent_civilite  = new AlkFormData($this, "agent_civilite", "",   ALK_SQL_TEXT);  
    $this->agent_nom       = new AlkFormData($this, "agent_nom",      "",   ALK_SQL_TEXT);    
    $this->agent_prenom    = new AlkFormData($this, "agent_prenom",   "",   ALK_SQL_TEXT);
    $this->agent_lg        = new AlkFormData($this, "agent_lg",       $GLOBALS["tabLocales"]["frontoffice"][0],   ALK_SQL_TEXT);   
    $this->agent_mail      = new AlkFormData($this, "agent_mail",     "",   ALK_SQL_TEXT);    
    $this->agent_priv      = new AlkFormData($this, "agent_priv",     "0",  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->agent_privcb    = new AlkFormData($this, "agent_privcb",   "0",  ALK_SQL_NONE);
    $this->profil_id       = new AlkFormData($this, "profil_id",      "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    
    $this->agent_adminauth = new AlkFormData($this, "agent_adminauth","1",  ALK_SQL_NUMBER, ALK_VERIF_CHECK);
    $this->agent_valide    = new AlkFormData($this, "agent_valide",   ( $this->iMode==ALK_FORM_MODE_ADD ? "0" : "1"),  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->agtype_id       = new AlkFormData($this, "agtype_id",      "0",  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);

    if( $this->iMode == ALK_FORM_MODE_UPDATE ) {
      $this->agent_validemem = new AlkFormData($this, "agent_validemem","1",  ALK_SQL_NONE);
      $this->agent_fonction  = new AlkFormData($this, "agent_fonction", "",   ALK_SQL_TEXT);
      $this->agent_desc      = new AlkFormData($this, "agent_desc",     "",   ALK_SQL_TEXT);
      $this->agent_trigramme = new AlkFormData($this, "agent_trigramme", "",  ALK_SQL_TEXT);
      $this->agent_photo     = new AlkFormData($this, "agent_photo",     "",  ALK_SQL_TEXT);    
      $this->agent_login     = new AlkFormData($this, "agent_login",     "",  ALK_SQL_TEXT);
      $this->agent_loginmem  = new AlkFormData($this, "agent_loginmem",  "",  ALK_SQL_NONE);
      $this->agent_pwd       = new AlkFormData($this, "agent_pwd",       "",  ALK_SQL_TEXT);
      $this->agent_pwd2      = new AlkFormData($this, "agent_pwd2",      "",  ALK_SQL_TEXT);
      $this->agent_pwdinit   = new AlkFormData($this, "agent_pwdinit",   "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
      $this->cont_id_start   = new AlkFormData($this, "cont_id_start",   "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
      if( ALK_LDAP ) {
        $this->agent_ldap      = new AlkFormData($this, "agent_ldap",      "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
      }
      
      $this->agent_tel      = new AlkFormData($this, "agent_tel",      "", ALK_SQL_TEXT);
      $this->agent_telposte = new AlkFormData($this, "agent_telposte", "", ALK_SQL_TEXT);
      $this->agent_fax      = new AlkFormData($this, "agent_fax",      "", ALK_SQL_TEXT);
      $this->agent_mobile   = new AlkFormData($this, "agent_mobile",   "", ALK_SQL_TEXT);

      $this->adr_adr1  = new AlkFormData($this, "adr_adr1",  "", ALK_SQL_TEXT);
      $this->adr_adr2  = new AlkFormData($this, "adr_adr2",  "", ALK_SQL_TEXT);
      $this->adr_adr3  = new AlkFormData($this, "adr_adr3",  "", ALK_SQL_TEXT);
      $this->adr_post  = new AlkFormData($this, "adr_post",  "", ALK_SQL_TEXT);
      $this->adr_ville = new AlkFormData($this, "adr_ville", "", ALK_SQL_TEXT);
      $this->adr_pays  = new AlkFormData($this, "adr_pays",  "", ALK_SQL_TEXT);
  
      $this->agent_dateconn  = new AlkFormData($this, "agent_dateconn", "", ALK_SQL_NONE);
      $this->agent_datecrea  = new AlkFormData($this, "agent_datecrea", "", ALK_SQL_NONE);
      $this->agent_datemaj   = new AlkFormData($this, "agent_datemaj",  "", ALK_SQL_NONE);
      $this->agent_nomcrea   = new AlkFormData($this, "agent_nomcrea",  "", ALK_SQL_NONE);
      $this->agent_nommaj    = new AlkFormData($this, "agent_nommaj",   "", ALK_SQL_NONE);

      $this->agent_date_valid = new AlkFormData($this, "agent_date_valid", "", ALK_SQL_NONE);
      $this->agent_valide     = new AlkFormData($this, "agent_valide",     "", ALK_SQL_NONE);
      $this->agent_date_limit = new AlkFormData($this, "agent_date_limit", "", ALK_SQL_NONE);
    } else {
      $this->service_id      = new AlkFormData($this, "service_id",     "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    }

    $oDrData = null;
    $reqMethod = -1;
    if( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      $oDsData = $this->oAppli->oQuery->getDs_ficheAgent($agent_id);
      $oDrData = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;

    $this->initData($iTypeInit, $oDrData, $reqMethod);
    
    if(/*$this->iMode == ALK_FORM_MODE_UPDATE*/ $this->iMode != ALK_FORM_MODE_ADD && $this->iMode != ALK_FORM_MODE_DEL && $oDrData) { // besoin d'initialiser bAdminServiceForUser dans les appels AJAX (13, 14, 15)
      // bAdminServiceForUser
      $this->servNiv1_id = $oDrData->getValueName("SERVICE_ID"); 
      $this->bAdminServiceForUser = $this->bAdminService && 
        ( $this->servNiv1_id == AlkFactory::getSProperty("service_id", "-1")); 
    }
    //echo "bAdminAll: ".intVal($this->bAdminAll)." ; bAdminService: ".intVal($this->bAdminService).
    //     " ; bAdminServiceForUser: ".intVal($this->bAdminServiceForUser)." ; bAdminSpaceAll: ".intval(AlkFactory::isSpaceAnimAll()).
    //     " ; user_id: ".$user_id." ; agent_id: ".$agent_id;
    
    if ( defined("ALK_B_ANNU_AGENT_GENERIC") && ALK_B_ANNU_AGENT_GENERIC ) {
      if ( $this->agtype_id->value == "0" ) {
        $this->bGeneric = false;
      } else {
        $this->bGeneric = true;
      }
    } else {
      $this->bGeneric = false;
    }
  }
   

  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  {
    $user_id     = AlkFactory::getSProperty("user_id", "-1");
    $userServ_id = AlkFactory::getSProperty("service_id", "-1");
    
    $oSpace = $this->oAppli->getProperty("oSpace", null);
    
    $strUrl = "";
    switch( $this->iMode ) {
    case ALK_FORM_MODE_ADD:
      $this->setData(ALK_INIT_MODE_REQUEST);
      
      $tabFields = $this->getTabQuery(array(), array("AGENT_PRIVCB"));
      $agent_id = $this->oAppli->addUser($tabFields);
      
      $oSpace->callService($this->oAppli->atype_id, "doSqlAnnuUserForm", $this, $agent_id, $tabFields);
      
      // retour sur l'onglet Modifier avec la fiche créée
      $strToken = $this->oAppli->getToken($this->iTypeSheet, ALK_SHEET_MODIFIER, ALK_SHEET_NONE, 
                                          "&iMode=".ALK_FORM_MODE_UPDATE."&agent_id=".$agent_id);
      $strUrl = ALK_ALKANET."?token=".$strToken;
      break;
      
    case ALK_FORM_MODE_UPDATE:
      $this->setData(ALK_INIT_MODE_REQUEST);

      $iSheet = AlkRequest::getToken("iSheet", ALK_SHEET_MODIFIER);
      $agent_id = AlkRequest::getToken("agent_id", "-1");
      $tabIgnore = array("AGENT_DATE_CREA", "AGENT_NONCREA", "AGENT_DATE_MAJ", "AGENT_NOMMAJ", "AGENT_DATE_LIMIT");
      
      // si block Param SIT invisible, ne pas ajouter les champs correspondants
      //if(!($this->bOwner || $this->bAdminAll || $this->bAdminServiceForUser)) {
      //  $tabIgnore = array_merge($tabIgnore, Array("AGENT_VALIDE", "AGENT_VALIDEMEM", "AGENT_LOGIN", "AGENT_LOGINMEM", 
      //    "AGENT_PWD", "AGENT_PWD2", "AGENT_PWDINIT", "CONT_ID_START"));
      //}
      
      $tabFields = $this->getTabQuery(array("AGENT_ID"), $tabIgnore);
      $tabFields["field"]["SERVICE_ID"][1] = AlkRequest::_POSTint("serv1_id", "-1");
      
      //die(print_r($tabFields,true)); // <---
      $this->oAppli->updateUser($agent_id, $tabFields);
      
      $oSpace->callService($this->oAppli->atype_id, "doSqlAnnuUserForm", $this, $agent_id, $tabFields);
      
      $strUrl = AlkRequest::getToken("urlBack", "");
      $this->bInternet = ( $strUrl != "" );
      
      if( !$this->bInternet ) {
        // retour sur le formulaire si ma fiche, sinon sur la recherche
        $strToken = ( $user_id == $agent_id
                      ? $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, $iSheet, ALK_SHEET_NONE, "&iMode=".ALK_FORM_MODE_UPDATE."&agent_id=".$agent_id)
                      : $this->getTokenBack() );
        $strUrl = ALK_ALKANET."?token=".$strToken;
      }
      break;
      
    case ALK_FORM_MODE_DEL :
      $agent_id = AlkRequest::getToken("agent_id", "-1");
      
      $oSpace->callService($this->oAppli->atype_id, "doSqlAnnuUserForm", $this, $agent_id, array());
      
      $this->oAppli->delUser($agent_id);

      // retour la page de recherche
      $strUrl = ALK_ALKANET."?token=".$this->getTokenBack();
      break;
    
    case 10: // modification filiation par ajax
      $agent_id = AlkRequest::getToken("ida", "-1");
      $iNiv = AlkRequest::getToken("niv", "-1");
      $id0s = AlkRequest::_GETint("id0s", "-2");
      $id1s = AlkRequest::_GETint("id1s", "-1");
      $id2s = AlkRequest::_GETint("id2s", "-1");
      $id3s = AlkRequest::_GETint("id3s", "-1");
      $id4s = AlkRequest::_GETint("id4s", "-1");
      if( $iNiv == "1" || $id1s == "-1" ) $id2s = "-1";
      if( $id2s == "-1" ) $id3s = "-1";
      if( $id3s == "-1" ) $id4s = "-1";
      
      if( $agent_id != "-1" )
        $this->oAppli->oQueryAction->delAddFiliation($agent_id, $iNiv, $id1s, $id2s, $id3s, $id4s);

      $strJsHtml = " var tabOptionsServ = new Array();";
      $tabServ_id = array(1, $id1s, $id2s, $id3s, $id4s);
      for($i=1; $i<$iNiv+1; $i++) {
        // pas de changement à ce niveau
        $strJsHtml .= " tabOptionsServ[".($i-1)."] = '';";
      }
      for($i=$iNiv+1; $i<=4; $i++) {
        $dsServ = $this->oAppli->oQuery->getDsListeServiceForCombo($i, $tabServ_id[$i-1], true, 55, "", $id0s);
        $nbElt = $dsServ->getCountTotDr();
        $strJsHtml .= " tabOptionsServ[".($i-1)."] = new Array();";
        if( $nbElt > 0 ) {
          $strJsHtml .= " tabOptionsServ[".($i-1)."][0] = new Array('-1', '"._f("Sélectionnez un service de niveau %s", $i)."');";
          while( $drServ = $dsServ->getRowIter() ) {
            $idServ  = $drServ->getValueNum(1);
            $strServ = $drServ->getValueNum(0);
            $strServ = addslashes(mb_ereg_replace('"', '', $strServ));
            $strJsHtml .= " tabOptionsServ[".($i-1)."][tabOptionsServ[".($i-1)."].length] = new Array('".$idServ."', '".$strServ."');";
          }
        } 
      }
      
      if( $iNiv == "1" && AlkFactory::isAnnuAdminServ() && $userServ_id!=$id1s ) {
        // on redirige vers la page de recherche car l'utilisateur n'est pas apte à modifier la fiche
        $strToken = $this->getTokenBack();
        $strJsHtml .= " var strUrl = '".ALK_ALKANET."?token=".$strToken."';";
      } else {
        $strJsHtml .= " var strUrl = '';";
      }

      // retour : code js des 4 tableaux pour chaque niveau de service
      echo $strJsHtml;
      break;

    case 11: // ajout mission, retrait de la liste dispo par ajax
      $agent_id = AlkRequest::getToken("ida", "-1");
      $mission_id = AlkRequest::_GETint("idd", "-1");

      $this->oAppli->oQueryAction->delAddAgentMission($agent_id, $mission_id, false);
      // aucun retour ajax
      break;

    case 12: // retrait mission, recalcul de la liste dispo par ajax
      $agent_id = AlkRequest::getToken("ida", "-1");
      $mission_id = AlkRequest::_GETint("idd", "-1");

      $this->oAppli->oQueryAction->delAgentMission($agent_id, $mission_id);
      // aucun retour ajax
      break;

    case 13: // modif profil principal, suppression du profil secondaire si présent par ajax
      $this->setData(ALK_INIT_MODE_REQUEST+ALK_INIT_MODE_DATAROW);
      
      $agent_id = AlkRequest::getToken("agent_id", "-1");
      $profil_id = AlkRequest::_GETint("idd", "-1");
      
      $strJsHtml = "";
      
      // vérfication des droits
      $bOk = false;
      if( $this->bAdminAll ) {
        $bOk = true;
      } else if( $this->bAdminServiceForUser ) {
        if( !$this->bOwner ) {
          $oDsProfil = $this->oAppli->oQuery->getDsListProfilAgentForCombo($user_id, false, false);
          while( $oDrProfil = $oDsProfil->getRowIter() ) {
            if ( $profil_id == $oDrProfil->getValueName("PROFIL_ID") ) {
              $bOk = true;
              break;
            }
          }
        }
      }
      if( $bOk ) {
        $this->oAppli->oQueryAction->addAgentProfil($agent_id, $profil_id, true);
      } else {
        $profil_id = $this->profil_id->value;
      }
      
      $oSpace = AlkFactory::getSpace();
      $oSpace->setProfilRightToUser($agent_id);
      
      // profil principal
      $strJsHtml .= "var profil_id = ".$profil_id.";";
      
      // liste des profils dispos
      $strJsHtml .= " var tabOptionsPD = new Array();";
      $dsProfil = $this->oAppli->oQuery->getDsListProfilAgentForCombo($agent_id, true, true);
      while( $drProfil = $dsProfil->getRowIter() ) {
        $idProfil  = $drProfil->getValueName("PROFIL_ID");
        $strProfil = $drProfil->getValueName("PROFIL_INTITULE");
        $strProfil = addslashes(mb_ereg_replace('"', '', $strProfil));
        $strJsHtml .= " tabOptionsPD[tabOptionsPD.length] = new Array('".$idProfil."', '".$strProfil."');";
      }
      // liste profils secondaires associés
      $strJsHtml .= " var tabOptionsPS = new Array();";
      $dsProfil = $this->oAppli->oQuery->getDsListProfilAgentForCombo($agent_id, true, false);
      while( $drProfil = $dsProfil->getRowIter() ) {
        $idProfil  = $drProfil->getValueName("PROFIL_ID");
        $strProfil = $drProfil->getValueName("PROFIL_INTITULE");
        $strProfil = addslashes(mb_ereg_replace('"', '', $strProfil));
        $strJsHtml .= " tabOptionsPS[tabOptionsPS.length] = new Array('".$idProfil."', '".$strProfil."');";
      }
      
      if( $bOk ) {
        $oSpace->callService($this->oAppli->atype_id, "doSqlAnnuUserForm", $this, $agent_id, array("profil_id" => $profil_id));
      }
      
      // retour: code js profil_id + 2 tableaux
      echo $strJsHtml;
      $strUrl = "";
      break;

    case 14: // ajout profil secondaire, retrait de la liste dispo par ajax
      $this->setData(ALK_INIT_MODE_REQUEST+ALK_INIT_MODE_DATAROW);
      
      $agent_id = AlkRequest::getToken("agent_id", "-1");
      $profil_id = AlkRequest::_GETint("idd", "-1");
      
      $strJsHtml = "";
      
      // vérfication des droits
      $bOk = false;
      if( $this->bAdminAll ) {
        $bOk = true;
      } else if( $this->bAdminServiceForUser ) {
        if( !$this->bOwner ) {
          $oDsProfil = $this->oAppli->oQuery->getDsListProfilAgentForCombo($user_id, false, false);
          while( $oDrProfil = $oDsProfil->getRowIter() ) {
            if ( $profil_id == $oDrProfil->getValueName("PROFIL_ID") ) {
              $bOk = true;
              break;
            }
          }
        }
      }
      if( $bOk ) {
        $this->oAppli->oQueryAction->addAgentProfil($agent_id, $profil_id, false);
      }
      
      $oSpace = AlkFactory::getSpace();
      $oSpace->setProfilRightToUser($agent_id);
      
      // liste des profils dispos
      $strJsHtml .= " var tabOptionsPD = new Array();";
      $dsProfil = $this->oAppli->oQuery->getDsListProfilAgentForCombo($agent_id, true, true);
      while( $drProfil = $dsProfil->getRowIter() ) {
        $idProfil  = $drProfil->getValueName("PROFIL_ID");
        $strProfil = $drProfil->getValueName("PROFIL_INTITULE");
        $strProfil = addslashes(mb_ereg_replace('"', '', $strProfil));
        $strJsHtml .= " tabOptionsPD[tabOptionsPD.length] = new Array('".$idProfil."', '".$strProfil."');";
      }
      // liste profils secondaires associés
      $strJsHtml .= " var tabOptionsPS = new Array();";
      $dsProfil = $this->oAppli->oQuery->getDsListProfilAgentForCombo($agent_id, true, false);
      while( $drProfil = $dsProfil->getRowIter() ) {
        $idProfil  = $drProfil->getValueName("PROFIL_ID");
        $strProfil = $drProfil->getValueName("PROFIL_INTITULE");
        $strProfil = addslashes(mb_ereg_replace('"', '', $strProfil));
        $strJsHtml .= " tabOptionsPS[tabOptionsPS.length] = new Array('".$idProfil."', '".$strProfil."');";
      }
      
      if( $bOk ) {
        $oSpace->callService($this->oAppli->atype_id, "doSqlAnnuUserForm", $this, $agent_id, array("profil_id" => $profil_id));
      }
      
      // retour: code js des 2 tableaux
      echo $strJsHtml;
      $strUrl = "";
      break;

    case 15: // retrait profil secondaire, recalcul de la liste dispo par ajax
      $this->setData(ALK_INIT_MODE_REQUEST+ALK_INIT_MODE_DATAROW);
      
      $agent_id = AlkRequest::getToken("agent_id", "-1");
      $profil_id = AlkRequest::_GETint("idd", "-1");
      
      $strJsHtml = "";
      
      // vérfication des droits
      $bOk = false;
      if( $this->bAdminAll ) {
        $bOk = true;
      } else if( $this->bAdminServiceForUser ) {
        if( !$this->bOwner ) {
          $oDsProfil = $this->oAppli->oQuery->getDsListProfilAgentForCombo($user_id, false, false);
          while( $oDrProfil = $oDsProfil->getRowIter() ) {
            if ( $profil_id == $oDrProfil->getValueName("PROFIL_ID") ) {
              $bOk = true;
              break;
            }
          }
        }
      }
      if( $bOk ) {
        $this->oAppli->oQueryAction->delAgentProfil($agent_id, $profil_id);
      }
      
      $oSpace = AlkFactory::getSpace();
      $oSpace->setProfilRightToUser($agent_id);
      
      // liste des profils dispos
      $strJsHtml .= " var tabOptionsPD = new Array();";
      $dsProfil = $this->oAppli->oQuery->getDsListProfilAgentForCombo($agent_id, true, true);
      while( $drProfil = $dsProfil->getRowIter() ) {
        $idProfil  = $drProfil->getValueName("PROFIL_ID");
        $strProfil = $drProfil->getValueName("PROFIL_INTITULE");
        $strProfil = addslashes(mb_ereg_replace('"', '', $strProfil));
        $strJsHtml .= " tabOptionsPD[tabOptionsPD.length] = new Array('".$idProfil."', '".$strProfil."');";
      }
      // liste profils secondaires associés
      $strJsHtml .= " var tabOptionsPS = new Array();";
      $dsProfil = $this->oAppli->oQuery->getDsListProfilAgentForCombo($agent_id, true, false);
      while( $drProfil = $dsProfil->getRowIter() ) {
        $idProfil  = $drProfil->getValueName("PROFIL_ID");
        $strProfil = $drProfil->getValueName("PROFIL_INTITULE");
        $strProfil = addslashes(mb_ereg_replace('"', '', $strProfil));
        $strJsHtml .= " tabOptionsPS[tabOptionsPS.length] = new Array('".$idProfil."', '".$strProfil."');";
      }
      
      if( $bOk ) {
        $oSpace->callService($this->oAppli->atype_id, "doSqlAnnuUserForm", $this, $agent_id, array("profil_id" => $profil_id));
      }
      
      // retour: code js des 2 tableaux
      echo $strJsHtml;
      $strUrl = "";
      break;
      
    case 16: // mise à jour ldap, requete ajax
      $agent_id   = AlkRequest::getToken("ida", "-1");
      $agent_mail = AlkRequest::_GET("m", "");
      $strHtmlJs = " var cpt = 0; ";
      $dsUser = $this->oAppli->oQuery->getDsLdapUserInfo($agent_mail);
      if( $dsUser->isConnected() ) {
      if( $drUser = $dsUser->getRowIter() ) {
        $tabLdapAssoc = unserialize(ALK_LDAP_ASSOC_ANNU);
        foreach($tabLdapAssoc as $tabAnnu) {
          $strValue = $drUser->getValueName($tabAnnu["field"]);
          if( $strValue != "" ) { 
            $strHtmlJs .= " if( f.".mb_strtolower($tabAnnu["field"])." ) {".
              " f.".mb_strtolower($tabAnnu["field"]).".value = \"".$strValue."\";".
              " f.".mb_strtolower($tabAnnu["field"]).".className = f.".mb_strtolower($tabAnnu["field"]).".className + ' formSelect';". 
              " cpt++; } ";
          }
        }
      } else {
        $strHtmlJs = " var cpt = -1; ";
      }
      } else {
        $strHtmlJs = " var cpt = -2; ";
      }
      $strHtmlJs .= " var strLdapName = \"".ALK_LDAP_NAME."\"; ";
      echo $strHtmlJs;
      $strUrl = "";
      break;
      
    case 17: // modif du login, requete ajax
      $agent_id = AlkRequest::getToken("ida", "-1");
      $strLoginProp = AlkRequest::_GET("l", "");
      
      $strLogin = $this->oAppli->oQueryAction->getStrVerifyLogin($agent_id, $strLoginProp, ALK_ANNU_LG_MAX_LOGIN);
      if( mb_strtolower($strLoginProp)==$strLogin ) {
        $this->oAppli->oQueryAction->updateUserLogin($agent_id, $strLogin);
      }
      
      echo $strLogin;
      $strUrl = "";
      break;
    
    case 18 : // vérification mail pour utilisation comme login, requête ajax
      $agent_mail = AlkRequest::_GET("agent_mail", "");
      $strLogin = $this->oAppli->oQueryAction->getStrVerifyLogin(-1, $agent_mail, ALK_ANNU_LG_MAX_LOGIN);
      if ( $strLogin == "" ) {
        echo 0;
      } else {
        echo 1;
      }
      break;
    }
    return $strUrl;
  } 

  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    if( $this->iMode==ALK_FORM_MODE_ADD ) {
      $this->setData(-1);  
      $this->setContentsAdd();
      $this->setTemplate("annu", "alkhtmlformagentformadd.tpl");
    } else {
      $this->setData(ALK_INIT_MODE_DATAROW);
      if ( $this->bOwner && $this->bGeneric ) {
        $this->iMode = ALK_FORM_MODE_READ;
      }
      if( !$this->bInternet ) {
        $this->setContentsUpdate();
        $this->setTemplate("annu", "alkhtmlformagentform.tpl");
        $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
      } else {
        $this->setContentsUpdateInternet();
        $this->setTemplate("annu", "alkhtmlformagentform_internet.tpl");
        $this->addVarJs("ALK_ALKANET_ROOT_URL", "'".ALK_ALKANET_ROOT_URL."'");
      }
    }
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlformagentform.js");
  }

  /**
   *  Définition du contenu affiché en mode ajout
   */
  private function setContentsAdd()
  {
    $bAnnuAdminAll = AlkFactory::isAnnuAdminAll();
    
    $iSelectWidth = 280;
    $iTxtWidth    = 38;
    $iMemoHeight  = 4;
    $iMemoWidth   = 36;

    $iWidthLabel = 150;
    $iWidthCtrl  = $iSelectWidth+10;

    $this->setLabelDesc(_t("Les champs suivis d'une astérisque (*) sont obligatoires."));

    $oCtrlCivilite = AlkHtmlFactory::getHtmlSelect($this->agent_civilite, _t("Civilité"));
    $tabValTxt = array(" "    => "",
                       "Mme"  => _t("Mme"),
                       "Mlle" => _t("Mlle"),
                       "M"    => _t("M"));
    $oCtrlCivilite->setProperty("tabValTxt", $tabValTxt);  
    
    $oCtrlNom = AlkHtmlFactory::getHtmlText($this->agent_nom, _t("Nom"), 1, $iTxtWidth, 100);
    $oCtrlNom->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);    

    $oCtrlPrenom = AlkHtmlFactory::getHtmlText($this->agent_prenom, _t("Prénom"), 1, $iTxtWidth, 40);
    $oCtrlPrenom->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);

    $oCtrlMail = AlkHtmlFactory::getHtmlText($this->agent_mail, _t("Courriel"), 1, $iTxtWidth, 255);
    $oCtrlMail->addValidator(ALK_VERIF_MAIL+ALK_IS_REQUIRED);    

    if( count($GLOBALS["tabStrLocales"]) > 1 ) {
      $oCtrlLg = AlkHtmlFactory::getHtmlSelect($this->agent_lg, _t("Langue - Pays"),  1, $iSelectWidth);
      $oCtrlLg->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, "-1");    
      //$oCtrlLg->setProperty("tabValTxtDefault", array("", ""));                                  
      $oCtrlLg->setProperty("tabValTxt", $GLOBALS["tabStrLocales"]);
    } else {
      $tabLocales = array_keys($GLOBALS["tabStrLocales"]);
      $this->agent_lg->value = $tabLocales[0]; 
      $oCtrlLg = AlkHtmlFactory::getHtmlHidden($this->agent_lg);
    }

    $defaultServNiv1_id = AlkFactory::getSProperty("service_id", "-1");
    $oCtrlServ = AlkHtmlFactory::getNewHtmlSelect($this, ($bAnnuAdminAll ? 0 : 1), "service_id", $defaultServNiv1_id, _t("Service de rattachement"), 1, $iSelectWidth);
    $oCtrlServ->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, "-1");    
    $oCtrlServ->setProperty("tabValTxtDefault", array("-1", ""));                                  
    $oCtrlServ->setProperty("oValTxt", $this->oAppli->oQuery->getDsListeServiceForCombo(1, -1, false));
    $oCtrlServ->setWriteHiddenOnReadOnly(!$bAnnuAdminAll);

    $oCtrlProfil = AlkHtmlFactory::getHtmlSelect($this->profil_id, _t("Profil principal"));    
    $oCtrlProfil->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, "-1");    
    $oCtrlProfil->setProperty("tabValTxtDefault", array("-1", ""));
    // un utilisateur qui n'est pas administrateur de tout l'annuaire (notamment administateurs annuaire de service) ne peut affecter que les profils qu'il possède lui-même
    if( $this->bAdminAll ) {
      $oCtrlProfil->setProperty("oValTxt", $this->oAppli->oQuery->getDsListProfilForCombo());
    } else {
      $user_id = AlkFactory::getSProperty("user_id", "-1");
      $oCtrlProfil->setProperty("oValTxt", $this->oAppli->oQuery->getDsListProfilAgentForCombo($user_id));
    }

    $oCtrlValide    = AlkHtmlFactory::getHtmlCheckbox($this->agent_valide, _t("Compte Valide"));
    $oCtrlAdminAuth = AlkHtmlFactory::getHtmlCheckbox($this->agent_adminauth, _t("Connexion autorisée"));
    
    $oCtrlGeneric = null;
    if ( defined("ALK_B_ANNU_AGENT_GENERIC") && ALK_B_ANNU_AGENT_GENERIC ) {
      $oCtrlGeneric = AlkHtmlFactory::getHtmlCheckbox($this->agtype_id, _t("Compte de service"));
    }

    $oBlock = $this->addBlock("blockIdent", _f("Cr&eacute;ation %s pour l'annuaire", ALK_S_D1NAGENT), "", $iWidthLabel, $iWidthCtrl, true);
    $oBlock->addCtrl($oCtrlCivilite);
    $oBlock->addCtrl($oCtrlNom);
    $oBlock->addCtrl($oCtrlPrenom);
    $oBlock->addCtrl($oCtrlMail);
    $oBlock->addCtrl($oCtrlLg);
    $oBlock->addCtrl($oCtrlServ);
    $oBlock->addCtrl($oCtrlProfil);
    $oBlock->addCtrl($oCtrlValide);
    $oBlock->addCtrl($oCtrlAdminAuth);
    $oBlock->addCtrl($oCtrlGeneric);
    
    /** privileges */
    $oCtrlH = AlkHtmlFactory::getHtmlHidden($this->agent_priv);
    $bAnnuAdminAll = AlkFactory::isAnnuAdminAll();
    $bSpaceAnimAll = AlkFactory::isSpaceAnimAll();
    $bAnnuAdminServ = AlkFactory::isAnnuAdminServ();
    
    if( $bAnnuAdminAll || $bSpaceAnimAll || $bAnnuAdminServ ) { 
      $oCtrlPriv = AlkHtmlFactory::getHtmlCheckbox($this->agent_privcb, "");
      $oCtrlPriv->setItemsPerLine(1);
    
      if( $bAnnuAdminServ || $bAnnuAdminAll ) {
        $i1 = $oCtrlPriv->addCheckBox(ALK_PRIV_SPACE_NONE, _t("Administrateur annuaire de service"), ALK_PRIV_ANNU_SERV,   ALK_PRIV_SPACE_NONE, true);
        $oCtrlPriv->addEventToCheckBox($i1, "onclick", "onClickPriv(this)");
      }
      
      if( $bAnnuAdminAll && $bSpaceAnimAll ) {
        $i2 = $oCtrlPriv->addCheckBox(ALK_PRIV_SPACE_NONE, _t("Administrateur de tout l'annuaire"),  ALK_PRIV_ANNU_ALL,    ALK_PRIV_SPACE_NONE, true);
        $oCtrlPriv->addEventToCheckBox($i2, "onclick", "onClickPriv(this)");
      }
      
      if( $bAnnuAdminAll && $bSpaceAnimAll ) {
        $i3 = $oCtrlPriv->addCheckBox(ALK_PRIV_SPACE_NONE, _t("Animateur de tous les espaces"),      ALK_PRIV_SPACE_ADMIN, ALK_PRIV_SPACE_NONE, true);
        $oCtrlPriv->addEventToCheckBox($i3, "onclick", "onClickPriv(this)");
      }
      
      $oBlockPriv = $this->addBlock("blockPriv", _t("Privilèges"), "", 10, 220, false);
      $oBlockPriv->addCtrl($oCtrlPriv, ALK_HTMLFORM_1L1C);
      $oBlockPriv->addCtrl($oCtrlH);
    } else {
      $oBlock->addCtrl($oCtrlH);
    }
    
    
    /** Elements spécifiques aux applications de l'espace */
    $oSpace = $this->oAppli->getProperty("oSpace", null);
    if ( !is_null($oSpace) && (defined("ALK_B_ATYPE_ACL") && ALK_B_ATYPE_ACL==true))
      $oSpace->callService($this->oAppli->atype_id, "getHtmlAnnuUserForm", $this, $this, $this->agent_id->value);
    
    $strTokenAdd  = $this->getTokenAdd();
    $strTokenMail = $this->getTokenMail();
    $oButton = $this->addButtonPage("btValid", "javascript:ValidAdd('".$strTokenAdd."', '".$this->makeDefaultPwd()."', ".
              ( defined("ALK_B_ANNU_LOGIN_USE_MAIL") && ALK_B_ANNU_LOGIN_USE_MAIL ? 1 : 0 ).", '".$strTokenMail."');",
               _t("Valider"), _t("Valider"));
    $this->addSubmitButton($oButton);

    $oButton = $this->addButtonPage("btCancel", "javascript:CancelAdd()", _t("Annuler"), _t("Annuler les modifications"));
    $this->setResetButton($oButton);
  }

  /**
   *  Définition du contenu affiché en mode modif
   */
  private function setContentsUpdate()
  {
    $iSelectWidth = 270;
    $iTxtWidth    = 36;
    $iMemoHeight  = 3;
    $iMemoWidth   = 34;

    $iWidthLabelLeft  = 100;
    $iWidthCtrlLeft   = 280;
    $iWidthLabelRight = 100;
    $iWidthCtrlRight  = 250;

    $this->setLabelDesc(_t("Les champs suivis d'une astérisque (*) sont obligatoires."));
    
    /** identité */
    $oCtrlH = AlkHtmlFactory::getHtmlHidden($this->agent_id);
    $oCtrlH->addDataHidden($this->agent_priv);
    $this->agent_validemem->value = $this->agent_valide->value; 
    $oCtrlH->addDataHidden($this->agent_validemem);
    $this->agent_loginmem->value = $this->agent_login->value; 
    $oCtrlH->addDataHidden($this->agent_loginmem);

    $oCtrlCivilite = AlkHtmlFactory::getHtmlSelect($this->agent_civilite, "Civilité");
    $tabValTxt = array(" "    => "",
                       "Mme"  => _t("Mme"),
                       "Mlle" => _t("Mlle"),
                       "M"    => _t("M"));
    $oCtrlCivilite->setProperty("tabValTxt", $tabValTxt);  
    
    $oCtrlNom = AlkHtmlFactory::getHtmlText($this->agent_nom, _t("Nom"), 1, $iTxtWidth, 100);
    $oCtrlNom->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);    

    $oCtrlPrenom = AlkHtmlFactory::getHtmlText($this->agent_prenom, _t("Prénom"), 1, $iTxtWidth, 40);
    $oCtrlPrenom->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);

    $oCtrlTrigramme = null;
    if( ALK_B_ANNU_TRIGRAMME == true ) {
      $oCtrlTrigramme = AlkHtmlFactory::getHtmlText($this->agent_trigramme, _t("Trigramme"), 1, 5, 4);
      $oCtrlTrigramme->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED, 3, 4);
      /** @todo bouton pour proposer un trigramme */
    }

    $oCtrlPhoto = AlkHtmlFactory::getHtmlFile($this->agent_photo, _t("Photo (100x75px)"), $iTxtWidth);
    $oCtrlPhoto->setDualMode(true);
    $oCtrlPhoto->setFileUrl($this->oAppli->getUrlUpload(), $this->agent_photo->value);

    /** fonction */
    $oCtrlFonc = AlkHtmlFactory::getHtmlText($this->agent_fonction, _t("Fonction"), 1, $iTxtWidth, 255);
    $oCtrlDesc = AlkHtmlFactory::getHtmlText($this->agent_desc, _t("Description"), $iMemoHeight, $iMemoWidth, 4000);

    /** privileges */
    $agent_priv = $this->agent_priv->value;
    $tabValue = array(( ($agent_priv & ALK_PRIV_ANNU_SERV)   == ALK_PRIV_ANNU_SERV   ? ALK_PRIV_ANNU_SERV   : ALK_PRIV_SPACE_NONE ),
                      ( ($agent_priv & ALK_PRIV_ANNU_ALL)    == ALK_PRIV_ANNU_ALL    ? ALK_PRIV_ANNU_ALL    : ALK_PRIV_SPACE_NONE ),
                      ( ($agent_priv & ALK_PRIV_SPACE_ADMIN) == ALK_PRIV_SPACE_ADMIN ? ALK_PRIV_SPACE_ADMIN : ALK_PRIV_SPACE_NONE ));
    $oCtrlPriv = AlkHtmlFactory::getHtmlCheckbox($this->agent_privcb, "");
    $oCtrlPriv->setItemsPerLine(1);
    $oCtrlPriv->addCheckBox($tabValue[0], _t("Administrateur annuaire de service"), ALK_PRIV_ANNU_SERV,   ALK_PRIV_SPACE_NONE, true);
    $oCtrlPriv->addCheckBox($tabValue[1], _t("Administrateur de tout l'annuaire"),  ALK_PRIV_ANNU_ALL,    ALK_PRIV_SPACE_NONE, true);
    $oCtrlPriv->addCheckBox($tabValue[2], _t("Animateur de tous les espaces"),      ALK_PRIV_SPACE_ADMIN, ALK_PRIV_SPACE_NONE, true);
    $oCtrlPriv->addEventToCheckBox(0,   "onclick", "onClickPriv(this)");
    $oCtrlPriv->addEventToCheckBox(1,    "onclick", "onClickPriv(this)");
    $oCtrlPriv->addEventToCheckBox(2, "onclick", "onClickPriv(this)");
    
    $bSpecialUser = ( $this->agent_id->value == ALK_USER_ID_ADMINALK || $this->agent_id->value == ALK_USER_ID_INTERNET );
    
    if( !$this->bAdminAll || $bSpecialUser )
      $oCtrlPriv->setCheckBoxProperty(0, "disabled", "true");
    if( !(AlkFactory::isSpaceAnimAll() && $this->bAdminAll) || $bSpecialUser )
      $oCtrlPriv->setCheckBoxProperty(1, "disabled",  "true");
    if( !(AlkFactory::isSpaceAnimAll() && $this->bAdminAll) || $bSpecialUser )
      $oCtrlPriv->setCheckBoxProperty(2, "disabled", "true");
    
    /** coordonnées */
    $bReadOnly = !($this->bOwner || $this->bAdminAll || $this->bAdminServiceForUser);
    $oCtrlMail = AlkHtmlFactory::getHtmlText($this->agent_mail, _t("Courriel"), 1, $iTxtWidth, 255);
    $oCtrlMail->setReadOnly($bReadOnly);
    $oCtrlMail->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);

    $oCtrlTel = AlkHtmlFactory::getHtmlText($this->agent_tel, _t("Téléphone"), 1, 32, 30);
    $oCtrlTel->setReadOnly($bReadOnly);
    $oCtrlTel->addValidator(ALK_VERIF_TEXT);
    
    $oCtrlTelp = AlkHtmlFactory::getHtmlText($this->agent_telposte, _t("Poste"), 1, 32, 30);
    $oCtrlTelp->setReadOnly($bReadOnly);
    $oCtrlTelp->addValidator(ALK_VERIF_TEXT);
    
    $oCtrlFax = AlkHtmlFactory::getHtmlText($this->agent_fax, _t("Télécopie"), 1, 32, 30);
    $oCtrlFax->setReadOnly($bReadOnly);
    $oCtrlFax->addValidator(ALK_VERIF_TEXT);

    $oCtrlMobile = AlkHtmlFactory::getHtmlText($this->agent_mobile, _t("Mobile"), 1, 32, 30);
    $oCtrlMobile->setReadOnly($bReadOnly);
    $oCtrlMobile->addValidator(ALK_VERIF_TEXT);

    /** adresse */
    $oCtrlAdr1  = AlkHtmlFactory::getHtmlText($this->adr_adr1, _t("Adresse 1"), 1, $iTxtWidth, 50);
    $oCtrlAdr1->setReadOnly($bReadOnly);
    $oCtrlAdr2  = AlkHtmlFactory::getHtmlText($this->adr_adr2, _t("Adresse 2"), 1, $iTxtWidth, 50);
    $oCtrlAdr2->setReadOnly($bReadOnly);
    $oCtrlAdr3  = AlkHtmlFactory::getHtmlText($this->adr_adr3, _t("Adresse 3"), 1, $iTxtWidth, 50);
    $oCtrlAdr3->setReadOnly($bReadOnly);
    $oCtrlCP    = AlkHtmlFactory::getHtmlText($this->adr_post, _t("Code postal"), 1, $iTxtWidth, 10);
    $oCtrlCP->setReadOnly($bReadOnly);
    $oCtrlVille = AlkHtmlFactory::getHtmlText($this->adr_ville, _t("Ville"), 1, $iTxtWidth, 50);
    $oCtrlVille->setReadOnly($bReadOnly);
    $oCtrlPays = AlkHtmlFactory::getHtmlText($this->adr_pays, _t("Pays"), 1, $iTxtWidth, 50);
    $oCtrlPays->setReadOnly($bReadOnly);

    /** méta données */
    $strHtml = ( $this->agent_datecrea->value != ""
                 ? _f("Créé le %s  par %s", $this->agent_datecrea->value, $this->agent_nomcrea->value)."<br/>".
                 ( $this->agent_datemaj->value != ""
                   ? _f("Modifié le %s par %s", $this->agent_datemaj->value, $this->agent_nommaj->value)."<br/>"
                   : "" )
                 : "" ).
      ( $this->agent_date_valid->value != ""
        ? _f("Compte validé le %s",$this->agent_date_valid->value)."<br/>"
        : "" ).
      ( $this->agent_dateconn->value != ""
        ? _f("Dernière connexion le %s", $this->agent_dateconn->value)."<br/>"
        : "" );
    $oCtrlDate = AlkHtmlFactory::getHtml($strHtml);
    
    /** définition des onglets */
    $oPanelSheet = AlkHtmlFactory::getHtmlPanel("_formUser");
    $this->addPanel($oPanelSheet);
    $oSheetProfil     = $oPanelSheet->addSheet("sheetProfil",   _t("Privilèges et profils"));
    /** param */
    if($this->bOwner || $this->bAdminAll || $this->bAdminServiceForUser) {
      $oSheetParam = $oPanelSheet->addSheet("sheetParam", _f("Paramètres %s",ALK_S_DSIT));
      $oSheetParam->setTemplate("annu", "alkhtmlsheetparam.tpl");
      
      $oBlockParam = $this->getBlockParam($oSheetParam, $this->agent_id->value);
      $oBlockDate =& $oSheetParam->addBlock("blockDate", _t("Méta-information"), "", 10, $iWidthLabelRight+$iWidthCtrlRight-10, false, $this);
      $oBlockDate->addCtrl($oCtrlDate, ALK_HTMLFORM_1L2C);
    } else {
      $oCtrlH->addDataHidden($this->agent_login);
      $oCtrlH->addDataHidden($this->agent_valide);
      $oCtrlH->addDataHidden($this->agent_pwdinit);
      $oCtrlH->addDataHidden($this->cont_id_start);
    }
    $oSheetCoor      = $oPanelSheet->addSheet("sheetCoor",    _t("Coordonnées"));
    $oSheetFiliation = $oPanelSheet->addSheet("sheetServ",    _t("Filiation"));

    $oSheetCoor->setTemplate("annu", "alkhtmlsheetcoor.tpl");
    $oSheetFiliation->setTemplate("annu", "alkhtmlsheetfiliation.tpl");
    $oSheetProfil->setTemplate("annu", "alkhtmlsheetprofil.tpl");

    /** définition des blocs */
    $oBlockIdent =& $this->addBlock("blockIdent", _t("Identité"), "", $iWidthLabelLeft, $iWidthCtrlLeft, true);
    $oBlockIdent->addCtrl($oCtrlH);
    $oBlockIdent->addCtrl($oCtrlCivilite);
    $oBlockIdent->addCtrl($oCtrlNom);
    $oBlockIdent->addCtrl($oCtrlPrenom);
    $oBlockIdent->addCtrl($oCtrlTrigramme);
    $oBlockIdent->addCtrl($oCtrlPhoto);

    $oBlockFonc =& $this->addBlock("blockFonc", _t("Fonction"), "", $iWidthLabelRight, $iWidthCtrlRight, false);
    $oBlockFonc->addCtrl($oCtrlFonc);
    $oBlockFonc->addCtrl($oCtrlDesc);

    $oBlockCoor =& $oSheetCoor->addBlock("blockCoor", _t("Coordonnées"), "", 85, $iWidthCtrlLeft, false, $this);
    $oBlockCoor->addCtrl($oCtrlMail);
    $oBlockCoor->addCtrl($oCtrlTel);
    $oBlockCoor->addCtrl($oCtrlTelp);
    $oBlockCoor->addCtrl($oCtrlFax);
    $oBlockCoor->addCtrl($oCtrlMobile);

    $oBlockAdr =& $oSheetCoor->addBlock("blockAdr", _t("Adresse"), "", 85, $iWidthCtrlLeft, false, $this);
    $oBlockAdr->addCtrl($oCtrlAdr1);
    $oBlockAdr->addCtrl($oCtrlAdr2);
    $oBlockAdr->addCtrl($oCtrlAdr3);
    $oBlockAdr->addCtrl($oCtrlCP);
    $oBlockAdr->addCtrl($oCtrlVille);
    $oBlockAdr->addCtrl($oCtrlPays);

    /** filiation */
    $oBlockFiliation = $this->getBlockFiliation($oSheetFiliation, $this->agent_id->value);

    /** profil et privilège */
    $oBlockPriv = $oSheetProfil->addBlock("blockPriv", _t("Privilèges"), "", 10, 220, false, $this);
    $oBlockPriv->addCtrl($oCtrlPriv, ALK_HTMLFORM_1L1C);
    $oBlockProfil = $this->getBlockProfil($oSheetProfil, $this->agent_id->value);
    
    /** mission */
    if( ALK_B_ANNU_MISSION == true ) {
      $oSheetMission = $oPanelSheet->addSheet("sheetMission", _t("Missions"));
      $oSheetMission->setTemplate("annu", "alkhtmlsheetmission.tpl");
      $oBlockMission = $this->getBlockMission($oSheetMission, $this->agent_id->value);
    }
    
    /** Onglets spécifiques aux applications de l'espace */
    $oSpace = $this->oAppli->getProperty("oSpace", null);
    if ( !is_null($oSpace) && (defined("ALK_B_ATYPE_ACL") && ALK_B_ATYPE_ACL==true))
      $oSpace->callService($this->oAppli->atype_id, "getHtmlAnnuUserForm", $this, $oPanelSheet, $this->agent_id->value);

    $user_id      = AlkFactory::getSProperty("user_id", "-1");
    $userServ_id  = AlkFactory::getSProperty("service_id", "-1");

    $strTokenBack = $this->getTokenBack();
    $strTokenUpdate = $this->getTokenUpdate($strTokenBack);
    $oButton = $this->addButtonPage("btValid", "javascript:ValidUpdate('".$strTokenUpdate."');", _t("Valider"), _t("Valider"));
    $this->addSubmitButton($oButton);

    $strTokenBack2 = ( $user_id == $this->agent_id->value 
                       ? ""
                       : $strTokenBack );
    $oButton = $this->addButtonPage("btCancel", "javascript:CancelUpdate('".$strTokenBack2."')", 
               _t("Annuler"), _t("Annuler les modifications"));
    if ($strTokenBack2=="")
      $this->setResetButton($oButton);

    if( $this->agent_id->value != ALK_USER_ID_ADMINALK &&
        $this->agent_id->value != ALK_USER_ID_INTERNET &&
        $user_id != $this->agent_id->value &&
        ( AlkFactory::isAnnuAdminAll() ||
          AlkFactory::isAnnuAdminServ() && $userServ_id==$this->servNiv1_id ) ) {
      $strTokenDel = $this->getTokenDel();
      $this->addButtonPage("btDel", "javascript:DelUser('".$strTokenDel."', '".addslashes(ALK_S_CAGENT)."')", 
            _t("Supprimer"), _f("Supprimer %s",ALK_S_CAGENT));
    }
  }

  /**
   * Définition du contenu affiché en mode modif pour internet
   * n'affiche que la fiche de l'utilisateur connecté
   */
  public function setContentsUpdateInternet()
  {
    if( !$this->bOwner ) return;
    
    $iSelectWidth = 270;
    $iTxtWidth    = 36;
    $iMemoHeight  = 3;
    $iMemoWidth   = 34;

    $iWidthLabelLeft  = 100;
    $iWidthCtrlLeft   = 280;
    $iWidthLabelRight = 100;
    $iWidthCtrlRight  = 250;

    $this->setLabelDesc(_t("Les champs suivis d'une astérisque (*) sont obligatoires."));
    
    /** identité */
    $oCtrlH = AlkHtmlFactory::getHtmlHidden($this->agent_id);
    $oCtrlH->addDataHidden($this->agent_priv);
    $this->agent_validemem->value = $this->agent_valide->value; 
    $oCtrlH->addDataHidden($this->agent_validemem);
    $this->agent_loginmem->value = $this->agent_login->value; 
    $oCtrlH->addDataHidden($this->agent_loginmem);

    $oCtrlCivilite = AlkHtmlFactory::getHtmlSelect($this->agent_civilite, _t("Civilité"));
    $tabValTxt = array(" "    => "",
                       "Mme"  => _t("Mme"),
                       "Mlle" => _t("Mlle"),
                       "M"    => _t("M"));
    $oCtrlCivilite->setProperty("tabValTxt", $tabValTxt);  
    
    $oCtrlNom = AlkHtmlFactory::getHtmlText($this->agent_nom, _t("Nom"), 1, $iTxtWidth, 100);
    $oCtrlNom->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);    

    $oCtrlPrenom = AlkHtmlFactory::getHtmlText($this->agent_prenom, _t("Prénom"), 1, $iTxtWidth, 40);
    $oCtrlPrenom->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);

    $oCtrlPhoto = AlkHtmlFactory::getHtmlFile($this->agent_photo, _t("Photo (100x75px)"), $iTxtWidth);
    $oCtrlPhoto->setDualMode(true);
    $oCtrlPhoto->setFileUrl($this->oAppli->getUrlUpload(), $this->agent_photo->value);

    /** fonction */
    $oCtrlFonc = AlkHtmlFactory::getHtmlText($this->agent_fonction, _t("Fonction"), 1, $iTxtWidth, 255);
    $oCtrlDesc = AlkHtmlFactory::getHtmlText($this->agent_desc, _t("Description"), $iMemoHeight, $iMemoWidth, 4000);

    /** coordonnées */
    $bReadOnly = !($this->bOwner || $this->bAdminAll || $this->bAdminServiceForUser);
    $oCtrlMail = AlkHtmlFactory::getHtmlText($this->agent_mail, _t("Courriel"), 1, $iTxtWidth, 255);
    $oCtrlMail->setReadOnly($bReadOnly);
    $oCtrlMail->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);

    $oCtrlTel = AlkHtmlFactory::getHtmlText($this->agent_tel, _t("Téléphone"), 1, 32, 30);
    $oCtrlTel->setReadOnly($bReadOnly);
    $oCtrlTel->addValidator(ALK_VERIF_TEXT);
    
    $oCtrlTelp = AlkHtmlFactory::getHtmlText($this->agent_telposte, _t("Poste"), 1, 32, 30);
    $oCtrlTelp->setReadOnly($bReadOnly);
    $oCtrlTelp->addValidator(ALK_VERIF_TEXT);
    
    $oCtrlFax = AlkHtmlFactory::getHtmlText($this->agent_fax, _t("Télécopie"), 1, 32, 30);
    $oCtrlFax->setReadOnly($bReadOnly);
    $oCtrlFax->addValidator(ALK_VERIF_TEXT);

    $oCtrlMobile = AlkHtmlFactory::getHtmlText($this->agent_mobile, _t("Mobile"), 1, 32, 30);
    $oCtrlMobile->setReadOnly($bReadOnly);
    $oCtrlMobile->addValidator(ALK_VERIF_TEXT);

    /** adresse */
    $oCtrlAdr1  = AlkHtmlFactory::getHtmlText($this->adr_adr1, _t("Adresse 1"), 1, $iTxtWidth, 50);
    $oCtrlAdr1->setReadOnly($bReadOnly);
    $oCtrlAdr2  = AlkHtmlFactory::getHtmlText($this->adr_adr2, _t("Adresse 2"), 1, $iTxtWidth, 50);
    $oCtrlAdr2->setReadOnly($bReadOnly);
    $oCtrlAdr3  = AlkHtmlFactory::getHtmlText($this->adr_adr3, _t("Adresse 3"), 1, $iTxtWidth, 50);
    $oCtrlAdr3->setReadOnly($bReadOnly);
    $oCtrlCP    = AlkHtmlFactory::getHtmlText($this->adr_post, _t("Code postal"), 1, $iTxtWidth, 10);
    $oCtrlCP->setReadOnly($bReadOnly);
    $oCtrlVille = AlkHtmlFactory::getHtmlText($this->adr_ville, _t("Ville"), 1, $iTxtWidth, 50);
    $oCtrlVille->setReadOnly($bReadOnly);
    $oCtrlPays = AlkHtmlFactory::getHtmlText($this->adr_pays, _t("Pays"), 1, $iTxtWidth, 50);
    $oCtrlPays->setReadOnly($bReadOnly);
    
    /** paramètres */
    $bCanChangeLogin = ALK_B_ANNU_USER_CHANGE_LOGIN && !$this->bGeneric;

    $oCtrlLogin = AlkHtmlFactory::getHtmlText($this->agent_login, _t("Identifiant"), 1, min($iTxtWidth, ALK_ANNU_LG_MAX_LOGIN), ALK_ANNU_LG_MAX_LOGIN);
    $oCtrlLogin->setMode(($bCanChangeLogin ? 0 : 1));
    //$oCtrlLogin->setReadOnly();
    if( $bCanChangeLogin ) {
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=17&ida=".$this->agent_id->value);
      $oBtUpdateLogin = AlkHtmlFactory::getHtmlButtonForm("javascript:updateLogin('".$strToken."')", _t("Soumettre"), _t("Soumettre pour valider votre proposition"), true);
      $oCtrlLogin->setLabelAfter($oBtUpdateLogin->getHtml());
    }

    $oCtrlPwd   = null;
    $oCtrlPwd2  = null;
    if( !(defined("ALK_B_ANNU_USER_CHANGE_PWD") && ALK_B_ANNU_USER_CHANGE_PWD==false) && !$this->bGeneric ) {
      // l'utilisateur peut modifier son mot de passe
      $this->agent_pwd->value = $this->makeDefaultPwd();
      $oCtrlPwd = AlkHtmlFactory::getHtmlText($this->agent_pwd, _t("Mot de passe"), 1, ALK_ANNU_LG_MAX_PWD+2, 80);
      $oCtrlPwd->AddValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED, ALK_ANNU_LG_MIN_PWD, ALK_ANNU_LG_MAX_PWD);
      $oCtrlPwd->setBPassword(true);
  
      $this->agent_pwd2->value = $this->makeDefaultPwd();
      $oCtrlPwd2 = AlkHtmlFactory::getHtmlText($this->agent_pwd2, _t("Confirmation"), 1, ALK_ANNU_LG_MAX_PWD+2, 80);
      $oCtrlPwd2->AddValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED, ALK_ANNU_LG_MIN_PWD, ALK_ANNU_LG_MAX_PWD);
      $oCtrlPwd2->setBPassword(true);
      $oCtrlPwd->addCtrl($oCtrlPwd2);
    }
    
    /** définition des blocs */
    $oBlockIdent =& $this->addBlock("blockIdent", _t("Identité"), "", $iWidthLabelLeft, $iWidthCtrlLeft, true);
    $oBlockIdent->addCtrl($oCtrlH);
    $oBlockIdent->addCtrl($oCtrlCivilite);
    $oBlockIdent->addCtrl($oCtrlNom);
    $oBlockIdent->addCtrl($oCtrlPrenom);
    $oBlockIdent->addCtrl($oCtrlPhoto);

    $oBlockFonc =& $this->addBlock("blockFonc", _t("Fonction"), "", $iWidthLabelRight, $iWidthCtrlRight, false);
    $oBlockFonc->addCtrl($oCtrlFonc);
    $oBlockFonc->addCtrl($oCtrlDesc);

    $oBlockCoor =& $this->addBlock("blockCoor", _t("Coordonnées"), "", 85, $iWidthCtrlLeft, false);
    $oBlockCoor->addCtrl($oCtrlMail);
    $oBlockCoor->addCtrl($oCtrlTel);
    $oBlockCoor->addCtrl($oCtrlTelp);
    $oBlockCoor->addCtrl($oCtrlFax);
    $oBlockCoor->addCtrl($oCtrlMobile);

    $oBlockAdr =& $this->addBlock("blockAdr", _t("Adresse"), "", 85, $iWidthCtrlLeft, false);
    $oBlockAdr->addCtrl($oCtrlAdr1);
    $oBlockAdr->addCtrl($oCtrlAdr2);
    $oBlockAdr->addCtrl($oCtrlAdr3);
    $oBlockAdr->addCtrl($oCtrlCP);
    $oBlockAdr->addCtrl($oCtrlVille);
    $oBlockAdr->addCtrl($oCtrlPays);    
   
    $oBlockParam =& $this->addBlock("blockParam", _t("Paramètres de connexion"), "", $iWidthLabelRight, $iWidthCtrlRight, false);
    $oBlockParam->addCtrl($oCtrlLogin);
    $oBlockParam->addCtrl($oCtrlPwd);
   
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_MODIFIER, ALK_SHEET_NONE, 
                                        "&iMode=".ALK_FORM_MODE_UPDATE."&agent_id=".$this->agent_id->value."&urlBack=".$_SERVER["REQUEST_URI"]);
    $oButton = $this->addButtonPage("btValid", "javascript:ValidUpdate('".$strToken."');", _t("Valider"), _t("Valider"));
    $this->addSubmitButton($oButton);

    $oButton = $this->addButtonPage("btCancel", "javascript:CancelUpdate('')", _t("Réinitialiser"), _t("Annuler les modifications"));   
    $this->setResetButton($oButton);
    
  }

  /**
   *  Retourne une référence sur le block filiation ajouté à l'onglet de même nom
   * @param oSheetFiliation   Référence sur l'onglet filiation
   * @param agent_id          Identifiant de l'agent à traiter
   * @return AlkHtmlBlock
   */
  private function getBlockFiliation(&$oSheetFiliation, $agent_id)
  {
    $iSelectWidth = 580;

    $oBlockFiliation =& $oSheetFiliation->addBlock("blockServ", _f("Filiation de %s", ALK_S_CAGENT), "", 100, $iSelectWidth+10, false, $this);

    $user_priv   = AlkFactory::getSProperty("user_priv", "0");
    $userServ_id = AlkFactory::getSProperty("service_id", "-1");

    // recherche la liste des services associés à l'agent
    $bAdmin = false;
    $tabServ_id = array(0, -1, -1, -1, -1);
    $dsServ = $this->oAppli->oQuery->getDsListServiceByAgent($agent_id, $user_priv, $userServ_id);
    if( !is_null($dsServ) ) {
      $iNiv = 1;
      while( $drServ = $dsServ->getRowIter() ) {
        $serv_id = $drServ->getValueName("SERVICE_ID");
        $tabServ_id[$iNiv] = $serv_id;
        $iNiv++;
      }
    }

    $serv_id = array();
    $serv_id[0] = new AlkFormData($this, "serv1_id", "-1",  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $serv_id[1] = new AlkFormData($this, "serv2_id", "-1",  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $serv_id[2] = new AlkFormData($this, "serv3_id", "-1",  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $serv_id[3] = new AlkFormData($this, "serv4_id", "-1",  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
  
    $iServPere = "-1";
    $oCtrlService = array();
    for($iNiv=1; $iNiv<=ALK_ANNU_SERV_NIV_MAX; $iNiv++) {
      //service niveau $iNiv
      $servX_id = $tabServ_id[$iNiv];
      $oDataServ = $serv_id[$iNiv-1];
      $oDataServ->value = $servX_id;
      $oCtrlService[$iNiv-1] = AlkHtmlFactory::getHtmlSelect($oDataServ, _f("Service niv. %s", $iNiv), 1, $iSelectWidth, $iSelectWidth);
      $oCtrlService[$iNiv-1]->setProperty("iMode", (($this->bAdminAll || $this->bAdminServiceForUser) ? "0" : "1"));
      $oCtrlService[$iNiv-1]->setReadOnly(!($this->bAdminAll || $this->bAdminServiceForUser)); // bReadOnly non utilisé avec AlkHtmlSelect single-selection
      $oCtrlService[$iNiv-1]->setWriteHiddenOnReadOnly(!($this->bAdminAll || $this->bAdminServiceForUser));
      if( $iNiv==1 && $servX_id==$userServ_id && AlkFactory::isAnnuAdminServ() ) {
        $dsSousService = $this->oAppli->oQuery->getDsListeServiceForCombo($iNiv, $iServPere, true, 65, "", "-2", $servX_id);
      } else {
        $dsSousService = $this->oAppli->oQuery->getDsListeServiceForCombo($iNiv, $iServPere, true, 65);
      }
      if( $iNiv > 1 ) {
        if( $dsSousService->getCountTotDr() > 0 )
          $oCtrlService[$iNiv-1]->setProperty("tabValTxtDefault", array("-1", _f("Sélectionnez un service de niveau %s",$iNiv)));
        else
          $oCtrlService[$iNiv-1]->setProperty("tabValTxtDefault", array("-1", ""));
      } else {
        $oCtrlService[$iNiv-1]->AddEvent("onFocus", "SaveSelectedIndex()");
      }
      $oCtrlService[$iNiv-1]->setProperty("oValTxt", $dsSousService);
      $bAdminServ = ( AlkFactory::isAnnuAdminAll() || AlkFactory::isAnnuAdminServ() && $userServ_id==$serv_id[0]->value );
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_MODIFIER, ALK_SHEET_NONE, "&iMode=10&niv=".$iNiv."&ida=".$agent_id);
      $oCtrlService[$iNiv-1]->AddEvent("onChange", "ChangeService('".$strToken."', ".$iNiv.", ".$agent_id.", ".($bAdminServ ? "true" : "false").")");
      $oBlockFiliation->addCtrl($oCtrlService[$iNiv-1]);
      $iServPere = $servX_id;
    }

    return $oBlockFiliation;  
  }

  /**
   *  Retourne une référence sur le block mission ajouté à l'onglet de même nom
   * @param oSheetMission     Référence sur l'onglet mission
   * @param agent_id          Identifiant de l'agent à traiter
   * @return AlkHtmlBlock
   */
  private function getBlockMission(&$oSheetMission, $agent_id)
  {
    $iSelectWidth = 560;

    $oBlockMission =& $oSheetMission->addBlock("blockMission", _f("Missions de %s",ALK_S_CAGENT), "", 120, $iSelectWidth+10, false, $this);

    if($this->bOwner || $this->bAdminAll || $this->bAdminServiceForUser) {
      $mission_dispo = new AlkFormData($this, "mission_dispo", "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);    
      $oCtrlMS = AlkHtmlFactory::getHtmlSelect($mission_dispo, _t("Missions disponibles"), 1, $iSelectWidth-80);
      $oCtrlMS->setProperty("oValTxt", $this->oAppli->oQuery->getDsListeMissionByAgentForCombo($agent_id, false, true));
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_MODIFIER, ALK_SHEET_NONE, "&iMode=11&ida=".$agent_id);
      $oCtrlMS->addButtonForm("btAddMission", "javascript:addMission('".$strToken."')", _t("Ajouter"), _t("Ajouter la mission sélectionnée"));
      $oCtrlMS->setTemplate("annu", "alkhtmlctrlmissiondispo.tpl");
  
      $agent_mission = new AlkFormData($this, "agent_mission[]", array(), ALK_SQL_NONE);
      $oCtrlMission = AlkHtmlFactory::getHtmlSelect($agent_mission, _t("Missions affectées"), 4, $iSelectWidth-80);
      $oCtrlMission->setProperty("oValTxt", $this->oAppli->oQuery->getDsListeMissionByAgentForCombo($agent_id));
      $oCtrlMission->setProperty("tabValTxtLast", array("-1", ""));
      $oCtrlMission->setProperty("bMultiple", true);
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_MODIFIER, ALK_SHEET_NONE, "&iMode=12&ida=".$agent_id);
      $oCtrlMission->addButtonForm("btDelMission", "javascript:removeMission('".$strToken."')", _t("Supprimer"), _t("Retirer la mission sélectionnée"));
      $oCtrlMission->setTemplate("annu", "alkhtmlctrlmission.tpl");
    
      $oBlockMission->addCtrl($oCtrlMS);
      $oBlockMission->addCtrl($oCtrlMission);
    } else {
      $agent_mission = new AlkFormData($this, "agent_mission[]", array(), ALK_SQL_NONE);
      $oCtrlMission = AlkHtmlFactory::getHtmlSelect($agent_mission, _t("Missions affectées"), 4, $iSelectWidth-80);
      $oCtrlMission->setProperty("oValTxt", $this->oAppli->oQuery->getDsListeMissionByAgentForCombo($agent_id));
      $oCtrlMission->setProperty("tabValTxtLast", array("-1", ""));
      $oCtrlMission->setProperty("bMultiple", true);
      $oCtrlMission->setReadOnly(true);
      $oCtrlMission->setWriteHiddenOnReadOnly(true);
      
      $oBlockMission->addCtrl($oCtrlMission);
    }
    
    return $oBlockMission;
  }  
    
  /**
   *  Retourne une référence sur le block privilège et profil ajouté à l'onglet de même nom
   * @param oSheetProfil       Référence sur l'onglet profil
   * @param agent_id          Identifiant de l'agent à traiter
   * @return AlkHtmlBlock
   */
  private function getBlockProfil(&$oSheetProfil, $agent_id)
  {
    $iSelectWidth = 380;

    $oBlockProfil =& $oSheetProfil->addBlock("blockProfil", _t("Profils généraux"), "", 110, $iSelectWidth+10, false, $this);
    
    $dsProfil = $this->oAppli->oQuery->getDsListProfilForCombo();
    $oCtrlGp1 = AlkHtmlFactory::getHtmlSelect($this->profil_id, _t("Profil principal"), 1);
    $oCtrlGp1->setProperty("oValTxt", $dsProfil);
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_MODIFIER, ALK_SHEET_NONE, "&iMode=13&agent_id=".$agent_id);
    $oCtrlGp1->addEvent("onchange", "onChangePrimaryProfil('".$strToken."')");
    
    $bAdminProfil = //AlkFactory::isSpaceAnimAll() || // inutile, les animateurs n'ont pas accès aux fiches agent en modification
                    $this->bAdminAll
                 || $this->bAdminServiceForUser && !$this->bOwner;  // un administrateur annuaire de service peut administrer les profils (restreint aux siens) mais ne peut pas modifier ses propores profils
    
    $oCtrlGp1->setProperty("iMode", (!$bAdminProfil ? "1" : "0"));
    $oCtrlGp1->setReadOnly(!$bAdminProfil); // bReadOnly non utilisé avec AlkHtmlSelect single-selection
    $oCtrlGp1->setWriteHiddenOnReadOnly(!$bAdminProfil);
    
    $oBlockProfil->addCtrl($oCtrlGp1);
    
    if( $dsProfil->getCountTotDr() > 1 ) { 
      if( $bAdminProfil ) {
        $profil_dispo = new AlkFormData($this, "profil_dispo", "-1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
        $oCtrlGpS = AlkHtmlFactory::getHtmlSelect($profil_dispo, _t("Profils disponibles"), 1, $iSelectWidth-80);
        $oCtrlGpS->setProperty("oValTxt", $this->oAppli->oQuery->getDsListProfilAgentForCombo($agent_id, true, true));
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_MODIFIER, ALK_SHEET_NONE, "&iMode=14&agent_id=".$agent_id);
        $oCtrlGpS->addButtonForm("btAddProfil", "javascript:addSecondaryProfil('".$strToken."')", _t("Ajouter"), _t("Ajouter le profil sélectionné"));
        $oCtrlGpS->setTemplate("annu", "alkhtmlctrlprofildispo.tpl");
    
        $agent_profil  = new AlkFormData($this, "agent_profil[]",  array(), ALK_SQL_NONE);
        $oCtrlGp2 = AlkHtmlFactory::getHtmlSelect($agent_profil, _t("Profils secondaires"), 4, $iSelectWidth-80);
        $oCtrlGp2->setProperty("oValTxt", $this->oAppli->oQuery->getDsListProfilAgentForCombo($agent_id, true, false));
        $oCtrlGp2->setProperty("tabValTxtLast", array("-1", ""));
        //$oCtrlGp2->setProperty("bMultiple", true);  // n'est pas multiple puisque la suppression ne se fait que profil par profil
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_MODIFIER, ALK_SHEET_NONE, "&iMode=15&agent_id=".$agent_id);
        $oCtrlGp2->addButtonForm("btDelProfil", "javascript:removeSecondaryProfil('".$strToken."')", _t("Supprimer"), _t("Retirer le profil sélectionné"));
        $oCtrlGp2->setTemplate("annu", "alkhtmlctrlprofilsecond.tpl");
        
        $oBlockProfil->addCtrl($oCtrlGpS);
        $oBlockProfil->addCtrl($oCtrlGp2);
        
        // désactive les profils non autorisés pour l'utilisateur s'il n'est pas administrateur de tout l'annuaire => ne peut administrer que les profils qu'il possède
        if( !$this->bAdminAll ) {
          $user_id = AlkFactory::getSProperty("user_id", "-1");
          $oDsProfil = $this->oAppli->oQuery->getDsListProfilAgentForCombo($user_id, false, false);
          $tabProfilId = array();
          while( $oDrProfil = $oDsProfil->getRowIter() ) {
            $tabProfilId[] = $oDrProfil->getValueName("PROFIL_ID");
          }
          $this->addOnload("setAuthorizedProfils([".implode(",", $tabProfilId)."])");
        }
      } else {
        $agent_profil  = new AlkFormData($this, "agent_profil[]",  array(), ALK_SQL_NONE);
        $oCtrlGp2 = AlkHtmlFactory::getHtmlSelect($agent_profil, _t("Profils secondaires"), 4, $iSelectWidth-80);
        $oCtrlGp2->setProperty("oValTxt", $this->oAppli->oQuery->getDsListProfilAgentForCombo($agent_id, true, false));
        $oCtrlGp2->setProperty("tabValTxtLast", array("-1", ""));
        // setDisabled(true) est suffisant car les profils secondaires ne sont pas gérés à la soumission du formulaire mais directement en AJAX
//        $oCtrlGp2->setProperty("bMultiple", true);
//        $oCtrlGp2->setReadOnly(true);
//        $oCtrlGp2->setWriteHiddenOnReadOnly(true);
        $oCtrlGp2->setDisabled(true);
        
        $oBlockProfil->addCtrl($oCtrlGp2);
      }
    }    
    return $oBlockProfil;
  }

  /**
   *  Retourne une référence sur le block paramètres ajouté à l'onglet de même nom
   * @param oSheetParam       Référence sur l'onglet param
   * @param agent_id          Identifiant de l'agent à traiter
   * @return AlkHtmlBlock
   */
  private function getBlockParam(&$oSheetParam, $agent_id)
  {
    $user_id     = AlkFactory::getSProperty("user_id", "-1");
    $user_priv   = AlkFactory::getSProperty("user_priv", "0");
    $userServ_id = AlkFactory::getSProperty("service_id", "-1");

    $bCanInitPwd     = ( AlkFactory::isAnnuAdminAll() ||
                         AlkFactory::isAnnuAdminServ() && $userServ_id==$this->servNiv1_id );
    $bCanChangeLogin = ( ALK_B_ANNU_USER_CHANGE_LOGIN==true && $this->bOwner && !$this->bGeneric || $bCanInitPwd );
    $bCanChangeValid = ( AlkFactory::isAnnuAdminAll() || 
                         (AlkFactory::isAnnuAdminServ() && $userServ_id==$this->servNiv1_id)) && !$this->bOwner;

    $iSelectWidth = 270;
    $iTxtWidth    = 36;
    $iMemoHeight  = 3;
    $iMemoWidth   = 34;

    $oBlockParam =& $oSheetParam->addBlock("blockParam", _t("Paramètres de connexion"), "", 100, $iSelectWidth+10, false, $this);

    $oCtrlValid = AlkHtmlFactory::getHtmlSelect($this->agent_valide, _t("Etat du compte"), 1);
    $tabValid = array("0"  => _t("Désactivé"),
                      "1"  => _t("Actif"));


    if( $this->agent_valide->value == "-2" ) {
      $tabValid = array("-2" => _t("En attente d'activation"),
                        "-1" => _t("Réfusé"),
                        "1"  => _t("Activé"));
      $oCtrlValid->setLabelAfter(_t("Saisir le modif de refus dans le champ description plus haut."));
    }
    $oCtrlValid->setProperty("tabValTxt", $tabValid);
    $oCtrlValid->setMode(($bCanChangeValid ? 0 : 1 ));
    
    $oCtrlAdminAuth = AlkHtmlFactory::getHtmlCheckbox($this->agent_adminauth, _t("Connex. autorisée"));
    $oCtrlAdminAuth->setMode(($bCanChangeValid ? 0 : 1 ));

    $oCtrlGeneric = null;
    if ( defined("ALK_B_ANNU_AGENT_GENERIC") && ALK_B_ANNU_AGENT_GENERIC ) {
      $oCtrlGeneric =  AlkHtmlFactory::getHtmlCheckbox($this->agtype_id, _t("Compte de service"));
      $oCtrlGeneric->setMode(($bCanChangeValid ? 0 : 1 ));
    }

    $oCtrlLdap = null;
    if( ALK_LDAP && $bCanChangeLogin ) {
      $oCtrlLdap = AlkHtmlFactory::getHtmlCheckbox($this->agent_ldap, _f("Compte %s", ALK_LDAP_NAME));
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=16&ida=".$agent_id);
      $oBtUpdateLdap = AlkHtmlFactory::getHtmlButtonForm("javascript:updateLdap('".$strToken."')", _t("Mettre à jour"), _f("Mise à jour à partir de l'annuaire %s",ALK_LDAP_NAME), true);
      $oCtrlLdap->setLabelAfter($oBtUpdateLdap->getHtml());
      $oCtrlLdap->setMode($bCanInitPwd ? 0 : 1);
      $oCtrlLdap->setHidden($this->agent_ldap->value=="0" && !$bCanInitPwd);
    }

    if( count($GLOBALS["tabStrLocales"]) > 1 ) {
      $oCtrlLg = AlkHtmlFactory::getHtmlSelect($this->agent_lg, _t("Langue - Pays"),  1, $iSelectWidth);
      $oCtrlLg->addValidator(ALK_VERIF_SELECT+ALK_IS_REQUIRED, "-1");    
      //$oCtrlLg->setProperty("tabValTxtDefault", array("", ""));                                  
      $oCtrlLg->setProperty("tabValTxt", $GLOBALS["tabStrLocales"]);
    } else {
      $tabLocales = array_keys($GLOBALS["tabStrLocales"]);
      $this->agent_lg->value = $tabLocales[0]; 
      $oCtrlLg = AlkHtmlFactory::getHtmlHidden($this->agent_lg);
    }

    $oCtrlLogin = AlkHtmlFactory::getHtmlText($this->agent_login, _t("Identifiant"), 1, min($iTxtWidth, ALK_ANNU_LG_MAX_LOGIN), ALK_ANNU_LG_MAX_LOGIN);
    $oCtrlLogin->setMode(($bCanChangeLogin ? 0 : 1));
    //$oCtrlLogin->setReadOnly();
    if( $bCanChangeLogin ) {
      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_CONSULT, ALK_SHEET_FICHE, ALK_SHEET_NONE, "&iMode=17&ida=".$agent_id);
      $oBtUpdateLogin = AlkHtmlFactory::getHtmlButtonForm("javascript:updateLogin('".$strToken."')", _t("Soumettre"), _t("Soumettre pour valider votre proposition"), true);
      $oCtrlLogin->setLabelAfter($oBtUpdateLogin->getHtml());
    }
    
    $oCtrlPwd   = null;
    $oCtrlPwd2  = null;
    $oCtrlCBPwd = null;
    if( $this->bOwner && !(defined("ALK_B_ANNU_USER_CHANGE_PWD") && ALK_B_ANNU_USER_CHANGE_PWD==false) && !$this->bGeneric ) {
      // l'utilisateur peut modifier son mot de passe
      $this->agent_pwd->value = $this->makeDefaultPwd();
      $oCtrlPwd = AlkHtmlFactory::getHtmlText($this->agent_pwd, _t("Mot de passe"), 1, ALK_ANNU_LG_MAX_PWD+2, 80);
      $oCtrlPwd->AddValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED, ALK_ANNU_LG_MIN_PWD, ALK_ANNU_LG_MAX_PWD);
      $oCtrlPwd->setBPassword(true);

      $this->agent_pwd2->value = $this->makeDefaultPwd();
      $oCtrlPwd2 = AlkHtmlFactory::getHtmlText($this->agent_pwd2, _t("Confirmation"), 1, ALK_ANNU_LG_MAX_PWD+2, 80);
      $oCtrlPwd2->AddValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED, ALK_ANNU_LG_MIN_PWD, ALK_ANNU_LG_MAX_PWD);
      $oCtrlPwd2->setBPassword(true);
      $oCtrlPwd->addCtrl($oCtrlPwd2);
    } 
    elseif( $bCanInitPwd ) {
      $oCtrlCBPwd = AlkHtmlFactory::getHtmlCheckBox($this->agent_pwdinit, _t("Mot de passe"));
      $oCtrlCBPwd->setLabelAfter("("._t("Cocher la case pour générer un nouveau mot de passe envoyé par messagerie après validation").")");
    }

    $oQueryCont = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);

    $oCtrlSpace = AlkHtmlFactory::getHtmlSelect($this->cont_id_start, _t("Espace d'accueil"), 1, $iSelectWidth);
    $oCtrlSpace->setProperty("oValTxt", $oQueryCont->getDsListSpaceByAgentForComboMaj($agent_id));
    $oCtrlSpace->setProperty("tabValTxtDefault", array("0", _t("aucun")));
    $oCtrlSpace->setProperty("iMode", (!($this->bOwner || $bCanInitPwd) ? "1" : "0"));
    $oCtrlSpace->setReadOnly(!($this->bOwner || $bCanInitPwd));
    $oCtrlSpace->setWriteHiddenOnReadOnly(!($this->bOwner || $bCanInitPwd));
    
    $oBlockParam->addCtrl($oCtrlValid);
    $oBlockParam->addCtrl($oCtrlAdminAuth);
    $oBlockParam->addCtrl($oCtrlGeneric);
    $oBlockParam->addCtrl($oCtrlLdap);
    $oBlockParam->addCtrl($oCtrlLg);
    $oBlockParam->addCtrl($oCtrlLogin);
    $oBlockParam->addCtrl($oCtrlPwd);
    $oBlockParam->addCtrl($oCtrlCBPwd);
    $oBlockParam->addCtrl($oCtrlSpace);

    return $oBlockParam;
  }
  
  /**
   * retourne le token d'ajout
   * @return string
   */
  public function getTokenAdd()
  {
    return $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, ALK_SHEET_NONE, "&iMode=".ALK_FORM_MODE_ADD);
  }
  
  /**
   * retourne le token d'envoi de mail
   * @return string
   */
  public function getTokenMail()
  {
    return $this->oAppli->getToken($this->iTypeSheet, $this->iSheet, ALK_SHEET_NONE, "&iMode=18");
  }
  
  /**
   * retourne le token de mise à jour
   * @return string
   */
  public function getTokenUpdate($strTokenBack="")
  {
    $iSheet = AlkRequest::getToken("iSheet", ALK_SHEET_MODIFIER);
    return $this->oAppli->getToken($this->iTypeSheet, $iSheet, ALK_SHEET_NONE, 
                                   "&iMode=".ALK_FORM_MODE_UPDATE."&tokenBack=".$strTokenBack."&agent_id=".$this->agent_id->value);
  }
  
  /**
   * retourne le token de suppression
   * @return string
   */
  public function getTokenDel()
  {
    $iSheet = AlkRequest::getToken("iSheet", ALK_SHEET_MODIFIER);
    return $this->oAppli->getToken($this->iTypeSheet, $iSheet, ALK_SHEET_NONE,
                                   "&agent_id=".$this->agent_id->value."&iMode=".ALK_FORM_MODE_DEL);
  }
  
  /**
   * retourne le token de retour
   * @return string
   */
  public function getTokenBack()
  {
    return $this->oAppli->getToken($this->iTypeSheet, ALK_SHEET_RECHERCHE, ALK_SHEET_NONE);
  }
  
  /**
  * Retourne l'aide associée au formulaire
  * @return string
  */
  public function getHelp()
  {
    if ($this->iSheet == ALK_SHEET_AJOUTER){
      return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_02_agent_add_form.htm"); 
    } else {
      return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_02_agent_maj_form.htm");
    }
  } 
  
}

?>