<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlFormServiceForm
 * 
 * Classe de gestion formulaire d'un service de l'Annuaire
 */
class AlkHtmlFormServiceForm extends AlkHtmlForm 
{
   protected $service_id;               
   protected $service_etat;      
   protected $dept_id;
   protected $responsable;
   protected $agent_id;
   protected $service_ldap;
   protected $service_ldapdn;
   protected $service_ldapuid;
   protected $service_intitule;            
   protected $service_intitule_court;      
   protected $service_pere;                
   protected $service_niveau;             
   protected $service_adresse;             
   protected $service_fax;                 
   protected $service_email; 
   protected $service_tel;              
   protected $service_web;                 
   protected $cont_id_start;
   protected $service_valide;                 
   protected $service_nb_agents;
   protected $service_date_creation;
   protected $service_logo;
   
  /**
   *  constructeur par défaut
   * @param oAppli Référence sur l'application associée 
   */
  public function __construct(AlkAppli $oAppli)
  {
    parent::__construct($oAppli, "formServiceForm"); 
    $iModeForm = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);  
    $this->setProperties($iModeForm, ALK_FORM_METHOD_POST, "");    
  }

  /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   */
  protected function setData($iTypeInit)
  {
    $service_id = AlkRequest::getToken("service_id", AlkRequest::_REQUESTint("service_id", -1));
    $service_pere = AlkRequest::getToken("service_pere", -1);

    $this->service_id             = new AlkFormData($this, "service_id", $service_id,  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->dept_id                = new AlkFormData($this, "dept_id", 0,  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->agent_id               = new AlkFormData($this, "agent_id", "",  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->responsable            = new AlkFormData($this, "responsable", "",  ALK_SQL_NONE);
    if( ALK_LDAP ) {
      $this->service_ldap           = new AlkFormData($this, "service_ldap", 0,  ALK_SQL_NUMBER, ALK_VERIF_CHECK);
      $this->service_ldapdn         = new AlkFormData($this, "service_ldapdn", "",  ALK_SQL_TEXT);
      $this->service_ldapuid        = new AlkFormData($this, "service_ldapuid", "",  ALK_SQL_TEXT);
    }
    $this->service_etat           = new AlkFormData($this, "service_etat", 0,  ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->service_intitule       = new AlkFormData($this, "service_intitule", "", ALK_SQL_TEXT);
    $this->service_intitule_court = new AlkFormData($this, "service_intitule_court", "", ALK_SQL_TEXT);
    $this->service_pere           = new AlkFormData($this, "service_pere", $service_pere, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);    
    $this->service_niveau         = new AlkFormData($this, "service_niveau", 0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->service_adresse        = new AlkFormData($this, "service_adresse", "", ALK_SQL_TEXT);
    $this->service_fax            = new AlkFormData($this, "service_fax", "", ALK_SQL_TEXT);
    $this->service_email          = new AlkFormData($this, "service_email", "", ALK_SQL_TEXT);
    $this->service_tel            = new AlkFormData($this, "service_tel", "", ALK_SQL_TEXT);
    $this->service_web            = new AlkFormData($this, "service_web", "", ALK_SQL_TEXT);
    $this->cont_id_start          = new AlkFormData($this, "cont_id_start", 0, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->service_valide         = new AlkFormData($this, "service_valide", 1, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->service_nb_agents      = $this->oAppli->oQuery->getNombreAgent($service_id);
    $this->service_date_creation  = new AlkFormData($this, "service_date_creation", "", ALK_SQL_NONE);
    $this->service_logo			  = new AlkFormData($this, "service_logo", "", ALK_SQL_TEXT);
    
    $tabData = array(null);
    $oDrData = null;
    $reqMethod = -1;
      if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      $oQuery = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
      $oDsData = $this->oAppli->oQuery->getDs_ficheService($service_id);
      $tabData[] = ( !($oDrData = $oDsData->GetRowIter()) ? null : $oDrData);
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST ){
      $reqMethod = REQ_POST;
    }
    foreach ($tabData as $oDrData){
      $this->initData($iTypeInit, $oDrData, $reqMethod);
    }
  }
  
  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  {
    $this->setData(ALK_INIT_MODE_REQUEST);
    
    $oSpace = $this->oAppli->getProperty("oSpace", null);
    
    switch( $this->iMode ) {
    case ALK_FORM_MODE_ADD:
      $tabQuery = $this->getTabQuery(array(mb_strtoupper($this->service_id->name)));

      $service_id = $this->oAppli->addService($tabQuery);
      $oSpace->callService($this->oAppli->atype_id, "doSqlAnnuServiceForm", $this, $service_id, $tabQuery);
      $service_ldap = ( isset($tabQuery["field"]["SERVICE_LDAP"][1]) 
                        ? $tabQuery["field"]["SERVICE_LDAP"][1] 
                        : "0" );
      if( $service_ldap != "0" ) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_SERVICE, ALK_SHEET_FORM, 
                                            "&service_id=".$service_id."&iMode=".ALK_FORM_MODE_UPDATE);
        return ALK_ALKANET."?token=".$strToken;
      }
      break;
    
    case ALK_FORM_MODE_UPDATE:
      $tabQuery = $this->getTabQuery(array(mb_strtoupper($this->service_id->name)));
      $this->oAppli->updateService($this->service_id->value, $tabQuery);
      $oSpace->callService($this->oAppli->atype_id, "doSqlAnnuServiceForm", $this, $this->service_id->value, $tabQuery);
      break;
    
    case ALK_FORM_MODE_DEL:
      $oSpace->callService($this->oAppli->atype_id, "doSqlAnnuServiceForm", $this, $this->service_id->value, array());
      $this->oAppli->delService($this->service_id->value);
      $this->service_pere->value = AlkRequest::getToken("service_pere", -1);
      break;
      
    case 4:
      $nbAgent = $this->initPwd();
      $strMsg = "";
      if( $nbAgent == 0 ) {
        $strMsg = _f("Aucun %s associé à ce service.", ALK_S_AGENT);
      } elseif( $nbAgent == 1 ) {
        $strMsg = _f("Le mot de passe de %s du service a été réinitialisé.\nIl recevra dans quelques instants son nouveau mot passe par courriel.", ALK_S_LAGENT);
      } else {
        $strMsg = _f("Le mot de passe des %s %s du service ont été réinitialisés.\\n Ils recevront dans quelques instants leur nouveau mot passe par courriel.", $nbAgent, ALK_S_AGENTS);
      }
      echo getBodyOnLoadExec("alkAlert('".$strMsg."')");
      return "";
    }

    $servIdReturn = $this->service_pere->value;
    $dept_id = AlkRequest::getToken("dept_id", "-1"); 
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_SERVICE, ALK_SHEET_LIST, "&dept_id=".$dept_id."&service_id=".$servIdReturn);
    return ALK_ALKANET."?token=".$strToken;
  }  

  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
    $user_priv = AlkFactory::getSProperty("user_priv", "0");

    $this->setData(ALK_INIT_MODE_DATAROW);
  
    // en mode ajout
    if( $this->iMode == ALK_FORM_MODE_ADD ) {
      // collecte les données héritées du service pere
      $dsServ = $this->oAppli->oQuery->GetDs_ficheService($this->service_pere->value);
      if( $drServ = $dsServ->getRowIter() ) {
        $service_niv = $drServ->getValueName("SERVICE_NIVEAU");
        $this->service_niveau->value = $service_niv+1;
        $this->service_etat->value = ( ALK_B_ANNU_SERVICE_ETAT==true
                                       ? $drServ->getValueName("SERVICE_ETAT")
                                       : 1 );
        $this->dept_id->value = $drServ->getValueName("DEPT_ID");
      }
    }

    $iWidthLabel  = 150;
    $iWidthCtrl   = 480;
    $iTxtWidth    = 48;
    $iSelectWidth = 360;
    
    $strParam = "cont_id=".$this->oAppli->cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_SERVICE;
   
    $strTitre = " "._t("d'un nouveau service de base");
    $strLib = " "._t("du service de base");
    
    if( $this->service_niveau->value >0 ) {
      $strTitre = " "._f("d'un nouveau service de niveau %s", $this->service_niveau->value);
      $strLib = " "._f("du service de niveau %s", $this->service_niveau->value);
    }
   
    $strTitle = ( $this->iMode == ALK_FORM_MODE_ADD
                  ? _t("Cr&eacute;ation").$strTitre
                  : _t("Modification").$strLib );
  
    $oCtrlH = AlkHtmlfactory::getHtmlHidden($this->service_id);
    $oCtrlH->addDataHidden($this->service_pere);
    $oCtrlH->addDataHidden($this->agent_id);
   
    $oCtrlIntitule = AlkHtmlfactory::getHtmlText($this->service_intitule, _t("Intitulé du service"), 1, $iTxtWidth, 255);
    $oCtrlIntitule->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
    
    $oCtrlIntituleCrt = AlkHtmlfactory::getHtmlText($this->service_intitule_court, _t("Sigle du service"), 1, $iTxtWidth, 40);
    $oCtrlIntituleCrt->addValidator(ALK_IS_REQUIRED+ALK_VERIF_TEXT);
    $bShow = ( $this->service_niveau->value == 1 );
    $oCtrlIntituleCrt->setHidden(!$bShow);
    
    $dsDept = $this->oAppli->oQuery->getDsListeDptForCombo(!($this->iMode== ALK_FORM_MODE_ADD && $this->service_niveau->value == 1));
    $dsDept->setTree("DEPT_ID", "DEPT_PERE");
    $oCtrlSelectDpt = AlkHtmlFactory::getHtmlSelect ($this->dept_id, _t("Service de"), 1, $iSelectWidth);
    $oCtrlSelectDpt->setProperty("oValTxt", $dsDept);
    $iModeDpt = ( $this->iMode== ALK_FORM_MODE_ADD && $this->service_niveau->value == 1 && $dsDept->getCountTotDr()>0 ? 0 : 1);
    $oCtrlSelectDpt->setMode($iModeDpt);
    if( $iModeDpt==1 ) {
      if( $this->dept_id->value=="0" ) {
        $oCtrlSelectDpt->setHidden(true);
      } else {
        $oCtrlH->addDataHidden($this->dept_id);
      }
    } else {
     $oCtrlSelectDpt->setLabelAfter("<br/><span class='txtWarning bold'>"._t("Ce champ n'est modifiable qu'en création sur un service de niveau 1").".</span>"); 
    }
  
    $oCtrlLdap = null;
    $oCtrlLdapUid = null;
    if( ALK_LDAP ) {
      $oCtrlLdap = AlkHtmlFactory::getHtmlCheckbox($this->service_ldap, _f("Service %s", ALK_LDAP_NAME));
      $oCtrlLdap->addEvent("onClick", "changeLdapStatus(this)");
    
      if( $this->iMode== ALK_FORM_MODE_UPDATE ) {
        $oCtrlLdapDn = AlkHtmlfactory::getHtmlSelect($this->service_ldapdn, _f("Noeuds %s",ALK_LDAP_NAME), 1);
        $oCtrlLdapDn->setDisabled($this->service_ldap->value!="1");
        $dsNode = $this->oAppli->oQuery->getDsLdapListServNode();
        if( $dsNode->isConnected() ) { 
          $tabServDn = array("" => _t("Sélectionnez un noeud de l'annuaire"));
        } else {
          $tabServDn = array($this->service_ldapdn->value => $this->service_ldapdn->value);
        }
        while( $drNode = $dsNode->getRowIter() ) {
          $strNodeValue = $drNode->getValueName("DN");
          $strNodeTxt   = mb_substr($strNodeValue, 0, -mb_strlen(",".ALK_LDAP_BASE_DN_NODE));
          $tabServDn[$strNodeValue] = $strNodeTxt;
        }
        $oCtrlLdapDn->setProperty("tabValTxt", $tabServDn);
        
        $oCtrlLdapUid = AlkHtmlfactory::getHtmlText($this->service_ldapuid, _f("Filtre %s", ALK_LDAP_NAME), 1, $iTxtWidth, 255);
        $oCtrlLdapUid->setDisabled($this->service_ldap->value!="1");
        $strHtmlAfter = ""; 
        
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_IMPORT_USER, ALK_SHEET_NONE, 
                                            "&ids=".$this->service_id->value."&niv=".$this->service_niveau->value);
        $oBtUpdateLdap = AlkHtmlFactory::getHtmlButtonForm("javascript:updateLdap('".$strToken."', '".ALK_LDAP_NAME."')", _t("Synchroniser"), _f("Synchroniser ce service à partir de l'annuaire %s", ALK_LDAP_NAME), true);
        $strHtmlAfter = $oBtUpdateLdap->getHtml();
        
        $oCtrlLdapUid->setLabelAfter($strHtmlAfter);
      } else {
        $oCtrlH->addDataHidden($this->service_ldapdn);
        $oCtrlH->addDataHidden($this->service_ldapuid);
      }
    }
        
    $oCtrlTxta = AlkHtmlfactory::getHtmlText($this->service_adresse, _t("Adresse complète"), 1, $iTxtWidth, 255); 
    
    $oCtrlTxtt = AlkHtmlfactory::getHtmlText($this->service_tel, _t("Téléphone"), 1, 30, 30);
    $oCtrlTxtt->addValidator(ALK_VERIF_TEXTNUM);
    
    $oCtrlTxtf = AlkHtmlfactory::getHtmlText($this->service_fax, _t("Télécopie"), 1, 30, 30);
    $oCtrlTxtf->addValidator(ALK_VERIF_TEXTNUM);
    
    $oCtrlTxtm = AlkHtmlfactory::getHtmlText($this->service_email, _t("Courriel"), 1, $iTxtWidth, 255);
    $oCtrlTxtm->addValidator(ALK_VERIF_MAIL);
  
    $oCtrlTxts = AlkHtmlfactory::getHtmlText($this->service_web, _t("Site Internet"), 1, $iTxtWidth, 255);
    
    $oCtrlChefNom = AlkHtmlFactory::getHtmlText($this->responsable, _t("Responsable"), 1, $iTxtWidth, 255);
    $oCtrlChefNom->setReadOnly(true);
    $strToken = EncodeRequest("cont_id=".$this->oAppli->cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP."&iSheet=".ALK_SHEET_USER_LIST.
                              "&dest=&destId=document.".$this->name.".elements['agent_id']&destTxt=document.".$this->name.".elements['responsable']");
    $oCtrlChefNom->addButtonForm("btAdd", "javascript:changeManager('".$strToken."')", _t("Sélectionner"), _t("Sélectionner un nouveau responsable de service"), true);
    
    $oCtrlCB = AlkHtmlFactory::getHtmlCheckbox($this->service_etat, "Service ".ALK_S_SERV_DTYPEETAT);
    $bReadOnly = !( $this->iMode == ALK_FORM_MODE_ADD && $this->service_niveau->value==1 );
    $bShow = ALK_B_ANNU_SERVICE_ETAT;
    $oCtrlCB->setHidden(!$bShow);
    if( $bReadOnly ) {
      $strTxt = "<input type='hidden' name='service_etat' value='".$this->service_etat->value."'>". 
        ( $this->service_etat->value==1
          ? "<span class='txtAdvice'>"._f("Les %s de ce service sont automatiquement invités aux espaces publics", ALK_S_AGENTS).".</span>"
          : "<span class='txtAdvice'>"._f("Les %s de ce service ne sont pas automatiquement invités aux espaces publics", ALK_S_AGENTS).".</span>");
      $oCtrlCB->setLabelAfter($strTxt);
    } else {
      $oCtrlCB->setLabelAfter("<br/><span class='txtAdvice'><span class='txtWarning bold'>".
                              _t("Attention :")."</span>"._f("A Cocher pour inviter automatiquement les %s de ce service aux espaces publics", ALK_S_AGENTS).".<br/>".
                              "<span class='txtWarning'>"._t("Ce champ n'est modifiable qu'en création sur un service de niveau 1").".</span></span>.");
    }
    $oCtrlCB->setMode(( $bReadOnly ? 1 : 0)); 
    
    $oQueryEspace = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);  
    $oCtrlSelect = AlkHtmlFactory::getHtmlSelect ($this->cont_id_start, _t("Espace de démarrage"), 1, $iSelectWidth);
    $oCtrlSelect->setProperty("oValTxt", $oQueryEspace->GetDs_listeEspaceByServiceForComboMaj());
    $bShow = ALK_B_SPACE_MENTION;
    $oCtrlSelect->setHidden(!$bShow);
    
    $oCtrlValide = AlkHtmlFactory::getHtmlSelect ($this->service_valide, _t("Statut du service"), 1, $iSelectWidth);
    $oCtrlValide->setProperty("tabValTxt", array("0" => _t("inactif"),
                                                 "-2" => _t("en attente d'activation"),
                                                 "1" => _t("actif")));
    $strNombreAgent="<span class='txtAdvice'>".$this->service_nb_agents."</span>";
    $oNombreAgents = AlkHtmlFactory::getHtml($strNombreAgent,_t("Nombre d'agents"),"");
    
    if($this->iMode == ALK_FORM_MODE_ADD){
      $strDateCreation="<span class='txtAdvice'>".date("d/m/Y")."</span>";
    }else{
      $strDateCreation="<span class='txtAdvice'>".$this->service_date_creation->value."</span>";
    }
    
    $oDateCreation = AlkHtmlFactory::getHtml($strDateCreation,_t("Date de création"),"");
    
    $bShow = ALK_B_SPACE_MENTION;
    $oCtrlSelect->setHidden(!$bShow);
    
    $this->addButtons();
    
    /** ajout de blocs et association des controles */
    $oBlockProp = $this->addBlock("block_1", $strTitle, "", $iWidthLabel, $iWidthCtrl, true);
    $oBlockProp->addCtrl($oCtrlIntitule);
    $oBlockProp->addCtrl($oCtrlIntituleCrt);
    $oBlockProp->addCtrl($oCtrlSelectDpt);
    $oBlockProp->addCtrl($oCtrlTxta);
    $oBlockProp->addCtrl($oCtrlTxtt);
    $oBlockProp->addCtrl($oCtrlTxtf);
    $oBlockProp->addCtrl($oCtrlTxtm);
    $oBlockProp->addCtrl($oCtrlTxts);
    $oBlockProp->addCtrl($oCtrlChefNom);
    $oBlockProp->addCtrl($oCtrlCB); 
    $oBlockProp->addCtrl($oCtrlSelect);
    $oBlockProp->addCtrl($oCtrlValide);
    $oBlockProp->addCtrl($oNombreAgents);
    $oBlockProp->addCtrl($oDateCreation);
    /** Elements spécifiques aux applications de l'espace */
    $oSpace = $this->oAppli->getProperty("oSpace", null);
    if ( !is_null($oSpace) && (defined("ALK_B_ATYPE_ACL") && ALK_B_ATYPE_ACL==true))
      $oSpace->callService($this->oAppli->atype_id, "getHtmlAnnuServiceForm", $this, $this, $this->service_id->value);
    
    if( ALK_LDAP ) {
      $tabLdapField = array_keys(unserialize(ALK_LDAP_ASSOC_ANNU));
      $strDesc = ( $this->iMode == ALK_FORM_MODE_UPDATE
                   ? _f("Veuillez sélectionner l'un des noeuds de l'annuaire %s", ALK_LDAP_NAME).",<br/>".
                     _f("puis spécifier la valeur du champ <u>%s</u> correspondant au filtre %s pour la synchronisation", $tabLdapField[1], ALK_LDAP_NAME).".<br/>".
                     _f("La valeur du champ <u>%s</u> est disponible sur les fiches utilisateurs %s", $tabLdapField[1], ALK_LDAP_NAME)
                   : "" );
      $oBlockLdap =  $this->addBlock("block_2", _f("Association avec l'annuaire %s", ALK_LDAP_NAME), $strDesc, $iWidthLabel, $iWidthCtrl);
      if( $this->iMode == ALK_FORM_MODE_ADD ) {
        $oBlockLdap->addCtrl($oCtrlLdap);
      } else {
        $oBlockLdap->addCtrl($oCtrlLdap);
        $oBlockLdap->addCtrl($oCtrlLdapDn);
        $oBlockLdap->addCtrl($oCtrlLdapUid);
      }
    }

    $strTokenInitPwd = $this->oAppli->getToken(ALK_TYPESHEET_ADMIN, ALK_SHEET_SERVICE, ALK_SHEET_FORM, 
                                               "&iMode=4&serv_id=".$this->service_id->value);
    $strDesc = '<div align="center">'.
                '<a title="'._t("En cliquant sur ce lien, vous allez réinitialiser le mot de passe de tous les utilisateurs liés à ce service").
                '" href="javascript:initPwd(\''.$strTokenInitPwd.'\')">'.
                _f("En cliquant sur ce lien, vous allez réinitialiser le mot de passe.%nlde tous les utilisateurs liés à ce service.", "<br/>").'</a></div>'.
                '<div id="layerListResult"></div>';
    $oBlockPwd = $this->addBlock("block_3", _t("Réinitialiser les mots de passe"), "", 5, $iWidthCtrl+$iWidthLabel-5, false);
    
    $oCtrlHtml = AlkHtmlfactory::getHtml($strDesc);
    $oBlockPwd->addCtrl($oCtrlHtml);
    
    $oCtrlLogo = null;
    if( defined("ALK_B_ANNU_SERVICE_LOGO") 
    	&& ALK_B_ANNU_SERVICE_LOGO == TRUE) {
      $oCtrlLogo = AlkHtmlFactory::getHtmlFile($this->service_logo, _f("Image"), $iTxtWidth);
      $oCtrlLogo->setDualMode(true);
      $oCtrlLogo->setFileUrl($this->oAppli->getUrlUpload(), $this->service_logo->value);
    }
    if($oCtrlLogo != null){
      $oBlockLogo = $this->addBlock("block_logo", _t("Personnalisation"), "", 5, $iWidthCtrl+$iWidthLabel-5, false);
      $oBlockLogo->addCtrl($oCtrlLogo);	
    }
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_LIB."lib_formselect.js");
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlformserviceform.js");  
  }
  
  /**
   * Réinitialise les mots de passe de tous les utilisateurs du service sélectionné
   * 
   */
  private function initPwd()
  {
    $nbAgent = 0;
    set_time_limit(600);
    $service_id = AlkRequest::getToken("serv_id", "-1");
    $dsAgent = $this->oAppli->oQuery->getDsListUserByServ($service_id, true, true);
    while( $drAgent = $dsAgent->getRowIter() ) {
      $agent_id        = $drAgent->getValueName("AGENT_ID");
      $agent_nom       = $drAgent->getValueName("AGENT_NOM");
      $agent_prenom    = $drAgent->getValueName("AGENT_PRENOM");
      $agent_mail      = $drAgent->getValueName("AGENT_MAIL");
      $agent_login     = $drAgent->getValueName("AGENT_LOGIN");
      $agent_pwd_clair =  $this->oAppli->oQueryAction->getStrGeneratedPwd();
      $agent_pwd       = AlkFactory::encrypt($agent_pwd_clair);
      $this->oAppli->oQueryAction->updateUserPwd($agent_id, $agent_pwd);
      
      $tabAssoc = array("agent_nom"    => $agent_nom,
                        "agent_prenom" => $agent_prenom,
                        "agent_mail"   => $agent_mail,
                        "agent_login"  => $agent_login,
                        "agent_pwd"    => $agent_pwd_clair); 
      $this->oAppli->SendMailToAgent($tabAssoc, AlkAppliAnnu::ALK_ANNU_MAIL_PCINIT);
      $nbAgent++;
    }
    return $nbAgent;
  }
  
  /**
   * Ajoute les boutons du formulaire
   */
  protected function addButtons()
  {
    $strParam = "cont_id=".$this->oAppli->cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_ADMIN."&iSheet=".ALK_SHEET_SERVICE.
      "&iSSheet=".ALK_SHEET_FORM."&iMode=".$this->iMode."&dept_id=".$this->dept_id->value;
    $this->addValidButton("", ALK_ALKANET_SQL."?token=".AlkRequest::getEncodeParam($strParam), _t("Valider"), _t("Valider le service"));
    $this->addCancelButton(ALK_TYPESHEET_ADMIN, ALK_SHEET_SERVICE, ALK_SHEET_LIST, "&dept_id=".$this->dept_id->value."&service_id=".$this->service_pere->value);
  }
  
  /**
   * Retourne l'aide associée au formulaire
   * @return string
   */
  public function getHelp()
  {
    return $this->readHelp(ALK_ALKANET_ROOT_PATH.ALK_ROOT_MODULE."annu/help/annu_07_service_form.htm"); 
  }   
}
?>