<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/


require_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."form/alkhtmlform.class.php");

/**
 * @package Alkanet_Module_Annu
 * @class AlkHtmlPopupListDiffusion
 * 
 * Classe de gestion d'une liste de diffusion : formulaire et liste d'abonnés 
 */
class AlkHtmlPopupLsDif extends AlkHtmlForm 
{
  /** ctrl du formulaire */
  protected $liste_id;
  protected $liste_intitule;
  protected $liste_desc;
  protected $liste_prive;
  protected $liste_type;
  protected $liste_valide;
  protected $creator_id;

  /** ctrl de la liste */
  //protected $insNom;
  //protected $insPrenom;
  protected $insMail;

  /** identifiant de sous onglet */
  protected $iSSheet;

  /** texte par défaut du champ courriel*/
  protected $defaultMailText;

  /**
   *  construct par défaut
   * @param oAppli référence sur l'application associée
   */  
  public function __construct(AlkAppli $oAppli)
  {   
    parent::__construct($oAppli, "formLsDif");
     
    $iMode = AlkRequest::getToken("iMode", ALK_FORM_MODE_ADD);
    $this->setProperties($iMode, ALK_FORM_METHOD_POST, "");
     
    $this->iSSheet = AlkRequest::getToken("iSSheet", ALK_SHEET_FORM);
    
    $this->defaultMailText = _t("Prénom Nom <Courriel> ou Courriel seul (1 par ligne)");
  }

  /**
   *  Initialise les données (FormData) du formulaire selon un ou plusieurs types d'initialisation
   * @param iTypeInit type de récupération
   */
  protected function setData($iTypeInit) 
  { 
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $user_id  = AlkFactory::getSProperty("user_id", "-1");
    $liste_id = AlkRequest::getToken("liste_id", "-1");
    
    $this->liste_id       = new AlkFormData($this, "liste_id", $liste_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->liste_intitule = new AlkFormData($this, "liste_intitule",  "", ALK_SQL_TEXT,   ALK_VERIF_DEFAULT, true);
    $this->liste_desc     = new AlkFormData($this, "liste_desc",      "", ALK_SQL_TEXT,   ALK_VERIF_DEFAULT, true);
    $this->liste_prive    = new AlkFormData($this, "liste_prive",    "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->liste_type     = new AlkFormData($this, "liste_type",     "0", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->liste_valide   = new AlkFormData($this, "liste_valide",  "1", ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->creator_id     = new AlkFormData($this, "agent_id",  $user_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);
    $this->cont_id        = new AlkFormData($this, "cont_id",  $cont_id, ALK_SQL_NUMBER, ALK_VERIF_NUMERIC);

    //$this->insNom    = new AlkFormData($this, "insNom",    "Nom",      ALK_SQL_TEXT);
    //$this->insPrenom = new AlkFormData($this, "insPrenom", "Prénom",   ALK_SQL_TEXT);
    $this->insMail   = new AlkFormData($this, "insMail", $this->defaultMailText, ALK_SQL_TEXT);
    
    $oDrData = null;
    $reqMethod = -1;
    if ( ($iTypeInit & ALK_INIT_MODE_DATAROW) == ALK_INIT_MODE_DATAROW ) {
      $oDsData = $this->oAppli->oQuery->getDsFicheListe($liste_id);
      if( !($oDrData = $oDsData->GetRowIter()) )
        $oDrData = null;
    }
    if ( ($iTypeInit & ALK_INIT_MODE_REQUEST) == ALK_INIT_MODE_REQUEST )
      $reqMethod = REQ_POST;
    $this->initData($iTypeInit, $oDrData, $reqMethod);
  }
  
  /**
   *  Appel des actions SQL sur les données du formulaire
   */
  public function doSql()
  {
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $this->setData(ALK_INIT_MODE_REQUEST);

    $strUrl = ""; 
    switch( $this->iMode ) {
    case ALK_FORM_MODE_ADD : //ajout
      switch( $this->iSSheet ) {
      case ALK_SHEET_FORM : // Crée la liste de diff
        //fonction de queryaction / sql et renvoieyr une url une action de retour
        $liste_id = $this->oAppli->oQueryAction->addListe($this->liste_intitule->value, $this->liste_desc->value, 
                                                          $this->liste_prive->value, $this->creator_id->value, $this->cont_id->value, -1, 
                                                          $this->liste_type->value, $this->liste_valide->value); 

        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MESLISTES, ALK_SHEET_FORM, 
                                            "&iMode=".ALK_FORM_MODE_UPDATE."&liste_id=".$liste_id."&tokenClose=reload"); 
        $strUrl = ALK_ALKANET."?token=".$strToken;          
        break;

      case ALK_SHEET_LIST : // Maj la liste de diff + Add Abonné local
        $this->oAppli->oQueryAction->addAbonneToListe($this->liste_id->value, $this->insMail->value);
        $this->oAppli->oQueryAction->updateListe($this->liste_id->value, $this->liste_intitule->value, $this->liste_desc->value, 
                                                 $this->liste_prive->value, $this->creator_id->value, $this->cont_id->value,
                                                 $this->liste_type->value, $this->liste_valide->value);
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MESLISTES, ALK_SHEET_LIST, 
                                            "&iMode=".ALK_FORM_MODE_UPDATE."&liste_id=".$this->liste_id->value."&tokenClose=reload"); 
        $strUrl = ALK_ALKANET."?token=".$strToken;
        break;
      }
      break;
   
    case ALK_FORM_MODE_UPDATE : //Modifier
      switch( $this->iSSheet ) {
      case ALK_SHEET_FORM : // Maj la liste de diff
        $this->oAppli->oQueryAction->updateListe($this->liste_id->value, $this->liste_intitule->value, $this->liste_desc->value,
                                                 $this->liste_prive->value, $this->creator_id->value, $this->cont_id->value,
                                                 $this->liste_type->value, $this->liste_valide->value);
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MESLISTES, ALK_SHEET_FORM, 
                                            "&iMode=".ALK_FORM_MODE_UPDATE."&liste_id=".$this->liste_id->value."&tokenClose=reload"); 
        $strUrl = ALK_ALKANET."?token=".$strToken;          
        break;

      case ALK_SHEET_LIST : // Add Abonnés à partir de la sélection multiple annuaire
        $liste_id = AlkRequest::getToken("liste_id", "-1");

        $tabListeAbonneId = AlkRequest::_POST("listUsersId", array());
        $tabListeAbonneId = array_chunk($tabListeAbonneId, 500);
        foreach($tabListeAbonneId as $tabSubListAbonneId) {
          $strListAgentId = ( is_array($tabSubListAbonneId)
                              ? implode(",", array_unique($tabSubListAbonneId))
                              : $tabSubListAbonneId );
          if( $strListAgentId != "" && $strListAgentId != "-1" ) {
            $this->oAppli->oQueryAction->delAddAbonneToListe($this->liste_id->value, $strListAgentId);
          }
        }

        // redirection vers la sélection multiple
        $strUrl = ALK_ALKANET."?token=".$this->getTokenAddUsers($liste_id);
        break;
        
      case ALK_SHEET_AUTORISATION : // Actions sur abonnés sélectionnés
        $iAction = AlkRequest::_GETint("a", "0");
        $tabAbonneId = AlkRequest::_POST("listUserId", array(-1), "is_array");
        $strListAbonneId = implode(",", $tabAbonneId);
        $this->oAppli->oQueryAction->setActionToAbonne($iAction, $strListAbonneId, $this->liste_id->value);
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MESLISTES, ALK_SHEET_LIST,
                                            "&iMode=".ALK_FORM_MODE_UPDATE."&liste_id=".$this->liste_id->value."&tokenClose=reload");
        $strUrl = ALK_ALKANET."?token=".$strToken;
        break;
      }
      break;
      
    case ALK_FORM_MODE_DEL : //effacer
      $liste_id = AlkRequest::getToken("liste_id", "-1");
      switch( $this->iSSheet ) {
      case ALK_SHEET_FORM : // Suppr la liste de diff
        $this->oAppli->delListe($liste_id);
        $strUrl = "";
        echo getBodyOnLoadExec("", "closeWindow('reload')"); 
        break;
        
      case ALK_SHEET_LIST : // Maj la liste de diff + suppression Abonné sélectionné
        $this->oAppli->oQueryAction->updateListe($this->liste_id->value, $this->liste_intitule->value, $this->liste_desc->value, 
                                                 $this->liste_prive->value, $this->creator_id->value, $this->cont_id->value,
                                                 $this->liste_type->value, $this->liste_valide->value);

        // récupération des aglist_id cochés
        $tabListeAbonneId = AlkRequest::_POST("listUserId", array(), "is_array");
        $tabListeAbonneId = array_chunk($tabListeAbonneId, 500);

        // suppression
        foreach($tabListeAbonneId as $tabSubListAbonneId) {
          $strListAbonneId = ( is_array($tabSubListAbonneId)
                               ? implode(",", array_unique($tabSubListAbonneId))
                               : $tabSubListAbonneId );
          if( $strListAbonneId != "" && $strListAbonneId != "-1" ) {
            $this->oAppli->oQueryAction->delAbonnement($strListAbonneId, $this->liste_id->value);
          }
        }
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MESLISTES, ALK_SHEET_LIST, 
                                            "&iMode=".ALK_FORM_MODE_UPDATE."&liste_id=".$liste_id."&tokenClose=reload"); 
        $strUrl = ALK_ALKANET."?token=".$strToken;   
        break;
      }
      break;
    }
    return $strUrl;
  }  
 
  /**
   *  Retourne le titre de la fenêtre popup->value
   * @return string
   */
  public function getTitle()
  {
    return ( $this->iMode==ALK_FORM_MODE_ADD 
             ? _t("Création d'une nouvelle liste") 
             : _t("Modification de la liste") );
  }

  /**
   *  Définition du contenu affiché du formulaire
   */
  protected function setContents()
  {
  	$this->setData(ALK_INIT_MODE_DATAROW);
    
    $this->addScriptJs(ALK_ALKANET_ROOT_URL.ALK_ROOT_MODULE."annu/lib/alkhtmlpopuplsdif.js");
    
    $oHide = AlkHtmlFactory::getHtmlHidden($this->liste_id);
    $oHide->addDataHidden($this->creator_id);
    
    // n'affiche pas les propriétés de la liste pour les listes d'abonnement aux catégories et informations/données
    if ( $this->liste_type->value == 2 ) {
      $oHide->addDataHidden($this->liste_type);
      foreach ( $this->tabLangue as $key => $tabLg ) {
        AlkHtmlFactory::getNewHtmlHidden($this, $this->liste_intitule->name.$tabLg["bdd"], $this->liste_intitule->getValueLanguage());
        AlkHtmlFactory::getNewHtmlHidden($this, $this->liste_desc->name.$tabLg["bdd"], $this->liste_desc->getValueLanguage());
      }
      $oHide->addDataHidden($this->liste_prive);
      $oHide->addDataHidden($this->liste_valide);
      
      $this->addButtonPage("BtA", "javascript:closeWindow()", _t("Fermer"), _t("Fermer la fenêtre"));
       
    } else {
      $liste_prive = $this->liste_prive->value;
      $user_id     = AlkFactory::getSProperty("user_id", "-1"); 
      $user_right  = AlkFactory::getSProperty("user_right", "-1"); 
      
      $iTxtWidth   = 48;
      $iMemoWidth  = 46;
      $iMemoHeight = 4;
      
      $cont_id      = AlkRequest::getToken("cont_id", "-1");
      
      // on vérifie si le user connecté est animateur de l'espace courant
      $bAnimEspace   = false;
      $oQueryEspace  = AlkFactory::getQuery(ALK_ATYPE_ID_ESPACE);
      $dsAnimateurs  = $oQueryEspace->getDs_listeAnimateurByEspaceForCombo($cont_id, false, false);
      while ($drAnim = $dsAnimateurs->getRowIter()){
        if ($user_id == $drAnim->getValueName("id")){
          $bAnimEspace = true;
          break;
        }
      }
      // mode modif pour le créateur ou admin général
      $this->iMode = ( $this->iMode==ALK_FORM_MODE_ADD 
                       || ($this->iMode==ALK_FORM_MODE_UPDATE && $this->creator_id->value == $user_id)
                       || AlkFactory::isSpaceAnimAll() 
                       || ($this->liste_prive->value==0 && $bAnimEspace)
                       ? $this->iMode 
                       : ALK_FORM_MODE_READ );
  
      $this->setLabelDesc(_t("Veuillez renseigner le nom de la liste, éventuellement un descriptif puis valider.").
                          "<br/>".
                          _t("Les champs suivis d'une astérisque (*) sont obligatoires."));
      
      if ( $this->iMode!=ALK_FORM_MODE_ADD )
        $oSheetProp = $this->addSheet("sheetProp", _t("Propriétés de la liste"));
      else
        $oSheetProp = $this;
        
      $oBlockProp = $oSheetProp->addBlock("blockProp", _t("Propriétés de la liste"), "", "120", "390", true);
  
  
      $oCtrlTypeListe = AlkHtmlFactory::getHtmlSelect($this->liste_type, _t("Type"), "1");
      $tabValTxt = array("0" => _t("Liste de diffusion"),
                         "3" => _t("Liste d'abonnement aux lettres d'informations"));
      $oCtrlTypeListe->setProperty("tabValTxt", $tabValTxt);                          
      $oBlockProp->addCtrl($oCtrlTypeListe);
      
      $oCtrlTxt = AlkHtmlFactory::getHtmlText($this->liste_intitule, _t("Intitulé"), 1, $iTxtWidth, 80);
      $oCtrlTxt->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);
      $oBlockProp->addCtrl($oCtrlTxt);
  
      $oCtrlTxt = AlkHtmlFactory::getHtmlText($this->liste_desc, _t("Description"), $iMemoHeight, $iMemoWidth, 4000);
      $oCtrlTxt->addValidator(ALK_VERIF_TEXT);
      $oBlockProp->addCtrl($oCtrlTxt);
     
      $oCtrlSelect = AlkHtmlFactory::getHtmlSelect($this->liste_prive, _t("Portée"), "1");
      
      $oBlockProp->addCtrl($oCtrlSelect);
      if( AlkFactory::isSpaceAnimAll() || $this->iMode==ALK_FORM_MODE_READ ) {
        // admin général
        $tabValTxt = array( "0" => _t("Publique pour cet espace"),
                            "2" => _t("Publique à tous les espaces"),
                            "1" => _t("Privée pour cet espace"),
                            "3" => _t("Privée pour l'ensemble des espaces"));  
      }
      elseif( AlkFactory::isSpaceAnim() ) {
        // animateur espace
        $tabValTxt = array( "0" => _t("Publique pour cet espace"),
                            "1" => _t("Privée pour cet espace"),
                            "3" => _t("Privée pour l'ensemble des espaces"));
      } else {
        // utilisateur
        $tabValTxt = array("1" => _t("Privée pour cet espace"),
                           "3" => _t("Privée pour l'ensemble des espaces"));
      }
      $oCtrlSelect->setProperty("tabValTxt", $tabValTxt);
      
      /* MTO 18/12/2012 : désactivation du champ "visible" car non utilisé dans la gestion de visibilité des listes */
      /*
      $oCtrlCB = AlkHtmlFactory::getHtmlCheckbox($this->liste_valide, _t("Visible"), "1", "0");
      $oBlockProp->addCtrl($oCtrlCB);
      */
      $oHide->addDataHidden($this->liste_valide);
  
      if( $this->iMode!=ALK_FORM_MODE_READ ) {
        $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MESLISTES, ALK_SHEET_FORM, "&iMode=".$this->iMode);     
        $oButton = $this->addButtonPage("BtV", "javascript:Validation('".$strToken."')", _t("Enregistrer"), _t("Valider la fiche")); 
        $this->addSubmitButton($oButton);
        $this->addButtonPage("BtA", "javascript:Annuler()", _t("Fermer"), _t("Annuler et fermer la fenêtre")); 
        
        $strSuppr = "";
        if( $this->iMode == ALK_FORM_MODE_UPDATE &&
            (AlkFactory::isSpaceAnim() ||
             (AlkFactory::isSpaceAnimAll() && $liste_prive!="2") ||
             /*cas utilisateur et */ ($liste_prive=="1" || $liste_prive=="3")) ) {
          $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MESLISTES, ALK_SHEET_FORM, 
                                              "&iMode=".ALK_FORM_MODE_DEL."&liste_id=".$this->liste_id->value);
          $this->addButtonPage("BtS", "javascript:delLsDif('".$strToken."')", _t("Supprimer"), _t("Supprimer cette liste")); 
        }
      }
  
      // En mode ajout on ne gère pas les abonnés donc on sort ici
      if( $this->iMode == ALK_FORM_MODE_ADD ) {
        $this->setTemplate("annu", "alkhtmlpopuplsdifform.tpl");
        return;
      }
      
      if( $this->iSSheet==ALK_SHEET_FORM ) {
        $this->oSheetsManager->setSelectedSheet($oSheetProp);
      }
    }
   
    $oSheetAddon = $this->addSheet("sheetAddon", _t("Abonnés de la liste"));

    $this->setContentsAddons($oSheetAddon);
  }
  
  /**
   *  Défint le contenu de l'onglet Abonnés
   * @see AlkAppliAnnu::CallServiceLsdifGetHtmlAbonnesListe
   */
  protected function setContentsAddons($oSheetAddon)
  {
  	if ( $this->iSSheet==ALK_SHEET_LIST )
      $this->oSheetsManager->setSelectedSheet($oSheetAddon);
    
    if ( $this->liste_type->value != 2 ) {
      $this->setLabelDesc(_t("Vous avez la possibilité de modifier les propriétés de la liste ainsi que de gérer les abonnés en sélectionnant l'un des deux onglets.", "<br/>"));
    }
  
    if( !isset($_SESSION["ALK_LSDIF_ITEMS_PER_PAGE"]) ) {
       $_SESSION["ALK_LSDIF_ITEMS_PER_PAGE"] = ALK_ITEMS_PER_PAGE;
    }
    
    $nbEltParPage = AlkRequest::_GETint("nbItemsPerPage", $_SESSION["ALK_LSDIF_ITEMS_PER_PAGE"]);
    $_SESSION["ALK_LSDIF_ITEMS_PER_PAGE"] = $nbEltParPage; 
    $page         = AlkRequest::_GETint("page", "1");

    $liste_intitule = "";
    $liste_agent_id = "-1";
    $dsListe = $this->oAppli->oQuery->getDsFicheListe($this->liste_id->value);
    if( $drListe = $dsListe->getRowIter() ) {
      $liste_intitule = $drListe->getValueName(AlkFactory::getDBCurrentLanguageField("LISTE_INTITULE"));
      $liste_agent_id = $drListe->getValueName("AGENT_ID");
    }
    
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
    AlkFactory::setSQLParamsName();
    
    if( $nbEltParPage > 0 )
      $this->dsAbonne = $this->oAppli->oQuery->getDsAbonnesByListe($this->liste_id->value, true, ($page-1)*$nbEltParPage, $page*$nbEltParPage-1);
    else {
      $this->dsAbonne = $this->oAppli->oQuery->getDsAbonnesByListe($this->liste_id->value, true);
      $nbEltParPage = $this->dsAbonne->iCountTotDr;
      $page = 1;
    }
    $nbElt = $this->dsAbonne->getCountTotDr();
    
    $output = array();
    /** IMPLEMENTATION DES ELEMENTS UTILES A JQUERY DATATABLE */
      $output = array(
            "sEcho" => AlkFactory::getSQLParamsName("sEcho", ""),
            "iTotalRecords" => $this->dsAbonne->getCountTotDr(),
            "iTotalDisplayRecords" => $this->dsAbonne->getCountTotDr(),
            "aaData" => array()
          );
    AlkFactory::emptySQLParamsName();
    
    $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MESLISTES, ALK_SHEET_LIST, "&iMode=4&liste_id=".$this->liste_id->value);
    $oList = AlkHtmlFactory::getHtmlListJQuery($this, $nbElt, true, ALK_ALKANET."?token=".$strToken);
    $oList->setFilter(true);
    $oList->setModeAjax(true);
                                     
    $oSheetAddon->addPanel($oList);
   
    if( $this->iMode != ALK_FORM_MODE_READ ) {
      $strToken = $this->getTokenAddUsers($this->liste_id->value);
      $oBtAddAll = AlkHtmlFactory::getHtmlButtonPage("javascript:addUsers('".$strToken."')", _t("Ajouter"), _t("Ajouter des abonnés de l'annuaire")); 

      $oCtrlCB = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "iCheckAll", 0, "");
      $oCtrlCB->addEvent("onclick", "SelectAllCB()");
      
      $oCtrlAction = AlkHtmlFactory::getNewHtmlSelect(null, 0, "ctrlAction", -1, "", 1, 45);
      $oCtrlAction->setProperty("tabValTxtDefault", array("-1", "--\\"));
      $oCtrlAction->setProperty("tabValTxt", array("1"  => _t("Activer"),
                                                   "2"  => _t("Désactiver"),
                                                   "3"  => _t("Réactiver"),
                                                   //"4"  => _t("Supprimer"),
                                                   "5"  => _t("Retirer"),
                                             )
      );
      $strTokenCBAction = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MESLISTES, ALK_SHEET_AUTORISATION, "&iMode=".ALK_FORM_MODE_UPDATE."&liste_id=".$this->liste_id->value);
      $oCtrlAction->addEvent("onchange", "onChangeCbAction(this, '".$strTokenCBAction."')");
      
      $oCtrlMail = AlkHtmlFactory::getHtmlText($this->insMail, "", 3, 50);
      $oCtrlMail->AddEvent("onblur",  "initText(this, '".$this->defaultMailText."', false)");
      $oCtrlMail->AddEvent("onfocus", "initText(this, '".$this->defaultMailText."', true)");
      $oCtrlMail->addValidator(ALK_VERIF_TEXT+ALK_IS_REQUIRED);

      $strToken = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MESLISTES, ALK_SHEET_LIST, 
                                          "&iMode=".ALK_FORM_MODE_ADD."&liste_id=".$this->liste_id->value);
      $oCtrlMail->addButtonForm("btAdd1", "javascript:ajouter('".$this->defaultMailText."', '".$strToken."')", 
                                _t("Ajouter"), _t("Ajouter ce nouvel abonné à la liste"), true); 
      $oCtrlCB->addCtrl($oCtrlAction);
    } 
    $strTitleRow = ( $nbElt>0 
                     ? _nf("%s abonné", "%s abonnés", $nbElt)
                     : _t("Aucun abonné" ));

    if( $this->iMode != ALK_FORM_MODE_READ ) {
      $oList->SetColumns(array("left",   "515", "NOM", true, true),
                         array("center", "30", "", false, false),
                         array("center", "120", "", false, false));                              

      $oList->AddTitleRow($strTitleRow, array($oBtAddAll, 2, 1));
      $oList->AddTitleRow(/*$oCtrlNom*/ $oCtrlMail, _t("Etat"), $oCtrlCB);
    } else {
      $oList->SetColumns(array("left",   "615"));
      $oList->AddTitleRow($strTitleRow);
    }
    
    if ($this->iMode == 4)
      $this->readData(true, $oList, $output);
  }
  
  private function readData($bModeAjax=false, &$oList, &$output) {

    while( $drAbonne = $this->dsAbonne->getRowIter() ) {
      $abId     = $drAbonne->getValueName("ABONNE_ID");
      $abNom    = $drAbonne->getValueName("NOM");
      $abPrenom = $drAbonne->getValueName("PRENOM");
      $abMail   = $drAbonne->getValueName("MAIL");
      $idAgent  = $drAbonne->getValueName("AGENT_ID");
      $iValide  = $drAbonne->getValueName("ABONNE_VALIDE");
      $dateDesinsc = $drAbonne->getValueName("ABONNE_DATE_DESINSCR");
      
      $strNom = 
        ( $abMail != "" 
          ? ' <a href="mailto:'.$abMail.'" title="'.$abMail.'">@</a> '
          : "").
        ( $idAgent != "" && $idAgent != ALK_USER_ID_INTERNET
          ? '<a href="javascript:OpenPopupFiche(\'agent\', '.$idAgent.');" title="'._t("Voir la fiche agent")." ".$abNom.'">'
          : '<a href="javascript:OpenPopupFiche(\'abonne\', '.$abId.');" title="'._t("Voir la fiche abonné")." ".$abNom.'">').
        $abNom." ".$abPrenom.
        ( $idAgent != "" ? '</a>' : "");
      
      $strEtat = ( $iValide == "1" 
                   ? '<img class="alkimgicon alkimgiconon" src="'.ALK_ALKANET_ROOT_URL.'media/images/transp.gif" alt="'._t("Activé").'"/>'
                   : ( $iValide == "0" && $dateDesinsc==""
                       ? '<img class="alkimgicon alkimgiconstandby" src="'.ALK_ALKANET_ROOT_URL.'media/images/transp.gif" alt="'._t("En attente d'activation").'"/>'
                       : '<img class="alkimgicon alkimgiconoff" src="'.ALK_ALKANET_ROOT_URL.'media/images/transp.gif" alt="'._t("Désactivé").'"/>' ));
      
      if( $this->iMode != ALK_FORM_MODE_READ ) {
        $oCBUser = AlkHtmlFactory::getNewHtmlCheckbox(null, 0, "listUserId[]", -1, "", $abId);
        $oCBUser = $oCBUser->getHtml();
         if ($bModeAjax)
        $output["aaData"][] = array($strNom, $strEtat, $oCBUser);
      else
        $oList->addRowByArray(array($strNom, $strEtat, $oCBUser));
      } else {
        if ($bModeAjax)
          $output["aaData"][] = array($strNom, $strEtat);
        else
          $oList->addRowByArray(array($strNom, $strEtat));
      }
    } 
    
     if ( $bModeAjax) {
      echo json_encode( $output );
      exit();
    }
  }
  
  /**
   * retourne le token d'ajout d'utilisateurs
   * @param $liste_id identifiant de la liste de diffusion associée
   * @return string token
   */
  protected function getTokenAddUsers($liste_id)
  {
    $cont_id = AlkRequest::getToken("cont_id", "-1");
    $strTokenSave  = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MESLISTES, ALK_SHEET_LIST, 
                                             "&iMode=".ALK_FORM_MODE_UPDATE."&liste_id=".$liste_id);
    $strTokenClose = $this->oAppli->getToken(ALK_TYPESHEET_POPUP, ALK_SHEET_MESLISTES, ALK_SHEET_LIST, 
                                             "&iMode=".ALK_FORM_MODE_UPDATE."&liste_id=".$liste_id."&tokenClose=reload");
    return AlkRequest::getEncodeParam("cont_id=".$cont_id."&appli_id=0&iTypeSheet=".ALK_TYPESHEET_POPUP.
                                      "&iSheet=".ALK_SHEET_USERS_LIST."&iAffAdmin=1&tokenSave=".$strTokenSave.
                                      "&tokenClose=".$strTokenClose.
                                      "&abonne_id_filtre=1".
                                      ( defined("ALK_B_ANNU_LSDIF_SIMPLE_ADD") && ALK_B_ANNU_LSDIF_SIMPLE_ADD==true
                                        ? "&searchNameOnly=1"
                                        : "" ));
  }
}
?>