<?php
/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annuaire
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimport.class.php");
include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimportwarning.class.php");
include_once(ALK_ALKANET_ROOT_PATH.ALK_ROOT_CLASSE."pattern/alkimporterror.class.php");

class AlkImportAbonne extends AlkImport {
  
  /** reference sur l'application */
  protected $oAppli;
  
  /** identifiant d'une liste d'abonnés */
  protected $liste_id;

  /**
   * constructeur par défaut
   * @param oAppli  référence sur l'application
   */
  public function __construct($strFichier_Import,  $tabAlkImportCol, $tabSup, $tabAjout, 
                              $tabModif, &$obj_Erreur,&$objWarning, &$oQuery, &$oQueryAction, &$oSpace , &$oAppli, $liste_id=-1)
  {
    parent::__construct($strFichier_Import,  $tabAlkImportCol, $tabSup, $tabAjout, 
                      $tabModif, $obj_Erreur,$objWarning, $oQuery, $oQueryAction, $oSpace );
    $this->oAppli = $oAppli;  
    $this->liste_id = $liste_id;
  }

 /**
   *  Fonction qui rend un tableaux de champs valeurs.
   *
   * @param tabLigne     Tableau contenant ligne courante
   * @param tabCopy      Tableau contenant l'intersection du  tabImport et de ligne reference   
   * @param tabLigneRef  Tableau contenant la ligne reference
   * @return tabChampsData  un tableau de champs valeurs
   */
  public function getChampsData($tabLigne, $tabCopy, $tabLigneRef, $bUpdate=false)
  {
    if( !$bUpdate ) { 
      // mode ajout
      $tabChampsData = array("ABONNE_ID"      => "-1", 
                             "ABONNE_NOM"     => "",   "ABONNE_PRENOM" => "",   "ABONNE_MAIL"   => "",  "ABONNE_TEL"    => "",
                             "ABONNE_ADRESSE" => "",   "ABONNE_CP"     => "",   "ABONNE_VILLE"  => "",  "ABONNE_CP"     => "", 
                             "ABONNE_VILLE"   => "",   "ABONNE_PAYS"   => "",   "ABONNE_VALIDE" => "0", "ABONNE_PSEUDO" => "",
                             );
    } else {
      // mode modif
      $tabChampsData = array("ABONNE_ID"      => "-2", 
                             "ABONNE_NOM"     => "-2",   "ABONNE_PRENOM" => "-2",   "ABONNE_MAIL"   => "-2", "ABONNE_TEL"    => "-2",
                             "ABONNE_ADRESSE" => "-2",   "ABONNE_CP"     => "-2",   "ABONNE_VILLE"  => "-2", "ABONNE_CP"     => "-2", 
                             "ABONNE_VILLE"   => "-2",   "ABONNE_PAYS"   => "-2",   "ABONNE_VALIDE" => "-2", "ABONNE_PSEUDO" => "-2",
                             );
    }
    
    foreach($tabChampsData as $strKey => $strValue) {
      if( $strKey == "ABONNE_ID" ) {
        if( in_array("CLE",$tabLigneRef) && ($tabLigne[$tabCopy["CLE"]] != "") ) { 
          $tabChampsData["ABONNE_ID"] = $tabLigne[$tabCopy["CLE"]];
        }
      } else {
        if( in_array($strKey, $tabLigneRef) && ($tabLigne[$tabCopy[$strKey]] != "") ) { 
          $tabChampsData[$strKey] = $tabLigne[$tabCopy[$strKey]];
        }
      }
    }
    
    return  $tabChampsData;
  }

  /**
   * Méthode virtuelle effectuant un ajout par rapport à une ligne du fichier d'import
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference
   * @param tabRef   Tableau contenant la ligne reference
   * @param i        numéro de la ligne
   * @return Retourne un entier : 0 si aucune erreur, >0 sinon
   */
  public function insert($tabLigne, $tabCopy, $tabRef=array(), $i=-1) 
  {
    $tabChampsData = $this->getChampsData($tabLigne, $tabCopy, $tabRef);
    
    // on vérifie que le mail n'existe pas
    $dsAbonne = $this->oQuery->getDsAbonneByMail($tabChampsData["ABONNE_MAIL"]);
    if( $dsAbonne->getCountTotDr() >0 ) {
       $strMes = "Erreur : Ligne ".$i.", Le courriel de l'abonné existe déjà. Ligne rejetée.";
       $this->obj_Erreur->erreur(7, $strMes);
       return 2;
    }

    $abonne_id = $this->oQueryAction->addAbonne(ALK_USER_ID_INTERNET, $tabChampsData["ABONNE_NOM"], $tabChampsData["ABONNE_PRENOM"], $tabChampsData["ABONNE_MAIL"], 
                                                $tabChampsData["ABONNE_VALIDE"], $tabChampsData["ABONNE_ADRESSE"], $tabChampsData["ABONNE_CP"],
                                                $tabChampsData["ABONNE_VILLE"], $tabChampsData["ABONNE_PAYS"], $tabChampsData["ABONNE_TEL"],
                                                ""/*$tabChampsData["ABONNE_PWD"]*/, $tabChampsData["ABONNE_PSEUDO"]);

    if( $abonne_id == "-1" ) {
      $strMes = "Erreur : Ligne ".$i.", Impossible d'ajouter l'abonné. Ligne rejetée.";
      $this->obj_Erreur->erreur(7, $strMes);
      return 2;      
    } else if ( $this->liste_id != -1 ) { 
      $this->oQueryAction->addAbonnement($abonne_id, $this->liste_id);
    }
    
    return 0;
  }
    
  /**
   * Méthode virtuelle effectuant une màj par rapport à une ligne du fichier d'import
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference
   * @param tabRef   Tableau contenant la ligne reference
   * @param i        numéro de la ligne
   * @return Retourne un entier : 0 si aucune erreur, >0 sinon
   */
  public function update($tabLigne, $tabCopy, $tabRef=array(), $i=-1) 
  {    
    $tabChampsData = $this->getChampsData($tabLigne, $tabCopy, $tabRef, true);

    // on vérifie que le mail n'existe qu'une seul fois
    $dsAbonne = $this->oQuery->getDsAbonneByIdOrNameOrMail($tabChampsData["ABONNE_ID"], $tabChampsData["ABONNE_NOM"], 
                                                           $tabChampsData["ABONNE_PRENOM"], $tabChampsData["ABONNE_MAIL"]);
    $nbRes = $dsAbonne->getCountTotDr();
    if( $nbRes == 1 && $drAbonne = $dsAbonne->getRowIter() ) {
      $abonne_id = $drAbonne->getValueName("ABONNE_ID");
      $abonne_valide_orig = $drAbonne->getValueName("ABONNE_VALIDE"); 
      
      $tabFields = array();
      foreach($tabChampsData as $strKey=>$strValue) {
        if( $strValue != "-2" ) {
          $tabFields[$strKey] = array(ALK_SQL_TEXT, $strValue);
        }
      }
      //$tabFields["ABONNE_VALIDE"] = ALK_SQL_NUMBER;
      $tabFields["ABONNE_ID"] = ALK_SQL_NUMBER;
      $tabFields["ABONNE_VALIDE_ORIG"] = array(ALK_SQL_NUMBER, $abonne_valide_orig);
      
      $this->oQueryAction->updateAbonne($tabFields, $abonne_id, -1);
      
      if ( $this->liste_id != -1 ) {
        $this->oQueryAction->addAbonnement($abonne_id, $this->liste_id);
      }
      return 0;
    }    

    $strMes = "Erreur : Ligne ".$i.", ".
      ( $nbRes == 0
        ? "enregistrement non trouvé"
        : "plusieurs enregistrements correspondent à cette ligne" ).
      ". Ligne rejetée.";
    $this->obj_Erreur->erreur(7, $strMes);
    return 2;
  }
  
  /**
   * Méthode virtuelle effectuant la suppression par rapport à une ligne du fichier d'import
   *
   * @param tabLigne Tableau contenant ligne courante
   * @param tabCopy  Tableau contenant l'intersection du  tabImport et de ligne reference
   * @param tabRef   Tableau contenant la ligne reference
   * @param i        numéro de la ligne
   * @return Retourne un entier : 0 si aucune erreur, >0 sinon
   */
  public function delete($tabLigne, $tabCopy, $tabRef=array(), $i=-1) 
  { 
    $tabChampsData = $this->getChampsData($tabLigne, $tabCopy, $tabRef);

    $dsAbonne = $this->oQuery->getDsAbonneByIdOrNameOrMail($tabChampsData["ABONNE_ID"], $tabChampsData["ABONNE_NOM"], 
                                                           $tabChampsData["ABONNE_PRENOM"], $tabChampsData["ABONNE_MAIL"], 1);
    $nbRes = $dsAbonne->getCountTotDr();
    if( $nbRes == 1 && $drAbonne = $dsAbonne->getRowIter() ) {
      $abonne_id = $drAbonne->getValueName("ABONNE_ID");
   
      $this->oAppli->delAbonne($abonne_id);
      return 0;
    }

    $strMes = "Erreur : Ligne ".$i.
      ( $nbRes == 0
        ? ", abonné non trouvé. Ligne rejetée."
        : ", plusieurs abonnés trouvés. Ligne rejetée." );
    $this->obj_Erreur->erreur(7, $strMes);
    return 2;
  }
  
}
?>