/*licence/ 

Module écrit, supporté par la société Alkante SAS <alkante@alkante.com>

Nom du module : Alkanet::Module::Annu
Module annuaire Alkanet.
Ce module appartient au framework Alkanet.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site http://www.cecill.info.

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée. Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme, le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard l'attention de l'utilisateur est attirée sur les risques
associés au chargement, à l'utilisation, à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant des connaissances informatiques approfondies. Les
utilisateurs sont donc invités à charger et tester l'adéquation du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.

/licence*/

var nbClickValid = 0;
function ValidAdd(strTokenAdd, strDefaultPwd, bVerifMailUnique, strTokenMail)
{
  var f = document.formUser;
  if( nbClickValid == 0 ) {
    var res = AlkVerifCtrl(f);
    if( res ) {
      
      if ( bVerifMailUnique != null && bVerifMailUnique == true ) {
		    var url = ALK_ALKANET_SQL+'?token='+strTokenMail+"&agent_mail="+f.agent_mail.value;
		    var oAjax = new AlkAjax('verifLoginUseMail', 'fnLoadVerifLoginUseMail', ALK_FORM_METHOD_GET, url, null, false);
		    var iRes = oAjax.getReturnValue();
		    if( iRes == 0 ) {
		      alkAlert("Ce courriel est déjà utilisé par un autre agent en tant que login, veuillez saisir un autre courriel.");
		      return false;
		    }
		  }
      
      // tester la confirmation du mot de passe (si modifié)
      if(f.agent_pwd && f.agent_pwd2) {
        if(f.agent_pwd.value!=f.agent_pwd2.value) {
          AlkAlertMsg(f.agent_pwd, "Les deux mots de passe doivent être identiques.");
          return false;
        }
        if(f.agent_pwd==strDefaultPwd) {
          AlkAlertMsg(f.agent_pwd, "Vous devez saisir un mot de passe différent de celui par défaut.");
          return false;
        }
      }
    
      nbClickValid++;
      f.action = ALK_ALKANET_SQL+"?token="+strTokenAdd;
      return true;
    }
  }
  return false;
}
function ValidUpdate(strToken)
{
  return ValidAdd(strToken);
}

function CancelAdd()
{
  var f = document.formUser;
  f.reset();
}

function CancelUpdate(strTokenBack)
{
  var f = document.formUser;
  if( strTokenBack == "" ) {
    f.reset();
  } else {
    AlkGoUrl(ALK_ALKANET+"?token="+strTokenBack);
  }
}
function DelUser(strToken, strUser)
{
  Confirmation(ALK_ALKANET_SQL+"?token="+strToken,
               "Veuillez confirmer la suppression de ".strUser);
}

var idServ1Selected = -1;
function SaveSelectedIndex()
{
  var f = document.formUser;
  idServ1Selected = f.serv1_id.selectedIndex;
}
function ChangeService(strToken, iNiv, idAgent, bAdminServ)
{
  var f = document.formUser;
  var iReload = 0;

  if( iNiv==1 && bAdminServ ) {
    var res = alkConfirm("Vous êtes sur le point de faire quitter cette personne de votre service.\n"+
                         "Si vous confirmez, vous ne pourrez plus l'administrer. Veuillez confirmer ?");
    if( !res ) {
      // selectionne l'ancienne valeur
      f.serv1_id.selectedIndex = idServ1Selected;
      return;
    } else {
      iReload = 1;
    }
  }

  var id0 = -2;
  var id1 = -1;
  var id2 = -1;
  var id3 = -1;
  var id4 = -1;
  if( f.serv1_id && f.serv1_id.selectedIndex>=0 )
    id1 = f.serv1_id.options[f.serv1_id.selectedIndex].value;
  if( f.serv2_id && f.serv2_id.selectedIndex>=0 )
    id2 = f.serv2_id.options[f.serv2_id.selectedIndex].value;
  if( f.serv3_id && f.serv3_id.selectedIndex>=0 )
    id3 = f.serv3_id.options[f.serv3_id.selectedIndex].value;
  if( f.serv4_id && f.serv4_id.selectedIndex>=0 )
    id4 = f.serv4_id.options[f.serv4_id.selectedIndex].value;

  if( id1 != -1 ) {
    var strParam = "&id0s="+id0+"&id1s="+id1+"&id2s="+id2+"&id3s="+id3+"&id4s="+id4+"&rl="+iReload;
    var oAjax = new AlkAjax('nameSaveServ', 'fnLoadSaveServ', ALK_FORM_METHOD_GET, 
                            ALK_ALKANET_SQL+'?token='+strToken+strParam, null);
  }
}

/**
 * @brief Récupération du contenu des listes
 */
function fnLoadSaveServ(strHtmlContent)
{
  var f = document.formUser;
  var tabCtrlServ = new Array(f.serv1_id, f.serv2_id, f.serv3_id, f.serv4_id);

  // evalue les 4 tableaux tabOptionsServ[1 à 4]
  eval(strHtmlContent);

  for(var i=0; i<tabCtrlServ.length; i++) {
    if( tabCtrlServ[i] && typeof(tabOptionsServ[i]) != "string" ) {
      updateComboFromTabAlkAjax(tabCtrlServ[i], tabOptionsServ[i], true, false);
    }
  }

  // redirection possible si admin serv connecté avec consult
  //  d'une fiche qui n'est plus dans son service
  if( strUrl != "" ) {
    AlkGoUrl(strUrl);
  }
}

/**
 * @brief Récupération du contenu des listes
 */
function fnLoadSaveEnd(strHtmlContent)
{
  var f = document.formUser;
  var oCtrlPd = f.profil_dispo;
  var oCtrlPs = f.elements["agent_profil[]"];
  
  // evalue les 2 tableaux tabOptionsPS et tabOptionsPD
  eval(strHtmlContent);
  
  if( oCtrlPd ) {
    updateComboFromTabAlkAjax(oCtrlPd, tabOptionsPD, true, false)
  }
  if( oCtrlPs ) {
    updateComboFromTabAlkAjax(oCtrlPs, tabOptionsPS, true, true, false, true);
  }
  /** réactive la possibilité de valider le formulaire */
  nbClickValid--;
  setAuthorizedProfils();
}

function onClickPriv(oThis)
{
  var f = document.formUser;
  var oCBAnnuServ = f.agent_privcb_0;
  if( oCBAnnuServ ) {
    var oCBAnnuAll  = f.agent_privcb_1;
    var oCBAnimAll  = f.agent_privcb_2;
    if( oCBAnnuAll == oThis ) {
      oCBAnnuServ.checked = false;
    } else if( oCBAnnuServ == oThis ) {
      oCBAnnuAll.checked = false;
    }
    f.agent_priv.value = ( oCBAnnuServ.checked ? oCBAnnuServ.value*1 : 0 ) +
                         ( oCBAnnuAll.checked  ? oCBAnnuAll.value*1  : 0 ) +
                         ( oCBAnimAll.checked  ? oCBAnimAll.value*1  : 0 );
  } else {
    oCBAnnuServ = f.agent_privcb;
    f.agent_priv.value = ( oCBAnnuServ.checked ? oCBAnnuServ.value*1 : 0 );
  }
}
/**
 * @since version annu 3.5.8 - 20/03/2013
 * désactive les profils non autorisés
 * @param tabAuthorizedProfils    tableau des identifiants des profils autorisés
 *                                   si undefined ou null : récupère le tableau de l'appel précédent
 *                                   si n'est pas un tableau : ne fait rien
 *                                   si vide : désactive tous les profils
 */
var _tabAuthorizedProfils = null;
function setAuthorizedProfils(tabAuthorizedProfils)
{
  if ( typeof tabAuthorizedProfils != 'undefined' && tabAuthorizedProfils != null ) {
    _tabAuthorizedProfils = tabAuthorizedProfils;
  }
  if ( typeof _tabAuthorizedProfils != 'undefined' && _tabAuthorizedProfils != null && isArray(_tabAuthorizedProfils) ) {
    if ( jQuery ) {
      jQuery('#profil_id option, #profil_dispo option, [name="agent_profil[]"] option').each(function(){
        var bAuthorized = false;
        for ( i in _tabAuthorizedProfils ) {
          if ( this.value == _tabAuthorizedProfils[i] ) {
            bAuthorized = true;
            break;
          }
        }
        if ( bAuthorized ) {
          jQuery(this).removeAttr('disabled');
        } else {
          jQuery(this).attr('disabled', 'disabled');
        }
      });
      jQuery('#profil_dispo, [name="agent_profil[]"]').val('');  // désélectionne la valeur dans la liste des profils disponibles et de l'agent pour éviter la sélection d'un profil non autorisé
    } else {
      // TODO...
      
    }
  }
}
function onChangePrimaryProfil(strToken)
{
  var f = document.formUser;
  var oCtrlP = f.profil_id;
  var profil_id = -1;
  if( oCtrlP.selectedIndex > -1 ) {
    profil_id = oCtrlP.options[oCtrlP.selectedIndex].value;
    oCtrlP.value = profil_id;  // force la sélection
  }
  
  if( profil_id != -1 ) {
    strParam = "&idd="+profil_id;
    nbClickValid++;
    var oAjax = new AlkAjax('nameSaveProfil', 'fnLoadSaveProfil', ALK_FORM_METHOD_GET, 
                            ALK_ALKANET_SQL+'?token='+strToken+strParam, null);
  }
}
function fnLoadSaveProfil(strHtmlContent)
{
  var f = document.formUser;
  var oCtrlP = f.profil_id;

  // evalue le profil principal
  eval(strHtmlContent);
  
  if( oCtrlP ) {
    oCtrlP.value = profil_id;
  }
  
  fnLoadSaveEnd(strHtmlContent);
}
function addSecondaryProfil(strToken)
{
  if( nbClickValid > 0 ) return;
  
  var f = document.formUser;
  var oCtrlPd = f.profil_dispo;
  var oCtrlP = f.elements["agent_profil[]"];
  
  if( oCtrlP && oCtrlPd && oCtrlPd.selectedIndex > -1 && oCtrlPd.options[oCtrlPd.selectedIndex].value != "-1" && oCtrlPd.options[oCtrlPd.selectedIndex].value != "" ) {
    nbClickValid++;
    flipDataComboToCombo(ALK_ALKANET_SQL+'?token='+strToken, oCtrlPd, oCtrlP, 'fnLoadSaveEnd', true, false);
  }
}
function removeSecondaryProfil(strToken)
{
  if( nbClickValid > 0 ) return;
  
  var f = document.formUser;
  var oCtrlPd = f.profil_dispo;
  var oCtrlP = f.elements["agent_profil[]"];

  if( oCtrlP && oCtrlPd && oCtrlP.selectedIndex > -1 && oCtrlP.options[oCtrlP.selectedIndex].value != "-1" && oCtrlP.options[oCtrlP.selectedIndex].value != "" ) { 
    nbClickValid++;
    flipDataComboToCombo(ALK_ALKANET_SQL+'?token='+strToken, oCtrlP, oCtrlPd, 'fnLoadSaveEnd', false, true);
  }
}
function addMission(strToken)
{
  var f = document.formUser;
  var oCtrlMd = f.mission_dispo;
  var oCtrlM = f.elements["agent_mission[]"];

  if( oCtrlM && oCtrlMd ) { 
    nbClickValid++; 
    flipDataComboToCombo(ALK_ALKANET_SQL+'?token='+strToken, oCtrlMd, oCtrlM, 'fnLoadSaveEnd', true, false);
   }
}
function removeMission(strToken)
{
  var f = document.formUser;
  var oCtrlMd = f.mission_dispo;
  var oCtrlM = f.elements["agent_mission[]"];

  if( oCtrlM && oCtrlMd ) { 
    nbClickValid++;
    flipDataComboToCombo(ALK_ALKANET_SQL+'?token='+strToken, oCtrlM, oCtrlMd, 'fnLoadSaveEnd', false, true);
  }
}
function updateLdap(strToken)
{
  var f = document.formUser;

  if( f.agent_ldap && f.agent_ldap.type=='checkbox' && !f.agent_ldap.checked ) {
    f.agent_ldap.checked = true;
  }
  var strParam = "&m="+f.agent_mail.value;
  var oAjax = new AlkAjax('nameUpdateLdap', 'fnLoadUpdateLdap', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_SQL+'?token='+strToken+strParam, null);
}
function fnLoadUpdateLdap(strHtmlContent)
{
  var f = document.formUser;
  
  eval(strHtmlContent);
  if( cpt == -2 ) {
    alkAlert("Impossible de se connecter à l'annuaire " + strLdapName);
  } else if( cpt == -1 ) {
    alkAlert("Aucune correspondance dans l'annuaire " + strLdapName);
    if( f.agent_ldap && f.agent_ldap.type=='checkbox' ) {
      f.agent_ldap.checked = false;
    }
  } else if( cpt == 0 ) {
    alkAlert("Aucune mise à jour n'a été effectuée.");
  } else {
    alkAlert("Mise à jour du formulaire effectuée (champs mis en couleur).\n"+
          "Il sera nécessaire de valider la fiche pour enregistrer cette mise à jour.");
  }
}
function updateLogin(strToken)
{
  var f = document.formUser;
  var strParam = "&l="+f.agent_login.value; 
  var oAjax = new AlkAjax('nameUpdateLogin', 'fnLoadUpdateLogin', ALK_FORM_METHOD_GET, 
                          ALK_ALKANET_SQL+'?token='+strToken+strParam, null);
}
function fnLoadUpdateLogin(strHtmlContent)
{
  var f = document.formUser;
  if( f.agent_login.value == strHtmlContent &&  f.agent_login.value!=f.agent_loginmem.value ) {
    alkAlert("Votre proposition a été acceptée et enregistrée.");
  } else if( f.agent_login.value != strHtmlContent ) {
    alkAlert("Votre proposition a été rejetée.\nVeuillez proposer un autre identifiant.");
    f.agent_login.value = f.agent_loginmem.value;
  }
}
